/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.databinding.DataComponentMap;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.fa.basedata.FADepreciationPolicyFactory;
import com.kingdee.eas.fi.fa.basedata.FADepreciationPolicyInfo;
import com.kingdee.eas.fi.fa.basedata.FaCatFactory;
import com.kingdee.eas.fi.fa.basedata.FaCatInfo;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.basedata.FaUseStatusInfo;
import com.kingdee.eas.fi.fa.basedata.FaUtils;
import com.kingdee.eas.fi.fa.basedata.IFADepreciationPolicy;
import com.kingdee.eas.fi.fa.basedata.IFaCat;
import com.kingdee.eas.fi.fa.manage.AbstractFaBillValidatorImpl;
import com.kingdee.eas.fi.fa.manage.AbstractFaCurCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.AbstractFaMonCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.AssistActItemInfo;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.FaCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaCurAsstActCompositCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaCurDepartmentCollection;
import com.kingdee.eas.fi.fa.manage.FaCurFacilityCollection;
import com.kingdee.eas.fi.fa.manage.FaDepartmentInfo;
import com.kingdee.eas.fi.fa.manage.FaFacilityInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaMonAsstActCompositCollection;
import com.kingdee.eas.fi.fa.manage.FaMonCardFactory;
import com.kingdee.eas.fi.fa.manage.FaMonCardInfo;
import com.kingdee.eas.fi.fa.manage.FaMonCostCenterCollection;
import com.kingdee.eas.fi.fa.manage.FaMonCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaMonDepartmentCollection;
import com.kingdee.eas.fi.fa.manage.FaMonFacilityCollection;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.fi.fa.manage.IFaMonCard;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class FaCardWebValidatorImpl
extends AbstractFaBillValidatorImpl {
    private static Logger logger = Logger.getLogger(FaCardWebValidatorImpl.class);
    private boolean hasInit = false;
    private CompanyOrgUnitInfo company;
    private boolean isRelAccount;
    private PeriodInfo currPeriod;
    private HashMap faParams;
    private int periodCount = 12;
    public static final BigDecimal ZERO = new BigDecimal("0");
    public String RESOURCE_PATH = "com.kingdee.eas.fi.fa.manage.FaCardResource";
    private IFaCat iFaCatFactory;
    private String resource = "com.kingdee.eas.fi.fa.manage.FaResource";

    public FaCardWebValidatorImpl(Context ctx, BillBaseInfo billInfo, boolean exitAnyError) {
        super(ctx, billInfo, exitAnyError);
    }

    public FaCardWebValidatorImpl(BillBaseInfo billInfo, DataComponentMap componentMap, boolean exitAnyError) {
        super(billInfo, componentMap, exitAnyError);
    }

    @Override
    public boolean validate() {
        this.reset();
        try {
            if (this.bosType.equals(new FaCurCardInfo().getBOSType().toString())) {
                boolean result = this.verifyCardInfo(false);
                boolean isFromChgBill = false;
                boolean isFromBatchChgBill = false;
                if (this.getParam("fromBillUI") != null) {
                    if (this.getParam("fromBillUI").toString().equals("FaChangeBillEditUI")) {
                        isFromChgBill = true;
                    }
                    if (this.getParam("fromBillUI").toString().equals("FaBatchChangeBillUI")) {
                        isFromBatchChgBill = true;
                    }
                }
                if (!isFromChgBill && !isFromBatchChgBill) {
                    boolean isValidAccountDate = this.verifyAccountDate((FaCurCardInfo)this.billInfo, false);
                    result = result && isValidAccountDate;
                }
                return result;
            }
            if (this.bosType.equals(new FaMonCardInfo().getBOSType().toString())) {
                boolean result = this.verifyCardInfo(true);
                boolean isValidAccountDate = this.verifyAccountDate((FaMonCardInfo)this.billInfo, true);
                result = result && isValidAccountDate;
                return result;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.appendInvalidMsg(null, e.getMessage());
            return false;
        }
        throw new IllegalArgumentException(com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"99_FaCardValidatorImpl"));
    }

    private boolean verifyCardInfo(boolean isInitCard) throws BOSException, EASBizException {
        String keepYearPeriod;
        FaDepreciationModeInfo aFaDepModeInfo;
        BigDecimal addUPDepThisYear;
        BigDecimal useTermCount;
        BigDecimal useYear;
        BigDecimal neatAmount;
        BigDecimal neatValue;
        BigDecimal neatLeftValue;
        BigDecimal exRate;
        String originValZearo;
        BigDecimal amount;
        BigDecimal assetAmt;
        String decValAccRequired;
        boolean importCard;
        CurrencyInfo baseCurrency;
        FaCardInfo card;
        String RESOURCE_PATH;
        block267: {
            IFaMonCard imoncard;
            IFaCurCard icurcard;
            boolean isFromBatchChgBill;
            boolean isFromChgBill;
            block266: {
                this.initiate();
                this.getFaCatFactory();
                RESOURCE_PATH = "com.kingdee.eas.fi.fa.manage.FaCardResource";
                card = (FaCardInfo)this.billInfo;
                if (card.get("checkedStatus") == null) {
                    throw new IllegalArgumentException(com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"100_FaCardValidatorImpl"));
                }
                isFromChgBill = false;
                boolean isFromCombinBill = false;
                boolean isFromSplitBill = false;
                isFromBatchChgBill = false;
                if (this.getParam("fromBillUI") != null) {
                    if (this.getParam("fromBillUI").toString().equals("FaChangeBillEditUI")) {
                        isFromChgBill = true;
                    }
                    if (this.getParam("fromBillUI").toString().equals("FaCombinBillEditUI")) {
                        isFromCombinBill = true;
                    }
                    if (this.getParam("fromBillUI").toString().equals("FaSplitBillEditUI")) {
                        isFromSplitBill = true;
                    }
                    if (this.getParam("fromBillUI").toString().equals("FaBatchChangeBillUI")) {
                        isFromBatchChgBill = true;
                    }
                }
                if (!(isInitCard || isFromChgBill || isFromBatchChgBill || card.getCheckedStatus().getValue() != 2)) {
                    throw new FaCardException(FaCardException.ALREADY_AUDIT);
                }
                icurcard = this.ctx == null ? FaCurCardFactory.getRemoteInstance() : FaCurCardFactory.getLocalInstance(this.ctx);
                imoncard = this.ctx == null ? FaMonCardFactory.getRemoteInstance() : FaMonCardFactory.getLocalInstance(this.ctx);
                baseCurrency = this.company.getBaseCurrency();
                if (baseCurrency == null) {
                    this.appendInvalidMsg(null, FaResUtil.getRes((String)"standardMondeyIsNull", (Locale)this.locale));
                }
                boolean bl = importCard = this.getParam("importCard") != null;
                if (!(isFromCombinBill || isFromChgBill || isFromSplitBill || isFromBatchChgBill || !this.isCheckNumber(card, importCard))) {
                    if (card.getNumber() == null || card.getNumber().trim().length() == 0) {
                        this.appendInvalidMsg("number", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_NumberIsNull", (Locale)this.locale));
                        if (this.exitAnyError) {
                            return false;
                        }
                    } else if (this.getParam("OprtState") == null || OprtState.ADDNEW.equals(this.getParam("OprtState").toString()) || OprtState.EDIT.equals(this.getParam("OprtState").toString())) {
                        try {
                            if (isInitCard) {
                                imoncard.checkNumberDup((IObjectPK)new ObjectUuidPK(card.getId()), (CoreBillBaseInfo)card);
                            } else {
                                icurcard.checkNumberDup((IObjectPK)new ObjectUuidPK(card.getId()), (CoreBillBaseInfo)card);
                            }
                        }
                        catch (Exception e) {
                            String msg = e.getMessage();
                            if (msg.lastIndexOf("\u3002") != -1 && msg.lastIndexOf("\u3002") == msg.length() - 1 || msg.lastIndexOf(".") != -1 && msg.lastIndexOf(".") == msg.length() - 1) {
                                msg = msg.substring(0, msg.length() - 1);
                            }
                            this.appendInvalidMsg("number", msg);
                            if (!this.exitAnyError) break block266;
                            return false;
                        }
                    }
                }
            }
            String useGroupNumber = (String)this.faParams.get("FA_030");
            if (!isFromChgBill && !isFromBatchChgBill && this.isCheckBlocNumber(card, importCard) && "true".equalsIgnoreCase(useGroupNumber) && !importCard) {
                if (card.getGroupNumber() == null || card.getGroupNumber().trim().length() == 0) {
                    this.appendInvalidMsg("groupNumber", ResourceBase.getString((String)RESOURCE_PATH, (String)"groupNumberNotNull", (Locale)this.locale));
                    if (this.exitAnyError) {
                        return false;
                    }
                } else {
                    try {
                        if (isInitCard) {
                            imoncard.checkGroupNumber((CoreBillBaseInfo)card);
                        } else {
                            icurcard.checkGroupNumber((CoreBillBaseInfo)card);
                        }
                    }
                    catch (Exception e) {
                        this.appendInvalidMsg("groupNumber", e.getMessage());
                        if (!this.exitAnyError) break block267;
                        return false;
                    }
                }
            }
        }
        if (card.getAssetName() == null || card.getAssetName().trim().length() == 0) {
            this.appendInvalidMsg("assetName", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_NameIsNull", (Locale)this.locale));
            if (this.exitAnyError) {
                return false;
            }
        }
        if (card.getAccountDate() == null) {
            this.appendInvalidMsg("accountDate", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_AccountDateIsNull", (Locale)this.locale));
            if (this.exitAnyError) {
                return false;
            }
        }
        Object isAllowPassPeriod = this.faParams.get("FA_022");
        if (card.getFiAccountDate() == null && !Boolean.valueOf(isAllowPassPeriod.toString()).booleanValue()) {
            this.appendInvalidMsg("fiAccountDate", FaResUtil.getRes((String)"fiAccountDateIsNull", (Locale)this.locale));
            return false;
        }
        if (this.getParam("verifySubmit") != null && !((Boolean)this.getParam("verifySubmit")).booleanValue()) {
            return this.getInvalidMsg() == null || this.getInvalidMsg().length() == 0;
        }
        if (card.getAssetCat() == null) {
            this.appendInvalidMsg("assetCat", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_FaCatIsNull", (Locale)this.locale));
            if (this.exitAnyError) {
                return false;
            }
        } else {
            if (card.getAssetCat().get("isLeaf") == null) {
                throw new IllegalArgumentException(com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"101_FaCardValidatorImpl"));
            }
            if (!card.getAssetCat().isIsLeaf()) {
                this.appendInvalidMsg("assetCat", FaResUtil.getRes((String)"assetCatIsNotDetailAccount", (Locale)this.locale));
                if (this.exitAnyError) {
                    return false;
                }
            }
        }
        if (card.getMeasureUnit() == null) {
            this.appendInvalidMsg("measureUnit", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_MeasureUnitIsNull", (Locale)this.locale));
            if (this.exitAnyError) {
                return false;
            }
        }
        if (card.getOriginMethod() == null) {
            this.appendInvalidMsg("originMethod", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_AlterModeIsNull", (Locale)this.locale));
            if (this.exitAnyError) {
                return false;
            }
        } else {
            if (card.getOriginMethod().get("isLeaf") == null) {
                throw new IllegalArgumentException(com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"102_FaCardValidatorImpl"));
            }
            if (!card.getOriginMethod().isIsLeaf()) {
                this.appendInvalidMsg("originMethod", FaResUtil.getRes((String)"originMeasureCanOnlyLeaf", (Locale)this.locale));
                if (this.exitAnyError) {
                    return false;
                }
            }
        }
        if (card.getUseStatus() == null) {
            this.appendInvalidMsg("useStatus", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_UseStatusIsNull", (Locale)this.locale));
            if (this.exitAnyError) {
                return false;
            }
        } else {
            if (card.getUseStatus().get("isLeaf") == null) {
                throw new IllegalArgumentException(com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"103_FaCardValidatorImpl"));
            }
            if (!card.getUseStatus().isIsLeaf()) {
                this.appendInvalidMsg("useStatus", FaResUtil.getRes((String)"useStatusCanOnlyLeaf", (Locale)this.locale));
                if (this.exitAnyError) {
                    return false;
                }
            }
        }
        if (card.getEconomicPurp() == null) {
            this.appendInvalidMsg("economicPurp", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_EconomicPurpIsNull", (Locale)this.locale));
            if (this.exitAnyError) {
                return false;
            }
        }
        if (card.getStoreCity() == null) {
            this.appendInvalidMsg("storeCity", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_StoreCityIsNull", (Locale)this.locale));
            if (this.exitAnyError) {
                return false;
            }
        }
        if (card.getDept() == null) {
            this.appendInvalidMsg("dept", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_ManageDepaIsNull", (Locale)this.locale));
            if (this.exitAnyError) {
                return false;
            }
        }
        if (card.getCurrency() == null) {
            this.appendInvalidMsg("currency", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_CurrencyIsNull", (Locale)this.locale));
            if (this.exitAnyError) {
                return false;
            }
        }
        AccountViewInfo aAccountViewInfo = null;
        if (card.getAccountAsset() == null) {
            String faAccRequired = (String)this.faParams.get("FA_013");
            if (faAccRequired == null || faAccRequired.equals("") || new Boolean(faAccRequired).booleanValue()) {
                this.appendInvalidMsg("accountAsset", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_AccountFixedIsNull", (Locale)this.locale));
                if (this.exitAnyError) {
                    return false;
                }
            }
        } else {
            aAccountViewInfo = card.getAccountAsset();
            if (aAccountViewInfo.get("isLeaf") == null) {
                throw new IllegalArgumentException(com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"104_FaCardValidatorImpl"));
            }
            if (!aAccountViewInfo.isIsLeaf()) {
                this.appendInvalidMsg("accountAsset", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_AccountFixedIsNotLeaf", (Locale)this.locale));
                if (this.exitAnyError) {
                    return false;
                }
            }
        }
        if (card.getAccountAccuDepr() != null) {
            aAccountViewInfo = card.getAccountAccuDepr();
            if (aAccountViewInfo.get("isLeaf") == null) {
                throw new IllegalArgumentException(com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"105_FaCardValidatorImpl"));
            }
            if (!aAccountViewInfo.isIsLeaf()) {
                this.appendInvalidMsg("accountAccuDepr", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_AccountDeprIsNotLeaf", (Locale)this.locale));
                if (this.exitAnyError) {
                    return false;
                }
            }
        } else {
            String accuDeprAccRequired = (String)this.faParams.get("FA_014");
            if ("true".equalsIgnoreCase(accuDeprAccRequired)) {
                this.appendInvalidMsg("accountAccuDepr", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_AccountDeprIsNull", (Locale)this.locale));
                if (this.exitAnyError) {
                    return false;
                }
            }
        }
        boolean hasChecked = false;
        BigDecimal addUPDep = card.getAccuDepr();
        String accuDeprAccRequired = (String)this.faParams.get("FA_014");
        if ((accuDeprAccRequired == null || accuDeprAccRequired.equals("") || new Boolean(accuDeprAccRequired).booleanValue()) && addUPDep.compareTo(ZERO) > 0 && card.getAccountAccuDepr() == null && this.isRelAccount) {
            hasChecked = true;
            this.appendInvalidMsg("accountAccuDepr", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_AccountDeprIsNull", (Locale)this.locale));
            if (this.exitAnyError) {
                return false;
            }
        }
        if (card.getAccountDecValue() != null) {
            aAccountViewInfo = card.getAccountDecValue();
            if (aAccountViewInfo.get("isLeaf") == null) {
                throw new IllegalArgumentException(com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"106_FaCardValidatorImpl"));
            }
            if (!aAccountViewInfo.isIsLeaf()) {
                this.appendInvalidMsg("accountDecValue", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_AccountDecPIsNotLeaf", (Locale)this.locale));
                if (this.exitAnyError) {
                    return false;
                }
            }
        } else {
            decValAccRequired = (String)this.faParams.get("FA_015");
            if ("true".equalsIgnoreCase(decValAccRequired)) {
                this.appendInvalidMsg("accountDecValue", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_AccountDecPIsNull", (Locale)this.locale));
                if (this.exitAnyError) {
                    return false;
                }
            }
        }
        if (((decValAccRequired = (String)this.faParams.get("FA_015")) == null || decValAccRequired.equals("") || new Boolean(decValAccRequired).booleanValue()) && card.getAccountDecValue() == null && this.isRelAccount) {
            this.appendInvalidMsg("accountDecValue", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_AccountDecPIsNull", (Locale)this.locale));
            if (this.exitAnyError) {
                return false;
            }
        }
        String propPrefix = isInitCard ? "faMonCostCenter." : "faCurCostCenter.";
        FaDepreciationModeInfo aFaDepreciationModeInfo = card.getDeprMethod();
        if (aFaDepreciationModeInfo != null) {
            if (FaManageUtils.isWorkLoadMethod((FaDepreciationModeInfo)aFaDepreciationModeInfo) && card.getMeasureUnitWL() == null) {
                this.appendInvalidMsg("measureUnitWL", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_LoadMeasureUnitIsNull", (Locale)this.locale));
                if (this.exitAnyError) {
                    return false;
                }
            }
            if (FaManageUtils.isStraightAccountMethod((FaDepreciationModeInfo)aFaDepreciationModeInfo)) {
                if (card.getMonthDepreRate() == null) {
                    this.appendInvalidMsg("monthDepreRate", ResourceBase.getString((String)RESOURCE_PATH, (String)"monthDepreRateNotNull", (Locale)this.locale));
                    if (this.exitAnyError) {
                        return false;
                    }
                } else if (card.getMonthDepreRate().compareTo(ZERO) < 0 || card.getMonthDepreRate().compareTo(new BigDecimal("100")) > 0) {
                    this.appendInvalidMsg("monthDepreRate", ResourceBase.getString((String)RESOURCE_PATH, (String)"monthDepreRateInvalid", (Locale)this.locale));
                    if (this.exitAnyError) {
                        return false;
                    }
                }
            }
            if (!hasChecked && ((accuDeprAccRequired = (String)this.faParams.get("FA_014")) == null || accuDeprAccRequired.equals("") || new Boolean(accuDeprAccRequired).booleanValue()) && card.getAccountAccuDepr() == null && this.isRelAccount) {
                this.appendInvalidMsg("accountAccuDepr", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_AccountDeprIsNull", (Locale)this.locale));
                if (this.exitAnyError) {
                    return false;
                }
            }
        }
        if (card.getAccuDeprAll() != null && card.getAccuDepr() != null && card.getAccuDeprAll().compareTo(card.getAccuDepr()) < 0) {
            this.appendInvalidMsg("accuDeprAll", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_AccuDeprMoreThanAddUPDep", (Locale)this.locale));
            if (this.exitAnyError) {
                return false;
            }
        }
        if ((assetAmt = card.getAssetAmt()) == null || assetAmt.compareTo(ZERO) <= 0) {
            this.appendInvalidMsg("assetAmt", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_AssetAmount", (Locale)this.locale));
            if (this.exitAnyError) {
                return false;
            }
        }
        if (!((amount = card.getOriginAmt()) != null && amount.compareTo(ZERO) > 0 || (originValZearo = (String)this.faParams.get("FA_017")) != null && !originValZearo.equals("") && new Boolean(originValZearo).booleanValue())) {
            this.appendInvalidMsg("originAmt", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_OriginalAmount", (Locale)this.locale));
            if (this.exitAnyError) {
                return false;
            }
        }
        if ((exRate = card.getExRate()) == null || exRate.compareTo(ZERO) <= 0) {
            this.appendInvalidMsg("exRate", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_ExchangeRate", (Locale)this.locale));
            if (this.exitAnyError) {
                return false;
            }
        }
        if (card.getCurrency() != null && baseCurrency != null && exRate != null && card.getCurrency().getId().equals((Object)baseCurrency.getId()) && new BigDecimal("1").compareTo(exRate) != 0) {
            this.appendInvalidMsg("exRate", MessageFormat.format(ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_BaseRateNotEqual1", (Locale)this.locale), baseCurrency.getName()));
        }
        if (this.exitAnyError) {
            return false;
        }
        amount = card.getAssetValue();
        if (amount == null || amount.compareTo(ZERO) <= 0) {
            BigDecimal decPrepare;
            String originValZearo2 = (String)this.faParams.get("FA_017");
            if (originValZearo2 == null || originValZearo2.equals("") || !new Boolean(originValZearo2).booleanValue()) {
                this.appendInvalidMsg("assetValue", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_LocalAmount", (Locale)this.locale));
                if (this.exitAnyError) {
                    return false;
                }
            }
            if ((decPrepare = card.getDecValue()) == null || decPrepare.compareTo(amount) > 0) {
                this.appendInvalidMsg("decValue", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_DecPrepare", (Locale)this.locale));
                if (this.exitAnyError) {
                    return false;
                }
            }
        } else {
            BigDecimal expNeatLeftValue;
            FaCatInfo aFaCatInfo;
            BigDecimal decPrepare = card.getDecValue();
            if (decPrepare == null || decPrepare.compareTo(amount) > 0) {
                this.appendInvalidMsg("decValue", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_DecPrepare", (Locale)this.locale));
                if (this.exitAnyError) {
                    return false;
                }
            }
            if ((aFaCatInfo = card.getAssetCat()) != null && aFaCatInfo.get("calcuByEvaluate") == null) {
                throw new IllegalArgumentException(com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"108_FaCardValidatorImpl"));
            }
            boolean isUseEvaValue = aFaCatInfo != null && aFaCatInfo.isCalcuByEvaluate() && card.getInitEvalValue() != null && card.isIsEvaledBefore();
            BigDecimal originalAmount = isUseEvaValue ? card.getInitEvalValue() : card.getAssetValue();
            BigDecimal temp = (originalAmount = originalAmount == null ? ZERO : originalAmount).subtract(expNeatLeftValue = card.getNeatRemValue()).subtract(decPrepare == null ? ZERO : decPrepare);
            if (addUPDep.compareTo(temp) > 0) {
                String strTemp = isUseEvaValue ? ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_evaValueError", (Locale)this.locale) : ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_AddUPDep_OriginaltAmount_ExpNeatLeftValue", (Locale)this.locale);
                this.appendInvalidMsg("accuDepr", strTemp);
                if (this.exitAnyError) {
                    return false;
                }
            }
        }
        if ((neatLeftValue = card.getNeatRemValue()) != null && neatLeftValue.compareTo(amount) > 0) {
            this.appendInvalidMsg("neatRemValue", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_NeatLeftValue", (Locale)this.locale));
            if (this.exitAnyError) {
                return false;
            }
        }
        if ((neatValue = card.getNeatValue()) != null && neatValue.compareTo(ZERO) < 0) {
            this.appendInvalidMsg("neatValue", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_NeatValue", (Locale)this.locale));
            if (this.exitAnyError) {
                return false;
            }
        }
        if ((neatAmount = card.getNeatAmt()) != null && neatAmount.compareTo(ZERO) < 0) {
            this.appendInvalidMsg("neatAmt", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_NeatAmount", (Locale)this.locale));
            if (this.exitAnyError) {
                return false;
            }
        }
        if (neatLeftValue != null && neatLeftValue.compareTo(neatValue) > 0) {
            this.appendInvalidMsg("neatRemValue", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_LeftValue_NeatValue", (Locale)this.locale));
            if (this.exitAnyError) {
                return false;
            }
        }
        if (!((useYear = card.getUseYears()) != null && useYear.compareTo(ZERO) > 0 || aFaDepreciationModeInfo != null && FaManageUtils.isWorkLoadMethod((FaDepreciationModeInfo)aFaDepreciationModeInfo))) {
            this.appendInvalidMsg("useYears", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_ExpUseYears", (Locale)this.locale));
            if (this.exitAnyError) {
                return false;
            }
        }
        if ((useTermCount = card.getUseTermCount()) == null || useTermCount.compareTo(ZERO) <= 0) {
            String strTemp = ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_ExpUsePeriod1", (Locale)this.locale);
            if (aFaDepreciationModeInfo != null && FaManageUtils.isWorkLoadMethod((FaDepreciationModeInfo)aFaDepreciationModeInfo)) {
                strTemp = ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_ExpUsePeriod2", (Locale)this.locale);
            }
            this.appendInvalidMsg("useTermCount", strTemp);
            if (this.exitAnyError) {
                return false;
            }
        }
        if (!isInitCard) {
            this.checkUseYearsAndNeatLeftValue(card);
        }
        if ((addUPDepThisYear = card.getAccuDeprTYear()) == null || addUPDepThisYear.compareTo(addUPDep) > 0) {
            this.appendInvalidMsg("accuDeprTYear", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_UPDepThisYear", (Locale)this.locale));
            if (this.exitAnyError) {
                return false;
            }
        }
        BigDecimal accudepre = card.getAccuDepr();
        BigDecimal deprTermCount = card.getDeprTermCount();
        if (accudepre.compareTo(ZERO) > 0 && deprTermCount.compareTo(ZERO) <= 0) {
            this.appendInvalidMsg("deprTermCount", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCard_DepCount", (Locale)this.locale));
            if (this.exitAnyError) {
                return false;
            }
        }
        if (deprTermCount.compareTo(ZERO) > 0 && accudepre.compareTo(ZERO) <= 0) {
            this.appendInvalidMsg("accudepre", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCard_DepCountBigThanZERO", (Locale)this.locale));
            if (this.exitAnyError) {
                return false;
            }
        }
        if (card.getAccountDate() != null) {
            Date deliverDate;
            Date leaveFactoryDate;
            Date accountDate = DateTimeUtils.truncateDate((Date)card.getAccountDate());
            if (card.getLevFrDate() != null && DateTimeUtils.dayAfter((Date)(leaveFactoryDate = card.getLevFrDate()), (Date)accountDate)) {
                this.appendInvalidMsg("levFrDate", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_LeaveFactoryDate", (Locale)this.locale));
                if (this.exitAnyError) {
                    return false;
                }
            }
            Date fiAccountDate = card.getFiAccountDate();
            if (accountDate != null && fiAccountDate != null && DateTimeUtils.dayBefore((Date)fiAccountDate, (Date)accountDate)) {
                this.appendInvalidMsg("fiAccountDate", FaResUtil.getRes((String)"fiAccountDateLtAccountDate", (Locale)this.locale));
                if (this.exitAnyError) {
                    return false;
                }
            }
            if (card.getDeliverDate() != null && DateTimeUtils.dayAfter((Date)(deliverDate = card.getDeliverDate()), (Date)accountDate)) {
                this.appendInvalidMsg("deliverDate", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_DeliverDate", (Locale)this.locale));
                if (this.exitAnyError) {
                    return false;
                }
            }
        }
        if (card.getStartUseDate() == null) {
            this.appendInvalidMsg("startUseDate", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_StartDateIsNull", (Locale)this.locale));
            if (this.exitAnyError) {
                return false;
            }
        } else {
            String strTemp;
            Date startDate = card.getStartUseDate();
            String companyId = "";
            companyId = card.getCompany() != null ? card.getCompany().getId().toString() : this.company.getId().toString();
            IParamControl ipc = this.ctx == null ? ParamControlFactory.getRemoteInstance() : ParamControlFactory.getLocalInstance((Context)this.ctx);
            String paramvalue = ipc.getParamValue((IObjectPK)new ObjectUuidPK(companyId), "FA_100");
            EntityViewInfo view = new EntityViewInfo();
            view.getSorter().add(new SorterItemInfo("enddate"));
            PeriodCollection periodLasts = this.ctx == null ? PeriodFactory.getRemoteInstance().getPeriodCollection(view) : PeriodFactory.getLocalInstance((Context)this.ctx).getPeriodCollection(view);
            PeriodInfo periodLastInfo = null;
            if (periodLasts.size() > 0) {
                periodLastInfo = periodLasts.get(periodLasts.size() - 1);
            }
            if (!Boolean.valueOf(paramvalue).booleanValue()) {
                if (DateTimeUtils.dayAfter((Date)startDate, (Date)this.currPeriod.getEndDate())) {
                    strTemp = ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_startDateErr", (Locale)this.locale);
                    strTemp = strTemp + "[" + this.currPeriod.getPeriodYear() + "." + this.currPeriod.getPeriodNumber() + "]";
                    this.appendInvalidMsg("startUseDate", strTemp);
                    if (this.exitAnyError) {
                        return false;
                    }
                }
            } else if (DateTimeUtils.dayAfter((Date)startDate, (Date)periodLastInfo.getEndDate())) {
                strTemp = com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"109_FaCardValidatorImpl");
                strTemp = strTemp + "[" + periodLastInfo.getPeriodYear() + "." + periodLastInfo.getPeriodNumber() + "]";
                this.appendInvalidMsg("startUseDate", strTemp);
                if (this.exitAnyError) {
                    return false;
                }
            }
        }
        if (card.getAssetCat() != null) {
            if (card.getAssetCat().getDepreciationPolicy() == null || card.getAssetCat().getDepreciationPolicy().get("deprRule") == null) {
                IFaCat icat = this.ctx == null ? FaCatFactory.getRemoteInstance() : FaCatFactory.getLocalInstance((Context)this.ctx);
                FaCatInfo _catInfo = (FaCatInfo)icat.getValue("select depreciationPolicy.deprRule,depreciationPolicy.StartDeprTime where id='" + card.getAssetCat().getId() + "'");
                card.getAssetCat().setDepreciationPolicy(_catInfo.getDepreciationPolicy());
            }
            int deprTime = card.getAssetCat().getDepreciationPolicy().getStartDeprTime().getValue();
            boolean isWorkLoad = false;
            if (card.getDeprMethod() != null) {
                isWorkLoad = card.getDeprMethod().isIsWorkload();
            }
            if (deprTime == 2 && !isWorkLoad && card.getDeprMethod() != null && !card.getDeprMethod().isIsWorkload()) {
                String strTemp = com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"110_FaCardValidatorImpl");
                this.appendInvalidMsg("deprMethod", strTemp);
                if (this.exitAnyError) {
                    return false;
                }
            }
            int deprRule = card.getAssetCat().getDepreciationPolicy().getDeprRule().getValue();
            FaUseStatusInfo usestatusInfo = card.getUseStatus();
            if (deprRule == 1 || deprRule == 0 && usestatusInfo != null && usestatusInfo.isIsDepreciation()) {
                if (card.getDeprMethod() == null && !card.getAssetCat().isNotCalDep()) {
                    this.appendInvalidMsg("deprMethod", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_DeprMode_Required", (Locale)this.locale));
                    if (this.exitAnyError) {
                        return false;
                    }
                }
                String isShowEval = (String)this.faParams.get("FA_021");
                if (!importCard && isShowEval != null && Boolean.valueOf(isShowEval).booleanValue() && !FaManageUtils.isWellOnlyMethod((FaDepreciationModeInfo)aFaDepreciationModeInfo) && card.getEvalDeprMode() == null) {
                    this.appendInvalidMsg("evalDeprMode", ResourceBase.getString((String)RESOURCE_PATH, (String)"IsNullEvalInfo4", (Locale)this.locale));
                    if (this.exitAnyError) {
                        return false;
                    }
                }
            }
        }
        if (isInitCard) {
            FaCatInfo aFaCatInfo = card.getAssetCat();
            FaDepreciationModeInfo aFaDeprModeInfo = card.getDeprMethod();
            if (aFaCatInfo != null && aFaDeprModeInfo != null) {
                FADepreciationPolicyInfo deprPolicyInfo = aFaCatInfo.getDepreciationPolicy();
                if (deprPolicyInfo.get("initOldAsset") == null) {
                    ObjectUuidPK policyId = new ObjectUuidPK(deprPolicyInfo.getId());
                    IFADepreciationPolicy ipolicy = this.ctx == null ? FADepreciationPolicyFactory.getRemoteInstance() : FADepreciationPolicyFactory.getLocalInstance((Context)this.ctx);
                    deprPolicyInfo = ipolicy.getFADepreciationPolicyInfo((IObjectPK)policyId);
                }
                if (!deprPolicyInfo.isInitOldAsset() && (FaManageUtils.isTotalYearMethod((FaDepreciationModeInfo)aFaDeprModeInfo) || FaManageUtils.isDoubleSubtractMethod((FaDepreciationModeInfo)aFaDeprModeInfo))) {
                    this.appendInvalidMsg("deprMethod", ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardInitResource.FaCurCardInitEditUI_NotSuportDeprMode", (Locale)this.locale));
                    if (this.exitAnyError) {
                        return false;
                    }
                }
            }
        }
        if (card.getNeatLeftRate() != null && (card.getNeatLeftRate().compareTo(ZERO) < 0 || card.getNeatLeftRate().compareTo(new BigDecimal("100")) > 0)) {
            this.appendInvalidMsg("neatLeftRate", FaResUtil.getRes((String)"neatLeftRateInvalid", (Locale)this.locale));
            if (this.exitAnyError) {
                return false;
            }
        }
        if ("true".equals((String)this.faParams.get("FA_023")) && card.getUseTermCount() != null && card.getUseTermCount().compareTo(ZERO) > 0 && (aFaDepModeInfo = card.getDeprMethod()) != null && !FaManageUtils.isWorkLoadMethod((FaDepreciationModeInfo)aFaDepModeInfo) && (keepYearPeriod = (String)this.faParams.get("FA_023")) != null && Boolean.valueOf(keepYearPeriod).booleanValue() && !this.checkUseTermCount(card.getUseYears(), card.getUseTermCount())) {
            this.appendInvalidMsg("useTermCount", FaResUtil.getRes((String)"useYearPeriodNotMatch", (Locale)this.locale));
            if (this.exitAnyError) {
                return false;
            }
        }
        if (card.getOriginMethod() != null && card.getOriginMethod().getNumber().equals("000")) {
            this.appendInvalidMsg("originMethod", FaResUtil.getRes((String)"cannotSelectChangeInit", (Locale)this.locale));
            if (this.exitAnyError) {
                return false;
            }
        }
        String isShowEvalInfo = (String)this.faParams.get("FA_021");
        if (!importCard && isShowEvalInfo != null && Boolean.valueOf(isShowEvalInfo).booleanValue() && !FaManageUtils.isWellOnlyMethod((FaDepreciationModeInfo)aFaDepreciationModeInfo)) {
            if (card.getEvalReInAccountDate() == null) {
                this.appendInvalidMsg("evalReInAccountDate", FaResUtil.getRes((String)"evalInfo15", (Locale)this.locale));
                if (this.exitAnyError) {
                    return false;
                }
            }
            if (card.getEvalDeprPeriodNum() == null) {
                if (FaUtils.isWorkLoadMethod((FaDepreciationModeInfo)card.getEvalDeprMode())) {
                    this.appendInvalidMsg("evalDeprPeriodNum", FaResUtil.getRes((String)"evalInfo30", (Locale)this.locale));
                } else {
                    this.appendInvalidMsg("evalDeprPeriodNum", FaResUtil.getRes((String)"evalInfo24", (Locale)this.locale));
                }
                if (this.exitAnyError) {
                    return false;
                }
            }
            if (card.getEvalDeprMode() != null && card.getEvalDeprMode().isIsWorkload() && card.getEvalMeasureUnitWL() == null) {
                this.appendInvalidMsg("evalMeasureUnitWL", FaResUtil.getRes((String)"evalInfo22", (Locale)this.locale));
                if (this.exitAnyError) {
                    return false;
                }
            }
            if (card.getEvalTaxLeftPeriod() == null) {
                if (FaUtils.isWorkLoadMethod((FaDepreciationModeInfo)card.getEvalDeprMode())) {
                    this.appendInvalidMsg("evalTaxLeftPeriod", FaResUtil.getRes((String)"evalInfo31", (Locale)this.locale));
                } else {
                    this.appendInvalidMsg("evalTaxLeftPeriod", FaResUtil.getRes((String)"evalInfo25", (Locale)this.locale));
                }
                if (this.exitAnyError) {
                    return false;
                }
            }
            if (card.getEvalDeprMode() != null && card.getEvalDeprMode().getNumber().compareTo("008") == 0 && card.getEvalMonthRate() == null) {
                this.appendInvalidMsg("evalMonthRate", ResourceBase.getString((String)RESOURCE_PATH, (String)"IsNullEvalInfo5", (Locale)this.locale));
                if (this.exitAnyError) {
                    return false;
                }
            }
            if (card.getEvalAddDepr() == null) {
                this.appendInvalidMsg("evalAddDepr", ResourceBase.getString((String)RESOURCE_PATH, (String)"IsNullEvalInfo6", (Locale)this.locale));
                if (this.exitAnyError) {
                    return false;
                }
            }
            if (card.getEvalRemValue() == null) {
                this.appendInvalidMsg("evalRemValue", ResourceBase.getString((String)RESOURCE_PATH, (String)"IsNullEvalInfo7", (Locale)this.locale));
                if (this.exitAnyError) {
                    return false;
                }
            }
            if (card.getEvalYearDepr() == null) {
                this.appendInvalidMsg("evalYearDepr", ResourceBase.getString((String)RESOURCE_PATH, (String)"IsNullEvalInfo8", (Locale)this.locale));
                if (this.exitAnyError) {
                    return false;
                }
            }
            if (card.getEvalDecValue() == null) {
                this.appendInvalidMsg("evalDecValue", ResourceBase.getString((String)RESOURCE_PATH, (String)"IsNullEvalInfo9", (Locale)this.locale));
                if (this.exitAnyError) {
                    return false;
                }
            }
            Date evalReInAccountDate = card.getEvalReInAccountDate();
            if (isInitCard && evalReInAccountDate != null && evalReInAccountDate.compareTo(this.currPeriod.getBeginDate()) >= 0) {
                this.appendInvalidMsg("evalReInAccountDate", ResourceBase.getString((String)RESOURCE_PATH, (String)"evalInfo12", (Locale)this.locale));
                if (this.exitAnyError) {
                    return false;
                }
            }
            if (card.getFiAccountDate() != null) {
                if (evalReInAccountDate != null && card.getFiAccountDate() != null && evalReInAccountDate.before(card.getFiAccountDate())) {
                    this.appendInvalidMsg("evalReInAccountDate", ResourceBase.getString((String)RESOURCE_PATH, (String)"evalInfo14", (Locale)this.locale));
                    if (this.exitAnyError) {
                        return false;
                    }
                }
            } else if (evalReInAccountDate != null && card.getAccountDate() != null && evalReInAccountDate.before(card.getAccountDate())) {
                this.appendInvalidMsg("evalReInAccountDate", ResourceBase.getString((String)RESOURCE_PATH, (String)"evalInfo15", (Locale)this.locale));
                if (this.exitAnyError) {
                    return false;
                }
            }
            if (card.getEvalAddDepr() != null && card.getEvalAssetValue() != null && card.getEvalAddDepr().compareTo(card.getEvalAssetValue()) > 0) {
                this.appendInvalidMsg("evalAddDepr", ResourceBase.getString((String)RESOURCE_PATH, (String)"evalInfo4", (Locale)this.locale));
                if (this.exitAnyError) {
                    return false;
                }
            }
            if (card.getEvalAddDepr() != null && card.getEvalAssetValue() != null && card.getEvalDecValue() != null && card.getEvalAddDepr().add(card.getEvalDecValue()).compareTo(card.getEvalAssetValue()) > 0) {
                this.appendInvalidMsg("evalAddDepr", ResourceBase.getString((String)RESOURCE_PATH, (String)"evalInfo5", (Locale)this.locale));
                if (this.exitAnyError) {
                    return false;
                }
            }
            if (card.getEvalAddDepr() != null && card.getEvalYearDepr() != null && card.getEvalAddDepr().compareTo(card.getEvalYearDepr()) < 0) {
                this.appendInvalidMsg("evalYearDepr", FaResUtil.getRes((String)"evalInfo19", (Locale)this.locale));
                if (this.exitAnyError) {
                    return false;
                }
            }
            if (card.getEvalUseTermCount() == null) {
                if (FaUtils.isWorkLoadMethod((FaDepreciationModeInfo)card.getEvalDeprMode())) {
                    this.appendInvalidMsg("evalUseTermCount", FaResUtil.getRes((String)"evalInfo32", (Locale)this.locale));
                } else {
                    this.appendInvalidMsg("evalUseTermCount", FaResUtil.getRes((String)"evalInfo26", (Locale)this.locale));
                }
                if (this.exitAnyError) {
                    return false;
                }
            }
            if (card.getEvalNeatLeftRate() == null) {
                this.appendInvalidMsg("evalNeatLeftRate", FaResUtil.getRes((String)"evalInfo27", (Locale)this.locale));
                if (this.exitAnyError) {
                    return false;
                }
            }
            if (card.getEvalDeprMode() != null && card.getDeprMethod() != null) {
                FaDepreciationModeInfo deprMode = card.getDeprMethod();
                FaDepreciationModeInfo evalDeprMode = card.getEvalDeprMode();
                if (FaManageUtils.isWorkLoadMethod((FaDepreciationModeInfo)deprMode) && !FaManageUtils.isWorkLoadMethod((FaDepreciationModeInfo)evalDeprMode) || FaManageUtils.isWorkLoadMethod((FaDepreciationModeInfo)evalDeprMode) && !FaManageUtils.isWorkLoadMethod((FaDepreciationModeInfo)deprMode)) {
                    this.appendInvalidMsg("deprMethod", FaResUtil.getRes((String)"evalInfo28", (Locale)this.locale));
                    if (this.exitAnyError) {
                        return false;
                    }
                }
            }
            if (card.getEvalDeprMode() != null && card.getDeprMethod() == null || card.getEvalDeprMode() == null && card.getDeprMethod() != null) {
                this.appendInvalidMsg("deprMethod", FaResUtil.getRes((String)"evalInfo29", (Locale)this.locale));
                if (this.exitAnyError) {
                    return false;
                }
            }
        }
        String strRow = ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_Row", (Locale)this.locale);
        if (!importCard) {
            int rowCount;
            FaMonFacilityCollection monFacility = isInitCard ? ((FaMonCardInfo)card).getFaMonFacility() : null;
            FaCurFacilityCollection curFacility = isInitCard ? null : ((FaCurCardInfo)card).getFaCurFacility();
            int n = rowCount = isInitCard ? monFacility.size() : curFacility.size();
            if (rowCount > 0) {
                String number = "";
                String name = "";
                BigDecimal tempB = ZERO;
                HashMap<String, Object> facilityNumMap = new HashMap<String, Object>(rowCount);
                for (int i = 0; i < rowCount; ++i) {
                    FaFacilityInfo iRow;
                    String strTemp = "";
                    FaFacilityInfo faFacilityInfo = iRow = isInitCard ? monFacility.get(i) : curFacility.get(i);
                    if (StringUtils.isEmpty((String)iRow.getFacilityNumber()) && StringUtils.isEmpty((String)iRow.getFacilityName()) && StringUtils.isEmpty((String)iRow.getFacilityModel()) && iRow.getRegisterDate() == null && iRow.getStorePlace() == null && iRow.getMeasureUnit() == null && iRow.getQuantity() == null && iRow.getAmount() == null && iRow.getKeeper() == null && StringUtils.isEmpty((String)iRow.getRemark())) continue;
                    number = iRow.getFacilityNumber();
                    name = iRow.getFacilityName();
                    if (number == null || number.trim().length() == 0) {
                        strTemp = ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_FacilityNumIsNull", (Locale)this.locale);
                        this.appendInvalidMsg(propPrefix + "facilityNumber", MessageFormat.format(strRow, i + 1, strTemp));
                        if (this.exitAnyError) {
                            return false;
                        }
                    }
                    if (facilityNumMap.containsKey(number)) {
                        if (facilityNumMap.get("HAS_ALREADY_DISPLAY_DUPLICATE_MSG") == null) {
                            facilityNumMap.put("HAS_ALREADY_DISPLAY_DUPLICATE_MSG", true);
                            strTemp = ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_FacilityNumDuplicate", (Locale)this.locale);
                            this.appendInvalidMsg(propPrefix + "facilityNumber", MessageFormat.format(strRow, i + 1, strTemp));
                            if (this.exitAnyError) {
                                return false;
                            }
                        }
                    } else {
                        facilityNumMap.put(number, number);
                    }
                    if (name == null || name.trim().length() == 0) {
                        strTemp = ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_FacilityNameIsNull", (Locale)this.locale);
                        this.appendInvalidMsg(propPrefix + "facilityName", MessageFormat.format(strRow, i + 1, strTemp));
                        if (this.exitAnyError) {
                            return false;
                        }
                    }
                    if ((tempB = iRow.getQuantity()) == null || tempB.compareTo(ZERO) < 0) {
                        strTemp = ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_FacilityQtyLessZERO", (Locale)this.locale);
                        this.appendInvalidMsg(propPrefix + "quantity", MessageFormat.format(strRow, i + 1, strTemp));
                        if (this.exitAnyError) {
                            return false;
                        }
                    }
                    if ((tempB = iRow.getAmount()) != null && tempB.compareTo(ZERO) >= 0) continue;
                    strTemp = ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_FacilityAmountLessZERO", (Locale)this.locale);
                    this.appendInvalidMsg(propPrefix + "amount", MessageFormat.format(strRow, i + 1, strTemp));
                    if (!this.exitAnyError) continue;
                    return false;
                }
            }
        }
        if (!importCard) {
            FaMonDepartmentCollection monDepts = isInitCard ? ((FaMonCardInfo)card).getFaMonDepartment() : null;
            FaCurDepartmentCollection curDepts = isInitCard ? null : ((FaCurCardInfo)card).getFaCurDepartment();
            int rowCount = isInitCard ? monDepts.size() : curDepts.size();
            int rowSum = 0;
            for (int i = 0; i < rowCount; ++i) {
                FaDepartmentInfo iRow;
                String strTemp = "";
                FaDepartmentInfo faDepartmentInfo = iRow = isInitCard ? monDepts.get(i) : curDepts.get(i);
                if (iRow.getUseDepartment() == null && iRow.getUsePerson() == null && StringUtils.isEmpty((String)iRow.getUsage()) && StringUtils.isEmpty((String)iRow.getRemark())) continue;
                ++rowSum;
                if (iRow.getUseDepartment() != null) continue;
                strTemp = ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_UseDepartmentIsNull", (Locale)this.locale);
                this.appendInvalidMsg(propPrefix + "useDepartment", MessageFormat.format(strRow, i + 1, strTemp));
                if (!this.exitAnyError) continue;
                return false;
            }
            if (rowSum == 0) {
                this.appendInvalidMsg(propPrefix + "useDepartment", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_UseDepartmentZero", (Locale)this.locale));
                if (this.exitAnyError) {
                    return false;
                }
            }
        }
        if (!importCard) {
            String costCenterRequired;
            FaMonCostCenterCollection monCostcenter = isInitCard ? ((FaMonCardInfo)card).getFaMonCostCenter() : null;
            FaCurCostCenterCollection curCostcenter = isInitCard ? null : ((FaCurCardInfo)card).getFaCurCostCenter();
            int rowCount = isInitCard ? monCostcenter.size() : curCostcenter.size();
            int rowSum = 0;
            BigDecimal sum = ZERO;
            boolean isDepaAndAcc = false;
            Vector<String> vectemp = new Vector<String>(0);
            BigDecimal tempB = null;
            for (int i = 0; i < rowCount; ++i) {
                AccountViewInfo _accountView;
                FaCostCenterInfo iRow;
                String strTemp = "";
                FaCostCenterInfo faCostCenterInfo = iRow = isInitCard ? monCostcenter.get(i) : curCostcenter.get(i);
                if (iRow.getAccountView() == null && iRow.getApportionScale() == null && StringUtils.isEmpty((String)iRow.getRemark())) continue;
                ++rowSum;
                if (iRow.getAccountView() == null) {
                    String deprAccRequired = (String)this.faParams.get("FA_016");
                    if (deprAccRequired == null || deprAccRequired.equals("") || new Boolean(deprAccRequired).booleanValue()) {
                        strTemp = ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_UseDepartAccIsNull", (Locale)this.locale);
                        this.appendInvalidMsg(propPrefix + "accountView", MessageFormat.format(strRow, i + 1, strTemp));
                        if (this.exitAnyError) {
                            return false;
                        }
                    }
                } else {
                    String faAsstActCompositErrorMsg = this.getFaAsstActCompositErrorMsg(isInitCard, iRow, iRow.getAccountView());
                    if (faAsstActCompositErrorMsg.trim().length() > 0) {
                        this.appendInvalidMsg(propPrefix + "accountView", faAsstActCompositErrorMsg);
                    }
                    if ((_accountView = iRow.getAccountView()).get("isLeaf") == null) {
                        throw new IllegalArgumentException(com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"111_FaCardValidatorImpl"));
                    }
                    if (!_accountView.isIsLeaf()) {
                        strTemp = ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_FaUseAccountIsNotLeaf", (Locale)this.locale);
                        this.appendInvalidMsg(propPrefix + "accountView", MessageFormat.format(strRow, i + 1, strTemp));
                        if (this.exitAnyError) {
                            return false;
                        }
                    }
                }
                if (!isDepaAndAcc && iRow.getAccountView() != null) {
                    String asstActItem = this.getAsstActString(iRow);
                    _accountView = iRow.getAccountView();
                    String strDepaAddAcc = _accountView.getId().toString() + asstActItem;
                    if (vectemp.contains(strDepaAddAcc)) {
                        isDepaAndAcc = true;
                    } else {
                        vectemp.add(strDepaAddAcc);
                    }
                }
                boolean flag = false;
                if (iRow.getApportionScale() == null) {
                    flag = true;
                } else {
                    tempB = iRow.getApportionScale();
                    if (tempB == null) {
                        tempB = ZERO;
                    }
                    if (tempB.compareTo(ZERO) <= 0) {
                        flag = true;
                    } else {
                        sum = sum.add(tempB);
                    }
                }
                if (!flag) continue;
                strTemp = ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_UseDepartRate", (Locale)this.locale);
                this.appendInvalidMsg(propPrefix + "apportionScale", MessageFormat.format(strRow, i + 1, strTemp));
                if (!this.exitAnyError) continue;
                return false;
            }
            if (rowSum > 0 && sum.doubleValue() != 100.0) {
                this.appendInvalidMsg(propPrefix + "apportionScale", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_UseDepartRateLimit", (Locale)this.locale));
                if (this.exitAnyError) {
                    return false;
                }
            }
            if (isDepaAndAcc) {
                this.appendInvalidMsg(propPrefix + "accountView", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_DepaAndAcc", (Locale)this.locale));
                if (this.exitAnyError) {
                    return false;
                }
            }
            if (((costCenterRequired = (String)this.faParams.get("FA_016")) == null || costCenterRequired.equals("") || new Boolean(costCenterRequired).booleanValue()) && rowSum == 0) {
                this.appendInvalidMsg(propPrefix + "accountView", ResourceBase.getString((String)RESOURCE_PATH, (String)"FaCurCardEditUI_UseDepartNoData", (Locale)this.locale));
                if (this.exitAnyError) {
                    return false;
                }
            }
        }
        if (!importCard && isInitCard && (((FaMonCardInfo)card).getFaMonInitData() == null || ((FaMonCardInfo)card).getFaMonInitData().size() == 0) && this.currPeriod.getPeriodNumber() != 1) {
            this.appendInvalidMsg("faMonInitData", com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"112_FaCardValidatorImpl"));
            if (this.exitAnyError) {
                return false;
            }
        }
        return this.getInvalidMsg() == null || this.getInvalidMsg().length() == 0;
    }

    private IFaCat getFaCatFactory() throws BOSException {
        if (this.iFaCatFactory == null) {
            this.iFaCatFactory = this.ctx == null ? FaCatFactory.getRemoteInstance() : FaCatFactory.getLocalInstance((Context)this.ctx);
        }
        return this.iFaCatFactory;
    }

    private void checkUseYearsAndNeatLeftValue(FaCardInfo faCardInfo) throws BOSException, EASBizException {
        FaCatInfo faCatInfo = faCardInfo.getAssetCat();
        FaDepreciationModeInfo depMethodInfo = faCardInfo.getDeprMethod();
        boolean isWorkLoad = false;
        if (depMethodInfo != null) {
            isWorkLoad = depMethodInfo.isIsWorkload();
        }
        BigDecimal period = new BigDecimal(12);
        if (faCatInfo != null) {
            boolean isGroupControl;
            if (faCatInfo.getPrePureRateFrom() == null || faCatInfo.getPrePureRateTo() == null) {
                faCatInfo = this.iFaCatFactory.getFaCatInfo((IObjectPK)new ObjectUuidPK(faCatInfo.getId()));
            }
            if (isGroupControl = faCatInfo.isGcUseLimitAndPureRate()) {
                boolean isFastSubmit;
                BigDecimal useYearFrom = faCatInfo.getBigDecimal("uselimitfrom");
                BigDecimal useYearTo = faCatInfo.getBigDecimal("uselimitto");
                BigDecimal prePureRateFrom = faCatInfo.getPrePureRateFrom();
                BigDecimal prePureRateTo = faCatInfo.getPrePureRateTo();
                BigDecimal userYear = faCardInfo.getUseYears();
                BigDecimal useTermCount = faCardInfo.getUseTermCount();
                BigDecimal neatLeftValue = faCardInfo.getNeatRemValue() == null ? ZERO : faCardInfo.getNeatRemValue();
                BigDecimal neatLeftRate = faCardInfo.getNeatLeftRate() == null ? ZERO : faCardInfo.getNeatLeftRate();
                BigDecimal localAmount = faCardInfo.getAssetValue();
                BigDecimal currenctRate = ZERO;
                if (localAmount.compareTo(ZERO) == 1) {
                    currenctRate = neatLeftValue.multiply(new BigDecimal(100)).divide(localAmount, 4);
                }
                boolean bl = isFastSubmit = this.getParam("verifyFastSubmit") != null && (Boolean)this.getParam("verifyFastSubmit") != false;
                if (!isWorkLoad && !isFastSubmit) {
                    if (userYear.compareTo(useYearFrom) == -1 || userYear.compareTo(useYearTo) == 1) {
                        this.appendInvalidMsg("useYear", ResourceBase.getString((String)this.RESOURCE_PATH, (String)"UseYearRangIllegal", (Locale)this.locale) + useYearFrom + " ~ " + useYearTo + EASResource.getString((String)this.resource, (String)"year"));
                    }
                    if (useTermCount.compareTo(useYearFrom.multiply(period)) == -1 || useTermCount.compareTo(useYearTo.multiply(period)) == 1) {
                        this.appendInvalidMsg("useTermCount", ResourceBase.getString((String)this.RESOURCE_PATH, (String)"UsePeriodRangIllegal", (Locale)this.locale) + useYearFrom.multiply(new BigDecimal(12)) + " ~ " + useYearTo.multiply(new BigDecimal(12)) + EASResource.getString((String)this.resource, (String)"period"));
                    }
                }
                if (!isFastSubmit) {
                    if (neatLeftRate.compareTo(prePureRateFrom) == -1 || neatLeftRate.compareTo(prePureRateTo) == 1) {
                        this.appendInvalidMsg("neatLeftRate", ResourceBase.getString((String)this.RESOURCE_PATH, (String)"LeftRateRangIllegal", (Locale)this.locale) + prePureRateFrom.setScale(2, 4) + "% ~ " + prePureRateTo.setScale(2, 4) + "%");
                    }
                    if (currenctRate.compareTo(prePureRateFrom) == -1 || currenctRate.compareTo(prePureRateTo) == 1) {
                        this.appendInvalidMsg("neatRemValue", ResourceBase.getString((String)this.RESOURCE_PATH, (String)"LeftValueRangIllegal", (Locale)this.locale) + prePureRateFrom.setScale(2, 4) + "% ~ " + prePureRateTo.setScale(2, 4) + "%");
                    }
                }
            }
        }
    }

    private String getAsstActString(FaCostCenterInfo costCenterInfo) {
        AsstActTypeInfo typeInfo;
        AssistActItemInfo asstItemInfo;
        int i;
        int size;
        FaCostCenterInfo curCostCenter;
        ArrayList<String> asstItem = new ArrayList<String>();
        ArrayList<String> asstType = new ArrayList<String>();
        if (costCenterInfo instanceof FaCurCostCenterInfo) {
            curCostCenter = (FaCurCostCenterInfo)costCenterInfo;
            size = ((AbstractFaCurCostCenterInfo)curCostCenter).getFaCurAsstActComposit().size();
            for (i = 0; i < size; ++i) {
                asstItemInfo = ((AbstractFaCurCostCenterInfo)curCostCenter).getFaCurAsstActComposit().get(i).getAsstActItem();
                if (asstItemInfo != null && asstItemInfo.getId() != null) {
                    asstItem.add(asstItemInfo.getId().toString());
                }
                if ((typeInfo = ((AbstractFaCurCostCenterInfo)curCostCenter).getFaCurAsstActComposit().get(i).getAsstActType()) == null || typeInfo.getId() == null) continue;
                asstType.add(typeInfo.getId().toString());
            }
        }
        if (costCenterInfo instanceof FaMonCostCenterInfo) {
            curCostCenter = (FaMonCostCenterInfo)costCenterInfo;
            size = ((AbstractFaMonCostCenterInfo)curCostCenter).getFaMonAsstActComposit().size();
            for (i = 0; i < size; ++i) {
                asstItemInfo = ((AbstractFaMonCostCenterInfo)curCostCenter).getFaMonAsstActComposit().get(i).getAsstActItem();
                if (asstItemInfo != null && asstItemInfo.getId() != null) {
                    asstItem.add(asstItemInfo.getId().toString());
                }
                if ((typeInfo = ((AbstractFaMonCostCenterInfo)curCostCenter).getFaMonAsstActComposit().get(i).getAsstActType()) == null || typeInfo.getId() == null) continue;
                asstType.add(typeInfo.getId().toString());
            }
        }
        Collections.sort(asstItem);
        Collections.sort(asstType);
        return asstItem.toString() + asstType.toString();
    }

    private String getFaAsstActCompositErrorMsg(boolean isInitCard, FaCostCenterInfo costCenterInfo, AccountViewInfo accountView) {
        if (accountView == null || accountView.getName() == null) {
            return "";
        }
        String errorMsg = "";
        String asstItemInvidMsg = ResourceBase.getString((String)this.RESOURCE_PATH, (String)"asstItemInvalid", (Locale)this.locale);
        String asstTypeInvaildMsg = ResourceBase.getString((String)this.RESOURCE_PATH, (String)"asstTypeInvaild", (Locale)this.locale);
        String accountViewName = accountView.getName();
        boolean isEnableAsstitem = new Boolean((String)this.faParams.get("FA_289"));
        if (isInitCard) {
            boolean isContainAsstActGpDt = false;
            try {
                isContainAsstActGpDt = FaUtils.isContainAsstActGpDt((Context)this.ctx, (AccountViewInfo)accountView);
            }
            catch (Exception e) {
                errorMsg = e.getMessage();
                return errorMsg;
            }
            FaMonCostCenterInfo monCostCenter = (FaMonCostCenterInfo)costCenterInfo;
            if (!(monCostCenter.getFaMonAsstActComposit() != null && monCostCenter.getFaMonAsstActComposit().size() != 0 || isContainAsstActGpDt)) {
                errorMsg = errorMsg + accountViewName + asstItemInvidMsg;
                return errorMsg;
            }
            FaMonAsstActCompositCollection monAsstActCollection = monCostCenter.getFaMonAsstActComposit();
            String asstActDupMsg = this.getAsstActItemDupMsg(accountViewName, isInitCard, (IObjectCollection)monAsstActCollection);
            if (asstActDupMsg.length() > 0) {
                errorMsg = errorMsg + asstActDupMsg;
                return errorMsg;
            }
            int size = monAsstActCollection.size();
            Map<Object, Object> map = new HashMap();
            try {
                map = this.getCaaTypeNum(this.ctx, accountView);
            }
            catch (Exception e) {
                return e.getMessage();
            }
            if (isEnableAsstitem) {
                int j = 0;
                for (int i = 0; i < size; ++i) {
                    if (size < map.size()) {
                        return ResourceBase.getString((String)this.RESOURCE_PATH, (String)"AsstActTypeInvalid", (Locale)this.locale, (Object[])new Object[]{accountView.getName()});
                    }
                    if (size == map.size()) {
                        if (!map.containsKey(monAsstActCollection.get(i).getAsstActType().getNumber().toString())) {
                            return ResourceBase.getString((String)this.RESOURCE_PATH, (String)"AsstActTypeInvalid", (Locale)this.locale, (Object[])new Object[]{accountView.getName()});
                        }
                    } else if (size > map.size()) {
                        if (!map.containsKey(monAsstActCollection.get(i).getAsstActType().getNumber().toString())) {
                            ++j;
                        }
                        if (j > size - map.size()) {
                            return ResourceBase.getString((String)this.RESOURCE_PATH, (String)"AsstActTypeInvalid", (Locale)this.locale, (Object[])new Object[]{accountView.getName()});
                        }
                    }
                    if (monAsstActCollection.get(i).getAsstActItem() == null || monAsstActCollection.get(i).getAsstActItem().getId() == null) {
                        errorMsg = errorMsg + accountViewName + asstItemInvidMsg;
                    } else {
                        if (monAsstActCollection.get(i).getAsstActType() != null && monAsstActCollection.get(i).getAsstActType().getId() != null) continue;
                        errorMsg = errorMsg + accountViewName + asstTypeInvaildMsg;
                    }
                    break;
                }
            } else {
                if (size < map.size()) {
                    return ResourceBase.getString((String)this.RESOURCE_PATH, (String)"AsstActTypeInvalid", (Locale)this.locale, (Object[])new Object[]{accountView.getName()});
                }
                for (int i = 0; i < size; ++i) {
                    if (!map.containsKey(monAsstActCollection.get(i).getAsstActType().getNumber().toString())) {
                        return ResourceBase.getString((String)this.RESOURCE_PATH, (String)"AsstactTypeNotBelongAccountView", (Locale)this.locale, (Object[])new Object[]{monAsstActCollection.get(i).getAsstActType().getName(), accountView.getName()});
                    }
                    if (i > map.size() - 1) {
                        return ResourceBase.getString((String)this.RESOURCE_PATH, (String)"AsstactTypeNotBelongAccountView", (Locale)this.locale, (Object[])new Object[]{monAsstActCollection.get(i).getAsstActType().getName(), accountView.getName()});
                    }
                    if (monAsstActCollection.get(i).getAsstActItem() == null || monAsstActCollection.get(i).getAsstActItem().getId() == null) {
                        errorMsg = errorMsg + accountViewName + asstItemInvidMsg;
                    } else {
                        if (monAsstActCollection.get(i).getAsstActType() != null && monAsstActCollection.get(i).getAsstActType().getId() != null) continue;
                        errorMsg = errorMsg + accountViewName + asstTypeInvaildMsg;
                    }
                    break;
                }
            }
        } else {
            boolean isContainAsstActGpDt = false;
            try {
                isContainAsstActGpDt = FaUtils.isContainAsstActGpDt((Context)this.ctx, (AccountViewInfo)accountView);
            }
            catch (Exception e) {
                errorMsg = e.getMessage();
                return errorMsg;
            }
            FaCurCostCenterInfo curCostCenter = (FaCurCostCenterInfo)costCenterInfo;
            if (!(curCostCenter.getFaCurAsstActComposit() != null && curCostCenter.getFaCurAsstActComposit().size() != 0 || isContainAsstActGpDt)) {
                errorMsg = errorMsg + accountViewName + asstItemInvidMsg;
                return errorMsg;
            }
            FaCurAsstActCompositCollection curAsstActCollection = curCostCenter.getFaCurAsstActComposit();
            String asstActDupMsg = this.getAsstActItemDupMsg(accountViewName, isInitCard, (IObjectCollection)curAsstActCollection);
            if (asstActDupMsg.length() > 0) {
                errorMsg = errorMsg + asstActDupMsg;
                return errorMsg;
            }
            int size = curAsstActCollection.size();
            Map<Object, Object> map = new HashMap();
            try {
                map = this.getCaaTypeNum(this.ctx, accountView);
            }
            catch (Exception e) {
                return e.getMessage();
            }
            if (isEnableAsstitem) {
                int j = 0;
                for (int i = 0; i < size; ++i) {
                    if (size < map.size()) {
                        return ResourceBase.getString((String)this.RESOURCE_PATH, (String)"AsstActTypeInvalid", (Locale)this.locale, (Object[])new Object[]{accountView.getName()});
                    }
                    if (size == map.size()) {
                        if (!map.containsKey(curAsstActCollection.get(i).getAsstActType().getNumber().toString())) {
                            return ResourceBase.getString((String)this.RESOURCE_PATH, (String)"AsstActTypeInvalid", (Locale)this.locale, (Object[])new Object[]{accountView.getName()});
                        }
                    } else if (size > map.size()) {
                        if (!map.containsKey(curAsstActCollection.get(i).getAsstActType().getNumber().toString())) {
                            ++j;
                        }
                        if (j > size - map.size()) {
                            return ResourceBase.getString((String)this.RESOURCE_PATH, (String)"AsstActTypeInvalid", (Locale)this.locale, (Object[])new Object[]{accountView.getName()});
                        }
                    }
                    if (curAsstActCollection.get(i).getAsstActItem() == null || curAsstActCollection.get(i).getAsstActItem().getId() == null) {
                        errorMsg = errorMsg + accountViewName + asstItemInvidMsg;
                    } else {
                        if (curAsstActCollection.get(i).getAsstActType() != null && curAsstActCollection.get(i).getAsstActType().getId() != null) continue;
                        errorMsg = errorMsg + accountViewName + asstTypeInvaildMsg;
                    }
                    break;
                }
            } else {
                if (size < map.size()) {
                    return ResourceBase.getString((String)this.RESOURCE_PATH, (String)"AsstActTypeInvalid", (Locale)this.locale, (Object[])new Object[]{accountView.getName()});
                }
                for (int i = 0; i < size; ++i) {
                    if (!map.containsKey(curAsstActCollection.get(i).getAsstActType().getNumber())) {
                        return ResourceBase.getString((String)this.RESOURCE_PATH, (String)"AsstactTypeNotBelongAccountView", (Locale)this.locale, (Object[])new Object[]{curAsstActCollection.get(i).getAsstActType().getName(), accountView.getName()});
                    }
                    if (i > map.size() - 1) {
                        return ResourceBase.getString((String)this.RESOURCE_PATH, (String)"AsstactTypeNotBelongAccountView", (Locale)this.locale, (Object[])new Object[]{curAsstActCollection.get(i).getAsstActType().getName(), accountView.getName()});
                    }
                    if (curAsstActCollection.get(i).getAsstActItem() == null || curAsstActCollection.get(i).getAsstActItem().getId() == null) {
                        errorMsg = errorMsg + accountViewName + asstItemInvidMsg;
                    } else {
                        if (curAsstActCollection.get(i).getAsstActType() != null && curAsstActCollection.get(i).getAsstActType().getId() != null) continue;
                        errorMsg = errorMsg + accountViewName + asstTypeInvaildMsg;
                    }
                    break;
                }
            }
        }
        return errorMsg;
    }

    private Map<String, String> getCaaTypeNum(Context ctx, AccountViewInfo accountView) throws BOSException, SQLException {
        String accountViewId = accountView.getId().toString();
        String sql = "SELECT AAT.FNUMBER NUMBER FROM T_BD_ACCOUNTVIEW  AV LEFT OUTER JOIN T_BD_ASSTACCOUNT AA ON AV.FCAA = AA.FID LEFT OUTER JOIN T_BD_ASSTACTGROUPDETAIL AAGD ON AAGD.FASSTACCOUNTID = AA.FID LEFT OUTER JOIN T_BD_ASSTACTTYPE AAT ON AAT.FID = AAGD.FASSTACTTYPEID WHERE AV.FID ='" + accountViewId + "'";
        HashMap<String, String> map = new HashMap<String, String>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rs.next()) {
            String number = rs.getString("NUMBER");
            if (StringUtils.isEmpty((String)number)) continue;
            map.put(number, number);
        }
        return map;
    }

    private String getAsstActItemDupMsg(String accountViewName, boolean isInitCard, IObjectCollection asstActCollection) {
        if (asstActCollection == null || asstActCollection.size() < 1) {
            return "";
        }
        boolean isDepaAndAcc = false;
        if (isInitCard) {
            FaMonAsstActCompositCollection monAsstActCollection = (FaMonAsstActCompositCollection)asstActCollection;
            int size = monAsstActCollection.size();
            Vector<String> vectemp = new Vector<String>(size);
            for (int i = 0; i < size; ++i) {
                if (isDepaAndAcc) continue;
                AssistActItemInfo asstActItem = monAsstActCollection.get(i).getAsstActItem();
                AsstActTypeInfo asstActType = monAsstActCollection.get(i).getAsstActType();
                if (asstActType == null || asstActItem == null) continue;
                String asstActItemId = "";
                String asstActTypeId = asstActType.getId().toString();
                String AsstActCompositId = asstActItemId + asstActTypeId;
                if (vectemp.contains(AsstActCompositId)) {
                    isDepaAndAcc = true;
                    break;
                }
                vectemp.add(AsstActCompositId);
            }
        } else {
            FaCurAsstActCompositCollection curAsstActCollection = (FaCurAsstActCompositCollection)asstActCollection;
            int size = curAsstActCollection.size();
            Vector<String> vectemp = new Vector<String>(size);
            for (int i = 0; i < size; ++i) {
                if (isDepaAndAcc) continue;
                AssistActItemInfo asstActItem = curAsstActCollection.get(i).getAsstActItem();
                AsstActTypeInfo asstActType = curAsstActCollection.get(i).getAsstActType();
                if (asstActType == null || asstActItem == null) continue;
                String asstActItemId = "";
                String asstActTypeId = asstActType.getId().toString();
                String AsstActCompositId = asstActItemId + asstActTypeId;
                if (vectemp.contains(AsstActCompositId)) {
                    isDepaAndAcc = true;
                    break;
                }
                vectemp.add(AsstActCompositId);
            }
        }
        if (isDepaAndAcc) {
            String asstTypeDupMsg = ResourceBase.getString((String)this.RESOURCE_PATH, (String)"asstTypeDup", (Locale)this.locale);
            return accountViewName + asstTypeDupMsg;
        }
        return "";
    }

    private boolean verifyAccountDate(FaCardInfo card, boolean isInitCard) throws BOSException, EASBizException {
        boolean result = true;
        String resource_path = "com.kingdee.eas.fi.fa.manage.FaCardResource";
        Date accountDate = card.getAccountDate();
        Date fiAccountDate = card.getFiAccountDate();
        if (accountDate == null) {
            return false;
        }
        if (!isInitCard) {
            String strTemp;
            String strTemp2;
            boolean isAllowFa022 = false;
            String paramvalue_22 = (String)this.faParams.get("FA_022");
            if (paramvalue_22 == null || Boolean.valueOf(paramvalue_22).booleanValue() || this.getParam("IS_FROM_BILL_UI") != null) {
                isAllowFa022 = true;
            }
            if (!(isAllowFa022 || this.getParam("fromBillUI") != null && this.getParam("fromBillUI").toString().equals("FaSplitBillEditUI"))) {
                if (DateTimeUtils.dayBefore((Date)accountDate, (Date)this.currPeriod.getBeginDate())) {
                    strTemp2 = FaResUtil.getRes((String)"accountDateMustGeCurPeriod", (Locale)this.locale);
                    strTemp2 = strTemp2 + "[" + this.currPeriod.getPeriodYear() + "." + this.currPeriod.getPeriodNumber() + "]";
                    this.appendInvalidMsg("fiAccountDate", strTemp2);
                    result = false;
                    if (this.exitAnyError) {
                        return false;
                    }
                }
                if (fiAccountDate != null) {
                    PeriodInfo faccountdate = PeriodUtils.getPeriodInfo((Context)this.ctx, (Date)accountDate, (CompanyOrgUnitInfo)card.getCompany());
                    PeriodInfo fiAccountDateD = PeriodUtils.getPeriodInfo((Context)this.ctx, (Date)fiAccountDate, (CompanyOrgUnitInfo)card.getCompany());
                    if (faccountdate != null && fiAccountDateD != null && !faccountdate.getId().equals((Object)fiAccountDateD.getId())) {
                        String strTemp3 = FaResUtil.getRes((String)"dateMustSamePeriod", (Locale)this.locale);
                        this.appendInvalidMsg("fiAccountDate", strTemp3);
                        return false;
                    }
                }
            }
            if (fiAccountDate != null && DateTimeUtils.dayBefore((Date)fiAccountDate, (Date)this.currPeriod.getBeginDate())) {
                strTemp2 = FaResUtil.getRes((String)"fiAccountDateMustGePeriod", (Locale)this.locale);
                strTemp2 = strTemp2 + "[" + this.currPeriod.getPeriodYear() + "." + this.currPeriod.getPeriodNumber() + "]";
                this.appendInvalidMsg("fiAccountDate", strTemp2);
                result = false;
                if (this.exitAnyError) {
                    return false;
                }
            }
            IParamControl ipc = this.ctx == null ? ParamControlFactory.getRemoteInstance() : ParamControlFactory.getLocalInstance((Context)this.ctx);
            String companyId = card.getCompany() != null ? card.getCompany().getId().toString() : this.company.getId().toString();
            String paramvalue_100 = ipc.getParamValue((IObjectPK)new ObjectUuidPK(companyId), "FA_100");
            boolean isAllowFa100 = Boolean.valueOf(paramvalue_100);
            if (!(this.getParam("verifySubmit") == null || ((Boolean)this.getParam("verifySubmit")).booleanValue() || isAllowFa022 || isAllowFa100)) {
                if (DateTimeUtils.dayBefore((Date)accountDate, (Date)this.currPeriod.getBeginDate()) || DateTimeUtils.dayAfter((Date)accountDate, (Date)this.currPeriod.getEndDate())) {
                    strTemp = FaResUtil.getRes((String)"accountDateMustAtCurPeriod", (Locale)this.locale);
                    strTemp = strTemp + "[" + this.currPeriod.getPeriodYear() + "." + this.currPeriod.getPeriodNumber() + "]";
                    this.appendInvalidMsg("fiAccountDate", strTemp);
                    result = false;
                    if (this.exitAnyError) {
                        return false;
                    }
                }
                if (fiAccountDate != null && (DateTimeUtils.dayBefore((Date)fiAccountDate, (Date)this.currPeriod.getBeginDate()) || DateTimeUtils.dayAfter((Date)fiAccountDate, (Date)this.currPeriod.getEndDate()))) {
                    strTemp = FaResUtil.getRes((String)"fiAccountDateMustAtCurPeriod", (Locale)this.locale);
                    strTemp = strTemp + "[" + this.currPeriod.getPeriodYear() + "." + this.currPeriod.getPeriodNumber() + "]";
                    this.appendInvalidMsg("fiAccountDate", strTemp);
                    result = false;
                    if (this.exitAnyError) {
                        return false;
                    }
                }
            }
            if (this.getParam("verifySubmit") != null && ((Boolean)this.getParam("verifySubmit")).booleanValue()) {
                if (!isAllowFa022 && !isAllowFa100) {
                    if (!(!DateTimeUtils.dayBefore((Date)accountDate, (Date)this.currPeriod.getBeginDate()) && !DateTimeUtils.dayAfter((Date)accountDate, (Date)this.currPeriod.getEndDate()) || this.getParam("fromBillUI") != null && this.getParam("fromBillUI").toString().equals("FaSplitBillEditUI"))) {
                        strTemp = FaResUtil.getRes((String)"accountDateMustAtCurPeriod", (Locale)this.locale);
                        strTemp = strTemp + "[" + this.currPeriod.getPeriodYear() + "." + this.currPeriod.getPeriodNumber() + "]";
                        this.appendInvalidMsg("fiAccountDate", strTemp);
                        result = false;
                        if (this.exitAnyError) {
                            return false;
                        }
                    }
                    if (fiAccountDate != null && (DateTimeUtils.dayBefore((Date)fiAccountDate, (Date)this.currPeriod.getBeginDate()) || DateTimeUtils.dayAfter((Date)fiAccountDate, (Date)this.currPeriod.getEndDate()))) {
                        strTemp = FaResUtil.getRes((String)"fiAccountDateMustAtCurPeriod", (Locale)this.locale);
                        strTemp = strTemp + "[" + this.currPeriod.getPeriodYear() + "." + this.currPeriod.getPeriodNumber() + "]";
                        this.appendInvalidMsg("fiAccountDate", strTemp);
                        result = false;
                        if (this.exitAnyError) {
                            return false;
                        }
                    } else if (fiAccountDate == null) {
                        if (this.invalidMsg.indexOf(FaResUtil.getRes((String)"fiAccountDateIsNull", (Locale)this.locale)) < 0) {
                            this.appendInvalidMsg("fiAccountDate", FaResUtil.getRes((String)"fiAccountDateIsNull", (Locale)this.locale));
                        }
                        result = false;
                        if (this.exitAnyError) {
                            return false;
                        }
                    }
                } else if (isAllowFa022 && !isAllowFa100) {
                    if (DateTimeUtils.dayAfter((Date)accountDate, (Date)this.currPeriod.getEndDate())) {
                        strTemp = FaResUtil.getRes((String)"accountDateMustLePeriod", (Locale)this.locale);
                        strTemp = strTemp + "[" + this.currPeriod.getPeriodYear() + "." + this.currPeriod.getPeriodNumber() + "]";
                        this.appendInvalidMsg("fiAccountDate", strTemp);
                        result = false;
                        if (this.exitAnyError) {
                            return false;
                        }
                    }
                    if (fiAccountDate != null && (DateTimeUtils.dayBefore((Date)fiAccountDate, (Date)this.currPeriod.getBeginDate()) || DateTimeUtils.dayAfter((Date)fiAccountDate, (Date)this.currPeriod.getEndDate()))) {
                        strTemp = FaResUtil.getRes((String)"fiAccountDateMustAtCurPeriod", (Locale)this.locale);
                        strTemp = strTemp + "[" + this.currPeriod.getPeriodYear() + "." + this.currPeriod.getPeriodNumber() + "]";
                        this.appendInvalidMsg("fiAccountDate", strTemp);
                        result = false;
                        if (this.exitAnyError) {
                            return false;
                        }
                    }
                }
            }
            return result;
        }
        if (!DateTimeUtils.dayBefore((Date)accountDate, (Date)this.currPeriod.getBeginDate())) {
            String strTemp = ResourceBase.getString((String)resource_path, (String)"FaCurCardEditUI_InitAccountDateOut", (Locale)this.locale);
            this.appendInvalidMsg("fiAccountDate", strTemp);
            result = false;
            if (this.exitAnyError) {
                return false;
            }
        }
        if (fiAccountDate != null && fiAccountDate.compareTo(this.currPeriod.getBeginDate()) >= 0) {
            this.appendInvalidMsg("fiAccountDate", FaResUtil.getRes((String)"fiAccountDateLtPeriodDate", (Locale)this.locale));
            result = false;
            if (this.exitAnyError) {
                return false;
            }
        }
        return result;
    }

    private void initiate() throws BOSException, EASBizException {
        if (this.hasInit) {
            return;
        }
        this.company = (CompanyOrgUnitInfo)this.getParam("Company");
        if (this.company == null) {
            String companyId = this.billInfo.getCompany().getId().toString();
            ICompanyOrgUnit icom = this.ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx);
            this.company = icom.getCompanyOrgUnitInfo("select *,baseCurrency.precision,baseCurrency.name,baseCurrency.id where id='" + companyId + "'");
        }
        this.faParams = FaManageUtils.getFAParameter(this.company.getBOSUuid("id"), this.ctx);
        Object _isRelAccount = this.getParam("isRelAccount");
        this.isRelAccount = _isRelAccount != null ? (Boolean)_isRelAccount : SystemStatusCtrolUtils.isRelAccount((Context)this.ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.company);
        this.currPeriod = (PeriodInfo)this.getParam("currentPeriod");
        if (this.currPeriod == null) {
            this.currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.company);
        }
        this.periodCount = PeriodUtils.getPeriodCount((Context)this.ctx, (IObjectPK)new ObjectUuidPK(this.currPeriod.getId()), (boolean)true);
        this.hasInit = true;
    }

    private boolean checkUseTermCount(BigDecimal useYear, BigDecimal useTermCount) {
        useYear = useYear.setScale(1, 4);
        useTermCount = useTermCount.setScale(0, 4);
        BigDecimal periodAmt = new BigDecimal(1.0 * (double)this.periodCount);
        boolean mulityBoolean = useYear.multiply(periodAmt).setScale(0, 4).compareTo(useTermCount) == 0;
        boolean devideBoolean = useTermCount.divide(periodAmt, 1, 4).compareTo(useYear) == 0;
        return mulityBoolean || devideBoolean;
    }

    private boolean isCheckNumber(FaCardInfo card, boolean importCard) {
        if (importCard) {
            return true;
        }
        String autoCode = (String)this.faParams.get("FA_001");
        String codeChange = (String)this.faParams.get("FA_003");
        if (autoCode == null || autoCode.trim().length() == 0 || autoCode.trim().equalsIgnoreCase("true")) {
            if (card.getId() == null || card.getId().toString().trim().length() == 0) {
                return false;
            }
            return codeChange != null && codeChange.trim().length() != 0 && codeChange.trim().equalsIgnoreCase("true");
        }
        return true;
    }

    private boolean isCheckBlocNumber(FaCardInfo card, boolean importCard) {
        if (importCard) {
            return true;
        }
        String autoCode = (String)this.faParams.get("FA_189");
        return autoCode != null && autoCode.trim().length() != 0 && !autoCode.trim().equalsIgnoreCase("true");
    }

    public static class ValidParam {
        public static final String IS_IMPORT_CARD = "importCard";
        public static final String FROM_BILL_UI = "fromBillUI";
        public static final String IS_FROM_BILL_UI = "isFromBillUI";
        public static final String CURRENT_PERIOD = "currentPeriod";
        public static final String IS_REL_ACCOUNT = "isRelAccount";
        public static final String COMPANY = "Company";
        public static final String OPRT_STATE = "OprtState";
        public static final String VERIFY_SUBMIT = "verifySubmit";
        public static final String VERIFY_FAST_SUBMIT = "verifyFastSubmit";
    }
}

