/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.wssc.BillImageMapCollection;
import com.kingdee.eas.base.wssc.BillImageMapFactory;
import com.kingdee.eas.base.wssc.BillImageMapInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

abstract class AbstractFaPrintManager
implements BOSQueryDelegate {
    IObjectCollection dataCollection;
    Logger logger = Logger.getLogger(AbstractFaPrintManager.class);
    List allColumns;

    protected AbstractFaPrintManager() {
    }

    protected AbstractFaPrintManager(IObjectCollection collection) {
        this.dataCollection = collection;
    }

    public abstract IRowSet execute(BOSQueryDataSource var1);

    protected IRowSet getDefaltRowSet(BOSQueryDataSource ds, KDTable[] tables) {
        IRowSet rs = null;
        try {
            if (this.dataCollection == null || this.dataCollection.size() <= 0) {
                return rs;
            }
            IObjectValue obj = this.dataCollection.getObject(0);
            List column = this.getAllKey(obj, "");
            column = this.beforeBuildColumn(column);
            rs = this.buildRowSet(column);
            rs.beforeFirst();
            for (int i = 0; i < this.dataCollection.size(); ++i) {
                IObjectValue obj2 = this.dataCollection.getObject(i);
                rs.moveToInsertRow();
                this.insertRowFromInfo(obj2, rs, "");
                this.afterHeadFill(rs, obj2);
                this.insertRowFromKDTable(rs, tables, obj2);
            }
            rs.beforeFirst();
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
            return null;
        }
        return rs;
    }

    protected IRowSet getDefaltRowSet(BOSQueryDataSource ds, String[] columns, String key) {
        IRowSet rs = null;
        try {
            if (this.dataCollection != null && this.dataCollection.size() == 1) {
                IObjectValue obj = this.dataCollection.getObject(0);
                List column = this.getAllKey(obj, "");
                column = this.beforeBuildColumn(column);
                rs = this.buildRowSet(column);
            } else if (this.dataCollection != null && this.dataCollection.size() > 1) {
                List column = this.putAllFieldsInColumn();
                column = this.beforeBuildColumn(column);
                rs = this.buildRowSet(column);
            } else {
                return rs;
            }
            rs.beforeFirst();
            for (int i = 0; i < this.dataCollection.size(); ++i) {
                IObjectValue obj = this.dataCollection.getObject(i);
                rs.moveToInsertRow();
                if (i > 0) {
                    this.clearRowSetOnContinuativePrint(rs);
                }
                this.insertRowFromInfo(obj, rs, "");
                this.afterHeadFill(rs, obj);
                this.insertRowFromInfo(rs, columns, obj, key);
            }
            rs.beforeFirst();
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
        }
        return rs;
    }

    private ArrayList putAllFieldsInColumn() {
        HashSet<String> set = new HashSet<String>();
        for (IObjectValue obj : this.dataCollection) {
            ArrayList column = this.getAllKey(obj, "");
            Iterator iterB = column.iterator();
            while (iterB.hasNext()) {
                set.add((String)iterB.next());
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        if (set != null && set.size() != 0) {
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                result.add((String)iter.next());
            }
        }
        return result;
    }

    private void clearRowSetOnContinuativePrint(IRowSet rs) throws SQLException {
        Iterator iter = this.allColumns.iterator();
        while (iter.hasNext()) {
            rs.updateString((String)iter.next(), "");
        }
    }

    protected List beforeBuildColumn(List columns) {
        return columns;
    }

    protected IRowSet buildRowSet(List columns) throws Exception {
        this.allColumns = columns;
        DynamicRowSet rs = new DynamicRowSet(columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            ColInfo ci;
            if ("attachmentImage".equals(columns.get(i).toString())) {
                ci = new ColInfo();
                ci.colType = -2;
                ci.columnName = columns.get(i).toString();
                ci.nullable = 1;
                rs.setColInfo(i + 1, ci);
                continue;
            }
            ci = new ColInfo();
            ci.colType = 12;
            ci.columnName = columns.get(i).toString();
            ci.nullable = 1;
            rs.setColInfo(i + 1, ci);
        }
        return rs;
    }

    protected void afterHeadFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
    }

    protected void afterDetailFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
    }

    protected ArrayList getAllKey(IObjectValue sourceInfo, String upper) {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration enumKeys = sourceInfo.keys();
        while (enumKeys.hasMoreElements()) {
            String key = enumKeys.nextElement().toString();
            Object info = sourceInfo.get(key);
            if (info instanceof IObjectCollection) {
                IObjectCollection collection = (IObjectCollection)info;
                if (collection.size() <= 0) continue;
                AbstractObjectValue baseInfo = (AbstractObjectValue)collection.getObject(0);
                if (this.hasSameKey(upper, key)) continue;
                result.addAll(this.getAllKey((IObjectValue)baseInfo, upper + key + "."));
                continue;
            }
            if (info instanceof IObjectValue) {
                if (this.hasSameKey(upper, key)) continue;
                IObjectValue baseInfo = (IObjectValue)info;
                result.addAll(this.getAllKey(baseInfo, upper + key + "."));
                continue;
            }
            result.add(upper + key);
        }
        return result;
    }

    protected boolean hasSameKey(String srcString, String key) {
        if (srcString == null || key == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(srcString, ".");
        while (st.hasMoreTokens()) {
            if (!st.nextToken().equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }

    protected void insertRowFromInfo(IRowSet rs, String[] columns, IObjectValue sourceInfo, String key) throws Exception {
        IObjectCollection collection = (IObjectCollection)sourceInfo.get(key);
        if (collection == null) {
            return;
        }
        if (collection.size() == 0) {
            rs.insertRow();
        }
        for (int count = 0; count < collection.size(); ++count) {
            IObjectValue obj = collection.getObject(count);
            if (count != 0) {
                rs.moveToInsertRow();
                this.insertRowFromInfo(sourceInfo, rs, "");
                this.afterHeadFill(rs, sourceInfo);
            }
            this.updateRowFromInfo(rs, columns, obj, key);
            rs.insertRow();
        }
    }

    protected void insertRowFromKDTable(IRowSet rs, KDTable[] tables, IObjectValue sourceInfo) throws Exception {
        for (int tableCount = 0; tableCount < tables.length; ++tableCount) {
            KDTable table = tables[tableCount];
            String key = "";
            if (table.getRowCount() == 0) {
                rs.insertRow();
            }
            int n = table.getRowCount();
            for (int i = 0; i < n; ++i) {
                IRow row = table.getRow(i);
                IObjectValue obj = (IObjectValue)row.getUserObject();
                if (i == 0) {
                    key = this.getEntryName(sourceInfo, obj, "");
                } else {
                    rs.moveToInsertRow();
                    this.insertRowFromInfo(sourceInfo, rs, "");
                    this.afterHeadFill(rs, sourceInfo);
                }
                this.updateRowFromKDTable(table, rs, row, obj, key);
                rs.insertRow();
            }
        }
    }

    protected String getEntryName(IObjectValue srcInfo, IObjectValue destInfo, String upper) {
        if (srcInfo.getClass().getName().equals(destInfo.getClass().getName())) {
            return upper;
        }
        Enumeration enumKeys = srcInfo.keys();
        String result = "";
        while (enumKeys.hasMoreElements()) {
            IObjectValue baseInfo;
            IObjectCollection collection;
            String key = enumKeys.nextElement().toString();
            Object info = srcInfo.get(key);
            if (info == null) continue;
            if (info.getClass().getName().equals(destInfo.getClass().getName())) {
                return upper + key;
            }
            if (!(info instanceof IObjectCollection) || (collection = (IObjectCollection)info).size() <= 0 || this.hasSameKey(upper, key) || (result = this.getEntryName(baseInfo = collection.getObject(0), destInfo, upper + key + ".")).trim().length() <= 0) continue;
            return result;
        }
        return result;
    }

    protected void updateRowFromInfo(IRowSet rs, String[] columns, IObjectValue sourceInfo, String key) throws Exception {
        int n = columns.length;
        for (int i = 0; i < n; ++i) {
            if (columns[i] == null || "".equals(columns[i])) continue;
            String[] subItems = StringUtils.split((String)columns[i], (String)".");
            IObjectValue subObj = sourceInfo;
            int l = subItems.length - 1;
            for (int k = 0; k < l && (subObj = (IObjectValue)subObj.get(subItems[k].toLowerCase())) != null; ++k) {
            }
            if (subObj == null) continue;
            try {
                rs.updateString(key.equals("") ? columns[i] : key + "." + columns[i].toLowerCase(), this.convertObject(subObj.get(subItems[subItems.length - 1])));
                continue;
            }
            catch (Exception ex) {
                this.logger.error((Object)("updateRowFromInfo(IRowSet rs, String[] columns, IObjectValue sourceInfo, String key)--" + new String(key.equals("") ? columns[i] : key + "." + columns[i].toLowerCase())));
                this.logger.error((Object)ex);
            }
        }
        this.afterDetailFill(rs, sourceInfo);
    }

    protected void updateRowFromKDTable(KDTable table, IRowSet rs, IRow row, IObjectValue sourceInfo, String key) throws Exception {
        int n = table.getColumnCount();
        for (int i = 0; i < n; ++i) {
            String bindField;
            if (table.getColumn(i).getFieldName() == null || StringUtils.isEmpty((String)(bindField = table.getColumn(i).getFieldName().toLowerCase()))) continue;
            try {
                if (row.getCell(i).getValue() != null) {
                    rs.updateString(key.equals("") ? bindField : key + bindField, this.convertObject(row.getCell(i).getValue()));
                    continue;
                }
                rs.updateString(key.equals("") ? bindField : key + bindField, "");
                continue;
            }
            catch (Exception ex) {
                this.logger.error((Object)("updateRowFromKDTable(KDTable table, IRowSet rs, IRow row, IObjectValue sourceInfo, String key)--" + new String(key.equals("") ? bindField : key + bindField)));
                this.logger.error((Object)ex);
            }
        }
        this.afterDetailFill(rs, sourceInfo);
    }

    protected String convertObject(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof Date) {
            return DateTimeUtils.format((Date)((Date)o), (String)"yyyy-MM-dd");
        }
        if (o instanceof Enum) {
            return ((Enum)o).getAlias();
        }
        return o.toString();
    }

    protected void insertRowFromInfo(IObjectValue sourceInfo, IRowSet rs, String upper) throws Exception {
        Enumeration enumKeys = sourceInfo.keys();
        while (enumKeys.hasMoreElements()) {
            String key = enumKeys.nextElement().toString();
            Object info = sourceInfo.get(key);
            if (info == null) continue;
            if (info instanceof IObjectCollection) {
                this.logger.info((Object)"do nothing");
                continue;
            }
            if (info instanceof IObjectValue) {
                if (this.hasSameKey(upper, key)) continue;
                IObjectValue baseInfo = (IObjectValue)info;
                this.insertRowFromInfo(baseInfo, rs, upper + key + ".");
                continue;
            }
            try {
                rs.updateString(upper + key, this.convertObject(info));
            }
            catch (Exception ex) {
                this.logger.error((Object)("insertRowFromInfo(IObjectValue sourceInfo, IRowSet rs, String upper)--" + upper + key));
                this.logger.error((Object)ex);
            }
        }
    }

    protected IObjectCollection getDataCollection() {
        return this.dataCollection;
    }

    protected void setDataCollection(IObjectCollection dataCollection) {
        this.dataCollection = dataCollection;
    }

    protected String getImageNumber(String bosType, String billID) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType));
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billID));
        BillImageMapCollection billImageMapCollection = BillImageMapFactory.getRemoteInstance().getBillImageMapCollection(view);
        if (billImageMapCollection != null && billImageMapCollection.size() > 0) {
            BillImageMapInfo billImageMapInfo = billImageMapCollection.get(0);
            return billImageMapInfo.getImageNumber();
        }
        return "";
    }
}

