/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.UIHelper;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolution;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QueryPanelTypeEnum;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.ShareTypeEnum;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CommonQueryPanel;
import com.kingdee.eas.base.commonquery.client.CommonQueryUI;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.IFilterPanel;
import com.kingdee.eas.base.commonquery.client.IQueryInfoPanel;
import com.kingdee.eas.base.commonquery.client.ISorterPanel;
import com.kingdee.eas.base.commonquery.client.QueryToolBar;
import com.kingdee.eas.base.commonquery.client.SolutionListPanel;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.fa.manage.client.SolutionPromptNoTypeUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ListModel;
import org.apache.log4j.Logger;

public class CommonQueryDialogWithoutToolBar
extends CommonQueryDialog {
    private static final Logger logger = Logger.getLogger(CommonQueryDialogWithoutToolBar.class);
    private CommonQueryPanel commonQueryPanel;
    private QueryToolBar queryToolBar;
    private KDWorkButton saveButton;
    private KDWorkButton saveAsButton;
    private KDWorkButton newButton;
    private KDWorkButton delButton;
    private KDList solutionList;
    private String currentSolutionName;
    private SolutionListPanel solutionListPanel;
    private static final String toolBarRes = "com.kingdee.eas.base.commonquery.client.ToolBar";
    private static final String className = "com.kingdee.eas.fi.fa.manage.FaCardResource";
    private QuerySolutionInfo currentQuerySolutionInfo;
    private KDCheckBox cbDefaultView;
    private static final String commonQueryRes = "com.kingdee.eas.base.commonquery.client.CommonQueryPanel";

    public CommonQueryDialogWithoutToolBar() {
        this.setShowShareType(2);
    }

    public ArrayList getUserPanels() {
        this.killCommonQueryToolBar();
        this.findQueryToolBarButton();
        this.initButtonListener();
        this.refreshSolutionList();
        QuerySolutionInfo querySolutionInfo = null;
        if (this.getSolutionList() != null) {
            querySolutionInfo = (QuerySolutionInfo)this.getSolutionList().getSelectedValue();
        }
        if (querySolutionInfo != null) {
            this.setCurrentSolution(querySolutionInfo);
            this.setCurrentSolutionName(querySolutionInfo.getName());
            if (EASResource.getString((String)commonQueryRes, (String)"sysDefaultRule").equals(this.solutionList.getSelectedValue().toString())) {
                this.getSaveButton().setEnabled(false);
                this.getDelButton().setEnabled(false);
            } else {
                this.getSaveButton().setEnabled(true);
                this.getDelButton().setEnabled(true);
            }
        }
        return super.getUserPanels();
    }

    private void killCommonQueryToolBar() {
        if (this.getToolBar() == null) {
            return;
        }
        for (int k = 0; k < this.getToolBar().getComponentCount(); ++k) {
            Component cToolBar = this.getToolBar().getComponent(k);
            if (!(cToolBar instanceof KDComboBox)) continue;
            KDComboBox shareTypeComboBox = (KDComboBox)cToolBar;
            shareTypeComboBox.setVisible(false);
        }
        if (this.getDefaultViewBox() != null) {
            this.getDefaultViewBox().setVisible(true);
        }
    }

    private CommonQueryUI getCommonQueryUI() {
        return (CommonQueryUI)this.getWindow().getUIObject();
    }

    private CommonQueryPanel getCommonQueryPanel() {
        if (this.commonQueryPanel == null) {
            for (int i = 0; i < this.getCommonQueryUI().getComponentCount(); ++i) {
                Component cUI = this.getCommonQueryUI().getComponent(i);
                if (!(cUI instanceof CommonQueryPanel)) continue;
                this.commonQueryPanel = (CommonQueryPanel)cUI;
            }
        }
        return this.commonQueryPanel;
    }

    private QueryToolBar getToolBar() {
        if (this.queryToolBar == null) {
            for (int j = 0; j < this.getCommonQueryPanel().getComponentCount(); ++j) {
                Component cPanel = this.getCommonQueryPanel().getComponent(j);
                if (!(cPanel instanceof QueryToolBar)) continue;
                this.queryToolBar = (QueryToolBar)cPanel;
            }
        }
        return this.queryToolBar;
    }

    private KDCheckBox getDefaultViewBox() {
        if (this.cbDefaultView == null) {
            for (int j = 0; j < this.getCommonQueryPanel().getComponentCount(); ++j) {
                Component cPanel = this.getCommonQueryPanel().getComponent(j);
                if (!(cPanel instanceof KDCheckBox)) continue;
                this.cbDefaultView = (KDCheckBox)cPanel;
            }
        }
        return this.cbDefaultView;
    }

    private void findQueryToolBarButton() {
        if (this.getToolBar() == null) {
            return;
        }
        for (int i = 0; i < this.getToolBar().getComponentCount(); ++i) {
            Component c = this.getToolBar().getComponent(i);
            if (c instanceof KDWorkButton && ((KDWorkButton)c).getToolTipText().equals(EASResource.getString((String)toolBarRes, (String)"save"))) {
                this.saveButton = (KDWorkButton)c;
            }
            if (c instanceof KDWorkButton && ((KDWorkButton)c).getToolTipText().equals(EASResource.getString((String)toolBarRes, (String)"saveAs"))) {
                this.saveAsButton = (KDWorkButton)c;
            }
            if (c instanceof KDWorkButton && ((KDWorkButton)c).getToolTipText().equals(EASResource.getString((String)toolBarRes, (String)"new"))) {
                this.newButton = (KDWorkButton)c;
            }
            if (!(c instanceof KDWorkButton) || !((KDWorkButton)c).getToolTipText().equals(EASResource.getString((String)toolBarRes, (String)"del"))) continue;
            this.delButton = (KDWorkButton)c;
        }
    }

    private void initButtonListener() {
        ActionListener listener;
        int i;
        if (this.getSaveButton() == null) {
            return;
        }
        for (i = 0; i < this.getSaveButton().getActionListeners().length; ++i) {
            listener = this.getSaveButton().getActionListeners()[i];
            this.getSaveButton().removeActionListener(listener);
        }
        this.getSaveButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonQueryDialogWithoutToolBar.this.saveButton_ActionPerformed();
            }
        });
        for (i = 0; i < this.getSaveAsButton().getActionListeners().length; ++i) {
            listener = this.getSaveAsButton().getActionListeners()[i];
            this.getSaveAsButton().removeActionListener(listener);
        }
        this.getSaveAsButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonQueryDialogWithoutToolBar.this.saveAsButton_ActionPerformed();
            }
        });
        for (i = 0; i < this.getNewButton().getActionListeners().length; ++i) {
            listener = this.getNewButton().getActionListeners()[i];
            this.getNewButton().removeActionListener(listener);
        }
        this.getNewButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonQueryDialogWithoutToolBar.this.newButton_ActionPerformed();
            }
        });
        for (i = 0; i < this.getDelButton().getActionListeners().length; ++i) {
            listener = this.getDelButton().getActionListeners()[i];
            this.getDelButton().removeActionListener(listener);
        }
        this.getDelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonQueryDialogWithoutToolBar.this.delButton_ActionPerformed();
                if (EASResource.getString((String)CommonQueryDialogWithoutToolBar.commonQueryRes, (String)"sysDefaultRule").equals(CommonQueryDialogWithoutToolBar.this.getSolutionList().getSelectedValue().toString())) {
                    CommonQueryDialogWithoutToolBar.this.getSaveButton().setEnabled(false);
                    CommonQueryDialogWithoutToolBar.this.getDelButton().setEnabled(false);
                } else {
                    CommonQueryDialogWithoutToolBar.this.getSaveButton().setEnabled(true);
                    CommonQueryDialogWithoutToolBar.this.getDelButton().setEnabled(true);
                }
            }
        });
        this.getSolutionList();
    }

    private void newButton_ActionPerformed() {
        this.resetUserPanels();
        this.setCurrentSolution(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveAsButton_ActionPerformed() {
        CommonQueryPanel queryPanel = this.getCommonQueryPanel();
        if (!queryPanel.verify() || !this.showSolutionDialog()) return;
        String sameNameSolutionID = this.getSameNameSolutionID();
        if (sameNameSolutionID != null) {
            int flag;
            String sameNameSolutionName = null;
            QuerySolutionInfo info = null;
            try {
                info = QuerySolutionFactory.getRemoteInstance().getQuerySolutionInfo((IObjectPK)new ObjectUuidPK(sameNameSolutionID));
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            if (info != null) {
                sameNameSolutionName = info.getName();
                if (sameNameSolutionID != null && sameNameSolutionName != null && EASResource.getString((String)commonQueryRes, (String)"sysDefaultRule").equals(sameNameSolutionName)) {
                    MsgBox.showInfo((Component)this.getToolBar(), (String)EASResource.getString((String)commonQueryRes, (String)"CanNotOverDefaultSolution"));
                    SysUtil.abort();
                }
            }
            if ((flag = MsgBox.showConfirm2((Component)this.getToolBar(), (String)EASResource.getString((String)toolBarRes, (String)"solutionNameExist"))) != 0) return;
            if (!this.editSolution(sameNameSolutionID)) return;
            MsgBox.showInfo((Component)this.getToolBar(), (String)EASResource.getString((String)toolBarRes, (String)"overwriteSolutionSucceed"));
            this.refreshSolutionList();
            this.setSolutionListSelected(this.getCurrentQuerySolutionInfo());
            return;
        }
        if (this.addSolution()) {
            MsgBox.showWarning((String)EASResource.getString((String)toolBarRes, (String)"saveAsSolutionSucceed"));
            this.refreshSolutionList();
            this.setSolutionListSelected(this.getCurrentQuerySolutionInfo());
            return;
        }
        this.refreshSolutionList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveButton_ActionPerformed() {
        CommonQueryPanel queryPanel = this.getCommonQueryPanel();
        if (!queryPanel.verify()) return;
        if (this.getCurrentQuerySolutionInfo() == null) {
            if (!this.showSolutionDialog()) return;
            String sameNameSolutionID = this.getSameNameSolutionID();
            if (sameNameSolutionID != null) {
                int flag = MsgBox.showConfirm2((Component)this.getToolBar(), (String)EASResource.getString((String)toolBarRes, (String)"solutionNameExist"));
                if (flag != 0) return;
                if (!this.editSolution(sameNameSolutionID)) return;
                MsgBox.showInfo((Component)this.getToolBar(), (String)EASResource.getString((String)toolBarRes, (String)"overwriteSolutionSucceed"));
                this.refreshSolutionList();
                this.setSolutionListSelected(this.getCurrentQuerySolutionInfo());
                return;
            }
            if (!this.addSolution()) return;
            MsgBox.showWarning((String)EASResource.getString((String)toolBarRes, (String)"saveSolutionSucceed"));
            this.refreshSolutionList();
            this.setSolutionListSelected(this.getCurrentQuerySolutionInfo());
            return;
        }
        if (!this.editSolution(this.getCurrentQuerySolutionInfo().getId().toString())) return;
        MsgBox.showWarning((String)EASResource.getString((String)toolBarRes, (String)"saveSolutionSucceed"));
        this.refreshSolutionList();
        this.setSolutionListSelected(this.getCurrentQuerySolutionInfo());
    }

    private void delButton_ActionPerformed() {
        QuerySolutionInfo delSolution = (QuerySolutionInfo)this.getSolutionList().getSelectedValue();
        if (delSolution == null) {
            MsgBox.showWarning((String)EASResource.getString((String)toolBarRes, (String)"chooseSolutionWarning"));
            return;
        }
        int flag = MsgBox.showConfirm2((Component)this.getToolBar(), (String)EASResource.getString((String)toolBarRes, (String)"delWarning"));
        if (flag == 0) {
            if (this.delSolution(delSolution.getId().toString())) {
                MsgBox.showWarning((String)EASResource.getString((String)toolBarRes, (String)"delSolutionSucceed"));
                this.refreshSolutionList();
                return;
            }
            MsgBox.showWarning((String)EASResource.getString((String)toolBarRes, (String)"delSolutionWarning"));
            this.refreshSolutionList();
            this.setSolutionListSelected(delSolution);
            return;
        }
    }

    private boolean showSolutionDialog() {
        boolean isConfirm = false;
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"TOOLBAR", (Object)this.getToolBar());
        IUIWindow showWindow = null;
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            showWindow = uiFactory.create(SolutionPromptNoTypeUI.class.getName(), (Map)uiContext, null, "");
            showWindow.show();
            isConfirm = 0 == ((SolutionPromptNoTypeUI)showWindow.getUIObject()).getWindowType();
            this.setCurrentSolutionName(((SolutionPromptNoTypeUI)showWindow.getUIObject()).getInputSolutionName());
            return isConfirm;
        }
        catch (UIException e) {
            return isConfirm;
        }
    }

    private String getCurrentSolutionName() {
        return this.currentSolutionName;
    }

    private void setCurrentSolutionName(String name) {
        this.currentSolutionName = name;
    }

    private String getSameNameSolutionID() {
        String queryName = "com.kingdee.eas.fi.fa.manage.FaChangeBillQuery";
        String parentUI = this.getParentUI();
        String orgID = this.getOrgID();
        ShareTypeEnum shareType = ShareTypeEnum.ORG_LEVEL;
        String saveAsName = this.getCurrentSolutionName();
        try {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("queryObjectName", (Object)queryName));
            filterInfo.getFilterItems().add(new FilterItemInfo("parentUIName", (Object)parentUI));
            filterInfo.getFilterItems().add(new FilterItemInfo("shareType", (Object)String.valueOf(shareType.getValue())));
            filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)saveAsName));
            if (orgID != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("orgID", (Object)orgID));
                filterInfo.setMaskString(" #0 AND #1 AND #2 AND #3 AND #4");
            } else {
                filterInfo.setMaskString(" #0 AND #1 AND #2 AND #3");
            }
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.setFilter(filterInfo);
            IQuerySolution iQuerySolution = QuerySolutionFactory.getRemoteInstance();
            IObjectPK[] objectPKs = iQuerySolution.getPKList(entityViewInfo.toString());
            if (objectPKs != null && objectPKs.length > 0) {
                return objectPKs[0].toString();
            }
            return null;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    protected String getOrgID() {
        CompanyOrgUnitInfo defCompany = SysContext.getSysContext().getCurrentFIUnit();
        if (defCompany != null) {
            return defCompany.getId().toString();
        }
        return null;
    }

    protected BOSUuid getOwner() {
        BOSUuid owner = SysContext.getSysContext().getCurrentUserInfo().getId();
        return owner;
    }

    private QuerySolutionInfo getQuerySolutionInfo(QuerySolutionInfo querySolutionInfo) {
        if (querySolutionInfo == null) {
            querySolutionInfo = new QuerySolutionInfo();
        }
        CommonQueryPanel queryPanel = this.getCommonQueryPanel();
        BOSUuid owner = this.getOwner();
        String name = this.getCurrentSolutionName();
        BOSUuid orgID = null;
        if (this.getOrgID() != null) {
            orgID = BOSUuid.read((String)this.getOrgID());
        }
        String queryObjectName = "com.kingdee.eas.fi.fa.manage.FaChangeBillQuery";
        ShareTypeEnum shareType = ShareTypeEnum.ORG_LEVEL;
        querySolutionInfo.setOwner(owner);
        querySolutionInfo.setName(name);
        querySolutionInfo.setOrgID(orgID);
        querySolutionInfo.setQueryObjectName(queryObjectName);
        querySolutionInfo.setEntityViewInfo(queryPanel.getEntityViewInfo().toString());
        querySolutionInfo.setLockedEntityViewInfo(queryPanel.getLockedEntityViewInfo().toString());
        querySolutionInfo.setShareType(shareType);
        querySolutionInfo.setSolutionType(SolutionTypeEnum.CUSTOMER_SOLUTION);
        querySolutionInfo.setParentUIName(this.getParentUI());
        QueryPanelCollection queryPanelCollection = new QueryPanelCollection();
        String panelName = null;
        String panelClassName = null;
        String filterInfo = "";
        String sorterInfo = "";
        QueryPanelTypeEnum queryPanelType = null;
        for (Object object : queryPanel.getCustomerQueryPanel()) {
            FilterInfo temp;
            QueryPanelInfo queryPanelInfo = new QueryPanelInfo();
            if (object == null) continue;
            String customerParams = null;
            if (object instanceof IQueryInfoPanel) {
                CustomerParams custParams;
                IQueryInfoPanel iQueryInfoPanel = (IQueryInfoPanel)object;
                panelName = iQueryInfoPanel.getPanelName();
                panelClassName = object.getClass().getName();
                if (iQueryInfoPanel.getSorterItems() != null) {
                    String oql = EntityViewInfo.toOQL((SorterItemCollection)iQueryInfoPanel.getSorterItems());
                    if (!(oql == null || oql.trim().equalsIgnoreCase("") || oql.indexOf("ORDER") != -1 && oql.indexOf("order") != -1)) {
                        oql = "ORDER BY " + oql;
                    }
                    sorterInfo = oql;
                }
                if (iQueryInfoPanel.getFilterInfo() != null) {
                    filterInfo = iQueryInfoPanel.getFilterInfo().toString();
                }
                if ((custParams = iQueryInfoPanel.getCustomerParams()) != null) {
                    Collection keys = custParams.getKeys();
                    Collection values = custParams.getValues();
                    if (keys.size() > 0) {
                        try {
                            customerParams = XMLBean.CreateXMLStrRecursion((Collection)keys, (Collection)values);
                        }
                        catch (Exception ex) {
                            MsgBox.showInfo((String)ex.getMessage());
                        }
                    }
                }
                queryPanelType = QueryPanelTypeEnum.CUSTOMER_PANEL;
            } else if (object instanceof IFilterPanel) {
                IFilterPanel iFilterPanel = (IFilterPanel)object;
                panelName = iFilterPanel.getPanelName();
                panelClassName = object.getClass().getName();
                temp = queryPanel.getCommonFilterPanel().getFilterInfo();
                if (queryPanel.getCommonFilterPanel().getFilterInfo() != null) {
                    filterInfo = temp.toString();
                }
                queryPanelType = QueryPanelTypeEnum.FILTER_PANEL;
            } else if (object instanceof ISorterPanel) {
                ISorterPanel iSorterPanel = (ISorterPanel)object;
                panelName = iSorterPanel.getPanelName();
                panelClassName = object.getClass().getName();
                temp = queryPanel.getCommonSorterPanel().getSorterItems();
                if (temp != null) {
                    String oql = EntityViewInfo.toOQL((SorterItemCollection)temp);
                    if (!(oql == null || oql.trim().equalsIgnoreCase("") || oql.indexOf("ORDER") != -1 && oql.indexOf("order") != -1)) {
                        oql = "ORDER BY " + oql;
                    }
                    sorterInfo = oql;
                }
                queryPanelType = QueryPanelTypeEnum.SORTER_PANEL;
            }
            queryPanelInfo.setPanelName(panelName);
            queryPanelInfo.setPanelClassName(panelClassName);
            queryPanelInfo.setFilterInfo(filterInfo);
            queryPanelInfo.setSorterInfo(sorterInfo);
            queryPanelInfo.setCustomerParams(customerParams);
            queryPanelInfo.setQueryPanelType(queryPanelType);
            queryPanelCollection.add(queryPanelInfo);
        }
        querySolutionInfo.getQueryPanelInfo().clear();
        querySolutionInfo.getQueryPanelInfo().addCollection(queryPanelCollection);
        return querySolutionInfo;
    }

    private String getParentUI() {
        String parentClass = this.getCommonQueryParam() == null ? "com.kingdee.eas.fi.fa.manage.client.FaContrastUI" : this.getCommonQueryParam().getParentUIClassName();
        return parentClass;
    }

    private boolean isSolutionOwner(QuerySolutionInfo solutionInfo) {
        return solutionInfo.getOwner().equals((Object)this.getOwner());
    }

    private boolean canSave(QuerySolutionInfo newSolutionInfo) throws Exception {
        if (newSolutionInfo != null) {
            QueryPanelCollection newQueryPanelCollection = newSolutionInfo.getQueryPanelInfo();
            QueryPanelInfo newQueryPanelInfo = newQueryPanelCollection.get(0);
            CustomerParams cp = XMLBean.TransStrToCustParams((String)newQueryPanelInfo.getCustomerParams());
            boolean newIsDefaultSolution = cp.getBoolean("IsDefaultSolution");
            for (int i = 0; i < this.getSolutionList().getElementCount(); ++i) {
                QuerySolutionInfo savedSolutionInfo = (QuerySolutionInfo)this.getSolutionList().getElement(i);
                QueryPanelCollection savedQueryPanelCollection = savedSolutionInfo.getQueryPanelInfo();
                if (savedSolutionInfo.getId() != null && newSolutionInfo.getId() != null && savedSolutionInfo.getId().toString().equalsIgnoreCase(newSolutionInfo.getId().toString())) continue;
                QueryPanelInfo savedQueryPanelInfo = savedQueryPanelCollection.get(0);
                boolean savedIsDefaultSolution = false;
                if (savedQueryPanelInfo != null && savedQueryPanelInfo.getCustomerParams() != null) {
                    CustomerParams savedLoadInfo = XMLBean.TransStrToCustParams((String)savedQueryPanelInfo.getCustomerParams());
                    savedIsDefaultSolution = savedLoadInfo.getBoolean("IsDefaultSolution");
                }
                if (!newIsDefaultSolution || !savedIsDefaultSolution) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean editSolution(String solutionID) {
        try {
            IQuerySolution iQuerySolution = QuerySolutionFactory.getRemoteInstance();
            QuerySolutionInfo querySolutionInfo = iQuerySolution.getQuerySolutionInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)solutionID)));
            if (!this.isSolutionOwner(querySolutionInfo)) {
                MsgBox.showInfo((Component)this.getToolBar(), (String)EASResource.getString((String)toolBarRes, (String)"saveOtherSolutionFail"));
                this.refreshSolutionList();
                return false;
            }
            if (!this.canSave(querySolutionInfo = this.getQuerySolutionInfo(querySolutionInfo))) {
                MsgBox.showError((Component)this.getToolBar(), (String)EASResource.getString((String)className, (String)"CommonQueryDialogWithoutToolBar_HasDefault"));
                return false;
            }
            if (this.cbDefaultView.isSelected()) {
                for (int i = 0; i < this.getSolutionList().getElementCount(); ++i) {
                    QuerySolutionInfo savedSolutionInfo = (QuerySolutionInfo)this.getSolutionList().getElement(i);
                    if (savedSolutionInfo.getId() != null && querySolutionInfo.getId() != null && savedSolutionInfo.getId().toString().equalsIgnoreCase(querySolutionInfo.getId().toString()) || !savedSolutionInfo.isIsUserDefaultSolu()) continue;
                    savedSolutionInfo.setIsUserDefaultSolu(false);
                    iQuerySolution.update((IObjectPK)new ObjectUuidPK(savedSolutionInfo.getId()), (CoreBaseInfo)savedSolutionInfo);
                    querySolutionInfo.setIsUserDefaultSolu(true);
                    break;
                }
                querySolutionInfo.setIsUserDefaultSolu(true);
            } else {
                querySolutionInfo.setIsUserDefaultSolu(false);
            }
            this.setMutiLangSolutionName(querySolutionInfo);
            iQuerySolution.update((IObjectPK)new ObjectUuidPK(querySolutionInfo.getId()), (CoreBaseInfo)querySolutionInfo);
            this.setCurrentSolution(querySolutionInfo);
            return true;
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)this.getToolBar(), (String)EASResource.getString((String)toolBarRes, (String)"saveSolutionFail"), (Throwable)e);
            return false;
        }
    }

    protected boolean addSolution() {
        try {
            IQuerySolution iQuerySolution = QuerySolutionFactory.getRemoteInstance();
            QuerySolutionInfo querySolutionInfo = this.getQuerySolutionInfo(null);
            if (!this.canSave(querySolutionInfo)) {
                MsgBox.showError((Component)this.getToolBar(), (String)EASResource.getString((String)className, (String)"CommonQueryDialogWithoutToolBar_HasDefault"));
                return false;
            }
            this.setMutiLangSolutionName(querySolutionInfo);
            IObjectPK objectPK = iQuerySolution.addnew((CoreBaseInfo)querySolutionInfo);
            querySolutionInfo.setId(BOSUuid.read((String)objectPK.toString()));
            this.setCurrentSolution(querySolutionInfo);
            return true;
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)this.getToolBar(), (String)EASResource.getString((String)toolBarRes, (String)"saveSolutionFail"), (Throwable)e);
            return false;
        }
    }

    private boolean delSolution(String solutionID) {
        try {
            IQuerySolution iQuerySolution = QuerySolutionFactory.getRemoteInstance();
            ObjectUuidPK iObjectPK = new ObjectUuidPK(solutionID);
            iQuerySolution.delete((IObjectPK)iObjectPK);
            this.setCurrentSolution(null);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected QuerySolutionCollection getQuerySolutions(ShareTypeEnum shareType) {
        String queryName = "com.kingdee.eas.fi.fa.manage.FaChangeBillQuery";
        String parentUI = this.getParentUI();
        String orgID = this.getOrgID();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("queryObjectName", (Object)queryName));
        filterInfo.getFilterItems().add(new FilterItemInfo("parentUIName", (Object)parentUI));
        filterInfo.getFilterItems().add(new FilterItemInfo("shareType", (Object)String.valueOf(shareType.getValue())));
        if (orgID != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("orgID", (Object)orgID));
            filterInfo.setMaskString(" #0 AND #1 AND #2 AND #3");
        } else {
            filterInfo.setMaskString(" #0 AND #1 AND #2 ");
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        QuerySolutionCollection querySolutionCollection = null;
        try {
            IQuerySolution iQuerySolution = QuerySolutionFactory.getRemoteInstance();
            querySolutionCollection = iQuerySolution.getQuerySolutionCollection(entityViewInfo);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)this.getToolBar(), (Throwable)e);
        }
        return querySolutionCollection;
    }

    protected void refreshSolutionList() {
        ShareTypeEnum shareType = ShareTypeEnum.ORG_LEVEL;
        QuerySolutionCollection querySolutionCollection = this.getQuerySolutions(shareType);
        int size = querySolutionCollection.size();
        Icon icon = EASResource.getIcon((String)"imgTree_public");
        if (this.getSolutionList() == null) {
            return;
        }
        int preSelectIndex = this.getSolutionList().getSelectedIndex();
        this.getSolutionList().removeAllElements();
        int j = -1;
        for (int i = 0; i < size; ++i) {
            this.getSolutionList().addElement((Object)querySolutionCollection.get(i));
            this.getSolutionList().setElementIcon(icon, i);
            if (!querySolutionCollection.get(i).isIsUserDefaultSolu()) continue;
            j = i;
        }
        if (j != -1) {
            this.getSolutionList().setSelectedIndex(j);
        } else {
            this.getSolutionList().setSelectedIndex(preSelectIndex >= 0 && size >= preSelectIndex + 1 ? preSelectIndex : (size > 0 ? 0 : -1));
        }
    }

    private SolutionListPanel getSolutionListPanel() {
        if (this.solutionListPanel == null) {
            for (int i = 0; i < this.getCommonQueryPanel().getComponentCount(); ++i) {
                Component c = this.getCommonQueryPanel().getComponent(i);
                if (!(c instanceof SolutionListPanel)) continue;
                this.solutionListPanel = (SolutionListPanel)c;
            }
        }
        return this.solutionListPanel;
    }

    private KDList getSolutionList() {
        if (this.solutionList == null && this.getSolutionListPanel() != null) {
            for (int j = 0; j < this.getSolutionListPanel().getComponentCount(); ++j) {
                Component c_solution = this.getSolutionListPanel().getComponent(j);
                if (!(c_solution instanceof KDScrollPane)) continue;
                KDScrollPane scrollPane = (KDScrollPane)c_solution;
                for (int k = 0; k < scrollPane.getViewport().getComponentCount(); ++k) {
                    Component c_scrollPane = scrollPane.getViewport().getComponent(k);
                    if (!(c_scrollPane instanceof KDList)) continue;
                    this.solutionList = (KDList)c_scrollPane;
                }
            }
            this.solutionList.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    try {
                        QuerySolutionInfo querySolutionInfo;
                        if (e.getClickCount() == 1 && (querySolutionInfo = (QuerySolutionInfo)CommonQueryDialogWithoutToolBar.this.getSolutionList().getSelectedValue()) != null) {
                            CommonQueryDialogWithoutToolBar.this.setCurrentSolution(querySolutionInfo);
                            CommonQueryDialogWithoutToolBar.this.setCurrentSolutionName(querySolutionInfo.getName());
                            if (EASResource.getString((String)CommonQueryDialogWithoutToolBar.commonQueryRes, (String)"sysDefaultRule").equals(CommonQueryDialogWithoutToolBar.this.solutionList.getSelectedValue().toString())) {
                                CommonQueryDialogWithoutToolBar.this.getSaveButton().setEnabled(false);
                                CommonQueryDialogWithoutToolBar.this.getDelButton().setEnabled(false);
                            } else {
                                CommonQueryDialogWithoutToolBar.this.getSaveButton().setEnabled(true);
                                CommonQueryDialogWithoutToolBar.this.getDelButton().setEnabled(true);
                            }
                        }
                    }
                    catch (Exception e1) {
                        ExceptionHandler.handle((Throwable)e1);
                    }
                }
            });
            this.solutionList.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    QuerySolutionInfo querySolutionInfo;
                    int keyCode = e.getKeyCode();
                    if ((keyCode == 38 || keyCode == 40) && (querySolutionInfo = (QuerySolutionInfo)CommonQueryDialogWithoutToolBar.this.getSolutionList().getSelectedValue()) != null) {
                        CommonQueryDialogWithoutToolBar.this.setCurrentSolution(querySolutionInfo);
                        CommonQueryDialogWithoutToolBar.this.setCurrentSolutionName(querySolutionInfo.getName());
                        if (EASResource.getString((String)CommonQueryDialogWithoutToolBar.commonQueryRes, (String)"sysDefaultRule").equals(CommonQueryDialogWithoutToolBar.this.solutionList.getSelectedValue().toString())) {
                            CommonQueryDialogWithoutToolBar.this.getSaveButton().setEnabled(false);
                            CommonQueryDialogWithoutToolBar.this.getDelButton().setEnabled(false);
                        } else {
                            CommonQueryDialogWithoutToolBar.this.getSaveButton().setEnabled(true);
                            CommonQueryDialogWithoutToolBar.this.getDelButton().setEnabled(true);
                        }
                    }
                }
            });
        }
        return this.solutionList;
    }

    protected void setSolutionListSelected(QuerySolutionInfo info) {
        if (info != null) {
            ListModel model = this.getSolutionList().getModel();
            int size = model.getSize();
            for (int i = 0; i < size; ++i) {
                QuerySolutionInfo solutionInfo = (QuerySolutionInfo)model.getElementAt(i);
                if (!solutionInfo.getId().equals((Object)info.getId())) continue;
                this.getSolutionList().setSelectedIndex(i);
            }
        }
    }

    private void resetUserPanels() {
        CommonQueryPanel queryPanel = this.getCommonQueryPanel();
        ArrayList panels = queryPanel.getCustomerQueryPanel();
        for (KDPanel tempPanel : panels) {
            if (!(tempPanel instanceof IQueryInfoPanel)) continue;
            ((IQueryInfoPanel)tempPanel).clear();
        }
    }

    private void setCurrentSolution(QuerySolutionInfo info) {
        this.currentQuerySolutionInfo = info;
    }

    private QuerySolutionInfo getCurrentQuerySolutionInfo() {
        return this.currentQuerySolutionInfo;
    }

    private KDWorkButton getSaveAsButton() {
        return this.saveAsButton;
    }

    private KDWorkButton getSaveButton() {
        return this.saveButton;
    }

    private KDWorkButton getNewButton() {
        return this.newButton;
    }

    private KDWorkButton getDelButton() {
        return this.delButton;
    }

    private void setMutiLangSolutionName(QuerySolutionInfo querySolutionInfo) {
        KDBizMultiLangBox solutionNameTextField = new KDBizMultiLangBox();
        List langList = KDBizMultiLangBox.getLanguageList();
        for (int i = 0; i < langList.size(); ++i) {
            if (!SysContext.getSysContext().getLocale().toString().equalsIgnoreCase(((LanguageInfo)langList.get(i)).getLocale().toString())) continue;
            solutionNameTextField.setSelectedLanguage((LanguageInfo)langList.get(i));
        }
        solutionNameTextField.getEditor().setItem(this.currentSolutionName);
        UIHelper.storeMultiLangFields((KDMultiLangBox)solutionNameTextField, (IObjectValue)querySolutionInfo, (String)"name");
    }

    public static QuerySolutionInfo getDefSolutionInfo() throws Exception {
        IQuerySolution iQuerySolution = QuerySolutionFactory.getRemoteInstance();
        String queryName = "com.kingdee.eas.fi.fa.manage.FaChangeBillQuery";
        BOSUuid orgID = Util.getOrgID((String)queryName);
        String parentUIName = "com.kingdee.eas.fi.fa.manage.client.FaContrastUI";
        ShareTypeEnum currentShareType = ShareTypeEnum.ORG_LEVEL;
        QuerySolutionCollection querySolutionCollection = iQuerySolution.getQuerySolutions(orgID.toString(), queryName, parentUIName, currentShareType);
        for (int i = 0; i < querySolutionCollection.size(); ++i) {
            QuerySolutionInfo solutionInfo = querySolutionCollection.get(i);
            if (!solutionInfo.isIsUserDefaultSolu()) continue;
            return solutionInfo;
        }
        return null;
    }
}

