/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CommonQueryPanel;
import com.kingdee.eas.base.commonquery.client.CommonQueryUI;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.fi.fa.basedata.FaContractCatInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillNewCollection;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.fa.manage.FaLessorTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaRentDirectionEnum;
import com.kingdee.eas.fi.fa.manage.client.FaCardFilterProcessor;
import com.kingdee.eas.fi.fa.manage.client.FaGenLeaseComQueryPanelHelper;
import com.kingdee.eas.fi.fa.manage.client.FaLeaseFilterAdapter;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class CommonQueryLeaseDialog
extends CommonQueryDialog {
    private static final Logger logger = Logger.getLogger(CommonQueryLeaseDialog.class);
    private FaCardFilterProcessor cardFilter = null;
    private Component owner;
    private FaRentDirectionEnum rentDirection = FaRentDirectionEnum.RENT_IN;

    public CommonQueryLeaseDialog() throws Exception {
        this(new FilterInfo(), true);
    }

    public CommonQueryLeaseDialog(FilterInfo filterInfo) throws Exception {
        this(filterInfo, false);
    }

    public CommonQueryLeaseDialog(FilterInfo filterInfo, boolean isUseDefaultFilter) throws Exception {
        this.cardFilter = new FaLeaseFilterAdapter();
        this.cardFilter.setUseDefaultFilter(isUseDefaultFilter);
        this.cardFilter.setFilterInfo(filterInfo);
        ((FaLeaseFilterAdapter)this.cardFilter).setRentDirection(this.rentDirection);
        this.setLeftPanelHeight(229);
    }

    public CommonQueryLeaseDialog(FaCardFilterProcessor cardFilter) {
        this.cardFilter = cardFilter;
    }

    public boolean show() {
        if (this.getOwner() != null && this.getOwner() instanceof IUIObject) {
            IUIObject o = (IUIObject)this.getOwner();
            int height = o.getUIContentPane().getHeight();
            if (this.getCommonQueryParam().getHeight() > height) {
                this.getCommonQueryParam().setHeight(height);
            }
        }
        return super.show();
    }

    public void setOwner(Component component) {
        super.setOwner(component);
        this.owner = component;
    }

    public ArrayList getUserPanels() {
        CommonQueryUI queryUI = (CommonQueryUI)this.getWindow().getUIObject();
        for (int i = 0; i < queryUI.getComponentCount(); ++i) {
            Component c = queryUI.getComponent(i);
            if (!(c instanceof CommonQueryPanel)) continue;
            try {
                FaGenLeaseComQueryPanelHelper.getInstance().setRentDirection(this.rentDirection);
                FaGenLeaseComQueryPanelHelper.getInstance().genCustomQueryPanel((CommonQueryPanel)c);
                FaGenLeaseComQueryPanelHelper.getInstance().setResultPanelTitle(this.cardFilter.getResultPanelTitle());
                FaGenLeaseComQueryPanelHelper.getInstance().setCardFilter(this.cardFilter);
                FaGenLeaseComQueryPanelHelper.getInstance().setCommonQueryParam(this.getCommonQueryParam());
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return super.getUserPanels();
    }

    public Object getKeyValue() {
        return this.getEntityViewInfoResult().get("leaseBill");
    }

    public boolean hasKeyValue() {
        return this.getKeyValue() != null && this.getSearchResult() != null && this.getSearchResult().size() > 0;
    }

    public void setSelectMode(int mode) {
        this.cardFilter.setSelectMode(mode);
    }

    public void setResultPanelTitle(String title) {
        this.cardFilter.setResultPanelTitle(title);
    }

    public ArrayList getSearchResult() {
        return (ArrayList)this.getEntityViewInfoResult().get("Query_ResultSet");
    }

    public IObjectCollection getSelectedLeaseBillCol() {
        FaLeaseInBillNewCollection result = null;
        ArrayList list = this.getSearchResult();
        int size = list.size();
        if (this.rentDirection == FaRentDirectionEnum.RENT_IN) {
            result = new FaLeaseInBillNewCollection();
            for (int i = 0; i < size; ++i) {
                IRow row = (IRow)list.get(i);
                if (row == null) continue;
                FaLeaseInBillNewInfo leaseInBillInfo = new FaLeaseInBillNewInfo();
                leaseInBillInfo.setId(BOSUuid.read((String)this.getStrFromCell(row, "id")));
                leaseInBillInfo.setNumber(this.getStrFromCell(row, "number"));
                leaseInBillInfo.setContractNumber(this.getStrFromCell(row, "contractNumber"));
                leaseInBillInfo.setContractName(this.getStrFromCell(row, "contractName"));
                leaseInBillInfo.setLessor(this.getStrFromCell(row, "lessor"));
                leaseInBillInfo.setLessorType(this.getEnumFromCell(row, "lessorType"));
                leaseInBillInfo.setInitialAsset(this.getBDFromCell(row, "initialAsset"));
                leaseInBillInfo.setInitialLiability(this.getBDFromCell(row, "initialLiability"));
                leaseInBillInfo.setUnrecognizedFinanceFee(this.getBDFromCell(row, "unrecognizedFinanceFee"));
                leaseInBillInfo.setInitialAssetDecValue(this.getBDFromCell(row, "initialAssetDecValue"));
                try {
                    leaseInBillInfo.setContractCat(this.getObjFromCell(row, "contractCat", FaContractCatInfo.class));
                    leaseInBillInfo.setUseDepartment(this.getObjFromCell(row, "useDepartment", AdminOrgUnitInfo.class));
                    leaseInBillInfo.setCostCenter(this.getObjFromCell(row, "costCenter", CostCenterOrgUnitInfo.class));
                    leaseInBillInfo.setInnerCompanyLessor(this.getObjFromCell(row, "innerCompanyLessor", CompanyOrgUnitInfo.class));
                    leaseInBillInfo.setCustomerLessor(this.getObjFromCell(row, "customerLessor", CustomerInfo.class));
                    leaseInBillInfo.setSupplierLessor(this.getObjFromCell(row, "supplierLessor", SupplierInfo.class));
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                result.addObject((IObjectValue)leaseInBillInfo);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                IRow row = (IRow)list.get(i);
                if (row == null) continue;
            }
        }
        return result;
    }

    private String getStrFromCell(IRow row, String key) {
        return row.getCell(key).getValue() == null ? null : row.getCell(key).getValue().toString();
    }

    private BigDecimal getBDFromCell(IRow row, String key) {
        return row.getCell(key).getValue() == null ? null : (BigDecimal)row.getCell(key).getValue();
    }

    private <T> T getObjFromCell(IRow row, String key, Class<T> clazz) throws Exception {
        CoreBaseInfo base = null;
        if (this.getStrFromCell(row, key + ".id") != null) {
            base = (CoreBaseInfo)clazz.newInstance();
            base.setId(BOSUuid.read((String)this.getStrFromCell(row, key + ".id")));
            base.put("name", (Object)this.getStrFromCell(row, key + ".name"));
        }
        return (T)(base == null ? null : base);
    }

    private FaLessorTypeEnum getEnumFromCell(IRow row, String key) {
        if (row.getCell(key).getValue() == null) {
            return null;
        }
        BizEnumValueDTO lessorType = (BizEnumValueDTO)row.getCell(key).getValue();
        String alias = lessorType.getAlias();
        if (FaLessorTypeEnum.CUSTOMER.getAlias().equals(alias)) {
            return FaLessorTypeEnum.CUSTOMER;
        }
        if (FaLessorTypeEnum.INNER_COMPAY.getAlias().equals(alias)) {
            return FaLessorTypeEnum.INNER_COMPAY;
        }
        if (FaLessorTypeEnum.SUPPLIER.getAlias().equals(alias)) {
            return FaLessorTypeEnum.SUPPLIER;
        }
        return null;
    }

    public void setOpenType(int openType) {
        this.cardFilter.setOpenType(openType);
    }

    public void setFilterInfo(FilterInfo filterInfo) {
        this.cardFilter.setFilterInfo(filterInfo);
    }

    public void setUseDefaultFilter(boolean isUseDefaultFilter) {
        this.cardFilter.setUseDefaultFilter(isUseDefaultFilter);
    }

    public FaCardFilterProcessor getCardFilterProcessor() {
        return this.cardFilter;
    }

    public void setCardFilterProcessor(FaCardFilterProcessor cardFilter) {
        this.cardFilter = cardFilter;
    }

    public Component getOwner() {
        return this.owner;
    }

    public void setRentDirection(FaRentDirectionEnum rentDirection) {
        this.rentDirection = rentDirection;
    }
}

