/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.manage.DateUnitEnum;
import com.kingdee.eas.fi.fa.manage.FALeaseContractFactory;
import com.kingdee.eas.fi.fa.manage.FALeaseContractInfo;
import com.kingdee.eas.fi.fa.manage.FaBillOriginEnum;
import com.kingdee.eas.fi.fa.manage.FaLeaseBillCollection;
import com.kingdee.eas.fi.fa.manage.FaLeaseBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaLeaseBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseBillFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseBillInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillCollection;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaPayModeEnum;
import com.kingdee.eas.fi.fa.manage.LeaseBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.client.AbstractFALeaseContractUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.manage.client.FaLeaseBillEditUI;
import com.kingdee.eas.fi.fa.manage.client.FaLeaseInEditUI;
import com.kingdee.eas.fi.fa.manage.client.FaPrintHelper;
import com.kingdee.eas.framework.BillBaseCollection;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.KeyStroke;

public class FALeaseContractUI
extends AbstractFALeaseContractUI {
    private static final long serialVersionUID = 2457233244731576206L;
    private CompanyOrgUnitInfo currCompany;
    boolean isUseWorkflow = false;
    protected static final String CARDRESOURCE_PATH = "com.kingdee.eas.fi.fa.manage.FaCardResource";
    public static final String STATUS_ADDNEW = "ADDNEW";
    public static final BigDecimal ZERO = new BigDecimal("0");
    protected static final String FROM_LINK = "Link";

    public void onLoad() throws Exception {
        this.currCompany = this.getCurrentCompany();
        super.onLoad();
        this.setWorkflowVisible();
        this.initTitle();
        this.initCtrlComp();
        this.menuItemAudit.setAccelerator(KeyStroke.getKeyStroke("ctrl U"));
        this.menuItemUnAudit.setAccelerator(KeyStroke.getKeyStroke("ctrl shift U"));
        this.actionAttachment.setEnabled(true);
        this.btnAttachment.setVisible(true);
        if (STATUS_ADDNEW.equals(this.oprtState)) {
            this.checkNumberRule(new FALeaseContractInfo());
        }
        if (this.editData != null) {
            if (OprtState.ADDNEW.equals(this.getOprtState()) || OprtState.EDIT.equals(this.getOprtState())) {
                this.actionEdit.setEnabled(false);
            } else if ("FINDVIEW".equals(this.getOprtState())) {
                this.actionEdit.setEnabled(false);
            } else if (FaClientUtils.isFromWorkflow(this.getUIContext())) {
                this.actionEdit.setEnabled(false);
            } else {
                this.actionEdit.setEnabled(this.editData.getCheckedStatus() != CheckedStatusEnum.AUDITED);
            }
        }
    }

    public void initCtrlComp() {
        this.btnGenLeaseBill.setIcon(EASResource.getIcon((String)"imgTbtn_associatecreate"));
        this.menuItemGenLeaseOut.setIcon(EASResource.getIcon((String)"imgTbtn_associatecreate"));
        this.menuItemGenLeaseIn.setIcon(EASResource.getIcon((String)"imgTbtn_associatecreate"));
        this.btnGenLeaseBill.addAssistMenuItem((Action)((Object)this.actionGenLeaseOutBill));
        this.btnGenLeaseBill.addAssistMenuItem((Action)((Object)this.actionGenLeaseInBill));
    }

    protected void initListener() {
        this.txtLessor.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                FALeaseContractUI.this.txtPartyA.setText(FALeaseContractUI.this.txtLessor.getText());
            }
        });
        this.txtCorporationA.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                FALeaseContractUI.this.txtDelegateA.setText(FALeaseContractUI.this.txtCorporationA.getText());
            }
        });
        this.txtLessee.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                FALeaseContractUI.this.txtPartyB.setText(FALeaseContractUI.this.txtLessee.getText());
            }
        });
        this.txtCorporationB.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                FALeaseContractUI.this.txtDelegateB.setText(FALeaseContractUI.this.txtCorporationB.getText());
            }
        });
        super.initListener();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (e != null && e.getSource() != null && (e.getSource() == this.btnSubmit || e.getSource() == this.menuItemSubmit) || e == null && this.getUIContext().get("isMultiApprove").equals(Boolean.TRUE)) {
            this.verifyFields();
        }
        super.beforeStoreFields(e);
    }

    private void verifyFields() throws EASBizException, BOSException {
        String eMail;
        String info = null;
        if (this.pkEffectiveDate.getValue() == null) {
            info = FaResUtil.getRes((String)"com.kingdee.eas.fi.fa.manage.FALeaseContractResource", (String)"effectiveDateCanNotNull");
            MsgBox.showInfo((Component)((Object)this), (String)info);
            this.pkEffectiveDate.requestFocus();
            SysUtil.abort();
        }
        Date effectiveDate = (Date)this.pkEffectiveDate.getValue();
        if (this.txtLessor.getText() == null || this.txtLessor.getText().trim().length() == 0) {
            info = FaResUtil.getRes((String)"com.kingdee.eas.fi.fa.manage.FALeaseContractResource", (String)"lessorCanNotNull");
            MsgBox.showInfo((Component)((Object)this), (String)info);
            this.txtLessor.requestFocus();
            SysUtil.abort();
        }
        if (this.txtCorporationA.getText() == null || this.txtCorporationA.getText().trim().length() == 0) {
            info = FaResUtil.getRes((String)"com.kingdee.eas.fi.fa.manage.FALeaseContractResource", (String)"corporationACanNotNull");
            MsgBox.showInfo((Component)((Object)this), (String)info);
            this.txtCorporationA.requestFocus();
            SysUtil.abort();
        }
        if (this.txtLessee.getText() == null || this.txtLessee.getText().trim().length() == 0) {
            info = FaResUtil.getRes((String)"com.kingdee.eas.fi.fa.manage.FALeaseContractResource", (String)"lesseeCanNotNull");
            MsgBox.showInfo((Component)((Object)this), (String)info);
            this.txtLessee.requestFocus();
            SysUtil.abort();
        }
        if (this.txtCorporationB.getText() == null || this.txtCorporationB.getText().trim().length() == 0) {
            info = FaResUtil.getRes((String)"com.kingdee.eas.fi.fa.manage.FALeaseContractResource", (String)"corporationBCanNotNull");
            MsgBox.showInfo((Component)((Object)this), (String)info);
            this.txtCorporationB.requestFocus();
            SysUtil.abort();
        }
        if (this.txtaContractTerms.getText() == null || this.txtaContractTerms.getText().trim().length() == 0) {
            info = FaResUtil.getRes((String)"com.kingdee.eas.fi.fa.manage.FALeaseContractResource", (String)"contractTermsCanNotNull");
            MsgBox.showInfo((Component)((Object)this), (String)info);
            this.txtaContractTerms.requestFocus();
            SysUtil.abort();
        }
        if (this.txtPartyA.getText() == null || this.txtPartyA.getText().trim().length() == 0) {
            info = FaResUtil.getRes((String)"com.kingdee.eas.fi.fa.manage.FALeaseContractResource", (String)"partyACanNotNull");
            MsgBox.showInfo((Component)((Object)this), (String)info);
            this.txtPartyA.requestFocus();
            SysUtil.abort();
        }
        if (this.txtDelegateA.getText() == null || this.txtDelegateA.getText().trim().length() == 0) {
            info = FaResUtil.getRes((String)"com.kingdee.eas.fi.fa.manage.FALeaseContractResource", (String)"delegateCanNotNull");
            MsgBox.showInfo((Component)((Object)this), (String)info);
            this.txtDelegateA.requestFocus();
            SysUtil.abort();
        }
        if (this.pkSignDateA.getValue() == null) {
            info = FaResUtil.getRes((String)"com.kingdee.eas.fi.fa.manage.FALeaseContractResource", (String)"signDateCanNotNull");
            MsgBox.showInfo((Component)((Object)this), (String)info);
            this.pkSignDateA.requestFocus();
            SysUtil.abort();
        }
        if (this.txtPartyB.getText() == null || this.txtPartyB.getText().trim().length() == 0) {
            info = FaResUtil.getRes((String)"com.kingdee.eas.fi.fa.manage.FALeaseContractResource", (String)"partyBCanNotNull");
            MsgBox.showInfo((Component)((Object)this), (String)info);
            this.txtPartyB.requestFocus();
            SysUtil.abort();
        }
        if (this.txtDelegateB.getText() == null || this.txtDelegateB.getText().trim().length() == 0) {
            info = FaResUtil.getRes((String)"com.kingdee.eas.fi.fa.manage.FALeaseContractResource", (String)"delegateCanNotNull");
            MsgBox.showInfo((Component)((Object)this), (String)info);
            this.txtDelegateB.requestFocus();
            SysUtil.abort();
        }
        if (this.pkSignDateB.getValue() == null) {
            info = FaResUtil.getRes((String)"com.kingdee.eas.fi.fa.manage.FALeaseContractResource", (String)"signDateCanNotNull");
            MsgBox.showInfo((Component)((Object)this), (String)info);
            this.pkSignDateB.requestFocus();
            SysUtil.abort();
        }
        if (this.pkSignDateC.getValue() != null && (effectiveDate.before((Date)this.pkSignDateA.getValue()) || effectiveDate.before((Date)this.pkSignDateB.getValue()) || effectiveDate.before((Date)this.pkSignDateC.getValue()))) {
            info = FaResUtil.getRes((String)"com.kingdee.eas.fi.fa.manage.FALeaseContractResource", (String)"effectiveDateCanNotBeforeSignDate");
            MsgBox.showInfo((Component)((Object)this), (String)info);
            this.pkEffectiveDate.requestFocus();
            SysUtil.abort();
        }
        if (this.txtEmailA.getText() != null && this.txtEmailA.getText().trim().length() != 0 && (eMail = this.txtEmailA.getText()).lastIndexOf("@") == -1) {
            info = FaResUtil.getRes((String)"com.kingdee.eas.fi.fa.manage.FALeaseContractResource", (String)"eMailAddrIsIllegal");
            MsgBox.showInfo((Component)((Object)this), (String)info);
            this.txtEmailA.requestFocus();
            SysUtil.abort();
        }
        if (this.txtEmailB.getText() != null && this.txtEmailB.getText().trim().length() != 0 && (eMail = this.txtEmailB.getText()).lastIndexOf("@") == -1) {
            info = FaResUtil.getRes((String)"com.kingdee.eas.fi.fa.manage.FALeaseContractResource", (String)"eMailAddrIsIllegal");
            MsgBox.showInfo((Component)((Object)this), (String)info);
            this.txtEmailB.requestFocus();
            SysUtil.abort();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void setWorkflowVisible() throws EASBizException, BOSException {
        this.isUseWorkflow = FaManageUtils.isUseWorkflow(null, this.currCompany.getId().toString(), ((Object)((Object)this)).getClass());
        this.actionAudit.setBindWorkFlow(this.isUseWorkflow && this.isBindWorkFlow());
        this.actionUnAudit.setBindWorkFlow(this.isUseWorkflow && this.isBindWorkFlow());
        this.actionSubmit.setBindWorkFlow(this.isUseWorkflow && this.isBindWorkFlow());
        this.actionRemove.setBindWorkFlow(this.isUseWorkflow && this.isBindWorkFlow());
        this.menuTool.setVisible(false);
        this.menuItemAudit.setVisible(!this.isUseWorkflow && this.isBindWorkFlow());
        this.btnAudit.setVisible(!this.isUseWorkflow && this.isBindWorkFlow());
        this.hideOrShowWorkflow(this.isUseWorkflow && this.isBindWorkFlow());
        this.hideOrShowAuditResult(this.isUseWorkflow && this.isBindWorkFlow());
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() != null) {
            String msg = EASResource.getString((String)CARDRESOURCE_PATH, (String)"IF_AUDIT");
            if (MsgBox.isCancel((int)MsgBox.showConfirm2((Component)((Object)this), (String)msg))) {
                return;
            }
            FALeaseContractFactory.getRemoteInstance().passAudit((IObjectPK)new ObjectUuidPK(this.editData.getId()));
            this.showAuditSuccess();
            this.editData = FALeaseContractFactory.getRemoteInstance().getFALeaseContractInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()), this.getSelectors());
            this.setDataObject((IObjectValue)this.editData);
            this.loadFields();
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)CARDRESOURCE_PATH, (String)"SAVE_FIRST"));
        }
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() != null) {
            String msg = EASResource.getString((String)CARDRESOURCE_PATH, (String)"IF_UNAUDIT");
            if (MsgBox.isCancel((int)MsgBox.showConfirm2((Component)((Object)this), (String)msg))) {
                return;
            }
            FALeaseContractFactory.getRemoteInstance().unpassAudit((IObjectPK)new ObjectUuidPK(this.editData.getId()));
            this.showUnAuditSuccess();
            this.editData = FALeaseContractFactory.getRemoteInstance().getFALeaseContractInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()), this.getSelectors());
            this.setDataObject((IObjectValue)this.editData);
            this.loadFields();
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)CARDRESOURCE_PATH, (String)"SAVE_FIRST"));
        }
    }

    @Override
    public void actionGenLeaseInBill_actionPerformed(ActionEvent e) throws Exception {
        FaLeaseBillCollection bBillColl;
        FaLeaseInBillCollection billColl;
        if (this.editData.getCheckedStatus() == null || CheckedStatusEnum.UNAUDITED == this.editData.getCheckedStatus()) {
            MsgBox.showInfo((String)FaResUtil.getRes((String)"com.kingdee.eas.fi.fa.manage.FALeaseContractResource", (String)"canNotGenBill"));
            SysUtil.abort();
        }
        if ((billColl = FaLeaseInBillFactory.getRemoteInstance().getFaLeaseInBillCollection("select id where bargainNum = '" + this.editData.getNumber() + "'")) != null && billColl.size() != 0) {
            MsgBox.showInfo((String)FaResUtil.getRes((String)"com.kingdee.eas.fi.fa.manage.FALeaseContractResource", (String)"hasGenLeaseInBill"));
            SysUtil.abort();
        }
        if ((bBillColl = FaLeaseBillFactory.getRemoteInstance().getFaLeaseBillCollection("select id where bargainNum = '" + this.editData.getNumber() + "'")) != null && bBillColl.size() != 0) {
            MsgBox.showInfo((Component)((Object)this), (String)FaResUtil.getRes((String)"com.kingdee.eas.fi.fa.manage.FALeaseContractResource", (String)"hasGenLeaseOutBill"));
            SysUtil.abort();
        }
        FaLeaseInBillInfo billInfo = new FaLeaseInBillInfo();
        billInfo.setHireOriginAmt(ZERO);
        billInfo.setHireNaturalAmt(ZERO);
        if (this.editData.getSourceBillId() != null && this.editData.getSourceBillId().trim().length() != 0) {
            billInfo = this.onReletGenLeaseInBill(billInfo);
        }
        billInfo.setBargainNum(this.editData.getNumber());
        billInfo.setSignaturePlace(this.editData.getSignAddress());
        billInfo.setSignatureDate(this.editData.getEffectiveDate());
        billInfo.setBeginDate(this.editData.getEffectiveDate());
        billInfo.setDeliverDate(this.editData.getEffectiveDate());
        Date endDate = DateTimeUtils.addYear((Date)this.editData.getEffectiveDate(), (int)1);
        billInfo.setBargainTime(new BigDecimal(1.0));
        billInfo.setEndDate(new Date(endDate.getTime() - 86400000L));
        billInfo.setLeasor(this.editData.getLessor());
        billInfo.setLeasee(this.editData.getLessee());
        billInfo.setCautioner(this.editData.getAssurer());
        billInfo.setBillType(FaBillOriginEnum.FROM_LEASECONTRACT);
        billInfo.setBizStatus(LeaseBizStatusEnum.CHECKING);
        billInfo.setCompany(this.currCompany);
        billInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        billInfo.setMeasureUnit(DateUnitEnum.YEAR);
        billInfo.setPayMode(FaPayModeEnum.MONTH_PAY);
        billInfo.setSubsOriginAmt(ZERO);
        billInfo.setSubsNaturalAmt(ZERO);
        BigDecimal ONE = new BigDecimal("1.00");
        billInfo.setSubsExRate(ONE);
        billInfo.setHireExRate(ONE);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.putAll(this.getUIContext());
        uiContext.put((Object)"InitDataObject", (Object)billInfo);
        String uiClassName = "com.kingdee.eas.fi.fa.manage.client.FaLeaseInEditUI";
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(uiClassName, (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        this.setCursorOfDefault();
    }

    private FaLeaseInBillInfo onReletGenLeaseInBill(FaLeaseInBillInfo billInfo) throws Exception {
        FaLeaseInEditUI editUI = new FaLeaseInEditUI();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("id", (Object)this.editData.getSourceBillId(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SelectorItemCollection selectorCols = editUI.getSelectors();
        Iterator iter = selectorCols.iterator();
        while (iter.hasNext()) {
            view.getSelector().add((SelectorItemInfo)iter.next());
        }
        FaLeaseInBillCollection billColls = FaLeaseInBillFactory.getRemoteInstance().getFaLeaseInBillCollection(view);
        if (billColls.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)FaResUtil.getRes((String)"com.kingdee.eas.fi.fa.manage.FALeaseContractResource", (String)"canNotGenLeaseInBill"));
            SysUtil.abort();
        } else {
            billInfo = billColls.get(0);
        }
        FaLeaseInBillEntryCollection leaseInBillColl = billInfo.getEntry();
        BigDecimal hireNaturalAmt = ZERO;
        BigDecimal hireOriginAmt = ZERO;
        for (int i = 0; i < leaseInBillColl.size(); ++i) {
            FaLeaseInBillEntryInfo leaseInBillEntryInfo = leaseInBillColl.get(i);
            leaseInBillEntryInfo.setId(null);
            BigDecimal monthHireLocal = leaseInBillEntryInfo.getMonLocalHireAmt() == null ? ZERO : leaseInBillEntryInfo.getMonLocalHireAmt();
            BigDecimal monOriginHireAmt = leaseInBillEntryInfo.getMonOriginHireAmt() == null ? ZERO : leaseInBillEntryInfo.getMonOriginHireAmt();
            leaseInBillEntryInfo.setHireLocalAmt(monthHireLocal.multiply(new BigDecimal(12)));
            leaseInBillEntryInfo.setHireOriginAmt(monOriginHireAmt.multiply(new BigDecimal(12)));
            hireNaturalAmt = hireNaturalAmt.add(monthHireLocal.multiply(new BigDecimal(12)));
            hireOriginAmt = hireOriginAmt.add(monOriginHireAmt.multiply(new BigDecimal(12)));
        }
        billInfo.setHireNaturalAmt(hireNaturalAmt);
        billInfo.setHireOriginAmt(hireOriginAmt);
        billInfo.setId(null);
        billInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        billInfo.setCreateTime(null);
        billInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        billInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
        billInfo.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        billInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        billInfo.setAuditor(null);
        billInfo.setAuditTime(null);
        billInfo.setFiVouchered(false);
        return billInfo;
    }

    @Override
    public void actionGenLeaseOutBill_actionPerformed(ActionEvent e) throws Exception {
        FaLeaseInBillCollection bBillColl;
        FaLeaseBillCollection billColl;
        if (this.editData.getCheckedStatus() == null || CheckedStatusEnum.UNAUDITED == this.editData.getCheckedStatus()) {
            MsgBox.showInfo((String)FaResUtil.getRes((String)"com.kingdee.eas.fi.fa.manage.FALeaseContractResource", (String)"canNotGenBill"));
            SysUtil.abort();
        }
        if ((billColl = FaLeaseBillFactory.getRemoteInstance().getFaLeaseBillCollection("select id where bargainNum = '" + this.editData.getNumber() + "'")) != null && billColl.size() != 0) {
            MsgBox.showInfo((String)FaResUtil.getRes((String)"com.kingdee.eas.fi.fa.manage.FALeaseContractResource", (String)"hasGenLeaseOutBill"));
            SysUtil.abort();
        }
        if ((bBillColl = FaLeaseInBillFactory.getRemoteInstance().getFaLeaseInBillCollection("select id where bargainNum = '" + this.editData.getNumber() + "'")) != null && bBillColl.size() != 0) {
            MsgBox.showInfo((String)FaResUtil.getRes((String)"com.kingdee.eas.fi.fa.manage.FALeaseContractResource", (String)"hasGenLeaseInBill"));
            SysUtil.abort();
        }
        FaLeaseBillInfo billInfo = new FaLeaseBillInfo();
        billInfo.setHireOriginAmt(ZERO);
        billInfo.setHireNaturalAmt(ZERO);
        if (this.editData.getSourceBillId() != null && this.editData.getSourceBillId().trim().length() != 0) {
            billInfo = this.onReletGenLeaseOutBill(billInfo);
        }
        billInfo.setBargainNum(this.editData.getNumber());
        billInfo.setSignaturePlace(this.editData.getSignAddress());
        billInfo.setSignatureDate(this.editData.getEffectiveDate());
        billInfo.setBeginDate(this.editData.getEffectiveDate());
        billInfo.setDeliverDate(this.editData.getEffectiveDate());
        Date endDate = DateTimeUtils.addYear((Date)this.editData.getEffectiveDate(), (int)1);
        billInfo.setBargainTime(new BigDecimal(1.0));
        billInfo.setEndDate(new Date(endDate.getTime() - 86400000L));
        billInfo.setHireCompany(this.editData.getLessor());
        billInfo.setLeaseCompany(this.editData.getLessee());
        billInfo.setCautioner(this.editData.getAssurer());
        billInfo.setBillType(FaBillOriginEnum.FROM_LEASECONTRACT);
        billInfo.setBizStatus(LeaseBizStatusEnum.CHECKING);
        billInfo.setCompany(this.currCompany);
        billInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        billInfo.setMeasureUnit(DateUnitEnum.YEAR);
        billInfo.setPayMode(FaPayModeEnum.MONTH_PAY);
        billInfo.setSubsOriginAmt(ZERO);
        billInfo.setSubsNaturalAmt(ZERO);
        BigDecimal ONE = new BigDecimal("1.00");
        billInfo.setSubsExRate(ONE);
        billInfo.setHireExRate(ONE);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.putAll(this.getUIContext());
        uiContext.put((Object)"InitDataObject", (Object)billInfo);
        String uiClassName = "com.kingdee.eas.fi.fa.manage.client.FaLeaseBillEditUI";
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(uiClassName, (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        this.setCursorOfDefault();
    }

    private FaLeaseBillInfo onReletGenLeaseOutBill(FaLeaseBillInfo billInfo) throws Exception {
        FaLeaseBillEditUI editUI = new FaLeaseBillEditUI();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("id", (Object)this.editData.getSourceBillId(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SelectorItemCollection selectorCols = editUI.getSelectors();
        Iterator iter = selectorCols.iterator();
        while (iter.hasNext()) {
            view.getSelector().add((SelectorItemInfo)iter.next());
        }
        FaLeaseBillCollection billColls = FaLeaseBillFactory.getRemoteInstance().getFaLeaseBillCollection(view);
        if (billColls.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)FaResUtil.getRes((String)"com.kingdee.eas.fi.fa.manage.FALeaseContractResource", (String)"canNotGenLeaseOutBill"));
            SysUtil.abort();
        } else {
            billInfo = billColls.get(0);
        }
        FaLeaseBillEntryCollection leaseBillColl = billInfo.getFaLeaseBillEntry();
        BigDecimal hireNaturalAmt = ZERO;
        BigDecimal hireOriginAmt = ZERO;
        for (int i = 0; i < leaseBillColl.size(); ++i) {
            FaLeaseBillEntryInfo leaseBillEntryInfo = leaseBillColl.get(i);
            leaseBillEntryInfo.setId(null);
            BigDecimal monthHireLocal = leaseBillEntryInfo.getMonLocalHireAmt() == null ? ZERO : leaseBillEntryInfo.getMonLocalHireAmt();
            BigDecimal monOriginHireAmt = leaseBillEntryInfo.getMonOriginHireAmt() == null ? ZERO : leaseBillEntryInfo.getMonOriginHireAmt();
            leaseBillEntryInfo.setHireLocalAmt(monthHireLocal.multiply(new BigDecimal(12)));
            leaseBillEntryInfo.setHireOriginAmt(monOriginHireAmt.multiply(new BigDecimal(12)));
            hireNaturalAmt = hireNaturalAmt.add(monthHireLocal.multiply(new BigDecimal(12)));
            hireOriginAmt = hireOriginAmt.add(monOriginHireAmt.multiply(new BigDecimal(12)));
        }
        billInfo.setHireNaturalAmt(hireNaturalAmt);
        billInfo.setHireOriginAmt(hireOriginAmt);
        billInfo.setId(null);
        billInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        billInfo.setCreateTime(null);
        billInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        billInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
        billInfo.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        billInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        billInfo.setAuditor(null);
        billInfo.setAuditTime(null);
        billInfo.setFiVouchered(false);
        return billInfo;
    }

    @Override
    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        FaLeaseInBillCollection inBillColl;
        if (this.editData.getCheckedStatus() == null || CheckedStatusEnum.UNAUDITED == this.editData.getCheckedStatus()) {
            MsgBox.showInfo((Component)((Object)this), (String)FaResUtil.getRes((String)"com.kingdee.eas.fi.fa.manage.FALeaseContractResource", (String)"notGenAnyBill"));
            SysUtil.abort();
        }
        boolean genAnyBill = false;
        FaLeaseBillCollection outBillColl = FaLeaseBillFactory.getRemoteInstance().getFaLeaseBillCollection("select id where bargainNum = '" + this.editData.getNumber() + "' and company.id = '" + this.currCompany.getId().toString() + "'");
        if (outBillColl != null && outBillColl.size() != 0) {
            String billID = outBillColl.get(0).getId().toString();
            if (billID == null || billID.trim().length() == 0) {
                return;
            }
            UIContext uiContext = new UIContext((Object)this);
            uiContext.putAll(this.getUIContext());
            uiContext.put((Object)FROM_LINK, (Object)Boolean.TRUE);
            uiContext.put((Object)"ID", (Object)billID);
            uiContext.put((Object)"InitDataObject", null);
            uiContext.put((Object)"COMPANY_ID", (Object)this.currCompany.getId().toString());
            String uiClassName = "com.kingdee.eas.fi.fa.manage.client.FaLeaseBillEditUI";
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(uiClassName, (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
            this.setCursorOfDefault();
            genAnyBill = true;
        }
        if ((inBillColl = FaLeaseInBillFactory.getRemoteInstance().getFaLeaseInBillCollection("select id where bargainNum = '" + this.editData.getNumber() + "' and company.id = '" + this.currCompany.getId().toString() + "'")) != null && inBillColl.size() != 0) {
            String billID = inBillColl.get(0).getId().toString();
            if (billID == null || billID.trim().length() == 0) {
                return;
            }
            UIContext uiContext = new UIContext((Object)this);
            uiContext.putAll(this.getUIContext());
            uiContext.put((Object)FROM_LINK, (Object)Boolean.TRUE);
            uiContext.put((Object)"ID", (Object)billID);
            uiContext.put((Object)"InitDataObject", null);
            uiContext.put((Object)"COMPANY_ID", (Object)this.currCompany.getId().toString());
            String uiClassName = "com.kingdee.eas.fi.fa.manage.client.FaLeaseInEditUI";
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(uiClassName, (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
            this.setCursorOfDefault();
            genAnyBill = true;
        }
        if (!genAnyBill) {
            MsgBox.showInfo((Component)((Object)this), (String)FaResUtil.getRes((String)"com.kingdee.eas.fi.fa.manage.FALeaseContractResource", (String)"notGenAnyBill"));
            SysUtil.abort();
        }
    }

    private void showAuditSuccess() {
        this.setMessageText(this.getClassAlise() + " " + FaResUtil.getRes((String)"auditOK"));
        this.showMessage();
    }

    private void showUnAuditSuccess() {
        this.setMessageText(this.getClassAlise() + " " + FaResUtil.getRes((String)"reAuditOK"));
        this.showMessage();
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        FALeaseContractInfo billinfo = (FALeaseContractInfo)dataObject;
        if (billinfo != null) {
            boolean isAudit = billinfo.getCheckedStatus() == CheckedStatusEnum.AUDITED;
            this.actionAudit.setEnabled(!isAudit);
            this.btnAudit.setEnabled(!isAudit);
            this.menuItemAudit.setEnabled(!isAudit);
            this.actionUnAudit.setEnabled(isAudit);
            this.btnUnAudit.setEnabled(isAudit);
            this.menuItemUnAudit.setEnabled(isAudit);
            this.actionGenLeaseInBill.setEnabled(isAudit);
            this.actionGenLeaseOutBill.setEnabled(isAudit);
            this.btnGenLeaseBill.setEnabled(isAudit);
            this.menuItemGenLeaseIn.setEnabled(isAudit);
            this.menuItemGenLeaseOut.setEnabled(isAudit);
            billinfo.setHandler(SysContext.getSysContext().getCurrentUserInfo());
        } else {
            this.actionAudit.setEnabled(true);
            this.btnAudit.setEnabled(true);
            this.menuItemAudit.setEnabled(true);
            this.actionUnAudit.setEnabled(false);
            this.btnUnAudit.setEnabled(false);
            this.menuItemUnAudit.setEnabled(false);
            this.actionGenLeaseInBill.setEnabled(false);
            this.actionGenLeaseOutBill.setEnabled(false);
            this.btnGenLeaseBill.setEnabled(false);
            this.menuItemGenLeaseIn.setEnabled(false);
            this.menuItemGenLeaseOut.setEnabled(false);
        }
        super.setDataObject(dataObject);
        if (FaClientUtils.isFromWorkflow(this.getUIContext())) {
            this.actionEdit.setEnabled(false);
        }
        this.actionEdit.setEnabled(!CheckedStatusEnum.AUDITED.equals((Object)this.editData.getCheckedStatus()));
        if (dataObject != null && (OprtState.ADDNEW.equals(this.getOprtState()) || OprtState.EDIT.equals(this.getOprtState()))) {
            this.actionEdit.setEnabled(false);
        }
    }

    protected CompanyOrgUnitInfo getCurrentCompany() {
        if (this.currCompany == null) {
            String companyId = null;
            if (FaClientUtils.isFromWorkflow(this.getUIContext())) {
                BillBaseInfo initObj = null;
                if (this.getUIContext().get("ID") != null) {
                    String id = this.getUIContext().get("ID").toString();
                    try {
                        initObj = (BillBaseInfo)this.getBizInterface().getValue("select company.id where id='" + id + "'");
                    }
                    catch (Exception e) {
                        this.handleException(e);
                    }
                }
                companyId = initObj == null ? SysContext.getSysContext().getCurrentFIUnit().getId().toString() : initObj.getCompany().getId().toString();
            } else {
                companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            }
            try {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("*"));
                selector.add(new SelectorItemInfo("baseCurrency.*"));
                this.currCompany = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), selector);
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.currCompany;
    }

    protected IObjectValue createNewData() {
        FALeaseContractInfo objectValue = new FALeaseContractInfo();
        PeriodInfo currPeriod = this.getCurrentPeriod();
        Date today = DateTimeUtils.truncateDate((Date)new Date());
        objectValue.setPeriod(currPeriod);
        objectValue.setEffectiveDate(today);
        objectValue.setSignDateA(today);
        objectValue.setSignDateB(today);
        objectValue.setSignDateC(today);
        objectValue.setCompany(this.currCompany);
        objectValue.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        objectValue.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        objectValue.setDeletedStatus(DeletedStatusEnum.NORMAL);
        objectValue.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        objectValue.setNumber(this.getRuleNumber(objectValue));
        return objectValue;
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        super.setFieldsNull(newData);
        FALeaseContractInfo objectValue = (FALeaseContractInfo)newData;
        PeriodInfo currPeriod = this.getCurrentPeriod();
        objectValue.setEffectiveDate(DateTimeUtils.truncateDate((Date)new Date()));
        objectValue.setSignDateA(DateTimeUtils.truncateDate((Date)new Date()));
        objectValue.setSignDateB(DateTimeUtils.truncateDate((Date)new Date()));
        objectValue.setSignDateC(DateTimeUtils.truncateDate((Date)new Date()));
        objectValue.setPeriod(currPeriod);
        objectValue.setPeriod(currPeriod);
        objectValue.setCompany(this.currCompany);
        objectValue.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        objectValue.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        objectValue.setDeletedStatus(DeletedStatusEnum.NORMAL);
        objectValue.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        objectValue.setAuditor(null);
        objectValue.setBizDate(null);
        objectValue.setNumber(null);
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        objectValue.setCreateTime(new Timestamp(new Date().getTime()));
        objectValue.setId(null);
        objectValue.setSourceBillId(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getRuleNumber(FALeaseContractInfo baseInfo) {
        String number = null;
        ICodingRuleManager iCodingRuleManager = null;
        CompanyOrgUnitInfo company = this.getCurrentCompany();
        try {
            if (baseInfo.getCompany() == null) {
                baseInfo.setCompany(company);
            }
            iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            boolean isCodingRule = iCodingRuleManager.isExist((IObjectValue)baseInfo, company.getId().toString());
            boolean isViewCodeRule = iCodingRuleManager.isAddView((IObjectValue)baseInfo, company.getId().toString());
            number = isCodingRule && isViewCodeRule ? iCodingRuleManager.readNumber((IObjectValue)baseInfo, company.getId().toString()) : "";
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        finally {
            if (number == null && this.isNeedCodeRule()) {
                SysUtil.abort();
            }
        }
        return number;
    }

    private boolean isNeedCodeRule() {
        return false;
    }

    private PeriodInfo getCurrentPeriod() {
        PeriodInfo currenctPeriod = null;
        try {
            currenctPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit());
        }
        catch (Exception ex) {
            this.handleException(ex);
            SysUtil.abort();
        }
        if (currenctPeriod == null) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.notConfigStartPeriod");
            MsgBox.showInfo((Component)((Object)this), (String)strMsg);
            SysUtil.abort();
        }
        return currenctPeriod;
    }

    protected KDTable getDetailTable() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FALeaseContractFactory.getRemoteInstance();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.menuItemAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.menuItemUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.setBtnStatus();
        this.txtNumber.setEditable(false);
    }

    private void setBtnStatus() {
        boolean enabled = this.editData.getId() != null && this.editData.getId().toString().trim().length() != 0;
        this.actionTraceUp.setEnabled(enabled);
        this.actionTraceDown.setEnabled(enabled);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    private void checkNumberRule(FALeaseContractInfo billInfo) throws Exception {
        String strCompanyId;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        if (!iCodingRuleManager.isExist((IObjectValue)billInfo, strCompanyId = this.getCurrentCompany().getId().toString())) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FALeaseContractResource", (String)"codingRuleNotDefine");
            MsgBox.showInfo((Component)((Object)this), (String)strMsg);
            SysUtil.abort();
        }
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        BillBaseCollection billCol = new BillBaseCollection();
        billCol.add((BillBaseInfo)this.editData);
        KDNoteHelper appHlp = new KDNoteHelper();
        KDTable[] tables = new KDTable[]{new KDTable()};
        BOSQueryDelegate data = FaPrintHelper.getPrintManagerForFaLeaseContractUI((IObjectCollection)billCol, tables);
        appHlp.printPreview(this.getPrintPath(), (Object)data, (Component)((Object)this));
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        BillBaseCollection billCol = new BillBaseCollection();
        billCol.add((BillBaseInfo)this.editData);
        KDNoteHelper appHlp = new KDNoteHelper();
        KDTable[] tables = new KDTable[]{new KDTable()};
        BOSQueryDelegate data = FaPrintHelper.getPrintManagerForFaLeaseContractUI((IObjectCollection)billCol, tables);
        appHlp.print(this.getPrintPath(), (Object)data, (Component)((Object)this));
    }

    protected String getPrintPath() {
        return "/FI/FA/FaLeaseContract";
    }

    protected void initTitle() throws Exception {
        if (this.getOprtState().equals(STATUS_ADDNEW)) {
            this.setUITitle(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_AddNew_New"), FrameWorkUtils.getClassAlias((CoreBaseInfo)this.editData)));
        }
        if (this.getOprtState().equals("EDIT")) {
            this.setUITitle(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Edit_New"), FrameWorkUtils.getClassAlias((CoreBaseInfo)this.editData)));
        }
        if (this.getOprtState().equals("VIEW") || this.getOprtState().equals("FINDVIEW")) {
            this.setUITitle(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_View_New"), FrameWorkUtils.getClassAlias((CoreBaseInfo)this.editData)));
        }
    }
}

