/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaBarcodePrintModeSetUI;
import com.kingdee.eas.rt.common.FaBarcodePrinter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class FaBarcodePrintModeSetUI
extends AbstractFaBarcodePrintModeSetUI {
    private static final Logger logger = CoreUIObject.getLogger(FaBarcodePrintModeSetUI.class);
    private Map modelFileNamePathMap = new HashMap();
    private FaBarcodePrinter barcodePrinter = new FaBarcodePrinter();
    private boolean isHasPrepareData = false;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.barcodePrinter.barCodeDllReg();
        this.loadModels();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setWindowsSize();
    }

    protected void setWindowsSize() {
        Dimension dimSize = new Dimension(470, 300);
        this.setPreferredSize(dimSize);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (this.getUIContext() != null && this.getUIContext().get("isPrint").equals("true")) {
            this.btnCreateModel.setVisible(false);
            this.btnDelModel.setVisible(false);
            this.btnExportModel.setVisible(false);
            this.btnImportModel.setVisible(false);
        } else {
            this.btnPrint.setVisible(false);
            this.btnPrintPreview.setVisible(false);
        }
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.checkSelect();
        String printModelFieldPath = (String)this.modelFileNamePathMap.get(this.listModels.getSelectedValue());
        if (!this.isHasPrepareData) {
            this.preparePrintData(printModelFieldPath);
        }
        this.getUIWindow().close();
        this.barcodePrinter.printBarcode(printModelFieldPath, this.barcodePrinter.getBarcodeTempPrintDataFilePath(), "-1");
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.checkSelect();
        String printModelFieldPath = (String)this.modelFileNamePathMap.get(this.listModels.getSelectedValue());
        if (!this.isHasPrepareData) {
            this.preparePrintData(printModelFieldPath);
        }
        this.getUIWindow().close();
        this.barcodePrinter.printBarcode(printModelFieldPath, this.barcodePrinter.getBarcodeTempPrintDataFilePath(), "0");
    }

    private void preparePrintData(String printModelFieldPath) throws JDOMException, IOException {
        Object printTableObj;
        if (this.getUIContext() != null && (printTableObj = this.getUIContext().get("printTable")) != null) {
            KDTable printTable = (KDTable)printTableObj;
            this.barcodePrinter.preparePrintData(printTable, printModelFieldPath);
        }
        this.isHasPrepareData = true;
    }

    private void loadModels() throws Exception {
        List modelsList = this.barcodePrinter.getPrintModels();
        for (int i = 0; i < modelsList.size(); ++i) {
            Element curElement = (Element)modelsList.get(i);
            String fileName = curElement.getAttributeValue("name");
            String filePath = curElement.getAttributeValue("filePath");
            this.listModels.addElement((Object)fileName);
            this.modelFileNamePathMap.put(fileName, filePath);
        }
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    @Override
    public void actionCreateModel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCreateModel_actionPerformed(e);
        this.barcodePrinter.executeBarCodeDesigner();
    }

    @Override
    public void actionImportModel_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportModel_actionPerformed(e);
        File modelFile = this.barcodePrinter.selectPrintModeFile((Component)((Object)this));
        if (modelFile == null) {
            return;
        }
        String shortFileName = this.getFileName(modelFile.getName());
        if (modelFile != null) {
            if (this.isHasRepeatModel(shortFileName)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"12_FaBarcodePrintModeSetUI"));
                return;
            }
            this.barcodePrinter.addPrintModel(shortFileName, modelFile.getPath());
            this.listModels.addElement((Object)shortFileName);
            this.modelFileNamePathMap.put(shortFileName, modelFile.getPath());
            modelFile = null;
        }
    }

    private String getFileName(String name) {
        if (name == null) {
            return null;
        }
        int pos = name.indexOf(".");
        if (pos > -1) {
            return name.substring(0, pos);
        }
        return null;
    }

    private boolean isHasRepeatModel(String modelName) {
        return this.modelFileNamePathMap.get(modelName) != null;
    }

    @Override
    public void actionDelModel_actionPerformed(ActionEvent e) throws Exception {
        String modelName;
        super.actionDelModel_actionPerformed(e);
        this.checkSelect();
        int result = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"13_FaBarcodePrintModeSetUI"));
        if (result != 0) {
            SysUtil.abort();
        }
        if (!this.barcodePrinter.delPrintModel(modelName = this.listModels.getSelectedValue().toString(), this.modelFileNamePathMap.get(modelName).toString())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"14_FaBarcodePrintModeSetUI"));
            return;
        }
        this.listModels.removeElement(this.listModels.getSelectedValue());
        this.modelFileNamePathMap.remove(modelName);
    }

    private void checkSelect() {
        if (this.listModels.getSelectedValue() == null) {
            SysUtil.abort();
        }
    }

    @Override
    public void actionExportModel_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportModel_actionPerformed(e);
        this.checkSelect();
        String fileName = this.listModels.getSelectedValue().toString();
        this.barcodePrinter.savePrintModeFile((Component)((Object)this), this.modelFileNamePathMap.get(fileName).toString());
    }
}

