/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.FaAlterModeInfo;
import com.kingdee.eas.fi.fa.basedata.FaCatInfo;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.basedata.client.FaAlterModePromptBox;
import com.kingdee.eas.fi.fa.basedata.client.FaDisplyFormatter;
import com.kingdee.eas.fi.fa.basedata.client.FaEditFormatter;
import com.kingdee.eas.fi.fa.def.FaDefCommonFacadeFactory;
import com.kingdee.eas.fi.fa.def.FaDefPropertyValueCollection;
import com.kingdee.eas.fi.fa.def.FaDefPropertyValueInfo;
import com.kingdee.eas.fi.fa.def.client.util.SplitPropertyValue;
import com.kingdee.eas.fi.fa.manage.FaBillTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaBizCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCardOriginEnum;
import com.kingdee.eas.fi.fa.manage.FaChangeStatusEnmu;
import com.kingdee.eas.fi.fa.manage.FaClearStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaDepCalFacadeFactory;
import com.kingdee.eas.fi.fa.manage.FaSplitBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaSplitBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaSplitBillFactory;
import com.kingdee.eas.fi.fa.manage.FaSplitBillInfo;
import com.kingdee.eas.fi.fa.manage.FaSplitTypeEnum;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaBatchSplitUI;
import com.kingdee.eas.fi.fa.manage.client.CommonQueryWithResultDialog;
import com.kingdee.eas.fi.fa.manage.client.FACommonProcessor;
import com.kingdee.eas.fi.fa.manage.client.FaBillEditUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class FaBatchSplitUI
extends AbstractFaBatchSplitUI {
    private static final Logger logger = CoreUIObject.getLogger(FaBatchSplitUI.class);
    protected Map<String, FaCurCardInfo> srcCardMap = new LinkedHashMap<String, FaCurCardInfo>();
    protected Map<String, FaCurCardCollection> destCardMap = new LinkedHashMap<String, FaCurCardCollection>();
    protected static final BigDecimal zeroValue = new BigDecimal("0");
    protected int currencyScale = -1;
    protected HashMap faParameter;
    protected CompanyOrgUnitInfo currCompany;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FaSplitBillFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.srcTable.checkParsed();
        this.destTable.checkParsed();
        this.initCtrlComponent();
        this.initData();
    }

    protected void initCtrlComponent() throws Exception {
        IColumn column;
        int idx;
        FaAlterModePromptBox aFaAlterModePromptBox = new FaAlterModePromptBox((CoreUIObject)this);
        this.prmtClearMode.setSelector((KDPromptSelector)aFaAlterModePromptBox);
        this.prmtClearMode.setDisplayFormatter((IFormatter)new FaDisplyFormatter());
        this.prmtClearMode.setEditFormatter((IFormatter)new FaEditFormatter());
        this.prmtClearMode.setCommitFormat("$number$");
        this.prmtClearMode.setEditable(true);
        this.prmtClearMode.setQueryInfo("com.kingdee.eas.fi.fa.basedata.FaAlterModeQuery");
        this.prmtClearMode.setEntityViewInfo(FaClientUtils.getAlterModeOrgSplitViewInfo(false));
        this.btnHalfSplit.setIcon(EASResource.getIcon((String)"imgTbtn_split"));
        this.btnHalfSplit.setVisible(true);
        this.btnHalfSplit.setEnabled(true);
        this.wbtnAddCard.setVisible(true);
        this.wbtnAddCard.setEnabled(true);
        this.wbtnDelCard.setVisible(true);
        this.wbtnDelCard.setEnabled(true);
        this.kdOK.setVisible(true);
        this.kdOK.setEnabled(true);
        this.kdCANCEL.setVisible(true);
        this.kdCANCEL.setEnabled(true);
        this.txtSrcCardNum.setRequired(true);
        this.comboSplitType.setRequired(true);
        this.prmtSpliter.setRequired(true);
        this.prmtClearMode.setRequired(true);
        this.dateSplitDate.setRequired(true);
        this.comboSplitType.setSelectedItem((Object)FaSplitTypeEnum.BY_QUANTITY);
        this.txtSrcCardNum.setEditable(false);
        this.txtDestCardNum.setEditable(false);
        KDFormattedTextField fField = new KDFormattedTextField(1);
        fField.setNegatived(false);
        fField.setPrecision(this.getFAQuantityScale());
        KDTDefaultCellEditor qualityEditor = new KDTDefaultCellEditor((JTextField)fField);
        for (idx = 0; idx < this.srcTable.getColumnCount(); ++idx) {
            column = this.srcTable.getColumn(idx);
            if ("splitAmt".equals(column.getKey())) {
                column.setEditor((ICellEditor)qualityEditor);
                column.getStyleAttributes().setNumberFormat(FaClientUtils.getDecimalFormat(this.getFAQuantityScale()));
                column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                column.setRequired(true);
                continue;
            }
            column.getStyleAttributes().setLocked(true);
        }
        this.srcTable.getColumn("assetAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.srcTable.getColumn("splitAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.srcTable.getColumn("originAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.srcTable.getColumn("addons").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.srcTable.getColumn("assetValue").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.srcTable.getColumn("accuDepr").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.srcTable.getColumn("accuDeprTYear").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.srcTable.getColumn("buyValue").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.srcTable.getColumn("buyAccuDepr").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.srcTable.getColumn("neatRemValue").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.srcTable.getColumn("decValue").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.srcTable.getColumn("neatValue").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.srcTable.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                int currCol = e.getColIndex();
                if (currCol == FaBatchSplitUI.this.srcTable.getColumn("splitAmt").getColumnIndex()) {
                    BigDecimal oldSplitAmt = (BigDecimal)e.getOldValue();
                    BigDecimal newSplitAmt = (BigDecimal)e.getValue();
                    BigDecimal changeAmt = newSplitAmt.subtract(oldSplitAmt);
                    BigDecimal oldDestCardNum = (BigDecimal)FaBatchSplitUI.this.txtDestCardNum.getValue();
                    if (oldDestCardNum == null) {
                        oldDestCardNum = zeroValue;
                    }
                    FaBatchSplitUI.this.txtDestCardNum.setValue((Object)oldDestCardNum.add(changeAmt));
                }
            }
        });
        for (idx = 0; idx < this.destTable.getColumnCount(); ++idx) {
            column = this.destTable.getColumn(idx);
            column.getStyleAttributes().setLocked(true);
        }
        this.destTable.getColumn("assetAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.destTable.getColumn("originAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.destTable.getColumn("addons").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.destTable.getColumn("assetValue").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.destTable.getColumn("accuDepr").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.destTable.getColumn("accuDeprTYear").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.destTable.getColumn("buyValue").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.destTable.getColumn("buyAccuDepr").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.destTable.getColumn("neatRemValue").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.destTable.getColumn("decValue").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.destTable.getColumn("neatValue").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    protected void initData() {
        ArrayList result = (ArrayList)this.getUIContext().get("result");
        int srcCardNum = result.size();
        BigDecimal totalDestCardNum = zeroValue;
        if (result != null && result.size() > 0) {
            for (int idx = 0; idx < result.size(); ++idx) {
                IRow row = (IRow)result.get(idx);
                String id = row.getCell("id").getValue().toString();
                FaCurCardInfo curCard = this.getCurCardInfo(id);
                if (this.isNeedDepreciation(curCard)) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource.alreadyDprBatch", (Object[])new Object[]{curCard.getNumber()}));
                    SysUtil.abort();
                }
                this.srcCardMap.put(id, curCard);
                totalDestCardNum = totalDestCardNum.add(curCard.getAssetAmt());
            }
        }
        this.insertTable(this.srcTable, this.srcCardMap);
        this.txtSrcCardNum.setValue((Object)this.srcTable.getRowCount());
        this.txtDestCardNum.setValue((Object)totalDestCardNum);
    }

    private void insertTable(KDTable kdTable, Map<String, FaCurCardInfo> cardMap) {
        FaCurCardCollection cardCol = new FaCurCardCollection();
        for (FaCurCardInfo curCard : cardMap.values()) {
            cardCol.add(curCard);
        }
        this.insertTable(kdTable, cardCol);
    }

    private void insertTable(KDTable kdTable, FaCurCardCollection curCardCol) {
        for (int idx = 0; idx < curCardCol.size(); ++idx) {
            FaCurCardInfo curCard = curCardCol.get(idx);
            IRow newRow = kdTable.addRow();
            newRow.getCell("number").setValue((Object)curCard.getNumber());
            newRow.getCell("barCode").setValue((Object)curCard.getBarCode());
            newRow.getCell("assetName").setValue((Object)curCard.getAssetName());
            newRow.getCell("assetCat").setValue((Object)curCard.getAssetCat().getName(this.currentOriginLocale));
            newRow.getCell("measureUnit").setValue((Object)curCard.getMeasureUnit().getName(this.currentOriginLocale));
            newRow.getCell("assetAmt").setValue((Object)curCard.getAssetAmt());
            if (newRow.getCell("splitAmt") != null) {
                newRow.getCell("splitAmt").setValue((Object)curCard.getAssetAmt());
            }
            newRow.getCell("originAmt").setValue((Object)curCard.getOriginAmt());
            newRow.getCell("addons").setValue((Object)curCard.getAddons());
            newRow.getCell("assetValue").setValue((Object)curCard.getAssetValue());
            newRow.getCell("accuDepr").setValue((Object)curCard.getAccuDepr());
            newRow.getCell("accuDeprTYear").setValue((Object)curCard.getAccuDeprTYear());
            newRow.getCell("buyValue").setValue((Object)curCard.getBuyValue());
            newRow.getCell("buyAccuDepr").setValue((Object)curCard.getBuyAccuDepr());
            newRow.getCell("neatRemValue").setValue((Object)curCard.getNeatAmt());
            newRow.getCell("decValue").setValue((Object)curCard.getDecValue());
            newRow.getCell("neatValue").setValue((Object)curCard.getNeatValue());
            newRow.getCell("id").setValue((Object)curCard.getId());
        }
    }

    private boolean isNeedDepreciation(FaCurCardInfo cardInfo) {
        FaCurCardCollection cardCollection = new FaCurCardCollection();
        cardCollection.add(cardInfo);
        return this.isNeedDepreciation(cardCollection);
    }

    private boolean isNeedDepreciation(FaCurCardCollection cardCollection) {
        boolean result = false;
        try {
            result = FaDepCalFacadeFactory.getRemoteInstance().isNeedDep(cardCollection);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return result;
    }

    private FaCurCardInfo getCurCardInfo(String curCardID) {
        FaCurCardInfo curCardInfo = new FaCurCardInfo();
        try {
            SelectorItemCollection sic = FaBillEditUI.getCurCardSelectors(0);
            sic.add(new SelectorItemInfo("assetCat.calcuByEvaluate"));
            sic.add(new SelectorItemInfo("propertyValue.*"));
            curCardInfo = FaCurCardFactory.getRemoteInstance().getFaCurCardInfo((IObjectPK)new ObjectUuidPK(curCardID), sic);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return curCardInfo;
    }

    private FaCurCardCollection splitByAssetAmt(FaCurCardInfo srcCard, BigDecimal splitQuantity, PeriodInfo currPeriod, Map map) throws BOSException {
        BigDecimal tosubstract;
        FaCurCardCollection splitCardCol = new FaCurCardCollection();
        BigDecimal assetAmt = srcCard.getAssetAmt().divide(splitQuantity, this.getFAQuantityScale(), 4).setScale(this.getFAQuantityScale(), 4);
        if (assetAmt.multiply(splitQuantity.subtract(new BigDecimal("1"))).compareTo(srcCard.getAssetAmt()) >= 0 && (assetAmt = assetAmt.subtract(tosubstract = new BigDecimal(Math.pow(10.0, -1 * this.getFAQuantityScale())))).compareTo(zeroValue) <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)FaResUtil.getRes((String)"canNotDisAmount"));
            SysUtil.abort();
        }
        BigDecimal totalnumber = zeroValue;
        if (map != null) {
            totalnumber = (BigDecimal)map.get("totalNumber");
        }
        BigDecimal ratio = assetAmt.divide(srcCard.getAssetAmt(), 8, 4);
        BigDecimal srcValue = zeroValue;
        BigDecimal destValue = zeroValue;
        BigDecimal totaodestValue = zeroValue;
        Date srcAccDate = srcCard.getAccountDate();
        Date targetDate = srcCard.getAccountDate();
        if (srcAccDate.before(currPeriod.getBeginDate())) {
            targetDate = currPeriod.getBeginDate();
        } else if (srcAccDate.after(currPeriod.getEndDate())) {
            targetDate = currPeriod.getEndDate();
        }
        FaDefPropertyValueInfo srcPropertyValue = srcCard.getPropertyValue();
        if (srcPropertyValue != null && srcPropertyValue.getId() != null) {
            srcPropertyValue = FaDefCommonFacadeFactory.getRemoteInstance().getPropertyValueById(srcPropertyValue.getId().toString());
        }
        FaDefPropertyValueCollection sc = map != null ? SplitPropertyValue.splitByRateMap((FaDefPropertyValueInfo)srcPropertyValue, (Map)map) : SplitPropertyValue.splitByAvg((FaDefPropertyValueInfo)srcPropertyValue, (int)splitQuantity.intValue());
        for (int i = 0; i < splitQuantity.intValue(); ++i) {
            FaCurCardInfo splitCard = (FaCurCardInfo)srcCard.clone();
            splitCard.setPropertyValue(sc.get(i));
            splitCard.setId(null);
            Enumeration enumKeys = srcCard.keys();
            while (enumKeys.hasMoreElements()) {
                String element = (String)enumKeys.nextElement();
                if ("wrtyperiod".equals(element) || !(srcCard.get(element) instanceof BigDecimal)) continue;
                srcValue = (BigDecimal)srcCard.get(element);
                destValue = map == null ? srcValue.multiply(ratio).setScale(this.getCurrencyScale(), 4) : srcValue.multiply(new BigDecimal((String)map.get(new Integer(i + 1).toString()))).divide(totalnumber, this.getCurrencyScale(), 4);
                totaodestValue = totaodestValue.add(destValue);
                splitCard.put(element, destValue);
                if (i != splitQuantity.intValue() - 1) continue;
                if (map == null) {
                    splitCard.put(element, srcValue.subtract(destValue.multiply(new BigDecimal(i))).setScale(this.getCurrencyScale(), 4));
                    continue;
                }
                splitCard.put(element, srcValue.subtract(this.sumSplitValueByElement(element, splitCardCol)).setScale(this.getCurrencyScale(), 4));
            }
            if (i == splitQuantity.intValue() - 1) {
                if (map == null) {
                    splitCard.setAssetAmt(srcCard.getAssetAmt().subtract(assetAmt.multiply(new BigDecimal(i))).setScale(this.getFAQuantityScale(), 4));
                } else {
                    splitCard.setAssetAmt(srcCard.getAssetAmt().subtract(this.sumSplitValueByElement("assetAmt", splitCardCol)).setScale(this.getFAQuantityScale(), 4));
                }
            } else if (map == null) {
                splitCard.setAssetAmt(assetAmt);
            } else {
                splitCard.setAssetAmt(srcCard.getAssetAmt().multiply(new BigDecimal((String)map.get(new Integer(i + 1).toString()))).divide(totalnumber, this.getFAQuantityScale(), 4));
            }
            splitCard.setExRate(srcCard.getExRate());
            splitCard.setDeprTermCount(srcCard.getDeprTermCount());
            splitCard.setUseYears(srcCard.getUseYears());
            splitCard.setUseTermCount(srcCard.getUseTermCount());
            splitCard.setTempDeprTermCount(srcCard.getTempDeprTermCount());
            splitCard.setTempUseTermCount(srcCard.getTempUseTermCount());
            splitCard.setNeatLeftRate(srcCard.getNeatLeftRate());
            splitCard.setEvalNeatLeftRate(srcCard.getEvalNeatLeftRate());
            splitCard.setEvalLeftPeriod(srcCard.getEvalLeftPeriod());
            splitCard.setEvalDeprPeriodNum(srcCard.getEvalDeprPeriodNum());
            splitCard.setEvalUseTermCount(srcCard.getEvalUseTermCount());
            splitCard.setEvalTaxLeftPeriod(srcCard.getEvalTaxLeftPeriod());
            splitCard.setEvalMonthRate(srcCard.getEvalMonthRate());
            splitCard.setEvalDeprTTerm(zeroValue);
            splitCard.setInputTax(zeroValue);
            splitCard.setAccountDate(srcCard.getAccountDate());
            splitCard.setGroupNumber(null);
            splitCard.setBarCode(null);
            this.calNeat(srcCard, splitCard);
            splitCardCol.add(splitCard);
        }
        return splitCardCol;
    }

    private FaCurCardCollection splitByAssetValue(FaCurCardInfo srcCard, BigDecimal splitQuantity, PeriodInfo currPeriod, Map map) throws BOSException {
        FaCurCardCollection splitCardCol = new FaCurCardCollection();
        BigDecimal srcValue = zeroValue;
        BigDecimal destValue = zeroValue;
        BigDecimal totalnumber = zeroValue;
        if (map != null) {
            totalnumber = (BigDecimal)map.get("totalNumber");
        }
        Date srcAccDate = srcCard.getAccountDate();
        Date targetDate = srcCard.getAccountDate();
        if (srcAccDate.before(currPeriod.getBeginDate())) {
            targetDate = currPeriod.getBeginDate();
        } else if (srcAccDate.after(currPeriod.getEndDate())) {
            targetDate = currPeriod.getEndDate();
        }
        FaDefPropertyValueInfo srcPropertyValue = srcCard.getPropertyValue();
        if (srcPropertyValue != null && srcPropertyValue.getId() != null) {
            srcPropertyValue = FaDefCommonFacadeFactory.getRemoteInstance().getPropertyValueById(srcPropertyValue.getId().toString());
        }
        FaDefPropertyValueCollection sc = map != null ? SplitPropertyValue.splitByRateMap((FaDefPropertyValueInfo)srcPropertyValue, (Map)map) : SplitPropertyValue.splitByAvg((FaDefPropertyValueInfo)srcPropertyValue, (int)splitQuantity.intValue());
        for (int i = 0; i < splitQuantity.intValue(); ++i) {
            FaCurCardInfo splitCard = (FaCurCardInfo)srcCard.clone();
            splitCard.setPropertyValue(sc.get(i));
            splitCard.setId(null);
            Enumeration enumKeys = srcCard.keys();
            while (enumKeys.hasMoreElements()) {
                String element = (String)enumKeys.nextElement();
                if ("wrtyperiod".equals(element) || !(srcCard.get(element) instanceof BigDecimal)) continue;
                srcValue = (BigDecimal)srcCard.get(element);
                destValue = map == null ? srcValue.divide(splitQuantity, this.getCurrencyScale(), 4).setScale(this.getCurrencyScale(), 4) : srcValue.multiply(new BigDecimal((String)map.get(new Integer(i + 1).toString()))).divide(totalnumber, this.getCurrencyScale(), 4);
                splitCard.put(element, destValue);
                if (i != splitQuantity.intValue() - 1) continue;
                if (map == null) {
                    splitCard.put(element, srcValue.subtract(destValue.multiply(new BigDecimal(i))).setScale(this.getCurrencyScale(), 4));
                    continue;
                }
                splitCard.put(element, srcValue.subtract(this.sumSplitValueByElement(element, splitCardCol)).setScale(this.getCurrencyScale(), 4));
            }
            splitCard.setAssetAmt(srcCard.getAssetAmt());
            splitCard.setExRate(srcCard.getExRate());
            splitCard.setDeprTermCount(srcCard.getDeprTermCount());
            splitCard.setUseYears(srcCard.getUseYears());
            splitCard.setUseTermCount(srcCard.getUseTermCount());
            splitCard.setTempDeprTermCount(srcCard.getTempDeprTermCount());
            splitCard.setTempUseTermCount(srcCard.getTempUseTermCount());
            splitCard.setNeatLeftRate(srcCard.getNeatLeftRate());
            splitCard.setEvalNeatLeftRate(srcCard.getEvalNeatLeftRate());
            splitCard.setEvalLeftPeriod(srcCard.getEvalLeftPeriod());
            splitCard.setEvalDeprPeriodNum(srcCard.getEvalDeprPeriodNum());
            splitCard.setEvalUseTermCount(srcCard.getEvalUseTermCount());
            splitCard.setEvalTaxLeftPeriod(srcCard.getEvalTaxLeftPeriod());
            splitCard.setEvalMonthRate(srcCard.getEvalMonthRate());
            splitCard.setEvalDeprTTerm(zeroValue);
            splitCard.setInputTax(zeroValue);
            splitCard.setAccountDate(srcCard.getAccountDate());
            splitCard.setGroupNumber(null);
            splitCard.setBarCode(null);
            this.calNeat(srcCard, splitCard);
            splitCardCol.add(splitCard);
        }
        return splitCardCol;
    }

    protected int getCurrencyScale() {
        if (this.currencyScale == -1) {
            try {
                this.currencyScale = FaClientUtils.getCurrencyScale(this.getCurrentCompany());
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return this.currencyScale == -1 ? 2 : this.currencyScale;
    }

    protected int getFAQuantityScale() {
        String scale = null;
        try {
            scale = (String)this.getFaParameter().get("FA_008");
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return scale == null ? 0 : Integer.valueOf(scale);
    }

    protected HashMap getFaParameter() throws Exception {
        if (this.faParameter == null) {
            this.faParameter = FaClientUtils.getFAParameter(this.getCurrentCompany().getId());
        }
        return this.faParameter;
    }

    private CompanyOrgUnitInfo getCurrentCompany() {
        if (this.currCompany == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("baseCurrency.id"));
            try {
                BOSUuid id = SysContext.getSysContext().getCurrentFIUnit().getId();
                this.currCompany = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(id), sic);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
        return this.currCompany;
    }

    private BigDecimal sumSplitValueByElement(String element, FaCurCardCollection splitCardCol) {
        BigDecimal sum = zeroValue;
        for (int i = 0; i < splitCardCol.size(); ++i) {
            FaCurCardInfo splitCard = splitCardCol.get(i);
            sum = sum.add(new BigDecimal(splitCard.get(element).toString()));
        }
        return sum;
    }

    private void calNeat(FaCardInfo srcCard, FaCardInfo destCard) {
        FaCatInfo aFaCatInfo = srcCard.getAssetCat();
        BigDecimal amount = aFaCatInfo != null && aFaCatInfo.isCalcuByEvaluate() && srcCard.getInitEvalValue() != null ? destCard.getInitEvalValue() : destCard.getAssetValue();
        if (amount == null) {
            return;
        }
        BigDecimal addUPDep = destCard.getAccuDepr() == null ? zeroValue : destCard.getAccuDepr();
        BigDecimal decPrepare = destCard.getDecValue() == null ? zeroValue : destCard.getDecValue();
        BigDecimal netValue = amount.subtract(addUPDep);
        destCard.setNeatValue(netValue);
        BigDecimal netRemValue = netValue.subtract(decPrepare);
        destCard.setNeatRemValue(netRemValue);
        BigDecimal netAmount = netValue.subtract(decPrepare);
        destCard.setNeatAmt(netAmount);
        BigDecimal evalNetValue = (destCard.getEvalAssetValue() == null ? zeroValue : destCard.getEvalAssetValue()).subtract(destCard.getEvalAddDepr() == null ? zeroValue : destCard.getEvalAddDepr());
        destCard.setEvalNeatValue(evalNetValue);
        destCard.setEvalNeatAmt(destCard.getEvalNeatValue().subtract(destCard.getEvalDecValue() == null ? zeroValue : destCard.getEvalDecValue()));
    }

    private void refreshDestTable() throws Exception {
        PeriodInfo currPeriod = FaClientUtils.getFACurrentPeriod();
        this.destTable.removeRows();
        this.destCardMap.clear();
        BigDecimal totalSplitAmt = zeroValue;
        for (int idx = 0; idx < this.srcTable.getRowCount(); ++idx) {
            IRow row = this.srcTable.getRow(idx);
            String id = row.getCell("id").getValue().toString();
            FaCurCardInfo srcCard = this.srcCardMap.get(id);
            BigDecimal splitAmt = (BigDecimal)row.getCell("splitAmt").getValue();
            totalSplitAmt = totalSplitAmt.add(splitAmt);
            FaCurCardCollection curCardCol = null;
            if (this.comboSplitType.getSelectedItem() == FaSplitTypeEnum.BY_AMOUNT) {
                curCardCol = this.splitByAssetValue(srcCard, splitAmt, currPeriod, null);
            } else if (this.comboSplitType.getSelectedItem() == FaSplitTypeEnum.BY_QUANTITY) {
                curCardCol = this.splitByAssetAmt(srcCard, splitAmt, currPeriod, null);
            }
            this.insertTable(this.destTable, curCardCol);
            this.destCardMap.put(id, curCardCol);
        }
        this.txtDestCardNum.setValue((Object)totalSplitAmt);
    }

    protected CommonQueryWithResultDialog initCardSelectDialog() throws Exception {
        CommonQueryWithResultDialog dialog = new CommonQueryWithResultDialog();
        if (this.getUIWindow() == null) {
            dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            dialog.setOwner((Component)((Object)this));
        }
        HashMap hmParam = this.getFaParameter();
        boolean isRange = "true".equals(hmParam.get("FA_040").toString());
        FACommonProcessor processor = new FACommonProcessor();
        processor.setRange(isRange);
        dialog.setProcessor((IProcessor)processor);
        dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        dialog.setEntityViewInfo(new EntityViewInfo());
        dialog.setQueryObjectPK((IMetaDataPK)this.getListUIQuery());
        dialog.setTitle(this.getUITitle());
        dialog.setHeight(525);
        dialog.setSelectMode(this.getCardFilterSelectMode());
        dialog.setOpenType(this.getCardFilterOpenType());
        dialog.setFilterInfo(this.getCardFilter());
        return dialog;
    }

    protected int getCardFilterSelectMode() {
        return 10;
    }

    protected int getCardFilterOpenType() {
        return -1;
    }

    protected FilterInfo getCardFilter() {
        FilterInfo filter = new FilterInfo();
        HashSet<String> ids = new HashSet<String>();
        for (int idx = 0; idx < this.srcTable.getRowCount(); ++idx) {
            IRow row = this.srcTable.getRow(idx);
            String id = row.getCell("id").getValue().toString();
            ids.add(id);
        }
        filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.NOTINCLUDE));
        return filter;
    }

    protected MetaDataPK getListUIQuery() {
        return new MetaDataPK("com.kingdee.eas.fi.fa.manage", "FaCurCardQuery");
    }

    protected void verifyBeforeSubmit(ActionEvent e) throws Exception {
        BigDecimal destCardNum;
        Integer srcCardNum;
        if (this.dateSplitDate.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)FaResUtil.getRes((String)"disDateIsNotNull"));
            this.dateSplitDate.requestFocus();
            SysUtil.abort();
        } else {
            Date changeDate = (Date)this.dateSplitDate.getValue();
            PeriodInfo aPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.currCompany);
            if (aPeriodInfo != null && (DateTimeUtils.dayBefore((Date)changeDate, (Date)aPeriodInfo.getBeginDate()) || DateTimeUtils.dayAfter((Date)changeDate, (Date)aPeriodInfo.getEndDate()))) {
                MsgBox.showInfo((Component)((Object)this), (String)FaResUtil.getRes((String)"disDateIsPeriod"));
                SysUtil.abort();
            }
        }
        if (this.prmtClearMode.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)FaResUtil.getRes((String)"cleanMethodIsNotNull"));
            this.prmtClearMode.requestFocus();
            SysUtil.abort();
        }
        if (this.prmtSpliter.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)FaResUtil.getRes((String)"disPersonNull"));
            this.prmtSpliter.requestFocus();
            SysUtil.abort();
        }
        if ((srcCardNum = (Integer)this.txtSrcCardNum.getValue()) == null || srcCardNum == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)FaResUtil.getRes((String)"srcCardIsNull"));
            SysUtil.abort();
        }
        if ((destCardNum = (BigDecimal)this.txtDestCardNum.getValue()) == null || destCardNum.compareTo(zeroValue) == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)FaResUtil.getRes((String)"destCardIsNull"));
            SysUtil.abort();
        }
        if (destCardNum != null && destCardNum.compareTo(new BigDecimal(this.destTable.getRowCount())) != 0) {
            MsgBox.showInfo((Component)((Object)this), (String)FaResUtil.getRes((String)"destNumNotEqual"));
            SysUtil.abort();
        }
    }

    private FaBizCardInfo curCard2BizCard(FaCurCardInfo curCard) throws Exception {
        FaBizCardInfo bizCardInfo = FaClientUtils.CurCard2BizCard(curCard);
        bizCardInfo.setNumber(null);
        bizCardInfo.setFaBakCard(null);
        bizCardInfo.setHasDisabled(false);
        bizCardInfo.setBizStatus(FaBizStatusEnum.ADDING);
        bizCardInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        bizCardInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
        bizCardInfo.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        bizCardInfo.setOriginFlag(FaCardOriginEnum.ADDNEW);
        bizCardInfo.setHasCleared(FaClearStatusEnum.HasNotCleared);
        bizCardInfo.setFiVouchered(false);
        bizCardInfo.setIsNeedReDepr(false);
        bizCardInfo.setLastBillID(null);
        bizCardInfo.setHasDisabled(false);
        bizCardInfo.setHasSplited(false);
        bizCardInfo.setHasEvaled(false);
        bizCardInfo.setHasChanged(FaChangeStatusEnmu.HasNotChanged);
        bizCardInfo.setSourceBillId(null);
        bizCardInfo.setBillType(FaBillTypeEnum.ADDNEW);
        bizCardInfo.setPeriod(FaClientUtils.getFACurrentPeriod());
        bizCardInfo.setFiAccountDate((Date)this.dateSplitDate.getValue());
        if ("true".equals(this.getFaParameter().get("FA_021").toString())) {
            bizCardInfo.setEvalReInAccountDate((Date)this.dateSplitDate.getValue());
        }
        bizCardInfo.setOriginFlag(FaCardOriginEnum.SPLIT);
        UserInfo aUserInfo = SysContext.getSysContext().getCurrentUserInfo();
        bizCardInfo.setHandler(aUserInfo);
        bizCardInfo.setAuditor(null);
        bizCardInfo.setBizDate(null);
        bizCardInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        bizCardInfo.setHasNew(true);
        bizCardInfo.setDeprTTerm(zeroValue);
        bizCardInfo.setMonthDepreRate(zeroValue);
        bizCardInfo.put("MARK_DIRTY", Boolean.TRUE);
        return bizCardInfo;
    }

    public void runBatchSubmit() throws Exception {
        for (int idx = 0; idx < this.srcTable.getRowCount(); ++idx) {
            IRow row = this.srcTable.getRow(idx);
            String id = row.getCell("id").getValue().toString();
            FaCurCardInfo srcCard = this.srcCardMap.get(id);
            BigDecimal splitAmt = (BigDecimal)row.getCell("splitAmt").getValue();
            FaSplitBillInfo splitBill = new FaSplitBillInfo();
            splitBill.setSplitDate((Date)this.dateSplitDate.getValue());
            splitBill.setClearMode((FaAlterModeInfo)this.prmtClearMode.getValue());
            splitBill.setSplitPerson((PersonInfo)this.prmtSpliter.getValue());
            splitBill.setSplitType((FaSplitTypeEnum)((Object)this.comboSplitType.getSelectedItem()));
            splitBill.setQuantity(splitAmt);
            splitBill.setFaCurCard(srcCard);
            splitBill.setDeletedStatus(DeletedStatusEnum.NORMAL);
            splitBill.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
            splitBill.setCompany(this.getCurrentCompany());
            splitBill.setPeriod(FaClientUtils.getFACurrentPeriod());
            splitBill.setHandler(SysContext.getSysContext().getCurrentUserInfo());
            FaCurCardCollection splitCardCol = this.destCardMap.get(id);
            if (splitCardCol.size() < 2) continue;
            FaSplitBillEntryCollection splitEntryCol = new FaSplitBillEntryCollection();
            for (int idx2 = 0; idx2 < splitCardCol.size(); ++idx2) {
                FaSplitBillEntryInfo entry = new FaSplitBillEntryInfo();
                entry.setFaBizCard(this.curCard2BizCard(splitCardCol.get(idx2)));
                entry.setSeq(idx2 + 1);
                splitEntryCol.add(entry);
            }
            splitBill.getFaSplitBillEntry().addCollection(splitEntryCol);
            this.getBizInterface().submit((CoreBaseInfo)splitBill);
        }
    }

    @Override
    public void actionHalfSplit_actionPerformed(ActionEvent e) throws Exception {
        for (int idx = 0; idx < this.srcTable.getRowCount(); ++idx) {
            BigDecimal splitAmt;
            IRow row = this.srcTable.getRow(idx);
            BigDecimal assetAmt = (BigDecimal)row.getCell("assetAmt").getValue();
            if (assetAmt.compareTo(splitAmt = (BigDecimal)row.getCell("splitAmt").getValue()) < 0 && this.getFAQuantityScale() == 0 && this.comboSplitType.getSelectedItem() == FaSplitTypeEnum.BY_QUANTITY) {
                MsgBox.showInfo((Component)((Object)this), (String)FaResUtil.getRes((String)"canNotDisAmount"));
                SysUtil.abort();
            }
            if (splitAmt.compareTo(new BigDecimal(2)) >= 0) continue;
            MsgBox.showInfo((Component)((Object)this), (String)FaResUtil.getRes((String)"splitAmtMustGtThanOne"));
            SysUtil.abort();
        }
        this.refreshDestTable();
    }

    @Override
    public void actionAddCard_actionPerformed(ActionEvent e) throws Exception {
        CommonQueryWithResultDialog dialog = this.initCardSelectDialog();
        if (dialog.show() || dialog.hasKeyValue()) {
            ArrayList result = dialog.getSearchResult();
            FaCurCardCollection newAddCol = new FaCurCardCollection();
            if (result != null && result.size() > 0) {
                for (int idx = 0; idx < result.size(); ++idx) {
                    IRow row = (IRow)result.get(idx);
                    String id = row.getCell("id").getValue().toString();
                    FaCurCardInfo curCard = this.getCurCardInfo(id);
                    this.srcCardMap.put(id, curCard);
                    newAddCol.add(curCard);
                }
            }
            this.insertTable(this.srcTable, newAddCol);
            this.txtSrcCardNum.setValue((Object)this.srcTable.getRowCount());
            this.refreshDestTable();
        } else {
            SysUtil.abort();
        }
    }

    @Override
    public void actionDelCard_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.tableDelLine(this.srcTable);
        this.txtSrcCardNum.setValue((Object)this.srcTable.getRowCount());
        this.refreshDestTable();
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        this.verifyBeforeSubmit(e);
        this.runBatchSubmit();
        this.getUIWindow().close();
    }

    @Override
    public void actionCANCEL_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }
}

