/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaBillTraceUI;
import com.kingdee.eas.fi.fa.manage.client.FaChangeBillListUI;
import com.kingdee.eas.fi.fa.manage.client.FaStocktakingAPListUI;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class FaBillTraceUI
extends AbstractFaBillTraceUI {
    private static final long serialVersionUID = 7485794611375135052L;
    private Vector BOSTypeVector = new Vector();
    private ListUI curentBillListUI = null;
    private static final String RESXFILENAME = "com.kingdee.eas.base.btp.btpResource";
    protected HashMap displayIDList;
    protected String isFromBook = null;
    private String billInfoID = null;

    public void onLoad() throws Exception {
        this.actionAttachment.setEnabled(false);
        this.actionAttachment.setVisible(false);
        if (this.getUIContext().get("isFromBook") != null) {
            this.isFromBook = "Y";
        }
        if (this.getUIContext().get("IDList") != null) {
            this.displayIDList = (HashMap)this.getUIContext().get("IDList");
            this.refreshTP(this.displayIDList);
        } else {
            MsgBox.showInfo((String)FaResUtil.getRes((String)"noEntries"));
            SysUtil.abort();
        }
        this.btnView.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        if (this.curentBillListUI instanceof FaStocktakingAPListUI) {
            this.btnView.setEnabled(false);
            this.btnView.setVisible(false);
        }
    }

    public void onShow() throws Exception {
        this.tpRelatedBills.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                KDTabbedPane tabpane = (KDTabbedPane)e.getSource();
                KDPanel curKDPanel = (KDPanel)tabpane.getSelectedComponent();
                if (curKDPanel != null && curKDPanel.getComponent(0) instanceof ListUI) {
                    FaBillTraceUI.this.curentBillListUI = (ListUI)curKDPanel.getComponent(0);
                }
            }
        });
    }

    private void runActionView(ListUI billListUI) throws Exception {
        ActionEvent e = new ActionEvent(this.btnView, 0, "View");
        if (billListUI == null) {
            return;
        }
        billListUI.actionView_actionPerformed(e);
    }

    public void actionNavView_actionPerformed(ActionEvent e) throws Exception {
        this.runActionView(this.curentBillListUI);
    }

    private String getTableColumnFieldNameByPropName(String propName, String BOSType) throws Exception {
        IBTPManager iBTPManager = BTPManagerFactory.getRemoteInstance();
        String billClassName = iBTPManager.getClassNameByBOSType(BOSType);
        String[] billClassNameArray = StringUtils.split((String)billClassName, (String)".");
        billClassName = billClassNameArray[billClassNameArray.length - 1];
        if (StringUtils.split((String)propName, (String)".").length == 1) {
            boolean isOwner = iBTPManager.isPropOwner(BOSType, propName);
            propName = !isOwner ? propName + ".id" : billClassName + "." + propName;
        }
        String tableColumnName = iBTPManager.getTableColumnFieldNameByPropName(BOSType, propName);
        return tableColumnName;
    }

    private void initQueryInfoFilter(ListUI billListUI, Vector billInfos) throws Exception {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer maskString = new StringBuffer();
        maskString.append("(");
        for (int i = 0; i < billInfos.size(); ++i) {
            if (i != 0) {
                maskString.append(" or ");
            }
            maskString.append("#" + i);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)((String)billInfos.get(i)), CompareType.EQUALS));
        }
        maskString.append(")");
        filter.setMaskString(maskString.toString());
        entityViewInfo.setFilter(filter);
        if (!(billListUI instanceof FaChangeBillListUI)) {
            billListUI.setDataObject((IObjectValue)entityViewInfo);
        }
        billListUI.getUIContext().put("BOTPFilter", entityViewInfo);
        billListUI.getUIContext().put("isFromBook", this.isFromBook);
        billListUI.getMainTable().getStyleAttributes().setLocked(true);
        billListUI.onLoad();
        EventListenerList list = billListUI.getMainTable().getListenerList();
        for (int i = ((KDTSelectListener[])list.getListeners(KDTSelectListener.class)).length - 1; i >= 0; --i) {
            billListUI.getMainTable().removeKDTSelectListener(((KDTSelectListener[])list.getListeners(KDTSelectListener.class))[i]);
        }
        billListUI.getMainTable().getSelectManager().setSelectMode(2);
    }

    private void refreshTP(HashMap hashMap) throws Exception {
        int compnentNum;
        for (int i = compnentNum = this.tpRelatedBills.getTabCount(); i > 0; --i) {
            this.tpRelatedBills.remove(i - 1);
        }
        this.BOSTypeVector = new Vector();
        IBTPManager iBTPManager = BTPManagerFactory.getRemoteInstance();
        Iterator itr = hashMap.keySet().iterator();
        int tabNumbers = 0;
        while (itr.hasNext()) {
            String key = (String)itr.next();
            String displayString = iBTPManager.getEntityObjectInfoDisplayName(key);
            String listUIName = iBTPManager.getEntityObjectInfoExtendPro(key, "listUI");
            if (listUIName != null && listUIName.trim().length() > 0) {
                Class<?> c = Class.forName(listUIName);
                ListUI billListUI = (ListUI)c.newInstance();
                billListUI.initLayout();
                billListUI.getUIContext().put("OwnerWindow", this.getUIContext().get("OwnerWindow"));
                billListUI.getUIContext().put("oprState", "VIEW");
                billListUI.getUIContext().put("TRACE_UP_DOWN", Boolean.TRUE);
                billListUI.getUIContext().put("BOTPViewStatus", new Integer(1));
                int width = 1024;
                int height = 768;
                billListUI.getUIContentPane().setSize(new Dimension(width, height));
                billListUI.setOprtState(OprtState.VIEW);
                KDTable kdTable = billListUI.getMainTable();
                kdTable.setBounds(new Rectangle(10, 10, width - 10, height - 10));
                KDPanel panel = new KDPanel();
                panel.setLayout((LayoutManager)new BorderLayout());
                panel.add((Component)billListUI, (Object)"Center");
                panel.validate();
                this.tpRelatedBills.addTab(displayString, (Component)panel);
                this.BOSTypeVector.add(key);
                this.initQueryInfoFilter(billListUI, (Vector)hashMap.get(key));
                ++tabNumbers;
            }
            if (tabNumbers != 0) continue;
            MsgBox.showError((String)EASResource.getString((String)RESXFILENAME, (String)"canNotNav"));
            SysUtil.abort();
        }
        if (this.innerGetListUIComponent() != null && this.innerGetListUIComponent() instanceof ListUI) {
            this.curentBillListUI = (ListUI)this.innerGetListUIComponent();
        }
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        if (this.curentBillListUI == null) {
            return;
        }
        this.preparePrintPage(this.curentBillListUI.getMainTable());
        this.curentBillListUI.getMainTable().getPrintManager().print();
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        if (this.curentBillListUI == null) {
            return;
        }
        this.preparePrintPage(this.curentBillListUI.getMainTable());
        this.curentBillListUI.getMainTable().getPrintManager().printPreview();
    }

    public void actionViewPrev_actionPerformed(ActionEvent e) throws Exception {
        this.getSelectedBillID();
        RequestContext request = new RequestContext();
        request = this.prepareAction(request);
        request.setMethodName("handleActionViewPrev");
        request.put("BTPRelationNavUI_ActionViewPrev_billInfoID", (Object)this.billInfoID);
        this.prepareRPC(request).callHandler();
        IBOTRelation iBOTRelation = BOTRelationFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)this.billInfoID, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        BOTRelationCollection relations = iBOTRelation.getCollection(viewInfo);
        Vector<String> srcBillIDs = new Vector<String>();
        if (relations == null || relations.size() == 0) {
            throw new BTPException(BTPException.SRCBILLTYPENULL);
        }
        for (int i = 0; i < relations.size(); ++i) {
            srcBillIDs.add(relations.get(i).getSrcObjectID());
        }
        HashMap billTypes = this.getRelatedBillType(srcBillIDs);
        this.refreshTP(billTypes);
    }

    public void actionViewNext_actionPerformed(ActionEvent e) throws Exception {
        this.getSelectedBillID();
        RequestContext request = new RequestContext();
        request = this.prepareAction(request);
        request.setMethodName("handleActionViewNext");
        request.put("BTPRelationNavUI_ActionViewNext_billInfoID", (Object)this.billInfoID);
        this.prepareRPC(request).callHandler();
        IBOTRelation iBOTRelation = BOTRelationFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)this.billInfoID, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        BOTRelationCollection relations = iBOTRelation.getCollection(viewInfo);
        if (relations == null || relations.size() == 0) {
            throw new BTPException(BTPException.DESTBILLNULL);
        }
        Vector<String> destBillIDs = new Vector<String>();
        for (int i = 0; i < relations.size(); ++i) {
            destBillIDs.add(relations.get(i).getDestObjectID());
        }
        HashMap billTypes = this.getRelatedBillType(destBillIDs);
        this.refreshTP(billTypes);
    }

    private void getSelectedBillID() throws BTPException, Exception {
        KDTable kdTable;
        HashMap columnFieldTOName = new HashMap();
        HashMap columnNameTOField = new HashMap();
        if (this.innerGetListUIComponent() != null) {
            kdTable = ((ListUI)this.innerGetListUIComponent()).getMainTable();
            this.getColumnFieldNameVector(kdTable, columnFieldTOName, columnNameTOField);
            if (kdTable.getSelectManager().getActiveRowIndex() < 0) {
                throw new BTPException(BTPException.NOSELECTROW);
            }
        } else {
            throw new BTPException(BTPException.NOSELECTROW);
        }
        IRow iRow = kdTable.getRow(kdTable.getSelectManager().getActiveRowIndex());
        this.billInfoID = this.getSelectedRowKeyColumnValue(iRow, columnFieldTOName, columnNameTOField);
    }

    private Component innerGetListUIComponent() {
        if (this.tpRelatedBills == null || (KDPanel)this.tpRelatedBills.getSelectedComponent() == null || ((KDPanel)this.tpRelatedBills.getSelectedComponent()).getComponentCount() <= 0) {
            return null;
        }
        return ((KDPanel)this.tpRelatedBills.getSelectedComponent()).getComponent(0);
    }

    private void getColumnFieldNameVector(KDTable kdTable, HashMap columnFieldTOName, HashMap columnNameTOField) {
        for (int i = 0; i < kdTable.getColumnCount(); ++i) {
            columnFieldTOName.put(kdTable.getColumn(i).getFieldName(), kdTable.getColumn(i).getKey());
            columnNameTOField.put(kdTable.getColumn(i).getKey(), kdTable.getColumn(i).getFieldName());
        }
    }

    private String getSelectedRowKeyColumnValue(IRow iRow, HashMap columnFieldTOName, HashMap columnNameTOField) throws Exception {
        String selectedBOSType = (String)this.BOSTypeVector.get(this.tpRelatedBills.getSelectedIndex());
        String tableColunmField = this.getTableColumnFieldNameByPropName("id", selectedBOSType);
        String keyValue = iRow.getCell((String)columnFieldTOName.get(tableColunmField)).getValue().toString();
        return keyValue;
    }

    private HashMap getRelatedBillType(Vector billCollection) throws BTPException {
        HashMap hashMap = new HashMap();
        if (billCollection != null) {
            for (int i = 0; i < billCollection.size(); ++i) {
                String BOSTypeString = BOSUuid.read((String)((String)billCollection.get(i))).getType().toString();
                if (!hashMap.containsKey(BOSTypeString)) {
                    Vector vector = new Vector();
                    vector.add(billCollection.get(i));
                    hashMap.put(BOSTypeString, vector);
                    continue;
                }
                if (((Vector)hashMap.get(BOSTypeString)).contains(billCollection.get(i))) continue;
                ((Vector)hashMap.get(BOSTypeString)).add(billCollection.get(i));
            }
        } else {
            throw new BTPException(BTPException.BILLNORELATEDBILL);
        }
        return hashMap;
    }
}

