/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.FaAlterModeFactory;
import com.kingdee.eas.fi.fa.basedata.FaAlterModeInfo;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.basedata.client.FaAlterModePromptBox;
import com.kingdee.eas.fi.fa.basedata.client.FaDisplyFormatter;
import com.kingdee.eas.fi.fa.basedata.client.FaEditFormatter;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaMaintainEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaMaintainEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaMaintainEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaMaintainFactory;
import com.kingdee.eas.fi.fa.manage.FaMaintainInfo;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.fi.fa.manage.IFaMaintain;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaCapitalizationUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class FaCapitalizationUI
extends AbstractFaCapitalizationUI {
    private static final Logger logger = CoreUIObject.getLogger(FaCapitalizationUI.class);
    private HashMap displayIDList;
    private BigDecimal costCap;
    private CompanyOrgUnitInfo currentCompany;
    private int scale;
    protected int currencyScale = -1;
    private FaMaintainInfo faMaintainInfo;
    private HashMap dataMap = new HashMap();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.tbMain.checkParsed();
        if (this.getUIContext().get("values") != null) {
            this.displayIDList = (HashMap)this.getUIContext().get("values");
            this.initCapData(this.displayIDList);
        } else {
            MsgBox.showInfo((String)FaResUtil.getRes((String)"noEntries"));
            SysUtil.abort();
        }
        super.onLoad();
        this.currentCompany = this.getCurrentCompany();
        this.initTblMainColumnOnlyMumeric();
        Color color = new Color(0xD9D9D2);
        this.tbMain.getColumn("id").getStyleAttributes().setHided(true);
        this.tbMain.getColumn("FaCurCard.number").getStyleAttributes().setBackground(color);
        this.tbMain.getColumn("FaCurCard.assetName").getStyleAttributes().setBackground(color);
        this.tbMain.getColumn("FaCurCar.spec").getStyleAttributes().setBackground(color);
        this.tbMain.getColumn("FaCurCard.number").getStyleAttributes().setLocked(true);
        this.tbMain.getColumn("FaCurCard.assetName").getStyleAttributes().setLocked(true);
        this.tbMain.getColumn("FaCurCar.spec").getStyleAttributes().setLocked(true);
    }

    protected void initControl() throws Exception {
        CurrencyInfo srcCyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectStringPK(this.faMaintainInfo.getCurrency().getId().toString()));
        this.scale = srcCyInfo.getPrecision();
        this.realcost.setDataType(1);
        this.realcost.setHorizontalAlignment(4);
        this.realcost.setNegatived(false);
        this.realcost.setMinimumValue((Comparable)new BigDecimal("0"));
        this.realcost.setSupportedEmpty(true);
        this.realcost.setPrecision(srcCyInfo.getPrecision());
        this.cost.setDataType(1);
        this.cost.setHorizontalAlignment(4);
        this.cost.setNegatived(false);
        this.cost.setMinimumValue((Comparable)new BigDecimal("0"));
        this.cost.setSupportedEmpty(true);
        this.cost.setPrecision(srcCyInfo.getPrecision());
        FaAlterModePromptBox bFaAlterModePromptBox = new FaAlterModePromptBox((CoreUIObject)this, true);
        this.fangshi.setSelector((KDPromptSelector)bFaAlterModePromptBox);
        this.fangshi.setDisplayFormatter((IFormatter)new FaDisplyFormatter());
        this.fangshi.setEditFormatter((IFormatter)new FaEditFormatter());
        this.fangshi.setEntityViewInfo(FaClientUtils.getAlterModeOrgSplitViewInfo(true));
    }

    protected void initTblMainColumnOnlyMumeric() throws Exception {
        KDFormattedTextField txtOnlyMumeric = new KDFormattedTextField();
        txtOnlyMumeric.setDataType(1);
        txtOnlyMumeric.setPrecision(this.scale);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)txtOnlyMumeric);
        this.tbMain.getColumn("onecost").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtOnlyMumeric));
        this.tbMain.getColumn("FaMaintain.expenseApportionScale").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtOnlyMumeric));
        FaClientUtils.changeTableNumberFormat(this.tbMain, new String[]{"onecost"}, FaClientUtils.getDecimalFormat(this.scale));
        FaClientUtils.changeTableNumberFormat(this.tbMain, new String[]{"FaMaintain.expenseApportionScale"}, FaClientUtils.getDecimalFormat(2));
    }

    protected void initAmountScal() throws Exception {
        String[] formatColumns = new String[]{"FaMaintain.expenseApportionScale", "onecost"};
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("precision"));
        int currencyScale = -1;
        ObjectUuidPK currencyPk = new ObjectUuidPK(this.currentCompany.getBaseCurrency().getId());
        try {
            CurrencyInfo currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)currencyPk, sic);
            currencyScale = currencyInfo.getPrecision();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        FaClientUtils.changeTableNumberFormat(this.tbMain, formatColumns, FaClientUtils.getFormatPatternForColumn(currencyScale));
    }

    private CompanyOrgUnitInfo getCurrentCompany() {
        if (this.currentCompany == null) {
            String companyId = null;
            if (this.getUIContext().get("Link") != null && this.getUIContext().get("Link").equals(Boolean.TRUE) && this.getUIContext().get("COMPANY_ID") != null) {
                companyId = this.getUIContext().get("COMPANY_ID").toString();
            } else if (FaClientUtils.isFromWorkflow(this.getUIContext())) {
                BillBaseInfo initObj = null;
                if (this.getUIContext().get("ID") != null) {
                    String id = this.getUIContext().get("ID").toString();
                    try {
                        initObj = (BillBaseInfo)this.getBizInterface().getValue("select company.id where id='" + id + "'");
                    }
                    catch (Exception e) {
                        this.handleException(e);
                        SysUtil.abort();
                    }
                }
                companyId = initObj == null ? SysContext.getSysContext().getCurrentFIUnit().getId().toString() : initObj.getCompany().getId().toString();
            } else {
                companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            }
            try {
                this.currentCompany = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyId)));
            }
            catch (Exception e) {
                this.handleException(e);
                SysUtil.abort();
            }
        }
        return (CompanyOrgUnitInfo)this.currentCompany.clone();
    }

    protected KDTable getDetailTable() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FaMaintainFactory.getRemoteInstance();
    }

    @Override
    protected void tbMain_editStopped(KDTEditEvent e) throws Exception {
        BigDecimal scale;
        Object value;
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        if (this.tbMain.getColumn("FaMaintain.expenseApportionScale") != null && colIndex == this.tbMain.getColumn("FaMaintain.expenseApportionScale").getColumnIndex() && (value = e.getValue()) != null && ((scale = new BigDecimal(value.toString())).compareTo(new BigDecimal("1")) == 1 || scale.compareTo(new BigDecimal("0")) == -1)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaMaintainResource.Only_0&1"));
            this.tbMain.getCell(rowIndex, "FaMaintain.expenseApportionScale").setValue(null);
        }
        BigDecimal totalScale = new BigDecimal("0");
        int j = this.tbMain.getRowCount();
        for (int i = 0; i < j; ++i) {
            Object keyValue;
            IRow row = this.tbMain.getRow(i);
            ICell cell = row.getCell("FaMaintain.expenseApportionScale");
            if (cell == null || cell.getValue() == null || (totalScale = totalScale.add(new BigDecimal((keyValue = cell.getValue()).toString()))).compareTo(new BigDecimal("1")) != 1) continue;
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaMaintainResource.Can't_Over1"));
            cell.setValue(null);
            SysUtil.abort();
        }
    }

    @Override
    public void fentanAction_actionPerformed(ActionEvent e) throws Exception {
        BigDecimal totalValue = new BigDecimal("0");
        int j = this.tbMain.getRowCount();
        for (int i = 0; i < j; ++i) {
            IRow row = this.tbMain.getRow(i);
            ICell cell = row.getCell("FaMaintain.expenseApportionScale");
            if (cell != null && cell.getValue() != null) {
                if (i != j - 1) {
                    BigDecimal keyValue = new BigDecimal(cell.getValue().toString());
                    row.getCell("onecost").setValue((Object)this.costCap.multiply(keyValue).setScale(this.scale, 4));
                    if (row.getCell("onecost") == null || row.getCell("onecost").getValue() == null) continue;
                    totalValue = totalValue.add(new BigDecimal(row.getCell("onecost").getValue().toString()));
                    continue;
                }
                row.getCell("onecost").setValue((Object)this.costCap.subtract(totalValue));
                continue;
            }
            MsgBox.showWarning((String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaMaintainResource.Edit_bili_Number"), row.getCell("FaCurCard.number").getValue()));
            SysUtil.abort();
        }
    }

    @Override
    public void capCancelAction_actionPerformed(ActionEvent e) throws Exception {
        if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaMaintainResource.Cancel_Caped")) != 0) {
            SysUtil.abort();
        }
        FaMaintainFactory.getRemoteInstance().cancelCap(this.dataMap.get("id").toString());
        MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaMaintainResource.CancelCap_Success"));
        this.capConfirmAction.setEnabled(true);
        this.fentanAction.setEnabled(true);
        this.capCancelAction.setEnabled(false);
        this.fangshi.setEnabled(true);
        this.tbMain.getColumn("onecost").getStyleAttributes().setLocked(false);
        this.tbMain.getColumn("FaMaintain.expenseApportionScale").getStyleAttributes().setLocked(false);
    }

    @Override
    public void capConfirmAction_actionPerformed(ActionEvent e) throws Exception {
        this.checkBeforeCap();
        int j = this.tbMain.getRowCount();
        for (int i = 0; i < j; ++i) {
            ICell cell1;
            IRow row = this.tbMain.getRow(i);
            ICell cell = row.getCell("onecost");
            if (cell != null && cell.getValue() != null) {
                Object keyValue = cell.getValue();
                this.dataMap.put(row.getCell("id").getValue().toString(), keyValue.toString());
            }
            if ((cell1 = row.getCell("FaMaintain.expenseApportionScale")) == null || cell1.getValue() == null) continue;
            Object keyValue = cell1.getValue();
            this.dataMap.put(row.getCell("id").getValue().toString() + "1", keyValue.toString());
        }
        if (this.fangshi.getText() != null && this.fangshi.getText().length() > 0) {
            String alterNumber = this.fangshi.getValue().toString().substring(0, this.fangshi.getValue().toString().indexOf("("));
            this.dataMap.put("alterNumber", alterNumber);
        }
        FaMaintainFactory.getRemoteInstance().confirmCap(this.dataMap);
        this.capCancelAction.setEnabled(true);
        this.capConfirmAction.setEnabled(false);
        this.fentanAction.setEnabled(false);
        this.fangshi.setEnabled(false);
        this.tbMain.getColumn("onecost").getStyleAttributes().setLocked(true);
        this.tbMain.getColumn("FaMaintain.expenseApportionScale").getStyleAttributes().setLocked(true);
        MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaMaintainResource.Success_Cap"));
    }

    @Override
    public void cancelAction_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    private void initCapData(HashMap hashMap) throws Exception {
        String id = hashMap.get("id").toString();
        this.dataMap.put("id", id);
        IFaMaintain faMaintain = FaMaintainFactory.getRemoteInstance();
        this.faMaintainInfo = faMaintain.getFaMaintainInfo((IObjectPK)new ObjectStringPK(id));
        this.initControl();
        if (this.faMaintainInfo.getCheckedStatus().getValue() != 2) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaMaintainResource.Audit_Cap"));
            SysUtil.abort();
        }
        if (this.faMaintainInfo.getCapitalMeltAmout() == null || this.faMaintainInfo.getCapitalMeltAmout().compareTo(new BigDecimal("0")) == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaMaintainResource.NotHave_CapMoney"));
            SysUtil.abort();
        } else if ((this.faMaintainInfo.getAlreadyCapitalMeltAmout() == null ? new BigDecimal("0") : this.faMaintainInfo.getAlreadyCapitalMeltAmout()).compareTo(this.faMaintainInfo.getCapitalMeltAmout() == null ? new BigDecimal("0") : this.faMaintainInfo.getCapitalMeltAmout()) == 0) {
            if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaMaintainResource.Has_Caped")) != 0) {
                SysUtil.abort();
            }
            this.capConfirmAction.setEnabled(false);
            this.fentanAction.setEnabled(false);
            this.capCancelAction.setEnabled(true);
            this.cost.setEditable(false);
            this.realcost.setEditable(false);
            this.fangshi.setEnabled(false);
            this.tbMain.getColumn("onecost").getStyleAttributes().setLocked(true);
            this.tbMain.getColumn("FaMaintain.expenseApportionScale").getStyleAttributes().setLocked(true);
        }
        if (this.faMaintainInfo.getFactMaintainLocalAmount() != null) {
            this.realcost.setValue((Object)this.faMaintainInfo.getFactMaintainLocalAmount().setScale(this.scale));
        }
        this.costCap = this.faMaintainInfo.getCapitalMeltAmout() == null ? new BigDecimal("0") : this.faMaintainInfo.getCapitalMeltAmout().setScale(this.scale);
        this.cost.setValue((Object)this.costCap.setScale(this.scale));
        FaClientUtils.setComponentPrecision(new Object[]{this.cost, this.realcost}, this.scale);
        this.dataMap.put("costCap", this.costCap);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("entry", (Object)id));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("faCurCard"));
        viewInfo.getSelector().add(new SelectorItemInfo("oneCost"));
        viewInfo.getSelector().add(new SelectorItemInfo("expenseApportionScale"));
        viewInfo.getSelector().add(new SelectorItemInfo("faAlterModel"));
        FaMaintainEntryCollection entryCollection = FaMaintainEntryFactory.getRemoteInstance().getFaMaintainEntryCollection(viewInfo);
        this.dataMap.put("entryCollection", entryCollection);
        String alterId = null;
        Iterator entryIterator = entryCollection.iterator();
        IFaCurCard curcard = FaCurCardFactory.getRemoteInstance();
        while (entryIterator.hasNext()) {
            IRow row = this.tbMain.addRow();
            FaMaintainEntryInfo entryInfo = (FaMaintainEntryInfo)entryIterator.next();
            String curCardId = entryInfo.getFaCurCard().getId().toString();
            FaCurCardInfo curCardInfo = curcard.getFaCurCardInfo((IObjectPK)new ObjectStringPK(curCardId));
            row.getCell("FaCurCard.assetName").setValue((Object)curCardInfo.getAssetName());
            row.getCell("FaCurCar.spec").setValue((Object)curCardInfo.getSpecs());
            row.getCell("FaCurCard.number").setValue((Object)curCardInfo.getNumber());
            row.getCell("id").setValue((Object)curCardId);
            if (entryInfo.getFaAlterModel() != null) {
                alterId = entryInfo.getFaAlterModel().getId().toString();
            }
            if (entryCollection != null && entryCollection.size() == 1) {
                row.getCell("FaMaintain.expenseApportionScale").setValue((Object)(entryInfo.getExpenseApportionScale() == null ? new BigDecimal("1") : entryInfo.getExpenseApportionScale()));
            } else {
                row.getCell("FaMaintain.expenseApportionScale").setValue((Object)(entryInfo.getExpenseApportionScale() == null ? null : entryInfo.getExpenseApportionScale()));
            }
            row.getCell("onecost").setValue((Object)(entryInfo.getOneCost() == null ? null : entryInfo.getOneCost()));
        }
        if (alterId != null) {
            FaAlterModeInfo faInfo = FaAlterModeFactory.getRemoteInstance().getFaAlterModeInfo((IObjectPK)new ObjectStringPK(alterId));
            this.fangshi.setData((Object)faInfo);
        }
    }

    private void checkBeforeCap() {
        BigDecimal totalCost = new BigDecimal("0");
        BigDecimal totalBili = new BigDecimal("0");
        BigDecimal exceptLastTotal = new BigDecimal("0");
        if (this.fangshi.getText() == null || this.fangshi.getText().length() <= 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaMaintainResource.Input_Cap_Style"));
            SysUtil.abort();
        }
        for (int m = 0; m < this.tbMain.getRowCount(); ++m) {
            IRow tableRow = this.tbMain.getRow(m);
            ICell expenseApportionCell = tableRow.getCell("FaMaintain.expenseApportionScale");
            if (expenseApportionCell.getValue() == null) {
                MsgBox.showWarning((String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaMaintainResource.Edit_biliLi"), tableRow.getCell("FaCurCard.number").getValue()));
                SysUtil.abort();
            }
            totalBili = totalBili.add(new BigDecimal(expenseApportionCell.getValue().toString()));
        }
        if (totalBili.compareTo(new BigDecimal("1")) != 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaMaintainResource.notEqual_1"));
            SysUtil.abort();
        }
        int j = this.tbMain.getRowCount();
        for (int i = 0; i < j; ++i) {
            Object keyValue;
            IRow row = this.tbMain.getRow(i);
            ICell cell = row.getCell("onecost");
            ICell cell1 = row.getCell("FaMaintain.expenseApportionScale");
            if (cell != null && cell.getValue() != null) {
                keyValue = cell.getValue();
                totalCost = totalCost.add(new BigDecimal(keyValue.toString()));
            } else {
                MsgBox.showWarning((String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaMaintainResource.Money_Null"), row.getCell("FaCurCard.number").getValue()));
                SysUtil.abort();
            }
            if (cell1 != null && cell1.getValue() != null) {
                keyValue = cell1.getValue();
                BigDecimal onecost = new BigDecimal("0");
                if (i != j - 1) {
                    onecost = new BigDecimal(keyValue.toString()).multiply(this.costCap).setScale(this.scale, 4);
                    exceptLastTotal = exceptLastTotal.add(onecost);
                } else {
                    onecost = this.costCap.subtract(exceptLastTotal);
                }
                if (onecost.compareTo(new BigDecimal(cell.getValue().toString())) == 0) continue;
                String msg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaMaintainResource.apportionCalcAmoutIlleagle");
                msg = MessageFormat.format(msg, i + 1 + "");
                MsgBox.showWarning((String)msg);
                SysUtil.abort();
                continue;
            }
            MsgBox.showWarning((String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaMaintainResource.Edit_biliLi"), row.getCell("FaCurCard.number").getValue()));
            SysUtil.abort();
        }
        if (totalCost.compareTo(this.costCap) != 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaMaintainResource.One_notEqual_All"));
            SysUtil.abort();
        }
    }

    @Override
    public void initUIContentLayout() {
        this.btnCancelCap.setLimitedSize(false);
        this.btnOnCap.setLimitedSize(false);
        super.initUIContentLayout();
    }
}

