/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.fi.fa.manage.client.FaCardFilterProcessor;
import com.kingdee.eas.fi.fa.manage.client.FaClearBillEditUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.ArrayList;

public class FaCardFilterAdapter
implements FaCardFilterProcessor {
    private String title = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"CommonQueryWithResultDialog_ResultTitle");
    private int selectMode = 2;
    private int openType = -1;
    private FilterInfo filterInfo = new FilterInfo();
    private boolean isUseDefaultFilter = true;

    @Override
    public String getResultPanelTitle() {
        return this.title;
    }

    @Override
    public int getOpenType() {
        return this.openType;
    }

    @Override
    public FilterInfo getCardFilter() {
        return this.filterInfo;
    }

    @Override
    public boolean isUseDefaultFilter() {
        return this.isUseDefaultFilter;
    }

    @Override
    public int getSelectMode() {
        return this.selectMode;
    }

    @Override
    public void verifyCardBeforeSelect(Component dialog, ArrayList curCardList) {
    }

    @Override
    public void setResultPanelTitle(String title) {
        this.title = title;
    }

    @Override
    public void setOpenType(int openType) {
        this.openType = openType;
    }

    @Override
    public void setFilterInfo(FilterInfo filterInfo) {
        this.filterInfo = filterInfo;
    }

    @Override
    public void setUseDefaultFilter(boolean isUseDefaultFilter) {
        this.isUseDefaultFilter = isUseDefaultFilter;
    }

    @Override
    public void setSelectMode(int mode) {
        this.selectMode = mode;
    }

    @Override
    public void dealRowsetAfterDataFill(KDTDataRequestEvent e, KDTable table) throws Exception {
        for (int i = e.getLastRow(); i != -1 && i >= e.getFirstRow(); --i) {
            BigDecimal deprTTerm;
            IRow row = table.getRow(i);
            if (this.isUseDefaultFilter() && this.removeCardFromQuery(row, this.openType)) {
                table.getRow(i).getStyleAttributes().setHided(true);
            }
            boolean isWorkLoad = (Boolean)row.getCell("deprMethod.isWorkload").getValue();
            String[] indexPeriods = new String[]{"deprTermCount", "useTermCount", "evalLeftPeriod"};
            for (int count = 0; count < indexPeriods.length; ++count) {
                BigDecimal deprTermCount;
                BigDecimal bigDecimal = deprTermCount = row.getCell(indexPeriods[count]) != null && row.getCell(indexPeriods[count]).getValue() != null ? (BigDecimal)row.getCell(indexPeriods[count]).getValue() : new BigDecimal("0.00");
                if (row.getCell(indexPeriods[count]) == null) continue;
                row.getCell(indexPeriods[count]).setValue((Object)deprTermCount.setScale(isWorkLoad ? 2 : 0, 4));
            }
            Object isEvaledBefore = row.getCell("isEvaledBefore").getValue();
            if (isEvaledBefore.equals(Boolean.FALSE)) {
                row.getCell("initEvalValue").setValue(null);
                row.getCell("evalLeftPeriod").setValue(null);
            }
            if ((deprTTerm = (BigDecimal)row.getCell("deprTTerm").getValue()) != null && deprTTerm.compareTo(new BigDecimal("0")) > 0) continue;
            row.getCell("deprTTerm").setValue(null);
            row.getCell("monthDepreRate").setValue(null);
        }
    }

    protected boolean removeCardFromQuery(IRow row, int queryType) throws Exception {
        if (this.openType == 1 && !FaClearBillEditUI.checkDeprePolicy(row, this.openType)) {
            return true;
        }
        if (this.openType == 0) {
            return false;
        }
        return false;
    }
}

