/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.fa.manage.FaBillOriginEnum;
import com.kingdee.eas.fi.fa.manage.FaBillTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaCardOriginEnum;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaCardLifeCycleUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import org.apache.log4j.Logger;

public class FaCardLifeCycleUI
extends AbstractFaCardLifeCycleUI {
    private static final Logger logger = CoreUIObject.getLogger(FaCardLifeCycleUI.class);
    private static final Color WARN_COLOR = new Color(246, 168, 46);
    private SimpleAttributeSet defAttr = new SimpleAttributeSet();
    private SimpleAttributeSet warnAttr = new SimpleAttributeSet();
    private SimpleAttributeSet errorAttr = new SimpleAttributeSet();
    private SimpleAttributeSet exeAttr = new SimpleAttributeSet();
    private Color BgColor_right = new Color(194, 225, 194);
    private Color BgColor_error = new Color(255, 215, 227);
    protected int dividerLocation = -1;
    private boolean stop = false;
    private BigDecimal ZERO = new BigDecimal("0.00");
    private String uiTitle = this.getUITitle();
    private String queryTitle = this.btnQuery.getText();

    public FaCardLifeCycleUI() throws Exception {
        this.showMonRecord.setSelected(true);
        this.showBalanceRecord.setSelected(true);
        this.showMonRecord.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!FaCardLifeCycleUI.this.showMonRecord.isSelected()) {
                    FaCardLifeCycleUI.this.showBalanceRecord.setSelected(false);
                }
            }
        });
        this.showBalanceRecord.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (FaCardLifeCycleUI.this.showBalanceRecord.isSelected()) {
                    FaCardLifeCycleUI.this.showMonRecord.setSelected(true);
                }
            }
        });
    }

    public void onLoad() throws Exception {
        Boolean showFutureRecord;
        super.onLoad();
        this.scrollPane.setBorder(BorderFactory.createLineBorder(new Color(145, 148, 140), 1));
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.checkParsed();
        this.tblMain.getColumn("depPeriod").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("originDiff").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("assetValue").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("depreciation").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("accuDeprChg").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("accuDepr").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("accuDeprtYearChg").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("accuDeprtYear").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("neatValue").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("decValue").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("neatAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("assetValueBalance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("accuDeprBalance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("addUpYearDepre").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("decValueBalance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        Map context = this.getUIContext();
        String cardId = (String)context.get("cardId");
        if (cardId != null) {
            this.txtId.setText(cardId);
        }
        if ((showFutureRecord = (Boolean)context.get("showFutureRecord")) != null) {
            this.showFutureRecord.setSelected(showFutureRecord.booleanValue());
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FaCardLifeCycleUI.this.btnQuery.doClick();
            }
        });
    }

    public void initLayout() {
        super.initLayout();
        this.splitPane.setBottomComponent(null);
    }

    private void switchConsole() {
        Component c = this.splitPane.getBottomComponent();
        if (c != null) {
            this.dividerLocation = this.splitPane.getDividerLocation();
            this.splitPane.setBottomComponent(null);
        } else {
            this.splitPane.setBottomComponent((Component)this.scrollPane);
            int height = this.splitPane.getHeight() - this.splitPane.getDividerSize() - this.splitPane.getInsets().top - this.splitPane.getInsets().bottom;
            if (this.dividerLocation <= 0 || this.dividerLocation >= height) {
                this.dividerLocation = height - 200;
            }
            if (this.dividerLocation <= 0 || this.dividerLocation >= height) {
                this.dividerLocation = 200;
            }
            this.splitPane.setDividerLocation(this.dividerLocation);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void actionShowConsole_actionPerformed(ActionEvent e) throws Exception {
        this.switchConsole();
    }

    @Override
    public void actionClearConsole_actionPerformed(ActionEvent e) throws Exception {
        this.txtConsole.setText("");
    }

    private void enableComponent(boolean enable) {
        this.showMonRecord.setEnabled(enable);
        this.showBalanceRecord.setEnabled(enable);
        this.showFutureRecord.setEnabled(enable);
        this.actionRefresh.setEnabled(enable);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.btnQuery.doClick();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        if (this.btnQuery.getClientProperty((Object)"canStop") != null) {
            this.stop = true;
            this.actionQuery.setEnabled(false);
            this.btnQuery.setEnabled(false);
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    FaCardLifeCycleUI.this.btnQuery.putClientProperty((Object)"canStop", (Object)true);
                    FaCardLifeCycleUI.this.btnQuery.setText("\u505c\u6b62");
                    FaCardLifeCycleUI.this.enableComponent(false);
                    FaCardLifeCycleUI.this.doQuery();
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                finally {
                    FaCardLifeCycleUI.this.btnQuery.setText(FaCardLifeCycleUI.this.queryTitle);
                    FaCardLifeCycleUI.this.enableComponent(true);
                    FaCardLifeCycleUI.this.actionQuery.setEnabled(true);
                    FaCardLifeCycleUI.this.btnQuery.setEnabled(true);
                    FaCardLifeCycleUI.this.btnQuery.putClientProperty((Object)"canStop", null);
                    FaCardLifeCycleUI.this.stop = false;
                }
            }
        }).start();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void doQuery() throws Exception {
        Map<String, Color> rowData;
        BigDecimal accuDeprtYearChg;
        BigDecimal decValue;
        BigDecimal accuDeprChg;
        BigDecimal originDiff;
        CompanyOrgUnitInfo company;
        this.txtNumber.setText("");
        this.txtName.setText("");
        this.tblMain.removeRows();
        String cardId = this.txtId.getText();
        if (cardId == null) {
            return;
        }
        if ((cardId = cardId.trim()).length() == 0) {
            return;
        }
        boolean isShowMonRecord = this.showMonRecord.isSelected();
        boolean isShowBalanceRecord = this.showBalanceRecord.isSelected();
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append("select \n");
        sql.append("    cur.FCompanyID, cur.FNumber, cur.FAssetName, cur.FCheckedStatus, cur.FDeletedStatus, \n");
        sql.append("    cur.FOriginFlag, c.FName_l2 FCatName, cur.FDeprTermCount, cur.FUseTermCount, cur.FIsOveraged, \n");
        sql.append("    cur.FAssetValue, cur.FNeatValue, cur.FNeatAmt, \n");
        sql.append("    cur.FAccuDeprtYear, cur.FAccuDepr, cur.FDecValue \n");
        sql.append("from T_FA_FaCurCard cur \n");
        sql.append("left join T_FA_Cat c on c.FID = cur.FAssetCatID \n");
        sql.append("where cur.FID = ? \n");
        params.add(cardId);
        IRowSet rs = FMIsqlFacadeFactory.getRemoteInstance().executeQuery(sql.toString(), params.toArray());
        if (!rs.next()) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("note", "\u627e\u4e0d\u5230\u5361\u7247");
            data.put("background", this.BgColor_error);
            this.addRow(data);
            return;
        }
        String companyId = rs.getString("FCompanyID");
        String number = rs.getString("FNumber");
        String name = rs.getString("FAssetName");
        int lastCheckedStatus = rs.getInt("FCheckedStatus");
        int lastDeletedStatus = rs.getInt("FDeletedStatus");
        FaCardOriginEnum origin = FaCardOriginEnum.getEnum(rs.getInt("FOriginFlag"));
        int lastDepPeriod = rs.getInt("FDeprTermCount");
        int lastUseTermCount = rs.getInt("FUseTermCount");
        int lastIsOveraged = rs.getInt("FIsOveraged");
        BigDecimal lastAssetValue = rs.getBigDecimal("FAssetValue");
        BigDecimal lastAccuDepr = rs.getBigDecimal("FAccuDepr");
        BigDecimal lastAccuDeprtYear = rs.getBigDecimal("FAccuDeprtYear");
        BigDecimal lastNeatValue = rs.getBigDecimal("FNeatValue");
        BigDecimal lastDecValue = rs.getBigDecimal("FDecValue");
        BigDecimal lastNeatAmt = rs.getBigDecimal("FNeatAmt");
        this.txtAssetCat.setText(rs.getString("FCatName"));
        this.txtNumber.setText(number);
        this.txtName.setText(name);
        this.setUITitle(this.uiTitle + " - " + name);
        int precision = 2;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("baseCurrency.id");
        selector.add("baseCurrency.precision");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)companyId));
        view.setFilter(filter);
        CompanyOrgUnitCollection col = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
        if (col != null && col.size() > 0 && (company = col.get(0)).getBaseCurrency() != null) {
            precision = company.getBaseCurrency().getPrecision();
        }
        String format = FaClientUtils.getFormatPatternForColumn(precision);
        this.tblMain.getColumn("originDiff").getStyleAttributes().setNumberFormat(format);
        this.tblMain.getColumn("assetValue").getStyleAttributes().setNumberFormat(format);
        this.tblMain.getColumn("depreciation").getStyleAttributes().setNumberFormat(format);
        this.tblMain.getColumn("accuDeprChg").getStyleAttributes().setNumberFormat(format);
        this.tblMain.getColumn("accuDepr").getStyleAttributes().setNumberFormat(format);
        this.tblMain.getColumn("accuDeprtYearChg").getStyleAttributes().setNumberFormat(format);
        this.tblMain.getColumn("accuDeprtYear").getStyleAttributes().setNumberFormat(format);
        this.tblMain.getColumn("neatValue").getStyleAttributes().setNumberFormat(format);
        this.tblMain.getColumn("decValue").getStyleAttributes().setNumberFormat(format);
        this.tblMain.getColumn("neatAmt").getStyleAttributes().setNumberFormat(format);
        this.tblMain.getColumn("assetValueBalance").getStyleAttributes().setNumberFormat(format);
        this.tblMain.getColumn("accuDeprBalance").getStyleAttributes().setNumberFormat(format);
        this.tblMain.getColumn("addUpYearDepre").getStyleAttributes().setNumberFormat(format);
        this.tblMain.getColumn("decValueBalance").getStyleAttributes().setNumberFormat(format);
        this.tblMain.getColumn("assetValueBalance").getStyleAttributes().setHided(!isShowMonRecord || !isShowBalanceRecord);
        this.tblMain.getColumn("accuDeprBalance").getStyleAttributes().setHided(!isShowMonRecord || !isShowBalanceRecord);
        this.tblMain.getColumn("addUpYearDepre").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("decValueBalance").getStyleAttributes().setHided(!isShowMonRecord || !isShowBalanceRecord);
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (IObjectPK)new ObjectUuidPK(companyId));
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (IObjectPK)new ObjectUuidPK(companyId));
        if (startPeriod == null || currentPeriod == null) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("note", "\u7ec4\u7ec7\u6ca1\u6709\u542f\u7528");
            data.put("background", this.BgColor_error);
            this.addRow(data);
            return;
        }
        HashMap<String, Object> current = new HashMap<String, Object>();
        current.put("flag", 999999);
        current.put("period", currentPeriod.getNumber() + "#");
        current.put("operate", "\u5f53\u524d");
        current.put("depPeriod", lastDepPeriod);
        current.put("assetValue", lastAssetValue);
        current.put("accuDepr", lastAccuDepr);
        current.put("accuDeprtYear", lastAccuDeprtYear);
        current.put("neatValue", lastNeatValue);
        current.put("decValue", lastDecValue);
        current.put("neatAmt", lastNeatAmt);
        if (lastCheckedStatus != 2) {
            current.put("note", "\u672a\u5ba1\u6838");
            current.put("background", new Color(220, 220, 220));
            this.addRow(current);
            return;
        }
        ArrayList<Map<Object, Object>> rowDatas = new ArrayList<Map<Object, Object>>();
        HashMap<String, Object> begin = new HashMap<String, Object>();
        sql.setLength(0);
        params.clear();
        int beginPeriod = -1;
        int beginDepPeriod = -1;
        if (FaCardOriginEnum.INITIAL.equals((Object)origin)) {
            sql.append("select \n");
            sql.append("    mon.FBizDate, mon.FCreateTime, mon.FDeprTermCount, \n");
            sql.append("    mon.FAssetValue, mon.FNeatValue, mon.FNeatAmt, \n");
            sql.append("    mon.FAccuDeprtYear, mon.FAccuDepr, mon.FDecValue \n");
            sql.append("from T_FA_FaMonCard mon \n");
            sql.append("where mon.FFaCurCardID = ? \n");
            sql.append("and mon.ForiginFlag = 0 \n");
            sql.append("and mon.FFaPeriodID is null \n");
            params.add(cardId);
            rs = FMIsqlFacadeFactory.getRemoteInstance().executeQuery(sql.toString(), params.toArray());
            if (!rs.next()) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("note", "\u521d\u59cb\u6570\u636e\u4e22\u5931");
                data.put("background", this.BgColor_error);
                this.addRow(data);
                return;
            }
            begin.put("flag", 0);
            begin.put("period", startPeriod.getNumber());
            beginPeriod = startPeriod.getNumber();
            begin.put("operate", (Object)FaCardOriginEnum.INITIAL);
            begin.put("bizDate", rs.getTimestamp("FCreateTime"));
            beginDepPeriod = rs.getInt("FDeprTermCount");
            begin.put("depPeriod", beginDepPeriod);
            begin.put("assetValue", rs.getBigDecimal("FAssetValue"));
            begin.put("accuDepr", rs.getBigDecimal("FAccuDepr"));
            begin.put("accuDeprtYear", rs.getBigDecimal("FAccuDeprtYear"));
            begin.put("neatValue", rs.getBigDecimal("FNeatValue"));
            begin.put("decValue", rs.getBigDecimal("FDecValue"));
            begin.put("neatAmt", rs.getBigDecimal("FNeatAmt"));
        } else {
            sql.append("select \n");
            sql.append("    p.FNumber FPeriod, bak.FOriginFlag, \n");
            sql.append("    bak.FBizDate, bak.FCreateTime, bak.FDeprTermCount, \n");
            sql.append("    bak.FAssetValue, bak.FNeatValue, bak.FNeatAmt, \n");
            sql.append("    bak.FAccuDeprtYear, bak.FAccuDepr, bak.FDecValue \n");
            sql.append("from T_FA_FaBakCard bak \n");
            sql.append("left join T_BD_Period p on p.FID = bak.FPeriodID \n");
            sql.append("where bak.FFaCurCardID = ? \n");
            sql.append("and bak.FBILLTYPE = 1 \n");
            sql.append("and bak.FCheckedStatus = 2 \n");
            params.add(cardId);
            rs = FMIsqlFacadeFactory.getRemoteInstance().executeQuery(sql.toString(), params.toArray());
            if (!rs.next()) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("note", "\u5907\u4efd\u6570\u636e\u4e22\u5931");
                data.put("background", this.BgColor_error);
                this.addRow(data);
                return;
            }
            begin.put("flag", 1);
            begin.put("period", rs.getInt("FPeriod"));
            beginPeriod = rs.getInt("FPeriod");
            int originFlag = rs.getInt("FOriginFlag");
            begin.put("operate", (Object)FaCardOriginEnum.getEnum(originFlag));
            begin.put("bizDate", rs.getTimestamp("FCreateTime"));
            beginDepPeriod = rs.getInt("FDeprTermCount");
            begin.put("depPeriod", beginDepPeriod);
            begin.put("assetValue", rs.getBigDecimal("FAssetValue"));
            begin.put("accuDepr", rs.getBigDecimal("FAccuDepr"));
            begin.put("accuDeprtYear", rs.getBigDecimal("FAccuDeprtYear"));
            begin.put("neatValue", rs.getBigDecimal("FNeatValue"));
            begin.put("decValue", rs.getBigDecimal("FDecValue"));
            begin.put("neatAmt", rs.getBigDecimal("FNeatAmt"));
        }
        if (this.stop) {
            return;
        }
        sql.setLength(0);
        params.clear();
        sql.append("select \n");
        sql.append("    p.FNumber FPeriod, c.FCheckedStatus, c.FBillType, \n");
        sql.append("    c.FNumber FBizNumber, c.FBizDate, \n");
        sql.append("    c.FChangeDate, m.FName_l2 FChangeType, \n");
        sql.append("    ce.TOriginChg, ce.TAccuDeprChg, ce.TDecValueChg, \n");
        sql.append("    biz.FID FBizCardID, bak.FID FBakCardID, \n");
        sql.append("    (isnull(biz.FAssetValue, 0) - isnull(bak.FAssetValue, 0)) FOriginChg, \n");
        sql.append("    (isnull(biz.FAccuDepr, 0) - isnull(bak.FAccuDepr, 0)) FAccuDeprChg, \n");
        sql.append("    (isnull(biz.FDecValue, 0) - isnull(bak.FDecValue, 0)) FDecValueChg, \n");
        sql.append("    (isnull(biz.FAccuDeprtYear, 0) - isnull(bak.FAccuDeprtYear, 0)) FAccuDeprtYearChg \n");
        sql.append("from T_FA_FaChangeBill c \n");
        sql.append("join T_BD_Period p on p.FID = c.FPeriodID \n");
        sql.append("left join T_FA_AlterMode m on m.FID = c.FChangeModeID \n");
        sql.append("join T_FA_FaChangeBillEntry ce on ce.FChangeBillID = c.FID \n");
        sql.append("left join T_FA_FaBizCard biz on biz.FID = ce.FBizCardID \n");
        sql.append("left join T_FA_FaBakCard bak on biz.FFaBakCardID = bak.FID \n");
        sql.append("where ce.FCurCardID = ? \n");
        params.add(cardId);
        if (!this.showFutureRecord.isSelected()) {
            sql.append("and p.FNumber <= ? \n");
            params.add(currentPeriod.getNumber() < beginPeriod ? beginPeriod : currentPeriod.getNumber());
        }
        sql.append("order by c.FBizDate \n");
        rs = FMIsqlFacadeFactory.getRemoteInstance().executeQuery(sql.toString(), params.toArray());
        while (rs.next()) {
            HashMap<String, Object> rowData2 = new HashMap<String, Object>();
            int billType = rs.getInt("FBillType");
            rowData2.put("flag", 2);
            rowData2.put("operate", billType > 0 ? FaBillOriginEnum.getEnum(String.valueOf(billType)) : "\u53d8\u66f4");
            int period = rs.getInt("FPeriod");
            rowData2.put("period", period);
            rowData2.put("checkedStatus", rs.getInt("FCheckedStatus"));
            rowData2.put("bizNumber", rs.getString("FBizNumber"));
            rowData2.put("bizDate", rs.getTimestamp("FBizDate"));
            rowData2.put("changeDate", rs.getDate("FChangeDate"));
            rowData2.put("changeType", rs.getString("FChangeType"));
            String bizCardId = rs.getString("FBizCardID");
            String bakCardId = rs.getString("FBakCardID");
            if (bizCardId == null) {
                rowData2.put("note", "\u4e1a\u52a1\u5361\u7247\u4e22\u5931");
                rowData2.put("background", this.BgColor_error);
            } else if (bakCardId == null) {
                rowData2.put("note", "\u5907\u4efd\u5361\u7247\u4e22\u5931");
                rowData2.put("background", this.BgColor_error);
            }
            originDiff = rs.getBigDecimal("TOriginChg");
            if (originDiff != null && originDiff.compareTo(this.ZERO) != 0) {
                rowData2.put("originDiff", originDiff);
            }
            if ((accuDeprChg = rs.getBigDecimal("TAccuDeprChg")) != null && accuDeprChg.compareTo(this.ZERO) != 0) {
                rowData2.put("accuDeprChg", accuDeprChg);
            }
            if ((decValue = rs.getBigDecimal("TDecValueChg")) != null && decValue.compareTo(this.ZERO) != 0) {
                rowData2.put("decValue", decValue);
            }
            if (bizCardId != null && bakCardId != null) {
                if (originDiff != null && originDiff.compareTo(rs.getBigDecimal("FOriginChg")) != 0) {
                    rowData2.put("note", "\u539f\u503c\u8c03\u6574\u4e0d\u7b49\u4e8e\u4e1a\u52a1\u5361\u7247");
                    rowData2.put("background", this.BgColor_error);
                    rowData2.put("column", "originDiff");
                } else if (accuDeprChg != null && accuDeprChg.compareTo(rs.getBigDecimal("FAccuDeprChg")) != 0) {
                    rowData2.put("note", "\u7d2f\u8ba1\u6298\u65e7\u8c03\u6574\u4e0d\u7b49\u4e8e\u4e1a\u52a1\u5361\u7247");
                    rowData2.put("background", this.BgColor_error);
                    rowData2.put("column", "accuDeprChg");
                } else if (decValue != null && decValue.compareTo(rs.getBigDecimal("FDecValueChg")) != 0) {
                    rowData2.put("note", "\u51cf\u503c\u51c6\u5907\u8c03\u6574\u4e0d\u7b49\u4e8e\u4e1a\u52a1\u5361\u7247");
                    rowData2.put("background", this.BgColor_error);
                    rowData2.put("column", "decValue");
                }
            }
            if (this.ZERO.compareTo(accuDeprtYearChg = rs.getBigDecimal("FAccuDeprtYearChg")) != 0) {
                rowData2.put("accuDeprtYearChg", accuDeprtYearChg);
            }
            rowDatas.add(rowData2);
        }
        if (this.stop) {
            return;
        }
        sql.setLength(0);
        params.clear();
        sql.append("select \n");
        sql.append("    p.FNumber FPeriod, c.FCheckedStatus, \n");
        sql.append("    c.FBizDate, c.FCreateTime, c.FNumber FBizNumber, \n");
        sql.append("    c.FSplitDate FChangeDate, m.FName_l2 FChangeType \n");
        sql.append("from T_FA_FaSplitBill c \n");
        sql.append("left join T_BD_Period p on p.FID = c.FPeriodID \n");
        sql.append("left join T_FA_AlterMode m on m.FID = c.FClearModeID \n");
        sql.append("where c.FFaCurCardID = ? \n");
        params.add(cardId);
        if (!this.showFutureRecord.isSelected()) {
            sql.append("and p.FNumber <= ? \n");
            params.add(currentPeriod.getNumber());
        }
        rs = FMIsqlFacadeFactory.getRemoteInstance().executeQuery(sql.toString(), params.toArray());
        while (rs.next()) {
            HashMap<String, Object> rowData3 = new HashMap<String, Object>();
            rowData3.put("flag", 4);
            rowData3.put("operate", "\u62c6\u5206");
            int period = rs.getInt("FPeriod");
            rowData3.put("period", period);
            rowData3.put("checkedStatus", rs.getInt("FCheckedStatus"));
            rowData3.put("bizNumber", rs.getString("FBizNumber"));
            rowData3.put("bizDate", rs.getTimestamp("FCreateTime"));
            rowData3.put("changeDate", rs.getDate("FChangeDate"));
            rowData3.put("changeType", rs.getString("FChangeType"));
            rowDatas.add(rowData3);
        }
        if (this.stop) {
            return;
        }
        sql.setLength(0);
        params.clear();
        sql.append("select \n");
        sql.append("    p.FNumber FPeriod, c.FCheckedStatus, bak.FBillType, \n");
        sql.append("    c.FBizDate, c.FCreateTime, c.FNumber FBizNumber, \n");
        sql.append("    c.FClearDate FChangeDate, m.FName_l2 FChangeType, \n");
        sql.append("    ce.FClrOriginal, ce.FClrAddupDep, ce.FClrDecPrep, \n");
        sql.append("    case when bak.FBillType = 3 then \n");
        sql.append("        (bak.FAccuDeprtYear - biz.FAccuDeprtYear) - ((bak.FAccuDepr - biz.FAccuDepr) - ce.FClrAddupDep) \n");
        sql.append("    else \n");
        sql.append("        biz.FAccuDeprtYear \n");
        sql.append("    end FClrAddupDepYear \n");
        sql.append("from T_FA_ClearBill c \n");
        sql.append("left join T_BD_Period p on p.FID = c.FPeriodID \n");
        sql.append("left join T_FA_AlterMode m on m.FID = c.FClearModeID \n");
        sql.append("join T_FA_ClearBillEntry ce on ce.FEntryID = c.FID \n");
        sql.append("join T_FA_FaBizCard biz on biz.FID = ce.FBIZCARDID \n");
        sql.append("join T_FA_FaBakCard bak on biz.FFaBakCardID = bak.FID \n");
        sql.append("where bak.FFaCurCardID = ? \n");
        params.add(cardId);
        sql.append("and (bak.FBillType = 3 or bak.FBillType = 4 or bak.FBillType = 5 or bak.FBillType = 8) \n");
        if (!this.showFutureRecord.isSelected()) {
            sql.append("and p.FNumber <= ? \n");
            params.add(currentPeriod.getNumber() < beginPeriod ? beginPeriod : currentPeriod.getNumber());
        }
        sql.append("order by c.fbizdate \n");
        rs = FMIsqlFacadeFactory.getRemoteInstance().executeQuery(sql.toString(), params.toArray());
        int completeClearPeriod = Integer.MAX_VALUE;
        while (rs.next()) {
            HashMap<String, Object> rowData4 = new HashMap<String, Object>();
            int flag = rs.getInt("FBillType");
            rowData4.put("flag", 89);
            rowData4.put("operate", (Object)FaBillTypeEnum.getEnum(flag));
            int period = rs.getInt("FPeriod");
            rowData4.put("period", period);
            int checkedStatus = rs.getInt("FCheckedStatus");
            rowData4.put("checkedStatus", checkedStatus);
            if (completeClearPeriod == Integer.MAX_VALUE && checkedStatus == 2 && flag != 3) {
                completeClearPeriod = period;
            }
            rowData4.put("bizNumber", rs.getString("FBizNumber"));
            rowData4.put("bizDate", rs.getTimestamp("FCreateTime"));
            rowData4.put("changeDate", rs.getDate("FChangeDate"));
            rowData4.put("changeType", rs.getString("FChangeType"));
            originDiff = this.ZERO.subtract(rs.getBigDecimal("FClrOriginal"));
            if (this.ZERO.compareTo(originDiff) != 0) {
                rowData4.put("originDiff", originDiff);
            }
            if (this.ZERO.compareTo(accuDeprChg = this.ZERO.subtract(rs.getBigDecimal("FClrAddupDep"))) != 0) {
                rowData4.put("accuDeprChg", accuDeprChg);
            }
            if (this.ZERO.compareTo(decValue = this.ZERO.subtract(rs.getBigDecimal("FClrDecPrep"))) != 0) {
                rowData4.put("decValue", decValue);
            }
            if (this.ZERO.compareTo(accuDeprtYearChg = this.ZERO.subtract(rs.getBigDecimal("FClrAddupDepYear"))) != 0) {
                rowData4.put("accuDeprtYearChg", accuDeprtYearChg);
            }
            rowDatas.add(rowData4);
        }
        if (this.stop) {
            return;
        }
        view = new EntityViewInfo();
        selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("periodYear");
        selector.add("periodNumber");
        selector.add("isAdjustPeriod");
        view.setSelector(selector);
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)currentPeriod.getPeriodType().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)beginPeriod, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)currentPeriod.getNumber(), CompareType.LESS_EQUALS));
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("number"));
        view.setSorter(sorter);
        PeriodCollection periods = PeriodFactory.getRemoteInstance().getPeriodCollection(view);
        sql.setLength(0);
        params.clear();
        sql.append("select \n");
        sql.append("    p.FNumber FPeriod, de.FState FCheckedStatus, d.FCreateTime, \n");
        sql.append("    d.FNumber FBizNumber, d.FBizDate, FDepreciation, dm.FName_l2 FDeprMethod \n");
        sql.append("FROM t_fa_FaDepreciation d \n");
        sql.append("left join T_BD_Period p on p.FID = d.FPeriod \n");
        sql.append("join t_fa_FaDepreciationEntry de on de.FLnkFaDepreEntry = d.fid \n");
        sql.append("left join T_FA_FaMonCard mon on mon.FFaCurCardID = de.FFaCurCardID and mon.FFaPeriodID = d.FPeriod \n");
        sql.append("left join T_FA_DepreciationMode dm on dm.FID = mon.FDeprMethodID \n");
        sql.append("where de.FFaCurCardID = ? \n");
        params.add(cardId);
        if (!this.showFutureRecord.isSelected()) {
            sql.append("and p.FNumber <= ? \n");
            params.add(currentPeriod.getNumber() < beginPeriod ? beginPeriod : currentPeriod.getNumber());
        }
        sql.append("order by p.fnumber \n");
        rs = FMIsqlFacadeFactory.getRemoteInstance().executeQuery(sql.toString(), params.toArray());
        HashMap dpDatass = new HashMap();
        int curDepPeriod = beginDepPeriod;
        int minDepPeriod = -1;
        int maxDepPeriod = -1;
        while (rs.next()) {
            HashMap<String, Object> rowData5 = new HashMap<String, Object>();
            rowData5.put("flag", 99);
            rowData5.put("operate", "\u6298\u65e7");
            int period = rs.getInt("FPeriod");
            if (minDepPeriod < 0) {
                minDepPeriod = period;
            }
            if (period > maxDepPeriod) {
                maxDepPeriod = period;
            }
            rowData5.put("period", period);
            rowData5.put("checkedStatus", rs.getInt("FCheckedStatus") == 3 ? 2 : 1);
            rowData5.put("bizDate", rs.getTimestamp("FCreateTime"));
            rowData5.put("changeDate", rs.getDate("FBizDate"));
            rowData5.put("deprMethod", rs.getString("FDeprMethod"));
            rowData5.put("depreciation", rs.getBigDecimal("FDepreciation"));
            List list = (List)dpDatass.get(period);
            if (list == null) {
                ArrayList<HashMap<String, Object>> arrayList = new ArrayList<HashMap<String, Object>>(1);
                dpDatass.put(period, arrayList);
                rowData5.put("seq", 1);
                arrayList.add(rowData5);
                continue;
            }
            rowData5.put("seq", list.size() + 1);
            rowData5.put("note", "\u6298\u65e7\u8bb0\u5f55\u91cd\u590d");
            rowData5.put("background", this.BgColor_error);
            rowData5.put("column", "operate");
            list.add(rowData5);
        }
        if (minDepPeriod < 0 && periods.size() > 1) {
            minDepPeriod = periods.get(1).getNumber();
        }
        int depPeriodCount = (Integer)begin.get("depPeriod");
        for (int i = 0; i < periods.size(); ++i) {
            if (periods.get(i).getNumber() < minDepPeriod) continue;
            List list = (List)dpDatass.remove(periods.get(i).getNumber());
            if (list == null) {
                if (periods.get(i).getNumber() >= currentPeriod.getNumber() || periods.get(i).getNumber() > completeClearPeriod || periods.get(i).getNumber() > maxDepPeriod || periods.get(i).isIsAdjustPeriod()) continue;
                rowData = new HashMap<String, Object>();
                rowData.put("flag", (Color)((Object)Integer.valueOf(99)));
                rowData.put("seq", (Color)((Object)Integer.valueOf(1)));
                rowData.put("operate", (Color)((Object)"\u6298\u65e7"));
                rowData.put("period", (Color)((Object)Integer.valueOf(periods.get(i).getNumber())));
                rowData.put("checkedStatus", (Color)((Object)Integer.valueOf(1)));
                rowData.put("depPeriod", null);
                rowData.put("assetValue", null);
                rowData.put("neatValue", null);
                rowData.put("neatAmt", null);
                rowData.put("note", (Color)((Object)"\u6ca1\u6709\u6298\u65e7\u8bb0\u5f55"));
                rowData.put("background", new Color(220, 220, 220));
                rowDatas.add(rowData);
                ++depPeriodCount;
                continue;
            }
            ++depPeriodCount;
            rowDatas.addAll(list);
        }
        if (dpDatass.size() > 0) {
            for (List list : dpDatass.values()) {
                rowDatas.addAll(list);
            }
        }
        if (this.stop) {
            return;
        }
        if (isShowMonRecord) {
            void var44_76;
            sql.setLength(0);
            params.clear();
            sql.append("select \n");
            sql.append("    p.FNumber FPeriod, mon.FDeprTermCount, \n");
            sql.append("    mon.FAssetValue, mon.FNeatValue, mon.FNeatAmt, \n");
            sql.append("    mon.FAccuDeprtYear, mon.FAccuDepr, mon.FDecValue, mon.FDeletedStatus \n");
            sql.append("from T_FA_FaMonCard mon \n");
            sql.append("join T_BD_Period p on p.FID = mon.FFaPeriodID \n");
            sql.append("where mon.FFaCurCardID = ? \n");
            params.add(cardId);
            if (!this.showFutureRecord.isSelected()) {
                sql.append("and p.FNumber < ? \n");
                params.add(currentPeriod.getNumber());
            }
            sql.append("and p.FNumber <= ? \n");
            params.add(completeClearPeriod);
            rs = FMIsqlFacadeFactory.getRemoteInstance().executeQuery(sql.toString(), params.toArray());
            HashMap monDatass = new HashMap();
            while (rs.next()) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("flag", 999);
                hashMap.put("operate", "\u6708\u7ed3");
                Integer period = rs.getInt("FPeriod");
                hashMap.put("period", period);
                hashMap.put("checkedStatus", 2);
                hashMap.put("deletedStatus", rs.getInt("FDeletedStatus"));
                hashMap.put("depPeriod", rs.getInt("FDeprTermCount"));
                hashMap.put("assetValue", rs.getBigDecimal("FAssetValue"));
                hashMap.put("accuDepr", rs.getBigDecimal("FAccuDepr"));
                hashMap.put("accuDeprtYear", rs.getBigDecimal("FAccuDeprtYear"));
                hashMap.put("neatValue", rs.getBigDecimal("FNeatValue"));
                hashMap.put("decValue", rs.getBigDecimal("FDecValue"));
                hashMap.put("neatAmt", rs.getBigDecimal("FNeatAmt"));
                ArrayList<HashMap<String, Object>> monDatas = (ArrayList<HashMap<String, Object>>)monDatass.get(period);
                if (monDatas == null) {
                    monDatas = new ArrayList<HashMap<String, Object>>(1);
                    monDatass.put(period, monDatas);
                    hashMap.put("seq", 1);
                    monDatas.add(hashMap);
                    continue;
                }
                hashMap.put("seq", monDatas.size() + 1);
                hashMap.put("note", "\u6708\u7ed3\u8bb0\u5f55\u91cd\u590d");
                hashMap.put("background", this.BgColor_error);
                hashMap.put("column", "operate");
                monDatas.add(hashMap);
            }
            boolean bl = false;
            while (var44_76 < periods.size()) {
                List monDatas = (List)monDatass.remove(periods.get((int)var44_76).getNumber());
                if (monDatas == null) {
                    if (periods.get((int)var44_76).getNumber() < currentPeriod.getNumber() && periods.get((int)var44_76).getNumber() <= completeClearPeriod) {
                        HashMap<String, Object> rowData6 = new HashMap<String, Object>();
                        rowData6.put("flag", 999);
                        rowData6.put("seq", 1);
                        rowData6.put("operate", "\u6708\u7ed3");
                        rowData6.put("period", periods.get((int)var44_76).getNumber());
                        rowData6.put("checkedStatus", 2);
                        rowData6.put("deletedStatus", 1);
                        rowData6.put("depPeriod", null);
                        rowData6.put("assetValue", null);
                        rowData6.put("neatValue", null);
                        rowData6.put("neatAmt", null);
                        rowData6.put("note", "\u6708\u7ed3\u8bb0\u5f55\u7f3a\u5931");
                        rowData6.put("background", this.BgColor_error);
                        rowData6.put("column", "operate");
                        rowDatas.add(rowData6);
                    }
                } else {
                    rowDatas.addAll(monDatas);
                }
                ++var44_76;
            }
            if (monDatass.size() > 0) {
                for (List monDatas : monDatass.values()) {
                    rowDatas.addAll(monDatas);
                }
            }
            if (this.stop) {
                return;
            }
        }
        HashMap<Integer, Map<String, Color>> balDatas = new HashMap<Integer, Map<String, Color>>();
        if (isShowMonRecord && isShowBalanceRecord) {
            sql.setLength(0);
            params.clear();
            sql.append("select \n");
            sql.append("    p.FNumber FPeriod, \n");
            sql.append("    b.FRealEndBalanceFor, \n");
            sql.append("    b.FDepreEndBalanceFor, \n");
            sql.append("    b.FAddUpYearDepre, \n");
            sql.append("    b.FDecValueEndBalanceFor \n");
            sql.append("from T_FA_FaAccountBalance b \n");
            sql.append("join T_BD_Period p on p.FID = b.FPeriodID \n");
            sql.append("where b.FFaCurCardID = ? \n");
            params.add(cardId);
            if (!this.showFutureRecord.isSelected()) {
                sql.append("and p.FNumber <= ? \n");
                params.add(currentPeriod.getNumber());
            }
            sql.append("and p.FNumber <= ? \n");
            params.add(completeClearPeriod);
            rs = FMIsqlFacadeFactory.getRemoteInstance().executeQuery(sql.toString(), params.toArray());
            while (rs.next()) {
                Integer n = rs.getInt("FPeriod");
                rowData = (Map)balDatas.get(n);
                if (rowData != null) {
                    rowData.put("note", (Color)((Object)"\u4f59\u989d\u8bb0\u5f55\u91cd\u590d"));
                    rowData.put("background", this.BgColor_error);
                    rowData.put("column", (Color)((Object)"operate"));
                    continue;
                }
                rowData = new HashMap();
                rowData.put("period", (Color)((Object)n));
                rowData.put("assetValueBalance", (Color)((Object)rs.getBigDecimal("FRealEndBalanceFor")));
                rowData.put("accuDeprBalance", (Color)((Object)rs.getBigDecimal("FDepreEndBalanceFor")));
                rowData.put("addUpYearDepre", (Color)((Object)rs.getBigDecimal("FAddUpYearDepre")));
                rowData.put("decValueBalance", (Color)((Object)rs.getBigDecimal("FDecValueEndBalanceFor")));
                balDatas.put(n, rowData);
            }
        }
        Collections.sort(rowDatas, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                int r = ((Integer)o1.get("period")).compareTo((Integer)o2.get("period"));
                if (r != 0) {
                    return r;
                }
                int flag1 = (Integer)o1.get("flag");
                int flag2 = (Integer)o2.get("flag");
                if (flag1 == 999 && flag2 == 999) {
                    return ((Integer)o1.get("seq")).compareTo((Integer)o2.get("seq"));
                }
                if (flag1 == 999) {
                    return 1;
                }
                if (flag2 == 999) {
                    return -1;
                }
                Timestamp bizDate1 = (Timestamp)o1.get("bizDate");
                Timestamp bizDate2 = (Timestamp)o2.get("bizDate");
                if (bizDate1 != null && bizDate2 != null) {
                    return bizDate1.compareTo(bizDate2);
                }
                return 0;
            }
        });
        ArrayList<Map> arrayList = new ArrayList<Map>();
        this.addRow(begin);
        int depPeriodBalance = (Integer)begin.get("depPeriod");
        BigDecimal assetValueBalance = (BigDecimal)begin.get("assetValue");
        BigDecimal accuDeprBalance = (BigDecimal)begin.get("accuDepr");
        BigDecimal accuDeprtYearBalance = (BigDecimal)begin.get("accuDeprtYear");
        BigDecimal addUpYearDepre = (BigDecimal)begin.get("accuDeprtYear");
        int periodYear = (Integer)begin.get("period") / 100;
        BigDecimal neatValueBalance = (BigDecimal)begin.get("neatValue");
        BigDecimal decValueBalance = (BigDecimal)begin.get("decValue");
        BigDecimal neatAmtBalance = (BigDecimal)begin.get("neatAmt");
        for (int i = 0; i < rowDatas.size(); ++i) {
            int checkedStatus;
            int period;
            int flag;
            Map rowData7;
            block135: {
                block136: {
                    block137: {
                        Map balData;
                        block139: {
                            block138: {
                                rowData7 = (Map)rowDatas.get(i);
                                flag = (Integer)rowData7.get("flag");
                                period = (Integer)rowData7.get("period");
                                if (period / 100 != periodYear) {
                                    accuDeprtYearBalance = this.ZERO;
                                    addUpYearDepre = this.ZERO;
                                    periodYear = period / 100;
                                }
                                if (flag != 999) break block135;
                                if (period >= currentPeriod.getNumber()) {
                                    rowData7.put("background", new Color(220, 220, 220));
                                    arrayList.add(rowData7);
                                    Map balData2 = (Map)balDatas.get(period);
                                    if (balData2 == null) continue;
                                    rowData7.put("assetValueBalance", balData2.get("assetValueBalance"));
                                    rowData7.put("accuDeprBalance", balData2.get("accuDeprBalance"));
                                    rowData7.put("addUpYearDepre", balData2.get("addUpYearDepre"));
                                    rowData7.put("decValueBalance", balData2.get("decValueBalance"));
                                    continue;
                                }
                                if (rowData7.get("note") == null) {
                                    int deletedStatus = (Integer)rowData7.get("deletedStatus");
                                    if ((Integer)rowData7.get("depPeriod") != depPeriodBalance) {
                                        rowData7.put("note", "\u6708\u7ed3\u6298\u65e7\u671f\u95f4\u6570\u9519\u8bef");
                                        rowData7.put("background", this.BgColor_error);
                                        rowData7.put("column", "depPeriod");
                                    } else if (((BigDecimal)rowData7.get("assetValue")).compareTo(assetValueBalance) != 0 && deletedStatus == 1) {
                                        rowData7.put("note", "\u6708\u7ed3\u539f\u503c\u9519\u8bef");
                                        rowData7.put("background", this.BgColor_error);
                                        rowData7.put("column", "assetValue");
                                    } else if (((BigDecimal)rowData7.get("accuDepr")).compareTo(accuDeprBalance) != 0 && deletedStatus == 1) {
                                        rowData7.put("note", "\u6708\u7ed3\u7d2f\u8ba1\u6298\u65e7\u9519\u8bef");
                                        rowData7.put("background", this.BgColor_error);
                                        rowData7.put("column", "accuDepr");
                                    } else if (((BigDecimal)rowData7.get("accuDeprtYear")).compareTo(accuDeprtYearBalance) != 0 && deletedStatus == 1) {
                                        rowData7.put("note", "\u6708\u7ed3\u672c\u5e74\u7d2f\u8ba1\u6298\u65e7\u9519\u8bef");
                                        rowData7.put("background", this.BgColor_error);
                                        rowData7.put("column", "accuDeprtYear");
                                    } else if (((BigDecimal)rowData7.get("neatValue")).compareTo(neatValueBalance) != 0 && deletedStatus == 1) {
                                        rowData7.put("note", "\u6708\u7ed3\u51c0\u503c\u9519\u8bef");
                                        rowData7.put("background", this.BgColor_error);
                                        rowData7.put("column", "neatValue");
                                    } else if (((BigDecimal)rowData7.get("decValue")).compareTo(decValueBalance) != 0) {
                                        rowData7.put("note", "\u6708\u7ed3\u51cf\u503c\u51c6\u5907\u9519\u8bef");
                                        rowData7.put("background", this.BgColor_error);
                                        rowData7.put("column", "decValue");
                                    } else if (((BigDecimal)rowData7.get("neatAmt")).compareTo(neatAmtBalance) != 0 && deletedStatus == 1) {
                                        rowData7.put("note", "\u6708\u7ed3\u51c0\u989d\u9519\u8bef");
                                        rowData7.put("background", this.BgColor_error);
                                        rowData7.put("column", "neatAmt");
                                    } else {
                                        rowData7.put("background", new Color(252, 251, 223));
                                    }
                                }
                                if (!isShowBalanceRecord) break block136;
                                balData = (Map)balDatas.get(period);
                                if (balData == null) break block137;
                                rowData7.put("assetValueBalance", balData.get("assetValueBalance"));
                                rowData7.put("accuDeprBalance", balData.get("accuDeprBalance"));
                                rowData7.put("addUpYearDepre", balData.get("addUpYearDepre"));
                                rowData7.put("decValueBalance", balData.get("decValueBalance"));
                                if (rowData7.get("note") != null) break block136;
                                if (balData.get("note") == null) break block138;
                                rowData7.put("note", balData.get("note"));
                                rowData7.put("background", this.BgColor_error);
                                break block136;
                            }
                            if (period >= completeClearPeriod) break block136;
                            if (((BigDecimal)balData.get("assetValueBalance")).compareTo(assetValueBalance) == 0) break block139;
                            rowData7.put("note", "\u539f\u503c\u4f59\u989d\u9519\u8bef");
                            rowData7.put("background", this.BgColor_error);
                            rowData7.put("column", "assetValueBalance");
                            break block136;
                        }
                        if (((BigDecimal)balData.get("accuDeprBalance")).compareTo(accuDeprBalance) != 0) {
                            rowData7.put("note", "\u7d2f\u8ba1\u6298\u65e7\u4f59\u989d\u9519\u8bef");
                            rowData7.put("background", this.BgColor_error);
                            rowData7.put("column", "accuDeprBalance");
                            break block136;
                        } else if (((BigDecimal)balData.get("decValueBalance")).compareTo(decValueBalance) != 0) {
                            rowData7.put("note", "\u51cf\u503c\u51c6\u5907\u4f59\u989d\u9519\u8bef");
                            rowData7.put("background", this.BgColor_error);
                            rowData7.put("column", "decValueBalance");
                        }
                        break block136;
                    }
                    rowData7.put("note", "\u4f59\u989d\u8bb0\u5f55\u7f3a\u5931");
                    rowData7.put("background", this.BgColor_error);
                    rowData7.put("column", "operate");
                }
                this.addRow(rowData7);
                continue;
            }
            if (currentPeriod.getNumber() < beginPeriod) {
                if (period > beginPeriod) {
                    rowData7.put("background", new Color(220, 220, 220));
                    arrayList.add(rowData7);
                    continue;
                }
            } else if (period > currentPeriod.getNumber()) {
                rowData7.put("background", new Color(220, 220, 220));
                arrayList.add(rowData7);
                continue;
            }
            if ((checkedStatus = ((Integer)rowData7.get("checkedStatus")).intValue()) == 2) {
                BigDecimal decValue2;
                BigDecimal originDiff2 = (BigDecimal)rowData7.get("originDiff");
                BigDecimal depreciation = (BigDecimal)rowData7.get("depreciation");
                BigDecimal accuDeprChg2 = (BigDecimal)rowData7.get("accuDeprChg");
                BigDecimal accuDeprtYearChg2 = (BigDecimal)rowData7.get("accuDeprtYearChg");
                if (flag == 2) {
                    if (originDiff2 != null) {
                        assetValueBalance = assetValueBalance.add(originDiff2);
                        neatValueBalance = neatValueBalance.add(originDiff2);
                        neatAmtBalance = neatAmtBalance.add(originDiff2);
                    }
                    if (accuDeprChg2 != null) {
                        accuDeprBalance = accuDeprBalance.add(accuDeprChg2);
                        neatValueBalance = neatValueBalance.subtract(accuDeprChg2);
                        neatAmtBalance = neatAmtBalance.subtract(accuDeprChg2);
                        addUpYearDepre = addUpYearDepre.add(accuDeprChg2);
                    }
                    if (accuDeprtYearChg2 != null) {
                        accuDeprtYearBalance = accuDeprtYearBalance.add(accuDeprtYearChg2);
                    }
                } else if (flag == 89) {
                    if (originDiff2 != null) {
                        assetValueBalance = assetValueBalance.add(originDiff2);
                        neatValueBalance = neatValueBalance.add(originDiff2);
                        neatAmtBalance = neatAmtBalance.add(originDiff2);
                    }
                    if (accuDeprChg2 != null) {
                        accuDeprBalance = accuDeprBalance.add(accuDeprChg2);
                        neatValueBalance = neatValueBalance.subtract(accuDeprChg2);
                        neatAmtBalance = neatAmtBalance.subtract(accuDeprChg2);
                        addUpYearDepre = addUpYearDepre.add(accuDeprChg2);
                    }
                    if (accuDeprtYearChg2 != null) {
                        accuDeprtYearBalance = accuDeprtYearBalance.add(accuDeprtYearChg2);
                    }
                } else if (flag == 99) {
                    ++depPeriodBalance;
                    if (depreciation != null) {
                        accuDeprBalance = accuDeprBalance.add(depreciation);
                        accuDeprtYearBalance = accuDeprtYearBalance.add(depreciation);
                        neatValueBalance = neatValueBalance.subtract(depreciation);
                        neatAmtBalance = neatAmtBalance.subtract(depreciation);
                        addUpYearDepre = addUpYearDepre.add(depreciation);
                    }
                }
                if ((decValue2 = (BigDecimal)rowData7.get("decValue")) != null) {
                    decValueBalance = decValueBalance.add(decValue2);
                    neatAmtBalance = neatAmtBalance.subtract(decValue2);
                }
                this.addRow(rowData7);
                continue;
            }
            if (period == currentPeriod.getNumber()) {
                if (!this.showFutureRecord.isSelected()) continue;
                if (rowData7.get("note") == null) {
                    rowData7.put("note", "\u672a\u5ba1\u6838");
                    rowData7.put("background", new Color(220, 220, 220));
                }
                arrayList.add(rowData7);
                continue;
            }
            if (rowData7.get("note") == null) {
                rowData7.put("note", "\u672a\u5ba1\u6838");
                rowData7.put("background", this.BgColor_error);
                rowData7.put("column", "operate");
            }
            this.addRow(rowData7);
        }
        if (depPeriodBalance != lastDepPeriod) {
            current.put("note", "\u5f53\u524d\u6298\u65e7\u671f\u95f4\u6570\u9519\u8bef");
            current.put("background", this.BgColor_error);
            current.put("column", "depPeriod");
        } else if (assetValueBalance.compareTo(lastAssetValue) != 0 && lastDeletedStatus == 1) {
            current.put("note", "\u5f53\u524d\u539f\u503c\u9519\u8bef");
            current.put("background", this.BgColor_error);
            current.put("column", "assetValue");
        } else if (accuDeprBalance.compareTo(lastAccuDepr) != 0 && lastDeletedStatus == 1) {
            current.put("note", "\u5f53\u524d\u7d2f\u8ba1\u6298\u65e7\u9519\u8bef");
            current.put("background", this.BgColor_error);
            current.put("column", "accuDepr");
        } else if (accuDeprtYearBalance.compareTo(lastAccuDeprtYear) != 0 && lastDeletedStatus == 1) {
            current.put("note", "\u5f53\u524d\u672c\u5e74\u7d2f\u8ba1\u6298\u65e7\u9519\u8bef");
            current.put("background", this.BgColor_error);
            current.put("column", "accuDeprtYear");
        } else if (neatValueBalance.compareTo(lastNeatValue) != 0 && lastDeletedStatus == 1) {
            current.put("note", "\u5f53\u524d\u51c0\u503c\u9519\u8bef");
            current.put("background", this.BgColor_error);
            current.put("column", "neatValue");
        } else if (decValueBalance.compareTo(lastDecValue) != 0) {
            current.put("note", "\u5f53\u524d\u51cf\u503c\u51c6\u5907\u9519\u8bef");
            current.put("background", this.BgColor_error);
            current.put("column", "decValue");
        } else if (neatAmtBalance.compareTo(lastNeatAmt) != 0 && lastDeletedStatus == 1) {
            current.put("note", "\u5f53\u524d\u51c0\u989d\u9519\u8bef");
            current.put("background", this.BgColor_error);
            current.put("column", "neatAmt");
        } else {
            current.put("background", this.BgColor_right);
        }
        int period = -1;
        Map balData = null;
        if (completeClearPeriod <= currentPeriod.getNumber()) {
            balData = (Map)balDatas.get(completeClearPeriod);
            period = completeClearPeriod;
        }
        if (balData == null) {
            balData = (Map)balDatas.get(currentPeriod.getNumber());
            period = currentPeriod.getNumber();
        }
        if (balData != null) {
            current.put("assetValueBalance", balData.get("assetValueBalance"));
            current.put("accuDeprBalance", balData.get("accuDeprBalance"));
            current.put("addUpYearDepre", balData.get("addUpYearDepre"));
            current.put("decValueBalance", balData.get("decValueBalance"));
            if (current.get("note") == null) {
                if (balData.get("note") != null) {
                    current.put("note", balData.get("note"));
                    current.put("background", this.BgColor_error);
                } else if (period < completeClearPeriod) {
                    if (((BigDecimal)balData.get("assetValueBalance")).compareTo(assetValueBalance) != 0) {
                        current.put("note", "\u539f\u503c\u4f59\u989d\u9519\u8bef");
                        current.put("background", this.BgColor_error);
                        current.put("column", "assetValueBalance");
                    } else if (((BigDecimal)balData.get("accuDeprBalance")).compareTo(accuDeprBalance) != 0) {
                        current.put("note", "\u7d2f\u8ba1\u6298\u65e7\u4f59\u989d\u9519\u8bef");
                        current.put("background", this.BgColor_error);
                        current.put("column", "accuDeprBalance");
                    } else if (((BigDecimal)balData.get("decValueBalance")).compareTo(decValueBalance) != 0) {
                        current.put("note", "\u51cf\u503c\u51c6\u5907\u4f59\u989d\u9519\u8bef");
                        current.put("background", this.BgColor_error);
                        current.put("column", "decValueBalance");
                    }
                }
            }
        }
        int factPeriod = currentPeriod.getNumber() < beginPeriod ? beginPeriod : currentPeriod.getNumber();
        boolean addCurrent = false;
        for (Map rowData8 : arrayList) {
            period = (Integer)rowData8.get("period");
            if (period > factPeriod && !addCurrent) {
                this.addRow(current);
                addCurrent = true;
            }
            this.addRow(rowData8);
        }
        if (!addCurrent) {
            this.addRow(current);
        }
    }

    private void addRow(final Map<String, Object> rowData) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String column;
                IRow row = FaCardLifeCycleUI.this.tblMain.addRow();
                row.getCell("operate").setValue(rowData.get("operate"));
                row.getCell("period").setValue(rowData.get("period"));
                row.getCell("bizNumber").setValue(rowData.get("bizNumber"));
                row.getCell("bizDate").setValue(rowData.get("bizDate"));
                row.getCell("changeDate").setValue(rowData.get("changeDate"));
                row.getCell("changeType").setValue(rowData.get("changeType"));
                row.getCell("depPeriod").setValue(rowData.get("depPeriod"));
                row.getCell("deprMethod").setValue(rowData.get("deprMethod"));
                row.getCell("originDiff").setValue(rowData.get("originDiff"));
                row.getCell("assetValue").setValue(rowData.get("assetValue"));
                row.getCell("depreciation").setValue(rowData.get("depreciation"));
                row.getCell("accuDeprChg").setValue(rowData.get("accuDeprChg"));
                row.getCell("accuDepr").setValue(rowData.get("accuDepr"));
                row.getCell("accuDeprtYearChg").setValue(rowData.get("accuDeprtYearChg"));
                row.getCell("accuDeprtYear").setValue(rowData.get("accuDeprtYear"));
                row.getCell("neatValue").setValue(rowData.get("neatValue"));
                row.getCell("decValue").setValue(rowData.get("decValue"));
                row.getCell("neatAmt").setValue(rowData.get("neatAmt"));
                row.getCell("assetValueBalance").setValue(rowData.get("assetValueBalance"));
                row.getCell("accuDeprBalance").setValue(rowData.get("accuDeprBalance"));
                row.getCell("addUpYearDepre").setValue(rowData.get("addUpYearDepre"));
                row.getCell("decValueBalance").setValue(rowData.get("decValueBalance"));
                row.getCell("note").setValue(rowData.get("note"));
                Color background = (Color)rowData.get("background");
                if (background != null) {
                    row.getStyleAttributes().setBackground(background);
                }
                if ((column = (String)rowData.get("column")) != null) {
                    StyleAttributes sa = row.getCell(column).getStyleAttributes();
                    sa.setFontColor(Color.RED);
                    sa.setBold(true);
                }
            }
        });
    }

    private void showInfo(String message) {
        this.showDetail(message, this.defAttr);
    }

    private void showWarn(String message) {
        this.showDetail(message, this.warnAttr);
    }

    private void showError(String message) {
        this.showDetail(message, this.errorAttr);
    }

    private void showExe(String message) {
        this.showDetail(message, this.exeAttr);
    }

    public static String printStackTrace(Throwable t) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(stream);
        t.printStackTrace(writer);
        writer.flush();
        String s = stream.toString();
        writer.close();
        return s;
    }

    private void showDetail(final String message, final SimpleAttributeSet set) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Document doc = FaCardLifeCycleUI.this.txtConsole.getDocument();
                try {
                    doc.insertString(doc.getLength(), message + "\n", set);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
    }

    public boolean checkBeforeWindowClosing() {
        this.stop = true;
        return super.checkBeforeWindowClosing();
    }

    public static void showMe(Object owner, String cardId, boolean showFutureRecord) {
        UIContext uiContext = new UIContext(owner);
        if (cardId != null) {
            uiContext.put((Object)"cardId", (Object)cardId);
            uiContext.put((Object)"ID", (Object)cardId);
        }
        uiContext.put((Object)"showFutureRecord", (Object)showFutureRecord);
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.fi.fa.manage.client.FaCardLifeCycleUI", (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
        catch (UIException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

