/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaCardInfo;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaCardTaxCalcUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import javax.swing.JTextField;

public class FaCardTaxCalcUI
extends AbstractFaCardTaxCalcUI {
    private FaCardInfo card;
    private final String nameColumn = "name";
    private final String percentColumn = "percent";
    private final String oriValueColumn = "originValue";
    private final String newValueColumn = "newValue";
    private final BigDecimal zero = new BigDecimal("0");
    private final BigDecimal hundred = new BigDecimal("100");
    private boolean isConfirm = false;
    static final String CARD_INFO = "cardinfo";

    public void onLoad() throws Exception {
        super.onLoad();
        this.card = (FaCardInfo)this.getUIContext().get(CARD_INFO);
        this.initControl();
        this.fillData();
    }

    protected void initUserConfig() {
    }

    private void initControl() throws EASBizException, BOSException {
        final int currencyScale = FaClientUtils.getCurrencyScale();
        this.kdtDetail.checkParsed();
        FaClientUtils.changeTableNumberFormat(this.kdtDetail, new String[]{"originValue", "newValue"}, FaClientUtils.getFormatPatternForColumn(currencyScale));
        FaClientUtils.changeTableNumberFormat(this.kdtDetail, new String[]{"percent"}, FaClientUtils.getFormatPatternForColumn(0));
        KDFormattedTextField decimalEditor = new KDFormattedTextField(1);
        decimalEditor.setPrecision(0);
        decimalEditor.setNegatived(false);
        decimalEditor.setSupportedEmpty(false);
        decimalEditor.setHorizontalAlignment(4);
        this.kdtDetail.getColumn("percent").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)decimalEditor));
        this.kdtDetail.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                if (e.getColIndex() == FaCardTaxCalcUI.this.kdtDetail.getColumnIndex("percent")) {
                    BigDecimal originValue;
                    BigDecimal percent = (BigDecimal)e.getValue();
                    BigDecimal newValue = percent.multiply(originValue = (BigDecimal)FaCardTaxCalcUI.this.kdtDetail.getRow(e.getRowIndex()).getCell("originValue").getValue()).divide(new BigDecimal(100), currencyScale, 4);
                    if (newValue.compareTo(FaClientUtils.MAX_DECIMAL) > 0) {
                        newValue = FaClientUtils.MAX_DECIMAL;
                    }
                    FaCardTaxCalcUI.this.kdtDetail.getRow(e.getRowIndex()).getCell("newValue").setValue((Object)newValue);
                }
            }
        });
    }

    private void fillData() {
        IRow row = this.kdtDetail.addRow();
        BigDecimal assetValue = this.card.getAssetValue() == null ? this.zero : this.card.getAssetValue();
        BigDecimal evalAssetValue = this.card.getEvalAssetValue() == null ? this.zero : this.card.getEvalAssetValue();
        row.getCell("name").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"assetValue"));
        row.getCell("percent").setValue((Object)(assetValue.compareTo(this.zero) == 0 ? this.zero : evalAssetValue.multiply(this.hundred).divide(assetValue, 0, 4)));
        row.getCell("originValue").setValue((Object)assetValue);
        row.getCell("newValue").setValue((Object)evalAssetValue);
        row = this.kdtDetail.addRow();
        BigDecimal accuDepr = this.card.getAccuDepr() == null ? this.zero : this.card.getAccuDepr();
        BigDecimal evalaccuDepr = this.card.getEvalAddDepr() == null ? this.zero : this.card.getEvalAddDepr();
        row.getCell("name").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"FaCurCard_DeprBegin"));
        row.getCell("percent").setValue((Object)(accuDepr.compareTo(this.zero) == 0 ? this.zero : evalaccuDepr.multiply(this.hundred).divide(accuDepr, 0, 4)));
        row.getCell("originValue").setValue((Object)accuDepr);
        row.getCell("newValue").setValue((Object)evalaccuDepr);
        row = this.kdtDetail.addRow();
        BigDecimal yearDepr = this.card.getAccuDeprTYear() == null ? this.zero : this.card.getAccuDeprTYear();
        BigDecimal evalyearDepr = this.card.getEvalYearDepr() == null ? this.zero : this.card.getEvalYearDepr();
        row.getCell("name").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"accuDeprTYear"));
        row.getCell("percent").setValue((Object)(yearDepr.compareTo(this.zero) == 0 ? this.zero : evalyearDepr.multiply(this.hundred).divide(yearDepr, 0, 4)));
        row.getCell("originValue").setValue((Object)yearDepr);
        row.getCell("newValue").setValue((Object)evalyearDepr);
        row = this.kdtDetail.addRow();
        BigDecimal decValue = this.card.getDecValue() == null ? this.zero : this.card.getDecValue();
        BigDecimal evaldecValue = this.card.getEvalDecValue() == null ? this.zero : this.card.getEvalDecValue();
        row.getCell("name").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"FaCurCard_DecValue"));
        row.getCell("percent").setValue((Object)(decValue.compareTo(this.zero) == 0 ? this.zero : evaldecValue.multiply(this.hundred).divide(decValue, 0, 4)));
        row.getCell("originValue").setValue((Object)decValue);
        row.getCell("newValue").setValue((Object)evaldecValue);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isConfirm = false;
        Util.getWindow((Component)((Object)this)).dispose();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.isConfirm = true;
        IRow row = this.kdtDetail.getRow(0);
        this.card.setEvalAssetValue((BigDecimal)row.getCell("newValue").getValue());
        row = this.kdtDetail.getRow(1);
        this.card.setEvalAddDepr((BigDecimal)row.getCell("newValue").getValue());
        row = this.kdtDetail.getRow(2);
        this.card.setEvalYearDepr((BigDecimal)row.getCell("newValue").getValue());
        row = this.kdtDetail.getRow(3);
        this.card.setEvalDecValue((BigDecimal)row.getCell("newValue").getValue());
        Util.getWindow((Component)((Object)this)).dispose();
    }

    public boolean isConfirm() {
        return this.isConfirm;
    }

    public FaCardInfo getCardInfo() {
        return this.card;
    }
}

