/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.codingrule.CodingRuleEntryCollection;
import com.kingdee.eas.base.codingrule.CodingRuleEntryFactory;
import com.kingdee.eas.base.codingrule.CodingRuleEntryInfo;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.BarCodeStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCardInfo;
import com.kingdee.eas.util.client.EASResource;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class FaCardUtil {
    private static final Logger logger = Logger.getLogger(FaCardUtil.class);
    private static final String RESOURCE_PATH = "com.kingdee.eas.fi.fa.manage.FaCardResource";
    public static final String PHYSICAL_RESOURCE_PATH = "com.kingdee.eas.fi.fa.manage.FaPhysicalResource";

    public static String checkCodingruleAttributeNotNull(FaCardInfo card, String companyid, Map hmResult) throws EASBizException, BOSException {
        CodingRuleEntryInfo codingRuleEntryInfo;
        int i;
        if (card.getBarCode() != null) {
            if (FaCardUtil.isGB2312(card.getBarCode())) {
                return EASResource.getString((String)RESOURCE_PATH, (String)"noCN");
            }
            return null;
        }
        if (Boolean.valueOf(String.valueOf(hmResult.get("FA_043"))).booleanValue()) {
            String changeCode = (String)hmResult.get("FA_101");
            if (changeCode != null && "false".equalsIgnoreCase(changeCode.trim())) {
                return null;
            }
        } else {
            return null;
        }
        card.setBarCodeStatus(BarCodeStatusEnum.EFFECTED);
        CodingRuleInfo codingRuleInfo = CodingRuleManagerFactory.getRemoteInstance().getCodingRule((IObjectValue)card, companyid, "barCodeStatus");
        if (codingRuleInfo == null) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("codingRule.id", (Object)codingRuleInfo.getId().toString()));
        view.setFilter(f);
        CodingRuleEntryCollection cols = CodingRuleEntryFactory.getRemoteInstance().getCodingRuleEntryCollection(view);
        int n = cols.size();
        for (i = 0; i < n; ++i) {
            codingRuleEntryInfo = cols.get(i);
            String attribute = codingRuleEntryInfo.getCodeAttribute();
            String str = codingRuleEntryInfo.getValueAttribute();
            String format = codingRuleEntryInfo.getFormat();
            if (!"fixedvalue".equalsIgnoreCase(attribute) || !FaCardUtil.isGB2312(format)) continue;
            return MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"16_FaCardUtil"), codingRuleInfo.getName());
        }
        n = cols.size();
        for (i = 0; i < n; ++i) {
            codingRuleEntryInfo = cols.get(i);
            String str = codingRuleEntryInfo.getValueAttribute();
            if (!"attribute".equalsIgnoreCase(codingRuleEntryInfo.getCodeAttribute()) || str == null) continue;
            if ("accountDate".equalsIgnoreCase(str) && card.getAccountDate() == null) {
                return EASResource.getString((String)RESOURCE_PATH, (String)"accountDateNotNull");
            }
            if (str.startsWith("dept.") && card.getDept() == null) {
                return EASResource.getString((String)RESOURCE_PATH, (String)"deptNotNull");
            }
            if (!str.startsWith("assetCat.") || card.getAssetCat() != null) continue;
            return EASResource.getString((String)RESOURCE_PATH, (String)"faCatNotNull");
        }
        String str = CodingRuleManagerFactory.getRemoteInstance().readNumber((IObjectValue)card, companyid, "barCodeStatus", "");
        if (FaCardUtil.isGB2312(str)) {
            return EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"17_FaCardUtil");
        }
        return null;
    }

    public static boolean isGB2312(String str) {
        char[] chars = str.toCharArray();
        boolean isGB2312 = false;
        for (int i = 0; i < chars.length; ++i) {
            int[] ints;
            byte[] bytes = ("" + chars[i]).getBytes();
            if (bytes.length != 2 || (ints = new int[]{bytes[0] & 0xFF, bytes[1] & 0xFF})[0] < 129 || ints[0] > 254 || ints[1] < 64 || ints[1] > 254) continue;
            isGB2312 = true;
            break;
        }
        return isGB2312;
    }

    public static boolean isTxtNull(KDTextField txtNumber) {
        if (txtNumber == null) {
            return true;
        }
        return txtNumber.getText() == null || txtNumber.getText().trim().length() == 0;
    }

    public static String getPhysicalResource(String resName) {
        return EASResource.getString((String)PHYSICAL_RESOURCE_PATH, (String)resName);
    }

    public static String getCardImageUrl(Set idSet, UserInfo user) throws BOSException, EASBizException {
        String url = null;
        ArrayList list = new ArrayList(idSet);
        try {
            url = BillImageFacadeFactory.getRemoteInstance().getImageURL((String)list.get(0), false, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e);
        }
        return url;
    }
}

