/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.FaAlterModeFactory;
import com.kingdee.eas.fi.fa.basedata.FaAlterModeInfo;
import com.kingdee.eas.fi.fa.basedata.client.FaAlterModePromptBox;
import com.kingdee.eas.fi.fa.basedata.client.FaDisplyFormatter;
import com.kingdee.eas.fi.fa.basedata.client.FaEditFormatter;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaChangeBillFilterUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.util.Date;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FaChangeBillFilterUI
extends AbstractFaChangeBillFilterUI
implements ChangeListener {
    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.auditPanel.setOpaque(false);
        this.initControl();
    }

    private void initControl() throws Exception {
        FaAlterModePromptBox aFaAlterModePromptBox = new FaAlterModePromptBox((CoreUIObject)this, true);
        this.promptBoxChangeMode.setSelector((KDPromptSelector)aFaAlterModePromptBox);
        this.promptBoxChangeMode.setDisplayFormatter((IFormatter)new FaDisplyFormatter());
        this.promptBoxChangeMode.setEditFormatter((IFormatter)new FaEditFormatter());
        this.promptBoxChangeMode.setEditable(true);
        this.promptBoxChangeMode.setCommitFormat("$number$");
        this.promptBoxChangeMode.setQueryInfo("com.kingdee.eas.fi.fa.basedata.FaAlterModeQuery");
        this.promptBoxChangeMode.setEntityViewInfo(FaClientUtils.getAlterModeOrgSplitViewInfo(true));
        this.promptBoxChangeMode.addChangeListener((ChangeListener)this);
        this.radioBtnAll.setSelected(true);
        this.dpChangeDateFrom.setValue(null);
        this.dpChangeDateTo.setValue(null);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        FaAlterModeInfo aFaAlterModeInfo;
        if (e.getSource() == this.promptBoxChangeMode && (aFaAlterModeInfo = (FaAlterModeInfo)this.promptBoxChangeMode.getData()) != null && !aFaAlterModeInfo.isIsLeaf()) {
            this.promptBoxChangeMode.setValue(null);
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource.strSelectChildPoint");
            MsgBox.showInfo((Component)((Object)this), (String)msg);
        }
    }

    public FilterInfo getFilterInfo() {
        FilterItemInfo templateFilterItemInfo;
        FilterItemInfo templateFilterItemInfo2;
        StringBuffer sbFormula = new StringBuffer();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        int i = 0;
        FaClientUtils.checkComp(null, SysContext.getSysContext().getCurrentFIUnit());
        if (SysContext.getSysContext().getCurrentFIUnit() != null) {
            FilterItemInfo companyFilterItemInfo = new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString());
            items.add(companyFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.tfChangeNumberFrom.getText() != null && this.tfChangeNumberFrom.getText().trim().length() > 0) {
            templateFilterItemInfo2 = new FilterItemInfo("number", (Object)this.tfChangeNumberFrom.getText().trim(), CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo2);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.tfChangeNumberTo.getText() != null && this.tfChangeNumberTo.getText().trim().length() > 0) {
            templateFilterItemInfo2 = new FilterItemInfo("number", (Object)this.tfChangeNumberTo.getText().trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo2);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.dpChangeDateFrom.getValue() != null) {
            Date dateFrom = DateTimeUtils.truncateDate((Date)((Date)this.dpChangeDateFrom.getValue()));
            templateFilterItemInfo = new FilterItemInfo("changeDate", (Object)dateFrom, CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.dpChangeDateTo.getValue() != null) {
            Date dateTo = new Date(DateTimeUtils.truncateDate((Date)((Date)this.dpChangeDateTo.getValue())).getTime() + 86400000L - 1L);
            templateFilterItemInfo = new FilterItemInfo("changeDate", (Object)dateTo, CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.promptBoxChangeMode.getData() != null) {
            templateFilterItemInfo2 = new FilterItemInfo("changeMode.id", (Object)((FaAlterModeInfo)this.promptBoxChangeMode.getData()).getId().toString());
            items.add(templateFilterItemInfo2);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.radioBtnAudit.isSelected()) {
            FilterItemInfo audited = new FilterItemInfo("checkedStatus", (Object)new Integer(2));
            items.add(audited);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        } else if (this.radioBtnUnAudit.isSelected()) {
            FilterItemInfo unAudited = new FilterItemInfo("checkedStatus", (Object)new Integer(1));
            items.add(unAudited);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (sbFormula.toString().length() != 0) {
            filter.setMaskString(sbFormula.toString());
        }
        return filter;
    }

    public void loadData(EntityViewInfo viewInfo) {
        this.clear();
        try {
            FilterItemCollection currentFilterItemCollection = viewInfo.getFilter().getFilterItems();
            if (currentFilterItemCollection == null || currentFilterItemCollection.size() == 0) {
                return;
            }
            int currentFilterItemCollectionSize = currentFilterItemCollection.size();
            for (int i = 0; i < currentFilterItemCollectionSize; ++i) {
                String number;
                FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
                if (filterItemInfo.getPropertyName().equals("number") && filterItemInfo.getCompareType().getName().equals(CompareType.GREATER_EQUALS.getName())) {
                    number = filterItemInfo.getCompareValue().toString();
                    this.tfChangeNumberFrom.setText(number);
                }
                if (filterItemInfo.getPropertyName().equals("number") && filterItemInfo.getCompareType().getName().equals(CompareType.LESS_EQUALS.getName())) {
                    number = filterItemInfo.getCompareValue().toString();
                    this.tfChangeNumberTo.setText(number);
                }
                if (filterItemInfo.getPropertyName().equals("changeDate") && filterItemInfo.getCompareType().getName().equals(CompareType.GREATER_EQUALS.getName())) {
                    this.dpChangeDateFrom.setValue(filterItemInfo.getCompareValue());
                }
                if (filterItemInfo.getPropertyName().equals("changeDate") && filterItemInfo.getCompareType().getName().equals(CompareType.LESS_EQUALS.getName())) {
                    this.dpChangeDateTo.setValue(filterItemInfo.getCompareValue());
                }
                if (filterItemInfo.getPropertyName().equals("changeMode.id")) {
                    String assetCatId = filterItemInfo.getCompareValue().toString();
                    ObjectStringPK pk = new ObjectStringPK();
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("number"));
                    sic.add(new SelectorItemInfo("name"));
                    sic.add(new SelectorItemInfo("isLeaf"));
                    pk.setKeyValue("id", (Object)assetCatId);
                    this.promptBoxChangeMode.setData((Object)FaAlterModeFactory.getRemoteInstance().getFaAlterModeInfo((IObjectPK)pk, sic));
                }
                if (filterItemInfo.getPropertyName().equals("checkedStatus") && filterItemInfo.getCompareValue() != null) {
                    if ((Integer)filterItemInfo.getCompareValue() == 2) {
                        this.radioBtnAudit.setSelected(true);
                    } else if ((Integer)filterItemInfo.getCompareValue() == 1) {
                        this.radioBtnUnAudit.setSelected(true);
                    }
                }
                if (!filterItemInfo.getPropertyName().equals("checkedStatus") || filterItemInfo.getCompareValue() != null) continue;
                this.radioBtnAll.setSelected(true);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void clear() {
        this.radioBtnAll.setSelected(true);
        this.promptBoxChangeMode.setValue(null);
        this.dpChangeDateFrom.setValue(null);
        this.dpChangeDateTo.setValue(null);
        this.tfChangeNumberFrom.setText("");
        this.tfChangeNumberTo.setText("");
    }
}

