/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.access.MetaDataAccessLoader;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.client.AttachmentUIContextInfo;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.fa.basedata.FaUtils;
import com.kingdee.eas.fi.fa.def.meta.FaDefQueryManager;
import com.kingdee.eas.fi.fa.manage.FaBakCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBillOriginEnum;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.FaClearBillCollection;
import com.kingdee.eas.fi.fa.manage.FaClearBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaClearBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaClearBillFactory;
import com.kingdee.eas.fi.fa.manage.FaClearBillInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.IFaClearBill;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaClearBillListUI;
import com.kingdee.eas.fi.fa.manage.client.CommonQueryWithResultDialog;
import com.kingdee.eas.fi.fa.manage.client.FACommonProcessor;
import com.kingdee.eas.fi.fa.manage.client.FaCardUtil;
import com.kingdee.eas.fi.fa.manage.client.FaClearBillEditUI;
import com.kingdee.eas.fi.fa.manage.client.FaClearBillFilterUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.manage.client.FaPrintHelper;
import com.kingdee.eas.fi.fa.manage.client.FaScanBarCodesEditUI;
import com.kingdee.eas.fi.fa.manage.client.ProcessUI;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.client.VersionUtil;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.BillBaseCollection;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.BillEntryBaseInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.KeyStroke;

public class FaClearBillListUI
extends AbstractFaClearBillListUI {
    private static String className = "com.kingdee.eas.fi.fa.manage.FaCardResource";
    private CompanyOrgUnitInfo currentCompany;
    private static final BigDecimal ZERO = new BigDecimal("0");
    boolean isUseWorkflow = false;
    protected HashMap faParameter;
    private KDTSelectListener dapKDTSelectListener = null;
    private static final String CHECKED_STATUS = "checkedStatus";
    private int selectedCheckedStauts = 2;

    protected boolean isFootVisible() {
        return true;
    }

    public FaClearBillListUI() throws Exception {
        this.setUITitle(EASResource.getString((String)className, (String)"FaClearBillTitle"));
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                FaClearBillListUI.this.changeTableMerge(e);
            }
        });
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent arg0) {
                try {
                    FaClearBillListUI.this.selectOneLine();
                }
                catch (Exception e) {
                    FaClearBillListUI.this.handUIException(e);
                }
            }
        });
    }

    public String getTableFormatXml() {
        return this.tblMain.getFormatXml();
    }

    private void selectOneLine() throws Exception {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return;
            }
            ICell cell = row.getCell(CHECKED_STATUS);
            if (cell != null) {
                BizEnumValueInfo aBizEnumValueInfo;
                ICell statusCell = row.getCell("effectedStatus");
                if (statusCell != null && statusCell.getValue() != null && statusCell.getValue() instanceof BizEnumValueInfo && (aBizEnumValueInfo = (BizEnumValueInfo)statusCell.getValue()).getValue().equals(String.valueOf(1))) {
                    this.actionAudit.setEnabled(false);
                    this.btnAudit.setEnabled(false);
                    this.menuItemAudit.setEnabled(false);
                    this.actionCancelAudit.setEnabled(false);
                    this.btnCancelAudit.setEnabled(false);
                    this.menuItemUnaudit.setEnabled(false);
                    return;
                }
                Object keyValue = cell.getValue();
                if (keyValue != null && keyValue instanceof BizEnumValueInfo) {
                    if (((BizEnumValueInfo)keyValue).getValue().toString().equals("2")) {
                        this.actionAudit.setEnabled(false);
                        this.btnAudit.setEnabled(false);
                        this.menuItemAudit.setEnabled(false);
                        this.actionCancelAudit.setEnabled(true);
                        this.btnCancelAudit.setEnabled(true);
                        this.menuItemUnaudit.setEnabled(true);
                    } else {
                        this.actionAudit.setEnabled(true);
                        this.btnAudit.setEnabled(true);
                        this.menuItemAudit.setEnabled(true);
                        this.actionCancelAudit.setEnabled(false);
                        this.btnCancelAudit.setEnabled(false);
                        this.menuItemUnaudit.setEnabled(false);
                    }
                }
            }
        }
    }

    @Override
    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        FaClientUtils.checkForGenVoucher();
        this.checkObjectExists();
        boolean isSplitOrCombineNoVourcher = "true".equals(this.gethmParam().get("FA_048").toString());
        if (isSplitOrCombineNoVourcher) {
            int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
            for (int i = 0; i < selectRows.length; ++i) {
                FaClearBillInfo billInfo;
                ICell idCell;
                String cardID;
                int rowIndex = selectRows[i];
                IRow row = this.tblMain.getRow(rowIndex);
                if (row == null || (cardID = (String)(idCell = row.getCell("id")).getValue()) == null || cardID.trim().length() == 0 || (billInfo = FaClearBillFactory.getRemoteInstance().getFaClearBillInfo((IObjectPK)new ObjectUuidPK(cardID))) == null || billInfo.getBillType() != FaBillOriginEnum.FROM_SPLIT && billInfo.getBillType() != FaBillOriginEnum.FROM_COMBIN) continue;
                String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource.needNotVourcher_clearCard");
                MsgBox.showInfo((Component)((Object)this), (String)strMsg);
                SysUtil.abort();
            }
        }
        super.actionVoucher_actionPerformed(e);
    }

    protected void checkObjectExists() throws BOSException, EASBizException, Exception {
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return FaClearBillEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FaClearBillFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    private void changeTableMerge(KDTDataRequestEvent e) {
        this.tblMain.setVerticalGridLineVisible(true);
        this.tblMain.setHorizonGridLineVisible(true);
        for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
            Object keyValue;
            IRow row = this.tblMain.getRow(i);
            if (row.getCell("clearBillEntry.splithDeal").getValue() != null && row.getCell("clearBillEntry.splithDeal").getValue().toString().equals("-1")) {
                row.getCell("clearBillEntry.splithDeal").setValue(null);
            }
            if (row.getCell(CHECKED_STATUS) == null || row.getCell(CHECKED_STATUS).getValue() == null || (keyValue = row.getCell(CHECKED_STATUS).getValue()) == null || !(keyValue instanceof BizEnumValueInfo)) continue;
            if (((BizEnumValueInfo)keyValue).getValue().toString().equals("2")) {
                row.getStyleAttributes().setBackground(FaClientUtils.colorAudit);
                continue;
            }
            row.getStyleAttributes().setBackground(FaClientUtils.colorNoAudit);
        }
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"btnType", (Object)e.getActionCommand());
        uiContext.put((Object)"parentUI", (Object)FaClearBillListUI.class.getName());
        if (this.getActionFromActionEvent(e).equals(this.actionAddNew)) {
            uiContext.put((Object)"Select_CurCards", this.getUIContext().get("SearchResult"));
        }
    }

    public void onLoad() throws Exception {
        FaDefQueryManager.addDefProperty((IMetaDataPK)this.mainQueryPK, (String)"bizCard", (KDTable)this.tblMain, (ResourceBundleHelper)this.resHelper);
        if (this.mainQuery == null) {
            this.mainQuery = new EntityViewInfo();
            this.setDataObject((IObjectValue)this.mainQuery);
        }
        CompanyOrgUnitInfo company = this.getCurrentCompany();
        FaClientUtils.checkComp((Component)((Object)this), company);
        FaClientUtils.checkFaInit((Component)this.getUIContext().get("Owner"), company);
        FaClientUtils.checkAccountSwap((Component)((Object)this), company);
        this.tblMain.checkParsed();
        this.tblMain.getGroupManager().setGroup(true);
        int size = this.getMergeColumns().length;
        for (int i = 0; i < size; ++i) {
            this.tblMain.getColumn(this.getMergeColumns()[i]).setGroup(true);
            this.tblMain.getColumn(this.getMergeColumns()[i]).setMergeable(true);
        }
        super.onLoad();
        this.setWorkflowVisible();
        this.menuItemImportData.setAccelerator(KeyStroke.getKeyStroke("ctrl I"));
        this.menuItemExportData.setAccelerator(KeyStroke.getKeyStroke("ctrl shift E"));
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.menuItemAudit.setAccelerator(KeyStroke.getKeyStroke("ctrl U"));
        this.menuItemUnaudit.setAccelerator(KeyStroke.getKeyStroke("ctrl shift U"));
        this.menuItemPrintCard.setAccelerator(null);
        this.menuItemPrintCardPre.setAccelerator(null);
        FaClientUtils.fmtDate(this.getMainTable(), new String[]{"FaClearBill.clearDate"});
        FaClientUtils.fmtAssetAmt(this.getMainTable(), "bizCard.assetAmt");
        FaClientUtils.fmtAssetAmt(this.getMainTable(), "clearBillEntry.clrQty");
        String[] formatColumns = new String[]{"clearBillEntry.clrOriginal", "clearBillEntry.clrAddupDep", "clearBillEntry.clrDecPrep", "clearBillEntry.clrFare", "clearBillEntry.spilthMoveIn", "clearBillEntry.spilthIncome", "clearBillEntry.clrEvalValue", "clearBillEntry.price"};
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("precision"));
        int currencyScale = -1;
        ObjectUuidPK currencyPk = new ObjectUuidPK(company.getBaseCurrency().getId());
        try {
            CurrencyInfo currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)currencyPk, sic);
            currencyScale = currencyInfo.getPrecision();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        FaClientUtils.changeTableNumberFormat(this.getMainTable(), formatColumns, FaClientUtils.getDecimalFormat(currencyScale));
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnCancelAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.menuItemAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.menuItemUnaudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.actionEdit.setBindWorkFlow(false);
        this.btnTraceDown.setVisible(true);
        this.menuItemPrintCard.setEnabled(true);
        this.menuItemPrintCard.setVisible(true);
        this.menuItemPrintCardPre.setEnabled(true);
        this.menuItemPrintCardPre.setVisible(true);
        FaUtils.freezeTable((KDTable)this.tblMain, (int)2);
        this.tblMain.setColumnMoveable(true);
        this.tblMain.moveColumn(this.tblMain.getColumnIndex(this.getKeyFieldName()), 0);
        boolean isEnableUndo = FaClientUtils.isEnableUndo(null);
        if (!isEnableUndo) {
            this.actionCancelAudit.setVisible(isEnableUndo);
            this.actionCancelAudit.setEnabled(isEnableUndo);
            this.separator1.setVisible(isEnableUndo);
            this.btnCancelAudit.setAction(null);
            this.menuItemUnaudit.setAction(null);
        }
        this.getMainStatusBar().setPerTitle(FMClientHelper.getSysStatusBarTitle((CoreUI)this));
        this.actionCreateTo.setVisible(true);
        this.actionCreateTo.setEnabled(true);
        this.hideTblMainColumns();
        this.menuScanAdd.setIcon(EASResource.getIcon((String)"imgTbtn_applycondition"));
        this.btnScanAdd.setIcon(EASResource.getIcon((String)"imgTbtn_applycondition"));
        boolean isUseBarCode = this.hasBarCodeStarted();
        this.actionScanAdd.setEnabled(isUseBarCode);
        this.actionScanAdd.setVisible(isUseBarCode);
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    FaClearBillListUI.this.afterSelectLine(e);
                }
                catch (Exception ex) {
                    FaClearBillListUI.this.handleException(ex);
                }
            }
        });
    }

    protected void afterSelectLine(KDTSelectEvent e) throws Exception {
        int statusField;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length <= 0) {
            return;
        }
        IRow row = this.tblMain.getRow(selectRows[0]);
        Object obj3 = row.getCell(statusField = this.tblMain.getColumnIndex(CHECKED_STATUS)).getValue();
        if (obj3 instanceof BizEnumValueInfo) {
            BizEnumValueInfo status = (BizEnumValueInfo)obj3;
            this.selectedCheckedStauts = status.getInt();
        }
    }

    protected HashMap getFaParameter() throws Exception {
        if (this.faParameter == null) {
            this.faParameter = FaClientUtils.getFAParameter(this.getCurrentCompany().getId());
        }
        return this.faParameter;
    }

    private void hideEvalValueByIsEvalBefore() {
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            if (this.tblMain.getRow(i) == null || this.tblMain.getRow(i).getCell("isEvalBefore") == null || this.tblMain.getRow(i).getCell("isEvalBefore").getValue() == null || Boolean.valueOf(this.tblMain.getRow(i).getCell("isEvalBefore").getValue().toString()).booleanValue()) continue;
            this.tblMain.getRow(i).getCell("clearBillEntry.clrEvalValue").setValue(null);
        }
    }

    @Override
    public void actionScanAdd_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = null;
        IUIFactory factory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        uiWindow = factory.create(FaScanBarCodesEditUI.class.getName(), (Map)uiContext, null, null);
        uiWindow.show();
        uiWindow.getUIObject().getUIContext().get("keys");
        Set keys = new HashSet();
        keys = (Set)uiWindow.getUIObject().getUIContext().get("keys");
        if (keys == null) {
            return;
        }
        if (keys.size() <= 0) {
            return;
        }
        this.getUIContext().put("isUseScan", "true");
        this.getUIContext().put("SearchResult", Arrays.asList(keys.toArray()));
        super.actionAddNew_actionPerformed(e);
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(this.getCurrentCompany().getId().toString());
        CommonQueryWithResultDialog dialog = new CommonQueryWithResultDialog();
        if (this.getUIWindow() == null) {
            dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            dialog.setOwner((Component)((Object)this));
        }
        HashMap hmParam = this.gethmParamD();
        boolean isRange = "true".equals(hmParam.get("FA_040").toString());
        FACommonProcessor processor = new FACommonProcessor();
        processor.setRange(isRange);
        dialog.setProcessor((IProcessor)processor);
        dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        dialog.setEntityViewInfo(new EntityViewInfo());
        dialog.setQueryObjectPK((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.fa.manage", "FaCurCardQuery"));
        dialog.setTitle(this.getUITitle());
        dialog.setHeight(525);
        dialog.setSelectMode(10);
        dialog.setOpenType(0);
        if (dialog.show() || dialog.hasKeyValue()) {
            this.getUIContext().put("SearchResult", dialog.getSearchResult());
            this.getUIContext().put("isUseScan", "false");
            super.actionAddNew_actionPerformed(e);
        } else {
            SysUtil.abort();
        }
    }

    public HashMap gethmParamD() {
        HashMap hmParam = new HashMap();
        try {
            hmParam = FaManageUtils.getFAParameter(this.getCurrentCompany().getId());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return hmParam;
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(this.getCurrentCompany().getId().toString());
        this.checkSelected();
        if (MsgBox.isOk((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)className, (String)"IF_AUDIT")))) {
            FaClientUtils.batchOperaction((ListUI)this, this.getSelectedIdValues(), this.getBizInterface(), EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource.bill"), EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource.audit"), "passAudit", new Class[]{IObjectPK.class, BillBaseInfo.class});
            this.refresh(null);
        } else {
            SysUtil.abort();
        }
    }

    @Override
    public void actionCancelAudit_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(this.getCurrentCompany().getId().toString());
        this.checkSelected();
        if (MsgBox.isOk((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)className, (String)"IF_UNAUDIT"))) && FaClientUtils.isCanUnAudit((Component)((Object)this))) {
            FaClientUtils.batchOperaction((ListUI)this, this.getSelectedIdValues(), this.getBizInterface(), EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource.bill"), EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource.unaudit"), "unpassAudit", new Class[]{IObjectPK.class, BillBaseInfo.class});
            this.refresh(null);
        } else {
            SysUtil.abort();
        }
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        try {
            dialog.addUserPanel((KDPanel)new FaClearBillFilterUI());
            dialog.setProcessor((IProcessor)new FACommonProcessor());
            dialog.setWidth(450);
            dialog.setHeight(320);
            MetaDataAccessLoader.Description customQueryLoader = new MetaDataAccessLoader.Description(new String[]{"com.kingdee.eas.fi.fa.def.app.FaDynQueryLoader"});
            customQueryLoader.setParam("fullJoinEntityName", (Object)"bizCard");
            customQueryLoader.setParam("companyId", (Object)this.getCurrentCompany().getId().toString());
            dialog.setCustomQueryLoader(customQueryLoader);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        dialog.getCommonQueryParam().setEntityViewInfo(new EntityViewInfo());
        return dialog;
    }

    public void handUIException(Throwable exc) {
        if (exc instanceof FaCardException) {
            FaClientUtils.handleExceptionMessage((CoreUI)this, (FaCardException)((Object)exc));
        }
        super.handUIException(exc);
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(this.getCurrentCompany().getId().toString());
        if (this.getSelectedIdValues().size() > 0) {
            String id = this.getSelectedIdValues().get(0).toString();
            FaClearBillInfo info = new FaClearBillInfo();
            info.setId(BOSUuid.read((String)id));
            ((IFaClearBill)this.getBizInterface()).checkStatusValid((CoreBaseInfo)info);
        }
        super.actionEdit_actionPerformed(e);
    }

    protected boolean initDefaultFilter() {
        if (this.getUIContext().get("TRACE_UP_DOWN") != null) {
            this.setIsNeedDefaultFilter(false);
            return false;
        }
        return true;
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"FaClearBill.number", "bizCard.assetName"};
        return locateNames;
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    @Override
    public void actionPrintCard_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintCard_actionPerformed(e);
        this.invokePrint(false);
    }

    @Override
    public void actionPrintCardPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintCardPreview_actionPerformed(e);
        this.invokePrint(true);
    }

    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        HashMap idList;
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillID", null, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("sourceBillID"));
        CoreBaseCollection col = this.getBizInterface().getCollection(viewInfo);
        if (col != null && col.size() > 0) {
            idList = new HashMap();
            for (int i = 0; i < col.size(); ++i) {
                BOSObjectType bosType = BOSUuid.getBOSObjectType((String)col.get(i).get("sourceBillID").toString(), (boolean)true);
                if (bosType == null) continue;
                if (idList.get(bosType.toString()) == null) {
                    idList.put(bosType.toString(), new Vector());
                }
                ((Vector)idList.get(bosType.toString())).add(col.get(i).get("sourceBillID").toString());
            }
        } else {
            throw new BTPException(BTPException.DESTBILLNULL);
        }
        FaClientUtils.showTraceUI((CoreUI)this, idList, 0);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.getCurrentCompany().getId().toString()));
        filter.setMaskString("#0");
        return filter;
    }

    protected void prepareMutexParameter(ActionEvent arg0, MutexParameter arg1) {
        super.prepareMutexParameter(arg0, arg1);
        CompanyOrgUnitInfo company = this.getCurrentCompany();
        if (company != null) {
            arg1.setOrgUnitID(company.getId());
        }
    }

    protected boolean isShowAttachmentAction() {
        return true;
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        boolean isAllOpenAttachment = FaManageUtils.getFaParamValue(null, "FA_261", SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
        boolean isEdit = true;
        if (!isAllOpenAttachment && this.selectedCheckedStauts > 1) {
            isEdit = false;
        }
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        String boID = this.getSelectedKeyValue();
        this.checkSelected();
        if (boID == null) {
            return;
        }
        AttachmentUIContextInfo info = new AttachmentUIContextInfo();
        info.setBoID(boID);
        info.setCode("");
        info.setEdit(isEdit);
        info.setListener(this.createAttatchListener("HEAD"));
        acm.showAttachmentListUIByBoID((Object)this, info);
    }

    protected EntityViewInfo getInitDefaultSolution() {
        EntityViewInfo initDefaultEntityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        CompanyOrgUnitInfo company = this.getCurrentCompany();
        FaClientUtils.checkComp(null, company);
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
        initDefaultEntityViewInfo.setFilter(filterInfo);
        return initDefaultEntityViewInfo;
    }

    protected boolean isAllowDefaultSolutionNull() {
        return false;
    }

    private String[] getMergeColumns() {
        return new String[]{"id", "FaClearBill.clearDate", "clearMode.name", "FaClearBill.description", "FaClearBill.number", "effectedStatus", CHECKED_STATUS, "deletedStatus", "isVouchered", "handler.name", "auditor.name"};
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        super.beforeExcutQuery(ev);
        FilterInfo filterInfo = ev.getFilter();
        if (filterInfo == null || filterInfo.getFilterItems() == null || filterInfo.getFilterItems().isEmpty()) {
            return;
        }
        FilterItemCollection filterColl = filterInfo.getFilterItems();
        for (int i = 0; i < filterColl.size(); ++i) {
            FilterItemInfo filter = filterColl.get(i);
            String propertyName = filter.getPropertyName();
            if (!"company.id".equals(propertyName) || this.getBOTPViewStatus() != 1 || this.getUIContext().get("BTPCreateMode") == null) continue;
            filter.setCompareValue((Object)this.getCurrentCompany().getId().toString());
            FilterInfo checkedFilter = new FilterInfo();
            checkedFilter.getFilterItems().add(new FilterItemInfo(CHECKED_STATUS, (Object)new Integer(2), CompareType.EQUALS));
            try {
                ev.getFilter().mergeFilter(checkedFilter, "And");
                continue;
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        ev.getSorter().add(new SorterItemInfo("clearBillEntry.seq"));
        FaClientUtils.setDefaultSorterForQuery(ev);
    }

    private CompanyOrgUnitInfo getCurrentCompany() {
        if (this.currentCompany == null) {
            if (this.getBOTPViewStatus() == 1 && this.getUIContext().get("BTPCreateMode") == null) {
                EntityViewInfo botpFilter = (EntityViewInfo)this.getUIContext().get("BOTPFilter");
                FaClearBillCollection cards = new FaClearBillCollection();
                try {
                    cards = FaClearBillFactory.getRemoteInstance().getFaClearBillCollection("select company.* " + botpFilter);
                }
                catch (BOSException e) {
                    this.handleException((Exception)((Object)e));
                    SysUtil.abort();
                }
                this.currentCompany = cards.size() > 0 ? cards.get(0).getCompany() : SysContext.getSysContext().getCurrentFIUnit();
            } else if (this.getBOTPViewStatus() == 1 && this.getUIContext().get("BTPCreateMode") != null && this.getUIContext().get("BTPEDITPARAMETER") != null) {
                this.currentCompany = (CompanyOrgUnitInfo)((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("ARAPCOMPANY");
                if (this.currentCompany == null) {
                    this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
                }
            } else if (!FaClientUtils.isFromWorkflow(this.getUIContext())) {
                this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
            } else {
                String billId = "";
                if (this.getUIContext().get("IDList") instanceof String[]) {
                    String[] idlist = (String[])this.getUIContext().get("IDList");
                    billId = idlist[0];
                } else if (this.getUIContext().get("IDList") instanceof RealModeIDList) {
                    billId = ((RealModeIDList)this.getUIContext().get("IDList")).getFirstID();
                }
                try {
                    this.currentCompany = FaClearBillFactory.getRemoteInstance().getFaClearBillInfo("select company.* where id = '" + billId + "'").getCompany();
                }
                catch (Exception e) {
                    this.handleException(e);
                    SysUtil.abort();
                }
            }
        }
        return (CompanyOrgUnitInfo)this.currentCompany.clone();
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoIgnoreZero = false;
        return exec;
    }

    protected String[] getCountQueryFields() {
        return new String[]{"id"};
    }

    protected void setWorkflowVisible() throws EASBizException, BOSException {
        this.isUseWorkflow = FaManageUtils.isUseWorkflow(null, this.getCurrentCompany().getId().toString(), ((Object)((Object)this)).getClass());
        this.actionAudit.setBindWorkFlow(this.isUseWorkflow && this.isBindWorkFlow());
        this.actionCancelAudit.setBindWorkFlow(this.isUseWorkflow && this.isBindWorkFlow());
        this.actionRemove.setBindWorkFlow(this.isUseWorkflow && this.isBindWorkFlow());
        this.menuTool.setVisible(false);
        if (this.isUseWorkflow && this.isBindWorkFlow()) {
            this.menuItemAudit.setAction(null);
            this.btnAudit.setAction(null);
        }
        this.menuItemAudit.setVisible(!this.isUseWorkflow && this.isBindWorkFlow());
        this.btnAudit.setVisible(!this.isUseWorkflow && this.isBindWorkFlow());
        this.hideOrShowWorkflow(this.isUseWorkflow);
        this.hideOrShowAuditResult(this.isUseWorkflow);
    }

    @Override
    public boolean isBindWorkFlow() {
        return true;
    }

    protected void Remove() throws Exception {
        FaClientUtils.batchOperaction((ListUI)this, this.getSelectedIdValues(), this.getBizInterface(), EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource.bill"), EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource.remove"), "delete", new Class[]{IObjectPK.class});
        this.refresh(null);
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo(CHECKED_STATUS));
        for (int i = 0; i < selectRows.length; ++i) {
            FaClearBillInfo billInfo;
            ICell idCell;
            String cardID;
            int rowIndex = selectRows[i];
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null || (cardID = (String)(idCell = row.getCell("id")).getValue()) == null || cardID.trim().length() == 0 || (billInfo = FaClearBillFactory.getRemoteInstance().getFaClearBillInfo((IObjectPK)new ObjectUuidPK(cardID), sic)) == null) continue;
            if (2 != billInfo.getCheckedStatus().getValue()) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource.hasUnAudit"));
                SysUtil.abort();
            }
            String aMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource.hasGenBill");
            StringTokenizer token = new StringTokenizer(aMsg, "!");
            String head = token.nextToken();
            String currentCompanyId = this.getCurrentCompany().getId().toString();
            boolean isAllowCreateMoreReceivingBill = FaManageUtils.getFaParamValue(null, "FA_061", currentCompanyId);
            String[][] destBillMsg = new String[][]{{"48DA3A71", head + token.nextToken(), EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"3_FaClearBillListUI")}, {"FC910EF3", head + token.nextToken(), EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"4_FaClearBillListUI")}, {"FA44FD5B", head + token.nextToken(), EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"5_FaClearBillListUI")}, {"40284E81", head + token.nextToken(), EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"6_FaClearBillListUI")}};
            for (int j = 0; j < 4; ++j) {
                ArrayList arrayList = BOTRelationFactory.getRemoteInstance().getDestObjIdByDestType(billInfo.getId().toString(), destBillMsg[j][0]);
                if (arrayList == null || arrayList.size() <= 0 || "40284E81".equals(destBillMsg[j][0]) && isAllowCreateMoreReceivingBill || "48DA3A71".equals(destBillMsg[j][0]) && isAllowCreateMoreReceivingBill) continue;
                MsgBox.showWarning((String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource.canNotCreatTo"), destBillMsg[j][1]));
                SysUtil.abort();
            }
        }
        super.actionCreateTo_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.hideTblMainColumns();
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.hideTblMainColumns();
    }

    public HashMap gethmParam() {
        HashMap hmParam = new HashMap();
        try {
            hmParam = FaManageUtils.getFAParameter(this.getCurrentCompany().getId());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return hmParam;
    }

    private void invokePrint(boolean isPreView) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 500) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource.printTooMuch"));
            SysUtil.abort();
        }
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("clearMode.name"));
        selectors.add(new SelectorItemInfo("handler.name"));
        selectors.add(new SelectorItemInfo("auditor.name"));
        selectors.add(new SelectorItemInfo("company.*"));
        selectors.add(new SelectorItemInfo("company.baseCurrency.*"));
        selectors.add(new SelectorItemInfo("company.baseCurrency.id"));
        selectors.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard.assetcat.name"));
        selectors.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard.number"));
        selectors.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard.assetname"));
        selectors.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard.specs"));
        selectors.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard.measureunit.name"));
        selectors.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard.assetValue"));
        selectors.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard.accuDepr"));
        selectors.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard.decValue"));
        selectors.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard.accountDate"));
        selectors.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard.deprTTerm"));
        selectors.add(new SelectorItemInfo("clearBillEntry.curCard.assetValue"));
        selectors.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard.initEvalValue"));
        selectors.add(new SelectorItemInfo("clearBillEntry.curCard.isEvaledBefore"));
        selectors.add(new SelectorItemInfo("clearBillEntry.curCard.assetCat.calcuByEvaluate"));
        selectors.add(new SelectorItemInfo("clearBillEntry.curCard.accuDepr"));
        BillBaseCollection billCol = new BillBaseCollection();
        for (int i = 0; i < selectRows.length; ++i) {
            FaClearBillInfo clearBillInfo;
            ICell idCell;
            String clearBillID;
            int rowIndex = selectRows[i];
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null || (clearBillID = (String)(idCell = row.getCell("id")).getValue()) == null || clearBillID.trim().length() == 0 || (clearBillInfo = (FaClearBillInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(clearBillID), selectors)) == null) continue;
            BigDecimal clrAssetValue = ZERO;
            BigDecimal clrNeatValue = ZERO;
            BigDecimal clrAccuDepr = ZERO;
            int currencyScale = -1;
            currencyScale = FaClientUtils.getCurrencyScale(clearBillInfo.getCompany().getBaseCurrency().getId());
            if (clearBillInfo.getClearBillEntry() != null && clearBillInfo.getClearBillEntry().size() > 0) {
                for (int j = 0; j < clearBillInfo.getClearBillEntry().size(); ++j) {
                    BigDecimal cellClrAccuDepr;
                    BigDecimal cellAssetValue = clearBillInfo.getClearBillEntry().get(j).getClrOriginal() == null ? ZERO : clearBillInfo.getClearBillEntry().get(j).getClrOriginal();
                    BigDecimal cellInitEvalValue = clearBillInfo.getClearBillEntry().get(j).getClrEvalValue() == null ? ZERO : clearBillInfo.getClearBillEntry().get(j).getClrEvalValue();
                    boolean isEvaledBefore = clearBillInfo.getClearBillEntry().get(j).getCurCard().isIsEvaledBefore();
                    boolean calcuByEvaluate = clearBillInfo.getClearBillEntry().get(j).getCurCard().getAssetCat().isCalcuByEvaluate();
                    isEvaledBefore = isEvaledBefore && calcuByEvaluate;
                    BigDecimal bigDecimal = cellClrAccuDepr = clearBillInfo.getClearBillEntry().get(j).getClrAddupDep() == null ? ZERO : clearBillInfo.getClearBillEntry().get(j).getClrAddupDep();
                    if (isEvaledBefore) {
                        BigDecimal assetAmt = new BigDecimal(clearBillInfo.getClearBillEntry().get(j).getBizCard().getFaBakCard().getAssetAmt().toString());
                        BigDecimal quantity = new BigDecimal(clearBillInfo.getClearBillEntry().get(j).getClrQty() == null ? "0" : clearBillInfo.getClearBillEntry().get(j).getClrQty().toString());
                        cellInitEvalValue = cellInitEvalValue.multiply(quantity).divide(assetAmt, currencyScale, 4);
                    }
                    clrAssetValue = clrAssetValue.add(cellAssetValue);
                    clrNeatValue = clrNeatValue.add(isEvaledBefore ? cellInitEvalValue.subtract(cellClrAccuDepr) : cellAssetValue.subtract(cellClrAccuDepr));
                    clrAccuDepr = clrAccuDepr.add(cellClrAccuDepr);
                }
            }
            clearBillInfo.put("assetValueTotal", FaClientUtils.formatDecimal(clrAssetValue, currencyScale));
            clearBillInfo.put("neatValueTotal", FaClientUtils.formatDecimal(clrNeatValue, currencyScale));
            clearBillInfo.put("accuDeprTotal", FaClientUtils.formatDecimal(clrAccuDepr, currencyScale));
            String[] formatColumns = new String[]{"clrOriginal", "clrAddupDep", "clrDecPrep", "clrFare", "spilthMoveIn", "spilthIncome", "clrEvalValue", "price"};
            int quantityScale = Integer.valueOf(this.faParameter.get("FA_008") == null ? "0" : (String)this.faParameter.get("FA_008"));
            FaClearBillEntryCollection faClearBillEntryCollection = clearBillInfo.getClearBillEntry();
            for (int j = 0; j < faClearBillEntryCollection.size(); ++j) {
                FaBakCardInfo faBakCardInfo;
                FaClearBillEntryInfo faBillEntryInfo = faClearBillEntryCollection.get(j);
                if (faBillEntryInfo == null) continue;
                this.dealNumricalPrint(faBillEntryInfo, formatColumns, currencyScale);
                this.dealNumricalPrint(faBillEntryInfo, new String[]{"clrQty"}, quantityScale);
                if (faBillEntryInfo.getBizCard() == null || (faBakCardInfo = faBillEntryInfo.getBizCard().getFaBakCard()) == null || faBakCardInfo.getAssetAmt() == null) continue;
                faBakCardInfo.setAssetAmt(faBakCardInfo.getAssetAmt().setScale(quantityScale, 4));
            }
            billCol.add((BillBaseInfo)clearBillInfo);
        }
        KDNoteHelper appHlp = new KDNoteHelper();
        BOSQueryDelegate data = FaPrintHelper.getPrintManagerForFaClearBillListUI((IObjectCollection)billCol);
        if (isPreView) {
            appHlp.printPreview("/FI/FA/FaClearBill", (Object)data, (Component)((Object)this));
        } else {
            appHlp.print("/FI/FA/FaClearBill", (Object)data, (Component)((Object)this));
        }
    }

    private void calcTotalAmount() {
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }

    protected void initDapButtons() throws Exception {
        if (this.dapKDTSelectListener == null) {
            this.dapKDTSelectListener = new KDTSelectListener(){

                public void tableSelectChanged(KDTSelectEvent e) {
                    try {
                        ArrayList idList = FaClearBillListUI.this.getSelectedIdValues();
                        if (idList.size() > 1) {
                            FaClearBillListUI.this.actionVoucher.setEnabled(true);
                            FaClearBillListUI.this.actionDelVoucher.setEnabled(true);
                        } else if (idList.size() == 0) {
                            FaClearBillListUI.this.actionVoucher.setEnabled(false);
                            FaClearBillListUI.this.actionDelVoucher.setEnabled(false);
                        } else {
                            int rowIndex = FaClearBillListUI.this.tblMain.getSelectManager().get().getTop();
                            String isVouchered = FaClearBillListUI.this.tblMain.getRow(rowIndex).getCell("isVouchered").getValue().toString();
                            if (isVouchered.equals("true")) {
                                FaClearBillListUI.this.actionVoucher.setEnabled(false);
                                FaClearBillListUI.this.actionDelVoucher.setEnabled(true);
                            } else {
                                FaClearBillListUI.this.actionVoucher.setEnabled(true);
                                FaClearBillListUI.this.actionDelVoucher.setEnabled(false);
                            }
                        }
                    }
                    catch (Exception exc) {
                        FaClearBillListUI.this.handUIException(exc);
                    }
                }
            };
            this.tblMain.addKDTSelectListener(this.dapKDTSelectListener);
        }
    }

    public void dealNumricalPrint(BillEntryBaseInfo billEntryBaseInfo, String[] param, int scale) {
        try {
            for (int i = 0; i < param.length; ++i) {
                if (billEntryBaseInfo.get(param[i]) == null) continue;
                BigDecimal bigDecimal = (BigDecimal)billEntryBaseInfo.get(param[i]);
                billEntryBaseInfo.setBigDecimal(param[i], bigDecimal.setScale(scale, 4));
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(this.getCurrentCompany().getId().toString());
        if (this.getSelectedIdValues().size() > 0) {
            int selectIdValuesSize = this.getSelectedIdValues().size();
            for (int i = 0; i < selectIdValuesSize; ++i) {
                try {
                    String pk = this.getSelectedIdValues().get(i).toString();
                    this.setOprtState("REMOVE");
                    this.pubFireVOChangeListener(pk);
                    continue;
                }
                catch (Throwable ex) {
                    this.handUIException(ex);
                    this.abort();
                }
            }
        }
        super.actionRemove_actionPerformed(e);
    }

    protected String[] getQueryShowField() {
        super.getQueryShowField();
        return new String[]{"FaClearBill.number", "FaClearBill.clearDate", "clearMode.name", "FaClearBill.description", "bizCard.number", "bizCard.assetName", "assetCat.name", "clearBillEntry.clrQty", "clearBillEntry.clrOriginal", "clearBillEntry.clrAddupDep", "clearBillEntry.clrDecPrep", "clearBillEntry.clrFare", "clearBillEntry.price", "clearBillEntry.spilthIncome", "handler.name", "isVouchered", "effectedStatus", CHECKED_STATUS};
    }

    protected String[] getQueryHideField() {
        return new String[]{"isVouchered", "effectedStatus", CHECKED_STATUS};
    }

    protected boolean isLazyMode() {
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = (RequestContext)clientHanlder.getRequestContext();
            request.put("COMPANY", (Object)this.getCurrentCompany());
            request.put("COMPANY_ID", (Object)this.currentCompany.getId().toString());
            request.put("USERINFO", (Object)SysContext.getSysContext().getCurrentUserInfo());
        }
        return clientHanlder;
    }

    protected void hideTblMainColumns() throws Exception {
        this.hideEvalValueByIsEvalBefore();
    }

    protected boolean hasGroupNumberStarted() throws Exception {
        Object isUseGroupNumber = this.getFaParameter().get("FA_030");
        return isUseGroupNumber != null && Boolean.valueOf(isUseGroupNumber.toString()) != false;
    }

    protected boolean hasBarCodeStarted() throws Exception {
        Object isUseBarCode = this.getFaParameter().get("FA_043");
        return isUseBarCode != null && Boolean.valueOf(isUseBarCode.toString()) != false;
    }

    public void beforeTransform(IObjectCollection srcObjCols, String destBillBosType) {
        if (this.getUIContext().get("BTPCreateMode") != null && new VoucherInfo().getBOSType().toString().equals(destBillBosType)) {
            Map faParam = null;
            try {
                FaClientUtils.checkForGenVoucher();
                faParam = FaManageUtils.getFAParameter(null, new String[]{"FA_048"}, this.getCurrentCompany().getId().toString());
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
            boolean isSplitOrCombineNoVourcher = false;
            if (faParam != null && faParam.get("FA_048") != null) {
                isSplitOrCombineNoVourcher = "true".equals(faParam.get("FA_048").toString());
            }
            for (FaClearBillInfo faClearBillInfo : srcObjCols) {
                String strMsg;
                if (faClearBillInfo.getCheckedStatus().getValue() == 1) {
                    strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource.billUnauditForbidGoFurther");
                    MsgBox.showInfo((Component)((Object)this), (String)strMsg);
                    SysUtil.abort();
                }
                if (faClearBillInfo.getBillType() != FaBillOriginEnum.FROM_SPLIT && faClearBillInfo.getBillType() != FaBillOriginEnum.FROM_COMBIN || !isSplitOrCombineNoVourcher) continue;
                strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource.needNotVourcher_clearCard");
                MsgBox.showInfo((Component)((Object)this), (String)strMsg);
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionViewImage_actionPerformed(ActionEvent e) throws Exception {
        ArrayList ids = this.getSelectedIdValues();
        HashSet idset = new HashSet(ids);
        if (ids != null && ids.size() > 0) {
            try {
                String navUrl = FaCardUtil.getCardImageUrl(idset, SysContext.getSysContext().getCurrentUserInfo());
                if (navUrl != null) {
                    VersionUtil.gotoSite((String)navUrl, (boolean)true);
                }
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
    }

    @Override
    public void actionBatchSubmit_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(this.getCurrentCompany().getId().toString());
        this.checkSelected();
        this.checkObjectExists();
        ArrayList ids = this.getSelectedIdValues();
        ArrayList<String> idsCopy = new ArrayList<String>();
        PeriodInfo currPeriod = FaClientUtils.getCurrentPeriod(this.currentCompany.getId().toString());
        HashMap sendMap = new HashMap();
        sendMap.put("ids", ids);
        sendMap.put("currPeriod", currPeriod);
        sendMap.put("currentCompany", this.currentCompany);
        HashSet<String> idset = new HashSet<String>();
        for (String id : ids) {
            idset.add(id);
            idsCopy.add(id);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", idset, CompareType.INCLUDE));
        view.put("selector", (Object)this.getClearBillSelectors(new SelectorItemCollection()));
        FaClearBillCollection cards = FaClearBillFactory.getRemoteInstance().getFaClearBillCollection(view);
        int m = cards.size();
        for (int n = 0; n < m; ++n) {
            FaClearBillInfo clearBillInfo = cards.get(n);
            if (clearBillInfo.getClearBillEntry() == null || clearBillInfo.getClearBillEntry().size() <= 0) continue;
            for (int i = 0; i < clearBillInfo.getClearBillEntry().size(); ++i) {
                if (clearBillInfo.getClearBillEntry().get(i) == null || clearBillInfo.getClearBillEntry().get(i).getCurCard() == null) continue;
                clearBillInfo.getClearBillEntry().get(i).put("faCurCard", clearBillInfo.getClearBillEntry().get(i).getCurCard().getId().toString());
            }
        }
        final HashMap<ObjectUuidPK, FaClearBillInfo> keyValue = new HashMap<ObjectUuidPK, FaClearBillInfo>();
        ids.clear();
        for (int i = 0; i < cards.size(); ++i) {
            keyValue.put(new ObjectUuidPK(cards.get(i).getId()), cards.get(i));
            ids.add(cards.get(i).getId().toString());
        }
        ArrayList<String> ids2 = new ArrayList<String>();
        for (String id : idsCopy) {
            if (!ids.contains(id) || ids2.contains(id)) continue;
            ids2.add(id);
        }
        final IFaClearBill iclear = FaClearBillFactory.getRemoteInstance();
        ProcessUI.LongTimeProcess doit = new ProcessUI.LongTimeProcess(){

            @Override
            public void doit(IObjectPK pk) throws Exception {
                FaClearBillInfo card = (FaClearBillInfo)keyValue.get(pk);
                iclear.submit((CoreBaseInfo)card);
            }

            @Override
            public boolean doit(List pkList) throws Exception {
                return false;
            }

            @Override
            public boolean notShowCount() {
                return false;
            }
        };
        FaClientUtils.doBatchProcess((CoreUI)this, ids2, keyValue, doit, EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"120_FaHasNewBizIsRef"), EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"19_FaCurCardInitListUI"));
        this.refreshList();
    }

    private SelectorItemCollection getClearBillSelectors(SelectorItemCollection curCardSelectors) {
        SelectorItemCollection sic = new SelectorItemCollection();
        for (int i = 0; i < curCardSelectors.size(); ++i) {
            sic.add(curCardSelectors.get(i));
        }
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("clearBillEntry.*"));
        sic.add(new SelectorItemInfo("clearBillEntry.bizCard.id"));
        sic.add(new SelectorItemInfo("clearBillEntry.curCard.id"));
        sic.add(new SelectorItemInfo("clearBillEntry.curCard.accuDepr"));
        sic.add(new SelectorItemInfo("clearBillEntry.curCard.hasNew"));
        sic.add(new SelectorItemInfo("clearBillEntry.curCard.assetAmt"));
        sic.add(new SelectorItemInfo("clearBillEntry.curCard.deprTTerm"));
        sic.add(new SelectorItemInfo("clearBillEntry.curCard.evalDeprTTerm"));
        sic.add(new SelectorItemInfo("clearBillEntry.curCard.fiVouchered"));
        sic.add(new SelectorItemInfo("clearBillEntry.bizCard.number"));
        sic.add(new SelectorItemInfo("clearBillEntry.bizCard.assetCat.id"));
        sic.add(new SelectorItemInfo("clearBillEntry.bizCard.assetCat.prePureRate"));
        sic.add(new SelectorItemInfo("clearBillEntry.bizCard.company.id"));
        sic.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard"));
        sic.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard.assetAmt"));
        sic.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard.lastEvalValue"));
        sic.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard.initEvalValue"));
        return sic;
    }
}

