/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.account.client.AccountClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.FaBasedataTypeEnum;
import com.kingdee.eas.fi.fa.basedata.FaCatFactory;
import com.kingdee.eas.fi.fa.basedata.FaCatInfo;
import com.kingdee.eas.fi.fa.basedata.IFaCat;
import com.kingdee.eas.fi.fa.basedata.client.FaCatPromptBox;
import com.kingdee.eas.fi.fa.manage.FaContrastCaclFactory;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaContrastFilterUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FaContrastFilterUI
extends AbstractFaContrastFilterUI {
    private static final long serialVersionUID = -5213551836703356425L;
    public static final String AccountMap_Key = "AccountMap";
    public static final String SelectedPeriod_Key = "SelectedPeriod";
    public static final String IsIncludeUnposted_Key = "isIncludeUnposted";
    public static final String IsDefaultSolution_Key = "IsDefaultSolution";
    public static final String IsUseEvaValue_Key = "isUseEvaValue";
    public static final String IsUseCatNumber_Key = "isUseCatNumber";
    public static final String IsUseCardAcct_Key = "isUseCardAcct";
    public static final String CatMap_Key = "CatMap";
    private KDBizPromptBox kDBizPromptBoxAccount = new KDBizPromptBox();
    private PeriodInfo currPeriod = null;
    private Map zipData = null;

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.assetsPanel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 520, 236));
        this.deprePanel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 520, 236));
        this.decPanel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 520, 236));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAddLine_Asset.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnAddLine_Dec.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnAddLine_Depre.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelLine_Asset.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnDelLine_Dec.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnDelLine_Depre.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.initAccountF7();
        this.kDContainer1.setOpaque(false);
        this.kDContainer1.setTitleStyle(2);
        this.kDTabbedPane1.setOpaque(false);
        ArrayList<CompanyOrgUnitInfo> params = new ArrayList<CompanyOrgUnitInfo>();
        params.add(SysContext.getSysContext().getCurrentFIUnit());
        this.zipData = FaContrastCaclFactory.getRemoteInstance().getZipDataForRPC(params);
        PeriodInfo startPeriod = (PeriodInfo)this.zipData.get("startPeriod");
        this.currPeriod = (PeriodInfo)this.zipData.get("currPeriod");
        this.initPeriodYear(startPeriod, this.currPeriod);
        this.fillPeriodComponent(this.currPeriod);
        this.changeContrastType(false);
        this.chbDefault.setEnabled(false);
        this.chbUseCat.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaContrastFilterUI.this.changeContrastType(FaContrastFilterUI.this.chbUseCat.getSelected() == 32);
            }
        });
        this.chbUseCardAcct.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (FaContrastFilterUI.this.chbUseCardAcct.isSelected() && FaContrastFilterUI.this.chbUseCat.isSelected()) {
                    FaContrastFilterUI.this.chbUseCat.setSelected(false);
                }
            }
        });
    }

    private void initPeriodYear(final PeriodInfo startPeriod, final PeriodInfo curPeriod) {
        SpinnerNumberModel yearModel = (SpinnerNumberModel)this.spPeriodYear.getModel();
        yearModel.setMinimum(new Integer(startPeriod.getPeriodYear()));
        yearModel.setMaximum(new Integer(curPeriod.getPeriodYear()));
        this.spPeriodYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaContrastFilterUI.this.changePeriodYear(startPeriod, curPeriod);
                try {
                    FaContrastFilterUI.this.setAccountF7Selector();
                }
                catch (Exception ex) {
                    FaContrastFilterUI.this.handUIException(ex);
                }
            }
        });
        this.spPeriodNumber.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    FaContrastFilterUI.this.setAccountF7Selector();
                }
                catch (Exception ex) {
                    FaContrastFilterUI.this.handUIException(ex);
                }
            }
        });
    }

    private void changePeriodYear(PeriodInfo startPeriodInfo, PeriodInfo curPeriodInfo) {
        if (startPeriodInfo == null || curPeriodInfo == null) {
            return;
        }
        Integer year = (Integer)this.spPeriodYear.getValue();
        SpinnerNumberModel numberModel = (SpinnerNumberModel)this.spPeriodNumber.getModel();
        try {
            int maxPeriod = (Integer)this.zipData.get("maxNumber" + year);
            int minPeriod = (Integer)this.zipData.get("minNumber" + year);
            numberModel.setMaximum(new Integer(maxPeriod));
            numberModel.setMinimum(new Integer(minPeriod));
            if (startPeriodInfo.getPeriodYear() == year.intValue()) {
                numberModel.setMinimum(new Integer(startPeriodInfo.getPeriodNumber()));
            }
            if (startPeriodInfo.getPeriodYear() > year) {
                this.spPeriodYear.setValue((Object)new Integer(startPeriodInfo.getPeriodYear()));
            }
            if (year.intValue() == curPeriodInfo.getPeriodYear()) {
                numberModel.setMaximum(new Integer(curPeriodInfo.getPeriodNumber()));
            }
            this.spPeriodNumber.setValue(numberModel.getMinimum());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void setAccountF7Selector() throws EASBizException, BOSException {
        String cuID = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        AccountClientUtils.checkCompanyAccountTable(null, (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit());
        String acctTableID = SysContext.getSysContext().getCurrentFIUnit().getAccountTable().getId().toString();
        acctTableID = AccountTools.getCurrentAcctTable((String)cuID, (String)acctTableID, (int)this.spPeriodYear.getIntegerVlaue(), (int)this.spPeriodNumber.getIntegerVlaue());
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("name"));
        selectors.add(new SelectorItemInfo("number"));
        AccountTableInfo acctTable = AccountTableFactory.getRemoteInstance().getAccountTableInfo((IObjectPK)new ObjectUuidPK(acctTableID), selectors);
        this.kDBizPromptBoxAccount.setSelector((KDPromptSelector)FaClientUtils.getAccountPromptBox((IUIObject)this, acctTable));
    }

    private void initAccountF7() {
        this.assetTable.checkParsed();
        this.decTable.checkParsed();
        this.depreTable.checkParsed();
        this.kDBizPromptBoxAccount.setQueryInfo("com.kingdee.eas.basedata.master.account.app.AccountViewQuery");
        this.kDBizPromptBoxAccount.setDisplayFormat("$number$--$name$");
        this.kDBizPromptBoxAccount.setEditFormat("$number$");
        this.kDBizPromptBoxAccount.setCommitFormat("$number$");
        this.kDBizPromptBoxAccount.setEditable(true);
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo companyAccountFilterItemInfo = new FilterItemInfo("companyID.id", (Object)aCompanyOrgUnitInfo.getId().toString());
        AccountClientUtils.checkCompanyAccountTable(null, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
        FilterItemInfo companyAccountFilterItemInfo2 = new FilterItemInfo("accountTableID.id", (Object)aCompanyOrgUnitInfo.getAccountTable().getId().toString());
        filter.getFilterItems().add(companyAccountFilterItemInfo);
        filter.getFilterItems().add(companyAccountFilterItemInfo2);
        viewInfo.setFilter(filter);
        this.kDBizPromptBoxAccount.setEntityViewInfo(viewInfo);
        this.assetTable.getColumn("account").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.kDBizPromptBoxAccount));
        this.decTable.getColumn("account").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.kDBizPromptBoxAccount));
        this.depreTable.getColumn("account").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.kDBizPromptBoxAccount));
        KDBizPromptBox bizPromptFaCat = new KDBizPromptBox();
        bizPromptFaCat.setQueryInfo("com.kingdee.eas.fi.fa.basedata.FaCatQuery");
        bizPromptFaCat.setCommitFormat("$number$");
        bizPromptFaCat.setEditFormat("$number$--$name$");
        bizPromptFaCat.setDisplayFormat("$number$--$name$");
        bizPromptFaCat.setEditable(true);
        bizPromptFaCat.setEntityViewInfo(FaClientUtils.getOrgSplitViewInfo(FaBasedataTypeEnum.CAT, false));
        bizPromptFaCat.setEnabledMultiSelection(true);
        FaCatPromptBox aFaCatPromptBox = new FaCatPromptBox((CoreUIObject)this, true, false);
        bizPromptFaCat.setSelector((KDPromptSelector)aFaCatPromptBox);
        ObjectValueRender render = new ObjectValueRender();
        render.setFormat(new IDataFormat(){

            public String format(Object object) {
                StringBuffer ret = new StringBuffer();
                if (object.getClass().isArray()) {
                    Object[] os = (Object[])object;
                    for (int i = 0; i < os.length; ++i) {
                        if (i > 0) {
                            ret.append("; ");
                        }
                        ret.append(((FaCatInfo)os[i]).toString());
                    }
                }
                return ret.toString();
            }
        });
        this.assetTable.getColumn("cat").setRenderer((IBasicRender)render);
        this.decTable.getColumn("cat").setRenderer((IBasicRender)render);
        this.depreTable.getColumn("cat").setRenderer((IBasicRender)render);
        this.assetTable.getColumn("cat").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPromptFaCat));
        this.decTable.getColumn("cat").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPromptFaCat));
        this.depreTable.getColumn("cat").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPromptFaCat));
    }

    public FilterInfo getFilterInfo() {
        int catCount;
        Object[] cat;
        int i;
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("checkedStatus", (Object)new Integer(2)));
        CustomerParams assetAccount = new CustomerParams();
        CustomerParams decAccount = new CustomerParams();
        CustomerParams depreAccount = new CustomerParams();
        CustomerParams catMap = new CustomerParams();
        for (i = 0; i < this.assetTable.getRowCount(); ++i) {
            if (this.assetTable.getRow(i).getCell("account").getValue() != null) {
                assetAccount.addCustomerParam("account" + i, ((AccountViewInfo)this.assetTable.getRow(i).getCell("account").getValue()).getId().toString());
            }
            if (this.assetTable.getRow(i).getCell("cat").getValue() == null) continue;
            CustomerParams assetCat = new CustomerParams();
            cat = (Object[])this.assetTable.getRow(i).getCell("cat").getValue();
            for (catCount = 0; catCount < cat.length; ++catCount) {
                assetCat.addCustomerParam("cat" + catCount, ((FaCatInfo)cat[catCount]).getId().toString());
            }
            if (assetAccount.getValues().size() <= i || assetAccount.getCustomerParam("account" + i) == null) continue;
            catMap.putMe("ASSET_" + assetAccount.getCustomerParam("account" + i).toString(), assetCat);
        }
        for (i = 0; i < this.decTable.getRowCount(); ++i) {
            if (this.decTable.getRow(i).getCell("account").getValue() != null) {
                decAccount.addCustomerParam("account" + i, ((AccountViewInfo)this.decTable.getRow(i).getCell("account").getValue()).getId().toString());
            }
            if (this.decTable.getRow(i).getCell("cat").getValue() == null) continue;
            CustomerParams decCat = new CustomerParams();
            cat = (Object[])this.decTable.getRow(i).getCell("cat").getValue();
            for (catCount = 0; catCount < cat.length; ++catCount) {
                decCat.addCustomerParam("cat" + catCount, ((FaCatInfo)cat[catCount]).getId().toString());
            }
            if (decAccount.getValues().size() <= i || decAccount.getCustomerParam("account" + i) == null) continue;
            catMap.putMe("DECVALUE_" + decAccount.getCustomerParam("account" + i).toString(), decCat);
        }
        for (i = 0; i < this.depreTable.getRowCount(); ++i) {
            if (this.depreTable.getRow(i).getCell("account").getValue() != null) {
                depreAccount.addCustomerParam("account" + i, ((AccountViewInfo)this.depreTable.getRow(i).getCell("account").getValue()).getId().toString());
            }
            if (this.depreTable.getRow(i).getCell("cat").getValue() == null) continue;
            CustomerParams depreCat = new CustomerParams();
            cat = (Object[])this.depreTable.getRow(i).getCell("cat").getValue();
            for (catCount = 0; catCount < cat.length; ++catCount) {
                depreCat.addCustomerParam("cat" + catCount, ((FaCatInfo)cat[catCount]).getId().toString());
            }
            if (depreAccount.getValues().size() <= i || depreAccount.getCustomerParam("account" + i) == null) continue;
            catMap.putMe("DEPRE_" + depreAccount.getCustomerParam("account" + i).toString(), depreCat);
        }
        CustomerParams accountMap = new CustomerParams();
        accountMap.putMe("ASSET", assetAccount);
        accountMap.putMe("DECVALUE", decAccount);
        accountMap.putMe("DEPRE", depreAccount);
        if (this.chbUseCat.getSelected() != 32) {
            catMap.getCustomerParamsHashMap().clear();
        }
        filter.put(AccountMap_Key, (Object)accountMap);
        filter.put(CatMap_Key, (Object)catMap);
        filter.put(IsIncludeUnposted_Key, (Object)(this.chbHasNotVoucher.getSelected() == 32 ? 1 : 0));
        filter.put(IsDefaultSolution_Key, (Object)(this.chbDefault.getSelected() == 32 ? 1 : 0));
        filter.put(IsUseEvaValue_Key, (Object)(this.chbUseEvaValue.getSelected() == 32 ? 1 : 0));
        filter.put(IsUseCatNumber_Key, (Object)(this.chbUseCat.getSelected() == 32 ? 1 : 0));
        filter.put(IsUseCardAcct_Key, (Object)(this.chbUseCardAcct.getSelected() == 32 ? 1 : 0));
        PeriodInfo selectedPeriod = new PeriodInfo();
        selectedPeriod.setPeriodYear(((Integer)this.spPeriodYear.getValue()).intValue());
        selectedPeriod.setPeriodNumber(((Integer)this.spPeriodNumber.getValue()).intValue());
        filter.put(SelectedPeriod_Key, (Object)selectedPeriod);
        CustomerParams serializObj = new CustomerParams();
        serializObj.putMe(AccountMap_Key, accountMap);
        serializObj.putMe(CatMap_Key, catMap);
        serializObj.putBoolean(IsIncludeUnposted_Key, this.chbHasNotVoucher.isSelected());
        serializObj.putBoolean(IsDefaultSolution_Key, this.chbDefault.isSelected());
        serializObj.putBoolean(IsUseEvaValue_Key, this.chbUseEvaValue.isSelected());
        serializObj.putBoolean(IsUseCatNumber_Key, this.chbUseCat.isSelected());
        serializObj.putBoolean(IsUseCardAcct_Key, this.chbUseCardAcct.isSelected());
        this.setCustomerParams(serializObj);
        return filter;
    }

    private boolean hasChildren(Object[] catArray) {
        if (catArray == null) {
            return false;
        }
        for (int i = 0; i < catArray.length; ++i) {
            FaCatInfo catInfo1 = (FaCatInfo)catArray[i];
            for (int j = 0; j < catArray.length; ++j) {
                if (j == i) continue;
                FaCatInfo catInfo2 = (FaCatInfo)catArray[j];
                if (catInfo1.getLongNumber().indexOf(catInfo2.getLongNumber() + "!") <= -1) continue;
                return true;
            }
        }
        return false;
    }

    public void loadData(EntityViewInfo viewInfo) {
        CustomerParams loadInfo = this.getCustomerParams();
        if (loadInfo != null) {
            this.fillTable(loadInfo);
            boolean isIncludeUnposted = loadInfo.getBoolean(IsIncludeUnposted_Key);
            this.chbHasNotVoucher.setSelected(isIncludeUnposted);
            boolean isDefaultSolution = loadInfo.getBoolean(IsDefaultSolution_Key);
            this.chbDefault.setSelected(isDefaultSolution);
            boolean isUseEvaValue = loadInfo.getBoolean(IsUseEvaValue_Key);
            this.chbUseEvaValue.setSelected(isUseEvaValue);
            boolean isUseCat = loadInfo.getBoolean(IsUseCatNumber_Key);
            this.chbUseCat.setSelected(isUseCat);
            boolean isUseCardAcct = loadInfo.getBoolean(IsUseCardAcct_Key);
            this.chbUseCardAcct.setSelected(isUseCardAcct);
            this.changeContrastType(isUseCat);
        }
    }

    private void fillTable(CustomerParams loadInfo) {
        CustomerParams accountMap = loadInfo.getMe(AccountMap_Key);
        CustomerParams catMap = loadInfo.getMe(CatMap_Key);
        if (accountMap == null && catMap == null) {
            return;
        }
        if (accountMap.getMe("ASSET") == null || accountMap.getMe("ASSET").getCustomerParamsHashMap() == null || accountMap.getMe("DECVALUE") == null || accountMap.getMe("DECVALUE").getCustomerParamsHashMap() == null || accountMap.getMe("DEPRE") == null || accountMap.getMe("DEPRE").getCustomerParamsHashMap() == null) {
            return;
        }
        TreeSet assetKeySet = new TreeSet(accountMap.getMe("ASSET").getCustomerParamsHashMap().keySet());
        TreeSet decvalueKeySet = new TreeSet(accountMap.getMe("DECVALUE").getCustomerParamsHashMap().keySet());
        TreeSet depreKeySet = new TreeSet(accountMap.getMe("DEPRE").getCustomerParamsHashMap().keySet());
        IRow row = null;
        this.assetTable.removeRows();
        this.decTable.removeRows();
        this.depreTable.removeRows();
        try {
            Iterator tmpItem;
            int i;
            String value;
            int i2;
            IAccountView iAccount = AccountViewFactory.getRemoteInstance();
            HashMap<String, AccountViewInfo> accountInfoMap = new HashMap<String, AccountViewInfo>();
            HashSet<String> accountIdSet = new HashSet<String>();
            for (i2 = 0; i2 < assetKeySet.size(); ++i2) {
                value = (String)accountMap.getMe("ASSET").getCustomerParamsHashMap().get(assetKeySet.toArray()[i2]);
                accountIdSet.add(value);
            }
            for (i2 = 0; i2 < decvalueKeySet.size(); ++i2) {
                value = (String)accountMap.getMe("DECVALUE").getCustomerParamsHashMap().get(decvalueKeySet.toArray()[i2]);
                accountIdSet.add(value);
            }
            for (i2 = 0; i2 < depreKeySet.size(); ++i2) {
                value = (String)accountMap.getMe("DEPRE").getCustomerParamsHashMap().get(depreKeySet.toArray()[i2]);
                accountIdSet.add(value);
            }
            if (accountIdSet.size() > 0) {
                EntityViewInfo v = new EntityViewInfo();
                FilterInfo f = new FilterInfo();
                v.setFilter(f);
                f.getFilterItems().add(new FilterItemInfo("id", accountIdSet, CompareType.INCLUDE));
                AccountViewCollection accounts = iAccount.getAccountViewCollection(v);
                for (int i3 = 0; i3 < accounts.size(); ++i3) {
                    accountInfoMap.put(accounts.get(i3).getId().toString(), accounts.get(i3));
                }
            }
            IFaCat faCat = FaCatFactory.getRemoteInstance();
            String ids = "";
            for (i = 0; i < assetKeySet.size(); ++i) {
                row = this.assetTable.addRow();
                String value2 = (String)accountMap.getMe("ASSET").getCustomerParamsHashMap().get(assetKeySet.toArray()[i]);
                row.getCell("account").setValue(accountInfoMap.get(value2));
                if (catMap == null || catMap.getMe("ASSET_" + value2) == null) continue;
                Collection assetCat = catMap.getMe("ASSET_" + value2).getValues();
                ids = "";
                tmpItem = assetCat.iterator();
                while (tmpItem.hasNext()) {
                    ids = ids + ",'" + tmpItem.next().toString() + "'";
                }
                row.getCell("cat").setValue((Object)faCat.getCollection("select id,name,number,longnumber where id in (" + ids.substring(1) + ")").toArray());
            }
            for (i = 0; i < decvalueKeySet.size(); ++i) {
                row = this.decTable.addRow();
                String value3 = (String)accountMap.getMe("DECVALUE").getCustomerParamsHashMap().get(decvalueKeySet.toArray()[i]);
                row.getCell("account").setValue(accountInfoMap.get(value3));
                if (catMap == null || catMap.getMe("DECVALUE_" + value3) == null) continue;
                Collection decCat = catMap.getMe("DECVALUE_" + value3).getValues();
                ids = "";
                tmpItem = decCat.iterator();
                while (tmpItem.hasNext()) {
                    ids = ids + ",'" + tmpItem.next().toString() + "'";
                }
                row.getCell("cat").setValue((Object)faCat.getCollection("select id,name,number,longnumber where id in (" + ids.substring(1) + ")").toArray());
            }
            for (i = 0; i < depreKeySet.size(); ++i) {
                row = this.depreTable.addRow();
                String value4 = (String)accountMap.getMe("DEPRE").getCustomerParamsHashMap().get(depreKeySet.toArray()[i]);
                row.getCell("account").setValue(accountInfoMap.get(value4));
                if (catMap == null || catMap.getMe("DEPRE_" + value4) == null) continue;
                Collection depreCat = catMap.getMe("DEPRE_" + value4).getValues();
                ids = "";
                tmpItem = depreCat.iterator();
                while (tmpItem.hasNext()) {
                    ids = ids + ",'" + tmpItem.next().toString() + "'";
                }
                row.getCell("cat").setValue((Object)faCat.getCollection("select id,name,number,longnumber where id in (" + ids.substring(1) + ")").toArray());
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void fillPeriodComponent(PeriodInfo periodInfo) {
        if (periodInfo != null) {
            this.spPeriodYear.setValue((Object)new Integer(periodInfo.getPeriodYear()));
            this.spPeriodNumber.setValue((Object)new Integer(periodInfo.getPeriodNumber()));
        }
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
        if (((AbstractButton)e.getSource()).getName().endsWith("_Asset")) {
            this.assetTable.addRow();
        }
        if (((AbstractButton)e.getSource()).getName().endsWith("_Dec")) {
            this.decTable.addRow();
        }
        if (((AbstractButton)e.getSource()).getName().endsWith("_Depre")) {
            this.depreTable.addRow();
        }
    }

    @Override
    public void actionDelLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelLine_actionPerformed(e);
        if (((AbstractButton)e.getSource()).getName().endsWith("_Asset")) {
            this.removeLine(this.assetTable);
        }
        if (((AbstractButton)e.getSource()).getName().endsWith("_Dec")) {
            this.removeLine(this.decTable);
        }
        if (((AbstractButton)e.getSource()).getName().endsWith("_Depre")) {
            this.removeLine(this.depreTable);
        }
    }

    protected void removeLine(KDTable table) {
        if (table.getSelectManager().size() == 0 || this.isTableColumnSelected(table)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        int top = table.getSelectManager().get().getTop();
        if (table.getRow(top) == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        table.removeRow(top);
    }

    private boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    public boolean verify() {
        Object[] cat;
        int i;
        AccountViewInfo accountI = null;
        AccountViewInfo account0 = null;
        boolean hasChildren = false;
        boolean useCat = this.chbUseCat.getSelected() == 32;
        String strAccount = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"strAccount");
        String notFitPeriod = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"notFitPeriod");
        String cuID = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        AccountClientUtils.checkCompanyAccountTable(null, (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit());
        String acctTableID = SysContext.getSysContext().getCurrentFIUnit().getAccountTable().getId().toString();
        try {
            acctTableID = AccountTools.getCurrentAcctTable((String)cuID, (String)acctTableID, (int)this.spPeriodYear.getIntegerVlaue(), (int)this.spPeriodNumber.getIntegerVlaue());
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        StringBuffer errInfo = new StringBuffer();
        for (i = 0; i < this.assetTable.getRowCount(); ++i) {
            if (this.assetTable.getRow(i).getCell("account").getValue() != null) {
                accountI = (AccountViewInfo)this.assetTable.getRow(i).getCell("account").getValue();
                account0 = (AccountViewInfo)this.assetTable.getRow(0).getCell("account").getValue();
                if (!accountI.getAccountTableID().getId().toString().equals(acctTableID)) {
                    errInfo.append("\uff1b").append(strAccount).append(accountI.getNumber());
                    errInfo.append("(").append(accountI.getName()).append(")").append(notFitPeriod);
                }
                if (accountI.getDC() != account0.getDC()) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"CommonQueryDialogWithoutToolBar_AssetAccountPropertyError"));
                    return false;
                }
            } else if (useCat) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"FaContrastUI_UseCatErr_accountNull"));
                return false;
            }
            cat = (Object[])this.assetTable.getRow(i).getCell("cat").getValue();
            hasChildren = hasChildren || this.hasChildren(cat);
        }
        for (i = 0; i < this.decTable.getRowCount(); ++i) {
            if (this.decTable.getRow(i).getCell("account").getValue() != null) {
                accountI = (AccountViewInfo)this.decTable.getRow(i).getCell("account").getValue();
                account0 = (AccountViewInfo)this.decTable.getRow(0).getCell("account").getValue();
                if (!accountI.getAccountTableID().getId().toString().equals(acctTableID)) {
                    errInfo.append("\uff1b").append(strAccount).append(accountI.getNumber());
                    errInfo.append("(").append(accountI.getName()).append(")").append(notFitPeriod);
                }
                if (accountI.getDC() != account0.getDC()) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"CommonQueryDialogWithoutToolBar_DecAccountPropertyError"));
                    return false;
                }
            } else if (useCat) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"FaContrastUI_UseCatErr_accountNull"));
                return false;
            }
            cat = (Object[])this.decTable.getRow(i).getCell("cat").getValue();
            hasChildren = hasChildren || this.hasChildren(cat);
        }
        for (i = 0; i < this.depreTable.getRowCount(); ++i) {
            if (this.depreTable.getRow(i).getCell("account").getValue() != null) {
                accountI = (AccountViewInfo)this.depreTable.getRow(i).getCell("account").getValue();
                account0 = (AccountViewInfo)this.depreTable.getRow(0).getCell("account").getValue();
                if (!accountI.getAccountTableID().getId().toString().equals(acctTableID)) {
                    errInfo.append("\uff1b").append(strAccount).append(accountI.getNumber());
                    errInfo.append("(").append(accountI.getName()).append(")").append(notFitPeriod);
                }
                if (accountI.getDC() != account0.getDC()) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"CommonQueryDialogWithoutToolBar_DepreAccountPropertyError"));
                    return false;
                }
            } else if (useCat) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"FaContrastUI_UseCatErr_accountNull"));
                return false;
            }
            cat = (Object[])this.depreTable.getRow(i).getCell("cat").getValue();
            hasChildren = hasChildren || this.hasChildren(cat);
        }
        if (errInfo.length() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)errInfo.substring(1));
            return false;
        }
        if (hasChildren && MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"FaContrastUI_catConfirm")) == 2) {
            return false;
        }
        return super.verify();
    }

    public void clear() {
        this.fillPeriodComponent(this.currPeriod);
        this.assetTable.removeRows();
        this.decTable.removeRows();
        this.depreTable.removeRows();
        this.chbHasNotVoucher.setSelected(16);
        this.chbDefault.setSelected(16);
        this.chbUseEvaValue.setSelected(16);
        this.chbUseCat.setSelected(16);
        this.chbUseCardAcct.setSelected(16);
    }

    private void changeContrastType(boolean isUseCat) {
        this.assetTable.getColumn("cat").getStyleAttributes().setHided(!isUseCat);
        this.decTable.getColumn("cat").getStyleAttributes().setHided(!isUseCat);
        this.depreTable.getColumn("cat").getStyleAttributes().setHided(!isUseCat);
        this.assetTable.getColumn("cat").setWidth(isUseCat ? 230 : 0);
        this.assetTable.getColumn("account").setWidth(isUseCat ? 230 : 460);
        this.decTable.getColumn("cat").setWidth(isUseCat ? 230 : 0);
        this.decTable.getColumn("account").setWidth(isUseCat ? 230 : 460);
        this.depreTable.getColumn("cat").setWidth(isUseCat ? 230 : 0);
        this.depreTable.getColumn("account").setWidth(isUseCat ? 230 : 460);
        if (isUseCat && this.chbUseCardAcct.isSelected()) {
            this.chbUseCardAcct.setSelected(false);
        }
    }
}

