/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.manage.FaBillTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaQueryNoVoucherFactory;
import com.kingdee.eas.fi.fa.manage.IFaQueryNoVoucher;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaContrastQueryUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.swing.JComboBox;

public class FaContrastQueryUI
extends AbstractFaContrastQueryUI {
    private static final String className = "com.kingdee.eas.fi.fa.manage.FaCardResource";
    private ArrayList billIDList = new ArrayList();

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private KDTable getTable() {
        return this.tblMain;
    }

    public String getUITitle() {
        return EASResource.getString((String)className, (String)"FaContrastQueryUI_title");
    }

    private void fillComponent() {
        ArrayList searchResult = this.searchContrast();
        this.getTable().removeRows();
        this.billIDList.clear();
        String number = "";
        int count = 0;
        for (int rowCount = 0; rowCount < searchResult.size(); ++rowCount) {
            IRow row = this.getTable().addRow();
            HashMap lineData = (HashMap)searchResult.get(rowCount);
            if (rowCount == 0) {
                number = (String)lineData.get("billID");
            }
            if (number != null && number.equals((String)lineData.get("billID"))) {
                ++count;
            } else {
                number = (String)lineData.get("billID");
                this.billIDList.add(new Integer(count));
                this.billIDList.add(new Integer(rowCount));
                count = 1;
            }
            if (rowCount == searchResult.size() - 1) {
                this.billIDList.add(new Integer(count));
                this.billIDList.add(new Integer(rowCount + 1));
            }
            Set resultKey = lineData.keySet();
            for (int i = 0; i < resultKey.size(); ++i) {
                String cellName = (String)resultKey.toArray()[i];
                if ("billType".equalsIgnoreCase(cellName)) {
                    row.getCell(cellName).setValue((Object)FaBillTypeEnum.getEnum(Integer.parseInt(lineData.get(cellName).toString())));
                } else {
                    row.getCell(cellName).setValue(lineData.get(cellName));
                }
                FaContrastQueryUI.getLogger(FaContrastQueryUI.class).debug((Object)("CELL NAME==" + cellName + " VALUE==" + lineData.get(cellName)));
            }
        }
        this.lbPeriodYear.setText(String.valueOf(this.getSelectedPeriod().getPeriodYear()));
        this.lbPeriodNumber.setText(String.valueOf(this.getSelectedPeriod().getPeriodNumber()));
        this.changeTableMerge();
    }

    private ArrayList searchContrast() {
        CompanyOrgUnitInfo curCompany = this.getCurCompany();
        try {
            return this.getBizInterface().getAllNoVoucher(this.getSelectedPeriod().getPeriodYear(), this.getSelectedPeriod().getPeriodNumber(), curCompany.getId().toString());
        }
        catch (Exception e) {
            this.handUIException(e);
            return new ArrayList();
        }
    }

    protected IFaQueryNoVoucher getBizInterface() throws Exception {
        return FaQueryNoVoucherFactory.getRemoteInstance();
    }

    private CompanyOrgUnitInfo getCurCompany() {
        if (this.getUIContext().get("company") != null) {
            return (CompanyOrgUnitInfo)this.getUIContext().get("company");
        }
        return SysContext.getSysContext().getCurrentFIUnit();
    }

    private PeriodInfo getSelectedPeriod() {
        if (this.getUIContext().get("SelectedPeriod") != null) {
            return (PeriodInfo)this.getUIContext().get("SelectedPeriod");
        }
        return new PeriodInfo();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.getTable().checkParsed();
        this.getTable().getStyleAttributes().setLocked(true);
        this.getTable().getSelectManager().setSelectMode(2);
        KDComboBox billTypeCombox = new KDComboBox();
        billTypeCombox.addItems(FaBillTypeEnum.getEnumList().toArray());
        this.getTable().getColumn("billType").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)billTypeCombox));
        FaClientUtils.adjustUIHeight((CoreUIObject)this);
        this.fillComponent();
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        Util.getWindow((Component)((Object)this)).dispose();
    }

    public void changeTableMerge() {
        this.tblMain.setVerticalGridLineVisible(false);
        int size = this.billIDList.size();
        for (int i = 0; i < size; ++i) {
            int count = (Integer)this.billIDList.get(i);
            int endLine = (Integer)this.billIDList.get(i + 1);
            for (int j = endLine - count; j < endLine; ++j) {
                IRow row = this.tblMain.getRow(j);
                if (endLine - j >= count) continue;
                for (int x = 0; x < this.getMergeColumns().length; ++x) {
                    if (row.getCell(this.getMergeColumns()[x]) == null) continue;
                    row.getCell(this.getMergeColumns()[x]).setValue(null);
                }
            }
            StyleAttributes sa = this.tblMain.getRow(endLine - 1).getStyleAttributes();
            sa.setBorderPenStyle(Styles.Position.BOTTOM, PenStyle.PS_SOLID);
            sa.setBorderColor(Styles.Position.BOTTOM, this.tblMain.getGridLineColor());
            ++i;
        }
    }

    protected String[] getMergeColumns() {
        return new String[]{"billNumber", "billDate"};
    }
}

