/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.icons.ResourceManager;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.CellTextIconRender;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.resource.KDResourceManager;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.CustomerParams;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.account.client.AccountClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.manage.FaContrastSolutionFactory;
import com.kingdee.eas.fi.fa.manage.FaContrastSolutionInfo;
import com.kingdee.eas.fi.fa.manage.IFaContrastSolution;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaContrastSolutionFilterUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.manage.client.FaContrastSolutionPromptBox;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class FaContrastSolutionFilterUI
extends AbstractFaContrastSolutionFilterUI {
    private static final long serialVersionUID = 2708824779258961430L;
    private static final Logger logger = CoreUIObject.getLogger(FaContrastSolutionFilterUI.class);
    private List dataList = new ArrayList();
    private Map zipData = null;
    private KDBizPromptBox kDBizPromptBoxOrg = new KDBizPromptBox();
    private List queryCondList = new ArrayList();
    private boolean isConfirm = false;
    private String textToFound = "";
    private int foundIndex = -1;
    private int currentIndex = 0;
    private boolean finishSearch = false;
    private int sort = 0;
    protected static final ImageIcon ICON_ASEND = ResourceManager.getImageIcon((String)"bill_icon_6.gif");
    protected static final ImageIcon ICON_DESEND = ResourceManager.getImageIcon((String)"bill_icon_5.gif");

    public FaContrastSolutionFilterUI() throws Exception {
        this.setPreferredSize(new Dimension(600, 450));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initMyIcon();
        this.initControl();
        IFaContrastSolution iconSolution = FaContrastSolutionFactory.getRemoteInstance();
        this.zipData = iconSolution.getPeriodRangeData();
        this.fillPeriodComponent();
        this.initPeriodYear(this.zipData);
        this.dataList = iconSolution.getInitData();
        this.loadData(this.dataList);
        List queryCondList = (List)this.getUIContext().get("queryCondList");
        this.setRowCanSelected();
        this.initTableListener();
    }

    private void initTableListener() {
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                block3: {
                    try {
                        int endRow;
                        int beginRow;
                        KDTSelectBlock selectBlock = FaContrastSolutionFilterUI.this.tblMain.getSelectManager().get();
                        if (selectBlock == null || (beginRow = selectBlock.getBeginRow()) != (endRow = selectBlock.getEndRow()) || FaContrastSolutionFilterUI.this.tblMain.getSelectManager().getActiveColumnIndex() != 0) break block3;
                        IRow row = FaContrastSolutionFilterUI.this.tblMain.getRow(beginRow);
                        boolean isSelected = (Boolean)row.getCell("select").getValue();
                        String tblOrgId = row.getCell("orgId").getValue().toString();
                        for (int j = 0; j < FaContrastSolutionFilterUI.this.dataList.size(); ++j) {
                            Map dataMap = (Map)FaContrastSolutionFilterUI.this.dataList.get(j);
                            String orgId = (String)dataMap.get("orgId");
                            if (!orgId.equals(tblOrgId)) continue;
                            dataMap.put("select", new Boolean(!isSelected));
                            break;
                        }
                    }
                    catch (Exception exc) {
                        FaContrastSolutionFilterUI.this.handUIException(exc);
                    }
                }
            }
        });
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
                    try {
                        FaContrastSolutionFilterUI.this.OrderByForTable(e);
                        FaContrastSolutionFilterUI.this.setRowCanSelected();
                    }
                    catch (Exception exc) {
                        FaContrastSolutionFilterUI.this.handUIException(exc);
                    }
                }
            }
        });
        this.tblMain.addKDTPropertyChangeListener(new KDTPropertyChangeListener(){

            public void propertyChange(KDTPropertyChangeEvent e) {
                if (e.getColIndex() == FaContrastSolutionFilterUI.this.tblMain.getColumnIndex("solution")) {
                    IRow row = FaContrastSolutionFilterUI.this.tblMain.getRow(e.getRowIndex());
                    FaContrastSolutionInfo solution = (FaContrastSolutionInfo)row.getCell(e.getColIndex()).getValue();
                    String tblOrgId = row.getCell("orgId").getValue().toString();
                    for (int j = 0; j < FaContrastSolutionFilterUI.this.dataList.size(); ++j) {
                        Map dataMap = (Map)FaContrastSolutionFilterUI.this.dataList.get(j);
                        String orgId = (String)dataMap.get("orgId");
                        if (!orgId.equals(tblOrgId)) continue;
                        dataMap.put("solution", solution);
                        break;
                    }
                }
            }
        });
    }

    private void OrderByForTable(KDTMouseEvent e) {
        if (e.getType() == 0) {
            String columnName = this.tblMain.getColumnKey(e.getColIndex());
            if (this.getNotOrderColumns() != null && this.getNotOrderColumns().length > 0) {
                for (int i = 0; i < this.getNotOrderColumns().length; ++i) {
                    if (!this.getNotOrderColumns()[i].equalsIgnoreCase(columnName)) continue;
                    return;
                }
            }
            if (this.sort == 0) {
                try {
                    this.orderByAsc(columnName);
                }
                catch (Exception e1) {
                    this.handleException(e1);
                }
            } else {
                try {
                    this.orderByDesc(columnName);
                }
                catch (Exception e1) {
                    this.handleException(e1);
                }
            }
            KDTCell cell = this.tblMain.getHead().getRow(e.getRowIndex()).getCell(e.getColIndex());
            CellTextIconRender render = new CellTextIconRender();
            if (this.sort == 0) {
                render.setIcon((Icon)ICON_ASEND);
                cell.setRenderer((IBasicRender)render);
                this.sort = 1;
            } else {
                render.setIcon((Icon)ICON_DESEND);
                cell.setRenderer((IBasicRender)render);
                this.sort = 0;
            }
        }
    }

    private String[] getNotOrderColumns() {
        return new String[]{"solution"};
    }

    private void orderByAsc(String columnName) throws Exception {
        if ("select".equals(columnName)) {
            this.orderBySelectFieldAsc();
        } else if ("orgNumber".equals(columnName)) {
            this.tblMain.removeRows();
            this.loadData(this.dataList);
        } else if ("orgName".equals(columnName)) {
            this.orderByOrgNameField("asc");
        } else if ("currPeriod".equals(columnName)) {
            this.orderByCurPeriodAsc();
        }
    }

    private void orderByDesc(String columnName) throws Exception {
        if ("select".equals(columnName)) {
            this.orderBySelectFieldDesc();
        } else if ("orgNumber".equals(columnName)) {
            ArrayList<Map> newDataList = new ArrayList<Map>();
            for (int i = this.dataList.size() - 1; i >= 0; --i) {
                Map dataMap = (Map)this.dataList.get(i);
                newDataList.add(dataMap);
            }
            this.tblMain.removeRows();
            this.loadData(newDataList);
        } else if ("orgName".equals(columnName)) {
            this.orderByOrgNameField("desc");
        } else if ("currPeriod".equals(columnName)) {
            this.orderByCurPeriodDesc();
        }
    }

    private void orderBySelectFieldAsc() throws Exception {
        int i;
        ArrayList<Map> newDataList = new ArrayList<Map>();
        ArrayList<String> fList = new ArrayList<String>();
        ArrayList<String> tList = new ArrayList<String>();
        block0: for (i = 0; i < this.dataList.size(); ++i) {
            Map dataMap = (Map)this.dataList.get(i);
            String orgNumber = (String)dataMap.get("orgNumber");
            for (int j = 0; j < this.tblMain.getRowCount(); ++j) {
                String tblNumber = (String)this.tblMain.getRow(j).getCell("orgNumber").getValue();
                if (!tblNumber.equals(orgNumber)) continue;
                boolean isSelected = (Boolean)this.tblMain.getRow(j).getCell("select").getValue();
                if (!isSelected) {
                    fList.add(orgNumber);
                    newDataList.add(dataMap);
                    continue block0;
                }
                tList.add(orgNumber);
                continue block0;
            }
        }
        block2: for (i = 0; i < tList.size(); ++i) {
            String tblNumber = (String)tList.get(i);
            for (int j = 0; j < this.dataList.size(); ++j) {
                Map dataMap = (Map)this.dataList.get(j);
                String orgNumber = (String)dataMap.get("orgNumber");
                if (!orgNumber.equals(tblNumber)) continue;
                newDataList.add(dataMap);
                continue block2;
            }
        }
        this.tblMain.removeRows();
        this.loadData(newDataList);
    }

    private void orderBySelectFieldDesc() throws Exception {
        int i;
        ArrayList<Map> newDataList = new ArrayList<Map>();
        ArrayList<String> fList = new ArrayList<String>();
        ArrayList<String> tList = new ArrayList<String>();
        block0: for (i = this.dataList.size() - 1; i >= 0; --i) {
            Map dataMap = (Map)this.dataList.get(i);
            String orgNumber = (String)dataMap.get("orgNumber");
            for (int j = 0; j < this.tblMain.getRowCount(); ++j) {
                String tblNumber = (String)this.tblMain.getRow(j).getCell("orgNumber").getValue();
                if (!tblNumber.equals(orgNumber)) continue;
                boolean isSelected = (Boolean)this.tblMain.getRow(j).getCell("select").getValue();
                if (isSelected) {
                    tList.add(orgNumber);
                    newDataList.add(dataMap);
                    continue block0;
                }
                fList.add(orgNumber);
                continue block0;
            }
        }
        for (i = 0; i < fList.size(); ++i) {
            String tblNumber = (String)fList.get(i);
            for (int j = 0; j < this.dataList.size(); ++j) {
                Map dataMap = (Map)this.dataList.get(j);
                String orgNumber = (String)dataMap.get("orgNumber");
                if (!orgNumber.equals(tblNumber)) continue;
                newDataList.add(dataMap);
            }
        }
        this.tblMain.removeRows();
        this.loadData(newDataList);
    }

    private void orderByOrgNameField(String orderType) throws Exception {
        Object[] orgName = new String[this.tblMain.getRowCount()];
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            orgName[i] = (String)this.tblMain.getRow(i).getCell("orgName").getValue();
        }
        if ("asc".equals(orderType)) {
            Arrays.sort(orgName);
        } else {
            Arrays.sort(orgName, Collections.reverseOrder());
        }
        ArrayList<Map> newDataList = new ArrayList<Map>();
        block1: for (int i = 0; i < orgName.length; ++i) {
            for (int j = 0; j < this.dataList.size(); ++j) {
                Map dataMap = (Map)this.dataList.get(j);
                String comName = (String)dataMap.get("orgName");
                if (!comName.equals(orgName[i])) continue;
                newDataList.add(dataMap);
                continue block1;
            }
        }
        this.tblMain.removeRows();
        this.loadData(newDataList);
    }

    private void orderByCurPeriodAsc() throws Exception {
        ArrayList<Integer> periodList = new ArrayList<Integer>();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            int p;
            String periodStr = (String)this.tblMain.getRow(i).getCell("currPeriod").getValue();
            if (periodStr.length() < 6 || periodList.contains(new Integer(p = Integer.parseInt(periodStr.substring(0, 4)) * 100 + Integer.parseInt(periodStr.substring(5))))) continue;
            periodList.add(new Integer(p));
        }
        Object[] period = periodList.toArray();
        Arrays.sort(period);
        ArrayList<Map> newDataList = new ArrayList<Map>();
        for (int i = 0; i < period.length; ++i) {
            String pd = String.valueOf(period[i]);
            String periodStr = pd.substring(0, 4).concat(".").concat(String.valueOf(Integer.parseInt(pd.substring(4))));
            for (int j = 0; j < this.dataList.size(); ++j) {
                Map dataMap = (Map)this.dataList.get(j);
                String curPeriod = (String)dataMap.get("currPeriod");
                if (!periodStr.equals(curPeriod)) continue;
                newDataList.add(dataMap);
            }
        }
        this.tblMain.removeRows();
        this.loadData(newDataList);
    }

    private void orderByCurPeriodDesc() throws Exception {
        ArrayList<Integer> periodList = new ArrayList<Integer>();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            int p;
            String periodStr = (String)this.tblMain.getRow(i).getCell("currPeriod").getValue();
            if (periodStr.length() < 6 || periodList.contains(new Integer(p = Integer.parseInt(periodStr.substring(0, 4)) * 100 + Integer.parseInt(periodStr.substring(5))))) continue;
            periodList.add(new Integer(p));
        }
        Object[] period = periodList.toArray();
        Arrays.sort(period, Collections.reverseOrder());
        ArrayList<Map> newDataList = new ArrayList<Map>();
        for (int i = 0; i < period.length; ++i) {
            String pd = String.valueOf(period[i]);
            String periodStr = pd.substring(0, 4).concat(".").concat(String.valueOf(Integer.parseInt(pd.substring(4))));
            for (int j = this.dataList.size() - 1; j >= 0; --j) {
                Map dataMap = (Map)this.dataList.get(j);
                String curPeriod = (String)dataMap.get("currPeriod");
                if (!periodStr.equals(curPeriod)) continue;
                newDataList.add(dataMap);
            }
        }
        this.tblMain.removeRows();
        this.loadData(newDataList);
    }

    private void loadQueryCond(List queryCondList) {
        block0: for (int i = 0; i < queryCondList.size(); ++i) {
            int j;
            Map queryMap = (Map)queryCondList.get(i);
            if (queryMap == null || queryMap.get("orgId") == null) continue;
            int periodYear = (Integer)queryMap.get("periodYear");
            int periodNumber = (Integer)queryMap.get("periodNumber");
            this.spPeriodYear.setValue((Object)periodYear);
            this.spPeriodNumber.setValue((Object)periodNumber);
            for (j = 0; j < this.tblMain.getRowCount(); ++j) {
                IRow row = this.tblMain.getRow(j);
                String companyId = row.getCell("orgId").getValue().toString();
                if (!companyId.equals(queryMap.get("orgId"))) continue;
                row.getCell("select").setValue((Object)Boolean.TRUE);
                row.getCell("solution").setValue((Object)((FaContrastSolutionInfo)queryMap.get("solution")));
            }
            for (j = 0; j < this.dataList.size(); ++j) {
                Map dataMap = (Map)this.dataList.get(j);
                String orgId = (String)dataMap.get("orgId");
                if (!orgId.equals(queryMap.get("orgId"))) continue;
                dataMap.put("select", Boolean.TRUE);
                continue block0;
            }
        }
    }

    private void fillPeriodComponent() throws EASBizException, BOSException {
        CompanyOrgUnitInfo currCompanyInfo = SysContext.getSysContext().getCurrentFIUnit();
        PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)currCompanyInfo);
        if (currPeriod == null || !currCompanyInfo.isIsBizUnit()) {
            currPeriod = PeriodUtils.getPeriodInfo((Date)new Date(), (CompanyOrgUnitInfo)currCompanyInfo);
        }
        if (currPeriod == null) {
            if (this.zipData.size() > 0) {
                int endYear = (Integer)this.zipData.get("endYear");
                int maxPeriod = this.zipData.get("maxNumber" + endYear) != null ? ((Integer)this.zipData.get("maxNumber" + endYear)).intValue() : new Integer(12).intValue();
                this.spPeriodYear.setValue((Object)new Integer(endYear));
                this.spPeriodNumber.setValue((Object)new Integer(maxPeriod));
            }
            return;
        }
        int currYear = currPeriod.getPeriodYear();
        int currMonth = currPeriod.getPeriodNumber();
        this.spPeriodYear.setValue((Object)new Integer(currYear));
        this.spPeriodNumber.setValue((Object)new Integer(currMonth));
    }

    private void initPeriodYear(Map periodRangeData) throws EASBizException, BOSException {
        if (periodRangeData.size() > 0) {
            SpinnerNumberModel yearModel = (SpinnerNumberModel)this.spPeriodYear.getModel();
            SpinnerNumberModel numberModel = (SpinnerNumberModel)this.spPeriodNumber.getModel();
            Integer startYear = (Integer)periodRangeData.get("startYear");
            Integer endYear = (Integer)periodRangeData.get("endYear");
            yearModel.setMinimum(startYear);
            yearModel.setMaximum(endYear);
            int year = (Integer)this.spPeriodYear.getValue();
            int maxPeriod = this.zipData.get("maxNumber" + year) != null ? ((Integer)this.zipData.get("maxNumber" + year)).intValue() : ((Integer)this.spPeriodNumber.getValue()).intValue();
            int minPeriod = this.zipData.get("minNumber" + year) != null ? (Integer)this.zipData.get("minNumber" + year) : 1;
            numberModel.setMinimum(Integer.valueOf(minPeriod));
            numberModel.setMaximum(Integer.valueOf(maxPeriod));
        } else {
            SpinnerNumberModel numberModel = (SpinnerNumberModel)this.spPeriodNumber.getModel();
            numberModel.setMinimum(new Integer(1));
            numberModel.setMaximum((Integer)this.spPeriodNumber.getValue());
        }
        this.spPeriodYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaContrastSolutionFilterUI.this.changePeriodYear();
                FaContrastSolutionFilterUI.this.setRowCanSelected();
            }
        });
        this.spPeriodNumber.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaContrastSolutionFilterUI.this.setRowCanSelected();
            }
        });
    }

    private void changePeriodYear() {
        if (this.zipData.size() == 0) {
            SpinnerNumberModel numbModel = (SpinnerNumberModel)this.spPeriodNumber.getModel();
            numbModel.setMinimum(new Integer(1));
            numbModel.setMaximum(new Integer(12));
            return;
        }
        Integer year = (Integer)this.spPeriodYear.getValue();
        SpinnerNumberModel numberModel = (SpinnerNumberModel)this.spPeriodNumber.getModel();
        try {
            int maxPeriod = this.zipData.get("maxNumber" + year) != null ? ((Integer)this.zipData.get("maxNumber" + year)).intValue() : ((Integer)this.spPeriodNumber.getValue()).intValue();
            int minPeriod = this.zipData.get("minNumber" + year) != null ? (Integer)this.zipData.get("minNumber" + year) : 1;
            numberModel.setMaximum(new Integer(maxPeriod));
            numberModel.setMinimum(new Integer(minPeriod));
            this.spPeriodNumber.setValue(numberModel.getMinimum());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void setRowCanSelected() {
        int n = this.tblMain.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.tblMain.getRow(i);
            int year = (Integer)this.spPeriodYear.getValue();
            int number = (Integer)this.spPeriodNumber.getValue();
            String currPeriod = (String)row.getCell("currPeriod").getValue();
            int index = currPeriod.indexOf(".");
            int currYear = Integer.parseInt(currPeriod.substring(0, index));
            int currNumber = Integer.parseInt(currPeriod.substring(index + 1));
            int startYear = ((PeriodInfo)row.getCell("startPeriod").getValue()).getPeriodYear();
            int startNumber = ((PeriodInfo)row.getCell("startPeriod").getValue()).getPeriodNumber();
            if (year > currYear || year == currYear && number > currNumber || year < startYear || year == startYear && number < startNumber) {
                row.getStyleAttributes().setFontColor(Color.GRAY);
                row.getCell("select").setValue((Object)Boolean.FALSE);
                row.getCell("select").getStyleAttributes().setLocked(true);
                row.getCell("solution").getStyleAttributes().setLocked(true);
                KDCheckBox kDCheckBox = (KDCheckBox)row.getCell("select").getEditor().getComponent();
                continue;
            }
            row.getStyleAttributes().setFontColor(Color.BLACK);
            row.getCell("select").getStyleAttributes().setLocked(false);
            row.getCell("solution").getStyleAttributes().setLocked(false);
        }
    }

    protected void initMyIcon() {
        this.tblMain.checkParsed();
        this.actionSearch.setEnabled(true);
        this.actionConfirm.setEnabled(true);
        this.actionExit.setEnabled(true);
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnSearch.setIcon((Icon)new ImageIcon(KDResourceManager.getImageOfRapid((String)"tree_demand.png")));
        this.tblMain.getColumn("orgNumber").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("orgName").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("currPeriod").getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(1);
        KDTRow row = this.tblMain.getHead().getRow(0);
        CellTextIconRender render = new CellTextIconRender();
        render.setIcon((Icon)ICON_ASEND);
        for (int i = 0; i < this.tblMain.getColumnCount(); ++i) {
            if (i == 3) continue;
            row.getCell(i).setRenderer((IBasicRender)render);
        }
    }

    protected void initControl() throws Exception {
        ObjectValueRender displayNameRender = new ObjectValueRender();
        displayNameRender.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kDBizPromptBoxOrg.setEditable(false);
        this.kDBizPromptBoxOrg.setDisplayFormat("$name$");
        this.tblMain.getColumn("solution").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.kDBizPromptBoxOrg));
        this.tblMain.getColumn("solution").setRenderer((IBasicRender)displayNameRender);
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){
            FaContrastSolutionPromptBox newSoluPromptBox = null;

            public void editStarted(KDTEditEvent e) {
                String orgId = (String)FaContrastSolutionFilterUI.this.tblMain.getCell(e.getRowIndex(), "orgId").getValue();
                if (e.getColIndex() == FaContrastSolutionFilterUI.this.tblMain.getColumnIndex("solution") && orgId != null) {
                    ObjectUuidPK companyPK = new ObjectUuidPK(orgId);
                    try {
                        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)companyPK);
                        this.newSoluPromptBox = new FaContrastSolutionPromptBox((IUIObject)FaContrastSolutionFilterUI.this, companyInfo);
                        FaContrastSolutionFilterUI.this.kDBizPromptBoxOrg.setSelector((KDPromptSelector)this.newSoluPromptBox);
                    }
                    catch (EASBizException e1) {
                        FaContrastSolutionFilterUI.this.handleException((Exception)((Object)e1));
                    }
                    catch (BOSException e1) {
                        FaContrastSolutionFilterUI.this.handleException((Exception)((Object)e1));
                    }
                }
            }

            public void editStopped(KDTEditEvent e) {
                FaContrastSolutionInfo solution;
                if (e.getColIndex() == FaContrastSolutionFilterUI.this.tblMain.getColumnIndex("solution") && FaContrastSolutionFilterUI.this.tblMain.getCell(e.getRowIndex(), "solution") != null && (solution = (FaContrastSolutionInfo)FaContrastSolutionFilterUI.this.tblMain.getCell(e.getRowIndex(), "solution").getValue()) != null && solution.getId() != null) {
                    try {
                        boolean isExists = FaContrastSolutionFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK(solution.getId()));
                        if (!isExists) {
                            FaContrastSolutionFilterUI.this.tblMain.getCell(e.getRowIndex(), "solution").setValue(null);
                        }
                    }
                    catch (EASBizException e1) {
                        FaContrastSolutionFilterUI.this.handleException((Exception)((Object)e1));
                    }
                    catch (BOSException e1) {
                        FaContrastSolutionFilterUI.this.handleException((Exception)((Object)e1));
                    }
                }
            }
        });
    }

    protected void loadData(List dataList) {
        if (dataList != null && dataList.size() > 0) {
            int n = dataList.size();
            for (int i = 0; i < n; ++i) {
                IRow row = this.tblMain.addRow();
                Map recordMap = (Map)dataList.get(i);
                KDCheckBox selected = new KDCheckBox();
                KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JCheckBox)selected);
                row.getCell("select").setEditor((ICellEditor)cellEditor);
                Boolean isSelected = recordMap.get("select") == null ? Boolean.FALSE : (Boolean)recordMap.get("select");
                row.getCell("select").setValue((Object)isSelected);
                row.getCell("orgId").setValue(recordMap.get("orgId"));
                row.getCell("orgNumber").setValue(recordMap.get("orgNumber"));
                row.getCell("orgName").setValue(recordMap.get("orgName"));
                row.getCell("currPeriod").setValue(recordMap.get("currPeriod"));
                row.getCell("solution").setValue((Object)((FaContrastSolutionInfo)recordMap.get("solution")));
                row.getCell("startPeriod").setValue((Object)((PeriodInfo)recordMap.get("startPeriod")));
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionSearch_actionPerformed(ActionEvent e) throws Exception {
        IRow currentRow = null;
        String rowText = "";
        int size = this.tblMain.getRowCount();
        String input = this.txtFindValue.getText().toLowerCase().trim();
        if (input != null && input.trim().length() > 0) {
            if (!this.textToFound.equalsIgnoreCase(input)) {
                this.finishSearch = false;
                this.textToFound = input;
                currentRow = null;
                this.foundIndex = -1;
                this.currentIndex = 0;
            }
            this.currentIndex = this.foundIndex + 1;
            if (this.currentIndex < size) {
                int i;
                for (i = this.currentIndex; i < size; ++i) {
                    String rowNameText;
                    currentRow = this.tblMain.getRow(i);
                    String rowNumberText = currentRow.getCell("orgNumber").getValue().toString();
                    rowText = rowNumberText.concat(rowNameText = currentRow.getCell("orgName").getValue().toString()).toLowerCase();
                    if (rowText.indexOf(this.textToFound) == -1) continue;
                    this.tblMain.getSelectManager().select(i, 1);
                    this.tblMain.getLayoutManager().scrollRowToShow(i);
                    this.foundIndex = i;
                    break;
                }
                if (i == size) {
                    this.finishSearch = true;
                }
            }
        }
        if (this.currentIndex == size) {
            this.finishSearch = true;
        }
        if (this.foundIndex == -1) {
            if (this.finishSearch) {
                String msg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaContrastResource", (String)"FinishFindButNoResult");
                MsgBox.showInfo((Component)((Object)this), (String)msg);
                return;
            }
        } else if (this.finishSearch) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaContrastResource", (String)"FinishFind");
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            this.finishSearch = false;
            this.textToFound = input;
            currentRow = null;
            this.foundIndex = -1;
            this.currentIndex = 0;
            this.tblMain.getSelectManager().select(0, 1);
            this.tblMain.getLayoutManager().scrollRowToShow(0);
            return;
        }
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.doSelect(true);
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        this.doSelect(false);
    }

    private void doSelect(boolean select) {
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblMain.getRow(i);
            if (row.getCell("select").getStyleAttributes().isLocked()) continue;
            row.getCell("select").setValue((Object)select);
        }
    }

    public List getQueryCondList() {
        return this.queryCondList;
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        StringBuffer msg = new StringBuffer();
        ArrayList companyList = new ArrayList();
        this.queryCondList = new ArrayList();
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (!((Boolean)this.tblMain.getRow(i).getCell("select").getValue()).booleanValue()) continue;
            HashMap<String, Object> queryCondMap = new HashMap<String, Object>();
            queryCondMap.put("orgId", this.tblMain.getRow(i).getCell("orgId").getValue());
            queryCondMap.put("periodYear", this.spPeriodYear.getValue());
            queryCondMap.put("periodNumber", this.spPeriodNumber.getValue());
            FaContrastSolutionInfo solution = (FaContrastSolutionInfo)this.tblMain.getRow(i).getCell("solution").getValue();
            String orgNumber = (String)this.tblMain.getRow(i).getCell("orgNumber").getValue();
            String orgName = (String)this.tblMain.getRow(i).getCell("orgName").getValue();
            this.verify(i, orgNumber + "  " + orgName, solution, msg, companyList);
            queryCondMap.put("solution", solution);
            this.queryCondList.add(queryCondMap);
        }
        if (companyList.size() > 0) {
            String valueStr = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaContrastResource", (String)"AccountView_NotIn_ContrastPeriod");
            msg.append(valueStr).append("\n");
            for (int i = 0; i < companyList.size(); ++i) {
                msg.append(companyList.get(i)).append("\n");
            }
        }
        if (msg.length() > 0) {
            String title = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDecValueResource", (String)"Fail_To_Operate");
            MsgBox.showDetailAndOK((Component)((Object)this), (String)title.toString(), (String)msg.toString(), (int)1);
            SysUtil.abort();
        }
        if (this.queryCondList.size() == 0) {
            String message = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaContrastResource", (String)"ContrastOrg_Is_NotNull");
            MsgBox.showInfo((Component)((Object)this), (String)message);
            return;
        }
        this.getUIContext().put("queryCondList", this.queryCondList);
        this.isConfirm = true;
        this.disposeUIWindow();
    }

    protected void verify(int n, String org, FaContrastSolutionInfo solution, StringBuffer msg, List companyList) throws Exception {
        CustomerParams cp;
        if (solution == null) {
            String valueStr = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaContrastResource", (String)"ContrastSolution_Is_NotNull"), n + 1 + "", org);
            msg.append(valueStr).append("\n");
        }
        if (solution != null && solution.getParams() != null && (cp = XMLBean.transStrToCommonCustParams((String)solution.getParams())) != null) {
            CustomerParams accountMap = cp.getMe("AccountMap");
            if (accountMap.getMe("ASSET") == null || accountMap.getMe("ASSET").getCustomerParamsHashMap() == null || accountMap.getMe("DECVALUE") == null || accountMap.getMe("DECVALUE").getCustomerParamsHashMap() == null || accountMap.getMe("DEPRE") == null || accountMap.getMe("DEPRE").getCustomerParamsHashMap() == null) {
                return;
            }
            TreeSet assetKeySet = new TreeSet(accountMap.getMe("ASSET").getCustomerParamsHashMap().keySet());
            TreeSet depreKeySet = new TreeSet(accountMap.getMe("DEPRE").getCustomerParamsHashMap().keySet());
            TreeSet decvalueKeySet = new TreeSet(accountMap.getMe("DECVALUE").getCustomerParamsHashMap().keySet());
            try {
                String value;
                int i;
                IAccountView iAccount = AccountViewFactory.getRemoteInstance();
                HashMap<String, AccountViewInfo> accountInfoMap = new HashMap<String, AccountViewInfo>();
                HashSet<String> accountIdSet = new HashSet<String>();
                for (i = 0; i < assetKeySet.size(); ++i) {
                    value = (String)accountMap.getMe("ASSET").getCustomerParamsHashMap().get(assetKeySet.toArray()[i]);
                    accountIdSet.add(value);
                }
                for (i = 0; i < depreKeySet.size(); ++i) {
                    value = (String)accountMap.getMe("DEPRE").getCustomerParamsHashMap().get(depreKeySet.toArray()[i]);
                    accountIdSet.add(value);
                }
                for (i = 0; i < decvalueKeySet.size(); ++i) {
                    value = (String)accountMap.getMe("DECVALUE").getCustomerParamsHashMap().get(decvalueKeySet.toArray()[i]);
                    accountIdSet.add(value);
                }
                if (accountIdSet.size() > 0) {
                    EntityViewInfo v = new EntityViewInfo();
                    FilterInfo f = new FilterInfo();
                    v.setFilter(f);
                    f.getFilterItems().add(new FilterItemInfo("id", accountIdSet, CompareType.INCLUDE));
                    AccountViewCollection accounts = iAccount.getAccountViewCollection(v);
                    for (int i2 = 0; i2 < accounts.size(); ++i2) {
                        accountInfoMap.put(accounts.get(i2).getId().toString(), accounts.get(i2));
                    }
                }
                AccountViewInfo accountI = null;
                String cuID = solution.getOrgID();
                CompanyOrgUnitInfo companyInfo = FaClientUtils.getCurrentCompany(null, cuID);
                AccountClientUtils.checkCompanyAccountTable(null, (CompanyOrgUnitInfo)companyInfo);
                String acctTableID = companyInfo.getAccountTable().getId().toString();
                try {
                    acctTableID = AccountTools.getCurrentAcctTable((String)cuID, (String)acctTableID, (int)this.spPeriodYear.getIntegerVlaue(), (int)this.spPeriodNumber.getIntegerVlaue());
                }
                catch (Exception ex) {
                    this.handUIException(ex);
                }
                for (int i3 = 0; i3 < accountIdSet.size(); ++i3) {
                    String accountId = (String)accountIdSet.toArray()[i3];
                    accountI = (AccountViewInfo)accountInfoMap.get(accountId);
                    if (accountI == null || accountI.getAccountTableID() == null || accountI.getAccountTableID().getId().toString().equals(acctTableID)) continue;
                    companyList.add(org);
                    break;
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("queryCondList", this.queryCondList);
        this.isConfirm = false;
        this.disposeUIWindow();
    }

    public boolean isConfirm() {
        return this.isConfirm;
    }
}

