/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.account.client.AccountClientUtils;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.fa.basedata.FaBasedataTypeEnum;
import com.kingdee.eas.fi.fa.basedata.FaCatFactory;
import com.kingdee.eas.fi.fa.basedata.FaCatInfo;
import com.kingdee.eas.fi.fa.basedata.IFaCat;
import com.kingdee.eas.fi.fa.basedata.client.FaCatPromptBox;
import com.kingdee.eas.fi.fa.manage.FaContrastSolutionFactory;
import com.kingdee.eas.fi.fa.manage.FaContrastSolutionInfo;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaContrastSolutionUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.manage.client.FaSolutionSaveAsPromptUI;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class FaContrastSolutionUI
extends AbstractFaContrastSolutionUI {
    private static final long serialVersionUID = 2219456896359225313L;
    private static final Logger logger = CoreUIObject.getLogger(FaContrastSolutionUI.class);
    public static final String AccountMap_Key = "AccountMap";
    public static final String IsIncludeUnposted_Key = "isIncludeUnposted";
    public static final String IsDefaultSolution_Key = "IsDefaultSolution";
    public static final String IsUseEvaValue_Key = "isUseEvaValue";
    public static final String IsUseCatNumber_Key = "isUseCatNumber";
    public static final String IsUseCardAcct_Key = "isUseCardAcct";
    public static final String CatMap_Key = "CatMap";
    private CompanyOrgUnitInfo currCompany = null;
    private PeriodInfo currPeriod = null;
    private KDBizPromptBox kDBizPromptBoxAccount = new KDBizPromptBox();
    private String currentSolutionName;
    private FaContrastSolutionInfo currSolutionInfo;
    protected boolean isCanceled = true;

    public FaContrastSolutionUI() throws Exception {
        this.setPreferredSize(new Dimension(800, 530));
    }

    protected CompanyOrgUnitInfo getCurrCompany() {
        if (this.currCompany == null) {
            this.currCompany = (CompanyOrgUnitInfo)this.getUIContext().get("currCompany");
            this.currCompany = this.currCompany == null ? SysContext.getSysContext().getCurrentFIUnit() : this.currCompany;
        }
        return this.currCompany;
    }

    protected PeriodInfo getCurrPeriod() throws EASBizException, BOSException {
        if (this.currPeriod == null) {
            this.currPeriod = FaClientUtils.getCurrentPeriod(this.getCurrCompany().getId().toString());
        }
        return this.currPeriod;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.remove((Component)this.btnNew);
        this.remove((Component)this.btnDel);
        this.remove((Component)this.btnSave);
        this.remove((Component)this.btnSaveAs);
        KDTreeView.ControlPanel pnl = this.tree.getControlPane();
        Component[] component = pnl.getComponents();
        for (int i = component.length - 1; i >= 0; --i) {
            Component comp = pnl.getComponent(i);
            if (!(comp instanceof KDWorkButton)) continue;
            pnl.remove(comp);
        }
        pnl.add((Component)this.btnNew);
        pnl.add((Component)this.btnDel);
        pnl.add((Component)this.btnSave);
        pnl.add((Component)this.btnSaveAs);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAddLine_Asset.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnAddLine_Dec.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnAddLine_Depre.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelLine_Asset.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnDelLine_Dec.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnDelLine_Depre.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnDelLine_Asset.setEnabled(true);
        this.btnDelLine_Depre.setEnabled(true);
        this.btnDelLine_Dec.setEnabled(true);
        this.actionConfirm.setEnabled(true);
        this.actionExit.setEnabled(true);
        this.txtCompany.setText(this.getCurrCompany().getName());
        this.initAccountF7();
        this.init();
        this.changeContrastType(false);
        this.chbUseCat.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaContrastSolutionUI.this.changeContrastType(FaContrastSolutionUI.this.chbUseCat.getSelected() == 32);
            }
        });
        this.chbUseCardAcct.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (FaContrastSolutionUI.this.chbUseCardAcct.isSelected() && FaContrastSolutionUI.this.chbUseCat.isSelected()) {
                    FaContrastSolutionUI.this.chbUseCat.setSelected(false);
                }
            }
        });
        this.refreshSolutionList();
    }

    protected ICoreBase getBizInterface() throws BOSException {
        return FaContrastSolutionFactory.getRemoteInstance();
    }

    private void initAccountF7() {
        this.assetTable.checkParsed();
        this.decTable.checkParsed();
        this.depreTable.checkParsed();
        this.kDBizPromptBoxAccount.setQueryInfo("com.kingdee.eas.basedata.master.account.app.AccountViewQuery");
        this.kDBizPromptBoxAccount.setDisplayFormat("$number$--$name$");
        this.kDBizPromptBoxAccount.setEditFormat("$number$");
        this.kDBizPromptBoxAccount.setCommitFormat("$number$");
        this.kDBizPromptBoxAccount.setEditable(true);
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = this.getCurrCompany();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo companyAccountFilterItemInfo = new FilterItemInfo("companyID.id", (Object)aCompanyOrgUnitInfo.getId().toString());
        AccountClientUtils.checkCompanyAccountTable(null, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
        FilterItemInfo companyAccountFilterItemInfo2 = new FilterItemInfo("accountTableID.id", (Object)aCompanyOrgUnitInfo.getAccountTable().getId().toString());
        FilterItemInfo gfStr = new FilterItemInfo("isGFreeze", (Object)new Integer(0));
        FilterItemInfo cfStr = new FilterItemInfo("isCFreeze", (Object)new Integer(0));
        filter.getFilterItems().add(companyAccountFilterItemInfo);
        filter.getFilterItems().add(companyAccountFilterItemInfo2);
        filter.getFilterItems().add(gfStr);
        filter.getFilterItems().add(cfStr);
        viewInfo.setFilter(filter);
        AccountPromptBox accountPromtBox = new AccountPromptBox((IUIObject)this, aCompanyOrgUnitInfo, filter, false, false);
        this.kDBizPromptBoxAccount.setSelector((KDPromptSelector)accountPromtBox);
        this.kDBizPromptBoxAccount.setEntityViewInfo(viewInfo);
        this.assetTable.getColumn("account").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.kDBizPromptBoxAccount));
        this.decTable.getColumn("account").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.kDBizPromptBoxAccount));
        this.depreTable.getColumn("account").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.kDBizPromptBoxAccount));
        KDBizPromptBox bizPromptFaCat = new KDBizPromptBox();
        bizPromptFaCat.setQueryInfo("com.kingdee.eas.fi.fa.basedata.FaCatQuery");
        bizPromptFaCat.setCommitFormat("$number$");
        bizPromptFaCat.setEditFormat("$number$--$name$");
        bizPromptFaCat.setDisplayFormat("$number$--$name$");
        bizPromptFaCat.setEditable(true);
        bizPromptFaCat.setEntityViewInfo(FaClientUtils.getOrgSplitViewInfo(FaBasedataTypeEnum.CAT, false));
        bizPromptFaCat.setEnabledMultiSelection(true);
        FaCatPromptBox aFaCatPromptBox = new FaCatPromptBox((CoreUIObject)this, true, false);
        aFaCatPromptBox.setACompanyOrgUnitInfo(aCompanyOrgUnitInfo);
        bizPromptFaCat.setSelector((KDPromptSelector)aFaCatPromptBox);
        ObjectValueRender render = new ObjectValueRender();
        render.setFormat(new IDataFormat(){

            public String format(Object object) {
                StringBuffer ret = new StringBuffer();
                if (object.getClass().isArray()) {
                    Object[] os = (Object[])object;
                    for (int i = 0; i < os.length; ++i) {
                        if (i > 0) {
                            ret.append("; ");
                        }
                        ret.append(((FaCatInfo)os[i]).toString());
                    }
                }
                return ret.toString();
            }
        });
        this.assetTable.getColumn("cat").setRenderer((IBasicRender)render);
        this.decTable.getColumn("cat").setRenderer((IBasicRender)render);
        this.depreTable.getColumn("cat").setRenderer((IBasicRender)render);
        this.assetTable.getColumn("cat").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPromptFaCat));
        this.decTable.getColumn("cat").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPromptFaCat));
        this.depreTable.getColumn("cat").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPromptFaCat));
    }

    private void setAccountF7Selector() throws EASBizException, BOSException {
        CompanyOrgUnitInfo currCompany = this.getCurrCompany();
        AccountClientUtils.checkCompanyAccountTable(null, (CompanyOrgUnitInfo)currCompany);
        String acctTableID = currCompany.getAccountTable().getId().toString();
        acctTableID = AccountTools.getCurrentAcctTable((String)currCompany.getId().toString(), (String)acctTableID, (int)this.getCurrPeriod().getPeriodYear(), (int)this.getCurrPeriod().getPeriodNumber());
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("name"));
        selectors.add(new SelectorItemInfo("number"));
        AccountTableInfo acctTable = AccountTableFactory.getRemoteInstance().getAccountTableInfo((IObjectPK)new ObjectUuidPK(acctTableID), selectors);
        AccountPromptBox accountPromtBox = new AccountPromptBox((IUIObject)this, currCompany, acctTable, new FilterInfo(), false, false);
        this.kDBizPromptBoxAccount.setSelector((KDPromptSelector)accountPromtBox);
    }

    protected void init() throws Exception {
        this.btnNew.setText(null);
        this.btnNew.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnNew.setFactType(0);
        this.btnNew.setBorder(null);
        this.btnNew.setContentAreaFilled(false);
        this.btnDel.setText(null);
        this.btnDel.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnDel.setFactType(0);
        this.btnDel.setBorder(null);
        this.btnDel.setContentAreaFilled(false);
        this.btnSave.setText(null);
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSave.setFactType(0);
        this.btnSave.setBorder(null);
        this.btnSave.setContentAreaFilled(false);
        this.btnSaveAs.setText(null);
        this.btnSaveAs.setIcon(EASResource.getIcon((String)"imgTbtn_saveas"));
        this.btnSaveAs.setFactType(0);
        this.btnSaveAs.setBorder(null);
        this.btnSaveAs.setContentAreaFilled(false);
    }

    private void changeContrastType(boolean isUseCat) {
        this.assetTable.getColumn("cat").getStyleAttributes().setHided(!isUseCat);
        this.decTable.getColumn("cat").getStyleAttributes().setHided(!isUseCat);
        this.depreTable.getColumn("cat").getStyleAttributes().setHided(!isUseCat);
        this.assetTable.getColumn("cat").setWidth(isUseCat ? 230 : 0);
        this.assetTable.getColumn("account").setWidth(isUseCat ? 230 : 460);
        this.decTable.getColumn("cat").setWidth(isUseCat ? 230 : 0);
        this.decTable.getColumn("account").setWidth(isUseCat ? 230 : 460);
        this.depreTable.getColumn("cat").setWidth(isUseCat ? 230 : 0);
        this.depreTable.getColumn("account").setWidth(isUseCat ? 230 : 460);
        if (isUseCat && this.chbUseCardAcct.isSelected()) {
            this.chbUseCardAcct.setSelected(false);
        }
    }

    public CustomerParams getFilterInfo() {
        int catCount;
        Object[] cat;
        int i;
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("checkedStatus", (Object)new Integer(2)));
        CustomerParams assetAccount = new CustomerParams();
        CustomerParams decAccount = new CustomerParams();
        CustomerParams depreAccount = new CustomerParams();
        CustomerParams catMap = new CustomerParams();
        for (i = 0; i < this.assetTable.getRowCount(); ++i) {
            if (this.assetTable.getRow(i).getCell("account").getValue() != null) {
                assetAccount.addCustomerParam("account" + i, ((AccountViewInfo)this.assetTable.getRow(i).getCell("account").getValue()).getId().toString());
            }
            if (this.assetTable.getRow(i).getCell("cat").getValue() == null) continue;
            CustomerParams assetCat = new CustomerParams();
            cat = (Object[])this.assetTable.getRow(i).getCell("cat").getValue();
            for (catCount = 0; catCount < cat.length; ++catCount) {
                assetCat.addCustomerParam("cat" + catCount, ((FaCatInfo)cat[catCount]).getId().toString());
            }
            if (assetAccount.getValues().size() <= i || assetAccount.getCustomerParam("account" + i) == null) continue;
            catMap.putMe("ASSET_" + assetAccount.getCustomerParam("account" + i).toString(), assetCat);
        }
        for (i = 0; i < this.decTable.getRowCount(); ++i) {
            if (this.decTable.getRow(i).getCell("account").getValue() != null) {
                decAccount.addCustomerParam("account" + i, ((AccountViewInfo)this.decTable.getRow(i).getCell("account").getValue()).getId().toString());
            }
            if (this.decTable.getRow(i).getCell("cat").getValue() == null) continue;
            CustomerParams decCat = new CustomerParams();
            cat = (Object[])this.decTable.getRow(i).getCell("cat").getValue();
            for (catCount = 0; catCount < cat.length; ++catCount) {
                decCat.addCustomerParam("cat" + catCount, ((FaCatInfo)cat[catCount]).getId().toString());
            }
            if (decAccount.getValues().size() <= i || decAccount.getCustomerParam("account" + i) == null) continue;
            catMap.putMe("DECVALUE_" + decAccount.getCustomerParam("account" + i).toString(), decCat);
        }
        for (i = 0; i < this.depreTable.getRowCount(); ++i) {
            if (this.depreTable.getRow(i).getCell("account").getValue() != null) {
                depreAccount.addCustomerParam("account" + i, ((AccountViewInfo)this.depreTable.getRow(i).getCell("account").getValue()).getId().toString());
            }
            if (this.depreTable.getRow(i).getCell("cat").getValue() == null) continue;
            CustomerParams depreCat = new CustomerParams();
            cat = (Object[])this.depreTable.getRow(i).getCell("cat").getValue();
            for (catCount = 0; catCount < cat.length; ++catCount) {
                depreCat.addCustomerParam("cat" + catCount, ((FaCatInfo)cat[catCount]).getId().toString());
            }
            if (depreAccount.getValues().size() <= i || depreAccount.getCustomerParam("account" + i) == null) continue;
            catMap.putMe("DEPRE_" + depreAccount.getCustomerParam("account" + i).toString(), depreCat);
        }
        CustomerParams accountMap = new CustomerParams();
        accountMap.putMe("ASSET", assetAccount);
        accountMap.putMe("DECVALUE", decAccount);
        accountMap.putMe("DEPRE", depreAccount);
        if (this.chbUseCat.getSelected() != 32) {
            catMap.getCustomerParamsHashMap().clear();
        }
        filter.put(AccountMap_Key, (Object)accountMap);
        filter.put(CatMap_Key, (Object)catMap);
        filter.put(IsIncludeUnposted_Key, (Object)(this.chbHasNotVoucher.getSelected() == 32 ? 1 : 0));
        filter.put(IsDefaultSolution_Key, (Object)(this.chbDefault.getSelected() == 32 ? 1 : 0));
        filter.put(IsUseEvaValue_Key, (Object)(this.chbUseEvaValue.getSelected() == 32 ? 1 : 0));
        filter.put(IsUseCatNumber_Key, (Object)(this.chbUseCat.getSelected() == 32 ? 1 : 0));
        filter.put(IsUseCardAcct_Key, (Object)(this.chbUseCardAcct.getSelected() == 32 ? 1 : 0));
        CustomerParams serializObj = new CustomerParams();
        serializObj.putMe(AccountMap_Key, accountMap);
        serializObj.putMe(CatMap_Key, catMap);
        serializObj.putBoolean(IsIncludeUnposted_Key, this.chbHasNotVoucher.isSelected());
        serializObj.putBoolean(IsDefaultSolution_Key, this.chbDefault.isSelected());
        serializObj.putBoolean(IsUseEvaValue_Key, this.chbUseEvaValue.isSelected());
        serializObj.putBoolean(IsUseCatNumber_Key, this.chbUseCat.isSelected());
        serializObj.putBoolean(IsUseCardAcct_Key, this.chbUseCardAcct.isSelected());
        return serializObj;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
        if (((AbstractButton)e.getSource()).getName().endsWith("_Asset")) {
            this.assetTable.addRow();
        }
        if (((AbstractButton)e.getSource()).getName().endsWith("_Dec")) {
            this.decTable.addRow();
        }
        if (((AbstractButton)e.getSource()).getName().endsWith("_Depre")) {
            this.depreTable.addRow();
        }
    }

    @Override
    public void actionDelLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelLine_actionPerformed(e);
        if (((AbstractButton)e.getSource()).getName().endsWith("_Asset")) {
            this.removeLine(this.assetTable);
        }
        if (((AbstractButton)e.getSource()).getName().endsWith("_Dec")) {
            this.removeLine(this.decTable);
        }
        if (((AbstractButton)e.getSource()).getName().endsWith("_Depre")) {
            this.removeLine(this.depreTable);
        }
    }

    protected void removeLine(KDTable table) {
        if (table.getSelectManager().size() == 0 || this.isTableColumnSelected(table)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        int top = table.getSelectManager().get().getTop();
        if (table.getRow(top) == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        table.removeRow(top);
    }

    private boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    public boolean verify() {
        Object[] cat;
        int i;
        AccountViewInfo accountI = null;
        AccountViewInfo account0 = null;
        boolean hasChildren = false;
        boolean useCat = this.chbUseCat.getSelected() == 32;
        String strAccount = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"strAccount");
        String notFitPeriod = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"notFitPeriod");
        String cuID = this.getCurrCompany().getId().toString();
        AccountClientUtils.checkCompanyAccountTable(null, (CompanyOrgUnitInfo)this.getCurrCompany());
        String acctTableID = this.getCurrCompany().getAccountTable().getId().toString();
        try {
            acctTableID = AccountTools.getCurrentAcctTable((String)cuID, (String)acctTableID, (int)this.getCurrPeriod().getPeriodYear(), (int)this.getCurrPeriod().getPeriodNumber());
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        StringBuffer errInfo = new StringBuffer();
        for (i = 0; i < this.assetTable.getRowCount(); ++i) {
            if (this.assetTable.getRow(i).getCell("account").getValue() != null) {
                accountI = (AccountViewInfo)this.assetTable.getRow(i).getCell("account").getValue();
                account0 = (AccountViewInfo)this.assetTable.getRow(0).getCell("account").getValue();
                if (!accountI.getAccountTableID().getId().toString().equals(acctTableID)) {
                    errInfo.append("\uff1b").append(strAccount).append(accountI.getNumber());
                    errInfo.append("(").append(accountI.getName()).append(")").append(notFitPeriod);
                }
                if (account0 == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"224_FaContrastSolutionUI"));
                    return false;
                }
                if (accountI.getDC() != account0.getDC()) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"CommonQueryDialogWithoutToolBar_AssetAccountPropertyError"));
                    return false;
                }
            } else if (useCat) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"FaContrastUI_UseCatErr_accountNull"));
                return false;
            }
            cat = (Object[])this.assetTable.getRow(i).getCell("cat").getValue();
            hasChildren = hasChildren || this.hasChildren(cat);
        }
        for (i = 0; i < this.decTable.getRowCount(); ++i) {
            if (this.decTable.getRow(i).getCell("account").getValue() != null) {
                accountI = (AccountViewInfo)this.decTable.getRow(i).getCell("account").getValue();
                account0 = (AccountViewInfo)this.decTable.getRow(0).getCell("account").getValue();
                if (!accountI.getAccountTableID().getId().toString().equals(acctTableID)) {
                    errInfo.append("\uff1b").append(strAccount).append(accountI.getNumber());
                    errInfo.append("(").append(accountI.getName()).append(")").append(notFitPeriod);
                }
                if (accountI.getDC() != account0.getDC()) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"CommonQueryDialogWithoutToolBar_DecAccountPropertyError"));
                    return false;
                }
            } else if (useCat) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"FaContrastUI_UseCatErr_accountNull"));
                return false;
            }
            cat = (Object[])this.decTable.getRow(i).getCell("cat").getValue();
            hasChildren = hasChildren || this.hasChildren(cat);
        }
        for (i = 0; i < this.depreTable.getRowCount(); ++i) {
            if (this.depreTable.getRow(i).getCell("account").getValue() != null) {
                accountI = (AccountViewInfo)this.depreTable.getRow(i).getCell("account").getValue();
                account0 = (AccountViewInfo)this.depreTable.getRow(0).getCell("account").getValue();
                if (!accountI.getAccountTableID().getId().toString().equals(acctTableID)) {
                    errInfo.append("\uff1b").append(strAccount).append(accountI.getNumber());
                    errInfo.append("(").append(accountI.getName()).append(")").append(notFitPeriod);
                }
                if (accountI.getDC() != account0.getDC()) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"CommonQueryDialogWithoutToolBar_DepreAccountPropertyError"));
                    return false;
                }
            } else if (useCat) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"FaContrastUI_UseCatErr_accountNull"));
                return false;
            }
            cat = (Object[])this.depreTable.getRow(i).getCell("cat").getValue();
            hasChildren = hasChildren || this.hasChildren(cat);
        }
        if (errInfo.length() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)errInfo.substring(1));
            return false;
        }
        return !hasChildren || MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"FaContrastUI_catConfirm")) != 2;
    }

    private boolean hasChildren(Object[] catArray) {
        if (catArray == null) {
            return false;
        }
        for (int i = 0; i < catArray.length; ++i) {
            FaCatInfo catInfo1 = (FaCatInfo)catArray[i];
            for (int j = 0; j < catArray.length; ++j) {
                if (j == i) continue;
                FaCatInfo catInfo2 = (FaCatInfo)catArray[j];
                if (catInfo1.getLongNumber().indexOf(catInfo2.getLongNumber() + "!") <= -1) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void btnNew_actionPerformed(ActionEvent e) throws Exception {
        this.newContrastSolution();
    }

    protected void newContrastSolution() {
        this.resetSolution();
        this.btnDel.setEnabled(false);
        this.setCurrSolutionInfo(null);
        if (this.tree.getTree() != null) {
            this.tree.getTree().setSelectionNode(null);
        }
    }

    protected void resetSolution() {
        this.assetTable.removeRows();
        this.depreTable.removeRows();
        this.decTable.removeRows();
        this.chbUseEvaValue.setSelected(false);
        this.chbHasNotVoucher.setSelected(false);
        this.chbDefault.setSelected(false);
        this.chbUseCat.setSelected(false);
        this.chbUseCardAcct.setSelected(false);
    }

    @Override
    protected void btnSave_actionPerformed(ActionEvent e) throws Exception {
        this.saveContrastSolution(false);
    }

    @Override
    protected void btnSaveAs_actionPerformed(ActionEvent e) throws Exception {
        this.saveContrastSolution(true);
    }

    protected void saveContrastSolution(boolean isNewSolution) throws Exception {
        if (this.verify()) {
            if (!this.canSave(isNewSolution)) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"CommonQueryDialogWithoutToolBar_HasDefault"));
                return;
            }
            if (isNewSolution) {
                if (this.showSolutionDialog()) {
                    if (this.isExistsSameNameSolution()) {
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaContrastResource", (String)"SolutionNameExists"));
                        return;
                    }
                    this.addSolution();
                }
            } else if (this.getCurrSolutionInfo() == null || this.getCurrSolutionInfo().getId() == null) {
                if (this.showSolutionDialog()) {
                    if (this.isExistsSameNameSolution()) {
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaContrastResource", (String)"SolutionNameExists"));
                        return;
                    }
                    this.addSolution();
                }
            } else {
                this.saveSolution();
            }
            this.refreshSolutionList();
        }
    }

    private String getCurrSolutionName() {
        return this.currentSolutionName;
    }

    private void setCurrSolutionName(String name) {
        this.currentSolutionName = name;
    }

    private void setCurrSolutionInfo(FaContrastSolutionInfo info) {
        this.currSolutionInfo = info;
    }

    public FaContrastSolutionInfo getCurrSolutionInfo() {
        return this.currSolutionInfo;
    }

    private boolean canSave(boolean isNewSolution) throws Exception {
        boolean isDefaultSolution = this.chbDefault.isSelected();
        if (!isDefaultSolution) {
            return true;
        }
        CoreBaseCollection solutionColl = this.getSolutionCollection();
        for (int i = 0; i < solutionColl.size(); ++i) {
            FaContrastSolutionInfo solution = (FaContrastSolutionInfo)solutionColl.get(i);
            if (!isNewSolution && this.getCurrSolutionInfo() != null && this.getCurrSolutionInfo().getId() != null && this.getCurrSolutionInfo().getId().toString().equalsIgnoreCase(solution.getId().toString())) continue;
            boolean savedIsDefaultSolution = false;
            if (solution != null && solution.getParams() != null) {
                CustomerParams savedLoadInfo = XMLBean.TransStrToCustParams((String)solution.getParams());
                savedIsDefaultSolution = savedLoadInfo.getBoolean(IsDefaultSolution_Key);
            }
            if (!isDefaultSolution || !savedIsDefaultSolution) continue;
            return false;
        }
        return true;
    }

    private boolean showSolutionDialog() throws UIException {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.fa.manage.client.FaSolutionSaveAsPromptUI", (Map)uiContext, null, null);
        FaSolutionSaveAsPromptUI promptUI = (FaSolutionSaveAsPromptUI)uiWindow.getUIObject();
        uiWindow.show();
        if (!promptUI.isOK()) {
            return false;
        }
        this.setCurrSolutionName(promptUI.getSchemaName());
        return true;
    }

    private boolean isExistsSameNameSolution() {
        String orgID = this.getCurrCompany().getId().toString();
        String saveName = this.getCurrSolutionName();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("orgID", (Object)orgID));
        filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)saveName));
        boolean result = false;
        try {
            result = this.getBizInterface().exists(filterInfo);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return result;
    }

    private void addSolution() throws EASBizException, BOSException {
        FaContrastSolutionInfo solution = new FaContrastSolutionInfo();
        solution.setName(this.getCurrSolutionName());
        solution.setOrgID(this.getCurrCompany().getId().toString());
        solution.setOwnerID(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        String customerParams = null;
        CustomerParams custParams = this.getFilterInfo();
        if (custParams != null) {
            Collection keys = custParams.getKeys();
            Collection values = custParams.getValues();
            if (keys.size() > 0) {
                try {
                    customerParams = XMLBean.CreateXMLStrRecursion((Collection)keys, (Collection)values);
                }
                catch (Exception ex) {
                    MsgBox.showInfo((String)ex.getMessage());
                }
            }
        }
        solution.setParams(customerParams);
        IObjectPK objectPK = this.getBizInterface().save((CoreBaseInfo)solution);
        solution.setId(BOSUuid.read((String)objectPK.toString()));
        this.setCurrSolutionInfo(solution);
    }

    private void saveSolution() throws EASBizException, BOSException {
        FaContrastSolutionInfo solution = this.getCurrSolutionInfo();
        String customerParams = null;
        CustomerParams custParams = this.getFilterInfo();
        if (custParams != null) {
            Collection keys = custParams.getKeys();
            Collection values = custParams.getValues();
            if (keys.size() > 0) {
                try {
                    customerParams = XMLBean.CreateXMLStrRecursion((Collection)keys, (Collection)values);
                }
                catch (Exception ex) {
                    MsgBox.showInfo((String)ex.getMessage());
                }
            }
        }
        solution.setParams(customerParams);
        this.getBizInterface().update((IObjectPK)new ObjectUuidPK(solution.getId().toString()), (CoreBaseInfo)solution);
        this.setCurrSolutionInfo(solution);
    }

    protected void refreshSolutionList() throws EASBizException, Exception {
        CoreBaseCollection solutionColls = this.getSolutionCollection();
        this.btnDel.setEnabled(solutionColls.size() > 0);
        Locale loc = SysContext.getSysContext().getLocale();
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"root");
        for (int i = 0; i < solutionColls.size(); ++i) {
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)solutionColls.get(i));
            node.setText(((FaContrastSolutionInfo)solutionColls.get(i)).getName(loc));
            node.setChecked(false);
            node.setCustomIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
            root.add((MutableTreeNode)node);
        }
        KingdeeTreeModel model = new KingdeeTreeModel((TreeNode)root);
        KDTree tt = new KDTree((TreeModel)model);
        tt.setRootVisible(false);
        this.tree.setTree(tt);
        tt.setShowCheckBox(false);
        tt.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = e.getNewLeadSelectionPath();
                FaContrastSolutionUI.this.btnDel.setEnabled(path != null);
                if (path != null) {
                    FaContrastSolutionInfo solution = (FaContrastSolutionInfo)((DefaultKingdeeTreeNode)path.getLastPathComponent()).getUserObject();
                    try {
                        if (FaContrastSolutionUI.this.currSolutionInfo != null && FaContrastSolutionUI.this.currSolutionInfo.getId() != null && FaContrastSolutionUI.this.currSolutionInfo.getId().equals((Object)solution.getId())) {
                            return;
                        }
                        FaContrastSolutionUI.this.setCurrSolutionInfo(solution);
                        if (solution.getParams() != null) {
                            FaContrastSolutionUI.this.setSolution(FaContrastSolutionUI.this.loadSolution(solution.getId().toString()));
                        }
                        ((DefaultKingdeeTreeNode)path.getLastPathComponent()).setChecked(true);
                        FaContrastSolutionUI.this.btnDel.setEnabled(true);
                        FaContrastSolutionUI.this.btnSave.setEnabled(true);
                    }
                    catch (Exception ex) {
                        FaContrastSolutionUI.this.handUIException(ex);
                    }
                }
            }
        });
        if (solutionColls.size() == 0) {
            return;
        }
        DefaultKingdeeTreeNode treeRoot = (DefaultKingdeeTreeNode)this.tree.getTree().getModel().getRoot();
        FaContrastSolutionInfo cc = null;
        if (this.getCurrSolutionInfo() == null) {
            this.btnDel.setEnabled(false);
            this.btnSave.setEnabled(false);
            return;
        }
        this.btnDel.setEnabled(true);
        this.btnSave.setEnabled(true);
        int n = treeRoot.getChildCount();
        for (int i = 0; i < n; ++i) {
            cc = (FaContrastSolutionInfo)((DefaultKingdeeTreeNode)treeRoot.getChildAt(i)).getUserObject();
            if (!cc.getId().equals((Object)this.getCurrSolutionInfo().getId())) continue;
            this.tree.getTree().setSelectionNode((DefaultKingdeeTreeNode)treeRoot.getChildAt(i));
            break;
        }
    }

    private CoreBaseCollection getSolutionCollection() throws BOSException {
        String orgID = this.getCurrCompany().getId().toString();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("orgID", (Object)orgID));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfo);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.getSorter().add(new SorterItemInfo("name"));
        view.setSorter(sorter);
        return this.getBizInterface().getCollection(view);
    }

    protected FaContrastSolutionInfo loadSolution(String Id) throws EASBizException, BOSException {
        return (FaContrastSolutionInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(Id));
    }

    protected void setSolution(FaContrastSolutionInfo solution) throws Exception {
        CustomerParams loadInfo = XMLBean.TransStrToCustParams((String)solution.getParams());
        if (loadInfo != null) {
            this.fillTable(loadInfo);
            boolean isIncludeUnposted = loadInfo.getBoolean(IsIncludeUnposted_Key);
            this.chbHasNotVoucher.setSelected(isIncludeUnposted);
            boolean isDefaultSolution = loadInfo.getBoolean(IsDefaultSolution_Key);
            this.chbDefault.setSelected(isDefaultSolution);
            boolean isUseEvaValue = loadInfo.getBoolean(IsUseEvaValue_Key);
            this.chbUseEvaValue.setSelected(isUseEvaValue);
            boolean isUseCat = loadInfo.getBoolean(IsUseCatNumber_Key);
            this.chbUseCat.setSelected(isUseCat);
            boolean isUseCardAcct = loadInfo.getBoolean(IsUseCardAcct_Key);
            this.chbUseCardAcct.setSelected(isUseCardAcct);
            this.changeContrastType(isUseCat);
        }
    }

    private void fillTable(CustomerParams loadInfo) {
        CustomerParams accountMap = loadInfo.getMe(AccountMap_Key);
        CustomerParams catMap = loadInfo.getMe(CatMap_Key);
        if (accountMap == null && catMap == null) {
            return;
        }
        if (accountMap.getMe("ASSET") == null || accountMap.getMe("ASSET").getCustomerParamsHashMap() == null || accountMap.getMe("DECVALUE") == null || accountMap.getMe("DECVALUE").getCustomerParamsHashMap() == null || accountMap.getMe("DEPRE") == null || accountMap.getMe("DEPRE").getCustomerParamsHashMap() == null) {
            return;
        }
        TreeSet<String> assetKeySet = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return Integer.valueOf(o1.substring(7)).compareTo(Integer.valueOf(o2.substring(7)));
            }
        });
        assetKeySet.addAll(new TreeSet(accountMap.getMe("ASSET").getCustomerParamsHashMap().keySet()));
        TreeSet<String> decvalueKeySet = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return Integer.valueOf(o1.substring(7)).compareTo(Integer.valueOf(o2.substring(7)));
            }
        });
        decvalueKeySet.addAll(new TreeSet(accountMap.getMe("DECVALUE").getCustomerParamsHashMap().keySet()));
        TreeSet<String> depreKeySet = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return Integer.valueOf(o1.substring(7)).compareTo(Integer.valueOf(o2.substring(7)));
            }
        });
        depreKeySet.addAll(new TreeSet(accountMap.getMe("DEPRE").getCustomerParamsHashMap().keySet()));
        IRow row = null;
        this.assetTable.removeRows();
        this.decTable.removeRows();
        this.depreTable.removeRows();
        try {
            Iterator tmpItem;
            int i;
            String value;
            int i2;
            IAccountView iAccount = AccountViewFactory.getRemoteInstance();
            HashMap<String, AccountViewInfo> accountInfoMap = new HashMap<String, AccountViewInfo>();
            HashSet<String> accountIdSet = new HashSet<String>();
            for (i2 = 0; i2 < assetKeySet.size(); ++i2) {
                value = (String)accountMap.getMe("ASSET").getCustomerParamsHashMap().get(assetKeySet.toArray()[i2]);
                accountIdSet.add(value);
            }
            for (i2 = 0; i2 < decvalueKeySet.size(); ++i2) {
                value = (String)accountMap.getMe("DECVALUE").getCustomerParamsHashMap().get(decvalueKeySet.toArray()[i2]);
                accountIdSet.add(value);
            }
            for (i2 = 0; i2 < depreKeySet.size(); ++i2) {
                value = (String)accountMap.getMe("DEPRE").getCustomerParamsHashMap().get(depreKeySet.toArray()[i2]);
                accountIdSet.add(value);
            }
            if (accountIdSet.size() > 0) {
                EntityViewInfo v = new EntityViewInfo();
                FilterInfo f = new FilterInfo();
                v.setFilter(f);
                f.getFilterItems().add(new FilterItemInfo("id", accountIdSet, CompareType.INCLUDE));
                AccountViewCollection accounts = iAccount.getAccountViewCollection(v);
                for (int i3 = 0; i3 < accounts.size(); ++i3) {
                    accountInfoMap.put(accounts.get(i3).getId().toString(), accounts.get(i3));
                }
            }
            IFaCat faCat = FaCatFactory.getRemoteInstance();
            String ids = "";
            for (i = 0; i < assetKeySet.size(); ++i) {
                row = this.assetTable.addRow();
                String value2 = (String)accountMap.getMe("ASSET").getCustomerParamsHashMap().get(assetKeySet.toArray()[i]);
                row.getCell("account").setValue(accountInfoMap.get(value2));
                if (catMap == null || catMap.getMe("ASSET_" + value2) == null) continue;
                Collection assetCat = catMap.getMe("ASSET_" + value2).getValues();
                ids = "";
                tmpItem = assetCat.iterator();
                while (tmpItem.hasNext()) {
                    ids = ids + ",'" + tmpItem.next().toString() + "'";
                }
                row.getCell("cat").setValue((Object)faCat.getCollection("select id,name,number,longnumber where id in (" + ids.substring(1) + ")").toArray());
            }
            for (i = 0; i < decvalueKeySet.size(); ++i) {
                row = this.decTable.addRow();
                String value3 = (String)accountMap.getMe("DECVALUE").getCustomerParamsHashMap().get(decvalueKeySet.toArray()[i]);
                row.getCell("account").setValue(accountInfoMap.get(value3));
                if (catMap == null || catMap.getMe("DECVALUE_" + value3) == null) continue;
                Collection decCat = catMap.getMe("DECVALUE_" + value3).getValues();
                ids = "";
                tmpItem = decCat.iterator();
                while (tmpItem.hasNext()) {
                    ids = ids + ",'" + tmpItem.next().toString() + "'";
                }
                row.getCell("cat").setValue((Object)faCat.getCollection("select id,name,number,longnumber where id in (" + ids.substring(1) + ")").toArray());
            }
            for (i = 0; i < depreKeySet.size(); ++i) {
                row = this.depreTable.addRow();
                String value4 = (String)accountMap.getMe("DEPRE").getCustomerParamsHashMap().get(depreKeySet.toArray()[i]);
                row.getCell("account").setValue(accountInfoMap.get(value4));
                if (catMap == null || catMap.getMe("DEPRE_" + value4) == null) continue;
                Collection depreCat = catMap.getMe("DEPRE_" + value4).getValues();
                ids = "";
                tmpItem = depreCat.iterator();
                while (tmpItem.hasNext()) {
                    ids = ids + ",'" + tmpItem.next().toString() + "'";
                }
                row.getCell("cat").setValue((Object)faCat.getCollection("select id,name,number,longnumber where id in (" + ids.substring(1) + ")").toArray());
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    protected void btnDel_actionPerformed(ActionEvent e) throws Exception {
        if (MsgBox.showConfirm2((Component)((Object)this), (String)GLResUtil.getRes((String)"confirm_del_schema")) == 0) {
            this.delContrastSolution();
        }
    }

    protected void delContrastSolution() throws Exception {
        if (this.getCurrSolutionInfo().getId() != null) {
            this.getBizInterface().delete((IObjectPK)new ObjectUuidPK(this.getCurrSolutionInfo().getId()));
            this.setCurrSolutionInfo(null);
            this.refreshSolutionList();
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.getCurrSolutionInfo() == null) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaContrastResource", (String)"Solution_Is_NotNull");
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            return;
        }
        this.setCanceled(false);
        this.disposeUIWindow();
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        this.setCanceled(true);
        this.disposeUIWindow();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean b) {
        this.isCanceled = b;
    }
}

