/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.AddressFactory;
import com.kingdee.eas.basedata.assistant.AddressInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.FaAlterModeFactory;
import com.kingdee.eas.fi.fa.basedata.FaAlterModeInfo;
import com.kingdee.eas.fi.fa.basedata.FaCatFactory;
import com.kingdee.eas.fi.fa.basedata.FaCatInfo;
import com.kingdee.eas.fi.fa.basedata.FaUseStatusFactory;
import com.kingdee.eas.fi.fa.basedata.FaUseStatusInfo;
import com.kingdee.eas.fi.fa.basedata.client.FaAlterModePromptBox;
import com.kingdee.eas.fi.fa.basedata.client.FaCatPromptBox;
import com.kingdee.eas.fi.fa.basedata.client.FaDisplyFormatter;
import com.kingdee.eas.fi.fa.basedata.client.FaEditFormatter;
import com.kingdee.eas.fi.fa.basedata.client.FaUseStatusPromptBox;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaCurCardFilterUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.rpt.FaListFactory;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.Date;
import java.util.HashMap;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FaCurCardFilterUI
extends AbstractFaCurCardFilterUI
implements ChangeListener {
    private static final long serialVersionUID = -3276018491452881075L;
    private CompanyOrgUnitInfo aCompanyOrgUnitInfo = null;
    private HashMap periodCollection = new HashMap();
    private PeriodInfo currPeriod = null;
    private PeriodInfo startPeriod = null;
    private boolean isLoadData = false;
    private Integer minPeriodYear;
    private Integer maxPeriodYear;
    private Integer minPeriodStartNumber;
    private Integer maxPerioEndNumber;

    public FaCurCardFilterUI(CompanyOrgUnitInfo currentCompanyInfo) throws Exception {
        this.aCompanyOrgUnitInfo = currentCompanyInfo;
        if (this.aCompanyOrgUnitInfo == null) {
            this.aCompanyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        }
        FaClientUtils.checkComp(null, this.aCompanyOrgUnitInfo);
        FaClientUtils.checkFaInit((Component)new CoreUI(), this.aCompanyOrgUnitInfo);
        this.currPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.aCompanyOrgUnitInfo);
        if (this.currPeriod == null) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardInitResource.FaCardPeriodIsNull");
            MsgBox.showInfo((Component)((Object)this), (String)strMsg);
            SysUtil.abort();
        }
        this.addListener();
        this.initControl();
        this.startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.aCompanyOrgUnitInfo);
        SpinnerNumberModel yearMinNumberModel = new SpinnerNumberModel();
        yearMinNumberModel.setMinimum(new Integer(this.startPeriod.getPeriodYear()));
        yearMinNumberModel.setMaximum(new Integer(this.currPeriod.getPeriodYear()));
        SpinnerNumberModel yearMaxNumberModel = new SpinnerNumberModel();
        yearMaxNumberModel.setMinimum(new Integer(this.startPeriod.getPeriodYear()));
        yearMaxNumberModel.setMaximum(new Integer(this.currPeriod.getPeriodYear()));
        this.minPeriodYear = this.startPeriod.getPeriodYear();
        this.maxPeriodYear = this.currPeriod.getPeriodYear();
        this.minPeriodStartNumber = this.startPeriod.getPeriodNumber();
        this.maxPerioEndNumber = this.currPeriod.getPeriodNumber();
        this.sldYearFrom.setModel((SpinnerModel)yearMinNumberModel);
        this.sldYearTo.setModel((SpinnerModel)yearMaxNumberModel);
        this.sldYearFrom.setValue((Object)new Integer(this.currPeriod.getPeriodYear()));
        this.sldYearTo.setValue((Object)new Integer(this.currPeriod.getPeriodYear()));
        this.sldPeriodFrom.setValue((Object)new Integer(this.currPeriod.getPeriodNumber()));
        this.sldPeriodTo.setValue((Object)new Integer(this.currPeriod.getPeriodNumber()));
        this.dtDateFrom.setValue((Object)this.currPeriod.getBeginDate());
        this.dtDateTo.setValue((Object)this.currPeriod.getEndDate());
        PeriodCollection periods = PeriodFactory.getRemoteInstance().getPeriodCollection("where periodType.id='" + this.aCompanyOrgUnitInfo.getAccountPeriodType().getId() + "' and periodYear>=" + this.startPeriod.getPeriodYear());
        for (int i = 0; i < periods.size(); ++i) {
            PeriodInfo period = periods.get(i);
            this.periodCollection.put(period.getPeriodYear() + "" + period.getPeriodNumber(), period);
        }
    }

    @Override
    protected void rbnByPeriod_itemStateChanged(ItemEvent evt) throws Exception {
        this.rbnByPeriodSelected(evt);
    }

    protected void rbnByPeriodSelected(ItemEvent evt) {
        boolean byPeriod = evt.getStateChange() == 1;
        this.labConYearFrom.setVisible(byPeriod);
        this.labConYearTo.setVisible(byPeriod);
        this.labConPeriodFrom.setVisible(byPeriod);
        this.labConPeriodTo.setVisible(byPeriod);
        this.labPeriodFrom.setVisible(byPeriod);
        this.labPeriodTo.setVisible(byPeriod);
        this.labConDateFrom.setVisible(!byPeriod);
        this.labConDateTo.setVisible(!byPeriod);
    }

    public FilterInfo getFilterInfo() {
        FilterItemInfo audited;
        FilterItemInfo templateFilterItemInfo;
        StringBuffer sbFormula = new StringBuffer();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        int i = 0;
        CustomerParams periodMap = new CustomerParams();
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        if (aCompanyOrgUnitInfo != null && aCompanyOrgUnitInfo.getId() != null) {
            FilterItemInfo companyFilterItemInfo = new FilterItemInfo("company.id", (Object)aCompanyOrgUnitInfo.getId().toString());
            items.add(companyFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.bizPromptFaCat.getData() != null) {
            templateFilterItemInfo = new FilterItemInfo("assetCat.id", (Object)((FaCatInfo)this.bizPromptFaCat.getData()).getId().toString());
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.txtNumberFrom.getText() != null && this.txtNumberFrom.getText().trim().length() > 0) {
            templateFilterItemInfo = new FilterItemInfo("number", (Object)this.txtNumberFrom.getText().trim(), CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.txtNumberTo.getText() != null && this.txtNumberTo.getText().trim().length() > 0) {
            templateFilterItemInfo = new FilterItemInfo("number", (Object)this.txtNumberTo.getText().trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.bizPromptFaAlterMode.getData() != null) {
            templateFilterItemInfo = new FilterItemInfo("originMethod.id", (Object)((FaAlterModeInfo)this.bizPromptFaAlterMode.getData()).getId().toString());
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.bizPromptFaUseStatus.getData() != null) {
            templateFilterItemInfo = new FilterItemInfo("useStatus.id", (Object)((FaUseStatusInfo)this.bizPromptFaUseStatus.getData()).getId().toString());
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.bizPromptStoreCity.getData() != null) {
            templateFilterItemInfo = new FilterItemInfo("storeCity.id", (Object)((AddressInfo)this.bizPromptStoreCity.getData()).getId().toString());
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.rbnByPeriod.isSelected()) {
            periodMap.putBoolean("byperiod", Boolean.TRUE.booleanValue());
            FilterItemInfo tempFilterItemInfo = new FilterItemInfo("originFlag", (Object)new Integer(0), CompareType.NOTEQUALS);
            items.add(tempFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
            if (this.sldPeriodFrom.getValue() != null) {
                int yearFrom = this.sldYearFrom.getIntegerVlaue();
                int numberFrom = this.sldPeriodFrom.getIntegerVlaue();
                periodMap.putInt("period.periodYearFrom", yearFrom);
                periodMap.putInt("period.periodNumberFrom", numberFrom);
                int startPeriodNumber = this.getPeriodNumber(yearFrom, numberFrom);
                FilterItemInfo startPeriod = new FilterItemInfo("period.number", (Object)new Integer(startPeriodNumber), CompareType.GREATER_EQUALS);
                items.add(startPeriod);
                if (i == 0) {
                    sbFormula.append(" #" + i++ + " ");
                } else {
                    sbFormula.append(" and #" + i++ + " ");
                }
            }
            if (this.sldPeriodTo.getValue() != null) {
                int yearTo = this.sldYearTo.getIntegerVlaue();
                int numberTo = this.sldPeriodTo.getIntegerVlaue();
                periodMap.putInt("period.periodYearTo", yearTo);
                periodMap.putInt("period.periodNumberTo", numberTo);
                int toPeriodNumber = this.getPeriodNumber(yearTo, numberTo);
                FilterItemInfo endPeriod = new FilterItemInfo("period.number", (Object)new Integer(toPeriodNumber), CompareType.LESS_EQUALS);
                items.add(endPeriod);
                if (i == 0) {
                    sbFormula.append(" #" + i++ + " ");
                } else {
                    sbFormula.append(" and #" + i++ + " ");
                }
            }
        } else {
            periodMap.putBoolean("byperiod", Boolean.FALSE.booleanValue());
            String queryDate = this.rbnByDate.isSelected() ? "accountDate" : "fiAccountDate";
            periodMap.putBoolean("bydate", this.rbnByDate.isSelected());
            if (this.dtDateFrom.isEnabled() && this.dtDateFrom.getTimestamp() != null) {
                Date date = DateTimeUtils.truncateDate((Date)this.dtDateFrom.getTimestamp());
                FilterItemInfo startDate = new FilterItemInfo(queryDate, (Object)date, CompareType.GREATER_EQUALS);
                items.add(startDate);
                if (i == 0) {
                    sbFormula.append("#" + i++);
                } else {
                    sbFormula.append(" and #" + i++);
                }
            }
            if (this.dtDateTo.isEnabled() && this.dtDateTo.getTimestamp() != null) {
                long date2Ms = DateTimeUtils.truncateDate((Date)((Date)this.dtDateTo.getValue())).getTime() + 86400000L - 1L;
                Date date = new Date(date2Ms);
                FilterItemInfo endDate = new FilterItemInfo(queryDate, (Object)date, CompareType.LESS_EQUALS);
                items.add(endDate);
                if (i == 0) {
                    sbFormula.append("#" + i++);
                } else {
                    sbFormula.append(" and #" + i++);
                }
            }
        }
        if (this.rbnAudited.isSelected()) {
            audited = new FilterItemInfo("checkedStatus", (Object)new Integer(2));
            items.add(audited);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        } else if (this.rbnUnAudit.isSelected()) {
            FilterItemInfo unAudited = new FilterItemInfo("checkedStatus", (Object)new Integer(1));
            items.add(unAudited);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (!this.chkBox.isSelected()) {
            audited = new FilterItemInfo("deletedStatus", (Object)new Integer(2), CompareType.NOTEQUALS);
            items.add(audited);
            if (i == 0) {
                sbFormula.append("# " + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (sbFormula.toString().length() != 0) {
            filter.setMaskString(sbFormula.toString());
        }
        this.setCustomerParams(periodMap);
        return filter;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.clear();
        this.isLoadData = true;
        boolean isDelete = false;
        boolean existBeginAccountDate = false;
        boolean existEndAccountDate = false;
        try {
            Object startDate;
            FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter().getFilterItems();
            if (currentFilterItemCollection == null || currentFilterItemCollection.size() == 0) {
                return;
            }
            int currentFilterItemCollectionSize = currentFilterItemCollection.size();
            for (int i = 0; i < currentFilterItemCollectionSize; ++i) {
                String number;
                SelectorItemCollection sic;
                ObjectStringPK pk;
                String assetCatId;
                FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
                if (filterItemInfo.getPropertyName().equals("assetCat.id")) {
                    assetCatId = filterItemInfo.getCompareValue().toString();
                    pk = new ObjectStringPK();
                    sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("number"));
                    sic.add(new SelectorItemInfo("name"));
                    sic.add(new SelectorItemInfo("isLeaf"));
                    pk.setKeyValue("id", (Object)assetCatId);
                    this.bizPromptFaCat.setData((Object)FaCatFactory.getRemoteInstance().getFaCatInfo((IObjectPK)pk, sic));
                }
                if (filterItemInfo.getPropertyName().equals("number") && filterItemInfo.getCompareType().getName().equals(CompareType.GREATER_EQUALS.getName())) {
                    number = filterItemInfo.getCompareValue().toString();
                    this.txtNumberFrom.setText(number);
                }
                if (filterItemInfo.getPropertyName().equals("number") && filterItemInfo.getCompareType().getName().equals(CompareType.LESS_EQUALS.getName())) {
                    number = filterItemInfo.getCompareValue().toString();
                    this.txtNumberTo.setText(number);
                }
                if (filterItemInfo.getPropertyName().equals("originMethod.id")) {
                    assetCatId = filterItemInfo.getCompareValue().toString();
                    pk = new ObjectStringPK();
                    sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("number"));
                    sic.add(new SelectorItemInfo("name"));
                    sic.add(new SelectorItemInfo("isLeaf"));
                    pk.setKeyValue("id", (Object)assetCatId);
                    this.bizPromptFaAlterMode.setData((Object)FaAlterModeFactory.getRemoteInstance().getFaAlterModeInfo((IObjectPK)pk, sic));
                }
                if (filterItemInfo.getPropertyName().equals("useStatus.id")) {
                    assetCatId = filterItemInfo.getCompareValue().toString();
                    pk = new ObjectStringPK();
                    sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("number"));
                    sic.add(new SelectorItemInfo("name"));
                    sic.add(new SelectorItemInfo("isLeaf"));
                    pk.setKeyValue("id", (Object)assetCatId);
                    this.bizPromptFaUseStatus.setData((Object)FaUseStatusFactory.getRemoteInstance().getFaUseStatusInfo((IObjectPK)pk, sic));
                }
                if (filterItemInfo.getPropertyName().equals("storeCity.id")) {
                    assetCatId = filterItemInfo.getCompareValue().toString();
                    pk = new ObjectStringPK();
                    sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("number"));
                    sic.add(new SelectorItemInfo("name"));
                    pk.setKeyValue("id", (Object)assetCatId);
                    this.bizPromptStoreCity.setData((Object)AddressFactory.getRemoteInstance().getAddressInfo((IObjectPK)pk, sic));
                }
                if ((filterItemInfo.getPropertyName().equals("accountDate") || filterItemInfo.getPropertyName().equals("fiAccountDate")) && filterItemInfo.getCompareType().getName().equals(CompareType.GREATER_EQUALS.getName())) {
                    startDate = filterItemInfo.getCompareValue();
                    this.dtDateFrom.setValue(startDate);
                    existBeginAccountDate = true;
                }
                if ((filterItemInfo.getPropertyName().equals("accountDate") || filterItemInfo.getPropertyName().equals("fiAccountDate")) && filterItemInfo.getCompareType().getName().equals(CompareType.LESS_EQUALS.getName())) {
                    Object endDate = filterItemInfo.getCompareValue();
                    this.dtDateTo.setValue(endDate);
                    existEndAccountDate = true;
                }
                if (filterItemInfo.getPropertyName().equals("checkedStatus") && filterItemInfo.getCompareValue() != null) {
                    number = filterItemInfo.getCompareValue().toString();
                    if (Integer.valueOf(number) == 2) {
                        this.rbnAudited.setSelected(true);
                    } else if (Integer.valueOf(number) == 1) {
                        this.rbnUnAudit.setSelected(true);
                    }
                }
                if (filterItemInfo.getPropertyName().equals("checkedStatus") && filterItemInfo.getCompareValue() == null) {
                    this.rbnAll.setSelected(true);
                }
                if (!filterItemInfo.getPropertyName().equals("deletedStatus") || !filterItemInfo.getCompareType().getName().equals(CompareType.NOTEQUALS.getName())) continue;
                isDelete = true;
            }
            if (!existBeginAccountDate) {
                this.dtDateFrom.setValue(null);
            }
            if (!existEndAccountDate) {
                this.dtDateTo.setValue(null);
            }
            this.chkBox.setSelected(!isDelete);
            CustomerParams periodMap = this.getCustomerParams();
            if (periodMap != null) {
                boolean byPeriod = periodMap.getBoolean("byperiod");
                if (byPeriod) {
                    this.rbnByPeriod.setSelected(true);
                } else if (periodMap.getBoolean("bydate")) {
                    this.rbnByDate.setSelected(true);
                } else {
                    this.rbnByFiDate.setSelected(true);
                }
                if (periodMap.getInt("period.periodYearFrom") != 0) {
                    startDate = periodMap.getCustomerParam("period.periodYearFrom");
                    this.sldYearFrom.setValue((Object)new Integer((String)startDate));
                }
                if (periodMap.getInt("period.periodNumberFrom") != 0) {
                    startDate = periodMap.getCustomerParam("period.periodNumberFrom");
                    this.sldPeriodFrom.setValue((Object)new Integer((String)startDate));
                }
                if (periodMap.getInt("period.periodYearTo") != 0) {
                    startDate = periodMap.getCustomerParam("period.periodYearTo");
                    this.sldYearTo.setValue((Object)new Integer((String)startDate));
                }
                if (periodMap.getInt("period.periodNumberTo") != 0) {
                    startDate = periodMap.getCustomerParam("period.periodNumberTo");
                    this.sldPeriodTo.setValue((Object)new Integer((String)startDate));
                }
            }
            this.isLoadData = false;
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    private void addListener() {
        super.initListener();
        this.sldYearFrom.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    FaCurCardFilterUI.this.fireStartYearChange();
                }
                catch (Exception ex) {
                    FaCurCardFilterUI.this.handUIException(ex);
                }
                FaCurCardFilterUI.this.firePeriodChange(e);
            }
        });
        this.sldYearTo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    FaCurCardFilterUI.this.fireEndYearChange();
                }
                catch (Exception ex) {
                    FaCurCardFilterUI.this.handUIException(ex);
                }
                FaCurCardFilterUI.this.firePeriodChange(e);
            }
        });
        this.sldPeriodFrom.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaCurCardFilterUI.this.firePeriodChange(e);
            }
        });
        this.sldPeriodTo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaCurCardFilterUI.this.firePeriodChange(e);
            }
        });
    }

    public void initControl() throws Exception {
        this.pnlAudit.setOpaque(false);
        this.pnlDate.setOpaque(false);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        FilterItemInfo companyFilterItemInfo = new FilterItemInfo("company.id", (Object)aCompanyOrgUnitInfo.getId().toString());
        filterInfo.getFilterItems().add(companyFilterItemInfo);
        viewInfo.setFilter(filterInfo);
        FaCatPromptBox aFaCatPromptBox = new FaCatPromptBox((CoreUIObject)this);
        this.bizPromptFaCat.setSelector((KDPromptSelector)aFaCatPromptBox);
        this.bizPromptFaCat.setDisplayFormatter((IFormatter)new FaDisplyFormatter());
        this.bizPromptFaCat.setEditFormatter((IFormatter)new FaEditFormatter());
        this.bizPromptFaCat.setEditable(true);
        this.bizPromptFaCat.setCommitFormat("$number$");
        this.bizPromptFaCat.setQueryInfo("com.kingdee.eas.fi.fa.basedata.FaCatQuery");
        this.bizPromptFaCat.setEntityViewInfo(viewInfo);
        this.bizPromptFaCat.addChangeListener((ChangeListener)this);
        FaAlterModePromptBox aFaAlterModePromptBox = new FaAlterModePromptBox((CoreUIObject)this);
        this.bizPromptFaAlterMode.setSelector((KDPromptSelector)aFaAlterModePromptBox);
        this.bizPromptFaAlterMode.setDisplayFormatter((IFormatter)new FaDisplyFormatter());
        this.bizPromptFaAlterMode.setEditFormatter((IFormatter)new FaEditFormatter());
        this.bizPromptFaAlterMode.setEditable(true);
        this.bizPromptFaAlterMode.setCommitFormat("$number$");
        this.bizPromptFaAlterMode.setQueryInfo("com.kingdee.eas.fi.fa.basedata.FaAlterModeQuery");
        this.bizPromptFaAlterMode.setEntityViewInfo(FaClientUtils.getAlterModeOrgSplitViewInfo(false));
        this.bizPromptFaAlterMode.addChangeListener((ChangeListener)this);
        FaUseStatusPromptBox aFaUseStatusPromptBox = new FaUseStatusPromptBox((CoreUIObject)this);
        this.bizPromptFaUseStatus.setSelector((KDPromptSelector)aFaUseStatusPromptBox);
        this.bizPromptFaUseStatus.setDisplayFormatter((IFormatter)new FaDisplyFormatter());
        this.bizPromptFaUseStatus.setEditFormatter((IFormatter)new FaEditFormatter());
        this.bizPromptFaUseStatus.setEditable(true);
        this.bizPromptFaUseStatus.setCommitFormat("$number$");
        this.bizPromptFaUseStatus.setQueryInfo("com.kingdee.eas.fi.fa.basedata.FaUseStautsQuery");
        this.bizPromptFaUseStatus.setEntityViewInfo(viewInfo);
        this.bizPromptFaUseStatus.addChangeListener((ChangeListener)this);
        this.bizPromptStoreCity.setEditable(true);
        this.bizPromptStoreCity.setCommitFormat("$number$");
        this.bizPromptStoreCity.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AddressQuery");
        this.rbnByPeriod.setSelected(false);
        this.rbnByDate.setSelected(true);
        this.rbnAll.setSelected(true);
        this.labConYearFrom.setVisible(false);
        this.labConYearTo.setVisible(false);
        this.labConPeriodFrom.setVisible(false);
        this.labConPeriodTo.setVisible(false);
        this.labPeriodFrom.setVisible(false);
        this.labPeriodTo.setVisible(false);
        this.labConDateFrom.setVisible(true);
        this.labConDateTo.setVisible(true);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        FaUseStatusInfo aFaUseStatusInfo;
        if (e.getSource() == this.bizPromptFaAlterMode) {
            FaAlterModeInfo aFaAlterModeInfo = (FaAlterModeInfo)this.bizPromptFaAlterMode.getData();
            if (aFaAlterModeInfo != null && !aFaAlterModeInfo.isIsLeaf()) {
                this.bizPromptFaAlterMode.setValue(null);
                this.showSelectLeaf();
            }
        } else if (e.getSource() == this.bizPromptFaCat) {
            FaCatInfo aFaCatInfo = (FaCatInfo)this.bizPromptFaCat.getData();
            if (aFaCatInfo != null && !aFaCatInfo.isIsLeaf()) {
                this.bizPromptFaCat.setValue(null);
                this.showSelectLeaf();
            }
        } else if (e.getSource() == this.bizPromptFaUseStatus && (aFaUseStatusInfo = (FaUseStatusInfo)this.bizPromptFaUseStatus.getData()) != null && !aFaUseStatusInfo.isIsLeaf()) {
            this.bizPromptFaUseStatus.setValue(null);
            this.showSelectLeaf();
        }
    }

    public void showSelectLeaf() {
        String msg = EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource.strSelectChildPoint");
        MsgBox.showInfo((Component)((Object)this), (String)msg);
    }

    public void clear() {
        super.clear();
        this.sldYearFrom.setValue((Object)new Integer(this.currPeriod.getPeriodYear()));
        this.sldYearTo.setValue((Object)new Integer(this.currPeriod.getPeriodYear()));
        this.sldPeriodFrom.setValue((Object)new Integer(this.currPeriod.getPeriodNumber()));
        this.sldPeriodTo.setValue((Object)new Integer(this.currPeriod.getPeriodNumber()));
        this.dtDateFrom.setValue((Object)this.currPeriod.getBeginDate());
        this.dtDateTo.setValue((Object)this.currPeriod.getEndDate());
        this.bizPromptFaCat.setData(null);
        this.txtNumberFrom.setText(null);
        this.txtNumberTo.setText(null);
        this.bizPromptFaAlterMode.setData(null);
        this.bizPromptFaUseStatus.setData(null);
        this.bizPromptStoreCity.setData(null);
        this.rbnAll.setSelected(true);
        this.rbnByDate.setSelected(true);
        this.chkBox.setSelected(false);
    }

    private int getPeriodNumber(int year, int number) {
        if (number > 13 || number < 1) {
            throw new IllegalArgumentException("period number illeagle: number > 13 || number< 1");
        }
        return year * 100 + number;
    }

    private void fireStartYearChange() throws EASBizException, BOSException {
        String periodTypeID = FaClientUtils.getCurrentCompany().getAccountPeriodType().getId().toString();
        int periodYear = this.sldYearFrom.getIntegerVlaue();
        try {
            int periodNum = FaListFactory.getRemoteInstance().findPeriodNum(periodYear, periodTypeID);
            Integer minPeriod = new Integer(1);
            Integer maxPeriod = new Integer(periodNum);
            SpinnerNumberModel periodSpinnerNumberModel = new SpinnerNumberModel();
            if (this.minPeriodYear == null) {
                this.minPeriodYear = this.sldYearFrom.getIntegerVlaue();
            }
            if (this.maxPeriodYear == null) {
                this.maxPeriodYear = this.sldYearFrom.getIntegerVlaue();
            }
            if (periodYear == this.minPeriodYear) {
                Integer n = minPeriod = this.minPeriodStartNumber == null ? new Integer(0) : this.minPeriodStartNumber;
            }
            if (periodYear == this.maxPeriodYear) {
                maxPeriod = this.maxPerioEndNumber == null ? new Integer(0) : this.maxPerioEndNumber;
            }
            periodSpinnerNumberModel.setMinimum(minPeriod);
            periodSpinnerNumberModel.setMaximum(maxPeriod);
            this.sldPeriodFrom.setModel((SpinnerModel)periodSpinnerNumberModel);
            this.sldPeriodFrom.setValue((Object)minPeriod);
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
    }

    private void firePeriodChange(ChangeEvent e) {
        int endPeriod;
        int startPeriod = this.sldYearFrom.getIntegerVlaue() * 100 + this.sldPeriodFrom.getIntegerVlaue();
        if (startPeriod > (endPeriod = this.sldYearTo.getIntegerVlaue() * 100 + this.sldPeriodTo.getIntegerVlaue())) {
            if (e.getSource() == this.sldYearFrom || e.getSource() == this.sldPeriodFrom) {
                this.sldYearTo.setValue(this.sldYearFrom.getValue());
                this.sldPeriodTo.setValue(this.sldPeriodFrom.getValue());
            } else if (!this.isLoadData) {
                this.sldYearFrom.setValue(this.sldYearTo.getValue());
                this.sldPeriodFrom.setValue(this.sldPeriodTo.getValue());
            }
        }
    }

    private void fireEndYearChange() throws EASBizException, BOSException {
        String periodTypeID = FaClientUtils.getCurrentCompany().getAccountPeriodType().getId().toString();
        int periodYear = this.sldYearTo.getIntegerVlaue();
        try {
            int periodNum = FaListFactory.getRemoteInstance().findPeriodNum(periodYear, periodTypeID);
            Integer minPeriod = new Integer(1);
            Integer maxPeriod = new Integer(periodNum);
            SpinnerNumberModel periodSpinnerNumberModel = new SpinnerNumberModel();
            if (this.minPeriodYear == null) {
                this.minPeriodYear = this.sldYearFrom.getIntegerVlaue();
            }
            if (this.maxPeriodYear == null) {
                this.maxPeriodYear = this.sldYearFrom.getIntegerVlaue();
            }
            if (periodYear == this.minPeriodYear) {
                Integer n = minPeriod = this.minPeriodStartNumber == null ? new Integer(0) : this.minPeriodStartNumber;
            }
            if (periodYear == this.maxPeriodYear) {
                maxPeriod = this.maxPerioEndNumber == null ? new Integer(0) : this.maxPerioEndNumber;
            }
            periodSpinnerNumberModel.setMinimum(minPeriod);
            periodSpinnerNumberModel.setMaximum(maxPeriod);
            this.sldPeriodTo.setModel((SpinnerModel)periodSpinnerNumberModel);
            this.sldPeriodTo.setValue((Object)minPeriod);
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
    }
}

