/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.ctrl.swing.KDButtonGroup;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.fa.manage.FaDataImportFacadeFactory;
import com.kingdee.eas.fi.fa.manage.TaskEntryInfo;
import com.kingdee.eas.fi.fa.manage.TaskInfo;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaDataImportUI;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.eas.tools.datatask.TaskStateEnum;
import com.kingdee.eas.tools.datatask.runtime.ExternalExcelDataReader;
import com.kingdee.eas.tools.datatask.runtime.ExternalExcelXDataReader;
import com.kingdee.eas.tools.datatask.runtime.UploadFileToServerHelper;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import com.kingdee.eas.tools.datatask.util.GlobalInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import org.apache.log4j.Logger;

public class FaDataImportUI
extends AbstractFaDataImportUI
implements ActionListener,
Runnable {
    private static final Logger logger = CoreUIObject.getLogger(FaDataImportUI.class);
    public static final DateFormat df = new SimpleDateFormat("HH:mm:ss SSS");
    private SimpleAttributeSet attributeSet = new SimpleAttributeSet();
    private KDButtonGroup btnImportGroup = new KDButtonGroup();
    private KDButtonGroup btnErrorGroup = new KDButtonGroup();
    private TaskInfo task = null;
    private int step = -1;
    private Thread monitor = null;
    private boolean running = false;
    private Object synObj = new Object();
    private static final int Max_Interval_Time = 5000;
    private static final int Min_Interval_Time = 200;
    private int intervalTime = 200;

    public void onLoad() throws Exception {
        super.onLoad();
        this.LabelWizard.setIcon(EASResource.getIcon((String)"imgTransfers_pic260"));
        this.btnOpen.setIcon((Icon)GlobalInfo.getIcon((String)"tbtn_open"));
        this.btnOpen.addActionListener((ActionListener)this);
        this.btnImportGroup.add((AbstractButton)this.btnAddNew);
        this.btnImportGroup.add((AbstractButton)this.btnOverWrite);
        this.btnAddNew.setSelected(true);
        this.btnErrorGroup.add((AbstractButton)this.btnReturnRightnow);
        this.btnErrorGroup.add((AbstractButton)this.btnReturnWhenFinish);
        this.btnReturnRightnow.setSelected(true);
        this.spBlockSize.setModel((SpinnerModel)new SpinnerNumberModel(1000, 100, 10000, 100));
        this.btnTemplate.setVisible(false);
        this.txtLog.setEditable(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.btnOpen)) {
            this.onBtnOpenClicked();
        }
    }

    private void onBtnOpenClicked() {
        String sFileName = null;
        try {
            sFileName = GlobalFunction.excelFileChoose((Component)((Object)this));
        }
        catch (Exception err) {
            MsgBox.showError((String)err.getMessage());
            return;
        }
        if (sFileName != null && !sFileName.equals("")) {
            this.txtFile.setText(sFileName);
            String string = GlobalFunction.getFileExtension((String)sFileName);
        }
        this.initUIContentLayout();
        this.btnOk.requestFocusInWindow();
    }

    private void enableComponent(boolean enable) {
        this.txtFile.setEnabled(enable);
        this.btnOpen.setEnabled(enable);
        this.btnReturnRightnow.setEnabled(enable);
        this.btnReturnWhenFinish.setEnabled(enable);
        this.btnAddNew.setEnabled(enable);
        this.btnOverWrite.setEnabled(enable);
        this.spBlockSize.setEnabled(enable);
        this.btnOk.setEnabled(enable);
        this.btnCancel.setEnabled(enable);
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        ArrayList sheetNames;
        HashMap<String, Object> params;
        String fileType;
        String fileName;
        block8: {
            fileName = this.getFileName();
            fileType = GlobalFunction.getFileExtension((String)fileName);
            if (fileName == null || fileName.equals("")) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"importDocument"));
                return;
            }
            params = new HashMap<String, Object>();
            sheetNames = null;
            try {
                ExternalExcelDataReader reader;
                if ("xls".equals(fileType)) {
                    reader = new ExternalExcelDataReader();
                    sheetNames = reader.getSheetNameCollection(fileName);
                    break block8;
                }
                if ("xlsx".equals(fileType)) {
                    reader = new ExternalExcelXDataReader();
                    sheetNames = reader.getSheetNameCollection(fileName);
                    break block8;
                }
                MsgBox.showError((Component)((Object)this), (String)(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"230_FaDataImportUI") + fileType + "\u3002"));
                return;
            }
            catch (FileNotFoundException ex) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"fileopened"));
                return;
            }
            catch (IOException ex) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"readFileError"));
                return;
            }
            catch (Exception ex) {
                MsgBox.showError((Component)((Object)this), (String)ex.getMessage());
                return;
            }
        }
        if (sheetNames == null || sheetNames.size() == 0) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"231_FaDataImportUI"));
            return;
        }
        params.put("sheetNames", sheetNames);
        this.showTimeLog(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"232_FaDataImportUI"));
        UploadFileToServerHelper helper = new UploadFileToServerHelper();
        String serverTmpFileName = helper.uploadFile(fileName);
        DatataskParameter param = new DatataskParameter();
        param.setFileType(fileType);
        param.setOpenFileName(serverTmpFileName);
        Map uiContext = this.getUIContext();
        params.put("className", uiContext.get("runnerClass"));
        param.datataskMode = this.btnAddNew.isSelected() ? 8 : (this.btnOverWrite.isSelected() ? 16 : 8);
        params.put("param", param);
        this.addErrorHandleMode(param);
        params.put("blockSize", this.spBlockSize.getValue());
        this.task = this.createTask();
        String taskId = FaDataImportFacadeFactory.getRemoteInstance().addTask(this.task);
        this.task.setId(taskId);
        this.step = -1;
        params.put("taskId", taskId);
        this.enableComponent(false);
        this.txtLog.setText("");
        new Thread(){

            @Override
            public void run() {
                FaDataImportUI.this.doImport(params);
            }
        }.start();
    }

    private TaskInfo createTask() {
        TaskInfo task = new TaskInfo();
        task.setNumber("cardimp");
        task.setName(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"233_FaDataImportUI"));
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doImport(Map params) {
        try {
            this.running = true;
            this.startMonitor();
            Map result = FaDataImportFacadeFactory.getRemoteInstance().importData(params);
            this.running = false;
            this.showTimeLog(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"234_FaDataImportUI"));
            this.monitor.interrupt();
            this.monitor = null;
            Object object = this.synObj;
            synchronized (object) {
                TaskInfo ti = FaDataImportFacadeFactory.getRemoteInstance().getTask(this.task.getId(), this.step);
                if (ti != null && ti.getEntries().size() > 0) {
                    Iterator<TaskEntryInfo> iterator = ti.getEntries().iterator();
                    while (iterator.hasNext()) {
                        TaskEntryInfo o;
                        TaskEntryInfo entry = o = iterator.next();
                        this.showTimeLog(entry.getContent(), entry.getCreateTime());
                    }
                }
            }
            TaskStateEnum state = (TaskStateEnum)result.get("state");
            if (state.equals((Object)TaskStateEnum.SUCCESSEND)) {
                this.showTimeLog(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"235_FaDataImportUI"));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FaDataImportUI.this.btnCancel.setText(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"236_FaDataImportUI"));
                        FaDataImportUI.this.btnCancel.setEnabled(true);
                    }
                });
            } else {
                this.showTimeLog(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"237_FaDataImportUI"));
                ArrayList sheetNames = (ArrayList)params.get("sheetNames");
                for (String sheetName : sheetNames) {
                    Map iResult = (Map)result.get(sheetName);
                    if (iResult == null) continue;
                    this.showLog("");
                    this.showLog(sheetName + EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"238_FaDataImportUI") + iResult.get("nSuccessCount") + EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"239_FaDataImportUI") + iResult.get("nFailCount"));
                    List errors = (List)iResult.get("errors");
                    for (String error : errors) {
                        this.showLog(error);
                    }
                }
                this.btnCancel.setText(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"236_FaDataImportUI"));
                this.enableComponent(true);
            }
        }
        catch (Throwable t) {
            this.enableComponent(true);
            this.showTimeLog(FaDataImportUI.printStackTrace(t));
        }
        finally {
            this.running = false;
            if (this.task != null) {
                try {
                    FaDataImportFacadeFactory.getRemoteInstance().deleteTask(this.task.getId());
                    this.task = null;
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
        }
    }

    private void addErrorHandleMode(DatataskParameter param) {
        ErrorHandleModeEnum errorHandleMode = null;
        errorHandleMode = this.btnReturnRightnow.isSelected() ? ErrorHandleModeEnum.ReturnRightnow : ErrorHandleModeEnum.ReturnWhenFinish;
        param.getContextParam().put("errorHandleMode", errorHandleMode);
    }

    public String getFileName() {
        return this.txtFile.getText();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    @Override
    public void actionTemplate_actionPerformed(ActionEvent e) throws Exception {
    }

    protected boolean checkBeforeWindowClosing() {
        if (this.running) {
            return false;
        }
        return super.checkBeforeWindowClosing();
    }

    private void showLog(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Document doc = FaDataImportUI.this.txtLog.getDocument();
                try {
                    doc.insertString(doc.getLength(), message + "\n", FaDataImportUI.this.attributeSet);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                FaDataImportUI.this.txtLog.setSelectionStart(doc.getLength());
            }
        });
    }

    private void showTimeLog(String message) {
        this.showLog(df.format(new Date()) + "[C] " + message);
    }

    private void showTimeLog(String message, Date date) {
        this.showLog(df.format(date) + " " + message);
    }

    private void startMonitor() {
        this.monitor = new Thread(this);
        this.monitor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.task == null) {
                return;
            }
            while (this.running) {
                Object object = this.synObj;
                synchronized (object) {
                    if (!this.running) {
                        return;
                    }
                    TaskInfo ti = FaDataImportFacadeFactory.getRemoteInstance().getTask(this.task.getId(), this.step);
                    if (ti == null) {
                        return;
                    }
                    if (ti.getEntries().size() > 0) {
                        this.intervalTime = 200;
                        Iterator<TaskEntryInfo> iterator = ti.getEntries().iterator();
                        while (iterator.hasNext()) {
                            TaskEntryInfo o;
                            TaskEntryInfo entry = o = iterator.next();
                            this.showTimeLog(entry.getContent(), entry.getCreateTime());
                            this.step = entry.getStep();
                        }
                    }
                    if (ti.getStatus() == 2) {
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Thread.sleep(60000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                if (!FaDataImportUI.this.btnCancel.isEnabled()) {
                                    FaDataImportUI.this.running = false;
                                    FaDataImportUI.this.btnCancel.setText(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"240_FaDataImportUI"));
                                    FaDataImportUI.this.btnCancel.setEnabled(true);
                                }
                            }
                        }).start();
                        return;
                    }
                }
                if (this.intervalTime < 5000) {
                    Thread.sleep(this.intervalTime);
                    this.intervalTime = (int)((double)this.intervalTime + (double)this.intervalTime * 0.5);
                    continue;
                }
                Thread.sleep(5000L);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Throwable t) {
            logger.error((Object)"", t);
        }
    }

    public static void showMe(Object owner, String runnerClass) {
        UIContext uiContext = new UIContext(owner);
        uiContext.put((Object)"runnerClass", (Object)runnerClass);
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.fa.manage.client.FaDataImportUI", (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
        catch (UIException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static String printStackTrace(Throwable t) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(stream);
        t.printStackTrace(writer);
        writer.flush();
        String s = stream.toString();
        writer.close();
        return s;
    }
}

