/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.printprovider.headerfooter.ExtVarProvider;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTFocusChangeAction;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.exception.AlreadyBindProcessInstanceException;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QueryPanelTypeEnum;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.FaAlterModeInfo;
import com.kingdee.eas.fi.fa.basedata.FaDecValueRuleEnum;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.basedata.client.FaAlterModePromptBox;
import com.kingdee.eas.fi.fa.manage.FaChangeBillInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaDecValueEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaDecValueEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaDecValueFactory;
import com.kingdee.eas.fi.fa.manage.FaDecValueInfo;
import com.kingdee.eas.fi.fa.manage.FaDepreciationFactory;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.IFaDecValue;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaDecValueUI;
import com.kingdee.eas.fi.fa.manage.client.FACommonProcessor;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.manage.client.PeriodFilterPanel;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class FaDecValueUI
extends AbstractFaDecValueUI {
    private static final long serialVersionUID = 3060554365344743487L;
    private static final String CARD_RES_PATH = "com.kingdee.eas.fi.fa.manage.FaCardResource";
    private static final String RES_PATH = "com.kingdee.eas.fi.fa.manage.FaDecValueResource";
    private static final String ERROR_INFO = "errorInfo";
    private static final String VOUCHERTYPE = new VoucherInfo().getBOSType().toString();
    private CompanyOrgUnitInfo currCompany;
    private BigDecimal ZERO = new BigDecimal("0.00");
    private static final String DECED_VALUE = "decedValue";
    private static final String NEAT_VALUE = "neatValue";
    private static final String DEC_VALUE = "decValue";
    private static final String BAK_DEC_VALUE = "bakDecValue";
    protected PeriodFilterPanel conditionPanel = new PeriodFilterPanel();
    private PeriodInfo currPeriod;
    private FaAlterModeInfo oldAlterModeInfo;
    protected int currencyScale = -1;
    protected EntityViewInfo view;
    protected CommonQueryDialog commonQueryDialog;
    protected static final String FROM_LINK = "Link";

    public void onLoad() throws Exception {
        this.initTable();
        this.initUIStyle();
        FaClientUtils.checkComp((Component)((Object)this), SysContext.getSysContext().getCurrentFIUnit());
        super.onLoad();
        if (!"VIEW".equals(this.getOprtState())) {
            CompanyOrgUnitInfo company = this.getCurrentCompany();
            FaClientUtils.checkComp((Component)((Object)this), company);
            FaClientUtils.checkFaInit((Component)((Object)this), company);
            FaClientUtils.checkAccountSwap((Component)((Object)this), company);
            this.currPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)company);
            if (FaDepreciationFactory.getRemoteInstance().checkUnAuditFaDep(this.currPeriod, company, null)) {
                MsgBox.showInfo((Component)((Component)this.getUIContext().get("Owner")), (String)EASResource.getString((String)RES_PATH, (String)"depr_NotAudit"));
                SysUtil.abort();
            }
            this.setOprtState("ADDNEW");
        } else {
            this.actionAttachment.setEnabled(false);
            this.actionQuery.setEnabled(false);
        }
        this.setWorkflowVisible();
        this.formatTableData();
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.tblMain.getInputMap().remove(KeyStroke.getKeyStroke(89, 128));
        this.tblMain.getActionMap().remove("Redo");
        this.actionReset.setEnabled(true);
        this.btnReset.setEnabled(true);
    }

    protected void setWorkflowVisible() throws EASBizException, BOSException {
        boolean isUseWorkflow = FaManageUtils.isUseWorkflow(null, this.getCurrentCompany().getId().toString(), ((Object)((Object)this)).getClass());
        if (isUseWorkflow) {
            this.menuTool.setVisible(true);
            this.hideOrShowWorkflow(true);
            this.btnNextPerson.setVisible(false);
            this.btnNextPerson.setEnabled(false);
            this.btnMultiapprove.setVisible(false);
            this.btnMultiapprove.setEnabled(false);
            this.hideOrShowAuditResult(false);
            this.btnAudit.setVisible(false);
        } else {
            this.menuTool.setVisible(false);
            this.hideOrShowWorkflow(false);
            this.hideOrShowAuditResult(false);
        }
    }

    protected void loadData() throws Exception {
        if (this.getUIContext().get("ID") != null) {
            SysUtil.abort();
        }
        boolean isViewStatus = "VIEW".equals(this.getOprtState()) || "FINDVIEW".equals(this.getOprtState());
        this.commonQueryDialog = new CommonQueryDialog();
        this.initCommonQueryDialog();
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = "com.kingdee.eas.fi.fa.manage.FaDecValueQuery";
        String currUserID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        CompanyOrgUnitInfo company = this.getCurrentCompany();
        if (iQuery.hasDefaultSolution(((Object)((Object)this)).getClass().getName(), queryName, company.getId().toString(), currUserID)) {
            QuerySolutionInfo solution;
            this.view = (EntityViewInfo)iQuery.getDefaultFilterInfo(((Object)((Object)this)).getClass().getName(), queryName, company.getId().toString(), currUserID);
            if (this.view == null) {
                this.view = new EntityViewInfo();
            }
            if (this.view.getFilter() == null) {
                this.view.setFilter(new FilterInfo());
            }
            if ((solution = iQuery.getDefaultSolution(((Object)((Object)this)).getClass().getName(), queryName, company.getId().toString(), currUserID)) != null && !solution.getName().equals(FaResUtil.getRes((String)"defaultSolution"))) {
                QueryPanelCollection queryPanels = solution.getQueryPanelInfo();
                QueryPanelInfo queryPanel = null;
                int size = queryPanels.size();
                for (int i = 0; i < size; ++i) {
                    if (queryPanels.get(i).getQueryPanelType() != QueryPanelTypeEnum.CUSTOMER_PANEL) continue;
                    queryPanel = queryPanels.get(i);
                    break;
                }
                CustomerParams cp = XMLBean.TransStrToCustParams((String)queryPanel.getCustomerParams());
                this.conditionPanel.setCustomerParams(cp);
            }
            this.conditionPanel.onLoad();
            this.conditionPanel.loadData(this.view);
            this.conditionPanel.verify();
            this.execute(true);
        } else if (this.commonQueryDialog.show()) {
            this.execute(false);
        } else {
            SysUtil.abort();
        }
        if (this.editData.getEntry().size() == 0) {
            Component component = (Component)this.getUIContext().get("Owner");
            MsgBox.showInfo((Component)component, (String)EASResource.getString((String)RES_PATH, (String)"notDecValueCard"));
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("period.periodYear"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("period.periodNumber"));
        return sic;
    }

    private void initUIStyle() throws BOSException {
        this.menuWorkflow.setVisible(true);
        this.btnWorkFlowG.setVisible(true);
        this.btnReset.setIcon(EASResource.getIcon((String)"imgTbtn_reset"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemReset.setIcon(EASResource.getIcon((String)"imgTbtn_reset"));
        this.menuItemQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.menuItemAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.menuItemUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.actionSave.setVisible(false);
        FaAlterModePromptBox aFaAlterModePromptBox = new FaAlterModePromptBox((CoreUIObject)this, false);
        this.bizPromptBoxChangeMode.setSelector((KDPromptSelector)aFaAlterModePromptBox);
        this.bizPromptBoxChangeMode.setEntityViewInfo(FaClientUtils.getAlterModeOrgSplitViewInfo(false));
    }

    @Override
    public void loadFields() {
        this.oldAlterModeInfo = this.editData.getAlterMode();
        super.loadFields();
        this.displayPeriodInfo();
        try {
            this.setCtrlStatus();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            this.tblMain.getCell(i, "status").setValue((Object)this.editData.getCheckedStatus());
            this.tblMain.getCell(i, BAK_DEC_VALUE).setValue(this.tblMain.getCell(i, DEC_VALUE).getValue());
        }
        IRow row = this.tblMain.addRow();
        row.getCell("assetCat").setValue((Object)EASResource.getString((String)RES_PATH, (String)"total"));
        this.setSumValues(row);
        row.getStyleAttributes().setBackground(this.tblMain.getRequiredColor());
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setAlterMode((FaAlterModeInfo)this.bizPromptBoxChangeMode.getValue());
        Date bizDate = DateTimeUtils.truncateDate((Date)new Date());
        if (bizDate.before(this.currPeriod.getBeginDate())) {
            bizDate = this.currPeriod.getBeginDate();
        } else if (bizDate.after(this.currPeriod.getEndDate())) {
            bizDate = this.currPeriod.getEndDate();
        }
        this.editData.setBizDate(bizDate);
        this.editData.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        this.editData.setCompany(this.getCurrentCompany());
        this.editData.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        this.editData.setPeriod(this.currPeriod);
        FaDecValueEntryCollection entryColl = this.editData.getEntry();
        entryColl.clear();
        for (int i = 0; i < this.tblMain.getRowCount() - 1; ++i) {
            BOSUuid cardID = (BOSUuid)this.tblMain.getCell(i, "cardID").getValue();
            if (cardID == null) continue;
            FaDecValueEntryInfo entryInfo = new FaDecValueEntryInfo();
            FaCurCardInfo curCardInfo = new FaCurCardInfo();
            curCardInfo.setId(cardID);
            entryInfo.setCurcard(curCardInfo);
            entryInfo.setDecValue((BigDecimal)this.tblMain.getCell(i, DEC_VALUE).getValue());
            entryColl.add(entryInfo);
        }
    }

    protected void initTable() throws BOSException {
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
    }

    protected void updateButtonStatus() {
    }

    protected void execute(boolean refresh) throws Exception {
        this.actionQuery.setVisible(true);
        if (!refresh || this.view == null) {
            EntityViewInfo entityViewInfo = this.view = this.commonQueryDialog == null ? null : this.commonQueryDialog.getEntityViewInfoResult();
        }
        if (this.view == null) {
            this.view = new EntityViewInfo();
        }
        this.view.put("periodYear", (Object)new Integer(this.conditionPanel.getCustomerParams().getInt("periodYear")));
        this.view.put("periodNumber", (Object)new Integer(this.conditionPanel.getCustomerParams().getInt("periodNumber")));
        this.setDataObject((IObjectValue)FaDecValueFactory.getRemoteInstance().getFaDecValueInfo(this.view));
        this.loadFields();
        Object id = this.getUIContext().get("ID");
        if (id != null) {
            this.prepareData(id.toString());
        }
    }

    private void setCtrlStatus() throws BOSException, EASBizException {
        boolean isViewStatus;
        boolean bl = isViewStatus = "VIEW".equals(this.getOprtState()) || "FINDVIEW".equals(this.getOprtState());
        if (isViewStatus) {
            this.actionAudit.setEnabled(false);
            this.actionUnAudit.setEnabled(false);
            this.actionReset.setEnabled(false);
            this.actionSubmit.setEnabled(false);
            this.actionVoucher.setEnabled(false);
            this.actionDelVoucher.setEnabled(false);
            this.tblMain.getColumn(DEC_VALUE).getStyleAttributes().setLocked(true);
            this.bizPromptBoxChangeMode.setAccessAuthority(1);
        } else {
            int periodYear = this.conditionPanel.getPeriodYear();
            int periodNumber = this.conditionPanel.getPeriodNumber();
            PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.getCurrentCompany());
            boolean isCurrPeriod = currPeriod.getPeriodYear() == periodYear && currPeriod.getPeriodNumber() == periodNumber;
            IFaDecValue iFaDecValue = FaDecValueFactory.getRemoteInstance();
            boolean isFiVouchered = iFaDecValue.isFiVouchered(periodYear, periodNumber);
            boolean isDecAudited = iFaDecValue.isDecAudited(periodYear, periodNumber);
            boolean isNotDecValue = iFaDecValue.isNotDecValue(periodYear, periodNumber);
            this.actionAudit.setEnabled(isCurrPeriod && !isDecAudited && !isNotDecValue && !isFiVouchered);
            this.actionAudit.setVisible(!isDecAudited);
            this.actionUnAudit.setEnabled(isCurrPeriod && isDecAudited && !isNotDecValue && !isFiVouchered);
            this.actionUnAudit.setVisible(isDecAudited);
            this.actionTraceDown.setVisible(isDecAudited);
            this.actionReset.setEnabled(isCurrPeriod && !isDecAudited);
            this.actionReset.setVisible(!isDecAudited);
            this.actionSubmit.setEnabled(isCurrPeriod && !isDecAudited);
            this.actionSubmit.setVisible(!isDecAudited);
            this.actionVoucher.setEnabled(isDecAudited && !isFiVouchered);
            this.actionVoucher.setVisible(isDecAudited && !isFiVouchered);
            this.actionDelVoucher.setEnabled(isDecAudited && isFiVouchered);
            this.actionDelVoucher.setVisible(isDecAudited && isFiVouchered);
            this.tblMain.getColumn(DEC_VALUE).getStyleAttributes().setLocked(!isCurrPeriod || isDecAudited);
            int authority = !isCurrPeriod || isDecAudited ? 1 : 0;
            this.bizPromptBoxChangeMode.setAccessAuthority(authority);
        }
    }

    protected IObjectValue createNewData() {
        return new FaDecValueInfo();
    }

    private void setSumValues(IRow row) {
        BigDecimal totalNeatValue = this.ZERO;
        BigDecimal totalDecedValue = this.ZERO;
        BigDecimal totalDecValue = this.ZERO;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            Object value = this.tblMain.getCell(i, NEAT_VALUE).getValue();
            if (value != null && value instanceof BigDecimal) {
                totalNeatValue = totalNeatValue.add((BigDecimal)value);
            }
            if ((value = this.tblMain.getCell(i, DECED_VALUE).getValue()) != null && value instanceof BigDecimal) {
                totalDecedValue = totalDecedValue.add((BigDecimal)value);
            }
            if ((value = this.tblMain.getCell(i, DEC_VALUE).getValue()) == null || !(value instanceof BigDecimal)) continue;
            totalDecValue = totalDecValue.add((BigDecimal)value);
        }
        row.getCell(NEAT_VALUE).setValue((Object)totalNeatValue);
        row.getCell(DECED_VALUE).setValue((Object)totalDecedValue);
        row.getCell(DEC_VALUE).setValue((Object)totalDecValue);
        row.getCell(DEC_VALUE).getStyleAttributes().setLocked(true);
    }

    private void setSumDecValue() {
        BigDecimal totalDecValue = this.ZERO;
        for (int i = 0; i < this.tblMain.getRowCount() - 1; ++i) {
            Object decValue = this.tblMain.getCell(i, DEC_VALUE).getValue();
            if (decValue == null || !(decValue instanceof BigDecimal)) continue;
            totalDecValue = totalDecValue.add((BigDecimal)decValue);
        }
        this.tblMain.getCell(this.tblMain.getRowCount() - 1, DEC_VALUE).setValue((Object)totalDecValue);
    }

    public void initListener() {
        super.initListener();
        KDTSortManager sortManager = new KDTSortManager(this.getDetailTable());
        sortManager.setSortAuto(false);
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                if (e.getValue() == null) {
                    return;
                }
                if (e.getValue().equals(e.getOldValue())) {
                    return;
                }
                if (FaDecValueUI.this.verifyDecValue(e)) {
                    FaDecValueUI.this.setSumDecValue();
                } else {
                    FaDecValueUI.this.tblMain.getCell(e.getRowIndex(), e.getColIndex()).setValue(e.getOldValue());
                    FaDecValueUI.this.tblMain.getEditManager().editCellAt(e.getRowIndex(), e.getColIndex());
                    e.setCancel(true);
                }
            }
        });
        this.tblMain.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                if (e.getPrevColumnIndex() == FaDecValueUI.this.tblMain.getColumnIndex(FaDecValueUI.DEC_VALUE)) {
                    for (int i = 0; i < FaDecValueUI.this.tblMain.getRowCount(); ++i) {
                        Object decValue = FaDecValueUI.this.tblMain.getCell(i, FaDecValueUI.DEC_VALUE).getValue();
                        if (decValue != null) continue;
                        FaDecValueUI.this.tblMain.getCell(i, FaDecValueUI.DEC_VALUE).setValue((Object)FaDecValueUI.this.ZERO);
                    }
                }
            }
        });
    }

    private boolean verifyDecValue(KDTEditEvent e) {
        BigDecimal decValue;
        BigDecimal decValue2;
        IRow row = this.tblMain.getRow(e.getRowIndex());
        Object policy = row.getCell("decValuePolicy").getValue();
        if (FaDecValueRuleEnum.CanDecValueAndCanNotCancel.equals(policy) && e.getValue() != null && e.getValue() instanceof BigDecimal && (decValue2 = (BigDecimal)e.getValue()).doubleValue() < 0.0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"decValueIsNegative"));
            return false;
        }
        BigDecimal neatValue = (BigDecimal)row.getCell(NEAT_VALUE).getValue();
        BigDecimal decedValue = (BigDecimal)row.getCell(DECED_VALUE).getValue();
        if (decedValue.add(decValue = (BigDecimal)row.getCell(DEC_VALUE).getValue()).compareTo(this.ZERO) < 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"neatValueCondtion1"));
            return false;
        }
        if (decedValue.add(decValue).compareTo(neatValue) > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"neatValueCondtion2"));
            return false;
        }
        return true;
    }

    protected KDTable getTableForCommon() {
        return this.tblMain;
    }

    protected KDTable getTableForOA() {
        return this.tblMain;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.BASICSYSTEM;
    }

    protected void afterSubmitAddNew() {
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(this.getCurrentCompany().getId().toString());
        if (this.getActionFromActionEvent(e) == null && !this.checkClickTime()) {
            return;
        }
        this.verify(e);
        this.doBeforeSubmitForWF((CoreBaseInfo)this.editData);
        IObjectPK pk = null;
        try {
            pk = this.runSubmit();
        }
        catch (AlreadyBindProcessInstanceException wfExceptoin) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_BindWfInstance"));
            return;
        }
        catch (Exception e2) {
            String msgString = e2.getMessage();
            int startIndex = msgString.indexOf("[");
            int endIndex = msgString.indexOf("]");
            StringBuffer resulrMsg = new StringBuffer();
            if (startIndex != -1) {
                String startStr = msgString.substring(0, startIndex);
                String numStr = msgString.substring(startIndex + 1, endIndex);
                resulrMsg.append(startStr + "[");
                if (null != numStr && "" != numStr) {
                    String[] split = numStr.split("\uff0c");
                    for (int i = 0; i < split.length; i += 2) {
                        if (i == 0) {
                            resulrMsg.append(split[i]);
                            resulrMsg.append(",");
                            resulrMsg.append("\n");
                            --i;
                            continue;
                        }
                        if (i + 1 == split.length) {
                            resulrMsg.append(split[i]);
                            continue;
                        }
                        resulrMsg.append(split[i]);
                        resulrMsg.append(",");
                        resulrMsg.append(split[i + 1]);
                        if (i + 1 < split.length) {
                            resulrMsg.append(",");
                        }
                        resulrMsg.append("\n");
                    }
                }
                String endStr = msgString.substring(endIndex + 1);
                resulrMsg.append("]").append(endStr);
            } else {
                resulrMsg.append(msgString);
            }
            MsgBox.showInfo((Component)((Object)this), (String)resulrMsg.toString());
        }
        this.getUIContext().put("ID", pk);
        this.editData.setId(pk == null ? null : BOSUuid.read((String)pk.toString()));
        CacheServiceFactory.getInstance().discardType(this.editData.getBOSType());
        this.showMessageForStatus();
        this.showSubmitSuccess();
        this.setSave(true);
        this.setSaved(true);
        this.execute(true);
    }

    public IObjectPK runSubmit() throws Exception {
        if (this.getBizInterface() == null) {
            throw new Exception("don't implement getBizInterface()  !");
        }
        FaDecValueInfo info = FaDecValueFactory.getRemoteInstance().verifySubmit(this.editData);
        if (info == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"notDecValueCard"));
            SysUtil.abort();
        } else if (info.get(ERROR_INFO) != null && !MsgBox.isOk((int)MsgBox.showConfirm2((Component)((Object)this), (String)info.get(ERROR_INFO).toString()))) {
            SysUtil.abort();
        }
        return this.getBizInterface().submit((CoreBaseInfo)info);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (this.editData.getEntry().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"notDecValueCard"));
            SysUtil.abort();
        }
        if (this.bizPromptBoxChangeMode.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"alterModeIsNull"));
            SysUtil.abort();
        }
        if (FaDepreciationFactory.getRemoteInstance().checkUnAuditFaDep(this.currPeriod, this.getCurrentCompany(), null)) {
            MsgBox.showInfo((Component)((Component)this.getUIContext().get("Owner")), (String)EASResource.getString((String)RES_PATH, (String)"depr_NotAudit"));
            SysUtil.abort();
        }
        this.verifyBeforeSubmit();
    }

    protected void showSubmitSuccess() {
        this.setMessageText(EASResource.getString((String)RES_PATH, (String)"Msg_Save_OK"));
        this.showMessage();
    }

    protected void showAuditSuccess() {
        this.setMessageText(EASResource.getString((String)RES_PATH, (String)"Msg_Audit_OK"));
        this.showMessage();
    }

    protected void showUnAuditSuccess() {
        this.setMessageText(EASResource.getString((String)RES_PATH, (String)"Msg_UnAudit_OK"));
        this.showMessage();
    }

    protected void showDelVoucherSuccess() {
        this.setMessageText(EASResource.getString((String)RES_PATH, (String)"Msg_DelVoucher_OK"));
        this.showMessage();
    }

    protected void formatTableData() throws EASBizException, BOSException {
        KDFormattedTextField fTxtDecValue = new KDFormattedTextField(1);
        fTxtDecValue.setPrecision(this.getCurrencyScale());
        fTxtDecValue.setHorizontalAlignment(4);
        this.tblMain.getColumn(DEC_VALUE).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)fTxtDecValue));
        this.tblMain.getActionMap().put("FocusChangeRow", (Action)new KDTFocusChangeAction(this.tblMain, 1, false, false, null));
        this.tblMain.getActionMap().put("FocusChangeCol", (Action)new KDTFocusChangeAction(this.tblMain, 1, false, false, null));
        String[] fmtColumnNames = new String[]{NEAT_VALUE, DECED_VALUE, DEC_VALUE};
        FaClientUtils.changeTableNumberFormat(this.tblMain, fmtColumnNames, FaClientUtils.getDecimalFormat(this.getCurrencyScale()));
    }

    protected int getCurrencyScale() {
        if (this.currencyScale == -1) {
            try {
                this.currencyScale = FaClientUtils.getCurrencyScale();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return this.currencyScale == -1 ? 2 : this.currencyScale;
    }

    protected void displayPeriodInfo() {
        this.lblPeriodValue.setText(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"displayPeriod"), this.editData.getPeriod().getPeriodYear(), this.editData.getPeriod().getPeriodNumber()));
    }

    protected void initCommonQueryDialog() throws Exception {
        this.commonQueryDialog.setOwner((Component)this.getUIContext().get("Owner"));
        this.commonQueryDialog.setParentUIClassName(((Object)((Object)this)).getClass().getName());
        this.commonQueryDialog.setQueryObjectPK((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.fa.manage.FaDecValueQuery"));
        this.commonQueryDialog.setShowFilter(true);
        this.commonQueryDialog.setShowSorter(true);
        this.commonQueryDialog.setShowToolbar(true);
        this.conditionPanel.setPanelName(EASResource.getString((String)RES_PATH, (String)"condition"));
        this.commonQueryDialog.addUserPanel((KDPanel)this.conditionPanel);
        this.commonQueryDialog.setDisShowRowCount(true);
        this.commonQueryDialog.setTitle(EASResource.getString((String)RES_PATH, (String)"faDecValue") + " - " + EASResource.getString((String)RES_PATH, (String)"condQuery"));
        FACommonProcessor process = new FACommonProcessor();
        process.set("parentDialog", this.commonQueryDialog);
        this.commonQueryDialog.setProcessor((IProcessor)process);
        this.commonQueryDialog.setHeight(300);
        this.commonQueryDialog.setWidth(400);
    }

    public String getUITitle() {
        return EASResource.getString((String)RES_PATH, (String)"faDecValue");
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FaDecValueFactory.getRemoteInstance();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entry.curcard.accountAsset.id"));
        sic.add(new SelectorItemInfo("entry.curcard.accountAccuDepr.id"));
        sic.add(new SelectorItemInfo("entry.curcard.accountDecValue.*"));
        sic.add(new SelectorItemInfo("entry.curcard.assetValue"));
        sic.add(new SelectorItemInfo("entry.curcard.accountAsset"));
        sic.add(new SelectorItemInfo("entry.curcard.accuDeprAll"));
        sic.add(new SelectorItemInfo("entry.curcard.assetCat.id"));
        sic.add(new SelectorItemInfo("entry.curcard.accuDepr"));
        sic.add(new SelectorItemInfo("entry.curcard.decValue"));
        sic.add(new SelectorItemInfo("entry.curcard.neatValue"));
        sic.add(new SelectorItemInfo("entry.curcard.neatAmt"));
        sic.add(new SelectorItemInfo("entry.curcard.decValueChg"));
        return sic;
    }

    public boolean isModify() {
        FaAlterModeInfo alterMode = (FaAlterModeInfo)this.bizPromptBoxChangeMode.getValue();
        if (this.oldAlterModeInfo != null || alterMode != null) {
            if (this.oldAlterModeInfo != null && alterMode == null) {
                return true;
            }
            if (this.oldAlterModeInfo == null && alterMode != null) {
                return true;
            }
            if (!this.oldAlterModeInfo.getId().equals((Object)alterMode.getId())) {
                return true;
            }
        }
        this.tblMain.getEditManager().stopEditing();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            BOSUuid cardID = (BOSUuid)this.tblMain.getCell(i, "cardID").getValue();
            if (cardID == null) continue;
            BigDecimal value = (BigDecimal)this.tblMain.getCell(i, DEC_VALUE).getValue();
            BigDecimal bakValue = (BigDecimal)this.tblMain.getCell(i, BAK_DEC_VALUE).getValue();
            if (value == null || bakValue == null || value.doubleValue() == bakValue.doubleValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(this.getCurrentCompany().getId().toString());
        FaDecValueInfo info = null;
        info = FaDecValueFactory.getRemoteInstance().verifySubmit(this.editData);
        if (MsgBox.isOk((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)CARD_RES_PATH, (String)"IF_AUDIT")))) {
            if (this.isModify() && MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"saveModify")))) {
                this.verify(e);
                this.verifyBeforeSubmit();
                info = FaDecValueFactory.getRemoteInstance().verifySubmit(this.editData);
                if (info.get(ERROR_INFO) != null && !MsgBox.isOk((int)MsgBox.showConfirm2((Component)((Object)this), (String)info.get(ERROR_INFO).toString()))) {
                    SysUtil.abort();
                }
                this.getBizInterface().submit((CoreBaseInfo)info);
            }
            FaDecValueFactory.getRemoteInstance().passAudit((IObjectPK)new ObjectUuidPK(info.getId()));
            this.execute(true);
            this.showAuditSuccess();
        } else {
            SysUtil.abort();
        }
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(this.getCurrentCompany().getId().toString());
        FaDecValueInfo info = null;
        info = FaDecValueFactory.getRemoteInstance().verifySubmit(this.editData);
        if (MsgBox.isOk((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)CARD_RES_PATH, (String)"IF_UNAUDIT")))) {
            FaDecValueFactory.getRemoteInstance().unpassAudit((IObjectPK)new ObjectUuidPK(info.getId()));
            this.execute(true);
            this.showUnAuditSuccess();
        } else {
            SysUtil.abort();
        }
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = new CommonQueryDialog();
            this.initCommonQueryDialog();
        }
        if (this.commonQueryDialog.show()) {
            this.execute(false);
        } else {
            SysUtil.abort();
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.execute(true);
    }

    @Override
    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        FaDecValueFactory.getRemoteInstance().deleteVoucher((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        this.execute(true);
        this.showDelVoucherSuccess();
    }

    @Override
    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        String id = this.getUIContext().get("ID").toString();
        this.setDataObject(this.getValue((IObjectPK)new ObjectUuidPK(id)));
        FaClientUtils.checkForGenVoucher();
        super.actionVoucher_actionPerformed(e);
        this.execute(true);
    }

    @Override
    public void actionReset_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            if (this.tblMain.getCell(i, BAK_DEC_VALUE).getValue() == null) continue;
            this.tblMain.getCell(i, DEC_VALUE).setValue(this.tblMain.getCell(i, BAK_DEC_VALUE).getValue());
        }
        this.setSumDecValue();
    }

    @Override
    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        FaDecValueEntryCollection entryColl = this.editData.getEntry();
        HashMap ids = new HashMap();
        Vector<String> changeBillVector = new Vector<String>();
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            FaDecValueEntryInfo entryInfo = entryColl.get(i);
            if (entryInfo.getChangeBill() == null || entryInfo.getChangeBill().getId() == null) continue;
            changeBillVector.add(entryInfo.getChangeBill().getId().toString());
        }
        if (changeBillVector.size() > 0) {
            ids.put(new FaChangeBillInfo().getBOSType().toString(), changeBillVector);
        }
        if (this.editData.isFiVouchered()) {
            Vector<String> voucherBillVector = new Vector<String>();
            IBOTRelation iBotRelation = BOTRelationFactory.getRemoteInstance();
            BOTRelationCollection relationCollection = iBotRelation.getCollection(new EntityViewInfo("where srcObjectID ='" + this.editData.getId() + "' and destEntityID ='" + VOUCHERTYPE + "'"));
            if (relationCollection.size() > 0) {
                for (BOTRelationInfo relationInfo : relationCollection) {
                    voucherBillVector.add(relationInfo.getDestObjectID());
                }
            }
            if (voucherBillVector.size() > 0) {
                ids.put(new VoucherInfo().getBOSType().toString(), voucherBillVector);
            }
        }
        FaClientUtils.showTraceUI((CoreUI)this, ids, 0);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Peroid", this.lblPeriodValue.getText());
        if (this.bizPromptBoxChangeMode.getData() != null) {
            map.put("AlterMode", ((FaAlterModeInfo)this.bizPromptBoxChangeMode.getData()).getName());
        }
        return map;
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer period = new StringBuffer(this.lblPeriod.getText()).append("&[Peroid]&| ");
        header.addRow(period.toString(), sa);
        StringBuffer alterMode = new StringBuffer(this.labConChangeMode.getBoundLabelText());
        alterMode.append("\uff1a").append("&[AlterMode]&| ");
        header.addRow(alterMode.toString(), sa);
    }

    protected ExtVarProvider getPrintExtVarProvider() {
        class MyExtVarProvider
        implements ExtVarProvider {
            MyExtVarProvider() {
            }

            public Variant requestVarData(String varName) {
                Map varMap = FaDecValueUI.this.preparePrintVariantMap();
                if (varMap == null) {
                    return null;
                }
                Object obj = varMap.get(varName);
                if (!(obj instanceof Variant)) {
                    Variant v = new Variant();
                    v.setObject(obj);
                    return v;
                }
                return (Variant)obj;
            }
        }
        return new MyExtVarProvider();
    }

    protected CompanyOrgUnitInfo getCurrentCompany() {
        if (this.currCompany == null) {
            String companyId = null;
            if (FaClientUtils.isFromWorkflow(this.getUIContext())) {
                BillBaseInfo initObj = null;
                if (this.getUIContext().get("ID") != null) {
                    String id = this.getUIContext().get("ID").toString();
                    try {
                        initObj = (BillBaseInfo)this.getBizInterface().getValue("select company.id where id='" + id + "'");
                    }
                    catch (Exception e) {
                        this.handleException(e);
                        SysUtil.abort();
                    }
                }
                companyId = initObj == null ? SysContext.getSysContext().getCurrentFIUnit().getId().toString() : initObj.getCompany().getId().toString();
            } else {
                companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            }
            try {
                this.currCompany = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyId)));
            }
            catch (Exception e) {
                this.handleException(e);
                SysUtil.abort();
            }
        }
        return this.currCompany;
    }

    protected void addLine(KDTable table) {
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }

    private void verifyBeforeSubmit() {
        StringBuffer msg = new StringBuffer();
        for (int i = 0; i < this.tblMain.getRowCount() - 1; ++i) {
            BigDecimal decValuea;
            BigDecimal decValue;
            IRow row = this.tblMain.getRow(i);
            Object policy = row.getCell("decValuePolicy").getValue();
            if (row.getCell(DEC_VALUE).getValue() == null) {
                this.tblMain.getCell(i, DEC_VALUE).setValue((Object)new BigDecimal("0.00"));
            }
            Object decValueObject = row.getCell(DEC_VALUE).getValue();
            Object assetNumber = row.getCell("assetNumber").getValue();
            if (FaDecValueRuleEnum.CanDecValueAndCanNotCancel.equals(policy) && decValueObject != null && decValueObject instanceof BigDecimal && (decValue = (BigDecimal)decValueObject).doubleValue() < 0.0) {
                msg.append(MessageFormat.format(EASResource.getString((String)RES_PATH, (String)"Line_And_CardNum"), i + 1 + "", assetNumber));
                msg.append(EASResource.getString((String)RES_PATH, (String)"decValueIsNegative")).append(";\n");
            }
            BigDecimal neatValue = (BigDecimal)row.getCell(NEAT_VALUE).getValue();
            BigDecimal decedValue = (BigDecimal)row.getCell(DECED_VALUE).getValue();
            if (decedValue.add(decValuea = (BigDecimal)row.getCell(DEC_VALUE).getValue()).compareTo(this.ZERO) < 0) {
                msg.append(MessageFormat.format(EASResource.getString((String)RES_PATH, (String)"Line_And_CardNum"), i + 1 + "", assetNumber));
                msg.append(EASResource.getString((String)RES_PATH, (String)"neatValueCondtion1")).append(";\n");
            }
            if (decedValue.add(decValuea).compareTo(neatValue) <= 0) continue;
            msg.append(MessageFormat.format(EASResource.getString((String)RES_PATH, (String)"Line_And_CardNum"), i + 1 + "", assetNumber));
            msg.append(EASResource.getString((String)RES_PATH, (String)"neatValueCondtion2")).append(";\n");
        }
        if (msg.length() > 0) {
            String title = EASResource.getString((String)RES_PATH, (String)"Fail_To_Operate");
            MsgBox.showDetailAndOK((Component)((Object)this), (String)title.toString(), (String)msg.toString(), (int)1);
            SysUtil.abort();
        }
    }
}

