/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaDepCalFacadeFactory;
import com.kingdee.eas.fi.fa.manage.FaDepChgEnum;
import com.kingdee.eas.fi.fa.manage.IFaDepCalFacade;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaDepBackChgUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class FaDepBackChgUI
extends AbstractFaDepBackChgUI {
    private static final Logger logger = CoreUIObject.getLogger(FaDepBackChgUI.class);
    FaCurCardInfo curcardInfo;

    private ArrayList searchDepBack(int year, int number, FaCurCardInfo curCardInfo) {
        try {
            return this.getBizInterface().emuCalDep(year, number, (IObjectValue)curCardInfo);
        }
        catch (Exception e) {
            this.handUIException(e);
            return new ArrayList();
        }
    }

    private void fillComponent(ArrayList searchResult) {
        this.getTable().removeRows();
        for (int rowCount = 0; rowCount < searchResult.size(); ++rowCount) {
            IRow row = this.getTable().addRow();
            HashMap lineData = (HashMap)searchResult.get(rowCount);
            Set resultKey = lineData.keySet();
            for (int colCount = 0; colCount < resultKey.size(); ++colCount) {
                String cellName = (String)resultKey.toArray()[colCount];
                logger.debug((Object)("CELL NAME==" + cellName + " VALUE==" + lineData.get(cellName)));
                if (cellName.equalsIgnoreCase("deprbalance") || cellName.equalsIgnoreCase("shoulddeprbalance")) {
                    BigDecimal balance = rowCount == 0 ? (BigDecimal)lineData.get(cellName) : ((BigDecimal)this.getTable().getRow(rowCount - 1).getCell(cellName).getValue()).add((BigDecimal)lineData.get(cellName));
                    row.getCell(cellName).setValue((Object)balance);
                    continue;
                }
                row.getCell(cellName).setValue(lineData.get(cellName));
            }
        }
    }

    protected IFaDepCalFacade getBizInterface() throws Exception {
        return FaDepCalFacadeFactory.getRemoteInstance();
    }

    private KDTable getTable() {
        return this.resultTable;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.getTable().checkParsed();
        this.getTable().getStyleAttributes().setLocked(true);
        this.getTable().getSelectManager().setSelectMode(2);
        this.comboChgType.addItems(FaDepChgEnum.getEnumList().toArray());
        int currencyScale = FaClientUtils.getCurrencyScale();
        for (int i = 1; i < 6; ++i) {
            FaClientUtils.changeTableNumberFormat(this.getTable(), i, FaClientUtils.getDecimalFormat(currencyScale));
        }
        FaClientUtils.setComponentPrecision(new Object[]{this.txtChgValue}, currencyScale);
        if (this.getUIContext().get("curcard") != null) {
            this.curcardInfo = (FaCurCardInfo)this.getUIContext().get("curcard");
            this.curcardInfo.getCompany().getBaseCurrency().setPrecision(currencyScale);
        } else {
            this.curcardInfo = new FaCurCardInfo();
        }
        this.btnCalc.setIcon(EASResource.getIcon((String)"imgTbtn_compute"));
        this.enableExportExcel(this.getTable());
        PeriodInfo startPeriod = (PeriodInfo)PeriodFactory.getRemoteInstance().getValue("select id, periodyear, periodnumber where id='" + this.curcardInfo.getPeriod().getId().toString() + "'");
        this.curcardInfo.setPeriod(startPeriod);
        PeriodInfo curPeriod = FaClientUtils.getFACurrentPeriod();
        this.initPeriodYear(startPeriod, curPeriod);
        this.initDepChgType();
        this.fillPeriodComponent(curPeriod);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.curcardInfo.put("backchgvalue", this.txtChgValue.getBigDecimalValue());
        Util.getWindow((Component)((Object)this)).dispose();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        Util.getWindow((Component)((Object)this)).dispose();
    }

    @Override
    public void actionCalc_actionPerformed(ActionEvent e) throws Exception {
        int year = (Integer)this.spPeriodYear.getValue();
        int number = (Integer)this.spPeriodNumber.getValue();
        this.fillComponent(this.searchDepBack(year, number, this.curcardInfo));
        this.selectDeprChg((FaDepChgEnum)((Object)this.comboChgType.getSelectedItem()));
    }

    private void initPeriodYear(final PeriodInfo startPeriod, final PeriodInfo curPeriod) {
        SpinnerNumberModel yearModel = (SpinnerNumberModel)this.spPeriodYear.getModel();
        yearModel.setMinimum(new Integer(startPeriod.getPeriodYear()));
        yearModel.setMaximum(new Integer(curPeriod.getPeriodYear()));
        this.spPeriodYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaDepBackChgUI.this.changePeriodYear(startPeriod, curPeriod);
            }
        });
    }

    private void changePeriodYear(PeriodInfo startPeriodInfo, PeriodInfo curPeriodInfo) {
        if (startPeriodInfo == null || curPeriodInfo == null) {
            return;
        }
        ObjectUuidPK companyPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getId());
        Integer year = (Integer)this.spPeriodYear.getValue();
        SpinnerNumberModel numberModel = (SpinnerNumberModel)this.spPeriodNumber.getModel();
        try {
            int maxPeriod = PeriodUtils.getMaxPeriodNumber(null, (int)year, (IObjectPK)companyPK);
            int minPeriod = PeriodUtils.getMinPeriodNumber(null, (int)year, (IObjectPK)companyPK);
            numberModel.setMaximum(new Integer(maxPeriod));
            numberModel.setMinimum(new Integer(minPeriod));
            if (startPeriodInfo.getPeriodYear() == year.intValue()) {
                numberModel.setMinimum(new Integer(startPeriodInfo.getPeriodNumber()));
            }
            if (startPeriodInfo.getPeriodYear() > year) {
                this.spPeriodYear.setValue((Object)new Integer(startPeriodInfo.getPeriodYear()));
            }
            if (year.intValue() == curPeriodInfo.getPeriodYear()) {
                numberModel.setMaximum(new Integer(curPeriodInfo.getPeriodNumber()));
            }
            this.spPeriodNumber.setValue(numberModel.getMinimum());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void fillPeriodComponent(PeriodInfo periodInfo) {
        if (periodInfo != null) {
            this.spPeriodYear.setValue((Object)new Integer(periodInfo.getPeriodYear()));
        }
    }

    private void selectDeprChg(FaDepChgEnum selectType) {
        IRow lastRow = this.getTable().getRow(this.getTable().getRowCount() - 1);
        if (lastRow != null) {
            this.txtChgValue.setValue(selectType == FaDepChgEnum.DepChg ? lastRow.getCell("deprbalance").getValue() : lastRow.getCell("shoulddeprbalance").getValue());
        }
    }

    private void initDepChgType() {
        this.comboChgType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FaDepBackChgUI.this.selectDeprChg((FaDepChgEnum)((Object)FaDepBackChgUI.this.comboChgType.getSelectedItem()));
            }
        });
    }
}

