/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaDepCalForCoalFilterUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FaDepCalForCoalFilterUI
extends AbstractFaDepCalForCoalFilterUI {
    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        PeriodInfo startPeriod = FaClientUtils.getFAStartPeriod();
        PeriodInfo curPeriod = FaClientUtils.getFACurrentPeriod();
        this.initPeriodYear(startPeriod, curPeriod);
        this.fillPeriodComponent(curPeriod);
        this.labAssetNumber.setVisible(false);
        this.labAssetName.setVisible(false);
    }

    private void initPeriodYear(final PeriodInfo startPeriod, final PeriodInfo curPeriod) {
        SpinnerNumberModel yearModel = (SpinnerNumberModel)this.spPeriodYear.getModel();
        yearModel.setMinimum(new Integer(startPeriod.getPeriodYear()));
        yearModel.setMaximum(new Integer(curPeriod.getPeriodYear()));
        this.spPeriodYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaDepCalForCoalFilterUI.this.changePeriodYear(startPeriod, curPeriod);
            }
        });
    }

    private void fillPeriodComponent(PeriodInfo periodInfo) {
        if (periodInfo != null) {
            this.spPeriodYear.setValue((Object)new Integer(periodInfo.getPeriodYear()));
            this.spPeriodNumber.setValue((Object)new Integer(periodInfo.getPeriodNumber()));
        }
    }

    private void changePeriodYear(PeriodInfo startPeriodInfo, PeriodInfo curPeriodInfo) {
        if (startPeriodInfo == null || curPeriodInfo == null) {
            return;
        }
        ObjectUuidPK companyPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getId());
        Integer year = (Integer)this.spPeriodYear.getValue();
        SpinnerNumberModel numberModel = (SpinnerNumberModel)this.spPeriodNumber.getModel();
        try {
            int maxPeriod = PeriodUtils.getMaxPeriodNumber(null, (int)year, (IObjectPK)companyPK);
            int minPeriod = PeriodUtils.getMinPeriodNumber(null, (int)year, (IObjectPK)companyPK);
            numberModel.setMaximum(new Integer(maxPeriod));
            numberModel.setMinimum(new Integer(minPeriod));
            if (startPeriodInfo.getPeriodYear() == year.intValue()) {
                numberModel.setMinimum(new Integer(startPeriodInfo.getPeriodNumber()));
            }
            if (startPeriodInfo.getPeriodYear() > year) {
                this.spPeriodYear.setValue((Object)new Integer(startPeriodInfo.getPeriodYear()));
            }
            if (year.intValue() == curPeriodInfo.getPeriodYear()) {
                numberModel.setMaximum(new Integer(curPeriodInfo.getPeriodNumber()));
            }
            this.spPeriodNumber.setValue(numberModel.getMinimum());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public FilterInfo getFilterInfo() {
        FilterInfo f = new FilterInfo();
        FilterItemCollection items = f.getFilterItems();
        StringBuffer sbFormula = new StringBuffer();
        int count = 3;
        FaClientUtils.checkComp(null, SysContext.getSysContext().getCurrentFIUnit());
        items.add(new FilterItemInfo("period.periodYear", this.spPeriodYear.getValue(), CompareType.EQUALS));
        items.add(new FilterItemInfo("period.periodNumber", this.spPeriodNumber.getValue(), CompareType.EQUALS));
        items.add(new FilterItemInfo("depType", (Object)new Integer(1), CompareType.EQUALS));
        sbFormula.append("#0 and #1 and #2 ");
        if (SysContext.getSysContext().getCurrentFIUnit() != null) {
            items.add(new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
            if (count == 0) {
                sbFormula.append("#" + count++);
            } else {
                sbFormula.append(" and #" + count++);
            }
        }
        if (this.txtAssetName.getText() != null && this.txtAssetName.getText().trim().length() > 0) {
            items.add(new FilterItemInfo("lnkFaDepreEntry.faCurCard.assetName", (Object)this.txtAssetName.getText().trim(), CompareType.LIKE));
            if (count == 0) {
                sbFormula.append("#" + count++);
            } else {
                sbFormula.append(" and #" + count++);
            }
        }
        if (this.txtAssetNumber.getText() != null && this.txtAssetNumber.getText().trim().length() > 0) {
            items.add(new FilterItemInfo("lnkFaDepreEntry.faCurCard.number", (Object)this.txtAssetNumber.getText().trim(), CompareType.LIKE));
            if (count == 0) {
                sbFormula.append("#" + count++);
            } else {
                sbFormula.append(" and #" + count++);
            }
        }
        if (sbFormula.toString().length() != 0) {
            f.setMaskString(sbFormula.toString());
        }
        return f;
    }

    public void loadData(EntityViewInfo viewInfo) {
        try {
            FilterItemCollection currentFilterItemCollection = viewInfo.getFilter().getFilterItems();
            if (currentFilterItemCollection == null || currentFilterItemCollection.size() == 0) {
                return;
            }
            int currentFilterItemCollectionSize = currentFilterItemCollection.size();
            for (int i = 0; i < currentFilterItemCollectionSize; ++i) {
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void clear() {
        this.txtAssetName.setText(null);
        this.txtAssetNumber.setText(null);
    }
}

