/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.client.AccountClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.basedata.FaUtils;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaDepCalcForCoalFacadeFactory;
import com.kingdee.eas.fi.fa.manage.FaDepDistributeCollection;
import com.kingdee.eas.fi.fa.manage.FaDepDistributeFactory;
import com.kingdee.eas.fi.fa.manage.FaDepEntryStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaDepreciationCollection;
import com.kingdee.eas.fi.fa.manage.FaDepreciationEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaDepreciationEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaDepreciationFactory;
import com.kingdee.eas.fi.fa.manage.FaDepreciationInfo;
import com.kingdee.eas.fi.fa.manage.FaPeriodCloseFacadeFactory;
import com.kingdee.eas.fi.fa.manage.FaPeriodException;
import com.kingdee.eas.fi.fa.manage.IFaDepCalcForCoalFacade;
import com.kingdee.eas.fi.fa.manage.IFaDepDistribute;
import com.kingdee.eas.fi.fa.manage.IFaDepreciation;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaDepCalForCoalUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.manage.client.FaDepCalForCoalFilterUI;
import com.kingdee.eas.fi.rpt.BalanceTypeEnum;
import com.kingdee.eas.fi.rpt.IReportCacl;
import com.kingdee.eas.fi.rpt.ReportCaclFactory;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class FaDepCalForCoalUI
extends AbstractFaDepCalForCoalUI {
    BigDecimal MAXVAL = FaClientUtils.MAX_DECIMAL;
    BigDecimal ZERO = new BigDecimal("0.00");
    private String ColumnIndex_EntryId = "id";
    private String ColumnIndex_Ratio = "ratio";
    private String ColumnIndex_depreTerm = "depreTerm";
    private String ColumnIndex_wellCostTerm = "wellcostTerm";
    private String ColumnIndex_TotalDep = "totalDep";
    private String ColumnIndex_WellCost = "wellCost";
    private String ColumnIndex_TotalDepCost = "totalDepCost";
    private String ColumnIndex_State = "state";
    private String ColumnIndex_CardID = "cardid";
    private IFaDepCalcForCoalFacade manager = null;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public String getUITitle() {
        return EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCalForWell_Title");
    }

    @Override
    public void actionCalc_actionPerformed(ActionEvent e) throws Exception {
        this.checkCurrentPeriod();
        this.checkBeforCalc(e);
        String companyID = this.aCompanyOrgUnitInfo.getId().toString();
        BigDecimal workLoad = this.formatBigDecmal(this.txtWork.getBigDecimalValue());
        BigDecimal fixRatio = this.formatBigDecmal(this.txtFixRatio.getBigDecimalValue());
        this.editData = (FaDepreciationInfo)this.getManager().calDep(companyID, this.currentPeriod, fixRatio, workLoad);
        if (this.editData != null) {
            this.showData(this.editData);
            this.setBtnEditable(true);
            this.actionSubmit.setEnabled(true);
            BigDecimal total = this.ZERO;
            for (int i = 0; i < this.getDetailTable().getRowCount() - 1; ++i) {
                total = total.add((BigDecimal)this.getDetailTable().getRow(i).getCell(this.getColumnIndex_ShouldDep()).getValue());
            }
            String str = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCal_Message1") + "\n";
            str = str + MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCal_Message2"), this.editData.getLnkFaDepreEntry().size()) + "\n";
            str = str + MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCal_Message4"), FaClientUtils.formatDecimal(total, 2)) + "\n";
            MsgBox.showInfo((Component)((Object)this), (String)str);
            if (workLoad.multiply(fixRatio).setScale(2, 4).compareTo(total) > 0) {
                MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCalForCoal_noAssignComplete3"), workLoad.multiply(fixRatio).subtract(total).setScale(2, 4)));
            }
            this.showAuditMessage(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCalForCoal_CalcSuccess"));
        }
    }

    @Override
    public void actionUndo_actionPerformed(ActionEvent e) throws Exception {
        this.checkCurrentPeriod();
        if (this.editData.isFiVouchered()) {
            MsgBox.showInfo((Component)((Object)this), (String)(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCalForCoal_VoucherAlready") + " " + EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCalForCoal_NoUndo")));
            SysUtil.abort();
        }
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        this.showData(this.editData);
    }

    @Override
    public void actionDistribute_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock sb = this.getDetailTable().getSelectManager().get();
        if (sb == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepMnt_SelectOneRow"));
            return;
        }
        int rowNum = this.getDetailTable().getSelectManager().get().getTop();
        if (rowNum == this.getDetailTable().getRowCount() - 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCal_haveRowDistribute"));
            SysUtil.abort();
        }
        if (this.editData.isFiVouchered()) {
            MsgBox.showInfo((Component)((Object)this), (String)(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCalForCoal_VoucherAlready") + " " + EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCalForCoal_NoDistribute")));
            SysUtil.abort();
        }
        FaDepreciationEntryInfo depEntry = (FaDepreciationEntryInfo)this.getDetailTable().getRow(rowNum).getUserObject();
        BigDecimal totalDepValue = (BigDecimal)this.getDetailTable().getRow(rowNum).getCell(this.getColumnIndex_TotalDep()).getValue();
        if (totalDepValue.subtract(depEntry.getEndDepre().add(depEntry.getWellCost().subtract(depEntry.getDepreciation()))).compareTo(this.ZERO) <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCalForCoal_DepEqualZero"));
            SysUtil.abort();
        }
        super.actionDistribute_actionPerformed(e);
    }

    @Override
    protected void setDistributeContext(Map uiContext) throws Exception {
        super.setDistributeContext(uiContext);
        int rowNum = this.getDetailTable().getSelectManager().get().getTop();
        FaDepreciationEntryInfo depEntry = (FaDepreciationEntryInfo)this.getDetailTable().getRow(rowNum).getUserObject();
        BigDecimal totalDepValue = (BigDecimal)this.getDetailTable().getRow(rowNum).getCell(this.getColumnIndex_TotalDep()).getValue();
        BigDecimal objDep = totalDepValue.subtract(depEntry.getEndDepre().add(depEntry.getWellCost().subtract(depEntry.getDepreciation())));
        uiContext.put("dep", objDep);
    }

    private void checkBeforCalc(ActionEvent e) throws Exception {
        String companyID = this.aCompanyOrgUnitInfo.getId().toString();
        this.checkFaAadCoadInit(companyID);
        if (this.getManager().isNeedInit(companyID)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCalForCoal_NoInitForUI"));
            SysUtil.abort();
        }
        if (this.txtWork.getText() == null || "".equals(this.txtWork.getText()) || this.txtFixRatio.getText() == null || "".equals(this.txtFixRatio.getText())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCalForCoal_InputCheck"));
            SysUtil.abort();
        }
        if (this.getManager().isAlreadyDep() && MsgBox.isCancel((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCalForCoal_NeedRedepr")))) {
            SysUtil.abort();
        }
        this.getManager().checkBeforeDep();
    }

    private void checkFaAadCoadInit(String companyID) throws BOSException, EASBizException, Exception {
        boolean isInit = this.getManager().isAlreadyInit(companyID);
        if (!isInit) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCalForCoal_MustInitForUI"));
            SysUtil.abort();
        } else if (CheckedStatusEnum.UNAUDITED == this.getManager().getInitDepInfo(companyID, true).getCheckedStatus()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCalForCoal_MustEndInitForUI"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkCurrentPeriod();
        if (this.editData != null) {
            if (this.isModify()) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCalForCoal_DataChange"));
                SysUtil.abort();
            }
            BigDecimal workLoad = this.formatBigDecmal(this.txtWork.getBigDecimalValue());
            BigDecimal fixRatio = this.formatBigDecmal(this.txtFixRatio.getBigDecimalValue());
            BigDecimal totalDep = this.formatBigDecmal((BigDecimal)this.getDetailTable().getRow(this.getDetailTable().getRowCount() - 1).getCell(this.getColumnIndex_Depreciation()).getValue());
            if (workLoad.multiply(fixRatio).setScale(2, 4).compareTo(totalDep.setScale(2, 4)) != 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCalForCoal_SumValueErr"));
                SysUtil.abort();
            }
            if (MsgBox.isOk((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCalForCoal_IsAudit")))) {
                this.getManager().auditBill(this.editData.getId().toString());
                this.showAuditMessage(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCalForCoal_AuditSuccess"));
            } else {
                SysUtil.abort();
            }
            this.refreshUI();
        }
    }

    @Override
    protected void refreshUI() throws Exception {
        if (this.editData != null) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)this.editData.getId().toString()));
            IFaDepreciation i = FaDepreciationFactory.getRemoteInstance();
            this.editData = i.getFaDepreciationInfo((IObjectPK)pk, FaDepCalForCoalUI.getDeprSelector());
            this.showData(this.editData);
        }
    }

    protected void checkCurrentPeriod() throws Exception {
        PeriodInfo period = FaClientUtils.getFACurrentPeriod();
        if (!period.getId().toString().equals(this.currentPeriod.getId().toString())) {
            this.currentPeriod = period;
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCalForCoal_RefreshUI"));
            SysUtil.abort();
        }
        if (this.currentPeriod.isIsAdjustPeriod()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCalForCoal_Adjust"));
            SysUtil.abort();
        }
    }

    private void showAuditMessage(String str) {
        this.setMessageText(FrameWorkUtils.getClassAlias((CoreBaseInfo)new FaDepreciationInfo()) + " " + str);
        this.showMessage();
    }

    @Override
    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkCurrentPeriod();
        if (this.editData != null) {
            for (int i = 0; i < this.getDetailTable().getRowCount() - 1; ++i) {
                FaDepEntryStatusEnum depState = (FaDepEntryStatusEnum)((Object)this.getDetailTable().getRow(i).getCell(this.getColumnIndex_State()).getValue());
                if (depState == FaDepEntryStatusEnum.YAUDIT_NMODIFY) continue;
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCalForCoal_NoAudit"));
                SysUtil.abort();
            }
            super.actionVoucher_actionPerformed(e);
            this.refreshUI();
        }
    }

    protected CoreBillBaseCollection getBillCollection() throws Exception {
        CoreBillBaseCollection sourceBillCollection = new CoreBillBaseCollection();
        if (this.editData != null && this.editData.getId() != null) {
            sourceBillCollection.add((CoreBillBaseInfo)this.editData);
        }
        return sourceBillCollection;
    }

    @Override
    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkCurrentPeriod();
        if (this.editData != null) {
            super.actionDelVoucher_actionPerformed(e);
            this.refreshUI();
        }
    }

    @Override
    public void onLoad() throws Exception {
        this.getDetailTable().checkParsed();
        this.getDetailTable().getColumn(this.ColumnIndex_WellCost).getStyleAttributes().setHided(true);
        this.getDetailTable().getColumn(this.ColumnIndex_wellCostTerm).getStyleAttributes().setHided(true);
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        this.checkFaAadCoadInit(aCompanyOrgUnitInfo.getId().toString());
        FaClientUtils.checkComp((Component)((Object)this), aCompanyOrgUnitInfo);
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        FaClientUtils.checkAccountSwap((Component)((Object)this), company);
        super.onLoad();
        this.amountScale = 2;
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.menuItemAudit.setAccelerator(KeyStroke.getKeyStroke("ctrl U"));
        this.menuItemUnAudit.setAccelerator(KeyStroke.getKeyStroke("ctrl shift U"));
        this.MenuItemVoucher.setAccelerator(KeyStroke.getKeyStroke("ctrl K"));
        this.menuItemDelVoucher.setAccelerator(KeyStroke.getKeyStroke("ctrl shift K"));
        if (this.editData != null && this.editData.getCheckedStatus() != CheckedStatusEnum.UNAUDITED) {
            this.setBtnEditable(false);
        }
        this.txtWork.setEditable(true);
        this.txtFixRatio.setEditable(true);
        this.getDetailTable().getColumn(this.getColumnIndex_Ratio()).getStyleAttributes().setHided(true);
        EntityViewInfo viewInfo = new EntityViewInfo();
        AccountClientUtils.checkCompanyAccountTable((CoreUI)this, (CompanyOrgUnitInfo)company);
        FilterInfo filterInfo = FaClientUtils.getAccountViewFilter((String)company.getCU().getId().toString(), (String)company.getAccountTable().getId().toString());
        viewInfo.setFilter(filterInfo);
        this.promptAccount.setEnabled(true);
        this.promptAccount.setSelector((KDPromptSelector)FaClientUtils.getAccountPromptBox((IUIObject)this, company));
        this.promptAccount.setEntityViewInfo(viewInfo);
        this.promptAccount.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                FaDepCalForCoalUI.this.searchAcctValue(e);
            }
        });
        this.setDataFormat();
        this.showPeriod(this.currentPeriod);
        this.actionCalc.setEnabled(true);
        this.actionUnAudit.setVisible(false);
        this.actionUnAudit.setEnabled(false);
        this.actionAudit.setVisible(true);
        this.separator5.setVisible(this.actionAudit.isVisible());
        this.actionWorkFlowG.setVisible(false);
        this.actionWorkFlowG.setEnabled(false);
        this.menuWorkflow.setVisible(false);
        this.menuWorkflow.setEnabled(false);
        this.actionRemoveAdj.setVisible(false);
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        this.actionAuditResult.setVisible(false);
        this.actionAuditResult.setEnabled(false);
        this.btnAuditResult.setEnabled(false);
        this.btnAuditResult.setVisible(false);
    }

    protected void searchAcctValue(PreChangeEvent event) {
        if (event == null || event.getData() == null) {
            return;
        }
        try {
            BigDecimal result;
            AccountViewInfo selectAccont = (AccountViewInfo)event.getData();
            IReportCacl reportCacl = ReportCaclFactory.getRemoteInstance();
            if (this.currentPeriod == null) {
                this.currentPeriod = FaClientUtils.getFACurrentPeriod();
            }
            if ((result = reportCacl.acct(SysContext.getSysContext().getCurrentFIUnit().getNumber(), selectAccont.getNumber(), BalanceTypeEnum.QJF, this.currentPeriod.getPeriodYear(), this.currentPeriod.getPeriodNumber(), this.currentPeriod.getPeriodYear(), this.currentPeriod.getPeriodNumber(), "GLC", false, false, false)) == null || result.compareTo(this.ZERO) <= 0) {
                MsgBox.showInfo((Component)((Object)this), (String)(selectAccont.getNumber() + " " + EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCalForCoal_AcctErr")));
                event.setResult(-1);
                this.promptAccount.setValue(null);
            } else {
                this.txtWork.setValue((Object)result);
            }
        }
        catch (Exception e) {
            event.setResult(-1);
            this.promptAccount.setValue(null);
            this.handUIException(e);
        }
    }

    @Override
    protected void initBtn() {
        this.btnCalc.setIcon(EASResource.getIcon((String)"imgTbtn_counter"));
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.menuItemCacl.setIcon(EASResource.getIcon((String)"imgTbtn_counter"));
        this.menuItemAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        super.initBtn();
    }

    @Override
    protected void handleQuery(ActionEvent e) throws Exception {
        EntityViewInfo view = this.showFilter(e);
        if (view == null) {
            return;
        }
        this.getData(view);
    }

    @Override
    protected CommonQueryDialog getDialog() {
        if (this.dialog == null) {
            this.dialog = new CommonQueryDialog();
            if (this.getUIWindow() == null) {
                this.dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.dialog.setOwner((Component)((Object)this));
            }
            this.dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.dialog.setEntityViewInfo(new EntityViewInfo());
            this.dialog.setQueryObjectPK((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.fa.manage", "FaDepreationQuery"));
            this.dialog.setShowFilter(false);
            this.dialog.setShowSorter(false);
            this.dialog.setDisVisiableDefaultView(true);
            try {
                this.dialog.addUserPanel((KDPanel)new FaDepCalForCoalFilterUI());
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            this.dialog.setTitle(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepMnt_DepFindForWell"));
        }
        return this.dialog;
    }

    @Override
    protected void getData(EntityViewInfo view) throws Exception {
        view.getSelector().addObjectCollection((IObjectCollection)FaDepCalForCoalUI.getDeprSelector());
        IFaDepreciation iDepre = FaDepreciationFactory.getRemoteInstance();
        FaDepreciationCollection col = iDepre.getFaDepreciationCollection(view);
        if (col.size() > 0) {
            this.editData = col.get(0);
            this.showData(this.editData);
        } else {
            this.editData = null;
            boolean isCurrPeriod = false;
            if (view != null) {
                this.currentPeriod = FaClientUtils.getFACurrentPeriod();
                int periodYear = this.currentPeriod.getPeriodYear();
                int periodNumber = this.currentPeriod.getPeriodNumber();
                for (int i = 0; i < view.getFilter().getFilterItems().size(); ++i) {
                    if (view.getFilter().getFilterItems().get(i).getPropertyName().equalsIgnoreCase("period.periodYear")) {
                        periodYear = (Integer)view.getFilter().getFilterItems().get(i).getCompareValue();
                    }
                    if (!view.getFilter().getFilterItems().get(i).getPropertyName().equalsIgnoreCase("period.periodNumber")) continue;
                    periodNumber = (Integer)view.getFilter().getFilterItems().get(i).getCompareValue();
                }
                isCurrPeriod = this.currentPeriod.getPeriodYear() == periodYear && this.currentPeriod.getPeriodNumber() == periodNumber;
            }
            this.setBtnEditable(false);
            this.actionCalc.setEnabled(isCurrPeriod);
            this.getDetailTable().removeRows();
            this.txtFixRatio.setValue(null);
            this.txtWork.setValue(null);
            this.txtWork.setEditable(isCurrPeriod);
            this.txtFixRatio.setEditable(isCurrPeriod);
            this.promptAccount.setEnabled(isCurrPeriod);
        }
    }

    protected static SelectorItemCollection getDeprSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("period.*"));
        sic.add(new SelectorItemInfo("lnkFaDepreEntry.*"));
        sic.add(new SelectorItemInfo("lnkFaDepreEntry.faCurCard.*"));
        sic.add(new SelectorItemInfo("lnkFaDepreEntry.faCurCard.assetCat.*"));
        sic.add(new SelectorItemInfo("lnkFaDepreEntry.faCurCard.deprMethod.*"));
        sic.add(new SelectorItemInfo("lnkFaDepreEntry.depDistribute.*"));
        sic.add(new SelectorItemInfo("lnkFaDepreEntry.depDistribute.asstActType.*"));
        sic.add(new SelectorItemInfo("lnkFaDepreEntry.depDistribute.accountView.*"));
        return sic;
    }

    protected void showData(FaDepreciationInfo depInfo) throws Exception {
        this.setStrId(this.editData.getId().toString());
        this.currentPeriod = FaClientUtils.getFACurrentPeriod();
        FaDepreciationEntryCollection depEntryCol = depInfo.getLnkFaDepreEntry();
        this.hasGenVoucher = depInfo.isFiVouchered();
        this.showCalcData(depEntryCol);
        this.showDeprHead(depInfo);
        if (depInfo.getPeriod().getId() != null && !depInfo.getPeriod().getId().toString().equals(this.currentPeriod.getId().toString())) {
            this.setBtnEditable(false);
        } else {
            this.setBtnEditable(true);
            this.actionVoucher.setEnabled(!this.hasGenVoucher);
            this.actionDelVoucher.setEnabled(this.hasGenVoucher);
        }
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
    }

    private void showPeriod(PeriodInfo period) throws Exception {
        StringBuffer s = new StringBuffer();
        s.append(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepMnt_DepPeriod"));
        Integer yearVal = new Integer(period.getPeriodYear());
        Integer monthVal = new Integer(period.getPeriodNumber());
        s.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"displayPeriod"), yearVal.toString(), monthVal.toString()));
        this.lblTerm.setText(s.toString());
    }

    private void setDataFormat() throws Exception {
        this.txtWork.setDataType(1);
        this.txtWork.setHorizontalAlignment(4);
        this.txtWork.setNegatived(false);
        this.txtWork.setPrecision(this.amountScale);
        this.txtWork.setMaximumValue((Comparable)this.MAXVAL);
        this.txtWork.setMinimumValue((Comparable)this.ZERO);
        this.txtWork.setSupportedEmpty(false);
        this.txtWork.setImmediatelyValidate(true);
        this.txtFixRatio.setDataType(1);
        this.txtFixRatio.setHorizontalAlignment(4);
        this.txtFixRatio.setNegatived(false);
        this.txtFixRatio.setPrecision(this.amountScale);
        this.txtFixRatio.setMaximumValue((Comparable)this.MAXVAL);
        this.txtFixRatio.setMinimumValue((Comparable)this.ZERO);
        this.txtFixRatio.setSupportedEmpty(false);
    }

    private void showDeprHead(FaDepreciationInfo depInfo) throws Exception {
        this.txtFixRatio.setValue((Object)this.formatBigDecmal(depInfo.getFixRatio()));
        this.txtWork.setValue((Object)this.formatBigDecmal(depInfo.getWorkLoad()));
        this.showPeriod(depInfo.getPeriod());
    }

    private void setBtnEditable(boolean flag) {
        this.txtWork.setEditable(flag);
        this.txtFixRatio.setEditable(flag);
        this.promptAccount.setEnabled(flag);
        int size = this.getDetailTable().getRowCount() - 1;
        for (int i = 0; i < size; ++i) {
            IRow row = this.getDetailTable().getRow(i);
            for (int j = 0; j < this.getDetailTable().getColumnCount(); ++j) {
                this.getDetailTable().getColumn(j).getStyleAttributes().setLocked(true);
            }
            row.getCell(this.getColumnIndex_Depreciation()).getStyleAttributes().setLocked(!flag || this.hasGenVoucher);
            row.getCell(this.getColumnIndex_DepreTerm()).getStyleAttributes().setLocked(!flag || this.hasGenVoucher);
            row.getCell(this.getColumnIndex_WellCostTerm()).getStyleAttributes().setLocked(!flag || this.hasGenVoucher);
        }
        this.actionCalc.setEnabled(flag);
        this.actionSubmit.setEnabled(flag);
        this.actionUndo.setEnabled(flag);
        this.actionDistribute.setEnabled(true);
        this.actionVoucher.setEnabled(!this.hasGenVoucher);
        this.actionDelVoucher.setEnabled(this.hasGenVoucher);
        this.actionAudit.setEnabled(flag);
        this.actionTraceDown.setEnabled(true);
    }

    private void showCalcData(FaDepreciationEntryCollection dataCol) throws Exception {
        this.getDetailTable().removeRows();
        if (dataCol == null) {
            return;
        }
        boolean refresh = this.getDetailTable().isRefresh();
        this.getDetailTable().setRefresh(false);
        BigDecimal[] valueTotal = new BigDecimal[]{this.ZERO, this.ZERO, this.ZERO, this.ZERO, this.ZERO, this.ZERO, this.ZERO};
        int[] columnArray = new int[]{this.getColumnIndex_ShouldDep(), this.getColumnIndex_Depreciation(), this.getColumnIndex_TotalDep(), this.getColumnIndex_WellCost(), this.getColumnIndex_TotalDepCost(), this.getColumnIndex_DepreTerm(), this.getColumnIndex_WellCostTerm()};
        for (int i = 0; i < dataCol.size(); ++i) {
            FaDepreciationEntryInfo depEntry = dataCol.get(i);
            List list = this.getTableRowData(depEntry);
            IRow row = this.addOneRow(this.getDetailTable(), list);
            row.setUserObject((Object)depEntry);
            for (int count = 0; count < columnArray.length; ++count) {
                valueTotal[count] = valueTotal[count].add((BigDecimal)row.getCell(columnArray[count]).getValue());
            }
        }
        IRow newRow = this.getDetailTable().addRow();
        newRow.getCell(this.getColumnIndex_AssetCat()).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCalForCoal_Sum"));
        for (int count = 0; count < columnArray.length; ++count) {
            newRow.getCell(columnArray[count]).setValue((Object)valueTotal[count]);
        }
        newRow.getStyleAttributes().setLocked(true);
        newRow.getStyleAttributes().setBackground(this.getDetailTable().getRequiredColor());
        this.getDetailTable().setRefresh(refresh);
        this.getDetailTable().repaint();
    }

    private List getTableRowData(FaDepreciationEntryInfo row) throws Exception {
        ArrayList<Object> ls = new ArrayList<Object>();
        ls.add(row.getId());
        ls.add(row.getFaCurCard().getAssetCat().getName());
        ls.add(row.getFaCurCard().getNumber());
        ls.add(row.getFaCurCard().getAssetName());
        ls.add(row.getFaCurCard().getSpecs());
        ls.add(row.getAssetRatio());
        ls.add(row.getShouldDepre());
        ls.add(row.getDepreciation());
        BigDecimal assetValue = row.getFaCurCard().getAssetValue();
        BigDecimal accuDepr = row.getFaCurCard().getAccuDepr();
        BigDecimal decValue = row.getFaCurCard().getDecValue();
        BigDecimal neatRemValue = row.getFaCurCard().getNeatRemValue();
        BigDecimal canDeper = assetValue.subtract(accuDepr).subtract(decValue).subtract(neatRemValue);
        if (canDeper.compareTo(row.getDepreciation()) >= 0) {
            canDeper = row.getDepreciation();
        }
        ls.add(canDeper);
        ls.add(row.getDepreciation().subtract(canDeper));
        ls.add(row.getWellCost());
        ls.add(row.getEndDepre());
        ls.add(row.getWellCost().add(row.getEndDepre()));
        ls.add((Object)row.getState());
        ls.add(row.getNotDepre());
        ls.add(row.getDepreciation());
        ls.add(row.getFaCurCard().getId());
        ls.add(row.getFaCurCard().getDeprMethod().getNumber());
        ls.add(row.getFaCurCard().getAssetValue());
        row.getDepDistribute().clear();
        return ls;
    }

    @Override
    public boolean isModify() {
        boolean flag = false;
        int rowCount = this.getDetailTable().getRowCount() - 1;
        for (int i = 0; i < rowCount; ++i) {
            FaDepEntryStatusEnum newState;
            IRow row = this.getDetailTable().getRow(i);
            BigDecimal oldDep = (BigDecimal)row.getCell(this.getColumnIndex_BackDep()).getValue();
            BigDecimal newDep = (BigDecimal)row.getCell(this.getColumnIndex_Depreciation()).getValue();
            if (newDep == null) {
                newDep = new BigDecimal("0");
            }
            if (oldDep.compareTo(newDep) != 0) {
                flag = true;
                break;
            }
            FaDepreciationEntryInfo depEntry = (FaDepreciationEntryInfo)row.getUserObject();
            oldDep = depEntry.getWellCost();
            newDep = (BigDecimal)row.getCell(this.getColumnIndex_WellCost()).getValue();
            if (newDep == null) {
                newDep = new BigDecimal("0");
            }
            if (oldDep.compareTo(newDep) != 0) {
                flag = true;
                break;
            }
            oldDep = depEntry.getEndDepre().add(depEntry.getWellCost());
            newDep = (BigDecimal)row.getCell(this.getColumnIndex_TotalDepCost()).getValue();
            if (newDep == null) {
                newDep = new BigDecimal("0");
            }
            if (oldDep.compareTo(newDep) != 0) {
                flag = true;
                break;
            }
            FaDepEntryStatusEnum oldState = depEntry.getState();
            if (oldState == (newState = (FaDepEntryStatusEnum)((Object)row.getCell(this.ColumnIndex_State).getValue()))) continue;
            flag = true;
            break;
        }
        return flag;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        PeriodInfo[] periods;
        if (this.editData != null && this.editData.isFiVouchered()) {
            MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCalForCoal_VoucherAlready") + " " + EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCalForCoal_NoSubmit")));
            SysUtil.abort();
        }
        if (!(periods = FaPeriodCloseFacadeFactory.getRemoteInstance().getLastestPeriod(this.aCompanyOrgUnitInfo.getId().toString()))[0].getId().toString().equals(periods[1].getId().toString())) {
            throw new FaPeriodException(FaPeriodException.LASTPERIODOPERNOTALLOW);
        }
        super.actionSubmit_actionPerformed(e);
        this.refreshUI();
    }

    @Override
    protected void checkHasUnAuditedBill(FaDepreciationEntryCollection c) throws Exception, EASBizException {
        this.getManager().checkBeforeDep();
        FilterInfo filter = new FilterInfo();
        StringBuffer mask = new StringBuffer("#0 and (");
        filter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)"%99", CompareType.LIKE));
        for (int i = 1; i <= c.size(); ++i) {
            FaDepreciationEntryInfo element = c.get(i - 1);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)element.getFaCurCard().getId().toString(), CompareType.EQUALS));
            mask.append("#" + i);
            if (i == c.size()) {
                mask.append(")");
                continue;
            }
            mask.append(" or ");
        }
        filter.setMaskString(mask.toString());
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        FaCurCardCollection cCard = FaCurCardFactory.getRemoteInstance().getFaCurCardCollection(ev);
        if (cCard == null || cCard.size() < c.size()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepMnt_HasUnAuditedBill"));
            SysUtil.abort();
        }
    }

    @Override
    protected void updateEntryCollection(FaDepreciationEntryCollection c) throws Exception {
        IFaDepreciation iFaDep = FaDepreciationFactory.getRemoteInstance();
        IFaDepDistribute distribute = FaDepDistributeFactory.getRemoteInstance();
        for (int i = 0; i < this.editData.getLnkFaDepreEntry().size(); ++i) {
            FaDepreciationEntryInfo entryInfo = this.editData.getLnkFaDepreEntry().get(i);
            if (entryInfo.getDepDistribute().size() != 0) continue;
            EntityViewInfo disView = new EntityViewInfo();
            disView.getSelector().add("*");
            disView.getSelector().add(new SelectorItemInfo("costCenter.name"));
            disView.getSelector().add(new SelectorItemInfo("accountView.*"));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("depEntry", (Object)entryInfo.getId(), CompareType.EQUALS));
            disView.setFilter(filterInfo);
            FaDepDistributeCollection disCollection = distribute.getFaDepDistributeCollection(disView);
            entryInfo.getDepDistribute().addCollection(disCollection);
        }
        iFaDep.submit((CoreBaseInfo)this.editData);
    }

    @Override
    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.hasGenVoucher) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCalForCoal_NoSubmit2"));
            SysUtil.abort();
        }
        int rowCount = this.getDetailTable().getRowCount() - 1;
        for (int i = 0; i < rowCount; ++i) {
            String cardNumber;
            IRow row = this.getDetailTable().getRow(i);
            FaDepreciationEntryInfo entryInfo = (FaDepreciationEntryInfo)row.getUserObject();
            BigDecimal newDep = (BigDecimal)row.getCell(this.getColumnIndex_Depreciation()).getValue();
            String string = cardNumber = row.getCell(this.getColumnIndex_AssetNumber()).getValue() == null ? "" : row.getCell(this.getColumnIndex_AssetNumber()).getValue().toString();
            if (newDep == null || newDep.compareTo(this.ZERO) < 0) {
                MsgBox.showInfo((Component)((Object)this), (String)FaResUtil.getRes((String)"dprValueLess0"));
                SysUtil.abort();
            }
            BigDecimal backDep = (BigDecimal)row.getCell(this.getColumnIndex_BackDep()).getValue();
            BigDecimal totalDep = (BigDecimal)row.getCell(this.getColumnIndex_TotalDep()).getValue();
            BigDecimal depreTerm = (BigDecimal)row.getCell(this.getColumnIndex_DepreTerm()).getValue();
            BigDecimal beginDep = entryInfo.getEndDepre().subtract(depreTerm);
            BigDecimal newWellCost = (BigDecimal)row.getCell(this.getColumnIndex_WellCost()).getValue();
            BigDecimal beginWellCost = entryInfo.getBeginWellCost();
            BigDecimal wellCost = entryInfo.getWellCost();
            BigDecimal wellCostTerm = (BigDecimal)row.getCell(this.getColumnIndex_WellCostTerm()).getValue();
            if (wellCostTerm.add(depreTerm).compareTo(newDep) != 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCalForCoal_DepreSumErr"));
                SysUtil.abort();
            }
            if (totalDep.subtract(beginDep).compareTo(this.ZERO) < 0) {
                MsgBox.showInfo((Component)((Object)this), (String)(cardNumber + EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCalForCoal_DepLessBeginDep") + "(" + beginDep.setScale(2) + ")" + EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCalForCoal_Confirm")));
                SysUtil.abort();
            }
            BigDecimal assetValue = entryInfo.getFaCurCard().getAssetValue();
            BigDecimal decValue = entryInfo.getFaCurCard().getDecValue();
            BigDecimal delNeatRemValue = entryInfo.getFaCurCard().getNeatRemValue();
            if (assetValue.subtract(decValue).subtract(delNeatRemValue).compareTo(totalDep) < 0) {
                MsgBox.showInfo((Component)((Object)this), (String)(cardNumber + EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCalForCoal_DepError")));
                SysUtil.abort();
            }
            if (totalDep.subtract(beginDep).compareTo(this.ZERO) > 0 && (newDep.compareTo(backDep) != 0 || wellCost.add(beginWellCost).compareTo(newWellCost) != 0)) {
                if (entryInfo.getDepDistribute().size() == 0) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepMnt_NeedReDis"));
                    SysUtil.abort();
                }
                FaDepDistributeCollection disCollection = entryInfo.getDepDistribute();
                BigDecimal totalDisDep = new BigDecimal("0");
                for (int j = 0; j < disCollection.size(); ++j) {
                    totalDisDep = totalDisDep.add(disCollection.get(j).getAmount());
                }
                if (totalDep.subtract(beginDep).compareTo(totalDisDep) != 0) {
                    MsgBox.showInfo((Component)((Object)this), (String)(cardNumber + FaResUtil.getRes((String)"notEqual")));
                    SysUtil.abort();
                }
            }
            BigDecimal workLoad = this.formatBigDecmal(new BigDecimal(this.txtWork.getText().toString()));
            BigDecimal fixRatio = this.formatBigDecmal(new BigDecimal(this.txtFixRatio.getText().toString()));
            BigDecimal totalDepre = this.formatBigDecmal((BigDecimal)this.getDetailTable().getRow(this.getDetailTable().getRowCount() - 1).getCell(this.getColumnIndex_Depreciation()).getValue());
            if (workLoad.multiply(fixRatio).setScale(2, 4).compareTo(totalDepre.setScale(2, 4)) == 0) continue;
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCalForCoal_SumValueErr"));
            SysUtil.abort();
        }
    }

    protected BigDecimal formatBigDecmal(BigDecimal data) {
        if (data == null || data.compareTo(this.ZERO) == 0) {
            data = new BigDecimal("0");
        }
        return data.setScale(this.amountScale, 4);
    }

    protected BigDecimal formatBigDecmal(BigDecimal data, int scale) {
        if (data == null || data.compareTo(this.ZERO) == 0) {
            data = new BigDecimal("0");
        }
        return data.setScale(scale, 4);
    }

    @Override
    protected void initTable() {
        this.amountScale = 2;
        this.getDetailTable().checkParsed();
        this.getDetailTable().getStyleAttributes().setLocked(true);
        this.getDetailTable().getSelectManager().setSelectMode(2);
        KDFormattedTextField formattedTextField = new KDFormattedTextField(1);
        formattedTextField.setPrecision(this.amountScale);
        formattedTextField.setNegatived(false);
        KDTDefaultCellEditor numberEditor = new KDTDefaultCellEditor((JTextField)formattedTextField);
        for (int i = 5; i < 13; ++i) {
            this.getDetailTable().getColumn(i).setEditor((ICellEditor)numberEditor);
            this.getDetailTable().getColumn(i).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.getDetailTable().getColumn(i).getStyleAttributes().setNumberFormat(FaClientUtils.getDecimalFormat(this.amountScale));
        }
        this.getDetailTable().addKDTEditListener(new KDTEditListener(){

            public void editStarting(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editValueChanged(KDTEditEvent e) {
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                FaDepCalForCoalUI.this.amountChanged(e);
            }

            public void editCanceled(KDTEditEvent arg0) {
            }
        });
    }

    protected void amountChanged(KDTEditEvent e) {
        int rowIndex;
        KDTSelectBlock sb;
        if (e.getColIndex() == this.getColumnIndex_DepreTerm() || e.getColIndex() == this.getColumnIndex_WellCostTerm()) {
            sb = this.getDetailTable().getSelectManager().get();
            rowIndex = sb.getTop();
            FaDepreciationEntryInfo entryInfo = (FaDepreciationEntryInfo)this.getDetailTable().getRow(rowIndex).getUserObject();
            if (entryInfo == null) {
                return;
            }
            BigDecimal depreTerm = this.getDetailTable().getCell(rowIndex, this.getColumnIndex_DepreTerm()).getValue() != null ? (BigDecimal)this.getDetailTable().getCell(rowIndex, this.getColumnIndex_DepreTerm()).getValue() : this.ZERO;
            BigDecimal wellcostTerm = this.getDetailTable().getCell(rowIndex, this.getColumnIndex_WellCostTerm()).getValue() != null ? (BigDecimal)this.getDetailTable().getCell(rowIndex, this.getColumnIndex_WellCostTerm()).getValue() : this.ZERO;
            this.getDetailTable().getCell(rowIndex, this.getColumnIndex_TotalDep()).setValue((Object)entryInfo.getEndDepre().subtract(entryInfo.getDepreciation()).add(depreTerm));
            this.getDetailTable().getCell(rowIndex, this.getColumnIndex_WellCost()).setValue((Object)entryInfo.getBeginWellCost().add(wellcostTerm));
        }
        if (e.getColIndex() == this.getColumnIndex_Depreciation() || e.getColIndex() == this.getColumnIndex_WellCost() || e.getColIndex() == this.getColumnIndex_TotalDep() || e.getColIndex() == this.getColumnIndex_DepreTerm() || e.getColIndex() == this.getColumnIndex_WellCostTerm()) {
            BigDecimal oldValue;
            sb = this.getDetailTable().getSelectManager().get();
            rowIndex = sb.getTop();
            BigDecimal newValue = this.getDetailTable().getCell(rowIndex, e.getColIndex()).getValue() != null ? (BigDecimal)this.getDetailTable().getCell(rowIndex, e.getColIndex()).getValue() : this.ZERO;
            BigDecimal bigDecimal = oldValue = e.getOldValue() != null ? (BigDecimal)e.getOldValue() : this.ZERO;
            if (newValue.compareTo(oldValue) != 0) {
                boolean audit = this.editData.getCheckedStatus() == CheckedStatusEnum.AUDITED;
                FaDepEntryStatusEnum entryState = audit ? FaDepEntryStatusEnum.YAUDIT_YMODIFY : FaDepEntryStatusEnum.NAUDIT_YMODIFY;
                this.getDetailTable().getRow(rowIndex).getCell(this.ColumnIndex_State).setValue((Object)entryState);
                BigDecimal[] valueTotal = new BigDecimal[]{this.ZERO, this.ZERO, this.ZERO, this.ZERO, this.ZERO, this.ZERO};
                int[] columnArray = new int[]{this.getColumnIndex_TotalDep(), this.getColumnIndex_WellCost(), this.getColumnIndex_Depreciation(), this.getColumnIndex_TotalDepCost(), this.getColumnIndex_DepreTerm(), this.getColumnIndex_WellCostTerm()};
                int size = this.getDetailTable().getRowCount() - 1;
                for (int i = 0; i < size; ++i) {
                    for (int count = 0; count < columnArray.length; ++count) {
                        valueTotal[count] = valueTotal[count].add((BigDecimal)this.getDetailTable().getCell(i, columnArray[count]).getValue());
                    }
                }
                for (int count = 0; count < columnArray.length; ++count) {
                    this.getDetailTable().getRow(this.getDetailTable().getRowCount() - 1).getCell(columnArray[count]).setValue((Object)valueTotal[count]);
                }
            }
        }
    }

    @Override
    protected FaDepreciationEntryCollection fieldsStore() throws BOSException {
        FaDepreciationEntryCollection entryCollection = new FaDepreciationEntryCollection();
        int rowCount = this.getDetailTable().getRowCount() - 1;
        this.getHmNewDep().clear();
        this.workloadSchemes = FaUtils.getUserDepreciationMode(null, (boolean)true);
        for (int i = 0; i < rowCount; ++i) {
            FaDepreciationEntryInfo info = this.fieldsStoreLine(i);
            if (info == null) continue;
            entryCollection.add(info);
        }
        return entryCollection;
    }

    @Override
    protected FaDepreciationEntryInfo fieldsStoreLine(int i) throws BOSException {
        boolean flag = false;
        IRow row = this.getDetailTable().getRow(i);
        FaDepreciationEntryInfo info = (FaDepreciationEntryInfo)row.getUserObject();
        BigDecimal oldDep = (BigDecimal)row.getCell(this.getColumnIndex_BackDep()).getValue();
        BigDecimal newDep = (BigDecimal)row.getCell(this.getColumnIndex_Depreciation()).getValue();
        if (newDep == null) {
            newDep = new BigDecimal("0");
        }
        if (oldDep.compareTo(newDep) != 0 || info.getDepDistribute().size() != 0) {
            BigDecimal assetValue;
            flag = true;
            this.getHmNewDep().put(new Integer(i), newDep);
            String deprModeNumber = (String)row.getCell(this.getColumnIndex_DeprMode()).getValue();
            if (deprModeNumber != null && (deprModeNumber.equals("001") || deprModeNumber.equals("010") || deprModeNumber.equals("002") || this.workloadSchemes.containsKey(deprModeNumber)) && (assetValue = new BigDecimal(row.getCell(this.getColumnIndex_AssetValue()).getValue().toString())) != null && assetValue.intValue() > 0) {
                info.put("needReCalRate", true);
                info.getFaCurCard().setAssetValue(assetValue);
            }
            info.setDepreciation(newDep);
            BigDecimal notDep = (BigDecimal)row.getCell(this.getColumnIndex_NotDep()).getValue();
            info.setNotDepre(notDep);
        }
        BigDecimal oldTotalDep = info.getEndDepre();
        BigDecimal newTotalDep = (BigDecimal)row.getCell(this.getColumnIndex_TotalDep()).getValue();
        if (newTotalDep == null) {
            newTotalDep = new BigDecimal("0");
        }
        if (oldTotalDep.compareTo(newTotalDep) != 0) {
            flag = true;
            info.setEndDepre(newTotalDep);
        }
        BigDecimal oldWellCost = info.getWellCost().add(info.getBeginWellCost());
        BigDecimal newWellCost = (BigDecimal)row.getCell(this.getColumnIndex_WellCost()).getValue();
        if (newWellCost == null) {
            newWellCost = new BigDecimal("0");
        }
        if (oldWellCost.compareTo(newWellCost) != 0) {
            flag = true;
            BigDecimal newWellCostTemp = (BigDecimal)row.getCell(this.getColumnIndex_WellCostTerm()).getValue();
            info.setWellCost(newWellCostTemp.add(info.getBeginWellCost()));
        }
        BigDecimal endDepr = (BigDecimal)row.getCell(this.getColumnIndex_TotalDep()).getValue();
        BigDecimal wellCost = (BigDecimal)row.getCell(this.getColumnIndex_WellCost()).getValue();
        BigDecimal totalDepr = endDepr == null ? this.ZERO : endDepr.add(wellCost == null ? this.ZERO : wellCost);
        row.getCell(this.getColumnIndex_TotalDepCost()).setValue((Object)totalDepr);
        if (flag && info.getState() == FaDepEntryStatusEnum.NAUDIT_NMODIFY) {
            info.setState(FaDepEntryStatusEnum.NAUDIT_YMODIFY);
        }
        if (flag && info.getState() == FaDepEntryStatusEnum.YAUDIT_NMODIFY) {
            info.setState(FaDepEntryStatusEnum.YAUDIT_YMODIFY);
        }
        this.makeDepCompositeInfoForWrong(info);
        if (flag) {
            return info;
        }
        return null;
    }

    protected FaDepreciationEntryInfo checkLine(int i) {
        boolean flag = false;
        IRow row = this.getDetailTable().getRow(i);
        FaDepreciationEntryInfo info = (FaDepreciationEntryInfo)row.getUserObject();
        BigDecimal oldDep = (BigDecimal)row.getCell(this.getColumnIndex_BackDep()).getValue();
        BigDecimal newDep = (BigDecimal)row.getCell(this.getColumnIndex_Depreciation()).getValue();
        if (newDep == null) {
            newDep = new BigDecimal("0");
        }
        if (oldDep.compareTo(newDep) != 0 || info.getDepDistribute() != null || info.getDepDistribute().size() != 0) {
            flag = true;
            this.getHmNewDep().put(new Integer(i), newDep);
        }
        BigDecimal oldTotalDep = info.getEndDepre();
        BigDecimal newTotalDep = (BigDecimal)row.getCell(this.getColumnIndex_TotalDep()).getValue();
        if (newTotalDep == null) {
            newTotalDep = new BigDecimal("0");
        }
        if (oldTotalDep.compareTo(newTotalDep) != 0) {
            flag = true;
        }
        BigDecimal oldWellCost = info.getWellCost().add(info.getBeginWellCost());
        BigDecimal newWellCost = (BigDecimal)row.getCell(this.getColumnIndex_WellCost()).getValue();
        if (newWellCost == null) {
            newWellCost = new BigDecimal("0");
        }
        if (oldWellCost.compareTo(newWellCost) != 0) {
            flag = true;
        }
        BigDecimal endDepr = (BigDecimal)row.getCell(this.getColumnIndex_TotalDep()).getValue();
        BigDecimal wellCost = (BigDecimal)row.getCell(this.getColumnIndex_WellCost()).getValue();
        BigDecimal totalDepr = endDepr == null ? this.ZERO : endDepr.add(wellCost == null ? this.ZERO : wellCost);
        row.getCell(this.getColumnIndex_TotalDepCost()).setValue((Object)totalDepr);
        if (flag) {
            return info;
        }
        return null;
    }

    protected IFaDepCalcForCoalFacade getManager() throws Exception {
        if (this.manager == null) {
            this.manager = FaDepCalcForCoalFacadeFactory.getRemoteInstance();
        }
        return this.manager;
    }

    protected int getColumnIndex_EntryId() {
        return this.tblDetail.getColumnIndex(this.ColumnIndex_EntryId);
    }

    @Override
    protected int getColumnIndex_AssetName() {
        return this.tblDetail.getColumnIndex(this.ColumnIndex_AssetName);
    }

    protected int getColumnIndex_Ratio() {
        return this.tblDetail.getColumnIndex(this.ColumnIndex_Ratio);
    }

    protected int getColumnIndex_TotalDep() {
        return this.tblDetail.getColumnIndex(this.ColumnIndex_TotalDep);
    }

    protected int getColumnIndex_WellCost() {
        return this.tblDetail.getColumnIndex(this.ColumnIndex_WellCost);
    }

    protected int getColumnIndex_TotalDepCost() {
        return this.tblDetail.getColumnIndex(this.ColumnIndex_TotalDepCost);
    }

    @Override
    protected int getColumnIndex_State() {
        return this.tblDetail.getColumnIndex(this.ColumnIndex_State);
    }

    protected int getColumnIndex_CardID() {
        return this.tblDetail.getColumnIndex(this.ColumnIndex_CardID);
    }

    protected int getColumnIndex_DepreTerm() {
        return this.tblDetail.getColumnIndex(this.ColumnIndex_depreTerm);
    }

    protected int getColumnIndex_WellCostTerm() {
        return this.tblDetail.getColumnIndex(this.ColumnIndex_wellCostTerm);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        if (this.mainView == null) {
            return;
        }
        this.getData(this.mainView);
    }

    @Override
    protected IRow addOneRow(KDTable table, Collection c) {
        IRow row = table.addRow();
        Iterator iterator = c.iterator();
        Object[] objValue = new Object[c.size()];
        int rowIndex = 0;
        while (iterator.hasNext()) {
            objValue[rowIndex] = iterator.next();
            ++rowIndex;
        }
        row.getCell(this.getColumnIndex_EntryId()).setValue(objValue[0]);
        row.getCell(this.getColumnIndex_AssetCat()).setValue(objValue[1]);
        row.getCell(this.getColumnIndex_AssetNumber()).setValue(objValue[2]);
        row.getCell(this.getColumnIndex_AssetName()).setValue(objValue[3]);
        row.getCell(this.getColumnIndex_AssetSpec()).setValue(objValue[4]);
        row.getCell(this.getColumnIndex_Ratio()).setValue(objValue[5]);
        row.getCell(this.getColumnIndex_ShouldDep()).setValue(objValue[6]);
        row.getCell(this.getColumnIndex_Depreciation()).setValue(objValue[7]);
        row.getCell(this.getColumnIndex_DepreTerm()).setValue(objValue[8]);
        row.getCell(this.getColumnIndex_WellCostTerm()).setValue(objValue[9]);
        row.getCell(this.getColumnIndex_WellCost()).setValue(objValue[10]);
        row.getCell(this.getColumnIndex_TotalDep()).setValue(objValue[11]);
        row.getCell(this.getColumnIndex_TotalDepCost()).setValue(objValue[12]);
        row.getCell(this.getColumnIndex_State()).setValue(objValue[13]);
        row.getCell(this.getColumnIndex_NotDep()).setValue(objValue[14]);
        row.getCell(this.getColumnIndex_BackDep()).setValue(objValue[15]);
        row.getCell(this.getColumnIndex_CardID()).setValue(objValue[16]);
        row.getCell(this.getColumnIndex_DeprMode()).setValue(objValue[17]);
        row.getCell(this.getColumnIndex_AssetValue()).setValue(objValue[18]);
        return row;
    }
}

