/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.uiframe.client.HelpUtils;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.manage.FaDepCalFacadeFactory;
import com.kingdee.eas.fi.fa.manage.FaDepreciationFactory;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaPeriodCloseFacadeFactory;
import com.kingdee.eas.fi.fa.manage.IFaDepCalFacade;
import com.kingdee.eas.fi.fa.manage.IFaDepreciation;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaDepCalUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.Uuid;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.KeyStroke;

public class FaDepCalUI
extends AbstractFaDepCalUI {
    protected KDCheckBox chkUseSQL;

    public FaDepCalUI() throws Exception {
        this.setPreferredSize(new Dimension(642, 321));
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void addHelp() {
        super.addHelp();
        this.addCSHelpforBtn((JButton)this.btnHelp);
    }

    public void addCSHelpforBtn(JButton btn) {
        HelpUtils.addCSHelpforBtn((JButton)btn);
    }

    @Override
    public void actionStart_actionPerformed(ActionEvent e) throws Exception {
        super.actionStart_actionPerformed(e);
        if (this.chkNeedAudit.isSelected()) {
            ObjectUuidPK userPk = new ObjectUuidPK(BOSUuid.read((String)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
            ObjectUuidPK orgPk = new ObjectUuidPK(BOSUuid.read((String)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
            PermissionFactory.getRemoteInstance().checkFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, "fa_dep_audit");
        }
        Uuid mutexUuid = Uuid.create();
        String tmp = this.txtInfo.getText();
        boolean hasExeception = false;
        try {
            AbstractButton button = (AbstractButton)e.getSource();
            String mutexActionName = button.getText();
            MutexParameter mutexParam = FaClientUtils.setMutexParameter(mutexUuid, mutexActionName);
            if (FaClientUtils.requestMutex(mutexParam)) {
                this.depCal();
            } else {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"Fa_Mutex_Is_InProcess"));
                this.abort();
            }
        }
        catch (Exception exception) {
            hasExeception = true;
            throw exception;
        }
        finally {
            FaClientUtils.releaseMutex(mutexUuid);
            if (hasExeception && !tmp.equalsIgnoreCase(this.txtInfo.getText())) {
                this.txtInfo.setText(tmp);
            }
        }
    }

    @Override
    public void actionCheck_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.destroyWindow();
    }

    public String getUITitle() {
        return EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCal_Title");
    }

    public void onLoad() throws Exception {
        this.lblImage.setIcon(EASResource.getIcon((String)"imgGuide_pic260"));
        this.txtInfo.setEditable(false);
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        super.onLoad();
        FaClientUtils.checkComp((Component)((Object)this), aCompanyOrgUnitInfo);
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
        if (currentPeriod == null) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepMnt_NoPeriod");
            MsgBox.showInfo((Component)((Object)this), (String)strMsg);
            SysUtil.abort();
        }
        FaClientUtils.checkAccountSwap((Component)((Object)this), aCompanyOrgUnitInfo);
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.addHelp();
        String isUSeWFAudit = (String)FaClientUtils.getFAParameter(aCompanyOrgUnitInfo.getId()).get("FA_012");
        boolean depUseWF = isUSeWFAudit != null ? Boolean.valueOf(isUSeWFAudit) : false;
        this.chkNeedAudit.setVisible(!depUseWF);
        this.chkUseSQL = new KDCheckBox();
        this.chkUseSQL.setName("chkUseSQL");
        this.chkUseSQL.setText(FaResUtil.getRes((String)"whetherUse") + "SQL" + FaResUtil.getRes((String)"calculature"));
        this.chkUseSQL.setSelected(true);
        this.add((Component)this.chkUseSQL, new KDLayout.Constraints(163, 248, 140, 19, 0));
        PeriodInfo[] periods = FaPeriodCloseFacadeFactory.getRemoteInstance().getLastestPeriod(aCompanyOrgUnitInfo.getId().toString());
        if (!periods[0].getId().toString().equals(periods[1].getId().toString())) {
            this.chkAll.setSelected(true);
            this.chkAll.setEnabled(false);
        }
        this.initHiddenFunction();
        boolean isUseCalDepNew = FaManageUtils.getFaParamValue(null, "FA_201", SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        if (isUseCalDepNew) {
            this.chkNeedAudit.setSelected(true);
            this.chkNeedAudit.setEditable(false);
            this.chkNeedAudit.setEnabled(false);
        }
    }

    private void initHiddenFunction() {
        this.lblTip.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int count = e.getClickCount();
                if (count > 1) {
                    String tip = FaDepCalUI.this.lblTip.getToolTipText();
                    if (tip == null || tip.length() == 0 || tip.equals(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"7_FaDepCalUI"))) {
                        FaDepCalUI.this.lblTip.setToolTipText(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"8_FaDepCalUI"));
                    } else if (tip.equals(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"8_FaDepCalUI"))) {
                        FaDepCalUI.this.lblTip.setToolTipText(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"9_FaDepCalUI"));
                    } else if (tip.equals(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"9_FaDepCalUI"))) {
                        FaDepCalUI.this.lblTip.setToolTipText(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"7_FaDepCalUI"));
                    }
                }
            }
        });
    }

    private void depCal() throws Exception {
        int i;
        this.txtInfo.setText(FaResUtil.getRes((String)"dpring"));
        IFaDepCalFacade depCalFacade = FaDepCalFacadeFactory.getRemoteInstance();
        boolean needDep = false;
        boolean alreadyCal = depCalFacade.checkBeforeCal();
        needDep = alreadyCal ? (i = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCal_AlreadyCal"))) == 0 : true;
        if (needDep) {
            HashMap<String, Comparable<Boolean>> hmPara = new HashMap<String, Comparable<Boolean>>();
            hmPara.put("all", Boolean.valueOf(!this.chkAll.isSelected()));
            hmPara.put("useSQL", Boolean.valueOf(this.chkUseSQL.isSelected()));
            hmPara.put("isNeedAudit", Boolean.valueOf(!this.chkNeedAudit.isSelected()));
            String strTip = this.lblTip.getToolTipText();
            Integer threadCount = strTip == null || strTip.length() == 0 ? new Integer(2) : (strTip.equals(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"8_FaDepCalUI")) ? new Integer(1) : (strTip.equals(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"9_FaDepCalUI")) ? new Integer(2) : new Integer(3)));
            hmPara.put("threadCount", threadCount);
            long start = System.currentTimeMillis();
            HashMap hm = depCalFacade.calDep(hmPara, SysContext.getSysContext().getCurrentFIUnit().getId().toString());
            if (hm.get("DepCount") != null) {
                long end = System.currentTimeMillis();
                long total = (end - start) / 1000L;
                String msg = (String)hm.get("msg");
                if (msg != null && msg.length() > 0) {
                    String title = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"later_period_exists_business");
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)title.toString(), (String)msg.toString(), (int)1);
                    SysUtil.abort();
                }
                int scale = 2;
                if (SysContext.getSysContext().getCurrentFIUnit() != null && SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency() != null) {
                    scale = FaClientUtils.getCurrencyScale();
                }
                String str = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCal_Message1") + "\n";
                int depCount = (Integer)hm.get("DepCount");
                str = str + MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCal_Message2"), depCount) + "\n";
                BigDecimal depAmount = hm.get("DepAmount") != null ? (BigDecimal)hm.get("DepAmount") : new BigDecimal("0.00");
                str = str + MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCal_Message4"), FaClientUtils.formatDecimal(depAmount, scale)) + "\n";
                str = str + MessageFormat.format(FaResUtil.getRes((String)"totalTime"), total) + "\n";
                if (hm.get("returnMsg") != null) {
                    str = str + (String)hm.get("returnMsg") + "\n";
                    this.txtInfo.setText(str);
                } else {
                    str = str + EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"241_FaDepCalUI");
                    this.txtInfo.setText(str);
                    String companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
                    HashMap<String, String> sendMap = new HashMap<String, String>();
                    sendMap.put("companyId", companyId);
                    IFaDepreciation faDepreciation = FaDepreciationFactory.getRemoteInstance();
                    HashMap returnMap = faDepreciation.sumAfterCalDep(sendMap);
                    if (returnMap.get("msg") != null) {
                        str = str + returnMap.get("msg") + "\n";
                        long end2 = System.currentTimeMillis();
                        long total2 = (end2 - end) / 1000L;
                        str = str + MessageFormat.format(FaResUtil.getRes((String)"totalTime"), total2) + "\n";
                        this.txtInfo.setText(str);
                    } else {
                        str = str + EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"242_FaDepCalUI");
                        this.txtInfo.setText(str);
                    }
                }
            } else {
                this.txtInfo.setText(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"243_FaDepCalUI"));
            }
        } else {
            this.txtInfo.setText("");
        }
    }

    private void checkDepCalAuditPermission() throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        if (companyOrgUnitInfo != null) {
            ObjectUuidPK companyPK = new ObjectUuidPK(companyOrgUnitInfo.getId());
            if (this.getUserPk() != null && companyPK != null) {
                PermissionFactory.getRemoteInstance().checkFunctionPermission(this.getUserPk(), (IObjectPK)companyPK, "fa_dep_audit");
            }
        }
    }
}

