/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.manage.FaDepCalcForCoalFacadeFactory;
import com.kingdee.eas.fi.fa.manage.FaDepreciationEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaDepreciationFactory;
import com.kingdee.eas.fi.fa.manage.FaDepreciationInfo;
import com.kingdee.eas.fi.fa.manage.IFaDepCalcForCoalFacade;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaDepInitForCoal;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.EventListenerList;

public class FaDepInitForCoal
extends AbstractFaDepInitForCoal {
    static BigDecimal zeroValue = new BigDecimal("0");
    private static final String CAT = "cat";
    private static final String ACCUDEPR = "accuDepr";
    private static final String WELLCOST = "wellCost";
    private static final String TOTALDEPR = "totalDepr";

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected KDTable getDetailTable() {
        return this.detailTable;
    }

    public IObjectPK runSubmit() throws Exception {
        return super.runSubmit();
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.getDetailTable().getPrintManager().print();
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.getDetailTable().getPrintManager().printPreview();
    }

    public void onLoad() throws Exception {
        this.getDetailTable().checkParsed();
        this.getDetailTable().getColumn(WELLCOST).getStyleAttributes().setHided(true);
        this.btnDoInit.setIcon(EASResource.getIcon((String)"imgTbtn_initialize"));
        this.btnUndoInit.setIcon(EASResource.getIcon((String)"imgTbtn_finitialize"));
        this.menuItemDoInit.setIcon(EASResource.getIcon((String)"imgTbtn_initialize"));
        this.menuItemUndoInit.setIcon(EASResource.getIcon((String)"imgTbtn_finitialize"));
        this.checkBeforeOnload();
        IFaDepCalcForCoalFacade depForCoalFacade = FaDepCalcForCoalFacadeFactory.getRemoteInstance();
        String curCompanyID = this.getCurCompany().getId().toString();
        boolean isInit = depForCoalFacade.isAlreadyInit(curCompanyID);
        FaDepreciationInfo depInfo = depForCoalFacade.getInitDepInfo(curCompanyID, isInit);
        this.getUIContext().put("InitDataObject", depInfo);
        this.setOprtState("ADDNEW");
        super.onLoad();
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.hideOrShowAuditResult(false);
        this.initTitle();
        this.displayDepInfo(depInfo, isInit);
        if (depInfo.getCheckedStatus() != CheckedStatusEnum.AUDITED && depInfo.getLnkFaDepreEntry() != null && depInfo.getLnkFaDepreEntry().size() > 0) {
            this.getDetailTable().getEditManager().editCellAt(0, 6);
        }
        this.getUIContext().put("ON_SHOWED", Boolean.TRUE);
        boolean isEnableUndo = FaClientUtils.isEnableUndo(null);
        if (!isEnableUndo) {
            this.actionUndoInit.setVisible(isEnableUndo);
            this.actionUndoInit.setEnabled(isEnableUndo);
        }
        FaClientUtils.disableFrameworkFunc((Component)((Object)this));
    }

    protected void refreshUI() throws Exception {
        IFaDepCalcForCoalFacade depForCoalFacade = FaDepCalcForCoalFacadeFactory.getRemoteInstance();
        String curCompanyID = this.getCurCompany().getId().toString();
        boolean isInit = depForCoalFacade.isAlreadyInit(curCompanyID);
        FaDepreciationInfo depInfo = depForCoalFacade.getInitDepInfo(curCompanyID, isInit);
        this.displayDepInfo(depInfo, isInit);
    }

    protected void initListener() {
        super.initListener();
        if (this.getDetailTable() != null) {
            EventListener[] mouseListener;
            EventListenerList listeners = this.getDetailTable().getListenerList();
            ArrayList<EventListener> backListeners = new ArrayList<EventListener>();
            if (listeners != null && (mouseListener = listeners.getListeners(KDTMouseListener.class)) != null) {
                for (int i = 0; i < mouseListener.length; ++i) {
                    backListeners.add(mouseListener[i]);
                    this.getDetailTable().getListenerList().remove(KDTMouseListener.class, (KDTMouseListener)mouseListener[i]);
                }
            }
            this.getDetailTable().addKDTMouseListener(new KDTMouseListener(){

                public void tableClicked(KDTMouseEvent e) {
                    try {
                        int type = e.getType();
                        if (type == 0) {
                            int rowCount = FaDepInitForCoal.this.getDetailTable().getRowCount();
                            IRow sumRow = null;
                            for (int i = 0; i < rowCount; ++i) {
                                IRow row = FaDepInitForCoal.this.getDetailTable().getRow(i);
                                if (row == null) continue;
                                ICell cell = row.getCell(FaDepInitForCoal.CAT);
                                String value = cell.getValue().toString();
                                if (!EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCalForCoal_Sum").equals(value)) continue;
                                sumRow = row;
                                FaDepInitForCoal.this.getDetailTable().removeRow(i);
                            }
                            IRow newRow = FaDepInitForCoal.this.getDetailTable().addRow();
                            newRow.getCell(FaDepInitForCoal.CAT).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCalForCoal_Sum"));
                            newRow.getCell(FaDepInitForCoal.ACCUDEPR).setValue(sumRow.getCell(FaDepInitForCoal.ACCUDEPR).getValue());
                            newRow.getCell(FaDepInitForCoal.WELLCOST).setValue(sumRow.getCell(FaDepInitForCoal.WELLCOST).getValue());
                            newRow.getCell(FaDepInitForCoal.TOTALDEPR).setValue(sumRow.getCell(FaDepInitForCoal.TOTALDEPR).getValue());
                            newRow.getStyleAttributes().setLocked(true);
                            newRow.getStyleAttributes().setBackground(FaDepInitForCoal.this.getDetailTable().getRequiredColor());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            for (int i = 0; i < backListeners.size(); ++i) {
                this.getDetailTable().addKDTMouseListener((KDTMouseListener)backListeners.get(i));
            }
        }
    }

    protected void initComponent(boolean isInit) {
        this.getDetailTable().getSelectManager().setSelectMode(2);
        IColumn col_WellCost = this.getDetailTable().getColumn(WELLCOST);
        IColumn col_AccuDepr = this.getDetailTable().getColumn(ACCUDEPR);
        KDFormattedTextField fTxtFieldFacAmount = new KDFormattedTextField(1);
        fTxtFieldFacAmount.setNegatived(false);
        fTxtFieldFacAmount.setPrecision(2);
        fTxtFieldFacAmount.setMaximumValue((Comparable)FaClientUtils.MAX_DECIMAL);
        fTxtFieldFacAmount.setMinimumValue((Comparable)new BigDecimal("0"));
        fTxtFieldFacAmount.setHorizontalAlignment(4);
        col_WellCost.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)fTxtFieldFacAmount));
        col_AccuDepr.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)fTxtFieldFacAmount));
        String[] formatColumns = new String[]{ACCUDEPR, WELLCOST, TOTALDEPR};
        FaClientUtils.changeTableNumberFormat(this.getDetailTable(), formatColumns);
        if (!isInit) {
            this.getDetailTable().addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    BigDecimal accuDeprTotal = zeroValue;
                    BigDecimal wellCostTotal = zeroValue;
                    BigDecimal totalDeprTotal = zeroValue;
                    int size = FaDepInitForCoal.this.getDetailTable().getRowCount() - 1;
                    for (int i = 0; i < size; ++i) {
                        FaDepInitForCoal.this.getDetailTable().getRow(i).getCell(FaDepInitForCoal.TOTALDEPR).setValue((Object)((BigDecimal)FaDepInitForCoal.this.getDetailTable().getRow(i).getCell(FaDepInitForCoal.ACCUDEPR).getValue()).add((BigDecimal)FaDepInitForCoal.this.getDetailTable().getRow(i).getCell(FaDepInitForCoal.WELLCOST).getValue()));
                        accuDeprTotal = accuDeprTotal.add((BigDecimal)FaDepInitForCoal.this.getDetailTable().getRow(i).getCell(FaDepInitForCoal.ACCUDEPR).getValue());
                        wellCostTotal = wellCostTotal.add((BigDecimal)FaDepInitForCoal.this.getDetailTable().getRow(i).getCell(FaDepInitForCoal.WELLCOST).getValue());
                        totalDeprTotal = totalDeprTotal.add((BigDecimal)FaDepInitForCoal.this.getDetailTable().getRow(i).getCell(FaDepInitForCoal.TOTALDEPR).getValue());
                    }
                    FaDepInitForCoal.this.getDetailTable().getRow(FaDepInitForCoal.this.getDetailTable().getRowCount() - 1).getCell(FaDepInitForCoal.ACCUDEPR).setValue((Object)accuDeprTotal);
                    FaDepInitForCoal.this.getDetailTable().getRow(FaDepInitForCoal.this.getDetailTable().getRowCount() - 1).getCell(FaDepInitForCoal.WELLCOST).setValue((Object)wellCostTotal);
                    FaDepInitForCoal.this.getDetailTable().getRow(FaDepInitForCoal.this.getDetailTable().getRowCount() - 1).getCell(FaDepInitForCoal.TOTALDEPR).setValue((Object)totalDeprTotal);
                }
            });
        }
    }

    @Override
    public void actionDoInit_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkFaInit((Component)this.getUIContext().get("Owner"), this.getCurCompany());
        if (this.getDetailTable().getRowCount() > 0) {
            if (this.verifyBeforeSubmit(e)) {
                FaDepCalcForCoalFacadeFactory.getRemoteInstance().hasNewBiz(this.getCurCompany().getId().toString());
                FaDepreciationFactory.getRemoteInstance().submit((CoreBaseInfo)this.editData);
            }
            FaDepCalcForCoalFacadeFactory.getRemoteInstance().doInit();
            this.showAuditMessage(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepInitForCoal_InitSuccess"));
        }
        this.refreshUI();
    }

    private void showAuditMessage(String str) {
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepInitForCoal_CardCoal") + " " + str);
        this.showMessage();
    }

    protected void showSubmitSuccess() {
        this.setMessageText(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK_New"), EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepInitForCoal_Title")));
        this.showMessage();
    }

    @Override
    public void actionUndoInit_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkFaInit((Component)this.getUIContext().get("Owner"), this.getCurCompany());
        FaDepCalcForCoalFacadeFactory.getRemoteInstance().undoInit();
        this.showAuditMessage(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepInitForCoal_UnInitSuccess"));
        this.refreshUI();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkFaInit((Component)this.getUIContext().get("Owner"), this.getCurCompany());
        IFaDepCalcForCoalFacade depForCoalFacade = FaDepCalcForCoalFacadeFactory.getRemoteInstance();
        String curCompanyID = this.getCurCompany().getId().toString();
        depForCoalFacade.hasNewBiz(curCompanyID);
        super.actionSubmit_actionPerformed(e);
        this.refreshUI();
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
    }

    protected IObjectValue createNewData() {
        return super.createNewData();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FaDepreciationFactory.getRemoteInstance();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        if (e != null && this.getActionFromActionEvent(e).equals(this.actionSubmit)) {
            this.verifyBeforeSubmit(e);
        }
    }

    protected boolean verifyBeforeSubmit(ActionEvent e) throws Exception {
        boolean result = false;
        if (this.editData == null) {
            return false;
        }
        int size = this.editData.getLnkFaDepreEntry().size();
        for (int i = 0; i < size; ++i) {
            FaDepreciationEntryInfo detail = this.editData.getLnkFaDepreEntry().get(i);
            BigDecimal cellValue = (BigDecimal)this.getDetailTable().getRow(i).getCell(WELLCOST).getValue();
            if (cellValue != null && cellValue.compareTo(detail.getWellCost()) != 0) {
                result = true;
            }
            if (cellValue != null && cellValue.compareTo(zeroValue) < 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepInitForCoal_WellCostError"));
                SysUtil.abort();
            }
            detail.setWellCost(cellValue);
        }
        return result;
    }

    protected void initBtnStatus(boolean isInit) {
        this.actionSubmit.setEnabled(!isInit);
        this.actionDoInit.setEnabled(!isInit);
        this.actionUndoInit.setEnabled(isInit);
    }

    protected void initTitle() throws Exception {
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepInitForCoal_Title"));
    }

    protected void checkBeforeOnload() throws Exception {
        FaClientUtils.checkComp((Component)((Object)this), this.getCurCompany());
        FaClientUtils.checkFaInit((Component)this.getUIContext().get("Owner"), this.getCurCompany());
        FaClientUtils.checkAccountSwap((Component)((Object)this), this.getCurCompany());
    }

    protected CompanyOrgUnitInfo getCurCompany() {
        return SysContext.getSysContext().getCurrentFIUnit();
    }

    protected void displayDepInfo(FaDepreciationInfo depInfo, Boolean isInit) throws Exception {
        this.getDetailTable().removeRows();
        BigDecimal accuDeprTotal = zeroValue;
        BigDecimal wellCostTotal = zeroValue;
        BigDecimal totalDeprTotal = zeroValue;
        boolean audit = depInfo.getCheckedStatus() == CheckedStatusEnum.AUDITED;
        int size = depInfo.getLnkFaDepreEntry().size();
        for (int i = 0; i < size; ++i) {
            FaDepreciationEntryInfo entryInfo = depInfo.getLnkFaDepreEntry().get(i);
            IRow newRow = this.getDetailTable().addRow();
            newRow.setUserObject((Object)entryInfo);
            newRow.getCell("id").setValue((Object)(entryInfo.getId() == null ? "" : entryInfo.getId().toString()));
            newRow.getCell(CAT).setValue((Object)entryInfo.getFaCurCard().getAssetCat().getName());
            newRow.getCell(CAT).getStyleAttributes().setLocked(true);
            newRow.getCell("number").setValue((Object)entryInfo.getFaCurCard().getNumber());
            newRow.getCell("number").getStyleAttributes().setLocked(true);
            newRow.getCell("name").setValue((Object)entryInfo.getFaCurCard().getAssetName());
            newRow.getCell("name").getStyleAttributes().setLocked(true);
            newRow.getCell("spec").setValue((Object)entryInfo.getFaCurCard().getSpecs());
            newRow.getCell("spec").getStyleAttributes().setLocked(true);
            newRow.getCell(ACCUDEPR).setValue((Object)entryInfo.getFaCurCard().getAccuDepr());
            newRow.getCell(ACCUDEPR).getStyleAttributes().setLocked(true);
            newRow.getCell(WELLCOST).setValue((Object)entryInfo.getWellCost());
            newRow.getCell(TOTALDEPR).setValue((Object)entryInfo.getWellCost().add(entryInfo.getFaCurCard().getAccuDepr()));
            newRow.getCell(TOTALDEPR).getStyleAttributes().setLocked(true);
            accuDeprTotal = accuDeprTotal.add(entryInfo.getFaCurCard().getAccuDepr());
            wellCostTotal = wellCostTotal.add(entryInfo.getWellCost());
            totalDeprTotal = totalDeprTotal.add(entryInfo.getFaCurCard().getAccuDepr().add(entryInfo.getWellCost()));
            newRow.getCell(WELLCOST).getStyleAttributes().setLocked(audit);
        }
        IRow newRow = this.getDetailTable().addRow();
        newRow.getCell(CAT).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCalForCoal_Sum"));
        newRow.getCell(ACCUDEPR).setValue((Object)accuDeprTotal);
        newRow.getCell(WELLCOST).setValue((Object)wellCostTotal);
        newRow.getCell(TOTALDEPR).setValue((Object)totalDeprTotal);
        newRow.getStyleAttributes().setLocked(true);
        newRow.getStyleAttributes().setBackground(this.getDetailTable().getRequiredColor());
        if (this.editData != null) {
            this.editData.setCheckedStatus(depInfo.getCheckedStatus());
        } else {
            if (isInit.booleanValue() && CheckedStatusEnum.UNAUDITED == depInfo.getCheckedStatus()) {
                this.actionDoInit.setEnabled(true);
                this.actionUndoInit.setEnabled(false);
            }
            if (isInit.booleanValue() && CheckedStatusEnum.AUDITED == depInfo.getCheckedStatus()) {
                this.actionDoInit.setEnabled(false);
                this.actionUndoInit.setEnabled(true);
            }
        }
        this.displayPeriod(depInfo.getPeriod());
        this.setDataObject((IObjectValue)depInfo);
        if (!isInit.booleanValue()) {
            this.actionDoInit.setEnabled(false);
        }
    }

    protected void displayPeriod(PeriodInfo period) {
        if (period == null) {
            return;
        }
        String s = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepMnt_DepPeriod");
        s = s + MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"displayPeriod"), period.getPeriodYear(), period.getPeriodNumber());
        this.periodLabel.setText(s);
    }

    protected void lockUIForViewStatus() {
    }

    protected boolean isShowAttachmentAction() {
        return false;
    }

    protected void unLockUIAndAction() {
        super.unLockUIAndAction();
        if (this.getEditData() != null) {
            FaDepreciationInfo depInfo = (FaDepreciationInfo)this.getEditData();
            this.initBtnStatus(depInfo.getCheckedStatus() == CheckedStatusEnum.AUDITED);
        }
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if (this.editData != null) {
            this.initBtnStatus(this.editData.getCheckedStatus() == CheckedStatusEnum.AUDITED);
            this.initComponent(this.editData.getCheckedStatus() == CheckedStatusEnum.AUDITED);
        }
    }
}

