/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.uiframe.client.HelpUtils;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.fa.manage.FaDepreAndAmortFactory;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaDepreAndAmortCalcUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.manage.client.NLMRecalculateAccountBalanceUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.KeyStroke;

public class FaDepreAndAmortCalcUI
extends AbstractFaDepreAndAmortCalcUI {
    private static final String RES_PATH = "com.kingdee.eas.fi.fa.manage.FaDepreAndAmortResources";

    public FaDepreAndAmortCalcUI() throws Exception {
        this.setPreferredSize(new Dimension(642, 321));
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void addHelp() {
        super.addHelp();
        this.addCSHelpforBtn((JButton)this.btnHelp);
    }

    public void addCSHelpforBtn(JButton btn) {
        HelpUtils.addCSHelpforBtn((JButton)btn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionStart_actionPerformed(ActionEvent e) throws Exception {
        super.actionStart_actionPerformed(e);
        Uuid mutexUuid = Uuid.create();
        String tmp = this.txtInfo.getText();
        boolean hasExeception = false;
        try {
            AbstractButton button = (AbstractButton)e.getSource();
            String mutexActionName = button.getText();
            MutexParameter mutexParam = FaClientUtils.setMutexParameter(mutexUuid, mutexActionName);
            if (FaClientUtils.requestMutex(mutexParam)) {
                FaDepreAndAmortFactory.getRemoteInstance().calcMonthDepreAndAmort();
                this.txtInfo.setText(EASResource.getString((String)RES_PATH, (String)"Calc_DepreAndAmort_Finish"));
            } else {
                MsgBox.showError((String)EASResource.getString((String)RES_PATH, (String)"DepreAndAmortCalc_Mutex_Is_InProcess"));
                this.abort();
            }
        }
        catch (Exception exception) {
            hasExeception = true;
            exception.getMessage();
            if (this.checkToRecalculateAccountBalance()) {
                SysUtil.abort();
            }
        }
        finally {
            FaClientUtils.releaseMutex(mutexUuid);
            if (hasExeception && !tmp.equalsIgnoreCase(this.txtInfo.getText())) {
                this.txtInfo.setText(tmp);
            }
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.destroyWindow();
    }

    public void onLoad() throws Exception {
        this.lblImage.setIcon(EASResource.getIcon((String)"imgGuide_pic260"));
        this.txtInfo.setEditable(false);
        this.txtInfo.setText(EASResource.getString((String)RES_PATH, (String)"DepreAndAmortCalcUI_Description"));
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        super.onLoad();
        FaClientUtils.checkBeforeOnload4Fl(this.getUIContext(), company);
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.addHelp();
    }

    private boolean checkToRecalculateAccountBalance() throws BOSException, EASBizException, SQLException {
        CompanyOrgUnitInfo curCompany = SysContext.getSysContext().getCurrentFIUnit();
        PeriodInfo initPeriod = FaClientUtils.getFLStartPeriod(curCompany);
        PeriodInfo curPeriod = FaClientUtils.getFLCurrentPeriod(curCompany);
        PeriodInfo latestPeriod = null;
        IRowSet latestPeriodResult = SQLExecutorFactory.getRemoteInstance((String)("SELECT leaseBill.FNUMBER leaseBillNumber, period.fnumber periodNumber, period.fid periodFid FROM T_FA_FaLeaseInBillNew leaseBill left join T_BD_PERIOD period on FPERIODID = period.FID where FCompanyID = '" + curCompany.getId().toString() + "' and FCheckedStatus = 2 order by period.FNUMBER desc \n")).executeSQL();
        if (latestPeriodResult.next()) {
            latestPeriod = PeriodFactory.getRemoteInstance().getPeriodInfo((IObjectPK)new ObjectUuidPK(latestPeriodResult.getString("periodFid")));
        }
        if (latestPeriod == null || latestPeriod.getNumber() < curPeriod.getNumber()) {
            latestPeriod = curPeriod;
        }
        UIContext uiContext = new UIContext();
        uiContext.put((Object)"curCompany", (Object)curCompany);
        uiContext.put((Object)"initPeriod", (Object)initPeriod);
        uiContext.put((Object)"curPeriod", (Object)curPeriod);
        uiContext.put((Object)"latestPeriod", (Object)latestPeriod);
        uiContext.put((Object)"isRepairTool", (Object)false);
        IUIWindow modelWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(NLMRecalculateAccountBalanceUI.class.getName(), (Map)uiContext, null, null);
        modelWindow.show();
        return true;
    }
}

