/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.core.client.f7.F7ContextInitializationHelper;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaDepreciationBatchFilterUI;
import org.apache.log4j.Logger;

public class FaDepreciationBatchFilterUI
extends AbstractFaDepreciationBatchFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(FaDepreciationBatchFilterUI.class);
    private static final String YEAR = "year";
    private static final String MONTH = "month";
    private static final String COMPANY = "company";
    protected static final String NUMBER = "number";
    protected static final String NAME = "name";
    protected static final String ID = "id";
    protected static final String INDEX = "index";

    public void onLoad() throws Exception {
        super.onLoad();
        this.initCompanyF7();
    }

    public void clear() {
        super.clear();
        try {
            this.setDefaultData();
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    private void setDefaultData() {
        this.prmtCompany.setData(null);
        this.rbnAllDepreciated.setSelected(true);
        this.rbnAllAudit.setSelected(true);
        this.rbnAllVoucher.setSelected(true);
    }

    private void initCompanyF7() {
        this.prmtCompany.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
        NewCompanyF7 selector = F7ContextInitializationHelper.getSelectCompany((IUIObject)this, null, null, (boolean)true);
        selector.setPermissionItem("fa_dep_cal");
        this.prmtCompany.setSelector((KDPromptSelector)selector);
        this.prmtCompany.setDisplayFormat("$name$");
        this.prmtCompany.setEditFormat("$number$");
        this.prmtCompany.setCommitFormat("$number$");
        this.prmtCompany.setEnabledMultiSelection(true);
        this.prmtCompany.setEditable(true);
        this.prmtCompany.setRequired(false);
    }

    public boolean verify() {
        CustomerParams params = new CustomerParams();
        Object[] companyOrgUnitInfo = (Object[])this.prmtCompany.getData();
        CustomerParams companys = this.transCompanyTree(companyOrgUnitInfo);
        if (companys != null) {
            params.putMe(COMPANY, companys);
        }
        if (this.rbnDepreciated.isSelected()) {
            params.putBoolean("rbnDepreciated", this.rbnDepreciated.isSelected());
        } else if (this.rbnUnDepreciated.isSelected()) {
            params.putBoolean("rbnUnDepreciated", this.rbnUnDepreciated.isSelected());
        }
        if (this.rbnAudited.isSelected()) {
            params.putBoolean("rbnAudited", this.rbnAudited.isSelected());
        } else if (this.rbnUnAudited.isSelected()) {
            params.putBoolean("rbnUnAudited", this.rbnUnAudited.isSelected());
        }
        if (this.rbnVoucherSaved.isSelected()) {
            params.putBoolean("rbnVoucherSaved", this.rbnVoucherSaved.isSelected());
        } else if (this.rbnUnVoucherSaved.isSelected()) {
            params.putBoolean("rbnUnVoucherSaved", this.rbnUnVoucherSaved.isSelected());
        }
        this.setCustomerParams(params);
        return true;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams params = super.getCustomerParams();
        if (params == null || params.toHashMap().isEmpty()) {
            params = new CustomerParams();
            Object[] companyOrgUnitInfo = (Object[])this.prmtCompany.getData();
            CustomerParams companys = this.transCompanyTree(companyOrgUnitInfo);
            if (companys != null) {
                params.putMe(COMPANY, companys);
            }
            if (this.rbnDepreciated.isSelected()) {
                params.putBoolean("rbnDepreciated", this.rbnDepreciated.isSelected());
            } else if (this.rbnUnDepreciated.isSelected()) {
                params.putBoolean("rbnUnDepreciated", this.rbnUnDepreciated.isSelected());
            }
            if (this.rbnAudited.isSelected()) {
                params.putBoolean("rbnAudited", this.rbnAudited.isSelected());
            } else if (this.rbnUnAudited.isSelected()) {
                params.putBoolean("rbnUnAudited", this.rbnUnAudited.isSelected());
            }
            if (this.rbnVoucherSaved.isSelected()) {
                params.putBoolean("rbnVoucherSaved", this.rbnVoucherSaved.isSelected());
            } else if (this.rbnUnVoucherSaved.isSelected()) {
                params.putBoolean("rbnUnVoucherSaved", this.rbnUnVoucherSaved.isSelected());
            }
        }
        return params;
    }

    protected CustomerParams transCompanyTree(Object[] companyOrgUnitInfo) {
        if (companyOrgUnitInfo == null) {
            return null;
        }
        CustomerParams params = new CustomerParams();
        params.putInt(INDEX, companyOrgUnitInfo.length);
        for (int i = 0; i < companyOrgUnitInfo.length; ++i) {
            CustomerParams params1 = new CustomerParams();
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)companyOrgUnitInfo[i];
            params1.addCustomerParam(ID, company.getId().toString());
            params1.addCustomerParam(NAME, company.getName());
            params1.addCustomerParam(NUMBER, company.getNumber());
            params.putMe(String.valueOf(i), params1);
        }
        return params;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        CustomerParams cond = this.getCustomerParams();
        if (cond != null) {
            this.prmtCompany.setData(this.resumeCompany(cond.getMe(COMPANY)));
            if (cond.getBoolean("rbnDepreciated")) {
                this.rbnDepreciated.setSelected(true);
            } else if (cond.getBoolean("rbnUnDepreciated")) {
                this.rbnUnDepreciated.setSelected(true);
            } else {
                this.rbnAllDepreciated.setSelected(true);
            }
            if (cond.getBoolean("rbnAudited")) {
                this.rbnAudited.setSelected(true);
            } else if (cond.getBoolean("rbnUnAudited")) {
                this.rbnUnAudited.setSelected(true);
            } else {
                this.rbnAllAudit.setSelected(true);
            }
            if (cond.getBoolean("rbnVoucherSaved")) {
                this.rbnVoucherSaved.setSelected(true);
            } else if (cond.getBoolean("rbnUnVoucherSaved")) {
                this.rbnUnVoucherSaved.setSelected(true);
            } else {
                this.rbnAllVoucher.setSelected(true);
            }
        }
    }

    private Object resumeCompany(CustomerParams me) {
        int index = me.getInt(INDEX);
        Object[] companyOrgUnitInfoArr = new Object[index];
        for (int i = 0; i < index; ++i) {
            CustomerParams cp = me.getMe(String.valueOf(i));
            CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
            companyOrgUnitInfo.setId(BOSUuid.read((String)cp.getCustomerParam(ID).toString()));
            companyOrgUnitInfo.setName(cp.getCustomerParam(NAME));
            companyOrgUnitInfo.setNumber(cp.getCustomerParam(NUMBER));
            companyOrgUnitInfoArr[i] = companyOrgUnitInfo;
        }
        return companyOrgUnitInfoArr;
    }

    public FilterInfo getFilterInfo() {
        return this.filterInfo;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }
}

