/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.fa.manage.FaDepreciationFactory;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaDepreciationFilter;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FaDepreciationFilter
extends AbstractFaDepreciationFilter {
    private PeriodInfo currPeriod;
    private boolean isShowEvalDepr = false;
    private HashMap zipData;

    public FaDepreciationFilter(CompanyOrgUnitInfo com) throws Exception {
        ArrayList<CompanyOrgUnitInfo> list = new ArrayList<CompanyOrgUnitInfo>();
        list.add(com);
        this.zipData = FaDepreciationFactory.getRemoteInstance().getZipDataForRPC(list);
        PeriodInfo startPeriod = (PeriodInfo)this.zipData.get("startPeriod");
        this.currPeriod = (PeriodInfo)this.zipData.get("currPeriod");
        this.initPeriodYear(startPeriod, this.currPeriod);
        this.fillPeriodComponent(this.currPeriod);
        HashMap hmParam = (HashMap)this.zipData.get("hmParam");
        this.isShowEvalDepr = hmParam.get("FA_021") == null ? false : Boolean.valueOf(hmParam.get("FA_021").toString());
        this.cbShowEvalDepr.setVisible(this.isShowEvalDepr);
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    private void initPeriodYear(final PeriodInfo startPeriod, final PeriodInfo curPeriod) {
        SpinnerNumberModel yearModel = (SpinnerNumberModel)this.spPeriodYear.getModel();
        yearModel.setMinimum(new Integer(startPeriod.getPeriodYear()));
        yearModel.setMaximum(new Integer(curPeriod.getPeriodYear()));
        this.spPeriodYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaDepreciationFilter.this.fireYearChange(startPeriod, curPeriod);
            }
        });
    }

    private void fireYearChange(PeriodInfo startPeriodInfo, PeriodInfo curPeriodInfo) {
        if (startPeriodInfo == null || curPeriodInfo == null) {
            return;
        }
        Integer year = (Integer)this.spPeriodYear.getValue();
        SpinnerNumberModel numberModel = (SpinnerNumberModel)this.spPeriodNumber.getModel();
        try {
            Integer maxPeriod = (Integer)this.zipData.get("maxNumber" + year);
            Integer minPeriod = (Integer)this.zipData.get("minNumber" + year);
            if (maxPeriod == null || minPeriod == null) {
                numberModel.setMaximum(new Integer(this.currPeriod.getPeriodNumber()));
                numberModel.setMinimum(new Integer(this.currPeriod.getPeriodNumber()));
                this.fillPeriodComponent(this.currPeriod);
                return;
            }
            numberModel.setMaximum(maxPeriod);
            numberModel.setMinimum(minPeriod);
            if (startPeriodInfo.getPeriodYear() == year.intValue()) {
                numberModel.setMinimum(new Integer(startPeriodInfo.getPeriodNumber()));
            }
            if (startPeriodInfo.getPeriodYear() > year) {
                this.spPeriodYear.setValue((Object)new Integer(startPeriodInfo.getPeriodYear()));
            }
            if (year.intValue() == curPeriodInfo.getPeriodYear()) {
                numberModel.setMaximum(new Integer(curPeriodInfo.getPeriodNumber()));
            }
            this.spPeriodNumber.setValue(numberModel.getMinimum());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void fillPeriodComponent(PeriodInfo periodInfo) {
        if (periodInfo != null) {
            this.spPeriodYear.setValue((Object)new Integer(periodInfo.getPeriodYear()));
            this.spPeriodNumber.setValue((Object)new Integer(periodInfo.getPeriodNumber()));
        }
    }

    public Integer getPeriodYear() {
        return this.spPeriodYear.getIntegerVlaue();
    }

    public Integer getPeriodNumber() {
        return this.spPeriodNumber.getIntegerVlaue();
    }

    public FilterInfo getFilterInfo() {
        StringBuffer sbFormula = new StringBuffer();
        FilterItemCollection filterItems = this.filterInfo.getFilterItems();
        filterItems.clear();
        int i = 0;
        FilterItemInfo filterItemInfo = new FilterItemInfo("period.periodYear", this.spPeriodYear.getValue());
        filterItems.add(filterItemInfo);
        if (i == 0) {
            sbFormula.append("#" + i++);
        } else {
            sbFormula.append(" and #" + i++);
        }
        filterItemInfo = new FilterItemInfo("period.periodNumber", this.spPeriodNumber.getValue());
        filterItems.add(filterItemInfo);
        if (i == 0) {
            sbFormula.append("#" + i++);
        } else {
            sbFormula.append(" and #" + i++);
        }
        if (sbFormula.toString().length() != 0) {
            this.filterInfo.setMaskString(sbFormula.toString());
        }
        return this.filterInfo;
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp != null) {
            this.cbShowEvalDepr.setSelected(this.isShowEvalDepr ? cp.getBoolean("showEvalDepr") : false);
        } else {
            this.cbShowEvalDepr.setSelected(false);
        }
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        cp.putBoolean("showEvalDepr", this.isShowEvalDepr ? this.cbShowEvalDepr.isSelected() : false);
        return cp;
    }

    public void clear() {
        super.clear();
        this.fillPeriodComponent(this.currPeriod);
        this.cbShowEvalDepr.setSelected(false);
    }
}

