/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.manage.FaDepreciationCollection;
import com.kingdee.eas.fi.fa.manage.FaDepreciationFactory;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaDepreciationListUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.manage.client.FaDepreciationUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;

public class FaDepreciationListUI
extends AbstractFaDepreciationListUI {
    private CompanyOrgUnitInfo currentCompany;

    @Override
    public void loadFields() {
        super.loadFields();
        this.tblMain.checkParsed();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return FaDepreciationUI.class.getName();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.getCurrentCompany().getId().toString()));
        filter.setMaskString("#0");
        return filter;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.menuItemImportData.setAccelerator(KeyStroke.getKeyStroke("ctrl I"));
        this.menuItemExportData.setAccelerator(KeyStroke.getKeyStroke("ctrl shift E"));
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
    }

    protected boolean isIgnoreCUFilter() {
        return this.getUIContext().get("Link") != null && this.getUIContext().get("Link").equals(Boolean.TRUE);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FaDepreciationFactory.getRemoteInstance();
    }

    public void onGetRowSet(IRowSet rowSet) {
        super.onGetRowSet(rowSet);
        int baseScale = 2;
        try {
            baseScale = FaClientUtils.getCurrencyScale();
        }
        catch (Exception e) {
            this.handleException(e);
            SysUtil.abort();
        }
        this.tblMain.getColumn("lnkFaDepreEntry.depreciation").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("lnkFaDepreEntry.shouldDepre").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("lnkFaDepreEntry.notDepre").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("lnkFaDepreEntry.depreciation").getStyleAttributes().setNumberFormat(FaClientUtils.getFormatPatternForColumn(baseScale));
        this.tblMain.getColumn("lnkFaDepreEntry.shouldDepre").getStyleAttributes().setNumberFormat(FaClientUtils.getFormatPatternForColumn(baseScale));
        this.tblMain.getColumn("lnkFaDepreEntry.notDepre").getStyleAttributes().setNumberFormat(FaClientUtils.getFormatPatternForColumn(baseScale));
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    private CompanyOrgUnitInfo getCurrentCompany() {
        if (this.currentCompany == null) {
            if (this.getBOTPViewStatus() == 1 && this.getUIContext().get("BTPCreateMode") == null) {
                EntityViewInfo botpFilter = (EntityViewInfo)this.getUIContext().get("BOTPFilter");
                FaDepreciationCollection deps = new FaDepreciationCollection();
                try {
                    deps = FaDepreciationFactory.getRemoteInstance().getFaDepreciationCollection("select company.* " + botpFilter);
                }
                catch (BOSException e) {
                    this.handleException((Exception)((Object)e));
                    SysUtil.abort();
                }
                this.currentCompany = deps.size() > 0 ? deps.get(0).getCompany() : SysContext.getSysContext().getCurrentFIUnit();
            } else {
                this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
            }
        }
        return (CompanyOrgUnitInfo)this.currentCompany.clone();
    }
}

