/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.client.AttachmentUIContextInfo;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.basedata.person.client.PersonF7Filter;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.basedata.client.FaAlterModePromptBox;
import com.kingdee.eas.fi.fa.basedata.client.FaDisplyFormatter;
import com.kingdee.eas.fi.fa.basedata.client.FaEditFormatter;
import com.kingdee.eas.fi.fa.def.meta.FaDefEntityManager;
import com.kingdee.eas.fi.fa.def.meta.FaDefMetaUtil;
import com.kingdee.eas.fi.fa.manage.FaBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaClearBillInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaDepreciationEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillFactory;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillInfo;
import com.kingdee.eas.fi.fa.manage.FaDispatchDirectionEnum;
import com.kingdee.eas.fi.fa.manage.FaEvalDepreciationEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.IFaDispatchBill;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaDispatchBillEditUI;
import com.kingdee.eas.fi.fa.manage.client.CommonQueryWithResultDialog;
import com.kingdee.eas.fi.fa.manage.client.FACommonProcessor;
import com.kingdee.eas.fi.fa.manage.client.FaCardUtil;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.manage.client.FaCurCardEditUI;
import com.kingdee.eas.fi.fa.manage.client.FaPrintHelper;
import com.kingdee.eas.fi.fa.manage.client.FaScanBarCodesEditUI;
import com.kingdee.eas.fi.gl.client.VersionUtil;
import com.kingdee.eas.framework.BillBaseCollection;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class FaDispatchBillEditUI
extends AbstractFaDispatchBillEditUI {
    private static final Logger logger = Logger.getLogger(FaDispatchBillEditUI.class);
    private static final int DISPATCHQUANTITY = 11;
    private NewCompanyF7 aCompanyBizUnitF7 = new NewCompanyF7((IUIObject)this);
    private static String className = "com.kingdee.eas.fi.fa.manage.FaCardResource";
    private boolean initDefPropertyBind = false;

    @Override
    protected void initBtnStatus() throws Exception {
        super.initBtnStatus();
        if (this.editData != null && this.editData.getCheckedStatus() != null) {
            if (this.editData.getCheckedStatus().getValue() == 2 || OprtState.VIEW.equals(this.getOprtState())) {
                this.actionScanPitch.setEnabled(false);
            } else {
                this.actionScanPitch.setEnabled(true);
            }
        }
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.initDispatchBillHead();
        this.menuItemAudit.setAccelerator(KeyStroke.getKeyStroke("ctrl U"));
        this.menuItemUnAudit.setAccelerator(KeyStroke.getKeyStroke("ctrl shift U"));
        this.btnScanPitch.setIcon(EASResource.getIcon((String)"imgTbtn_applycondition"));
        this.actionScanPitch.setEnabled(false);
        this.actionScanPitch.setVisible(false);
        boolean isUseBarCode = Boolean.valueOf(String.valueOf(this.getFaParameter().get("FA_043")));
        boolean isUseGroupNumber = Boolean.valueOf(String.valueOf(this.getFaParameter().get("FA_030")));
        if (isUseBarCode) {
            this.actionScanPitch.setEnabled(true);
            this.actionScanPitch.setVisible(true);
        }
        this.detailTable.getColumn("barCode").getStyleAttributes().setHided(!isUseBarCode);
        this.detailTable.getColumn("groupNumber").getStyleAttributes().setHided(!isUseGroupNumber);
        if (this.editData != null && this.editData.getCheckedStatus() != null) {
            if (this.editData.getCheckedStatus().getValue() == 2 || OprtState.VIEW.equals(this.getOprtState())) {
                this.actionScanPitch.setEnabled(false);
            } else {
                this.actionScanPitch.setEnabled(true);
            }
        }
        this.bindDefProperty();
        this.detailTable.getActionMap().remove("Paste");
        this.chkDispatchWithEvalValue.setVisible(false);
        this.chkMenuItemSubmitAndPrint.setVisible(false);
    }

    @Override
    protected boolean isShowAttachmentAction() {
        return true;
    }

    @Override
    protected HashMap getFaParameter() throws Exception {
        if (this.faParameter == null) {
            this.faParameter = FaClientUtils.getFAParameter(this.getCurrentCompany().getId());
        }
        return this.faParameter;
    }

    @Override
    protected String[] getFormatColumns() {
        String[] mergeColumns = new String[]{"assetValue", "accuDepr", "neatValue", "evaluateValue"};
        return mergeColumns;
    }

    @Override
    protected String[] getAssetAmtColumns() {
        return new String[]{"assetAmt", "quantity"};
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return FaDispatchBillFactory.getRemoteInstance();
    }

    @Override
    public void loadFields() {
        this.bindDefProperty();
        super.loadFields();
        this.showBotton();
        this.calcTotalAmount();
    }

    private void bindDefProperty() {
        if (!this.initDefPropertyBind) {
            try {
                FaDefEntityManager.bindDefProperty((String)"faDispatchBillEntry.faBizCard.", (KDTable)this.detailTable, (String)this.resHelper.getString("detailTable.formatXml"), (DataBinder)this.dataBinder);
                this.initDefPropertyBind = true;
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
    }

    private void initDispatchBillHead() throws Exception {
        FaClientUtils.setComponentPrecision(new Object[]{this.formatTxtDispatchAmount}, this.getCurrencyScale());
        FaAlterModePromptBox aFaAlterModePromptBox = new FaAlterModePromptBox((CoreUIObject)this);
        this.prmtDispatchMethod.setSelector((KDPromptSelector)aFaAlterModePromptBox);
        this.prmtDispatchMethod.setDisplayFormatter((IFormatter)new FaDisplyFormatter());
        this.prmtDispatchMethod.setEditFormatter((IFormatter)new FaEditFormatter());
        this.prmtDispatchMethod.setEntityViewInfo(FaClientUtils.getAlterModeOrgSplitViewInfo(false));
        this.aCompanyBizUnitF7.setIsCUFilter(false);
        this.aCompanyBizUnitF7.setNeedAddOrgRange(false);
        this.prmtInCompany.setSelector((KDPromptSelector)this.aCompanyBizUnitF7);
        this.prmtInCompany.setHasCUDefaultFilter(false);
        HashMap hmParam = this.gethmParam();
        HashMap map = new HashMap();
        boolean isRange = "true".equals(hmParam.get("FA_040").toString());
        PersonPromptBox personPromptBox = FaClientUtils.getRangePersonF7(isRange, map, (IUIObject)this);
        this.prmtOutPrincipal.setSelector((KDPromptSelector)personPromptBox);
        this.prmtOutPrincipal.setFilterInfoProducer((IFilterInfoProducer)new PersonF7Filter(map));
        this.prmtOutPrincipal.setHasCUDefaultFilter(false);
        this.prmtInPrincipal.setSelector((KDPromptSelector)personPromptBox);
        this.prmtInPrincipal.setFilterInfoProducer((IFilterInfoProducer)new PersonF7Filter(map));
        this.prmtInPrincipal.setHasCUDefaultFilter(false);
    }

    protected void initListener() {
        this.getDetailTable().addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    FaDispatchBillEditUI.this.tableSelfStopEdit(e);
                }
                catch (Exception e1) {
                    logger.error((Object)e1);
                }
            }
        });
    }

    public void tableSelfStopEdit(KDTEditEvent e) throws Exception {
        KDTable kdtable = this.getDetailTable();
        String className = "com.kingdee.eas.fi.fa.manage.FaCardResource";
        int currCol = kdtable.getSelectManager().getActiveColumnIndex();
        BigDecimal zero = new BigDecimal("0");
        if (e.getColIndex() == kdtable.getColumnIndex("quantity")) {
            int rowIndex = kdtable.getSelectManager().getActiveRowIndex();
            FaCurCardInfo curCard = this.getCurCardInfo(kdtable.getRow(rowIndex).getCell("FaCurCardID").getValue().toString());
            BigDecimal assetAmt = new BigDecimal(kdtable.getRow(rowIndex).getCell("assetAmt").getValue().toString());
            if (kdtable.getRow(rowIndex).getCell("quantity").getValue() != null) {
                BigDecimal quantity = (BigDecimal)kdtable.getRow(rowIndex).getCell("quantity").getValue();
                if (quantity.compareTo(assetAmt) > 0) {
                    MsgBox.showInfo((String)EASResource.getString((String)className, (String)"FaDispatchBillEditUI_DispatchQuantityExceedassetAmt"));
                    quantity = assetAmt;
                    kdtable.getRow(rowIndex).getCell("quantity").setValue((Object)assetAmt);
                } else if (quantity.compareTo(zero) <= 0) {
                    MsgBox.showInfo((String)EASResource.getString((String)className, (String)"FaDispatchBillEditUI_DispatchQuantityEquateZero"));
                    quantity = assetAmt;
                    kdtable.getRow(rowIndex).getCell("quantity").setValue((Object)assetAmt);
                }
                this.calcDispAmount(kdtable, rowIndex, curCard, quantity);
            } else {
                this.calcDispAmount(kdtable, rowIndex, curCard, assetAmt);
            }
        }
        this.calcTotalAmount();
    }

    private void calcDispAmount(KDTable kdtable, int rowIndex, FaCurCardInfo curCard, BigDecimal dispCount) throws Exception {
        BigDecimal assetAmt = curCard.getAssetAmt();
        int scale = this.getCurrencyScale();
        IRow row = kdtable.getRow(rowIndex);
        PeriodInfo curPeriod = FaClientUtils.getCurrentPeriod(curCard.getCompany().getId().toString());
        boolean isStartDeprTime = curCard.getAssetCat().getDepreciationPolicy().getStartDeprTime().getValue() != 0;
        boolean isDep = FaDepreciationEntryFactory.getRemoteInstance().exists("select fid where LnkFaDepreEntry.period.id='" + curPeriod.getId().toString() + "' and LnkFaDepreEntry.company.id='" + curCard.getCompany().getId().toString() + "' and faCurCard.id='" + curCard.getId().toString() + "'");
        if (!isDep) {
            isDep = FaEvalDepreciationEntryFactory.getRemoteInstance().exists("select fid where LnkFaDepreEntry.period.id='" + curPeriod.getId().toString() + "' and LnkFaDepreEntry.company.id='" + curCard.getCompany().getId().toString() + "' and faCurCard.id='" + curCard.getId().toString() + "'");
        }
        row.getCell("assetValue").setValue((Object)curCard.getAssetValue().multiply(dispCount).divide(assetAmt, scale, 4));
        BigDecimal accuDepr = curCard.getAccuDepr();
        if (isDep && !isStartDeprTime) {
            BigDecimal zero = new BigDecimal("0");
            BigDecimal termDepr = curCard.getDeprTTerm() == null ? zero : curCard.getDeprTTerm();
            accuDepr = accuDepr.subtract(termDepr);
        }
        row.getCell("accuDepr").setValue((Object)accuDepr.multiply(dispCount).divide(assetAmt, scale, 4));
        row.getCell("evaluateValue").setValue((Object)curCard.getInitEvalValue().multiply(dispCount).divide(assetAmt, scale, 4));
        boolean isEvaledBefore = Boolean.valueOf(row.getCell("isEvaledBefore").getValue().toString());
        boolean calcuByEvaluate = Boolean.valueOf(row.getCell("calcuByEvaluate").getValue().toString());
        isEvaledBefore = isEvaledBefore && calcuByEvaluate;
        BigDecimal neatValue = isEvaledBefore ? ((BigDecimal)row.getCell("evaluateValue").getValue()).subtract((BigDecimal)row.getCell("accuDepr").getValue()) : ((BigDecimal)row.getCell("assetValue").getValue()).subtract((BigDecimal)row.getCell("accuDepr").getValue());
        row.getCell("neatValue").setValue((Object)neatValue);
    }

    @Override
    protected IObjectValue createNewData() {
        FaDispatchBillInfo dispatchBillInfo = new FaDispatchBillInfo();
        if (dispatchBillInfo.getId() == null || dispatchBillInfo.getId().equals((Object)"")) {
            Date today = new Date();
            dispatchBillInfo.setDispatchDate(today);
            try {
                PeriodInfo aPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.currCompany);
                if (aPeriodInfo != null && DateTimeUtils.dayBefore((Date)today, (Date)aPeriodInfo.getBeginDate())) {
                    dispatchBillInfo.setDispatchDate(aPeriodInfo.getBeginDate());
                } else if (DateTimeUtils.dayAfter((Date)today, (Date)aPeriodInfo.getEndDate())) {
                    dispatchBillInfo.setDispatchDate(aPeriodInfo.getEndDate());
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            dispatchBillInfo.setOutCompany(this.currCompany);
            dispatchBillInfo.setOutPrincipal(SysContext.getSysContext().getCurrentUserInfo().getPerson());
        }
        return dispatchBillInfo;
    }

    @Override
    protected IObjectValue createNewDetailData(KDTable table) {
        FaDispatchBillEntryInfo faDispatchBillEntryInfo = new FaDispatchBillEntryInfo();
        return faDispatchBillEntryInfo;
    }

    @Override
    protected void verifyBeforeSubmit(ActionEvent e) throws Exception {
        if (e == null || e != null && this.getActionFromActionEvent(e).equals(this.actionSubmit)) {
            KDTable kdtable;
            int rowCount;
            boolean isInitEnd;
            if (this.pkDispatchDate.getValue() == null) {
                this.pkDispatchDate.requestFocus();
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)className, (String)"FaDispatchBillEditUI_DispatchDateIsNull"));
                SysUtil.abort();
            } else {
                Date changeDate = (Date)this.pkDispatchDate.getValue();
                PeriodInfo aPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.currCompany);
                if (aPeriodInfo != null && (DateTimeUtils.dayBefore((Date)changeDate, (Date)aPeriodInfo.getBeginDate()) || DateTimeUtils.dayAfter((Date)changeDate, (Date)aPeriodInfo.getEndDate()))) {
                    this.pkDispatchDate.requestFocus();
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)className, (String)"FaDispatchBillEditUI_DispatchDateError"));
                    SysUtil.abort();
                }
            }
            if (this.prmtInCompany.getValue() == null) {
                this.prmtInCompany.requestFocus();
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)className, (String)"FaDispatchBillEditUI_InCompanyIsNull"));
                SysUtil.abort();
            }
            if (!(isInitEnd = SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)this.prmtInCompany.getValue())))) {
                this.prmtInCompany.requestFocus();
                String msg = EASResource.getString((String)className, (String)"FaDispatchInCompany");
                msg = msg + EASResource.getString((String)className, (String)"FaCurCardEditUI_FANotEndInit");
                MsgBox.showInfo((Component)((Object)this), (String)msg);
                SysUtil.abort();
            }
            if (this.prmtDispatchMethod.getValue() == null) {
                this.prmtDispatchMethod.requestFocus();
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)className, (String)"FaDispatchBillEditUI_DispatchMethodIsNull"));
                SysUtil.abort();
            }
            if (this.prmtOutPrincipal.getValue() == null) {
                this.prmtOutPrincipal.requestFocus();
                MsgBox.showInfo((Component)((Object)this), (String)FaResUtil.getRes((String)"chiefCanNotNull"));
                SysUtil.abort();
            }
            if (this.prmtInPrincipal.getValue() == null) {
                this.prmtInPrincipal.requestFocus();
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)className, (String)"FaDispatchBillEditUI_InPrincipalIsNull"));
                SysUtil.abort();
            }
            if ((rowCount = (kdtable = this.getDetailTable()).getRowCount()) == 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)className, (String)"FaDispatchBillEditUI_EntryIsNull"));
                SysUtil.abort();
            } else {
                for (int i = 0; i < rowCount; ++i) {
                    if (kdtable.getRow(i).getCell("quantity").getValue() == null) {
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)className, (String)"FaDispatchBillEditUI_QuantityIsNull"));
                        SysUtil.abort();
                    }
                    if (((BigDecimal)kdtable.getRow(i).getCell("quantity").getValue()).compareTo(new BigDecimal("0")) > 0) continue;
                    MsgBox.showInfo((String)EASResource.getString((String)className, (String)"FaDispatchBillEditUI_DispatchQuantityEquateZero"));
                    SysUtil.abort();
                }
            }
            PeriodInfo periodOut = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)this.prmtOutCompany.getValue()));
            PeriodInfo periodIn = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)this.prmtInCompany.getValue()));
            if (periodIn == null) {
                String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource.FaDispatchInCompany") + EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardInitResource.FaCardPeriodIsNull");
                MsgBox.showInfo((Component)((Object)this), (String)strMsg);
                SysUtil.abort();
            }
            if (periodOut.getPeriodYear() != periodIn.getPeriodYear() || periodOut.getPeriodNumber() != periodIn.getPeriodNumber()) {
                String msg_currentPeriod = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource.CurrentPeriodIs");
                String msg_year = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose.year");
                String msg_period = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose.period");
                String msg_outCompany = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource.FaDispatchOutCompany");
                String msg_inCompany = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource.FaDispatchInCompany");
                String msg_notSamePeriodForDispatch = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource.NotSamePeriodForDispatch");
                String strMsg = msg_outCompany + msg_currentPeriod + periodOut.getPeriodYear() + msg_year + periodOut.getPeriodNumber() + msg_period + "\uff0c" + msg_inCompany + msg_currentPeriod + periodIn.getPeriodYear() + msg_year + periodIn.getPeriodNumber() + msg_period + "\uff0c" + msg_notSamePeriodForDispatch;
                MsgBox.showInfo((Component)((Object)this), (String)strMsg);
                SysUtil.abort();
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected boolean isShowCardFilter() {
        return false;
    }

    private void showBotton() {
        this.contDetailTable.removeButton((JButton)this.btnInsertCard);
        this.contDetailTable.removeButton((JButton)this.btnRemoveCard);
        this.contDetailTable.addButton((JButton)this.btnInsertCard);
        this.contDetailTable.addButton((JButton)this.btnRemoveCard);
        this.btnInsertCard.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnRemoveCard.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        boolean isInWorkflow = false;
        if (FaClientUtils.isFromWorkflow(this.getUIContext()) && this.editData.getDispatchDirection() == FaDispatchDirectionEnum.IN) {
            isInWorkflow = true;
            this.actionMultiapprove.setEnabled(false);
            this.actionNextPerson.setEnabled(false);
            this.actionUnAudit.setEnabled(false);
            this.actionAudit.setEnabled(false);
        }
        boolean isNotFromWorkflowListUI = this.getUIContext().get("isLightWeight") == null;
        this.actionAffirmInEdit.setEnabled(isInWorkflow && isNotFromWorkflowListUI);
        this.menuItemAffirmInEdit.setVisible(isInWorkflow && isNotFromWorkflowListUI);
        this.btnAffirmInEdit.setVisible(isInWorkflow && isNotFromWorkflowListUI);
        this.btnAffirmInEdit.setIcon(EASResource.getIcon((String)"imgTbtn_affirm"));
        this.menuItemAffirmInEdit.setIcon(EASResource.getIcon((String)"imgTbtn_affirm"));
        this.btnTraceDown.setEnabled(!isInWorkflow);
        this.actionTraceDown.setEnabled(!isInWorkflow);
        this.btnTraceUp.setEnabled(false);
        this.actionTraceUp.setEnabled(false);
        boolean isViewState = "FINDVIEW".equals(this.getOprtState()) || "VIEW".equals(this.getOprtState());
        this.actionInsertCard.setEnabled(!isInWorkflow && !isViewState);
        this.actionRemoveCard.setEnabled(!isInWorkflow && !isViewState);
        if (this.editData.getEffectedStatus() != null) {
            this.actionSave.setEnabled(EffectedStatusEnum.TEMPSTORE.equals((Object)this.editData.getEffectedStatus()) && !"VIEW".equals(this.getOprtState()));
        }
    }

    private CommonQueryWithResultDialog initDialog() throws Exception {
        CommonQueryWithResultDialog dialog = new CommonQueryWithResultDialog();
        if (this.getUIWindow() == null) {
            dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            dialog.setOwner((Component)((Object)this));
        }
        HashMap hmParam = this.gethmParamD();
        boolean isRange = "true".equals(hmParam.get("FA_040").toString());
        FACommonProcessor processor = new FACommonProcessor();
        processor.setRange(isRange);
        dialog.setProcessor((IProcessor)processor);
        dialog.setParentUIClassName(((Object)((Object)this)).getClass().getName());
        dialog.setEntityViewInfo(new EntityViewInfo());
        dialog.setQueryObjectPK((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.fa.manage", "FaCurCardQuery"));
        dialog.setTitle(this.getUITitle());
        dialog.setHeight(525);
        dialog.setSelectMode(10);
        dialog.setOpenType(0);
        return dialog;
    }

    @Override
    protected KDTable getDetailTable() {
        return this.detailTable;
    }

    protected FaCurCardInfo getCurCardInfo(String curCardID) {
        FaCurCardInfo curCardInfo = new FaCurCardInfo();
        try {
            SelectorItemCollection sic = FaDefMetaUtil.getFaDefPropertySelectors((SelectorItemCollection)this.getCurCardSelectors());
            curCardInfo = FaCurCardFactory.getRemoteInstance().getFaCurCardInfo((IObjectPK)new ObjectUuidPK(curCardID), sic);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return curCardInfo;
    }

    public SelectorItemCollection getCurCardSelectors() {
        return AbstractFaDispatchBillEditUI.getCurCardSelectors(0);
    }

    private void setTable(ArrayList rowSet) throws Exception {
        if (rowSet != null && rowSet.size() > 0) {
            KDTable kdtable = this.getDetailTable();
            for (int i = 0; i < rowSet.size(); ++i) {
                IRow result = (IRow)rowSet.get(i);
                boolean isDuplicate = false;
                for (int j = 0; j < kdtable.getRowCount(); ++j) {
                    Object oldID = kdtable.getRow(j).getCell("FaCurCardID").getValue();
                    Object newID = result.getCell("id").getValue();
                    if (oldID == null || newID == null || !oldID.toString().equals(newID.toString())) continue;
                    isDuplicate = true;
                    break;
                }
                if (isDuplicate) continue;
                FaCurCardInfo curCard = this.getCurCardInfo(result.getCell("id").getValue().toString());
                if (this.isNeedDepreciation(curCard)) {
                    MsgBox.showInfo((Component)((Object)this), (String)FaResUtil.getRes((String)"hasNoDpr"));
                    SysUtil.abort();
                }
                EffectedStatusEnum effectedStatus = curCard.getEffectedStatus();
                CheckedStatusEnum checkedStatus = curCard.getCheckedStatus();
                BlockedStatusEnum blockedStatus = curCard.getBlockedStatus();
                DeletedStatusEnum deletedStatus = curCard.getDeletedStatus();
                FaBizStatusEnum bizStatus = curCard.getBizStatus();
                if (effectedStatus == null || effectedStatus != EffectedStatusEnum.EFFECTED || checkedStatus == null || checkedStatus != CheckedStatusEnum.AUDITED || blockedStatus == null || blockedStatus != BlockedStatusEnum.UNBLOCKED || deletedStatus == null || deletedStatus != DeletedStatusEnum.NORMAL || !bizStatus.getValue().endsWith("99")) continue;
                PeriodInfo curPeriod = FaClientUtils.getCurrentPeriod(curCard.getCompany().getId().toString());
                boolean isStartDeprTime = curCard.getAssetCat().getDepreciationPolicy().getStartDeprTime().getValue() != 0;
                boolean isDep = FaDepreciationEntryFactory.getRemoteInstance().exists("select fid where LnkFaDepreEntry.period.id='" + curPeriod.getId().toString() + "' and LnkFaDepreEntry.company.id='" + curCard.getCompany().getId().toString() + "' and faCurCard.id='" + curCard.getId().toString() + "'");
                if (!isDep) {
                    isDep = FaEvalDepreciationEntryFactory.getRemoteInstance().exists("select fid where LnkFaDepreEntry.period.id='" + curPeriod.getId().toString() + "' and LnkFaDepreEntry.company.id='" + curCard.getCompany().getId().toString() + "' and faCurCard.id='" + curCard.getId().toString() + "'");
                }
                IRow row = kdtable.addRow();
                FaDispatchBillEntryInfo billInfo = (FaDispatchBillEntryInfo)this.createNewDetailData(kdtable);
                billInfo.setFaBizCard(FaClientUtils.CurCard2BizCard(curCard));
                billInfo.setFaCurCard(curCard);
                billInfo.setQuantity(curCard.getAssetAmt());
                billInfo.setAssetValue(curCard.getAssetValue());
                if (!isDep || isStartDeprTime) {
                    billInfo.setNeatValue(curCard.getNeatValue());
                    billInfo.setAccuDepr(curCard.getAccuDepr());
                } else {
                    BigDecimal zero = new BigDecimal("0");
                    BigDecimal termDepr = curCard.getDeprTTerm() == null ? zero : curCard.getDeprTTerm();
                    billInfo.setNeatValue(curCard.getNeatValue().add(termDepr));
                    billInfo.setAccuDepr(curCard.getAccuDepr().subtract(termDepr));
                }
                billInfo.setEvaluateValue(curCard.getInitEvalValue());
                this.loadLineFields(kdtable, row, (IObjectValue)billInfo);
            }
        }
    }

    private void setTableUS(List rowSet) throws Exception {
        if (rowSet != null && rowSet.size() > 0) {
            KDTable kdtable = this.getDetailTable();
            for (int i = 0; i < rowSet.size(); ++i) {
                boolean isDuplicate = false;
                for (int j = 0; j < kdtable.getRowCount(); ++j) {
                    Object oldID = kdtable.getRow(j).getCell("FaCurCardID").getValue();
                    String newID = rowSet.get(i).toString();
                    if (oldID == null || newID == null || !oldID.toString().equals(newID.toString())) continue;
                    isDuplicate = true;
                    break;
                }
                if (isDuplicate) continue;
                FaCurCardInfo curCard = this.getCurCardInfo(rowSet.get(i).toString());
                if (this.isNeedDepreciation(curCard)) {
                    MsgBox.showInfo((Component)((Object)this), (String)FaResUtil.getRes((String)"hasNoDpr"));
                    SysUtil.abort();
                }
                EffectedStatusEnum effectedStatus = curCard.getEffectedStatus();
                CheckedStatusEnum checkedStatus = curCard.getCheckedStatus();
                BlockedStatusEnum blockedStatus = curCard.getBlockedStatus();
                DeletedStatusEnum deletedStatus = curCard.getDeletedStatus();
                FaBizStatusEnum bizStatus = curCard.getBizStatus();
                if (effectedStatus == null || effectedStatus != EffectedStatusEnum.EFFECTED || checkedStatus == null || checkedStatus != CheckedStatusEnum.AUDITED || blockedStatus == null || blockedStatus != BlockedStatusEnum.UNBLOCKED || deletedStatus == null || deletedStatus != DeletedStatusEnum.NORMAL || !bizStatus.getValue().endsWith("99")) continue;
                PeriodInfo curPeriod = FaClientUtils.getCurrentPeriod(curCard.getCompany().getId().toString());
                boolean isStartDeprTime = curCard.getAssetCat().getDepreciationPolicy().getStartDeprTime().getValue() != 0;
                boolean isDep = FaDepreciationEntryFactory.getRemoteInstance().exists("select fid where LnkFaDepreEntry.period.id='" + curPeriod.getId().toString() + "' and LnkFaDepreEntry.company.id='" + curCard.getCompany().getId().toString() + "' and faCurCard.id='" + curCard.getId().toString() + "'");
                if (!isDep) {
                    isDep = FaEvalDepreciationEntryFactory.getRemoteInstance().exists("select fid where LnkFaDepreEntry.period.id='" + curPeriod.getId().toString() + "' and LnkFaDepreEntry.company.id='" + curCard.getCompany().getId().toString() + "' and faCurCard.id='" + curCard.getId().toString() + "'");
                }
                IRow row = kdtable.addRow();
                FaDispatchBillEntryInfo billInfo = (FaDispatchBillEntryInfo)this.createNewDetailData(kdtable);
                billInfo.setFaBizCard(FaClientUtils.CurCard2BizCard(curCard));
                billInfo.setFaCurCard(curCard);
                billInfo.setQuantity(curCard.getAssetAmt());
                billInfo.setAssetValue(curCard.getAssetValue());
                if (isStartDeprTime) {
                    billInfo.setNeatValue(curCard.getNeatValue());
                    billInfo.setAccuDepr(curCard.getAccuDepr());
                } else {
                    BigDecimal zero = new BigDecimal("0");
                    BigDecimal termDepr = curCard.getDeprTTerm() == null ? zero : curCard.getDeprTTerm();
                    billInfo.setNeatValue(curCard.getNeatValue().add(termDepr));
                    billInfo.setAccuDepr(curCard.getAccuDepr().subtract(termDepr));
                }
                billInfo.setEvaluateValue(curCard.getInitEvalValue());
                this.loadLineFields(kdtable, row, (IObjectValue)billInfo);
            }
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.faBizCard.faBakCard.id"));
        sic.add(new SelectorItemInfo("company"));
        sic.add(new SelectorItemInfo("dispatchDirection"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        sic.add(new SelectorItemInfo("effectedStatus"));
        sic.add("FaDispatchBillEntry.faBizCard.propertyValue.*");
        return sic;
    }

    @Override
    protected void initCtrlComponent() throws Exception {
        super.initCtrlComponent();
        if (!"VIEW".equals(this.getOprtState())) {
            this.prmtInCompany.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    FaDispatchBillEditUI.this.inCompanyDataChanged(eventObj);
                }
            });
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    protected boolean isNeedCodeRule() {
        return true;
    }

    private void inCompanyDataChanged(DataChangeEvent eventObj) {
        if (this.prmtInCompany.getValue() == null) {
            return;
        }
        CompanyOrgUnitInfo inCompany = null;
        if (this.prmtInCompany.getValue().getClass().isInstance(new CompanyOrgUnitInfo())) {
            inCompany = (CompanyOrgUnitInfo)this.prmtInCompany.getValue();
            this.processInCompanyDataChanged(inCompany);
        } else {
            OrgUnitInfo unitInfo = (OrgUnitInfo)this.prmtInCompany.getValue();
            if (unitInfo.isIsCompanyOrgUnit()) {
                try {
                    inCompany = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(unitInfo.getId()));
                    this.prmtInCompany.setValue((Object)inCompany);
                }
                catch (Exception e) {
                    SysUtil.abort();
                }
            }
        }
    }

    private void processInCompanyDataChanged(CompanyOrgUnitInfo inCompany) {
        if (inCompany.getId().equals((Object)((CompanyOrgUnitInfo)this.prmtOutCompany.getValue()).getId())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)className, (String)"FaDispatchBillEditUI_InCompanyEqualsOutCompany"));
            this.prmtInCompany.setValue(null);
            this.prmtInCompany.requestFocus();
            return;
        }
        if (!inCompany.isIsBizUnit()) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.vitualComNotAllowUseThisFun");
            MsgBox.showInfo((Component)((Object)this), (String)strMsg);
            this.prmtInCompany.setValue(null);
            this.prmtInCompany.requestFocus();
            return;
        }
        if (!inCompany.isIsCompanyOrgUnit()) {
            MsgBox.showInfo((Component)((Object)this), (String)FaResUtil.getRes((String)"isNotFI"));
            this.prmtInCompany.setValue(null);
            this.prmtInCompany.requestFocus();
            return;
        }
    }

    @Override
    protected String getEntryKeyName() {
        return "faDispatchBillEntry";
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        this.txtDispatchCause.requestFocus();
    }

    @Override
    public void actionScanPitch_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = null;
        IUIFactory factory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        uiWindow = factory.create(FaScanBarCodesEditUI.class.getName(), (Map)uiContext, null, null);
        uiWindow.show();
        uiWindow.getUIObject().getUIContext().get("keys");
        Set keys = new HashSet();
        keys = (Set)uiWindow.getUIObject().getUIContext().get("keys");
        if (keys == null) {
            return;
        }
        if (keys.size() <= 0) {
            return;
        }
        List<Object> al = Arrays.asList(keys.toArray());
        this.setTableUS(al);
        this.calcTotalAmount();
    }

    @Override
    public void actionInsertCard_actionPerformed(ActionEvent e) throws Exception {
        CommonQueryWithResultDialog dialog = this.initDialog();
        if (dialog.show() || dialog.hasKeyValue()) {
            this.setTable(dialog.getSearchResult());
            this.calcTotalAmount();
        } else {
            SysUtil.abort();
        }
    }

    @Override
    public void actionRemoveCard_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.removeLine(this.detailTable);
        this.calcTotalAmount();
    }

    @Override
    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        String msgTxt = FaResUtil.getRes((String)"noDestinationBill");
        if (this.getOprtState() == OprtState.ADDNEW) {
            MsgBox.showInfo((String)msgTxt);
            SysUtil.abort();
        }
        IFaDispatchBill iFadispatchBill = FaDispatchBillFactory.getRemoteInstance();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("inCompany.id"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.newCard.id"));
        sic.add(new SelectorItemInfo("faClearBill"));
        sic.add(new SelectorItemInfo("faClearBill.id"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        FaDispatchBillInfo billInfo = iFadispatchBill.getFaDispatchBillInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()), sic);
        FaDispatchBillEntryCollection billEnties = billInfo.getFaDispatchBillEntry();
        if (billInfo.getCheckedStatus().getValue() != 2) {
            MsgBox.showInfo((String)msgTxt);
            return;
        }
        HashMap idList = new HashMap();
        Vector<String> v1 = new Vector<String>();
        if (this.getCurCompany().getId().toString().equals(billInfo.getInCompany().getId().toString())) {
            int size = billEnties.size();
            for (int i = 0; i < size; ++i) {
                FaDispatchBillEntryInfo billEntry = billEnties.get(i);
                if (billEntry.getNewCard() == null) {
                    MsgBox.showInfo((String)msgTxt);
                    return;
                }
                String newCardId = billEntry.getNewCard().getId().toString();
                v1.add(newCardId);
            }
            if (v1.size() > 0) {
                idList.put(billEnties.get(0).getNewCard().getBOSType().toString(), v1);
                this.showTraceUI(idList, 0);
            } else {
                MsgBox.showInfo((String)msgTxt);
            }
        } else {
            FaClearBillInfo clearBillInfo = billInfo.getFaClearBill();
            if (clearBillInfo == null) {
                MsgBox.showInfo((String)msgTxt);
                return;
            }
            v1.add(clearBillInfo.getId().toString());
            idList.put(clearBillInfo.getBOSType().toString(), v1);
            this.showTraceUI(idList, 0);
        }
    }

    @Override
    protected String[] getEditableColumn() {
        return new String[]{"quantity", "evaluateValue", "description"};
    }

    @Override
    public void actionAffirmInEdit_actionPerformed(ActionEvent e) throws Exception {
        String pk = this.editData.getId().toString();
        FaDispatchBillFactory.getRemoteInstance().affirm((IObjectPK)new ObjectUuidPK(pk));
        this.destroyWindow();
        if (SysContext.getSysContext().getCurrentFIUnit() == null || !SysContext.getSysContext().getCurrentFIUnit().isIsBizUnit()) {
            return;
        }
        String sourceCompId = this.editData.getCompany().getId().toString();
        if (!SysContext.getSysContext().getCurrentFIUnit().getId().toString().equals(sourceCompId)) {
            return;
        }
        FaCurCardCollection newCards = FaCurCardFactory.getRemoteInstance().getFaCurCardCollection("select id where sourceBillId ='" + pk + "'");
        RealModeIDList idList = new RealModeIDList();
        for (int i = 0; i < newCards.size(); ++i) {
            idList.add(newCards.get(i).getId().toString());
        }
        String currentId = newCards.get(0).getId().toString();
        idList.setCurrentID(currentId);
        idList.setCount(newCards.size());
        UIContext uiContext = new UIContext((Object)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        uiContext.put((Object)"ID", (Object)currentId);
        uiContext.put((Object)"ObjectUpdateLockId", (Object)currentId);
        uiContext.put((Object)"IDList", (Object)idList);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(FaCurCardEditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    @Override
    protected String getPrintPath() {
        return "/FI/FA/FaDispatchBill";
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        this.editData.put("assetValueTotal", this.lblAssetValue.getText());
        this.editData.put("neatValueTotal", this.lblNeatValue.getText());
        this.editData.put("accuDeprTotal", this.lblAccuDepr.getText());
        BillBaseCollection billCol = new BillBaseCollection();
        billCol.add((BillBaseInfo)this.editData);
        KDNoteHelper appHlp = new KDNoteHelper();
        KDTable[] tables = new KDTable[]{this.getDetailTable()};
        BOSQueryDelegate data = FaPrintHelper.getPrintManagerForFaDispatchBillEditUI((IObjectCollection)billCol, tables);
        appHlp.printPreview(this.getPrintPath(), (Object)data, (Component)((Object)this));
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        this.editData.put("assetValueTotal", this.lblAssetValue.getText());
        this.editData.put("neatValueTotal", this.lblNeatValue.getText());
        this.editData.put("accuDeprTotal", this.lblAccuDepr.getText());
        BillBaseCollection billCol = new BillBaseCollection();
        billCol.add((BillBaseInfo)this.editData);
        KDNoteHelper appHlp = new KDNoteHelper();
        KDTable[] tables = new KDTable[]{this.getDetailTable()};
        BOSQueryDelegate data = FaPrintHelper.getPrintManagerForFaDispatchBillEditUI((IObjectCollection)billCol, tables);
        appHlp.print(this.getPrintPath(), (Object)data, (Component)((Object)this));
    }

    private void calcTotalAmount() {
        BigDecimal clrAssetValue = ZERO;
        BigDecimal clrNeatValue = ZERO;
        BigDecimal clrAccuDepr = ZERO;
        int scale = this.getCurrencyScale();
        for (int i = 0; i < this.detailTable.getRowCount(); ++i) {
            IRow row = this.detailTable.getRow(i);
            BigDecimal cellAssetValue = row.getCell("assetValue").getValue() == null ? ZERO : (BigDecimal)row.getCell("assetValue").getValue();
            BigDecimal cellInitEvalValue = row.getCell("initEvalValue").getValue() == null ? ZERO : (BigDecimal)row.getCell("initEvalValue").getValue();
            BigDecimal cellClrAccuDepr = row.getCell("accuDepr").getValue() == null ? ZERO : (BigDecimal)row.getCell("accuDepr").getValue();
            boolean isEvaledBefore = row.getCell("isEvaledBefore").getValue() != null ? Boolean.valueOf(row.getCell("isEvaledBefore").getValue().toString()) : false;
            boolean calcuByEvaluate = row.getCell("calcuByEvaluate").getValue() != null ? Boolean.valueOf(row.getCell("calcuByEvaluate").getValue().toString()) : false;
            boolean bl = isEvaledBefore = isEvaledBefore && calcuByEvaluate;
            if (isEvaledBefore) {
                BigDecimal assetAmt = new BigDecimal(row.getCell("assetAmt").getValue().toString());
                BigDecimal quantity = new BigDecimal(row.getCell("quantity").getValue() == null ? "0" : row.getCell("quantity").getValue().toString());
                cellInitEvalValue = cellInitEvalValue.multiply(quantity).divide(assetAmt, scale, 4);
            }
            clrAssetValue = clrAssetValue.add(cellAssetValue);
            clrNeatValue = clrNeatValue.add(isEvaledBefore ? cellInitEvalValue.subtract(cellClrAccuDepr) : cellAssetValue.subtract(cellClrAccuDepr));
            clrAccuDepr = clrAccuDepr.add(cellClrAccuDepr);
        }
        this.lblAssetValue.setText(FaClientUtils.formatDecimal(clrAssetValue, scale));
        this.lblNeatValue.setText(FaClientUtils.formatDecimal(clrNeatValue, scale));
        this.lblAccuDepr.setText(FaClientUtils.formatDecimal(clrAccuDepr, scale));
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(this.getCurCompany().getId().toString());
        super.actionEdit_actionPerformed(e);
        this.actionInsertCard.setEnabled(true);
        this.actionRemoveCard.setEnabled(true);
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if (this.editData != null && this.editData.getDispatchDirection() == FaDispatchDirectionEnum.IN) {
            this.actionMultiapprove.setEnabled(false);
            this.actionNextPerson.setEnabled(false);
            this.actionUnAudit.setEnabled(false);
            this.actionAudit.setEnabled(false);
        }
    }

    private CompanyOrgUnitInfo getCurrentCompany() throws Exception {
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        String companyId = null;
        companyId = FaClientUtils.isFromLink((CoreUIObject)this) ? (String)this.getUIContext().get("COMPANY_ID") : SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("accountPeriodType.id"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("reportCurrency.id"));
        sic.add(new SelectorItemInfo("reportCurrency.number"));
        sic.add(new SelectorItemInfo("reportCurrency.name"));
        sic.add(new SelectorItemInfo("baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("reportExchangeTable.id"));
        companyOrgUnitInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyId)), sic);
        return companyOrgUnitInfo;
    }

    public HashMap gethmParam() {
        HashMap hmParam = new HashMap();
        try {
            hmParam = FaManageUtils.getFAParameter(this.getCurrentCompany().getId());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return hmParam;
    }

    public boolean destroyWindow() {
        this.setOprtState("RELEASEALL");
        return super.destroyWindow();
    }

    @Override
    protected FilterInfo getCardFilter() {
        FilterInfo filter = super.getCardFilter();
        boolean isAutoCreateChangeBillByRequi = "true".equals(this.gethmParam().get("FA_044").toString());
        if (isAutoCreateChangeBillByRequi) {
            String hasRequisitionNotRefunding = "select FCurCardID from T_FA_FaRequisitionedBillEntry billEntry inner join T_FA_FaCurCard curCard on curCard.FID = billEntry.FCurCardID where curCard.FKeeperID not in (select FManageID from T_FA_FaTreasuryManage) and curCard.FCompanyID = '" + this.getCurrentCompanyID() + "'";
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)hasRequisitionNotRefunding, CompareType.NOTINNER));
        }
        String hasBorrowingNotReturn = "select FCurCardID from T_FA_FaBorrowingEntry where FIsReturned = 0";
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)hasBorrowingNotReturn, CompareType.NOTINNER));
        return filter;
    }

    @Override
    public void actionViewImage_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData != null && this.editData.getId() != null) {
            HashSet<String> idset = new HashSet<String>();
            idset.add(this.editData.getId().toString());
            try {
                String navUrl = FaCardUtil.getCardImageUrl(idset, SysContext.getSysContext().getCurrentUserInfo());
                if (navUrl != null) {
                    VersionUtil.gotoSite((String)navUrl, (boolean)true);
                }
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        boolean isAllOpenAttachment = FaManageUtils.getFaParamValue(null, "FA_261", SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
        if (isAllOpenAttachment) {
            AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
            AttachmentUIContextInfo info = this.getAttacheInfo();
            if (info == null) {
                info = new AttachmentUIContextInfo();
            }
            if (info.getBoID() == null || info.getBoID().trim().equals("")) {
                String boID = this.getSelectBOID();
                if (boID == null) {
                    if (OprtState.ADDNEW.equals(this.getOprtState())) {
                        boID = acm.getAttID().toString();
                    } else {
                        return;
                    }
                }
                info.setBoID(boID);
            }
            info.setEdit(true);
            String multi = (String)this.getUIContext().get("MultiapproveAttachment");
            if (multi != null && multi.equals("true")) {
                acm.showAttachmentListUIByBoIDNoAlready((Object)this, info);
            } else {
                acm.showAttachmentListUIByBoID((Object)this, info);
            }
        } else {
            super.actionAttachment_actionPerformed(e);
        }
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(this.getCurCompany().getId().toString());
        super.actionAddNew_actionPerformed(e);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(this.getCurCompany().getId().toString());
        super.actionAudit_actionPerformed(e);
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(this.getCurCompany().getId().toString());
        super.actionUnAudit_actionPerformed(e);
    }
}

