/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.access.MetaDataAccessLoader;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.attachment.client.AttachmentUIContextInfo;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.def.meta.FaDefQueryManager;
import com.kingdee.eas.fi.fa.manage.FaBillBaseInfo;
import com.kingdee.eas.fi.fa.manage.FaBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.FaClearBillInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillCollection;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillException;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillFactory;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillInfo;
import com.kingdee.eas.fi.fa.manage.FaDispatchDirectionEnum;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.IFaDispatchBill;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaDispatchBillListUI;
import com.kingdee.eas.fi.fa.manage.client.FACommonProcessor;
import com.kingdee.eas.fi.fa.manage.client.FaCardUtil;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.manage.client.FaCurCardEditUI;
import com.kingdee.eas.fi.fa.manage.client.FaDispatchBillEditUI;
import com.kingdee.eas.fi.fa.manage.client.FaDispatchCardItemUI;
import com.kingdee.eas.fi.fa.manage.client.FaDispatchCustomerQueryUI;
import com.kingdee.eas.fi.gl.client.VersionUtil;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.framework.client.workflow.MultiAssignmentUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class FaDispatchBillListUI
extends AbstractFaDispatchBillListUI {
    CommonQueryDialog dialog;
    private static final String FADISPATCH_RESOURCE = "com.kingdee.eas.fi.fa.manage.FaCardResource";
    private static final String CHECKED_STATUS = "checkedStatus";
    private int selectedCheckedStauts = 2;

    public FaDispatchBillListUI() throws Exception {
        this.btnAffirm.setIcon(EASResource.getIcon((String)"imgTbtn_affirm"));
        this.btnAffirmInEdit.setIcon(EASResource.getIcon((String)"imgTbtn_affirm"));
        this.actionAffirmInEdit.setBindWorkFlow(true);
        this.btnUnAffirm.setIcon(EASResource.getIcon((String)"imgTbtn_faffirm"));
        this.menuItemAffirm.setIcon(EASResource.getIcon((String)"imgTbtn_affirm"));
        this.menuItemUnAffirm.setIcon(EASResource.getIcon((String)"imgTbtn_faffirm"));
        if (this.selectLineListener != null) {
            this.tblMain.removeKDTSelectListener(this.selectLineListener);
        }
        this.tblMain.getSelectManager().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                FaDispatchBillListUI.this.setButtonState();
            }
        });
        FaDefQueryManager.addDefProperty((IMetaDataPK)this.mainQueryPK, (String)"faBizCard", (KDTable)this.tblMain, (ResourceBundleHelper)this.resHelper);
    }

    public String getTableFormatXml() {
        return this.tblMain.getFormatXml();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.menuItemImportData.setAccelerator(KeyStroke.getKeyStroke("ctrl I"));
        this.menuItemExportData.setAccelerator(KeyStroke.getKeyStroke("ctrl shift E"));
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.menuItemAudit.setAccelerator(KeyStroke.getKeyStroke("ctrl U"));
        this.menuItemUnaudit.setAccelerator(KeyStroke.getKeyStroke("ctrl shift U"));
        this.actionUnAffirm.setVisible(this.isEnableUndo);
        this.actionUnAffirm.setEnabled(this.isEnableUndo);
        FaClientUtils.fmtDate(this.tblMain, new String[]{"dispatchDate"});
        this.getMainStatusBar().setPerTitle(FMClientHelper.getSysStatusBarTitle((CoreUI)this));
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    FaDispatchBillListUI.this.afterSelectLine(e);
                }
                catch (Exception ex) {
                    FaDispatchBillListUI.this.handleException(ex);
                }
            }
        });
    }

    protected void afterSelectLine(KDTSelectEvent e) throws Exception {
        int statusField;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length <= 0) {
            return;
        }
        IRow row = this.tblMain.getRow(selectRows[0]);
        Object obj3 = row.getCell(statusField = this.tblMain.getColumnIndex(CHECKED_STATUS)).getValue();
        if (obj3 instanceof BizEnumValueInfo) {
            BizEnumValueInfo status = (BizEnumValueInfo)obj3;
            this.selectedCheckedStauts = status.getInt();
        }
    }

    @Override
    protected boolean isShowAttachmentAction() {
        return true;
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        boolean isAllOpenAttachment = FaManageUtils.getFaParamValue(null, "FA_261", SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
        boolean isEdit = true;
        if (!isAllOpenAttachment && this.selectedCheckedStauts > 1) {
            isEdit = false;
        }
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        String boID = this.getSelectedKeyValue();
        this.checkSelected();
        if (boID == null) {
            return;
        }
        AttachmentUIContextInfo info = new AttachmentUIContextInfo();
        info.setBoID(boID);
        info.setCode("");
        info.setEdit(isEdit);
        info.setListener(this.createAttatchListener("HEAD"));
        acm.showAttachmentListUIByBoID((Object)this, info);
    }

    private void setButtonState() {
        int size = this.tblMain.getSelectManager().size();
        if (size == 0 || this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            return;
        }
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(0);
        boolean hasAffirmed = false;
        boolean isIncommpany = false;
        IRow row = this.tblMain.getRow(selectBlock.getBeginRow());
        if (row == null) {
            return;
        }
        Object inCompanyID = row.getCell("inCompany.id").getValue();
        hasAffirmed = (Boolean)row.getCell("hasAffirmed").getValue();
        isIncommpany = this.getCurCompany().getId().toString().equals(inCompanyID);
        if (isIncommpany) {
            this.actionUnAudit.setEnabled(false);
            this.actionAudit.setEnabled(false);
            this.actionAffirm.setEnabled(!hasAffirmed);
            this.actionUnAffirm.setEnabled(hasAffirmed);
            for (int k = 0; k < size; ++k) {
                selectBlock = this.tblMain.getSelectManager().get(k);
                for (int i = selectBlock.getTop(); i <= selectBlock.getEndRow(); ++i) {
                    row = this.tblMain.getRow(i);
                    if (hasAffirmed == (Boolean)row.getCell("hasAffirmed").getValue()) continue;
                    this.actionAffirm.setEnabled(false);
                    this.actionUnAffirm.setEnabled(false);
                    return;
                }
            }
        } else {
            ICell cell = row.getCell(CHECKED_STATUS);
            Object keyValue = cell.getValue();
            if (keyValue != null && keyValue instanceof BizEnumValueInfo) {
                if (((BizEnumValueInfo)keyValue).getValue().toString().equals("2")) {
                    this.actionAudit.setEnabled(false);
                    this.actionUnAudit.setEnabled(true);
                } else {
                    this.actionAudit.setEnabled(true);
                    this.actionUnAudit.setEnabled(false);
                }
            }
            this.actionAffirm.setEnabled(false);
            this.actionUnAffirm.setEnabled(false);
        }
    }

    public String getUITitle() {
        return EASResource.getString((String)this.getResClassName(), (String)"FaDispatch");
    }

    @Override
    protected FaBillBaseInfo getBillInfo() {
        return new FaDispatchBillInfo();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return FaDispatchBillFactory.getRemoteInstance();
    }

    @Override
    protected String getEditUIName() {
        return FaDispatchBillEditUI.class.getName();
    }

    @Override
    protected boolean isShowCardFilter() {
        return false;
    }

    @Override
    protected boolean initDefaultFilter() {
        if (this.getUIContext().get("TRACE_UP_DOWN") != null) {
            this.setIsNeedDefaultFilter(false);
            return false;
        }
        return true;
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        if (FaClientUtils.isFromWorkflow(this.getUIContext())) {
            this.btnTraceDown.setEnabled(false);
            this.actionTraceDown.setEnabled(false);
        }
        this.btnVoucher.setVisible(false);
        this.btnDelVoucher.setVisible(false);
        this.menuItemVoucher.setVisible(false);
        this.menuItemDelVoucher.setVisible(false);
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog == null) {
            try {
                this.checkBeforeOnload();
                this.dialog = super.initCommonQueryDialog();
                this.dialog.setHeight(330);
                this.dialog.setWidth(540);
                FaDispatchCustomerQueryUI customerQueryUI = new FaDispatchCustomerQueryUI();
                this.dialog.addUserPanel((KDPanel)customerQueryUI);
                this.dialog.setShowFilter(true);
                this.dialog.setShowSorter(true);
                this.dialog.setShowToolbar(true);
                FACommonProcessor processor = new FACommonProcessor();
                processor.set("parentDialog", this.dialog);
                this.dialog.setProcessor((IProcessor)processor);
                MetaDataAccessLoader.Description customQueryLoader = new MetaDataAccessLoader.Description(new String[]{"com.kingdee.eas.fi.fa.def.app.FaDynQueryLoader"});
                customQueryLoader.setParam("fullJoinEntityName", (Object)"faBizCard");
                customQueryLoader.setParam("companyId", (Object)this.getCurCompany().getId().toString());
                this.dialog.setCustomQueryLoader(customQueryLoader);
                String strTitle = EASResource.getString((String)FADISPATCH_RESOURCE, (String)"FaDispatch");
                String strFilter = EASResource.getString((String)FADISPATCH_RESOURCE, (String)"SpecialSearch");
                this.dialog.setTitle(strTitle + " - " + strFilter);
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        }
        return this.dialog;
    }

    @Override
    protected String[] getMergeColumns() {
        String[] mergeColumns = new String[]{"number", "dispatchDate", "dispatchCause", "dispatchMethod.name", "inCompany.name", "outCompany.name", "outPrincipal.name", "inPrincipal.name", "dispatchAmount", "description", "effectedStatus", "deletedStatus", CHECKED_STATUS, "hasAffirmed"};
        return mergeColumns;
    }

    @Override
    protected String[] getFormatColumns() {
        String[] mergeColumns = new String[]{"dispatchAmount", "FaDispatchBillEntry.assetValue", "FaDispatchBillEntry.neatValue", "billEntry.evaluateValue", "FaDispatchBillEntry.accuDepr"};
        return mergeColumns;
    }

    @Override
    protected String[] getAssetAmtColumns() {
        return new String[]{"FaDispatchBillEntry.quantity"};
    }

    @Override
    public void actionAffirm_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(this.getCurCompany().getId().toString());
        this.checkSelected();
        if (MsgBox.isOk((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)FADISPATCH_RESOURCE, (String)"FaDispatchBillListUI_BillAffirm")))) {
            IFaDispatchBill iFadispatchbill = FaDispatchBillFactory.getRemoteInstance();
            ArrayList billids = this.getSelectedIdValues();
            ArrayList refids = this.getRefBillIds(billids);
            ArrayList allmutexIds = new ArrayList(billids);
            allmutexIds.addAll(refids);
            StringBuffer idbuff = new StringBuffer();
            FaClientUtils.reqDataMutex((CoreUI)this, allmutexIds, this.getOprtState());
            boolean hasFail = false;
            try {
                int size = billids.size();
                for (int i = 0; i < size; ++i) {
                    iFadispatchbill.affirm((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)((String)billids.get(i)))));
                    idbuff.append("'" + billids.get(i) + "',");
                }
                if (idbuff.length() > 0) {
                    if (this.getUIContext().get("isLightWeight") != null) {
                        MultiAssignmentUI parentFrame = (MultiAssignmentUI)this.getUIContext().get("parentFrame");
                        parentFrame.destroyWindow();
                    }
                    if (SysContext.getSysContext().getCurrentFIUnit() == null || !SysContext.getSysContext().getCurrentFIUnit().isIsBizUnit()) {
                        return;
                    }
                    String currentCompId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
                    for (int i = 0; i < billids.size(); ++i) {
                        ObjectUuidPK sourceBillId = new ObjectUuidPK(BOSUuid.read((String)((String)billids.get(i))));
                        String sourceCompId = FaDispatchBillFactory.getRemoteInstance().getFaDispatchBillInfo((IObjectPK)sourceBillId).getCompany().getId().toString();
                        if (currentCompId.equals(sourceCompId)) continue;
                        return;
                    }
                    FaCurCardCollection newCards = FaCurCardFactory.getRemoteInstance().getFaCurCardCollection("select id where sourceBillId in (" + idbuff.substring(0, idbuff.length() - 1) + ") order by number");
                    RealModeIDList idList = new RealModeIDList();
                    for (int i = 0; i < newCards.size(); ++i) {
                        idList.add(newCards.get(i).getId().toString());
                    }
                    String currentId = newCards.get(0).getId().toString();
                    idList.setCurrentID(currentId);
                    idList.setCount(newCards.size());
                    UIContext uiContext = new UIContext((Object)SwingUtilities.getWindowAncestor((Component)((Object)this)));
                    uiContext.put((Object)"ID", (Object)currentId);
                    uiContext.put((Object)"ObjectUpdateLockId", (Object)currentId);
                    uiContext.put((Object)"IDList", (Object)idList);
                    uiContext.put((Object)"Dispach", (Object)"dispach");
                    IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(FaCurCardEditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
                    uiWindow.show();
                }
            }
            catch (Exception ex) {
                hasFail = true;
                throw ex;
            }
            finally {
                FaClientUtils.releaseDataMutex((CoreUI)this, allmutexIds);
                this.refreshList();
            }
            if (!hasFail) {
                this.setMessageBarText(EASResource.getString((String)FADISPATCH_RESOURCE, (String)"FaDispatchBillListUI_BillAffirmOk"));
            }
        }
    }

    private ArrayList getRefBillIds(ArrayList billids) throws BOSException {
        if (billids == null || billids.size() == 0) {
            return new ArrayList();
        }
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer idbuff = new StringBuffer();
        int size = billids.size();
        for (int i = 0; i < size; ++i) {
            idbuff.append("'" + billids.get(i) + "',");
        }
        FaDispatchBillCollection billinfos = FaDispatchBillFactory.getRemoteInstance().getFaDispatchBillCollection("select refBillUuid where id in (" + idbuff.substring(0, idbuff.length() - 1) + ")");
        for (int i = 0; i < billinfos.size(); ++i) {
            list.add(billinfos.get(i).getRefBillUuid().toString());
        }
        return list;
    }

    @Override
    public void actionUnAffirm_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(this.getCurCompany().getId().toString());
        this.checkSelected();
        if (MsgBox.isOk((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)FADISPATCH_RESOURCE, (String)"FaDispatchBillListUI_BillUnAffirm")))) {
            IFaDispatchBill iDispatchBill = FaDispatchBillFactory.getRemoteInstance();
            ArrayList billids = this.getSelectedIdValues();
            ArrayList allmutexIds = new ArrayList(billids);
            allmutexIds.addAll(this.getRefBillIds(billids));
            FaClientUtils.reqDataMutex((CoreUI)this, allmutexIds, this.getOprtState());
            boolean hasFail = false;
            try {
                int size = billids.size();
                for (int i = 0; i < size; ++i) {
                    FaDispatchBillInfo inBillInfo = iDispatchBill.getFaDispatchBillInfo((IObjectPK)new ObjectUuidPK(billids.get(i).toString()), this.getUnAffirmSelector());
                    FaDispatchBillEntryCollection inBillEnties = inBillInfo.getFaDispatchBillEntry();
                    IEnactmentService service = EnactmentServiceFactory.createRemoteEnactService();
                    if (inBillInfo.getDispatchDirection() == FaDispatchDirectionEnum.OUT) {
                        throw new FaDispatchBillException(FaDispatchBillException.COMPANYNOTMATCH);
                    }
                    if (!inBillInfo.isHasAffirmed()) {
                        throw new FaDispatchBillException(FaDispatchBillException.BILLHASUNCONFIRMED);
                    }
                    for (int j = 0; j < inBillEnties.size(); ++j) {
                        ProcessInstInfo[] procInsts;
                        FaCurCardInfo newCard = inBillEnties.get(j).getNewCard();
                        if (newCard.getCheckedStatus() == CheckedStatusEnum.AUDITED) {
                            throw new FaDispatchBillException(FaDispatchBillException.NEWBILLAUDITED);
                        }
                        if (newCard.getBizStatus() != FaBizStatusEnum.ADDING || (procInsts = service.getProcessInstanceByHoldedObjectId(newCard.getId().toString())).length == 0 || procInsts.length == 1) continue;
                        throw new FaCardException(FaCardException.CANNOT_BE_UNAFFIRM, new Object[]{newCard.getNumber()});
                    }
                    iDispatchBill.unAffirm((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)((String)billids.get(i)))));
                }
            }
            catch (Exception ex) {
                hasFail = true;
                throw ex;
            }
            finally {
                FaClientUtils.releaseDataMutex((CoreUI)this, allmutexIds);
                this.refreshList();
            }
            if (!hasFail) {
                this.setMessageBarText(EASResource.getString((String)FADISPATCH_RESOURCE, (String)"FaDispatchBillListUI_BillUnAffirmOk"));
            }
        }
    }

    private SelectorItemCollection getUnAffirmSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("dispatchDirection"));
        sic.add(new SelectorItemInfo("hasAffirmed"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.newCard.checkedStatus"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.newCard.bizStatus"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.newCard.id"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.newCard.number"));
        return sic;
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IFaDispatchBill iFadispatchBill = FaDispatchBillFactory.getRemoteInstance();
        String id = this.getSelectedKeyValue();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("inCompany.id"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.newCard.id"));
        sic.add(new SelectorItemInfo("faClearBill"));
        sic.add(new SelectorItemInfo("faClearBill.id"));
        sic.add(new SelectorItemInfo(CHECKED_STATUS));
        FaDispatchBillInfo billInfo = iFadispatchBill.getFaDispatchBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        FaDispatchBillEntryCollection billEnties = billInfo.getFaDispatchBillEntry();
        String msgTxt = FaResUtil.getRes((String)"noDestinationBill");
        if (billInfo.getCheckedStatus().getValue() != 2) {
            MsgBox.showInfo((String)msgTxt);
            return;
        }
        HashMap idList = new HashMap();
        Vector<String> v1 = new Vector<String>();
        if (this.getCurCompany().getId().toString().equals(billInfo.getInCompany().getId().toString())) {
            int size = billEnties.size();
            for (int i = 0; i < size; ++i) {
                FaDispatchBillEntryInfo billEntry = billEnties.get(i);
                if (billEntry.getNewCard() == null) {
                    MsgBox.showInfo((String)msgTxt);
                    return;
                }
                String newCardId = billEntry.getNewCard().getId().toString();
                v1.add(newCardId);
            }
            if (v1.size() > 0) {
                idList.put(billEnties.get(0).getNewCard().getBOSType().toString(), v1);
                this.showTraceUI(idList, 0);
            } else {
                MsgBox.showInfo((String)msgTxt);
            }
        } else {
            FaClearBillInfo clearBillInfo = billInfo.getFaClearBill();
            if (clearBillInfo == null) {
                MsgBox.showInfo((String)msgTxt);
                return;
            }
            v1.add(clearBillInfo.getId().toString());
            idList.put(clearBillInfo.getBOSType().toString(), v1);
            this.showTraceUI(idList, 0);
        }
    }

    @Override
    protected EntityViewInfo getInitDefaultSolution() {
        EntityViewInfo initDefaultEntityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        FaClientUtils.checkComp(null, this.getCurCompany());
        filterItems.add(new FilterItemInfo("company.id", (Object)this.getCurCompany().getId().toString()));
        filterItems.add(new FilterItemInfo("dispatchDirection", (Object)new Integer(1)));
        initDefaultEntityViewInfo.setFilter(filterInfo);
        return initDefaultEntityViewInfo;
    }

    @Override
    public void actionAffirmInEdit_actionPerformed(ActionEvent e) throws Exception {
        this.actionAffirm_actionPerformed(e);
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent arg0) {
                try {
                    FaDispatchBillListUI.this.selectOneLine();
                }
                catch (Exception e) {
                    FaDispatchBillListUI.this.handUIException(e);
                }
            }
        });
    }

    public void selectOneLine() throws Exception {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return;
            }
            ICell cell = row.getCell(CHECKED_STATUS);
            if (cell != null) {
                BizEnumValueInfo aBizEnumValueInfo;
                ICell statusCell = row.getCell("effectedStatus");
                if (statusCell != null && statusCell.getValue() != null && statusCell.getValue() instanceof BizEnumValueInfo && (aBizEnumValueInfo = (BizEnumValueInfo)statusCell.getValue()).getValue().equals(String.valueOf(1))) {
                    this.actionAudit.setEnabled(false);
                    this.actionUnAudit.setEnabled(false);
                    this.btnAudit.setEnabled(false);
                    this.btnUnAudit.setEnabled(false);
                    return;
                }
                Object keyValue = cell.getValue();
                if (keyValue != null && keyValue instanceof BizEnumValueInfo) {
                    if (((BizEnumValueInfo)keyValue).getValue().toString().equals("2")) {
                        this.actionAudit.setEnabled(false);
                        this.actionUnAudit.setEnabled(true);
                        this.btnAudit.setEnabled(false);
                        this.btnUnAudit.setEnabled(true);
                    } else {
                        this.actionAudit.setEnabled(true);
                        this.actionUnAudit.setEnabled(false);
                        this.btnAudit.setEnabled(true);
                        this.btnUnAudit.setEnabled(false);
                    }
                }
            }
        }
    }

    @Override
    public void actionDisPatchCardItem_actionPerformed(ActionEvent e) throws Exception {
        super.actionDisPatchCardItem_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow window = null;
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        window = uiFactory.create(FaDispatchCardItemUI.class.getName(), (Map)uiContext, null, "");
        window.show();
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(this.getCurCompany().getId().toString());
        if (this.getSelectedIdValues().size() > 0) {
            int selectIdValuesSize = this.getSelectedIdValues().size();
            for (int i = 0; i < selectIdValuesSize; ++i) {
                try {
                    String pk = this.getSelectedIdValues().get(i).toString();
                    this.setOprtState("REMOVE");
                    this.pubFireVOChangeListener(pk);
                    continue;
                }
                catch (Throwable ex) {
                    this.handUIException(ex);
                    this.abort();
                }
            }
        }
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void actionViewImage_actionPerformed(ActionEvent e) throws Exception {
        ArrayList ids = this.getSelectedIdValues();
        HashSet idset = new HashSet(ids);
        if (ids != null && ids.size() > 0) {
            try {
                String navUrl = FaCardUtil.getCardImageUrl(idset, SysContext.getSysContext().getCurrentUserInfo());
                if (navUrl != null) {
                    VersionUtil.gotoSite((String)navUrl, (boolean)true);
                }
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(this.getCurCompany().getId().toString());
        super.actionAddNew_actionPerformed(e);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(this.getCurCompany().getId().toString());
        super.actionAudit_actionPerformed(e);
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(this.getCurCompany().getId().toString());
        super.actionUnAudit_actionPerformed(e);
    }
}

