/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.fa.basedata.EvaItemEnum;
import com.kingdee.eas.fi.fa.manage.FaEvaImpSchemeCollection;
import com.kingdee.eas.fi.fa.manage.FaEvaImpSchemeEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaEvaImpSchemeEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaEvaImpSchemeFactory;
import com.kingdee.eas.fi.fa.manage.FaEvaImpSchemeInfo;
import com.kingdee.eas.fi.fa.manage.IFaEvaImpScheme;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaEvaValueImportUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.manage.client.FaEvaValueImpPromptUI;
import com.kingdee.eas.fi.fa.manage.client.FaEvaluateBillEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import jxl.Cell;
import jxl.NumberCell;
import jxl.Sheet;
import jxl.Workbook;

public class FaEvaValueImportUI
extends AbstractFaEvaValueImportUI {
    private static final String RESOURCE_PATH = "com.kingdee.eas.fi.fa.manage.FaEvaluateResource";
    private String solutionName;
    private List evaItems;
    private IFaEvaImpScheme iEvaImpScheme;
    private String cuId;
    private KDFileChooser chooser;
    private static final BigDecimal ZERO = new BigDecimal("0");

    public FaEvaValueImportUI() throws Exception {
        this.kdtScheme.checkParsed();
        this.iEvaImpScheme = FaEvaImpSchemeFactory.getRemoteInstance();
        this.cuId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        this.evaItems = new ArrayList();
        this.evaItems.add(EASResource.getString((String)RESOURCE_PATH, (String)"IMPORT_EVAITEM_ASSET"));
        this.evaItems.add(EASResource.getString((String)RESOURCE_PATH, (String)"IMPORT_EVAITEM_ODDLEFTLIFE"));
        this.chooser = new KDFileChooser();
        this.chooser.setFileFilter((FileFilter)new ExcelFileFilter());
        this.chooser.setAcceptAllFileFilterUsed(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initColumnModel();
        this.kdList.addListSelectionListener((ListSelectionListener)new EvaSchemeChangeListener());
        this.refreshList();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSaveAs.setIcon(EASResource.getIcon((String)"imgTbtn_saveas"));
        this.btnDel.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnOpenFile.setIcon(EASResource.getIcon((String)"imgTbtn_open"));
        this.contScheme.removeButton((JButton)this.btnInsertLine);
        this.contScheme.removeButton((JButton)this.btnRemoveLine);
        this.contScheme.addButton((JButton)this.btnInsertLine);
        this.contScheme.addButton((JButton)this.btnRemoveLine);
        this.actionAddNew.setEnabled(true);
        this.actionSave.setEnabled(true);
        this.actionSaveAs.setEnabled(true);
        this.actionDel.setEnabled(true);
        this.actionConfirm.setEnabled(true);
        this.actionCancel.setEnabled(true);
        this.actionInsertLine.setEnabled(true);
        this.actionRemoveLine.setEnabled(true);
        this.actionFileOpen.setEnabled(true);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setVisible(false);
        FaEvaluateBillEditUI owner = (FaEvaluateBillEditUI)((Object)this.getUIContext().get("Owner"));
        owner.setImpValue(new HashMap());
        this.disposeUIWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        String path = this.txtFilePath.getText();
        if (path == null || path.trim().length() == 0) {
            this.txtFilePath.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"SELECT_FILE_FIRST"));
            return;
        }
        if (!new File(path).exists()) {
            this.txtFilePath.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"FILE_NOT_FOUND"));
            return;
        }
        this.verfyBeforeStore();
        FaEvaluateBillEditUI owner = (FaEvaluateBillEditUI)((Object)this.getUIContext().get("Owner"));
        HashMap<String, BigDecimal> impValue = new HashMap<String, BigDecimal>();
        boolean isFail = false;
        try (Workbook book = null;){
            book = Workbook.getWorkbook((File)new File(path));
            if (book.getSheets().length == 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"FILE_HAS_NO_CONTENT"));
                book.close();
                return;
            }
            Sheet sheet = book.getSheets()[0];
            int size = this.kdtScheme.getRowCount();
            block10: for (int i = 0; i < size && !isFail; ++i) {
                IRow row = this.kdtScheme.getRow(i);
                int beginLine = ((BigDecimal)row.getCell("beginLine").getValue()).intValue();
                int endLine = ((BigDecimal)row.getCell("endLine").getValue()).intValue();
                int assetIdx = ((BigDecimal)row.getCell("assetIdx").getValue()).intValue();
                int evaValueIdx = ((BigDecimal)row.getCell("evaValueIdx").getValue()).intValue();
                EvaItemEnum evaItemEnum = null;
                if (row.getCell("evaItem").getValue().toString().equals(this.evaItems.get(0))) {
                    evaItemEnum = EvaItemEnum.ASSETVALUE;
                } else if (row.getCell("evaItem").getValue().toString().equals(this.evaItems.get(1))) {
                    evaItemEnum = EvaItemEnum.ODDUSELIFE;
                }
                if (sheet.getRows() < endLine) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"MAX_LINE_REACHED"));
                    isFail = true;
                    break;
                }
                for (int j = beginLine; j <= endLine && !isFail; ++j) {
                    Cell[] cells = sheet.getRow(j - 1);
                    String isEmptyEvaValue = EASResource.getString((String)RESOURCE_PATH, (String)"IMPORT_AMOUNT_IS_NULL");
                    if (cells.length == 0) {
                        MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)RESOURCE_PATH, (String)"EMPTY_LINE"), j));
                        isFail = true;
                        continue block10;
                    }
                    if (cells.length < assetIdx) {
                        MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(isEmptyEvaValue, j, assetIdx));
                        isFail = true;
                        continue block10;
                    }
                    if (cells.length < evaValueIdx) {
                        MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(isEmptyEvaValue, j, evaValueIdx));
                        isFail = true;
                        continue block10;
                    }
                    String assetNum = cells[assetIdx - 1].getContents();
                    String assetValue = null;
                    Cell cell = cells[evaValueIdx - 1];
                    assetValue = cell instanceof NumberCell ? String.valueOf(((NumberCell)cell).getValue()) : cell.getContents().trim();
                    if (assetNum == null || assetNum.length() == 0 || assetValue == null || assetValue.length() == 0) {
                        MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(isEmptyEvaValue, j, evaValueIdx));
                        isFail = true;
                        continue block10;
                    }
                    try {
                        BigDecimal result = new BigDecimal(assetValue);
                        if (result.compareTo(ZERO) < 0) {
                            MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)RESOURCE_PATH, (String)"NEGATIVE_VALUE_NOT_ALLOW"), isEmptyEvaValue, evaValueIdx));
                            isFail = true;
                            continue block10;
                        }
                        impValue.put(assetNum + evaItemEnum, result);
                        continue;
                    }
                    catch (NumberFormatException e1) {
                        MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)RESOURCE_PATH, (String)"IMPORT_AMOUNT_ILLEGAL"), isEmptyEvaValue, evaValueIdx));
                        isFail = true;
                        continue block10;
                    }
                }
            }
        }
        if (!isFail) {
            owner.setImpValue(impValue);
            this.disposeUIWindow();
        }
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.openSaveWin();
        if (this.solutionName != null && this.solutionName.length() > 0) {
            FaEvaImpSchemeInfo info = new FaEvaImpSchemeInfo();
            info.setName(this.solutionName);
            info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
            this.iEvaImpScheme.addnew((CoreBaseInfo)info);
            this.refreshList();
        }
    }

    @Override
    public void actionDel_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdList.getSelectedIndex() == -1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"SELECT_IMPORT_SCHEME_FIRST"));
            return;
        }
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")))) {
            String filterString;
            this.solutionName = (String)this.kdList.getSelectedValue();
            if (this.solutionName != null && this.iEvaImpScheme.exists(filterString = "where name ='" + this.solutionName + "' and CU.id ='" + this.cuId + "'")) {
                this.iEvaImpScheme.delete(filterString);
            }
            this.refreshList();
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdList.getSelectedIndex() == -1) {
            this.actionSaveAs_actionPerformed(null);
            return;
        }
        this.saveDetail();
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"SAVE_SUCCESS"));
    }

    @Override
    public void actionSaveAs_actionPerformed(ActionEvent e) throws Exception {
        this.openSaveWin();
        if (this.solutionName != null && this.solutionName.length() > 0) {
            String filterString = "where name ='" + this.solutionName + "' and CU.id ='" + this.cuId + "'";
            if (this.iEvaImpScheme.exists(filterString)) {
                this.iEvaImpScheme.delete(filterString);
            }
            FaEvaImpSchemeInfo info = new FaEvaImpSchemeInfo();
            info.setName(this.solutionName);
            info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
            this.iEvaImpScheme.addnew((CoreBaseInfo)info);
            this.saveDetail();
            this.refreshList();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"SAVE_SUCCESS"));
        }
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtScheme.getRowCount() >= this.evaItems.size()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"IMPORT_INVALID_ENTRY_SIZE"));
            return;
        }
        IRow row = this.kdtScheme.addRow();
        int count = this.kdtScheme.getRowCount();
        row.getCell("seq").setValue((Object)new BigDecimal(count));
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectManager selectManager = this.kdtScheme.getSelectManager();
        if (selectManager != null) {
            int i;
            if (selectManager.size() == 0) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
                return;
            }
            KDTSelectBlock block = selectManager.get();
            int endRow = block.getEndRow();
            int beginRow = block.getBeginRow();
            for (i = endRow; i >= beginRow; --i) {
                this.kdtScheme.removeRow(i);
            }
            int size = this.kdtScheme.getRowCount();
            for (i = 0; i < size; ++i) {
                this.kdtScheme.getRow(i).getCell("seq").setValue((Object)new BigDecimal(i + 1));
            }
        }
    }

    @Override
    public void actionFileOpen_actionPerformed(ActionEvent e) throws Exception {
        int rVal = this.chooser.showOpenDialog((Component)((Object)this));
        if (rVal == 0) {
            this.txtFilePath.setText(this.chooser.getSelectedFile().toString());
        }
    }

    public void setSolutionName(String solutionName) {
        this.solutionName = solutionName;
    }

    private void initColumnModel() throws Exception {
        Object[] columns = new IColumn[]{this.kdtScheme.getColumn("seq"), this.kdtScheme.getColumn("beginLine"), this.kdtScheme.getColumn("endLine"), this.kdtScheme.getColumn("assetIdx"), this.kdtScheme.getColumn("evaValueIdx")};
        this.kdtScheme.getColumn("seq").getStyleAttributes().setLocked(true);
        FaClientUtils.setComponentPrecision(columns, 0);
        Vector evaItemList = new Vector();
        int size = this.evaItems.size();
        for (int i = 0; i < size; ++i) {
            evaItemList.add(this.evaItems.get(i));
        }
        KDComboBox evaItemCombo = new KDComboBox();
        evaItemCombo.setModel(new DefaultComboBoxModel(evaItemList));
        this.kdtScheme.getColumn("evaItem").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)evaItemCombo));
    }

    private void refreshList() throws BOSException {
        FaEvaImpSchemeCollection schemes = this.iEvaImpScheme.getFaEvaImpSchemeCollection("select name where CU.id ='" + this.cuId + "'");
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        int size = schemes.size();
        for (int i = 0; i < size; ++i) {
            listModel.addElement(schemes.get(i).getName());
        }
        this.kdList.setModel(listModel);
        if (this.kdList.getModel().getSize() > 0) {
            this.kdList.setSelectedIndex(0);
        } else {
            this.solutionName = null;
        }
    }

    private void openSaveWin() throws BOSException, EASBizException {
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        IUIWindow window = uiFactory.create(FaEvaValueImpPromptUI.class.getName(), (Map)uiContext, null, "");
        window.show();
    }

    private void saveDetail() throws EASBizException, BOSException {
        this.verfyBeforeStore();
        FaEvaImpSchemeInfo info = this.iEvaImpScheme.getFaEvaImpSchemeInfo("where name='" + this.solutionName + "' and CU.id='" + this.cuId + "'");
        FaEvaImpSchemeEntryCollection iec = new FaEvaImpSchemeEntryCollection();
        int size = this.kdtScheme.getRowCount();
        for (int i = 0; i < size; ++i) {
            FaEvaImpSchemeEntryInfo entry = new FaEvaImpSchemeEntryInfo();
            IRow row = this.kdtScheme.getRow(i);
            entry.setSeq(((BigDecimal)row.getCell("seq").getValue()).intValue());
            entry.setBeginLine(((BigDecimal)row.getCell("beginLine").getValue()).intValue());
            entry.setEndLine(((BigDecimal)row.getCell("endLine").getValue()).intValue());
            entry.setAssetIdx(((BigDecimal)row.getCell("assetIdx").getValue()).intValue());
            entry.setEvaValueIdx(((BigDecimal)row.getCell("evaValueIdx").getValue()).intValue());
            if (row.getCell("evaItem").getValue().toString().equals(this.evaItems.get(0))) {
                entry.setEvaItem(EvaItemEnum.ASSETVALUE);
            } else if (row.getCell("evaItem").getValue().toString().equals(this.evaItems.get(1))) {
                entry.setEvaItem(EvaItemEnum.ODDUSELIFE);
            }
            iec.add(entry);
        }
        info.put("entry", (Object)iec);
        this.iEvaImpScheme.update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
    }

    private void verfyBeforeStore() {
        ArrayList<String> evaItemList = new ArrayList<String>();
        int size = this.kdtScheme.getRowCount();
        for (int i = 0; i < size; ++i) {
            String evaItem;
            IRow row = this.kdtScheme.getRow(i);
            int size2 = this.kdtScheme.getColumnCount();
            for (int j = 0; j < size2; ++j) {
                if (row.getCell(j).getValue() != null && row.getCell(j).getValue().toString().length() != 0) continue;
                MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)RESOURCE_PATH, (String)"IMPORT_AMOUNT_IS_NULL"), i + 1, j + 1));
                SysUtil.abort();
            }
            if (((BigDecimal)this.kdtScheme.getRow(i).getCell("beginLine").getValue()).compareTo((BigDecimal)this.kdtScheme.getRow(i).getCell("endLine").getValue()) > 0) {
                MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)RESOURCE_PATH, (String)"IMPORT_TABLE_BEGIN_END_INVALID"), i + 1));
                SysUtil.abort();
            }
            if (evaItemList.contains(evaItem = (String)this.kdtScheme.getRow(i).getCell("evaItem").getValue())) {
                MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)RESOURCE_PATH, (String)"TARGET_EVA_ITEM_DUPLICATED"), evaItem));
                SysUtil.abort();
            }
            evaItemList.add(evaItem);
        }
    }

    private static class ExcelFileFilter
    extends FileFilter {
        private ExcelFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String ext = f.getName();
            ext = ext.lastIndexOf(".") > 0 ? ext.substring(ext.lastIndexOf(".") + 1, ext.length()) : null;
            if (ext != null) {
                return (ext = ext.toLowerCase()).equalsIgnoreCase("xls");
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "Microsoft Office Excel (*.xls)";
        }
    }

    private class EvaSchemeChangeListener
    implements ListSelectionListener {
        private EvaSchemeChangeListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            try {
                KDList list = (KDList)e.getSource();
                if (list.getComponentCount() == 0 || list.getSelectedIndex() == -1) {
                    return;
                }
                FaEvaValueImportUI.this.solutionName = (String)list.getSelectedValue();
                FaEvaImpSchemeInfo info = FaEvaValueImportUI.this.iEvaImpScheme.getFaEvaImpSchemeInfo("select *,entry.* where name = '" + FaEvaValueImportUI.this.solutionName + "' and CU.id ='" + FaEvaValueImportUI.this.cuId + "'");
                FaEvaImpSchemeEntryCollection entries = info.getEntry();
                FaEvaValueImportUI.this.kdtScheme.removeRows();
                int size = entries.size();
                for (int i = 0; i < size; ++i) {
                    FaEvaImpSchemeEntryInfo entry = entries.get(i);
                    IRow row = FaEvaValueImportUI.this.kdtScheme.addRow();
                    row.getCell("seq").setValue((Object)new BigDecimal(entry.getSeq()));
                    row.getCell("beginLine").setValue((Object)new BigDecimal(entry.getBeginLine()));
                    row.getCell("endLine").setValue((Object)new BigDecimal(entry.getEndLine()));
                    row.getCell("assetIdx").setValue((Object)new BigDecimal(entry.getAssetIdx()));
                    row.getCell("evaValueIdx").setValue((Object)new BigDecimal(entry.getEvaValueIdx()));
                    if (entry.getEvaItem() == EvaItemEnum.ASSETVALUE) {
                        row.getCell("evaItem").setValue(FaEvaValueImportUI.this.evaItems.get(0));
                        continue;
                    }
                    if (entry.getEvaItem() != EvaItemEnum.ODDUSELIFE) continue;
                    row.getCell("evaItem").setValue(FaEvaValueImportUI.this.evaItems.get(1));
                }
            }
            catch (Exception e1) {
                FaEvaValueImportUI.this.handleException(e1);
                SysUtil.abort();
            }
        }
    }
}

