/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewAdminF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.fa.basedata.AbstractEvaItemInfo;
import com.kingdee.eas.fi.fa.basedata.EvaItemEnum;
import com.kingdee.eas.fi.fa.basedata.FAEvaluateModeFactory;
import com.kingdee.eas.fi.fa.basedata.FAEvaluateModeInfo;
import com.kingdee.eas.fi.fa.basedata.FaEvaItemDetailInfo;
import com.kingdee.eas.fi.fa.basedata.FaEvaSchemeInfo;
import com.kingdee.eas.fi.fa.basedata.FaUtils;
import com.kingdee.eas.fi.fa.def.FaDefPropertyValueInfo;
import com.kingdee.eas.fi.fa.def.meta.FaDefEntityManager;
import com.kingdee.eas.fi.fa.manage.FaBizCardInfo;
import com.kingdee.eas.fi.fa.manage.FaChangeBillInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaEvaValueCollection;
import com.kingdee.eas.fi.fa.manage.FaEvaValueFactory;
import com.kingdee.eas.fi.fa.manage.FaEvaValueInfo;
import com.kingdee.eas.fi.fa.manage.FaEvaluateBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaEvaluateBillEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaEvaluateBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaEvaluateBillFactory;
import com.kingdee.eas.fi.fa.manage.FaEvaluateBillInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.IFaEvaValue;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaEvaluateBillEditUI;
import com.kingdee.eas.fi.fa.manage.client.CommonQueryWithResultDialog;
import com.kingdee.eas.fi.fa.manage.client.FaCardFilterAdapter;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.manage.client.FaPrintHelper;
import com.kingdee.eas.fi.fa.manage.client.FaSpinnerChangeListener;
import com.kingdee.eas.framework.BillBaseCollection;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeListener;

public class FaEvaluateBillEditUI
extends AbstractFaEvaluateBillEditUI {
    private static final long serialVersionUID = 1L;
    private static final String RESOURCE_PATH = "com.kingdee.eas.fi.fa.manage.FaEvaluateResource";
    private FaEvaSchemeInfo evaSchemeInfo;
    private List evaItems = new ArrayList();
    private Map evaValues = new HashMap();
    private Map evaColumnMap = new HashMap();
    private boolean isCatLimited = false;
    private boolean isModify = false;
    private boolean isFinishLoad = false;
    private static final BigDecimal ZERO = new BigDecimal("0");
    private int cardSelectedStatus = -1;
    private Map impValue = new HashMap();
    private PeriodInfo period;
    HashMap workloadSchemes = FaUtils.getUserDepreciationMode(null, (boolean)true);
    protected static final String FROM_LINK = "Link";
    private boolean initDefPropertyBind = false;

    public FaEvaluateBillEditUI() throws Exception {
        this.detailTable.checkParsed();
        this.kdtFaEvaluateDoc.checkParsed();
    }

    @Override
    public void loadFields() {
        this.bindDefProperty();
        super.loadFields();
        boolean isNew = this.editData == null || this.editData.getId() == null;
        this.actionCopy.setEnabled(!isNew);
        this.btnCopy.setEnabled(!isNew);
        int size = this.detailTable.getColumnCount();
        for (int i = 0; i < size; ++i) {
            this.detailTable.getColumn(i).getStyleAttributes().setLocked(true);
        }
        boolean isViewStatus = "VIEW".equals(this.oprtState) || "FINDVIEW".equals(this.oprtState);
        this.lockUnlockDocTable(isViewStatus);
        if (this.editData != null) {
            for (String key : this.evaColumnMap.keySet()) {
                if (!key.endsWith("00")) continue;
                this.detailTable.getColumn(((Integer)this.evaColumnMap.get(key)).intValue()).getStyleAttributes().setLocked(isViewStatus);
            }
            this.detailTable.getColumn("faEvaluateBillEntry.description").getStyleAttributes().setLocked(isViewStatus);
        }
        this.actionEntryAdd.setEnabled(!isViewStatus);
        this.actionEntryDel.setEnabled(!isViewStatus);
        this.actionImportEvaValue.setEnabled(!isViewStatus);
    }

    private void lockUnlockDocTable(boolean lock) {
        int size = this.kdtFaEvaluateDoc.getColumnCount();
        for (int i = 0; i < size; ++i) {
            this.kdtFaEvaluateDoc.getColumn(i).getStyleAttributes().setLocked(lock);
        }
        this.actionDocAdd.setEnabled(!lock);
        this.actionDocDel.setEnabled(!lock);
    }

    @Override
    public void storeFields() {
        int colCount = this.kdtFaEvaluateDoc.getColumnCount();
        for (int i = this.kdtFaEvaluateDoc.getRowCount(); i > 0; --i) {
            boolean isEmptyEntry = true;
            for (int j = 0; j < colCount; ++j) {
                if (this.kdtFaEvaluateDoc.getColumn(j).getFieldName().equals("id")) continue;
                Object value = this.kdtFaEvaluateDoc.getRow(i - 1).getCell(j).getValue();
                isEmptyEntry = isEmptyEntry && (value == null || value.toString().trim().length() == 0);
            }
            if (!isEmptyEntry) continue;
            this.kdtFaEvaluateDoc.removeRow(i - 1);
        }
        super.storeFields();
    }

    @Override
    protected IObjectValue createNewDetailData(KDTable arg0) {
        return new FaEvaluateBillEntryInfo();
    }

    @Override
    protected KDTable getDetailTable() {
        return this.detailTable;
    }

    @Override
    protected IObjectValue createNewData() {
        FaEvaluateBillInfo billInfo = new FaEvaluateBillInfo();
        try {
            Date today = DateTimeUtils.truncateDate((Date)new Date());
            billInfo.setBeginDate(today);
            billInfo.setEndDate(today);
            billInfo.setBenchmarkDate(today);
            billInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            billInfo.setValidityYear(new BigDecimal("1"));
            billInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
            AdminOrgUnitInfo unitInfo = SysContext.getSysContext().getCurrentAdminUnit();
            if (unitInfo != null && unitInfo.getId() != null) {
                unitInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(unitInfo.getId()));
                billInfo.setOwnerCompany(unitInfo);
            }
            if (this.period == null) {
                this.period = FaClientUtils.getFACurrentPeriod(this.getCurCompany());
            }
            if (DateTimeUtils.truncateDate((Date)this.period.getBeginDate()).after(today)) {
                billInfo.setAdjustDate(DateTimeUtils.truncateDate((Date)this.period.getBeginDate()));
            } else if (DateTimeUtils.truncateDate((Date)this.period.getEndDate()).before(today)) {
                billInfo.setAdjustDate(DateTimeUtils.truncateDate((Date)this.period.getEndDate()));
            } else {
                billInfo.setAdjustDate(today);
            }
            return billInfo;
        }
        catch (Exception e) {
            this.handleException(e);
            return billInfo;
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return FaEvaluateBillFactory.getRemoteInstance();
    }

    @Override
    public void onLoad() throws Exception {
        if (this.getUIContext().get(FROM_LINK) != null && this.getUIContext().get(FROM_LINK).equals(Boolean.TRUE)) {
            this.menuBar.removeAll();
            this.menuBar.setVisible(false);
            this.toolBar.removeAll();
            this.toolBar.add((Component)new KDLabel());
        }
        super.onLoad();
        this.period = FaClientUtils.getFACurrentPeriod(this.getCurCompany());
        this.menuItemAudit.setAccelerator(KeyStroke.getKeyStroke("ctrl U"));
        this.menuItemUnAudit.setAccelerator(KeyStroke.getKeyStroke("ctrl shift U"));
        FaClientUtils.changeTextField((JComponent)((Object)this), true, false);
        FaManageUtils.freezeTable((KDTable)this.getDetailTable(), (int)3);
        FaManageUtils.freezeTable((KDTable)this.kdtFaEvaluateDoc, (int)2);
        this.bindDefProperty();
        this.chkMenuItemSubmitAndPrint.setVisible(false);
    }

    private void bindDefProperty() {
        if (!this.initDefPropertyBind) {
            try {
                FaDefEntityManager.bindDefProperty((String)"faEvaluateBillEntry.faBizCard.", (KDTable)this.detailTable, (String)this.resHelper.getString("detailTable.formatXml"), (DataBinder)this.dataBinder);
                this.initDefPropertyBind = true;
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.pnlEntry.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 991, 376));
        this.pnlDoc.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 991, 376));
    }

    @Override
    protected String getEntryKeyName() {
        return "faEvaluateBillEntry.id";
    }

    @Override
    public void actionDocAdd_actionPerformed(ActionEvent e) throws Exception {
        this.kdtFaEvaluateDoc.addRow();
    }

    @Override
    public void actionDocDel_actionPerformed(ActionEvent e) throws Exception {
        this.removeLine(this.kdtFaEvaluateDoc);
    }

    @Override
    public void actionEntryAdd_actionPerformed(ActionEvent e) throws Exception {
        if (this.evaSchemeInfo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"SELECT_SCHEME_FIRST"));
            this.prmtEvaluateScheme.requestFocus();
            return;
        }
        CommonQueryWithResultDialog dialog = this.initCardSelectDialog();
        FaEvaCardFilterProcessor processor = (FaEvaCardFilterProcessor)dialog.getCardFilterProcessor();
        processor.setCatLimited(this.isCatLimited);
        if (this.isCatLimited && this.detailTable.getRowCount() > 0) {
            processor.setCatNumber((String)this.detailTable.getRow(0).getCell("cardCat.number").getValue());
        }
        if (dialog.show() || dialog.hasKeyValue()) {
            this.processCardSelected(dialog.getSelectedCards());
        }
    }

    @Override
    protected CommonQueryWithResultDialog initCardSelectDialog() throws Exception {
        FaEvaCardFilterProcessor processor = new FaEvaCardFilterProcessor();
        CommonQueryWithResultDialog commonDialog = super.initCardSelectDialog();
        commonDialog.setCardFilterProcessor(processor);
        commonDialog.setSelectMode(10);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hasEvaled", (Object)false));
        processor.setFilterInfo(filter);
        return commonDialog;
    }

    @Override
    public void actionEntryDel_actionPerformed(ActionEvent e) throws Exception {
        this.removeLine(this.detailTable);
        this.isModify = true;
    }

    @Override
    public void actionImportEvaValue_actionPerformed(ActionEvent e) throws Exception {
        if (this.detailTable.getRowCount() == 0) {
            this.btnEntryAdd.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"SELECT_CARD_BEFORE_IMPORT"));
            return;
        }
        if (this.evaSchemeInfo == null) {
            this.prmtEvaluateScheme.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"SELECT_EVA_SCHEME_FIRST"));
            return;
        }
        this.initDataImportDialog();
        if (this.impValue.size() > 0 && this.detailTable.getRowCount() > 0) {
            int size = this.detailTable.getRowCount();
            for (int i = 0; i < size; ++i) {
                IRow row = this.detailTable.getRow(i);
                int size2 = this.evaItems.size();
                for (int j = 0; j < size2; ++j) {
                    AbstractEvaItemInfo item = (AbstractEvaItemInfo)this.evaItems.get(j);
                    String key = "" + row.getCell("cardNumber").getValue() + item;
                    if (!this.impValue.containsKey(key)) continue;
                    Integer evaValueIdx = (Integer)this.evaColumnMap.get(item.getEnum().getValue() + "|" + "00");
                    row.getCell(evaValueIdx.intValue()).setValue(this.impValue.get(key));
                }
            }
            this.impValue.clear();
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        this.updateEvaAfterAction();
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.updateEvaAfterAction();
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(this.getCurCompany().getId().toString());
        super.actionAddNew_actionPerformed(e);
        this.updateEvaAfterAction();
    }

    @Override
    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.updateEvaAfterAction();
    }

    @Override
    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.updateEvaAfterAction();
    }

    @Override
    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.updateEvaAfterAction();
    }

    @Override
    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.updateEvaAfterAction();
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        int colIndex;
        Iterator iter;
        int i;
        FaClientUtils.checkAdjustmentPeriod(this.getCurCompany().getId().toString());
        int entryCnt = this.detailTable.getRowCount();
        HashMap<String, Object> oldEvaValue = new HashMap<String, Object>();
        for (i = 0; i < entryCnt; ++i) {
            iter = this.evaColumnMap.keySet().iterator();
            while (iter.hasNext()) {
                colIndex = (Integer)this.evaColumnMap.get(iter.next());
                oldEvaValue.put("" + i + "+" + colIndex, this.detailTable.getRow(i).getCell(colIndex).getValue());
            }
        }
        super.actionCopy_actionPerformed(e);
        for (i = entryCnt; i > 0; --i) {
            this.detailTable.getRow(i - 1).getCell("faEvaluateBillEntry.bizCard.id").setValue(null);
        }
        this.txtNumber.setText(this.editData.getNumber());
        this.prmtAuditor.setData(null);
        this.prmtCreator.setData(null);
        this.pkAuditTime.setValue(null);
        this.editData.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        this.schemeChanged(null);
        this.schemeChanged(this.editData.getEvaluateScheme());
        entryCnt = this.detailTable.getRowCount();
        for (i = 0; i < entryCnt; ++i) {
            iter = this.evaColumnMap.keySet().iterator();
            while (iter.hasNext()) {
                colIndex = (Integer)this.evaColumnMap.get(iter.next());
                this.detailTable.getRow(i).getCell(colIndex).setValue(oldEvaValue.get("" + i + "+" + colIndex));
            }
        }
        this.setEvaEntryCollection(false, this.editData);
        this.storeFields();
        this.actionSave.setEnabled(true);
        this.isModify = false;
        this.actionEntryAdd.setEnabled(true);
        this.actionEntryDel.setEnabled(true);
        this.actionDocAdd.setEnabled(true);
        this.actionDocDel.setEnabled(true);
        this.txtNumber.setText(null);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(this.getCurCompany().getId().toString());
        super.actionAudit_actionPerformed(e);
        for (int i = 0; i < this.detailTable.getRowCount(); ++i) {
            this.fillLineEvaValue(this.detailTable.getRow(i));
        }
        this.actionImportEvaValue.setEnabled(this.editData.getCheckedStatus() != CheckedStatusEnum.AUDITED);
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(this.getCurCompany().getId().toString());
        super.actionUnAudit_actionPerformed(e);
        for (int i = 0; i < this.detailTable.getRowCount(); ++i) {
            this.fillLineEvaValue(this.detailTable.getRow(i));
        }
        this.actionImportEvaValue.setEnabled(this.editData.getCheckedStatus() != CheckedStatusEnum.AUDITED);
    }

    @Override
    protected void verifyBeforeSave(ActionEvent e) throws Exception {
        this.verfyBenchmarkDate(false);
        this.setEvaEntryCollection(false, this.editData);
    }

    @Override
    protected void verifyBeforeSubmit(ActionEvent e) throws Exception {
        Date endDate;
        Date beginDate;
        if (this.prmtEvaluateScheme.getData() == null) {
            this.abort((JComponent)this.prmtEvaluateScheme, EASResource.getString((String)RESOURCE_PATH, (String)"EVA_SCHEME_IS_EMPTY"));
        }
        if (StringUtils.isEmpty((String)this.txtAim.getText())) {
            this.abort((JComponent)this.txtAim, EASResource.getString((String)RESOURCE_PATH, (String)"EVA_AIM_IS_EMPTY"));
        }
        if (this.prmtEvaluateMode.getData() == null) {
            this.abort((JComponent)this.prmtEvaluateMode, EASResource.getString((String)RESOURCE_PATH, (String)"EVA_MODE_IS_EMPTY"));
        }
        if (this.pkBenchmarkDate.getValue() == null) {
            this.abort((JComponent)this.pkBenchmarkDate, EASResource.getString((String)RESOURCE_PATH, (String)"EVA_BASELINE_IS_EMPTY"));
        } else if ("true".equals(this.gethmParam().get("FA_056").toString())) {
            Date baseDate = DateTimeUtils.truncateDate((Date)((Date)this.pkBenchmarkDate.getValue()));
            if (DateTimeUtils.truncateDate((Date)this.period.getBeginDate()).after(baseDate) || DateTimeUtils.truncateDate((Date)this.period.getEndDate()).before(baseDate)) {
                this.abort((JComponent)this.pkBenchmarkDate, EASResource.getString((String)RESOURCE_PATH, (String)"BASELINE_DATE_NOTIN_PERIOD"));
            }
        }
        if (this.pkBeginDate.getValue() == null) {
            this.abort((JComponent)this.pkBeginDate, EASResource.getString((String)RESOURCE_PATH, (String)"EVA_BEGIN_DATE_IS_EMPTY"));
        } else {
            beginDate = DateTimeUtils.truncateDate((Date)((Date)this.pkBeginDate.getValue()));
            if (DateTimeUtils.truncateDate((Date)this.period.getEndDate()).before(beginDate)) {
                this.abort((JComponent)this.pkBeginDate, EASResource.getString((String)RESOURCE_PATH, (String)"BEGIN_DATE_NOTIN_PERIOD"));
            }
        }
        if (this.pkEndDate.getValue() == null) {
            this.abort((JComponent)this.pkEndDate, EASResource.getString((String)RESOURCE_PATH, (String)"EVA_END_DATA_IS_EMPTY"));
        } else {
            Date endDate2 = DateTimeUtils.truncateDate((Date)((Date)this.pkEndDate.getValue()));
            if (DateTimeUtils.truncateDate((Date)this.period.getEndDate()).before(endDate2)) {
                this.abort((JComponent)this.pkEndDate, EASResource.getString((String)RESOURCE_PATH, (String)"END_DATE_NOTIN_PERIOD"));
            }
        }
        if (this.prmtOwnerCompany.getData() == null) {
            this.abort((JComponent)this.prmtOwnerCompany, EASResource.getString((String)RESOURCE_PATH, (String)"EVA_OWNERCOMP_IS_EMPTY"));
        }
        if (this.detailTable.getRowCount() == 0) {
            this.abort((JComponent)this.btnEntryAdd, EASResource.getString((String)RESOURCE_PATH, (String)"SELECT_CARD_FIRST"));
        }
        if ((beginDate = DateTimeUtils.truncateDate((Date)((Date)this.pkBeginDate.getValue()))).after(endDate = DateTimeUtils.truncateDate((Date)((Date)this.pkEndDate.getValue())))) {
            this.abort((JComponent)this.pkBeginDate, EASResource.getString((String)RESOURCE_PATH, (String)"BEGIN_END_DATE_INVALID"));
        }
        if (this.pkAdjustDate.getValue() == null) {
            this.abort((JComponent)this.pkAdjustDate, EASResource.getString((String)RESOURCE_PATH, (String)"ADJUST_DATE_IS_EMPTY"));
        } else {
            Date adjustDate = DateTimeUtils.truncateDate((Date)((Date)this.pkAdjustDate.getValue()));
            if (DateTimeUtils.truncateDate((Date)this.period.getBeginDate()).after(adjustDate) || DateTimeUtils.truncateDate((Date)this.period.getEndDate()).before(adjustDate)) {
                this.abort((JComponent)this.pkAdjustDate, EASResource.getString((String)RESOURCE_PATH, (String)"ADJUST_DATE_NOTIN_PERIOD"));
            }
        }
        if (this.evaSchemeInfo.isChangeCard() || this.evaSchemeInfo.isClearDepreciation()) {
            try {
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                FaChangeBillInfo changeBillInfo = new FaChangeBillInfo();
                changeBillInfo.setCompany(this.editData.getCompany());
                iCodingRuleManager.readNumber((IObjectValue)changeBillInfo, this.editData.getCompany().getId().toString());
            }
            catch (CodingRuleException e1) {
                this.abort((JComponent)this.txtNumber, EASResource.getString((String)RESOURCE_PATH, (String)"NOT_EXIST_CHANGE_BILL_CODINGRULE"));
            }
        }
        this.verfyBenchmarkDate(true);
        this.setEvaEntryCollection(true, this.editData);
    }

    @Override
    protected void initCtrlComponent() throws Exception {
        this.btnEntryAdd.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnEntryDel.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnDocAdd.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDocDel.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnImportEvaValue.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.menuImportEvaValue.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.actionRemove.setEnabled(false);
        this.btnRemove.setVisible(false);
        this.menuItemRemove.setVisible(false);
        this.prmtEvaluateScheme.setEntityViewInfo(new EntityViewInfo("where isEnabled = 1 and company.id = '" + this.getCurCompany().getId() + "'"));
        NewAdminF7 adminF7 = new NewAdminF7((IUIObject)this);
        boolean isOrgRange = "true".equals(this.gethmParam().get("FA_040").toString());
        FaClientUtils.processAdminF7(adminF7, isOrgRange);
        this.prmtOwnerCompany.setSelector((KDPromptSelector)adminF7);
        KDTextField textField = new KDTextField();
        textField.setMaxLength(80);
        this.kdtFaEvaluateDoc.getColumn("documentNumber").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)textField));
        this.kdtFaEvaluateDoc.getColumn("documentName").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)textField));
        this.kdtFaEvaluateDoc.getColumn("handler").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)textField));
        this.kdtFaEvaluateDoc.getColumn("auditor").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)textField));
        this.kdtFaEvaluateDoc.getColumn("keeper").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)textField));
        this.kdtFaEvaluateDoc.getColumn("dept").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)textField));
        textField = new KDTextField();
        textField.setMaxLength(200);
        this.kdtFaEvaluateDoc.getColumn("description").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)textField));
        this.detailTable.getColumn("faEvaluateBillEntry.description").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)textField));
        this.setComponentPrecision(new Object[]{this.kdtFaEvaluateDoc.getColumn("page"), this.kdtFaEvaluateDoc.getColumn("share")}, 0);
        this.MenuItemAttachment.setVisible(true);
        this.MenuItemAttachment.setEnabled(true);
        this.btnAttachment.setVisible(true);
        this.btnAttachment.setEnabled(true);
    }

    public HashMap gethmParam() {
        HashMap hmParam = new HashMap();
        try {
            hmParam = FaManageUtils.getFAParameter(this.getCurrentCompany().getId());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return hmParam;
    }

    private CompanyOrgUnitInfo getCurrentCompany() throws Exception {
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        String companyId = null;
        companyId = FaClientUtils.isFromLink((CoreUIObject)this) ? (String)this.getUIContext().get("COMPANY_ID") : SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("accountPeriodType.id"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("reportCurrency.id"));
        sic.add(new SelectorItemInfo("reportCurrency.number"));
        sic.add(new SelectorItemInfo("reportCurrency.name"));
        sic.add(new SelectorItemInfo("baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("reportExchangeTable.id"));
        companyOrgUnitInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyId)), sic);
        return companyOrgUnitInfo;
    }

    @Override
    protected boolean isNeedCodeRule() {
        return true;
    }

    protected void initListener() {
        super.initListener();
        this.prmtEvaluateScheme.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                try {
                    FaEvaSchemeInfo newEvaSchemeInfo = (FaEvaSchemeInfo)e.getData();
                    FaEvaluateBillEditUI.this.schemeChanged(newEvaSchemeInfo);
                    FaEvaluateBillEditUI.this.setHasModified();
                }
                catch (Exception ex) {
                    FaEvaluateBillEditUI.this.handleException(ex);
                    SysUtil.abort();
                }
            }
        });
        this.detailTable.addKDTEditListener((KDTEditListener)new KdtEditStopedListener());
        this.detailTable.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                if (FaEvaluateBillEditUI.this.cardSelectedStatus == 1) {
                    List list = FaEvaluateBillEditUI.this.getSortedColIndex(true);
                    int col = (Integer)list.get(0);
                    FaEvaluateBillEditUI.this.detailTable.getEditManager().editCellAt(0, col);
                    FaEvaluateBillEditUI.this.cardSelectedStatus = -1;
                    return;
                }
                if (FaEvaluateBillEditUI.this.cardSelectedStatus == 0) {
                    FaEvaluateBillEditUI.this.cardSelectedStatus = 1;
                    return;
                }
                int selectedX = e.getSelectBlock().getBeginCol();
                int selectedY = e.getSelectBlock().getBeginRow();
                List sortedColIndex = FaEvaluateBillEditUI.this.getSortedColIndex(true);
                int index = sortedColIndex.indexOf(new Integer(selectedX));
                if (index != -1) {
                    FaEvaluateBillEditUI.this.detailTable.getEditManager().editCellAt(selectedY, selectedX, false);
                }
            }
        });
        this.spinValidityYear.addChangeListener((ChangeListener)new FaSpinnerChangeListener(9999, 1));
    }

    @Override
    protected void addLine(KDTable table) {
    }

    @Override
    protected boolean isShowCardFilter() {
        return false;
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        if (this.getUIContext().get("isFromWorkflow") != null) {
            this.actionCopy.setEnabled(false);
        }
        if (this.evaColumnMap.size() == 0 && this.editData.getEvaluateScheme() != null) {
            this.schemeChanged(this.editData.getEvaluateScheme());
        }
        this.isFinishLoad = true;
    }

    @Override
    public boolean isModify() {
        return super.isModify() || this.isModify;
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(this.getCurCompany().getId().toString());
        super.actionEdit_actionPerformed(e);
        this.spinValidityYear.setValue((Object)this.editData.getValidityYear().setScale(0, 4));
        this.schemeChanged(this.editData.getEvaluateScheme());
        this.actionEntryAdd.setEnabled(true);
        this.actionEntryDel.setEnabled(true);
        this.lockUnlockDocTable(false);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selector = super.getSelectors();
        selector.add(new SelectorItemInfo("*"));
        selector.add("faEvaluateBillEntry.faBizCard.propertyValue.*");
        return selector;
    }

    public void setImpValue(Map impValue) {
        this.impValue = impValue;
    }

    private void initDataImportDialog() throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        IUIWindow importUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.fa.manage.client.FaEvaValueImportUI", (Map)uiContext);
        importUI.show();
    }

    private void initEvaItemHead() throws Exception {
        boolean isViewStatus;
        boolean bl = isViewStatus = "VIEW".equals(this.oprtState) || "FINDVIEW".equals(this.oprtState);
        if (this.evaItems != null && this.evaItems.size() > 0) {
            List removeCols = this.getSortedColIndex(false);
            for (int i = removeCols.size() - 1; i >= 0; --i) {
                this.detailTable.removeColumn(((Integer)removeCols.get(i)).intValue());
            }
            this.evaItems.clear();
            this.evaColumnMap.clear();
        }
        if (this.evaSchemeInfo != null) {
            int baseScale = this.getCurrencyScale();
            KDTMergeManager mergeManager = this.detailTable.getHeadMergeManager();
            int columnIdx = this.detailTable.getColumnIndex("faEvaluateBillEntry.description");
            this.evaItems = FaManageUtils.getItemInfo((String)this.evaSchemeInfo.getFaEvaItem());
            this.evaColumnMap.clear();
            int size = this.evaItems.size();
            for (int i = 0; i < size; ++i) {
                AbstractEvaItemInfo evaItem = (AbstractEvaItemInfo)this.evaItems.get(i);
                int evaScale = evaItem.getEnum() == EvaItemEnum.ASSETVALUE ? baseScale : 2;
                String evaItemName = evaItem.getName();
                List details = evaItem.getEvaItemDetail();
                int detailSize = details.size();
                for (int j = 0; j < detailSize; ++j) {
                    FaEvaItemDetailInfo detail = (FaEvaItemDetailInfo)details.get(j);
                    IColumn column = this.detailTable.addColumn(columnIdx + j);
                    this.setComponentPrecision(new Object[]{column}, evaScale);
                    column.getStyleAttributes().setLocked(true);
                    this.detailTable.getHeadRow(0).getCell(column.getColumnIndex()).setValue((Object)evaItemName);
                    this.detailTable.getHeadRow(1).getCell(column.getColumnIndex()).setValue((Object)detail.getName());
                    this.evaColumnMap.put(evaItem.getEnum().getValue() + "|" + detail.getEnum().getValue(), new Integer(column.getColumnIndex()));
                }
                IColumn column = this.detailTable.addColumn(columnIdx + detailSize);
                this.setComponentPrecision(new Object[]{column}, evaScale);
                column.getStyleAttributes().setLocked(isViewStatus);
                this.evaColumnMap.put(evaItem.getEnum().getValue() + "|" + "00", new Integer(column.getColumnIndex()));
                this.detailTable.getHeadRow(1).getCell(column.getColumnIndex()).setValue((Object)EASResource.getString((String)RESOURCE_PATH, (String)"EVA_VALUE"));
                mergeManager.mergeBlock(0, columnIdx, 0, columnIdx + detailSize);
                columnIdx += details.size() + 1;
            }
        }
    }

    private void processCardSelected(FaCurCardCollection cardInfos) throws Exception {
        int i;
        if (cardInfos == null || cardInfos.size() == 0) {
            return;
        }
        ArrayList<String> oriCardIds = new ArrayList<String>();
        int size = this.detailTable.getRowCount();
        for (i = 0; i < size; ++i) {
            String cardId = this.detailTable.getRow(i).getCell("faEvaluateBillEntry.curCard.id").getValue().toString();
            oriCardIds.add(cardId);
        }
        this.detailTable.setRefresh(false);
        this.workloadSchemes = FaUtils.getUserDepreciationMode(null, (boolean)true);
        size = cardInfos.size();
        for (i = 0; i < size; ++i) {
            FaCurCardInfo cardInfo = cardInfos.get(i);
            String cardId = cardInfo.getId().toString();
            if (oriCardIds.contains(cardId)) continue;
            IRow row = this.detailTable.addRow();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("propertyValue.*"));
            FaCurCardInfo buf = FaCurCardFactory.getRemoteInstance().getFaCurCardInfo((IObjectPK)new ObjectUuidPK(cardId), selector);
            cardInfo.setPropertyValue(buf.getPropertyValue());
            HashMap<String, ICell> cellMap = new HashMap<String, ICell>();
            KDTColumns cc = this.detailTable.getColumns();
            for (int j = 0; j < cc.size(); ++j) {
                String key = cc.getColumn(j).getKey();
                if (key == null) continue;
                cellMap.put(key.toLowerCase(), row.getCell(key));
            }
            String prefix = "propertyValue.";
            if (cardInfo.getPropertyValue() != null) {
                FaDefPropertyValueInfo pv = cardInfo.getPropertyValue();
                String[] cols = pv.getDefPropertyNames();
                for (int ii = 0; ii < cols.length; ++ii) {
                    String name = prefix + cols[ii];
                    ICell cell = (ICell)cellMap.get(name.toLowerCase());
                    if (cell == null) continue;
                    cell.setValue(pv.get(cols[ii]));
                }
            }
            row.getCell("cardNumber").setValue((Object)cardInfo.getNumber());
            row.getCell("cardName").setValue((Object)cardInfo.getAssetName());
            row.getCell("cardCat").setValue((Object)cardInfo.getAssetCat().getName());
            row.getCell("cardSpec").setValue((Object)cardInfo.getSpecs());
            row.getCell("cardMeasure").setValue((Object)cardInfo.getMeasureUnit().getName());
            row.getCell("faEvaluateBillEntry.curCard.id").setValue((Object)cardInfo.getId().toString());
            row.getCell("cardCat.number").setValue((Object)cardInfo.getAssetCat().getNumber());
            row.getCell("deprMethod.number").setValue((Object)cardInfo.getDeprMethod().getNumber());
            row.getCell("curCard.lastUpdateTime").setValue((Object)cardInfo.getLastUpdateTime());
            Map code_col_map = AbstractEvaItemInfo.CODE_COLUMN_MAP;
            for (String key : code_col_map.keySet()) {
                this.evaValues.put("" + cardInfo.getId() + key, cardInfo.get((String)code_col_map.get(key)));
            }
            this.fillLineEvaValue(row);
        }
        this.detailTable.setRefresh(true);
        this.detailTable.repaint();
        int rowCnt = this.detailTable.getRowCount();
        if (rowCnt > 0) {
            List list = this.getSortedColIndex(true);
            int col = (Integer)list.get(0);
            this.cardSelectedStatus = 0;
            this.detailTable.getEditManager().editCellAt(0, col);
        }
    }

    private void fillEvaValue() throws Exception {
        int cardSize;
        this.evaValues.clear();
        if (this.detailTable.getRowCount() == 0 || this.evaSchemeInfo == null) {
            return;
        }
        ArrayList<String> entryIds = new ArrayList<String>();
        ArrayList<String> curCardIds = new ArrayList<String>();
        int size = this.detailTable.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.detailTable.getRow(i);
            String entryId = row.getCell(this.getEntryKeyName()).getValue() == null ? null : row.getCell(this.getEntryKeyName()).getValue().toString();
            String curCardId = row.getCell("faEvaluateBillEntry.curCard.id").getValue().toString();
            if (!StringUtils.isEmpty((String)entryId)) {
                entryIds.add(entryId);
            }
            curCardIds.add(curCardId);
        }
        if (entryIds.size() > 0) {
            IFaEvaValue iEvaValue = FaEvaValueFactory.getRemoteInstance();
            String ids = this.getIds(entryIds, "evaEntry.id");
            FaEvaValueCollection evaValueColl = iEvaValue.getFaEvaValueCollection("where evaEntry.id in (" + ids + ")");
            int size2 = evaValueColl.size();
            for (int i = 0; i < size2; ++i) {
                FaEvaValueInfo evaValue = evaValueColl.get(i);
                this.evaValues.put("" + evaValue.getEvaEntry().getId() + evaValue.getMainType().getValue() + evaValue.getSubType().getValue(), evaValue.getEvaValue());
            }
        }
        if ((cardSize = curCardIds.size()) > 0) {
            String ids = this.getIds(curCardIds, "id");
            FaCurCardCollection cards = FaCurCardFactory.getRemoteInstance().getFaCurCardCollection("select id," + AbstractEvaItemInfo.ALL_EVA_COLUMN + " where id in(" + ids + ")");
            for (int i = 0; i < cardSize; ++i) {
                FaCurCardInfo card = cards.get(i);
                Map code_col_map = AbstractEvaItemInfo.CODE_COLUMN_MAP;
                for (String key : code_col_map.keySet()) {
                    this.evaValues.put("" + card.getId() + key, card.getBigDecimal((String)code_col_map.get(key)));
                }
            }
        }
        int size2 = this.detailTable.getRowCount();
        for (int i = 0; i < size2; ++i) {
            this.fillLineEvaValue(this.detailTable.getRow(i));
        }
    }

    private String getIds(List curCardIds, String columnName) {
        StringBuffer idsBuffer = new StringBuffer(100);
        int cardSize = curCardIds.size();
        for (int i = 0; i < cardSize - 1; ++i) {
            if ((i + 1) % 900 == 0 && i + 1 < cardSize) {
                idsBuffer.append("'" + curCardIds.get(i) + "') or " + columnName + " in(");
                continue;
            }
            idsBuffer.append("'" + curCardIds.get(i) + "',");
        }
        idsBuffer.append("'" + curCardIds.get(curCardIds.size() - 1) + "'");
        return idsBuffer.toString();
    }

    private void fillLineEvaValue(IRow row) throws Exception {
        String entryId = row.getCell(this.getEntryKeyName()).getValue() == null ? null : row.getCell(this.getEntryKeyName()).getValue().toString();
        String curCardId = row.getCell("faEvaluateBillEntry.curCard.id").getValue().toString();
        String deprMethodNum = (String)row.getCell("deprMethod.number").getValue();
        boolean isWorkLoadMethod = deprMethodNum != null && (deprMethodNum.equals("002") || this.workloadSchemes.containsKey(deprMethodNum));
        int size = this.evaItems.size();
        for (int i = 0; i < size; ++i) {
            AbstractEvaItemInfo evaItem = (AbstractEvaItemInfo)this.evaItems.get(i);
            List details = evaItem.getEvaItemDetail();
            boolean resetPrecision = !isWorkLoadMethod && evaItem.getEnum() == EvaItemEnum.ODDUSELIFE;
            int size3 = details.size();
            for (int j = 0; j < size3; ++j) {
                Object value;
                FaEvaItemDetailInfo detail = (FaEvaItemDetailInfo)details.get(j);
                ICell cell = row.getCell(((Integer)this.evaColumnMap.get(evaItem.getEnum().getValue() + "|" + detail.getEnum().getValue())).intValue());
                if (resetPrecision) {
                    this.setComponentPrecision(new Object[]{cell}, 0);
                }
                if (!StringUtils.isEmpty((String)entryId)) {
                    value = this.evaValues.get(entryId + evaItem.getEnum().getValue() + detail.getEnum().getValue());
                    if (value == null) {
                        value = this.evaValues.get(curCardId + evaItem.getEnum().getValue() + detail.getEnum().getValue());
                    }
                    cell.setValue((Object)(value == null ? ZERO : value));
                    continue;
                }
                value = this.evaValues.get(curCardId + evaItem.getEnum().getValue() + detail.getEnum().getValue());
                cell.setValue((Object)(value == null ? ZERO : value));
            }
            ICell cell = row.getCell(((Integer)this.evaColumnMap.get(evaItem.getEnum().getValue() + "|" + "00")).intValue());
            if (resetPrecision) {
                this.setComponentPrecision(new Object[]{cell}, 0);
            }
            if (!StringUtils.isEmpty((String)entryId)) {
                Object value = this.evaValues.get(entryId + evaItem.getEnum().getValue() + "00");
                cell.setValue((Object)(value == null ? ZERO : value));
                continue;
            }
            cell.setValue((Object)ZERO);
        }
    }

    private List getSortedColIndex(boolean isOnlyEvaCol) {
        ArrayList list = new ArrayList();
        for (Map.Entry entry : this.evaColumnMap.entrySet()) {
            if (!isOnlyEvaCol) {
                list.add(entry.getValue());
                continue;
            }
            String key = (String)entry.getKey();
            if (!key.endsWith("00")) continue;
            list.add(entry.getValue());
        }
        Collections.sort(list);
        return list;
    }

    private void abort(JComponent component, String msg) {
        MsgBox.showInfo((Component)((Object)this), (String)msg);
        component.requestFocus();
        SysUtil.abort();
    }

    private void setEvaEntryCollection(boolean checkAmt, FaEvaluateBillInfo editData) throws BOSException {
        FaEvaluateBillEntryCollection entries = new FaEvaluateBillEntryCollection();
        editData.put("faEvaluateBillEntry", (Object)entries);
        this.workloadSchemes = FaUtils.getUserDepreciationMode(null, (boolean)true);
        int size = this.detailTable.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.detailTable.getRow(i);
            FaEvaluateBillEntryInfo entry = new FaEvaluateBillEntryInfo();
            entry.setDescription((String)row.getCell("faEvaluateBillEntry.description").getValue());
            entry.setFaEvaluateBill(editData);
            FaCurCardInfo cardInfo = new FaCurCardInfo();
            cardInfo.setId(BOSUuid.read((String)row.getCell("faEvaluateBillEntry.curCard.id").getValue().toString()));
            cardInfo.setLastUpdateTime((Timestamp)row.getCell("curCard.lastUpdateTime").getValue());
            String deprMethodNum = (String)row.getCell("deprMethod.number").getValue();
            boolean isWorkLoadMethod = deprMethodNum != null && (deprMethodNum.equals("002") || this.workloadSchemes.containsKey(deprMethodNum));
            cardInfo.put("isWorkLoadMethod", isWorkLoadMethod);
            entry.setFaCurCard(cardInfo);
            Object entryId = row.getCell("faEvaluateBillEntry.id").getValue();
            if (entryId != null && entryId.toString().length() > 0) {
                entry.setId(BOSUuid.read((String)entryId.toString()));
                FaBizCardInfo bizCard = new FaBizCardInfo();
                if (row.getCell("faEvaluateBillEntry.bizCard.id").getValue() != null) {
                    bizCard.setId(BOSUuid.read((String)row.getCell("faEvaluateBillEntry.bizCard.id").getValue().toString()));
                    entry.setFaBizCard(bizCard);
                }
            }
            entries.add(entry);
            FaEvaValueCollection evaValues = new FaEvaValueCollection();
            FaEvaValueInfo evaValue = new FaEvaValueInfo();
            for (Map.Entry evaCol : this.evaColumnMap.entrySet()) {
                String key = (String)evaCol.getKey();
                Integer colIndex = (Integer)evaCol.getValue();
                BigDecimal value = (BigDecimal)this.detailTable.getRow(i).getCell(colIndex.intValue()).getValue();
                evaValue.setMainType(FaManageUtils.getEvaItemEnum((int)Integer.parseInt(key.substring(0, key.indexOf("|")))));
                evaValue.setSubType(FaManageUtils.getEvaItemDetailEnum((String)key.substring(key.indexOf("|") + 1)));
                evaValue.setEvaValue(value);
                evaValues.add(evaValue);
                evaValue = new FaEvaValueInfo();
            }
            entry.put("evaValue", (Object)evaValues);
        }
    }

    private void schemeChanged(FaEvaSchemeInfo newEvaSchemeInfo) throws BOSException, EASBizException, Exception {
        if (newEvaSchemeInfo != null) {
            FAEvaluateModeInfo evaMode;
            this.isCatLimited = newEvaSchemeInfo.isAssetUnite();
            if (StringUtils.isEmpty((String)this.txtAim.getText())) {
                this.txtAim.setText(newEvaSchemeInfo.getEvaluateAim());
            }
            if (this.prmtEvaluateMode.getValue() == null && (evaMode = newEvaSchemeInfo.getFaEvaluateMode()) != null) {
                evaMode = (FAEvaluateModeInfo)FAEvaluateModeFactory.getRemoteInstance().getValue("select id,name,number where id ='" + evaMode.getId() + "'");
                this.prmtEvaluateMode.setValue((Object)evaMode);
            }
            String lastCatNumber = null;
            if (this.isCatLimited) {
                int size = this.detailTable.getRowCount();
                for (int i = 0; i < size; ++i) {
                    IRow row = this.detailTable.getRow(i);
                    if (lastCatNumber == null) {
                        lastCatNumber = (String)row.getCell("cardCat.number").getValue();
                        continue;
                    }
                    String faCatNumber = (String)row.getCell("cardCat.number").getValue();
                    if (faCatNumber.equals(lastCatNumber)) continue;
                    if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"CARDS_IS_MUTI_ASSETCAT")) == 0) {
                        this.detailTable.removeRows();
                        break;
                    }
                    SysUtil.abort();
                }
            }
            if (this.editData.getEffectedStatus() != EffectedStatusEnum.EFFECTED) {
                ArrayList<Object> cardIds = new ArrayList<Object>();
                ArrayList<Object> cardNums = new ArrayList<Object>();
                ArrayList<Integer> removeRows = new ArrayList<Integer>();
                int size = this.detailTable.getRowCount();
                for (int i = 0; i < size; ++i) {
                    IRow row = this.detailTable.getRow(i);
                    cardIds.add(row.getCell("faEvaluateBillEntry.curCard.id").getValue());
                    cardNums.add(row.getCell("cardNumber").getValue());
                }
                List result = FaEvaluateBillFactory.getRemoteInstance().hasChanged(cardIds, newEvaSchemeInfo, this.period);
                if (result != null && result.size() > 0) {
                    int i;
                    StringBuffer buffer = new StringBuffer(result.size() * 10 * 10);
                    int size2 = result.size();
                    int invalidCnt = 0;
                    for (i = 0; i < size2; ++i) {
                        if (invalidCnt < 10) {
                            buffer.append(result.get(i) + ",");
                        } else if (invalidCnt == 10) {
                            buffer.append("... ");
                        }
                        removeRows.add(new Integer(cardNums.indexOf(result.get(i))));
                        ++invalidCnt;
                    }
                    MsgBox.showInfo((Component)((Object)this), (String)(EASResource.getString((String)RESOURCE_PATH, (String)"CARDS_CHANGED_TO_REMOVE") + "\n[" + buffer.substring(0, buffer.length() - 1) + "]"));
                    for (i = removeRows.size(); i > 0; --i) {
                        this.detailTable.removeRow(((Integer)removeRows.get(i - 1)).intValue());
                    }
                }
            }
        }
        this.evaSchemeInfo = newEvaSchemeInfo;
        this.initEvaItemHead();
        this.fillEvaValue();
        this.detailTable.repaint();
    }

    private void setHasModified() {
        if (this.isModify) {
            return;
        }
        if (!this.isFinishLoad) {
            return;
        }
        if (!OprtState.VIEW.equals(this.oprtState) && !"FINDVIEW".equals(this.oprtState)) {
            this.isModify = true;
        }
    }

    private void updateEvaAfterAction() throws BOSException, EASBizException, Exception {
        this.schemeChanged(this.editData.getEvaluateScheme());
        this.isModify = false;
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        FaEvaluateBillInfo editDataClone = (FaEvaluateBillInfo)this.editData.clone();
        this.setEvaEntryCollection(false, editDataClone);
        BillBaseCollection billCol = new BillBaseCollection();
        billCol.add((BillBaseInfo)editDataClone);
        KDNoteHelper appHlp = new KDNoteHelper();
        KDTable[] tables = new KDTable[]{this.getDetailTable()};
        BOSQueryDelegate data = FaPrintHelper.getPrintManagerForFaEvalueBillEditUI((IObjectCollection)billCol, tables);
        appHlp.printPreview(this.getPrintPath(), (Object)data, (Component)((Object)this));
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        FaEvaluateBillInfo editDataClone = (FaEvaluateBillInfo)this.editData.clone();
        this.setEvaEntryCollection(false, editDataClone);
        BillBaseCollection billCol = new BillBaseCollection();
        billCol.add((BillBaseInfo)editDataClone);
        KDNoteHelper appHlp = new KDNoteHelper();
        KDTable[] tables = new KDTable[]{this.getDetailTable()};
        BOSQueryDelegate data = FaPrintHelper.getPrintManagerForFaEvalueBillEditUI((IObjectCollection)billCol, tables);
        appHlp.print(this.getPrintPath(), (Object)data, (Component)((Object)this));
    }

    @Override
    protected String getPrintPath() {
        return "/FI/FA/FaEvaluateBill";
    }

    private void verfyBenchmarkDate(boolean isSubmit) throws EASBizException, BOSException {
        if (this.pkBenchmarkDate.getValue() == null || this.detailTable.getRowCount() == 0) {
            return;
        }
        if (isSubmit && this.pkAdjustDate.getValue() != null && "true".equals(this.gethmParam().get("FA_056").toString()) && DateTimeUtils.truncateDate((Date)((Date)this.pkBenchmarkDate.getValue())).after(DateTimeUtils.truncateDate((Date)((Date)this.pkAdjustDate.getValue())))) {
            this.abort((JComponent)this.pkBenchmarkDate, EASResource.getString((String)RESOURCE_PATH, (String)"ADJUST_DATE_INVALID"));
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("faCurCard.number"));
        Date benchmarkDate = (Date)this.pkBenchmarkDate.getValue();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(benchmarkDate);
        calendar.set(5, 1);
        fic.add(new FilterItemInfo("faEvaluateBill.benchmarkDate", (Object)calendar.getTime(), CompareType.GREATER_EQUALS));
        calendar.set(5, calendar.getActualMaximum(5));
        fic.add(new FilterItemInfo("faEvaluateBill.benchmarkDate", (Object)calendar.getTime(), CompareType.LESS_EQUALS));
        fic.add(new FilterItemInfo("faCurCard.bizStatus", (Object)"%99", CompareType.LIKE));
        HashSet<Object> cardIds = new HashSet<Object>();
        int size = this.detailTable.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.detailTable.getRow(i);
            cardIds.add(row.getCell("faEvaluateBillEntry.curCard.id").getValue());
        }
        fic.add(new FilterItemInfo("faCurCard.id", cardIds, CompareType.INCLUDE));
        FaEvaluateBillEntryCollection entryCollection = FaEvaluateBillEntryFactory.getRemoteInstance().getFaEvaluateBillEntryCollection(viewInfo);
        if (entryCollection.size() > 0) {
            StringBuffer buffer = new StringBuffer();
            int size2 = entryCollection.size();
            for (int i = 0; i < size2; ++i) {
                FaEvaluateBillEntryInfo entryInfo = entryCollection.get(i);
                if (entryInfo.getFaCurCard() == null || entryInfo.getFaCurCard().getNumber() == null) continue;
                buffer.append(entryInfo.getFaCurCard().getNumber() + ",");
                if (i == 10) break;
            }
            String cardNumbers = entryCollection.size() >= 10 ? buffer.substring(0, buffer.length() - 1).concat("...") : buffer.substring(0, buffer.length() - 1);
            MsgBox.showInfo((Component)((Object)this), (String)(EASResource.getString((String)RESOURCE_PATH, (String)"BENCHMARKDATE_INVALID_CARDS") + "[" + cardNumbers + "]"));
            SysUtil.abort();
        }
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        String boID = this.getSelectBOID();
        if (boID == null) {
            return;
        }
        acm.showAttachmentListUIByBoID(boID, (Object)this, true);
    }

    private class FaEvaCardFilterProcessor
    extends FaCardFilterAdapter {
        private boolean isCatLimited;
        private String catNumber;
        private List invalidCardIds = null;

        public FaEvaCardFilterProcessor() {
            try {
                this.invalidCardIds = new ArrayList();
                if (FaEvaluateBillEditUI.this.evaSchemeInfo.isClearDepreciation()) {
                    String oql = "select id where deprTTerm > 0 and assetCat.DepreciationPolicy.EvaluateChange = 1 and company.id ='" + FaEvaluateBillEditUI.this.currCompany.getId() + "'";
                    FaCurCardCollection cards = FaCurCardFactory.getRemoteInstance().getFaCurCardCollection(oql);
                    int size = cards.size();
                    for (int i = 0; i < size; ++i) {
                        this.invalidCardIds.add(cards.get(i).getId().toString());
                    }
                }
            }
            catch (BOSException e) {
                FaEvaluateBillEditUI.this.handleException((Exception)((Object)e));
                SysUtil.abort();
            }
        }

        @Override
        public void verifyCardBeforeSelect(Component dialog, ArrayList curCardList) {
            int i;
            ArrayList<String> oriCardIds = new ArrayList<String>();
            String oriCatNumber = this.catNumber;
            int size = FaEvaluateBillEditUI.this.detailTable.getRowCount();
            for (i = 0; i < size; ++i) {
                String cardId = FaEvaluateBillEditUI.this.detailTable.getRow(i).getCell("faEvaluateBillEntry.curCard.id").getValue().toString();
                oriCardIds.add(cardId);
                if (!this.isCatLimited || oriCatNumber != null) continue;
                oriCatNumber = (String)FaEvaluateBillEditUI.this.detailTable.getRow(i).getCell("cardCat.number").getValue();
            }
            if (this.isCatLimited) {
                size = curCardList.size();
                for (i = 0; i < size; ++i) {
                    IRow resultRow = (IRow)curCardList.get(i);
                    if (oriCatNumber == null) {
                        oriCatNumber = (String)resultRow.getCell("assetCat.number").getValue();
                        continue;
                    }
                    if (oriCatNumber.equals(resultRow.getCell("assetCat.number").getValue())) continue;
                    MsgBox.showInfo((Component)((Object)FaEvaluateBillEditUI.this), (String)EASResource.getString((String)FaEvaluateBillEditUI.RESOURCE_PATH, (String)"SELECT_UNIFY_ASSET_CARD"));
                    SysUtil.abort();
                }
            }
            ArrayList<Object> cardIds = new ArrayList<Object>();
            List validEvaCards = null;
            int size2 = curCardList.size();
            for (int i2 = 0; i2 < size2; ++i2) {
                IRow row = (IRow)curCardList.get(i2);
                cardIds.add(row.getCell("id").getValue());
            }
            try {
                validEvaCards = FaEvaluateBillFactory.getRemoteInstance().hasChanged(cardIds, FaEvaluateBillEditUI.this.evaSchemeInfo, FaEvaluateBillEditUI.this.period);
            }
            catch (Exception e) {
                FaEvaluateBillEditUI.this.handleException(e);
                SysUtil.abort();
            }
            if (validEvaCards != null && validEvaCards.size() > 0) {
                MsgBox.showInfo((Component)((Object)FaEvaluateBillEditUI.this), (String)EASResource.getString((String)FaEvaluateBillEditUI.RESOURCE_PATH, (String)"CARD_CHANGED_BEFORE_EVALUATE"));
                SysUtil.abort();
            }
        }

        @Override
        protected boolean removeCardFromQuery(IRow row, int queryType) throws Exception {
            return this.invalidCardIds.contains(row.getCell("id").getValue().toString());
        }

        public void setCatNumber(String catNumber) {
            this.catNumber = catNumber;
        }

        public void setCatLimited(boolean isCatLimited) {
            this.isCatLimited = isCatLimited;
        }
    }

    private class KdtEditStopedListener
    extends KDTEditAdapter {
        private KdtEditStopedListener() {
        }

        public void editStopped(KDTEditEvent e) {
            if (FaEvaluateBillEditUI.this.detailTable.getRowCount() == 0) {
                return;
            }
            if (e.getColIndex() == FaEvaluateBillEditUI.this.detailTable.getColumn("faEvaluateBillEntry.description").getColumnIndex()) {
                return;
            }
            if (e.getOldValue() == null || ((BigDecimal)e.getOldValue()).compareTo((BigDecimal)e.getValue()) != 0) {
                FaEvaluateBillEditUI.this.setHasModified();
            }
            int activedRow = e.getRowIndex();
            int activedCol = e.getColIndex();
            List sortedColIndex = FaEvaluateBillEditUI.this.getSortedColIndex(true);
            int index = sortedColIndex.indexOf(new Integer(activedCol));
            if (index == -1) {
                return;
            }
        }
    }
}

