/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewAdminF7;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.FAEvaluateModeFactory;
import com.kingdee.eas.fi.fa.basedata.FAEvaluateModeInfo;
import com.kingdee.eas.fi.fa.basedata.FaCatFactory;
import com.kingdee.eas.fi.fa.basedata.FaCatInfo;
import com.kingdee.eas.fi.fa.basedata.FaEvaSchemeFactory;
import com.kingdee.eas.fi.fa.basedata.FaEvaSchemeInfo;
import com.kingdee.eas.fi.fa.basedata.client.FaCatPromptBox;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaEvaluateBillFilterUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class FaEvaluateBillFilterUI
extends AbstractFaEvaluateBillFilterUI {
    private Logger logger = Logger.getLogger(FaEvaluateBillFilterUI.class);

    public FaEvaluateBillFilterUI() throws Exception {
        this.initUIComponents();
    }

    public FilterInfo getFilterInfo() {
        FilterItemCollection filterItems = this.filterInfo.getFilterItems();
        filterItems.clear();
        StringBuffer sbFormula = new StringBuffer();
        int i = 0;
        filterItems.add(new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
        sbFormula.append("#" + i++);
        if (!StringUtils.isEmpty((String)this.txtNumber.getText())) {
            filterItems.add(new FilterItemInfo("number", (Object)this.txtNumber.getText()));
            sbFormula.append(" and #" + i++);
        }
        if (this.prmtScheme.getData() != null) {
            filterItems.add(new FilterItemInfo("evaluateScheme.id", (Object)((FaEvaSchemeInfo)this.prmtScheme.getData()).getId().toString()));
            sbFormula.append(" and #" + i++);
        }
        if (this.prmtMode.getData() != null) {
            filterItems.add(new FilterItemInfo("evaluateMode.id", (Object)((FAEvaluateModeInfo)this.prmtMode.getData()).getId().toString()));
            sbFormula.append(" and #" + i++);
        }
        if (!StringUtils.isEmpty((String)this.txtEvaluateOrg.getText())) {
            filterItems.add(new FilterItemInfo("evaluateOrg", (Object)this.txtEvaluateOrg.getText()));
            sbFormula.append(" and #" + i++);
        }
        if (this.prmtOwnerCompany.getData() != null) {
            filterItems.add(new FilterItemInfo("ownerCompany.id", (Object)((AdminOrgUnitInfo)this.prmtOwnerCompany.getData()).getId().toString()));
            sbFormula.append(" and #" + i++);
        }
        if (this.prmtCat.getData() != null) {
            filterItems.add(new FilterItemInfo("faEvaluateBillEntry.faBizCard.assetCat.id", (Object)((FaCatInfo)this.prmtCat.getData()).getId().toString()));
            sbFormula.append(" and #" + i++);
        }
        if (this.pkBeginDate.getValue() != null) {
            filterItems.add(new FilterItemInfo("benchmarkDate", (Object)DateTimeUtils.truncateDate((Date)((Date)this.pkBeginDate.getValue())), CompareType.GREATER_EQUALS));
            sbFormula.append(" and #" + i++);
        }
        if (this.pkEndDate.getValue() != null) {
            filterItems.add(new FilterItemInfo("benchmarkDate", (Object)DateTimeUtils.truncateDate((Date)((Date)this.pkEndDate.getValue())), CompareType.LESS_EQUALS));
            sbFormula.append(" and #" + i++);
        }
        if (!StringUtils.isEmpty((String)this.txtAssetNumFrom.getText())) {
            filterItems.add(new FilterItemInfo("faEvaluateBillEntry.faBizCard.assetCat.number", (Object)this.txtAssetNumFrom.getText(), CompareType.GREATER_EQUALS));
            sbFormula.append(" and #" + i++);
        }
        if (!StringUtils.isEmpty((String)this.txtAssetNumTo.getText())) {
            filterItems.add(new FilterItemInfo("faEvaluateBillEntry.faBizCard.assetCat.number", (Object)this.txtAssetNumTo.getText(), CompareType.LESS_EQUALS));
            sbFormula.append(" and #" + i++);
        }
        this.filterInfo.setMaskString(sbFormula.toString());
        return this.filterInfo;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.clear();
        FilterItemCollection fic = new FilterItemCollection();
        if (entityViewInfo.getFilter() != null) {
            fic = entityViewInfo.getFilter().getFilterItems();
        }
        if (fic == null || fic.size() == 0) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        int size = fic.size();
        for (int i = 0; i < size; ++i) {
            FilterItemInfo filterItem = fic.get(i);
            CompareType compType = filterItem.getCompareType();
            String propName = filterItem.getPropertyName();
            Object compValue = filterItem.getCompareValue();
            try {
                if (propName.equals("number")) {
                    this.txtNumber.setText((String)compValue);
                    continue;
                }
                if (propName.equals("evaluateScheme.id")) {
                    FaEvaSchemeInfo schemeInfo = FaEvaSchemeFactory.getRemoteInstance().getFaEvaSchemeInfo((IObjectPK)new ObjectUuidPK((String)compValue), sic);
                    this.prmtScheme.setData((Object)schemeInfo);
                    continue;
                }
                if (propName.equals("evaluateMode.id")) {
                    FAEvaluateModeInfo modeInfo = FAEvaluateModeFactory.getRemoteInstance().getFAEvaluateModeInfo((IObjectPK)new ObjectUuidPK((String)compValue), sic);
                    this.prmtMode.setData((Object)modeInfo);
                    continue;
                }
                if (propName.equals("evaluateOrg")) {
                    this.txtEvaluateOrg.setText((String)compValue);
                    continue;
                }
                if (propName.equals("ownerCompany.id")) {
                    AdminOrgUnitInfo ownerCompany = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK((String)compValue), sic);
                    this.prmtOwnerCompany.setData((Object)ownerCompany);
                    continue;
                }
                if (propName.equals("faEvaluateBillEntry.faBizCard.assetCat.id")) {
                    FaCatInfo catInfo = FaCatFactory.getRemoteInstance().getFaCatInfo((IObjectPK)new ObjectUuidPK((String)compValue), sic);
                    this.prmtCat.setData((Object)catInfo);
                    continue;
                }
                if (propName.equals("benchmarkDate") && compType == CompareType.GREATER_EQUALS) {
                    this.pkBeginDate.setValue(compValue);
                    continue;
                }
                if (propName.equals("benchmarkDate") && compType == CompareType.LESS_EQUALS) {
                    this.pkEndDate.setValue(compValue);
                    continue;
                }
                if (propName.equals("faEvaluateBillEntry.faBizCard.assetCat.number") && compType == CompareType.GREATER_EQUALS) {
                    this.txtAssetNumFrom.setText((String)compValue);
                    continue;
                }
                if (!propName.equals("faEvaluateBillEntry.faBizCard.assetCat.number") || compType != CompareType.LESS_EQUALS) continue;
                this.txtAssetNumTo.setText((String)compValue);
                continue;
            }
            catch (ObjectNotFoundException e) {
                this.logger.error((Object)e);
                continue;
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        }
    }

    private void initUIComponents() throws Exception {
        NewAdminF7 adminF7 = new NewAdminF7((IUIObject)this);
        boolean isOrgRange = "true".equals(this.gethmParam().get("FA_040").toString());
        FaClientUtils.processAdminF7(adminF7, isOrgRange);
        this.prmtOwnerCompany.setSelector((KDPromptSelector)adminF7);
        FaCatPromptBox catF7 = new FaCatPromptBox((CoreUIObject)this);
        this.prmtCat.setSelector((KDPromptSelector)catF7);
        try {
            this.prmtScheme.setEntityViewInfo(new EntityViewInfo("where isEnabled = 1 and company.id = '" + SysContext.getSysContext().getCurrentFIUnit().getId() + "'"));
        }
        catch (ParserException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        this.pkBeginDate.setValue(null);
        this.pkEndDate.setValue(null);
    }

    public HashMap gethmParam() {
        HashMap hmParam = new HashMap();
        try {
            hmParam = FaManageUtils.getFAParameter(this.getCurrentCompany().getId());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return hmParam;
    }

    private CompanyOrgUnitInfo getCurrentCompany() throws Exception {
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        String companyId = null;
        companyId = FaClientUtils.isFromLink((CoreUIObject)this) ? (String)this.getUIContext().get("COMPANY_ID") : SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("accountPeriodType.id"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("reportCurrency.id"));
        sic.add(new SelectorItemInfo("reportCurrency.number"));
        sic.add(new SelectorItemInfo("reportCurrency.name"));
        sic.add(new SelectorItemInfo("baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("reportExchangeTable.id"));
        companyOrgUnitInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyId)), sic);
        return companyOrgUnitInfo;
    }

    public void clear() {
        this.txtNumber.setText(null);
        this.prmtScheme.setData(null);
        this.prmtMode.setData(null);
        this.txtEvaluateOrg.setText(null);
        this.prmtOwnerCompany.setData(null);
        this.prmtCat.setData(null);
        this.pkBeginDate.setValue(null);
        this.pkEndDate.setValue(null);
        this.txtAssetNumFrom.setText(null);
        this.txtAssetNumTo.setText(null);
    }
}

