/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaUtils;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceBillFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceBillInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseException;
import com.kingdee.eas.fi.fa.manage.FaPayModeEnum;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaLeaseBalanceDetailUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.manage.client.FaLeaseUtils;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;

public class FaLeaseBalanceDetailUI
extends AbstractFaLeaseBalanceDetailUI {
    private static final String RES_PATH = "com.kingdee.eas.fi.fa.manage.FaLeaseResource";
    private int scale = 0;
    private final String year_str = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaLeaseResource", (String)"year");
    private final String year2_str = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaLeaseResource", (String)"year2");
    private final String month_str = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaLeaseResource", (String)"month");
    private final String month2_str = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaLeaseResource", (String)"month2");
    private final String season2_str = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaLeaseResource", (String)"season2");
    private final String day_str = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaLeaseResource", (String)"day");
    private static final String VOUCHERTYPE = new VoucherInfo().getBOSType().toString();

    public FaLeaseBalanceDetailUI() throws Exception {
        this.tblBalance.checkParsed();
        FaUtils.freezeTable((KDTable)this.tblBalance, (int)4);
        this.tblBalance.getStyleAttributes().setLocked(true);
        this.tblBalance.getSelectManager().setSelectMode(2);
        this.scale = FaClientUtils.getCurrencyScale();
        FaClientUtils.fmtDate(this.tblBalance, new String[]{"paymentDate"});
        FaClientUtils.changeTableNumberFormat(this.tblBalance, new String[]{"shouldPayment", "actualPayment", "realPayment"}, FaClientUtils.getDecimalFormat(this.scale));
        FaClientUtils.changeTableTextFormat(this.tblBalance, new String[]{"balanceNumber", "relatedNumber"});
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public KDTable getDetailTable() {
        return this.tblBalance;
    }

    public void fillData(IObjectValue billInfo) throws Exception {
        this.tblBalance.removeRows();
        if (billInfo == null) {
            return;
        }
        BigDecimal amount = (BigDecimal)billInfo.get("hireNaturalAmt");
        FaPayModeEnum payMode = FaPayModeEnum.getEnum(billInfo.getInt("payMode"));
        String periodId = ((PeriodInfo)billInfo.get("period")).getId().toString();
        PeriodInfo period = PeriodFactory.getRemoteInstance().getPeriodInfo((IObjectPK)new ObjectUuidPK(periodId));
        this.setPayMode(payMode);
        this.fillPlanData(amount, payMode, (Date)billInfo.get("beginDate"), (Date)billInfo.get("endDate"), period, billInfo.getBigDecimal("bargainTime").intValue(), billInfo.getInt("measureUnit"));
        if (billInfo.getBOSUuid("id") != null) {
            this.fillBalanceData(billInfo.getBOSUuid("id").toString());
        }
    }

    private void fillPlanData(BigDecimal amount, FaPayModeEnum payMode, Date beginDate, Date endDate, PeriodInfo period, int bargainTime, int measureUnit) throws Exception {
        IRow row;
        int i;
        String[] timeZone = null;
        int lineCount = Integer.MAX_VALUE;
        if (payMode.getValue() == 0) {
            timeZone = FaLeaseUtils.getYearZone(beginDate, endDate);
            lineCount = measureUnit == 0 ? bargainTime : (measureUnit == 1 ? (int)Math.ceil((double)bargainTime / 12.0) : Integer.MAX_VALUE);
        } else if (payMode.getValue() == 1) {
            timeZone = FaLeaseUtils.getSeasonZone(beginDate, endDate);
            lineCount = measureUnit == 0 ? bargainTime * 4 : (measureUnit == 1 ? (int)Math.ceil((double)bargainTime / 3.0) : Integer.MAX_VALUE);
        } else if (payMode.getValue() == 2) {
            timeZone = FaLeaseUtils.getMonthZone(beginDate, endDate);
            lineCount = measureUnit == 0 ? bargainTime * 12 : (measureUnit == 1 ? bargainTime : Integer.MAX_VALUE);
        } else if (payMode.getValue() == 3) {
            timeZone = FaLeaseUtils.getDayZone(beginDate, endDate);
        } else {
            this.tblBalance.addRow();
            return;
        }
        BigDecimal sum = new BigDecimal("0");
        lineCount = Math.min(timeZone.length, lineCount);
        BigDecimal cellValue = amount.divide(new BigDecimal(lineCount), this.scale, 4);
        for (i = 0; i < timeZone.length - 1 && i < lineCount - 1; ++i) {
            row = this.tblBalance.addRow();
            row.getCell("measureUnit").setValue((Object)timeZone[i]);
            sum = sum.add(cellValue);
            row.getCell("shouldPayment").setValue((Object)cellValue);
        }
        row = this.tblBalance.addRow();
        row.getCell("measureUnit").setValue((Object)timeZone[i]);
        row.getCell("shouldPayment").setValue((Object)amount.subtract(sum));
    }

    public void fillBalanceData(String billId) throws BOSException, EASBizException, ParserException {
        CoreBaseCollection balances = this.getBalance(billId);
        FaLeaseBalanceEntryCollection entries = new FaLeaseBalanceEntryCollection();
        if (balances.size() == 0) {
            return;
        }
        entries = ((FaLeaseBalanceBillInfo)balances.get(0)).getEntry();
        entries = FaLeaseUtils.resortBalance(entries);
        for (int i = 0; i < entries.size(); ++i) {
            FaLeaseBalanceEntryInfo entry = entries.get(i);
            int rowIndex = entry.getSeq() - 1;
            IRow row = this.tblBalance.getRow(rowIndex);
            if (row == null) {
                row = this.tblBalance.addRow();
            }
            row.getCell("actualPayment").setValue((Object)entry.getActualPayment().setScale(this.scale, 4));
            row.getCell("paymentType").setValue((Object)entry.getPaymentType().toString());
            row.getCell("paymentDate").setValue((Object)entry.getPaymentDate());
            row.getCell("balanceType").setValue(entry.getBalanceType() == null ? null : entry.getBalanceType().getName());
            row.getCell("balanceNumber").setValue((Object)entry.getBalanceNumber());
            row.getCell("bank").setValue(entry.getBank() == null ? null : entry.getBank().getName());
            row.getCell("paymentAccount").setValue(entry.getPaymentAccount() == null ? null : entry.getPaymentAccount().getName());
            row.getCell("paymentAcctView").setValue(entry.getPaymentAcctView() == null ? null : entry.getPaymentAcctView().getNumber() + " - " + entry.getPaymentAcctView().getName());
            row.getCell("paymentOppAcctView").setValue(entry.getPaymentOppAcctView() == null ? null : entry.getPaymentOppAcctView().getNumber() + " - " + entry.getPaymentOppAcctView().getName());
            row.getCell("relatedNumber").setValue((Object)entry.getRelatedNumber());
            row.getCell("realPayment").setValue((Object)entry.getRealPayment().setScale(this.scale, 4));
            row.getCell("feeAcctView").setValue(entry.getFeeAcctView() == null ? null : entry.getFeeAcctView().getNumber() + " - " + entry.getFeeAcctView().getName());
            row.getCell("feeOppAcctView").setValue(entry.getFeeOppAcctView() == null ? null : entry.getFeeOppAcctView().getNumber() + " - " + entry.getFeeOppAcctView().getName());
            row.getCell("handler").setValue((Object)entry.getHandler().getName());
            String isCheck = entry.getCheckedStatus().getValue() == 2 ? EASResource.getString((String)RES_PATH, (String)"hasAudit") : (entry.isCheckStatus() ? EASResource.getString((String)RES_PATH, (String)"hasCheck") : EASResource.getString((String)RES_PATH, (String)"hasSubmit"));
            row.getCell("checkedStatus").setValue((Object)isCheck);
            String vchNumber = this.getVchNumber(entry.getId().toString());
            row.getCell("vchNumber").setValue((Object)(vchNumber == null ? null : vchNumber));
            row.getCell("isPayment").setValue((Object)(entry.isIsPayment() ? EASResource.getString((String)RES_PATH, (String)"paymentBill") : EASResource.getString((String)RES_PATH, (String)"gatheringBill")));
            row.getCell("id").setValue((Object)entry.getId().toString());
        }
        if (this.tblBalance.getRowCount() > 1 && this.tblBalance.getRow(0).getCell("measureUnit").getValue() == null && this.tblBalance.getRow(0).getCell("id").getValue() == null) {
            this.tblBalance.removeRow(0);
        }
    }

    private CoreBaseCollection getBalance(String billId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new String("entry.actualPayment"));
        sic.add(new String("entry.paymentType"));
        sic.add(new String("entry.paymentDate"));
        sic.add(new String("entry.balanceType.name"));
        sic.add(new String("entry.balanceNumber"));
        sic.add(new String("entry.bank.name"));
        sic.add(new String("entry.paymentAccount.name"));
        sic.add(new String("entry.paymentAccount.number"));
        sic.add(new String("entry.paymentAcctView.name"));
        sic.add(new String("entry.paymentAcctView.number"));
        sic.add(new String("entry.paymentOppAcctView.name"));
        sic.add(new String("entry.relatedNumber"));
        sic.add(new String("entry.realPayment"));
        sic.add(new String("entry.feeAcctView.name"));
        sic.add(new String("entry.feeAcctView.number"));
        sic.add(new String("entry.feeOppAcctView.name"));
        sic.add(new String("entry.feeOppAcctView.number"));
        sic.add(new String("entry.handler.name"));
        sic.add(new String("entry.checkedStatus"));
        sic.add(new String("entry.checkStatus"));
        sic.add(new String("entry.voucher.number"));
        sic.add(new String("entry.seq"));
        sic.add(new String("entry.isPayment"));
        sic.add(new String("entry.id"));
        sic.add(new String("id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("leaseOutBill.id", (Object)billId));
        filter.getFilterItems().add(new FilterItemInfo("leaseInBill.id", (Object)billId));
        filter.setMaskString("#0 or #1");
        view.setFilter(filter);
        String oql = "select *,entry.*,entry.paymentAccount.name,entry.paymentAccount.number,entry.paymentAcctView.name,entry.paymentAcctView.number,entry.paymentOppAcctView.name,entry.paymentOppAcctView.number,";
        oql = oql + "entry.feeAcctView.name,entry.feeAcctView.number,entry.feeOppAcctView.name,entry.feeOppAcctView.number,entry.bank.name,entry.balanceType.name,entry.handler.name ";
        CoreBaseCollection balances = FaLeaseBalanceBillFactory.getRemoteInstance().getCollection(oql + "where leaseOutBill.id='" + billId + "' or leaseInBill.id='" + billId + "'");
        return balances;
    }

    private String getVchNumber(String srcBillId) throws BOSException {
        String vchNumber = null;
        ArrayList relationCollection = BOTRelationFactory.getRemoteInstance().getDestObjIdByDestType(srcBillId, VOUCHERTYPE);
        if (relationCollection != null && relationCollection.size() > 0) {
            HashSet<String> keySet = new HashSet<String>();
            keySet.add(relationCollection.get(0).toString());
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("number"));
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", keySet, CompareType.INCLUDE));
            VoucherCollection vchCollection = VoucherFactory.getRemoteInstance().getVoucherCollection(view);
            if (vchCollection != null && vchCollection.get(0) != null) {
                vchNumber = vchCollection.get(0).getNumber().toString();
            }
        }
        return vchNumber;
    }

    public void setPayMode(FaPayModeEnum payMode) {
        this.tblBalance.getColumn("measureUnit").getStyleAttributes().setHided(false);
        this.tblBalance.getColumn("shouldPayment").getStyleAttributes().setHided(false);
        ICell unitCell = this.tblBalance.getHeadRow(0).getCell("measureUnit");
        if (payMode == null) {
            unitCell.setValue((Object)(this.year2_str + "/" + this.season2_str + "/" + this.month2_str + "/" + this.day_str));
        } else if (payMode.getValue() == 0) {
            unitCell.setValue((Object)this.year2_str);
        } else if (payMode.getValue() == 1) {
            unitCell.setValue((Object)this.season2_str);
        } else if (payMode.getValue() == 2) {
            unitCell.setValue((Object)this.month2_str);
        } else if (payMode.getValue() == 3) {
            unitCell.setValue((Object)this.day_str);
        } else {
            this.tblBalance.getColumn("measureUnit").getStyleAttributes().setHided(true);
            this.tblBalance.getColumn("shouldPayment").getStyleAttributes().setHided(true);
        }
    }

    public void addRow(IObjectValue billInfo) throws FaLeaseException {
        if (billInfo == null) {
            return;
        }
        if (billInfo.getInt("bizStatus") == 5) {
            throw new FaLeaseException(FaLeaseException.HASCLOSEDNOPAID);
        }
        FaPayModeEnum payMode = FaPayModeEnum.getEnum(billInfo.getInt("payMode"));
        if (payMode.getValue() == 5) {
            int i;
            boolean hasEmptyRow = false;
            for (i = 0; i < this.tblBalance.getRowCount(); ++i) {
                IRow row = this.tblBalance.getRow(i);
                if (row.getCell("id").getValue() != null) continue;
                hasEmptyRow = true;
                break;
            }
            if (hasEmptyRow) {
                MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)RES_PATH, (String)"checkLine"), new Integer(i + 1)));
                return;
            }
            this.tblBalance.addRow();
        }
    }

    public void removeRow(IObjectValue billInfo) throws EASBizException, BOSException {
        if (billInfo == null) {
            return;
        }
        KDTSelectBlock block = this.tblBalance.getSelectManager().get();
        if (block == null || this.tblBalance.getRow(block.getBeginRow()) == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        int rowIndex = block.getBeginRow();
        IRow row = this.tblBalance.getRow(rowIndex);
        if (row.getCell("id").getValue() == null) {
            this.tblBalance.removeRow(rowIndex);
        } else if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")))) {
            String id = row.getCell("id").getValue().toString();
            FaLeaseBalanceEntryFactory.getRemoteInstance().delete((IObjectPK)new ObjectUuidPK(id));
            this.tblBalance.removeRow(rowIndex);
        }
    }
}

