/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.ext.CommonF7KDTableListener;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.fa.manage.AbstractFaLeaseBillInfo;
import com.kingdee.eas.fi.fa.manage.AbstractFaLeaseInBillInfo;
import com.kingdee.eas.fi.fa.manage.DateUnitEnum;
import com.kingdee.eas.fi.fa.manage.FaBillBaseInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceBillFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceInEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceOutEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaLeaseBillInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseException;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillInfo;
import com.kingdee.eas.fi.fa.manage.FaPayModeEnum;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaLeaseBalanceUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.manage.client.FaLeaseBalanceDetailUI;
import com.kingdee.eas.fi.fa.manage.client.FaLeasePaymentUI;
import com.kingdee.eas.fi.fa.manage.client.FaLeaseUtils;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.IntEnum;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.KeyStroke;

public class FaLeaseBalanceUI
extends AbstractFaLeaseBalanceUI {
    private FaLeaseBalanceDetailUI detailUI = new FaLeaseBalanceDetailUI();
    private static final String RES_PATH = "com.kingdee.eas.fi.fa.manage.FaLeaseResource";
    private static final String VOUCHERTYPE = new VoucherInfo().getBOSType().toString();
    private CurrencyCollection currencyCollection;

    public FaLeaseBalanceUI() throws Exception {
        this.detailUI.initUIContentLayout();
    }

    @Override
    public void onLoad() throws Exception {
        this.setOprtState(OprtState.ADDNEW);
        super.onLoad();
        this.afterOnload();
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.menuItemAudit.setAccelerator(KeyStroke.getKeyStroke("ctrl U"));
        this.menuItemUnAudit.setAccelerator(KeyStroke.getKeyStroke("ctrl shift U"));
        this.menuItemPayment.setAccelerator(KeyStroke.getKeyStroke("ctrl H"));
        this.menuItemReceivement.setAccelerator(KeyStroke.getKeyStroke("ctrl G"));
        CurrencyCollection currencyCollection = this.getCurrencyCollection();
        Vector<CurrencyInfo> tempCbDatas = new Vector<CurrencyInfo>();
        int size = currencyCollection.size();
        for (int i = 0; i < size; ++i) {
            tempCbDatas.addElement(currencyCollection.get(i));
        }
        this.comboHireCurrency.setModel(new DefaultComboBoxModel(tempCbDatas));
    }

    private CurrencyCollection getCurrencyCollection() {
        if (this.currencyCollection == null) {
            try {
                this.currencyCollection = FaClientUtils.setCurrencyCombo(this.getCurCompany(), OprtState.VIEW);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return this.currencyCollection;
    }

    protected void loadData() throws Exception {
    }

    @Override
    public boolean isModify() {
        return false;
    }

    @Override
    protected String getEntryKeyName() {
        return "entry";
    }

    public String getUITitle() {
        return EASResource.getString((String)RES_PATH, (String)"leasePaymentUITitle");
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return FaLeaseBalanceBillFactory.getRemoteInstance();
    }

    @Override
    public void actionPayment_actionPerformed(ActionEvent e) throws Exception {
        this.showPaymentUI(Boolean.TRUE);
    }

    private void showPaymentUI(Boolean isPayment) throws Exception {
        int rowIndex;
        if (this.detailUI.getDetailTable().getSelectManager() == null || this.detailUI.getDetailTable().getSelectManager().get() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if ((rowIndex = this.detailUI.getDetailTable().getSelectManager().get().getBeginRow()) < 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        IRow row = this.detailUI.getDetailTable().getRow(rowIndex);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"bill", this.bizLeaseBill.getValue());
        uiContext.put((Object)"isPayment", (Object)isPayment);
        uiContext.put((Object)"measureUnit", row.getCell("measureUnit").getValue());
        uiContext.put((Object)"seq", (Object)new Integer(rowIndex + 1));
        String id = (String)row.getCell("id").getValue();
        uiContext.put((Object)"ID", (Object)id);
        if (id == null) {
            String unitText = (String)row.getCell("measureUnit").getValue();
            if (unitText != null && unitText.length() > 0) {
                if (((IObjectValue)this.bizLeaseBill.getValue()).getInt("bizStatus") == 5) {
                    throw new FaLeaseException(FaLeaseException.HASCLOSEDNOPAID);
                }
                PeriodInfo period = FaClientUtils.getFACurrentPeriod(this.getCurCompany());
                FaPayModeEnum payMode = (FaPayModeEnum)((Object)this.combPayMode.getSelectedItem());
                boolean isValid = true;
                if (payMode.getValue() == 0) {
                    int[] parseYearResult = FaLeaseUtils.parseYearZone(unitText);
                    int year = parseYearResult[0];
                    if (period.getPeriodYear() != year) {
                        isValid = false;
                    }
                } else if (payMode.getValue() == 1) {
                    int[] parseSeasonResult = FaLeaseUtils.parseSeasonZone(unitText);
                    int year = parseSeasonResult[0];
                    int season = parseSeasonResult[1];
                    int month = period.getPeriodNumber();
                    if (period.getPeriodYear() != year || month <= (season - 1) * 3 || month > season * 3) {
                        isValid = false;
                    }
                } else if (payMode.getValue() == 2 || payMode.getValue() == 3) {
                    int[] parseMonthResult = FaLeaseUtils.parseMonthZone(unitText);
                    int year = parseMonthResult[0];
                    int month = parseMonthResult[1];
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(period.getBeginDate());
                    int curMonth = cal.get(2) + 1;
                    int curYear = cal.get(1);
                    if (curYear != year || curMonth != month) {
                        isValid = false;
                    }
                }
                if (!isValid) {
                    MsgBox.showInfo((Component)((Object)this), (String)(MessageFormat.format(EASResource.getString((String)RES_PATH, (String)"currPeriodIs"), period) + "\uff0c" + EASResource.getString((String)RES_PATH, (String)"mustInPeriod")));
                    SysUtil.abort();
                }
            }
        } else {
            Boolean cellIsPayment = row.getCell("isPayment").getValue().equals(EASResource.getString((String)RES_PATH, (String)"paymentBill"));
            if (!isPayment.equals(cellIsPayment)) {
                MsgBox.showInfo((Component)((Object)this), (String)(cellIsPayment != false ? EASResource.getString((String)RES_PATH, (String)"hasPaymentAbort") : EASResource.getString((String)RES_PATH, (String)"hasRecvAbort")));
                SysUtil.abort();
            }
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FaLeasePaymentUI.class.getName(), (Map)uiContext, null, id == null ? OprtState.ADDNEW : OprtState.VIEW);
        uiWindow.show();
        if (((EditUI)uiWindow.getUIObject()).isSaved()) {
            KDTable table;
            IRow endRow;
            this.loadBillInfo2UI((IObjectValue)this.bizLeaseBill.getValue());
            if (((FaPayModeEnum)((Object)this.combPayMode.getSelectedItem())).getValue() == 5 && (endRow = (table = this.detailUI.getDetailTable()).getRow(table.getRowCount() - 1)) != null && endRow.getCell("id").getValue() != null) {
                this.actionAddPayment_actionPerformed(null);
            }
        }
    }

    @Override
    public void actionTraceLeaseBill_actionPerformed(ActionEvent e) throws Exception {
        if (this.bizLeaseBill.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        IObjectValue bill = (IObjectValue)this.bizLeaseBill.getValue();
        HashMap idList = new HashMap();
        BOSObjectType bosType = bill.getBOSType();
        Vector<String> v = new Vector<String>();
        v.add(bill.getBOSUuid("id").toString());
        idList.put(bosType.toString(), v);
        FaClientUtils.showTraceUI((CoreUI)this, idList, 0);
    }

    @Override
    public void actionTraceVoucher_actionPerformed(ActionEvent e) throws Exception {
        HashMap idList;
        int rowIndex;
        IRow row;
        String id;
        KDTable _table = this.detailUI.getDetailTable();
        if (_table.getSelectManager().get() == null || _table.getSelectManager().get().getBeginRow() < 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if ((id = (String)(row = _table.getRow(rowIndex = _table.getSelectManager().get().getBeginRow())).getCell("id").getValue()) == null || id.trim().length() == 0) {
            throw new BTPException(BTPException.DESTBILLNULL);
        }
        IBOTRelation iBotRelation = BOTRelationFactory.getRemoteInstance();
        BOTRelationCollection relationCollection = iBotRelation.getCollection(new EntityViewInfo("where srcObjectID ='" + id + "' and destEntityID ='" + VOUCHERTYPE + "'"));
        if (relationCollection != null && relationCollection.size() > 0) {
            idList = new HashMap();
            if (relationCollection.get(0).getDestObjectID() != null) {
                BOSObjectType bosType = new VoucherInfo().getBOSType();
                Vector<String> v = new Vector<String>();
                v.add(relationCollection.get(0).getDestObjectID().toString());
                idList.put(bosType.toString(), v);
            }
            if (idList.size() <= 0) {
                throw new BTPException(BTPException.DESTBILLNULL);
            }
        } else {
            throw new BTPException(BTPException.DESTBILLNULL);
        }
        FaClientUtils.showTraceUI((CoreUI)this, idList, 0);
    }

    @Override
    public void actionReceivement_actionPerformed(ActionEvent e) throws Exception {
        this.showPaymentUI(Boolean.FALSE);
    }

    private void afterOnload() {
        this.actionAudit.setVisible(false);
        this.actionSave.setVisible(false);
        this.actionSubmit.setVisible(false);
        this.txtHireNaturalAmt.setDataType(1);
        this.txtHireNaturalAmt.setHorizontalAlignment(4);
        this.txtHireNaturalAmt.setRemoveingZeroInDispaly(false);
        this.txtHireNaturalAmt.setPrecision(this.currencyScale);
        this.txtHireOriginAmt.setDataType(1);
        this.txtHireOriginAmt.setHorizontalAlignment(4);
        this.txtHireOriginAmt.setRemoveingZeroInDispaly(false);
        this.txtBargainTime.setDataType(0);
        this.txtBargainTime.setHorizontalAlignment(4);
        this.txtBargainTime.setRemoveingZeroInDispaly(false);
        this.txtRemainTime.setDataType(0);
        this.txtRemainTime.setHorizontalAlignment(4);
        this.txtRemainTime.setRemoveingZeroInDispaly(false);
        this.txtLeasedTime.setDataType(0);
        this.txtLeasedTime.setHorizontalAlignment(4);
        this.txtLeasedTime.setRemoveingZeroInDispaly(false);
        this.hideOrShowAuditResult(false);
        this.hideOrShowWorkflow(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        Icon icon = EASResource.getIcon((String)"imgTbtn_sequencecheck");
        this.btnPayment.setIcon(EASResource.getIcon((String)"imgTbtn_payment"));
        this.btnReceivement.setIcon(EASResource.getIcon((String)"imgTbtn_gathering"));
        this.btnTraceLeaseBill.setIcon(icon);
        this.btnTraceVoucher.setIcon(icon);
        this.menuItemPayment.setIcon(EASResource.getIcon((String)"imgTbtn_payment"));
        this.menuItemReceivement.setIcon(EASResource.getIcon((String)"imgTbtn_gathering"));
        this.menuItemTraceLeaseBill.setIcon(icon);
        this.menuItemTraceVoucher.setIcon(icon);
        this.btnAddPayment.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelPayment.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.kDContainer1.removeButton((JButton)this.btnAddPayment);
        this.kDContainer1.removeButton((JButton)this.btnDelPayment);
        this.kDContainer1.addButton((JButton)this.btnAddPayment);
        this.kDContainer1.addButton((JButton)this.btnDelPayment);
    }

    protected void initListener() {
        super.initListener();
        this.bizLeaseType.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                String newId;
                String oldId;
                if (e.getOldValue() != null && e.getNewValue() != null && (oldId = ((ObjectBaseInfo)e.getOldValue()).getId().toString()).compareTo(newId = ((ObjectBaseInfo)e.getNewValue()).getId().toString()) == 0) {
                    return;
                }
                FaLeaseBalanceUI.this.initLeaseBillF7();
            }
        });
        this.comboLeaseDC.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FaLeaseBalanceUI.this.initLeaseBillF7();
                FaLeaseBalanceUI.this.detailUI.getDetailTable().removeRows();
            }
        });
        this.bizLeaseBill.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                FaLeaseBalanceUI.this.loadBillInfo2UI((IObjectValue)((CoreBillBaseInfo)e.getNewValue()));
            }
        });
        final KDTable _table = this.detailUI.getDetailTable();
        _table.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                IRow row;
                String id;
                int rowIndex;
                if (e.getClickCount() == 2 && (rowIndex = _table.getSelectManager().get().getBeginRow()) >= 0 && _table.getRow(rowIndex) != null && (id = (String)(row = _table.getRow(rowIndex)).getCell("id").getValue()) != null) {
                    try {
                        FaLeaseBalanceUI.this.showPaymentUI(row.getCell("isPayment").getValue().equals(EASResource.getString((String)FaLeaseBalanceUI.RES_PATH, (String)"paymentBill")));
                    }
                    catch (Exception e1) {
                        FaLeaseBalanceUI.this.handleException(e1);
                    }
                }
            }
        });
    }

    private void loadBillInfo2UI(IObjectValue info) {
        if (info == null) {
            this.txtBargainNum.setText(null);
            this.txtBargainTime.setValue(null);
            this.txtHireBalanceType.setText(null);
            this.txtHireNaturalAmt.setValue(null);
            this.txtHireOriginAmt.setValue(null);
            this.txtLeasedTime.setText(null);
            this.txtMeasureUnit.setText(null);
            this.txtRemainTime.setText(null);
            this.pkBeginDate.setValue(null);
            this.pkEndDate.setValue(null);
            this.combPayMode.setSelectedIndex(0);
            this.comboHireCurrency.setSelectedItem(null);
            this.actionAddPayment.setEnabled(false);
            this.btnAddPayment.setVisible(false);
            this.actionDelPayment.setEnabled(false);
            this.btnDelPayment.setVisible(false);
        } else {
            int payMode;
            FaBillBaseInfo leaseInfo;
            boolean isLeaseOutBill = info.getBOSType().toString().equals(new FaLeaseBillInfo().getBOSType().toString());
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add("hireCurrency.number");
            sic.add("hireCurrency.name");
            sic.add(isLeaseOutBill ? "hireBalanceType.name" : "settlType.name");
            sic.add("balanceEntry.measureUnit");
            sic.add("balanceEntry.shouldPayment");
            sic.add("balanceEntry.seq");
            try {
                info = DynamicObjectFactory.getRemoteInstance().getValue(info.getBOSType(), (IObjectPK)new ObjectUuidPK(info.getBOSUuid("id")), sic);
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
                SysUtil.abort();
            }
            try {
                this.detailUI.setPayMode(null);
                this.detailUI.fillData(info);
            }
            catch (Exception e) {
                this.handleException(e);
                SysUtil.abort();
            }
            DateUnitEnum measureUnit = null;
            SelectorItemCollection currencySic = new SelectorItemCollection();
            currencySic.add(new String("precision"));
            if (isLeaseOutBill) {
                int i;
                leaseInfo = (FaLeaseBillInfo)info;
                this.txtBargainNum.setText(((AbstractFaLeaseBillInfo)leaseInfo).getBargainNum());
                this.txtBargainTime.setValue((Object)((AbstractFaLeaseBillInfo)leaseInfo).getBargainTime());
                this.txtHireBalanceType.setText(((AbstractFaLeaseBillInfo)leaseInfo).getHireBalanceType() == null ? null : ((AbstractFaLeaseBillInfo)leaseInfo).getHireBalanceType().getName());
                this.txtHireNaturalAmt.setValue((Object)((AbstractFaLeaseBillInfo)leaseInfo).getHireNaturalAmt());
                this.txtHireOriginAmt.setValue((Object)((AbstractFaLeaseBillInfo)leaseInfo).getHireOriginAmt());
                this.txtMeasureUnit.setText(((AbstractFaLeaseBillInfo)leaseInfo).getMeasureUnit().toString());
                this.pkBeginDate.setValue((Object)((AbstractFaLeaseBillInfo)leaseInfo).getBeginDate());
                this.pkEndDate.setValue((Object)((AbstractFaLeaseBillInfo)leaseInfo).getEndDate());
                this.combPayMode.setSelectedItem((Object)((AbstractFaLeaseBillInfo)leaseInfo).getPayMode());
                int size = this.currencyCollection.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    if (!this.currencyCollection.get(i2).getId().equals((Object)((AbstractFaLeaseBillInfo)leaseInfo).getHireCurrency().getId())) continue;
                    this.comboHireCurrency.setSelectedItem((Object)this.currencyCollection.get(i2));
                }
                CurrencyInfo oriCurrency = null;
                try {
                    oriCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(((AbstractFaLeaseBillInfo)leaseInfo).getHireCurrency().getId()), currencySic);
                }
                catch (Exception e) {
                    this.handleException(e);
                    SysUtil.abort();
                }
                this.txtHireOriginAmt.setPrecision(oriCurrency.getPrecision());
                measureUnit = ((AbstractFaLeaseBillInfo)leaseInfo).getMeasureUnit();
                FaLeaseBalanceOutEntryCollection outEntries = ((AbstractFaLeaseBillInfo)leaseInfo).getBalanceEntry();
                outEntries = FaLeaseUtils.resortBalanceOut(outEntries);
                String[] timeZone = outEntries.size() == 0 ? null : new String[outEntries.size()];
                for (i = 0; i < outEntries.size(); ++i) {
                    timeZone[i] = outEntries.get(i).getMeasureUnit();
                }
                payMode = ((AbstractFaLeaseBillInfo)leaseInfo).getPayMode().getValue();
                timeZone = FaLeaseUtils.formatTimeZone(payMode, timeZone);
                for (i = 0; i < this.detailUI.getDetailTable().getRowCount(); ++i) {
                    if (outEntries == null || outEntries.get(i) == null) continue;
                    this.detailUI.getDetailTable().getCell(i, "measureUnit").setValue(timeZone == null ? null : timeZone[i]);
                    this.detailUI.getDetailTable().getCell(i, "shouldPayment").setValue((Object)outEntries.get(i).getShouldPayment());
                }
            } else {
                int i;
                leaseInfo = (FaLeaseInBillInfo)info;
                this.txtBargainNum.setText(((AbstractFaLeaseInBillInfo)leaseInfo).getBargainNum());
                this.txtBargainTime.setValue((Object)((AbstractFaLeaseInBillInfo)leaseInfo).getBargainTime());
                this.txtHireBalanceType.setText(((AbstractFaLeaseInBillInfo)leaseInfo).getSettlType() == null ? null : ((AbstractFaLeaseInBillInfo)leaseInfo).getSettlType().getName());
                this.txtHireNaturalAmt.setValue((Object)((AbstractFaLeaseInBillInfo)leaseInfo).getHireNaturalAmt());
                this.txtHireOriginAmt.setValue((Object)((AbstractFaLeaseInBillInfo)leaseInfo).getHireOriginAmt());
                this.txtMeasureUnit.setText(((AbstractFaLeaseInBillInfo)leaseInfo).getMeasureUnit().toString());
                this.pkBeginDate.setValue((Object)((AbstractFaLeaseInBillInfo)leaseInfo).getBeginDate());
                this.pkEndDate.setValue((Object)((AbstractFaLeaseInBillInfo)leaseInfo).getEndDate());
                this.combPayMode.setSelectedItem((Object)((AbstractFaLeaseInBillInfo)leaseInfo).getPayMode());
                int size = this.currencyCollection.size();
                for (int i3 = 0; i3 < size; ++i3) {
                    if (!this.currencyCollection.get(i3).getId().equals((Object)((AbstractFaLeaseInBillInfo)leaseInfo).getHireCurrency().getId())) continue;
                    this.comboHireCurrency.setSelectedItem((Object)this.currencyCollection.get(i3));
                }
                CurrencyInfo oriCurrency = null;
                try {
                    oriCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(((AbstractFaLeaseInBillInfo)leaseInfo).getHireCurrency().getId()), currencySic);
                }
                catch (Exception e) {
                    this.handleException(e);
                    SysUtil.abort();
                }
                this.txtHireOriginAmt.setPrecision(oriCurrency.getPrecision());
                measureUnit = ((AbstractFaLeaseInBillInfo)leaseInfo).getMeasureUnit();
                FaLeaseBalanceInEntryCollection inEntries = ((AbstractFaLeaseInBillInfo)leaseInfo).getBalanceEntry();
                inEntries = FaLeaseUtils.resortBalanceIn(inEntries);
                String[] timeZone = inEntries.size() == 0 ? null : new String[inEntries.size()];
                for (i = 0; i < inEntries.size(); ++i) {
                    timeZone[i] = inEntries.get(i).getMeasureUnit();
                }
                payMode = ((AbstractFaLeaseInBillInfo)leaseInfo).getPayMode().getValue();
                timeZone = FaLeaseUtils.formatTimeZone(payMode, timeZone);
                for (i = 0; i < this.detailUI.getDetailTable().getRowCount(); ++i) {
                    if (inEntries == null || inEntries.get(i) == null) continue;
                    this.detailUI.getDetailTable().getCell(i, "measureUnit").setValue(timeZone == null ? null : timeZone[i]);
                    this.detailUI.getDetailTable().getCell(i, "shouldPayment").setValue((Object)inEntries.get(i).getShouldPayment());
                }
            }
            boolean showButton = payMode == 5 && info.getInt("bizStatus") != 5;
            this.actionAddPayment.setEnabled(showButton);
            this.btnAddPayment.setVisible(showButton);
            this.actionDelPayment.setEnabled(showButton);
            this.btnDelPayment.setVisible(showButton);
            this.calLeaseTime(measureUnit);
        }
    }

    private void calLeaseTime(DateUnitEnum measureUnit) {
        Date beginDate = this.pkBeginDate.getSqlDate();
        Date endDate = this.pkEndDate.getSqlDate();
        BigDecimal bargainTime = this.txtBargainTime.getBigDecimalValue();
        BigDecimal leasedTime = FaClientUtils.calLeasedTime(beginDate, endDate, bargainTime, measureUnit);
        this.txtLeasedTime.setValue((Object)leasedTime);
        this.txtRemainTime.setValue((Object)this.txtBargainTime.getBigDecimalValue().subtract(leasedTime));
    }

    private void initLeaseBillF7() {
        IntEnum item = (IntEnum)this.comboLeaseDC.getSelectedItem();
        this.bizLeaseBill.setValue(null);
        this.bizLeaseBill.getQueryAgent().resetRuntimeEntityView();
        this.lblBillName.setBoundLabelText(item.getValue() == 0 ? EASResource.getString((String)RES_PATH, (String)"faLeaseBill") : EASResource.getString((String)RES_PATH, (String)"faLeaseInBill"));
        Object data = this.bizLeaseType.getValue();
        if (data == null) {
            this.bizLeaseBill.setEnabled(false);
        } else {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.getCurCompany().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(2), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("hireNaturalAmt", (Object)new BigDecimal("0"), CompareType.GREATER));
            if (item.getValue() == 0) {
                this.bizLeaseBill.setQueryInfo("com.kingdee.eas.fi.fa.manage.FaLeaseBillF7");
                filter.getFilterItems().add(new FilterItemInfo("faLeaseType.id", (Object)((ObjectBaseInfo)this.bizLeaseType.getValue()).getId().toString()));
            } else {
                this.bizLeaseBill.setQueryInfo("com.kingdee.eas.fi.fa.manage.FaLeaseInBillF7");
                filter.getFilterItems().add(new FilterItemInfo("leaseType.id", (Object)((ObjectBaseInfo)this.bizLeaseType.getValue()).getId().toString()));
            }
            this.bizLeaseBill.getQueryAgent().setDefaultFilterInfo(filter);
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            this.bizLeaseBill.setEntityViewInfo(view);
            this.bizLeaseBill.setEnabled(true);
            this.bizLeaseBill.addCommonF7KDTableListener(new CommonF7KDTableListener(){

                public void onTableStructureCreated(final KDTable table) {
                    int baseScale = 0;
                    try {
                        baseScale = FaClientUtils.getCurrencyScale();
                    }
                    catch (Exception e1) {
                        FaLeaseBalanceUI.this.handleException(e1);
                        SysUtil.abort();
                    }
                    table.checkParsed();
                    final String baseNumberFmt = FaClientUtils.getFormatPatternForColumn(baseScale);
                    final String zeroPrecisionFmt = FaClientUtils.getFormatPatternForColumn(0);
                    table.addKDTDataFillListener(new KDTDataFillListener(){

                        public void afterDataFill(KDTDataRequestEvent e) {
                            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                                IRow row = table.getRow(i);
                                int hireScale = Integer.parseInt(row.getCell("hireCurrency.precision").getValue().toString());
                                int subsScale = Integer.parseInt(row.getCell("subsCurrency.precision").getValue().toString());
                                table.getColumn("hireOriginAmt").getStyleAttributes().setNumberFormat(FaClientUtils.getFormatPatternForColumn(hireScale));
                                table.getColumn("hireNaturalAmt").getStyleAttributes().setNumberFormat(baseNumberFmt);
                                table.getColumn("subsOriginAmt").getStyleAttributes().setNumberFormat(FaClientUtils.getFormatPatternForColumn(subsScale));
                                table.getColumn("subsNaturalAmt").getStyleAttributes().setNumberFormat(baseNumberFmt);
                                table.getColumn("bargainTime").getStyleAttributes().setNumberFormat(zeroPrecisionFmt);
                            }
                        }
                    });
                }
            });
        }
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        KDLayout.Constraints constraints = new KDLayout.Constraints(0, 7, 986, 490, 15);
        this.kDContainer1.getContentPane().add((Component)((Object)this.detailUI), constraints);
    }

    @Override
    public void actionAddPayment_actionPerformed(ActionEvent e) throws Exception {
        if (this.actionAddPayment.isEnabled()) {
            this.detailUI.addRow((IObjectValue)this.bizLeaseBill.getValue());
        }
    }

    @Override
    public void actionDelPayment_actionPerformed(ActionEvent e) throws Exception {
        this.detailUI.removeRow((IObjectValue)this.bizLeaseBill.getValue());
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.detailUI.getDetailTable());
        this.detailUI.getDetailTable().getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.detailUI.getDetailTable());
        this.detailUI.getDetailTable().getPrintManager().printPreview();
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        IObjectValue value = (IObjectValue)this.bizLeaseBill.getValue();
        if (value == null) {
            return;
        }
        String leaseOut_str = EASResource.getString((String)RES_PATH, (String)"faLeaseBill");
        String leaseIn_str = EASResource.getString((String)RES_PATH, (String)"faLeaseInBill");
        StyleAttributes sa = Styles.getDefaultSA();
        sa.setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        boolean isLeaseOut = value.getBOSType().toString().equals(new FaLeaseBillInfo().getBOSType().toString());
        StringBuffer sb = new StringBuffer(this.getCurCompany().getName() + "-");
        sb.append(isLeaseOut ? leaseOut_str : leaseIn_str).append(":" + value.getString("number"));
        sb.append(" &| &|");
        header.addRow(sb.toString(), sa);
    }

    protected boolean isAllowLoadPrintSetting() {
        return false;
    }
}

