/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.fa.basedata.FaLeaseTypeInfo;
import com.kingdee.eas.fi.fa.basedata.FaUtils;
import com.kingdee.eas.fi.fa.def.FaDefPropertyValueFactory;
import com.kingdee.eas.fi.fa.def.FaDefPropertyValueInfo;
import com.kingdee.eas.fi.fa.def.meta.FaDefEntityManager;
import com.kingdee.eas.fi.fa.manage.DateUnitEnum;
import com.kingdee.eas.fi.fa.manage.FALeaseContractCollection;
import com.kingdee.eas.fi.fa.manage.FALeaseContractFactory;
import com.kingdee.eas.fi.fa.manage.FALeaseContractInfo;
import com.kingdee.eas.fi.fa.manage.FaBillOriginEnum;
import com.kingdee.eas.fi.fa.manage.FaCardInfo;
import com.kingdee.eas.fi.fa.manage.FaChangeBillInfo;
import com.kingdee.eas.fi.fa.manage.FaClearBillInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceBillFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceBillInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceOutEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceOutEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseBillCollection;
import com.kingdee.eas.fi.fa.manage.FaLeaseBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaLeaseBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseBillFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseBillInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaPayModeEnum;
import com.kingdee.eas.fi.fa.manage.IFaLeaseBill;
import com.kingdee.eas.fi.fa.manage.LeaseBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaLeaseBillEditUI;
import com.kingdee.eas.fi.fa.manage.client.CommonQueryWithResultDialog;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.manage.client.FaLeaseUtils;
import com.kingdee.eas.fi.fa.manage.client.FaPrintHelper;
import com.kingdee.eas.fi.fa.manage.client.FaScanBarCodesEditUI;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.lcm.client.LCMClientUtils;
import com.kingdee.eas.framework.BillBaseCollection;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class FaLeaseBillEditUI
extends AbstractFaLeaseBillEditUI {
    private static final long serialVersionUID = 1829225615570469055L;
    private static final Logger logger = CoreUIObject.getLogger(FaLeaseBillEditUI.class);
    private static final String RES_PATH = "com.kingdee.eas.fi.fa.manage.FaLeaseResource";
    private static final String WORK_LEASE_TYPE = "001";
    private static final BigDecimal DEFAULT_BARGAINTIME = new BigDecimal("1.0");
    private CurrencyInfo baseCurrency;
    private CurrencyCollection initCurrencyCollection;
    protected static final String FROM_LINK = "Link";
    private boolean balanceModify = true;
    private boolean initDefPropertyBind = false;
    private int scale = 0;
    private int hireConvertMode = 0;
    private int subsConvertMode = 0;
    private static final String HIRE_TYPE = "hire_type";
    private static final String SUBS_TYPE = "subs_type";
    private boolean fromLink = false;
    private KDFormattedTextField textField = new KDFormattedTextField();
    private static final String VOUCHERTYPE = new VoucherInfo().getBOSType().toString();

    @Override
    protected boolean isNeedCodeRule() {
        return true;
    }

    @Override
    public void onLoad() throws Exception {
        if (this.getUIContext().get(FROM_LINK) != null && this.getUIContext().get(FROM_LINK).equals(Boolean.TRUE)) {
            this.menuBar.removeAll();
            this.menuBar.setVisible(false);
            this.toolBar.removeAll();
            this.toolBar.add((Component)new KDLabel());
            this.fromLink = true;
        }
        super.onLoad();
        this.menuItemAudit.setAccelerator(KeyStroke.getKeyStroke("ctrl U"));
        this.menuItemUnAudit.setAccelerator(KeyStroke.getKeyStroke("ctrl shift U"));
        this.leaseTable.checkParsed();
        FaUtils.freezeTable((KDTable)this.leaseTable, (int)4);
        this.leaseTable.getStyleAttributes().setLocked(true);
        this.leaseTable.getSelectManager().setSelectMode(2);
        this.scale = this.getCurrencyScale();
        FaClientUtils.changeTableNumberFormat(this.leaseTable, new String[]{"shouldPayment", "actualPayment", "realPayment"}, FaClientUtils.getDecimalFormat(this.scale));
        FaClientUtils.changeTableTextFormat(this.leaseTable, new String[]{"balanceNumber", "relatedNumber"});
        this.textField.setDataType(1);
        this.textField.setHorizontalAlignment(4);
        this.textField.setNegatived(false);
        this.textField.setPrecision(this.scale);
        this.textField.setMaximumValue((Comparable)FaClientUtils.MAX_DECIMAL);
        this.textField.setMinimumValue((Comparable)ZERO);
        this.leaseTable.getColumn("shouldPayment").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)this.textField));
        this.leaseTable.getColumn("shouldPayment").getStyleAttributes().setNumberFormat(FaClientUtils.getDecimalFormat(this.scale));
        this.leaseTable.getColumn("shouldPayment").getStyleAttributes().setLocked(false);
        this.btnScanPitch.setIcon(EASResource.getIcon((String)"imgTbtn_applycondition"));
        this.actionScanPitch.setEnabled(false);
        this.actionScanPitch.setVisible(false);
        boolean isUseBarCode = Boolean.valueOf(String.valueOf(this.getFaParameter().get("FA_043")));
        if (isUseBarCode) {
            this.actionScanPitch.setEnabled(true);
            this.actionScanPitch.setVisible(true);
        }
        this.detailTable.getColumn("barCode").getStyleAttributes().setHided(!isUseBarCode);
        if (this.editData != null && this.editData.getCheckedStatus() != null) {
            if (this.editData.getCheckedStatus().getValue() == 2 || OprtState.VIEW.equals(this.getOprtState())) {
                this.actionScanPitch.setEnabled(false);
            } else {
                this.actionScanPitch.setEnabled(true);
            }
        }
        this.bindDefProperty();
    }

    @Override
    protected HashMap getFaParameter() throws Exception {
        if (this.faParameter == null) {
            this.faParameter = FaClientUtils.getFAParameter(this.getCurrentCompany().getId());
        }
        return this.faParameter;
    }

    private CompanyOrgUnitInfo getCurrentCompany() throws Exception {
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        String companyId = null;
        companyId = FaClientUtils.isFromLink((CoreUIObject)this) ? (String)this.getUIContext().get("COMPANY_ID") : SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("accountPeriodType.id"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("reportCurrency.id"));
        sic.add(new SelectorItemInfo("reportCurrency.number"));
        sic.add(new SelectorItemInfo("reportCurrency.name"));
        sic.add(new SelectorItemInfo("baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("reportExchangeTable.id"));
        companyOrgUnitInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyId)), sic);
        return companyOrgUnitInfo;
    }

    protected void initListener() {
        super.initListener();
        this.getDetailTable().addKDTPropertyChangeListener(new KDTPropertyChangeListener(){

            public void propertyChange(KDTPropertyChangeEvent e) {
                FaLeaseBillEditUI.this.actionValueChanged(e);
            }
        });
        this.pkBeginDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if ("ADDNEW".equals(FaLeaseBillEditUI.this.getOprtState()) || "EDIT".equals(FaLeaseBillEditUI.this.getOprtState())) {
                    if (!FaLeaseBillEditUI.this.calEndDate()) {
                        FaLeaseBillEditUI.this.pkBeginDate.setValue(e.getOldValue());
                    }
                    FaLeaseBillEditUI.this.calLeaseTime();
                }
            }
        });
        this.pkEndDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if ("ADDNEW".equals(FaLeaseBillEditUI.this.getOprtState()) || "EDIT".equals(FaLeaseBillEditUI.this.getOprtState())) {
                    for (int i = 0; i < FaLeaseBillEditUI.this.detailTable.getRowCount(); ++i) {
                        FaLeaseBillEditUI.this.calEntryHireAmt(i);
                    }
                    FaLeaseBillEditUI.this.calTotalHireAmt();
                }
            }
        });
        this.prmtFaLeaseType.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                FaLeaseBillEditUI.this.setHideDetailColumn();
            }
        });
        this.txtBargainTime.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if ("ADDNEW".equals(FaLeaseBillEditUI.this.getOprtState()) || "EDIT".equals(FaLeaseBillEditUI.this.getOprtState())) {
                    if (!FaLeaseBillEditUI.this.calEndDate() || FaLeaseBillEditUI.this.txtBargainTime.getBigDecimalValue().floatValue() < 1.0f) {
                        FaLeaseBillEditUI.this.txtBargainTime.setValue(e.getOldValue());
                    }
                    FaLeaseBillEditUI.this.calLeaseTime();
                }
            }
        });
        this.comboMeasureUnit.addItemListener(new ItemListener(){
            Object oldValue = null;

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    this.oldValue = e.getItem();
                }
                if (e.getStateChange() == 1) {
                    if (!FaLeaseBillEditUI.this.calEndDate()) {
                        FaLeaseBillEditUI.this.comboMeasureUnit.setSelectedItem(this.oldValue);
                    }
                    FaLeaseBillEditUI.this.calLeaseTime();
                }
            }
        });
        this.comboBoxPayMode.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FaLeaseBillEditUI.this.setHireAmtColumnTitle();
                    if ("ADDNEW".equals(FaLeaseBillEditUI.this.getOprtState()) || "EDIT".equals(FaLeaseBillEditUI.this.getOprtState())) {
                        for (int i = 0; i < FaLeaseBillEditUI.this.detailTable.getRowCount(); ++i) {
                            FaLeaseBillEditUI.this.calEntryHireAmt(i);
                        }
                        FaLeaseBillEditUI.this.calTotalHireAmt();
                    }
                }
            }
        });
        this.comboBoxPayMode.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FaLeaseBillEditUI.this.setHireAmtColumnTitle();
                if ("ADDNEW".equals(FaLeaseBillEditUI.this.getOprtState()) || "EDIT".equals(FaLeaseBillEditUI.this.getOprtState())) {
                    for (int i = 0; i < FaLeaseBillEditUI.this.detailTable.getRowCount(); ++i) {
                        FaLeaseBillEditUI.this.calEntryHireAmt(i);
                    }
                    FaLeaseBillEditUI.this.calTotalHireAmt();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if ("ADDNEW".equals(FaLeaseBillEditUI.this.getOprtState()) || "EDIT".equals(FaLeaseBillEditUI.this.getOprtState())) {
                    for (int i = 0; i < FaLeaseBillEditUI.this.detailTable.getRowCount(); ++i) {
                        FaLeaseBillEditUI.this.calEntryHireAmt(i);
                    }
                    FaLeaseBillEditUI.this.calTotalHireAmt();
                }
            }
        });
        this.comboHireCurrency.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FaLeaseBillEditUI.this.comboHireCurrency_itemStateChanged(e);
            }
        });
        this.txtHireExRate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if ("ADDNEW".equals(FaLeaseBillEditUI.this.getOprtState()) || "EDIT".equals(FaLeaseBillEditUI.this.getOprtState())) {
                    FaLeaseBillEditUI.this.hireExRateChanged();
                    FaLeaseBillEditUI.this.calcTotalAmount();
                }
            }
        });
        this.comboSubsCurrency.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FaLeaseBillEditUI.this.comboSubsCurrency_itemStateChanged(e);
            }
        });
        this.txtSubsExRate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if ("ADDNEW".equals(FaLeaseBillEditUI.this.getOprtState()) || "EDIT".equals(FaLeaseBillEditUI.this.getOprtState())) {
                    FaLeaseBillEditUI.this.calSubsLocalAmt();
                }
            }
        });
        this.txtSubsOriginAmt.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if ("ADDNEW".equals(FaLeaseBillEditUI.this.getOprtState()) || "EDIT".equals(FaLeaseBillEditUI.this.getOprtState())) {
                    FaLeaseBillEditUI.this.calSubsLocalAmt();
                }
            }
        });
        this.detailTable.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                FaLeaseBillEditUI.this.calAmount(e);
                FaLeaseBillEditUI.this.setHireAmtColumnTitle();
            }
        });
    }

    private void loadLeaseDetail() {
        FaLeaseBalanceOutEntryCollection resultCollection = new FaLeaseBalanceOutEntryCollection();
        if (this.editData.getBalanceEntry() != null) {
            resultCollection = FaLeaseUtils.resortBalanceOut(this.editData.getBalanceEntry());
        }
        String[] timeZone = resultCollection.size() == 0 ? null : new String[resultCollection.size()];
        for (int i = 0; i < resultCollection.size(); ++i) {
            timeZone[i] = resultCollection.get(i).getMeasureUnit();
        }
        int payMode = this.editData.getPayMode() == null ? null : Integer.valueOf(this.editData.getPayMode().getValue());
        timeZone = FaLeaseUtils.formatTimeZone(payMode, timeZone);
        boolean timeZoneNull = false;
        if (timeZone == null || timeZone.length == 0) {
            timeZoneNull = true;
        }
        for (int i = 0; i < this.leaseTable.getRowCount(); ++i) {
            if (this.editData.getBalanceEntry() == null || this.editData.getBalanceEntry().get(i) == null) continue;
            this.leaseTable.getCell(i, "measureUnit").setValue(timeZoneNull ? null : (timeZone.length <= i ? null : timeZone[i]));
            this.leaseTable.getCell(i, "shouldPayment").setValue((Object)resultCollection.get(i).getShouldPayment());
            this.leaseTable.getCell(i, "seq").setValue((Object)resultCollection.get(i).getSeq());
        }
        if (this.leaseTable.getRowCount() > 0 && this.editData != null && this.editData.getId() != null) {
            try {
                this.loadLeaseBalance(this.editData.getId().toString());
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
    }

    @Override
    protected void initCtrlComponent() throws Exception {
        this.initNumericTxt();
        this.initDetailTable();
        this.setHireAmtColumnTitle();
        this.setHideDetailColumn();
        this.pkBeginDate.setSupportedEmpty(false);
        this.pkDeliverDate.setSupportedEmpty(false);
        FaClientUtils.changeTextField((JComponent)((Object)this), true, false);
    }

    protected void unLockUI() {
        super.unLockUI();
        this.lockLeaseContractFeild();
        this.lockCurrency();
        this.txtSubsOriginAmt.setEditable(this.comboSubsCurrency.getSelectedItem() != null);
        this.txtSubsExRate.setEditable(this.comboSubsCurrency.getSelectedItem() != null);
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        if (this.editData != null && this.editData.getCheckedStatus() != null) {
            if (this.editData.getCheckedStatus().getValue() == 2 || OprtState.VIEW.equals(this.getOprtState())) {
                this.actionScanPitch.setEnabled(false);
            } else {
                this.actionScanPitch.setEnabled(true);
            }
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.loadCurrency();
        if (this.editData != null && this.editData.getCheckedStatus() != null) {
            if (this.editData.getCheckedStatus().getValue() == 2 || OprtState.VIEW.equals(this.getOprtState())) {
                this.actionScanPitch.setEnabled(false);
            } else {
                this.actionScanPitch.setEnabled(true);
            }
        }
    }

    @Override
    protected void initBtnStatus() throws Exception {
        super.initBtnStatus();
        this.actionInsertLine.setEnabled(false);
        if (this.editData == null || this.editData.getFaLeaseType() == null) {
            return;
        }
        boolean editable = !LeaseBizStatusEnum.RELETING.equals((Object)this.editData.getBizStatus()) && ("ADDNEW".equals(this.getOprtState()) || "EDIT".equals(this.getOprtState()));
        this.actionAddLine.setEnabled(editable);
        this.actionInsertLine.setEnabled(editable);
        this.actionRemoveLine.setEnabled(editable);
    }

    private void setOrigCurrencyRate() {
        CurrencyInfo currencyInfo = (CurrencyInfo)this.comboHireCurrency.getSelectedItem();
        int scale = currencyInfo == null ? this.getCurrencyScale() : currencyInfo.getPrecision();
        this.formatTableColumn(this.detailTable, new String[]{"monOriginHireAmt", "hireOriginAmt"}, scale);
    }

    private void lockLeaseContractFeild() {
        boolean fromContract = FaBillOriginEnum.FROM_LEASECONTRACT.equals((Object)this.editData.getBillType());
        this.txtBargainNum.setEditable(!fromContract);
        this.txtSignaturePlace.setEditable(!fromContract);
        this.txtCautioner.setEditable(!fromContract);
        boolean fromRelet = LeaseBizStatusEnum.RELETING.equals((Object)this.editData.getBizStatus());
        this.txtLeaseCompany.setEditable(!fromContract && !fromRelet);
        this.txtHireCompany.setEditable(!fromContract && !fromRelet);
        this.prmtFaLeaseType.setEnabled(this.prmtFaLeaseType.getValue() == null || !LeaseBizStatusEnum.RELETING.equals((Object)this.editData.getBizStatus()));
        boolean editable = !fromRelet && ("ADDNEW".equals(this.getOprtState()) || "EDIT".equals(this.getOprtState()));
        this.actionAddLine.setEnabled(editable);
        this.actionRemoveLine.setEnabled(editable);
        if (!editable) {
            for (int i = 0; i < this.detailTable.getColumnCount(); ++i) {
                this.detailTable.getColumn(i).getStyleAttributes().setLocked(true);
            }
            editable = "ADDNEW".equals(this.getOprtState()) || "EDIT".equals(this.getOprtState());
            this.detailTable.getColumn("attornAmt").getStyleAttributes().setLocked(!editable);
            this.detailTable.getColumn("insuranceAmt").getStyleAttributes().setLocked(!editable);
        }
        editable = !fromRelet || this.editData.getFaLeaseType() == null || !"002".equals(this.editData.getFaLeaseType().getNumber());
        this.comboHireCurrency.setEnabled(editable);
        this.txtHireExRate.setEditable(editable);
        this.detailTable.getColumn("monOriginHireAmt").getStyleAttributes().setLocked(!editable);
        if (FaPayModeEnum.APERIODIC_PAY.equals(this.comboBoxPayMode.getSelectedItem()) || FaPayModeEnum.ONE_PAY.equals(this.comboBoxPayMode.getSelectedItem())) {
            this.detailTable.getColumn("hireOriginAmt").getStyleAttributes().setLocked(!editable);
        }
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        if ("ADDNEW".equals(this.getOprtState()) || "EDIT".equals(this.getOprtState())) {
            this.btnInsertCard.setEnabled(true);
            this.btnRemoveCard.setEnabled(true);
            this.getDetailTable().getStyleAttributes().setLocked(false);
        } else {
            this.btnInsertCard.setEnabled(false);
            this.btnRemoveCard.setEnabled(false);
        }
    }

    private boolean calEndDate() {
        Object measureUnit = this.comboMeasureUnit.getSelectedItem();
        java.sql.Date beginDate = this.pkBeginDate.getSqlDate();
        BigDecimal bargainTeim = this.txtBargainTime.getBigDecimalValue();
        if (beginDate != null && bargainTeim != null) {
            Date newDate = null;
            if (DateUnitEnum.DAY.equals(measureUnit)) {
                newDate = DateTimeUtils.addDay((Date)beginDate, (long)bargainTeim.intValue());
            } else if (DateUnitEnum.MONTH.equals(measureUnit)) {
                newDate = DateTimeUtils.addMonth((Date)beginDate, (int)bargainTeim.intValue());
                if (bargainTeim.doubleValue() - (double)bargainTeim.intValue() > 0.0) {
                    int maxDays = DateTimeUtils.daysOfMonth((int)DateTimeUtils.getYear((Date)newDate), (int)DateTimeUtils.getMonth((Date)newDate));
                    double days = (double)maxDays * (bargainTeim.doubleValue() - (double)bargainTeim.intValue());
                    newDate = DateTimeUtils.addDay((Date)newDate, (long)new Double(days).intValue());
                }
            } else if (DateUnitEnum.YEAR.equals(measureUnit)) {
                newDate = DateTimeUtils.addYear((Date)beginDate, (int)bargainTeim.intValue());
                if (bargainTeim.doubleValue() - (double)bargainTeim.intValue() > 0.0) {
                    Double months = new Double(12.0 * (bargainTeim.doubleValue() - (double)bargainTeim.intValue()));
                    newDate = DateTimeUtils.addMonth((Date)newDate, (int)months.intValue());
                    if (months - (double)months.intValue() > 0.0) {
                        int maxDays = DateTimeUtils.daysOfMonth((int)DateTimeUtils.getYear((Date)newDate), (int)DateTimeUtils.getMonth((Date)newDate));
                        double days = (double)maxDays * (months - (double)months.intValue());
                        newDate = DateTimeUtils.addDay((Date)newDate, (long)new Double(days).intValue());
                    }
                }
            }
            if (DateTimeUtils.getYear((Date)newDate) > 9999) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"leaseTimeOver"));
                return false;
            }
            newDate = new Date(newDate.getTime() - 86400000L);
            this.pkEndDate.setValue((Object)newDate);
        }
        return true;
    }

    private void hireExRateChanged() {
        for (int i = 0; i < this.detailTable.getRowCount(); ++i) {
            this.calMonthHireAmt(i);
            this.calEntryHireAmt(i);
        }
        this.calTotalHireAmt();
    }

    private void calSubsLocalAmt() {
        BigDecimal subsExRate = this.txtSubsExRate.getBigDecimalValue();
        BigDecimal subsOrginAmt = this.txtSubsOriginAmt.getBigDecimalValue();
        if (subsExRate != null && subsOrginAmt != null) {
            CurrencyInfo currencyInfo = (CurrencyInfo)this.comboSubsCurrency.getSelectedItem();
            int scale = currencyInfo == null ? this.getCurrencyScale() : currencyInfo.getPrecision();
            BigDecimal subsLocalAmt = FaClientUtils.getLocalAmount(this.subsConvertMode, subsExRate, scale, subsOrginAmt);
            subsLocalAmt = subsLocalAmt.setScale(scale, 4);
            this.txtSubsNaturalAmt.setValue((Object)subsLocalAmt);
        }
    }

    private void calAmount(KDTEditEvent e) {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (colIndex == this.detailTable.getColumnIndex("monOriginHireAmt")) {
            this.calMonthHireAmt(rowIndex);
            this.calEntryHireAmt(rowIndex);
            this.calTotalHireAmt();
        } else if (colIndex == this.detailTable.getColumnIndex("hireOriginAmt") && (FaPayModeEnum.ONE_PAY.equals(this.comboBoxPayMode.getSelectedItem()) || FaPayModeEnum.APERIODIC_PAY.equals(this.comboBoxPayMode.getSelectedItem()))) {
            BigDecimal originHireAmt = (BigDecimal)this.detailTable.getCell(rowIndex, "hireOriginAmt").getValue();
            BigDecimal exRate = this.txtHireExRate.getBigDecimalValue();
            if (originHireAmt != null && exRate != null) {
                BigDecimal localHireAmt = FaClientUtils.getLocalAmount(this.hireConvertMode, exRate, this.scale, originHireAmt);
                this.detailTable.getCell(rowIndex, "hireLocalAmt").setValue((Object)localHireAmt.setScale(this.getCurrencyScale(), 4));
            }
            this.calTotalHireAmt();
        } else if (colIndex == this.detailTable.getColumnIndex("hasInsurance")) {
            this.doDetailInsurance(rowIndex);
        }
        if (e.getValue() instanceof BigDecimal) {
            this.calcTotalAmount();
        }
    }

    private void doDetailInsurance(int rowIndex) {
        Boolean hasInsurance = (Boolean)this.detailTable.getCell(rowIndex, "hasInsurance").getValue();
        if (hasInsurance.booleanValue()) {
            this.detailTable.getCell(rowIndex, "insuranceAmt").getStyleAttributes().setLocked(!"ADDNEW".equals(this.getOprtState()) && !"EDIT".equals(this.getOprtState()));
        } else {
            this.detailTable.getCell(rowIndex, "insuranceAmt").setValue(null);
            this.detailTable.getCell(rowIndex, "insuranceAmt").getStyleAttributes().setLocked(true);
        }
    }

    private void doInsurance() {
        for (int i = 0; i < this.getDetailTable().getRowCount(); ++i) {
            this.doDetailInsurance(i);
        }
    }

    private void calMonthHireAmt(int rowIndex) {
        BigDecimal monOriginHireAmt = (BigDecimal)this.detailTable.getCell(rowIndex, "monOriginHireAmt").getValue();
        BigDecimal exRate = this.txtHireExRate.getBigDecimalValue();
        if (monOriginHireAmt != null && exRate != null) {
            BigDecimal monLocalHireAmt = FaClientUtils.getLocalAmount(this.hireConvertMode, exRate, this.scale, monOriginHireAmt);
            this.detailTable.getCell(rowIndex, "monLocalHireAmt").setValue((Object)monLocalHireAmt.setScale(this.getCurrencyScale(), 4));
        }
    }

    private void calEntryHireAmt(int rowIndex) {
        BigDecimal monOriginHireAmt = (BigDecimal)this.detailTable.getCell(rowIndex, "monOriginHireAmt").getValue();
        BigDecimal exRate = this.txtHireExRate.getBigDecimalValue();
        BigDecimal hireOrginAmt = ZERO;
        BigDecimal hireLocalAmt = ZERO;
        DateUnitEnum measureUnit = (DateUnitEnum)((Object)this.comboMeasureUnit.getSelectedItem());
        java.sql.Date beginDate = this.pkBeginDate.getSqlDate();
        java.sql.Date endDate = this.pkEndDate.getSqlDate();
        int bargainTime = this.txtBargainTime.getBigDecimalValue().intValue();
        String[] timeZone = null;
        int lineCount = Integer.MAX_VALUE;
        if (FaPayModeEnum.YEAR_PAY.equals(this.comboBoxPayMode.getSelectedItem())) {
            timeZone = FaLeaseUtils.getYearZone(beginDate, endDate);
            lineCount = measureUnit == DateUnitEnum.YEAR ? bargainTime : (measureUnit == DateUnitEnum.MONTH ? (int)Math.ceil((double)bargainTime / 12.0) : Integer.MAX_VALUE);
        } else if (FaPayModeEnum.SEASON_PAY.equals(this.comboBoxPayMode.getSelectedItem())) {
            timeZone = FaLeaseUtils.getSeasonZone(beginDate, endDate);
            lineCount = measureUnit == DateUnitEnum.YEAR ? bargainTime * 4 : (measureUnit == DateUnitEnum.MONTH ? (int)Math.ceil((double)bargainTime / 3.0) : Integer.MAX_VALUE);
        } else if (FaPayModeEnum.MONTH_PAY.equals(this.comboBoxPayMode.getSelectedItem())) {
            timeZone = FaLeaseUtils.getMonthZone(beginDate, endDate);
            lineCount = measureUnit == DateUnitEnum.YEAR ? bargainTime * 12 : (measureUnit == DateUnitEnum.MONTH ? bargainTime : Integer.MAX_VALUE);
        } else if (FaPayModeEnum.DAY_PAY.equals(this.comboBoxPayMode.getSelectedItem())) {
            timeZone = FaLeaseUtils.getDayZone(beginDate, endDate);
        } else {
            return;
        }
        lineCount = Math.min(timeZone.length, lineCount);
        hireOrginAmt = monOriginHireAmt == null ? ZERO : monOriginHireAmt.multiply(new BigDecimal(lineCount));
        this.detailTable.getCell(rowIndex, "hireOriginAmt").setValue((Object)hireOrginAmt);
        if (exRate != null) {
            hireLocalAmt = FaClientUtils.getLocalAmount(this.hireConvertMode, exRate, this.scale, hireOrginAmt);
            hireLocalAmt = hireLocalAmt.setScale(this.getCurrencyScale(), 4);
            this.detailTable.getCell(rowIndex, "hireLocalAmt").setValue((Object)hireLocalAmt);
        }
    }

    private void calTotalHireAmt() {
        BigDecimal totalHireOrginAmt = ZERO;
        BigDecimal totalHireLocalAmt = ZERO;
        for (int i = 0; i < this.detailTable.getRowCount(); ++i) {
            BigDecimal hireLocalAmt;
            BigDecimal hireOrginAmt = (BigDecimal)this.detailTable.getCell(i, "hireOriginAmt").getValue();
            if (hireOrginAmt != null) {
                totalHireOrginAmt = totalHireOrginAmt.add(hireOrginAmt);
            }
            if ((hireLocalAmt = (BigDecimal)this.detailTable.getCell(i, "hireLocalAmt").getValue()) == null) continue;
            totalHireLocalAmt = totalHireLocalAmt.add(hireLocalAmt);
        }
        this.txtHireOriginAmt.setValue((Object)totalHireOrginAmt);
        this.txtHireNaturalAmt.setValue((Object)totalHireLocalAmt);
    }

    private void setHireAmtColumnTitle() {
        if (this.comboBoxPayMode.getSelectedItem() == FaPayModeEnum.ONE_PAY || this.comboBoxPayMode.getSelectedItem() == FaPayModeEnum.APERIODIC_PAY) {
            int i;
            this.getDetailTable().getColumn("monOriginHireAmt").getStyleAttributes().setHided(true);
            this.getDetailTable().getColumn("monLocalHireAmt").getStyleAttributes().setHided(true);
            this.getDetailTable().getColumn("hireOriginAmt").getStyleAttributes().setLocked(!"ADDNEW".equals(this.getOprtState()) && !"EDIT".equals(this.getOprtState()));
            for (i = 0; i < this.getDetailTable().getRowCount(); ++i) {
                this.getDetailTable().getCell(i, "monOriginHireAmt").setValue((Object)ZERO);
                this.getDetailTable().getCell(i, "monLocalHireAmt").setValue((Object)ZERO);
            }
            this.getLeaseTable().checkParsed();
            this.getLeaseTable().getColumn("measureUnit").getStyleAttributes().setHided(true);
            this.getLeaseTable().getColumn("shouldPayment").getStyleAttributes().setHided(true);
            for (i = 0; i < this.getLeaseTable().getRowCount(); ++i) {
                this.getLeaseTable().getCell(i, "measureUnit").setValue(null);
                this.getLeaseTable().getCell(i, "shouldPayment").setValue(null);
            }
        } else {
            this.getDetailTable().getColumn("hireOriginAmt").getStyleAttributes().setLocked(true);
            this.getDetailTable().getColumn("monOriginHireAmt").getStyleAttributes().setHided(false);
            this.getDetailTable().getColumn("monLocalHireAmt").getStyleAttributes().setHided(false);
            this.getLeaseTable().checkParsed();
            this.getLeaseTable().getColumn("measureUnit").getStyleAttributes().setHided(false);
            this.getLeaseTable().getColumn("shouldPayment").getStyleAttributes().setHided(false);
            String originColumnName = "";
            String localColumnName = "";
            String measureUnitColumnName = "";
            if (this.comboBoxPayMode.getSelectedItem() == FaPayModeEnum.YEAR_PAY) {
                originColumnName = EASResource.getString((String)RES_PATH, (String)"yearOHireAmt");
                localColumnName = EASResource.getString((String)RES_PATH, (String)"yearLHireAmt");
                measureUnitColumnName = EASResource.getString((String)RES_PATH, (String)"year2");
            } else if (this.comboBoxPayMode.getSelectedItem() == FaPayModeEnum.SEASON_PAY) {
                originColumnName = EASResource.getString((String)RES_PATH, (String)"seaOHireAmt");
                localColumnName = EASResource.getString((String)RES_PATH, (String)"seaLHireAmt");
                measureUnitColumnName = EASResource.getString((String)RES_PATH, (String)"season2");
            } else if (this.comboBoxPayMode.getSelectedItem() == FaPayModeEnum.MONTH_PAY) {
                originColumnName = EASResource.getString((String)RES_PATH, (String)"monthOHireAmt");
                localColumnName = EASResource.getString((String)RES_PATH, (String)"monthLHireAmt");
                measureUnitColumnName = EASResource.getString((String)RES_PATH, (String)"month2");
            } else if (this.comboBoxPayMode.getSelectedItem() == FaPayModeEnum.DAY_PAY) {
                originColumnName = EASResource.getString((String)RES_PATH, (String)"dayOHireAmt");
                localColumnName = EASResource.getString((String)RES_PATH, (String)"dayLHireAmt");
                measureUnitColumnName = EASResource.getString((String)RES_PATH, (String)"day");
            }
            this.getDetailTable().getHeadRow(0).getCell("monOriginHireAmt").setValue((Object)originColumnName);
            this.getDetailTable().getHeadRow(0).getCell("monLocalHireAmt").setValue((Object)localColumnName);
            this.getLeaseTable().getHeadRow(0).getCell("measureUnit").setValue((Object)measureUnitColumnName);
            String totalText = EASResource.getString((String)RES_PATH, (String)"total");
            this.kDLabel7.setText(originColumnName + totalText);
            this.kDLabel6.setText(localColumnName + totalText);
        }
        this.calcTotalAmount();
        this.fillLeaseTable();
    }

    private void setHideDetailColumn() {
        FaLeaseTypeInfo leaseTypeInfo = (FaLeaseTypeInfo)this.prmtFaLeaseType.getValue();
        boolean isLock = leaseTypeInfo != null && leaseTypeInfo.getNumber().equals(WORK_LEASE_TYPE);
        boolean fromRelet = LeaseBizStatusEnum.RELETING.equals((Object)this.editData.getBizStatus());
        boolean viewStatus = !"ADDNEW".equals(this.getOprtState()) && !"EDIT".equals(this.getOprtState());
        this.getDetailTable().getColumn("unAssuredAmt").getStyleAttributes().setHided(isLock);
        this.getDetailTable().getColumn("attornAmt").getStyleAttributes().setHided(isLock);
        this.getDetailTable().getColumn("unAssuredAmt").getStyleAttributes().setLocked(isLock || fromRelet || viewStatus);
        this.getDetailTable().getColumn("attornAmt").getStyleAttributes().setLocked(isLock || viewStatus);
        if (isLock) {
            for (int i = 0; i < this.getDetailTable().getRowCount(); ++i) {
                this.getDetailTable().getCell(i, "unAssuredAmt").setValue(null);
                this.getDetailTable().getCell(i, "attornAmt").setValue(null);
            }
            this.getDetailTable().getColumn("assetCat").getStyleAttributes().setBackground(this.getDetailTable().getColumn("specs").getStyleAttributes().getBackground());
        } else {
            this.getDetailTable().getColumn("assetCat").getStyleAttributes().setBackground(this.getDetailTable().getRequiredColor());
        }
        this.calcTotalAmount();
        this.tHelper.saveConfig(this.getDetailTable());
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.kDPanel1.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(1, 0, 985, 180));
        this.pnlPayAmt.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(1, 0, 985, 180));
        this.contDetailTable.getContentPane().putClientProperty("OriginalBounds", new Rectangle(9, 230, 992, 217));
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return FaLeaseBillFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("faLeaseBillEntry.faCurCard.lastUpdateTime"));
        sic.add(new SelectorItemInfo("hireCurrency.id"));
        sic.add(new SelectorItemInfo("hireCurrency.number"));
        sic.add(new SelectorItemInfo("hireCurrency.name"));
        sic.add(new SelectorItemInfo("hireCurrency.isoCode"));
        sic.add(new SelectorItemInfo("hireCurrency.sign"));
        sic.add(new SelectorItemInfo("hireCurrency.baseUnit"));
        sic.add(new SelectorItemInfo("hireCurrency.precision"));
        sic.add(new SelectorItemInfo("hireCurrency.deletedStatus"));
        sic.add(new SelectorItemInfo("subsCurrency.id"));
        sic.add(new SelectorItemInfo("subsCurrency.number"));
        sic.add(new SelectorItemInfo("subsCurrency.name"));
        sic.add(new SelectorItemInfo("subsCurrency.isoCode"));
        sic.add(new SelectorItemInfo("subsCurrency.sign"));
        sic.add(new SelectorItemInfo("subsCurrency.baseUnit"));
        sic.add(new SelectorItemInfo("subsCurrency.precision"));
        sic.add(new SelectorItemInfo("subsCurrency.deletedStatus"));
        sic.add("faLeaseBillEntry.faBizCard.propertyValue.*");
        return sic;
    }

    @Override
    protected IObjectValue createNewData() {
        this.detailTable.removeRows();
        FaLeaseBillInfo leaseBillInfo = new FaLeaseBillInfo();
        Date today = new Date();
        today = DateTimeUtils.truncateDate((Date)today);
        try {
            PeriodInfo currenctPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.getCurCompany());
            if (currenctPeriod != null) {
                if (DateTimeUtils.dayBefore((Date)today, (Date)currenctPeriod.getBeginDate())) {
                    today = currenctPeriod.getBeginDate();
                }
                if (DateTimeUtils.dayAfter((Date)today, (Date)currenctPeriod.getEndDate())) {
                    today = currenctPeriod.getEndDate();
                }
                today = new Date(today.getTime());
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        leaseBillInfo.setCompany(this.currCompany);
        leaseBillInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        leaseBillInfo.setSignatureDate(today);
        leaseBillInfo.setBeginDate(today);
        leaseBillInfo.setDeliverDate(today);
        leaseBillInfo.setBizStatus(LeaseBizStatusEnum.CHECKING);
        leaseBillInfo.setMeasureUnit(DateUnitEnum.YEAR);
        leaseBillInfo.setBargainTime(DEFAULT_BARGAINTIME);
        Date endDate = DateTimeUtils.addYear((Date)today, (int)DEFAULT_BARGAINTIME.intValue());
        leaseBillInfo.setEndDate(new Date(endDate.getTime() - 86400000L));
        leaseBillInfo.setPayMode(FaPayModeEnum.MONTH_PAY);
        leaseBillInfo.setHireOriginAmt(ZERO);
        leaseBillInfo.setHireNaturalAmt(ZERO);
        leaseBillInfo.setSubsOriginAmt(ZERO);
        leaseBillInfo.setSubsNaturalAmt(ZERO);
        BigDecimal ONE = new BigDecimal("1.00");
        leaseBillInfo.setHireExRate(ONE);
        leaseBillInfo.setSubsExRate(ONE);
        return leaseBillInfo;
    }

    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        String bargainNum = this.txtBargainNum.getText();
        if (bargainNum != null && bargainNum.trim().length() > 0) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.getCurCompany().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)bargainNum));
            viewInfo.setFilter(filter);
            FALeaseContractCollection col = FALeaseContractFactory.getRemoteInstance().getFALeaseContractCollection(viewInfo);
            if (col != null && col.size() > 0) {
                BOSObjectType bosType = new FALeaseContractInfo().getBOSType();
                HashMap idList = new HashMap();
                for (int i = 0; i < col.size(); ++i) {
                    if (idList.get(bosType.toString()) == null) {
                        idList.put(bosType.toString(), new Vector());
                    }
                    ((Vector)idList.get(bosType.toString())).add(col.get(i).getId().toString());
                }
                FaClientUtils.showTraceUI((CoreUI)this, idList, 1);
                return;
            }
        }
        if (this.editData.getSourceBillId() != null && FaBillOriginEnum.FROM_LEASEOUT_RELET.equals((Object)this.editData.getBillType())) {
            FaLeaseBillInfo billInfo = FaLeaseBillFactory.getRemoteInstance().getFaLeaseBillInfo((IObjectPK)new ObjectUuidPK(this.editData.getSourceBillId()));
            HashMap idList = new HashMap();
            BOSObjectType bosType = this.editData.getBOSType();
            if (idList.get(bosType.toString()) == null) {
                idList.put(bosType.toString(), new Vector());
            }
            ((Vector)idList.get(bosType.toString())).add(billInfo.getId().toString());
            FaClientUtils.showTraceUI((CoreUI)this, idList, 1);
            return;
        }
        throw new BTPException(BTPException.DESTBILLNULL);
    }

    @Override
    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            throw new BTPException(BTPException.DESTBILLNULL);
        }
        IFaLeaseBill iFaLeaseBill = FaLeaseBillFactory.getRemoteInstance();
        FaLeaseBillInfo billInfo = iFaLeaseBill.getFaLeaseBillInfo("select id,fiVouchered,voucher.id,clearBill.id,faLeaseBillEntry.changeBill.id,faLeaseBillEntry.returnChangeBill.id where id ='" + this.editData.getId().toString() + "'");
        FaLeaseBillEntryCollection entries = billInfo.getFaLeaseBillEntry();
        HashMap ids = new HashMap();
        Vector<String> changeBillVector = new Vector<String>();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            FaLeaseBillEntryInfo entry = entries.get(i);
            if (entry.getChangeBill() == null || entry.getChangeBill().getId() == null) continue;
            changeBillVector.add(entry.getChangeBill().getId().toString());
        }
        if (changeBillVector.size() > 0) {
            ids.put(new FaChangeBillInfo().getBOSType().toString(), changeBillVector);
        }
        Vector<String> clearBillVector = new Vector<String>();
        if (billInfo.getClearBill() != null && billInfo.getClearBill().getId() != null) {
            clearBillVector.add(billInfo.getClearBill().getId().toString());
            ids.put(new FaClearBillInfo().getBOSType().toString(), clearBillVector);
        }
        int size2 = entries.size();
        for (int i = 0; i < size2; ++i) {
            FaLeaseBillEntryInfo entry = entries.get(i);
            if (entry.getReturnChangeBill() == null || entry.getReturnChangeBill().getId() == null) continue;
            changeBillVector.add(entry.getReturnChangeBill().getId().toString());
        }
        if (changeBillVector.size() > 0) {
            ids.put(new FaChangeBillInfo().getBOSType().toString(), changeBillVector);
        }
        Vector<String> leaseBillVector = new Vector<String>();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)this.editData.getId().toString()));
        viewInfo.setFilter(filter);
        FaLeaseBillCollection col = iFaLeaseBill.getFaLeaseBillCollection(viewInfo);
        if (col != null && col.size() > 0) {
            leaseBillVector.add(col.get(0).getId().toString());
            ids.put(billInfo.getBOSType().toString(), leaseBillVector);
        }
        if (billInfo.isFiVouchered()) {
            Vector<String> voucherBillVector = new Vector<String>();
            IBOTRelation iBotRelation = BOTRelationFactory.getRemoteInstance();
            BOTRelationCollection relationCollection = iBotRelation.getCollection(new EntityViewInfo("where srcObjectID ='" + billInfo.getId() + "' and destEntityID ='" + new VoucherInfo().getBOSType().toString() + "'"));
            if (relationCollection.size() > 0) {
                for (BOTRelationInfo relationInfo : relationCollection) {
                    voucherBillVector.add(relationInfo.getDestObjectID());
                }
            }
            if (voucherBillVector.size() > 0) {
                ids.put(new VoucherInfo().getBOSType().toString(), voucherBillVector);
            }
        }
        if (ids.size() == 0) {
            throw new BTPException(BTPException.DESTBILLNULL);
        }
        this.showTraceUI(ids, 0);
    }

    @Override
    protected IObjectValue createNewDetailData(KDTable table) {
        return new FaLeaseBillEntryInfo();
    }

    @Override
    protected boolean isShowCardFilter() {
        return false;
    }

    @Override
    protected String getEntryKeyName() {
        return "faLeaseBillEntry";
    }

    @Override
    public boolean isModify() {
        boolean leaseBillChange = true;
        if (this.isOnLoadExceptionAbort || this.editData == null) {
            leaseBillChange = false;
        }
        try {
            ControlUtilities.checkFocusAndCommit();
        }
        catch (ParseException e) {
            this.handleControlException();
            this.abort();
        }
        this.balanceModify = false;
        try {
            this.storeFields();
            this.editData.setSyncOldValue(false);
        }
        catch (Exception exc) {
            leaseBillChange = false;
        }
        FaLeaseBillInfo objectValue = this.editData;
        leaseBillChange = objectValue.isValueChange();
        if (!this.balanceModify) {
            this.editData.getBalanceEntry().clear();
            for (int i = 0; i < this.leaseTable.getRowCount(); ++i) {
                FaLeaseBalanceOutEntryInfo info = new FaLeaseBalanceOutEntryInfo();
                info.setMeasureUnit(this.leaseTable.getCell(i, "measureUnit").getValue() == null ? null : this.leaseTable.getCell(i, "measureUnit").getValue().toString());
                info.setShouldPayment(this.leaseTable.getCell(i, "shouldPayment").getValue() == null ? null : (BigDecimal)this.leaseTable.getCell(i, "shouldPayment").getValue());
                info.setBillNumber(this.editData.getNumber());
                info.setSeq(i + 1);
                this.editData.getBalanceEntry().add(info);
            }
        }
        if (this.fromLink) {
            leaseBillChange = false;
        }
        if (OprtState.VIEW.equals(this.getOprtState()) || "FINDVIEW".equals(this.getOprtState())) {
            leaseBillChange = false;
        }
        return leaseBillChange;
    }

    @Override
    public void storeFields() {
        int i;
        super.storeFields();
        for (i = 0; i < this.editData.getFaLeaseBillEntry().size(); ++i) {
            FaLeaseBillEntryInfo entryInfo;
            entryInfo.setInitAmt((entryInfo = this.editData.getFaLeaseBillEntry().get(i)).getInitAmt() == null ? ZERO : entryInfo.getInitAmt());
            entryInfo.setUnAssuredAmt(entryInfo.getUnAssuredAmt() == null ? null : entryInfo.getUnAssuredAmt());
            entryInfo.setAttornAmt(entryInfo.getAttornAmt() == null ? null : entryInfo.getAttornAmt());
            if (!entryInfo.isHasInsurance() || entryInfo.getInsuranceAmt() != null) continue;
            entryInfo.setInsuranceAmt(ZERO);
        }
        if (this.balanceModify) {
            this.editData.getBalanceEntry().clear();
            for (i = 0; i < this.leaseTable.getRowCount(); ++i) {
                FaLeaseBalanceOutEntryInfo info = new FaLeaseBalanceOutEntryInfo();
                info.setMeasureUnit(this.leaseTable.getCell(i, "measureUnit").getValue() == null ? null : this.leaseTable.getCell(i, "measureUnit").getValue().toString());
                info.setShouldPayment(this.leaseTable.getCell(i, "shouldPayment").getValue() == null ? null : (BigDecimal)this.leaseTable.getCell(i, "shouldPayment").getValue());
                info.setBillNumber(this.editData.getNumber());
                info.setSeq(i + 1);
                this.editData.getBalanceEntry().add(info);
            }
        }
    }

    @Override
    public void actionScanPitch_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = null;
        IUIFactory factory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        uiWindow = factory.create(FaScanBarCodesEditUI.class.getName(), (Map)uiContext, null, null);
        uiWindow.show();
        uiWindow.getUIObject().getUIContext().get("keys");
        Set keys = new HashSet();
        keys = (Set)uiWindow.getUIObject().getUIContext().get("keys");
        if (keys == null) {
            return;
        }
        if (keys.size() <= 0) {
            return;
        }
        List<Object> al = Arrays.asList(keys.toArray());
        this.setTableUS(al);
        this.calcTotalAmount();
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        CommonQueryWithResultDialog dialog = super.initCardSelectDialog();
        if (dialog.show() || dialog.hasKeyValue()) {
            this.setTable(dialog.getSelectedCards());
            this.calcTotalAmount();
        } else {
            SysUtil.abort();
        }
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
        this.calTotalHireAmt();
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue newData) {
        FaLeaseBillInfo leaseBillInfo = (FaLeaseBillInfo)newData;
        Date today = new Date();
        today = DateTimeUtils.truncateDate((Date)today);
        try {
            PeriodInfo currenctPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.getCurCompany());
            if (currenctPeriod != null) {
                if (DateTimeUtils.dayBefore((Date)today, (Date)currenctPeriod.getBeginDate())) {
                    today = currenctPeriod.getBeginDate();
                }
                if (DateTimeUtils.dayAfter((Date)today, (Date)currenctPeriod.getEndDate())) {
                    today = currenctPeriod.getEndDate();
                }
                today = new Date(today.getTime());
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        leaseBillInfo.setBargainNum(null);
        leaseBillInfo.setSignatureDate(today);
        leaseBillInfo.setBeginDate(today);
        leaseBillInfo.setMeasureUnit(DateUnitEnum.YEAR);
        leaseBillInfo.setBargainTime(DEFAULT_BARGAINTIME);
        Date endDate = DateTimeUtils.addYear((Date)today, (int)DEFAULT_BARGAINTIME.intValue());
        leaseBillInfo.setEndDate(new Date(endDate.getTime() - 86400000L));
        leaseBillInfo.setDeliverDate(today);
        leaseBillInfo.setCompany(this.currCompany);
        leaseBillInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        leaseBillInfo.setCreateTime(null);
        leaseBillInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        leaseBillInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
        leaseBillInfo.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        leaseBillInfo.setFiVouchered(false);
        leaseBillInfo.setBizStatus(LeaseBizStatusEnum.CHECKING);
        leaseBillInfo.setAuditor(null);
        leaseBillInfo.setAuditTime(null);
        leaseBillInfo.setString("billType", null);
        FaLeaseBillEntryCollection leaseBillColl = leaseBillInfo.getFaLeaseBillEntry();
        for (int i = 0; i < leaseBillColl.size(); ++i) {
            FaLeaseBillEntryInfo aFaLeaseBillEntryInfo = leaseBillColl.get(i);
            aFaLeaseBillEntryInfo.setId(null);
        }
    }

    private void initDetailTable() {
        this.btnInsertCard.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnRemoveCard.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        KDBizPromptBox bizAssetCat = new KDBizPromptBox();
        bizAssetCat.setEditable(true);
        bizAssetCat.setQueryInfo("com.kingdee.eas.fi.fa.basedata.FaCatQuery");
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        FilterItemInfo companyFilterItemInfo = new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        filter.getFilterItems().add(companyFilterItemInfo);
        bizAssetCat.setEntityViewInfo(ev);
        bizAssetCat.setDisplayFormat("$name$");
        bizAssetCat.setEditFormat("$number$");
        bizAssetCat.setCommitFormat("$number$");
        this.detailTable.getColumn("assetCat").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizAssetCat));
        KDBizPromptBox bizMeasureUnit = new KDBizPromptBox();
        bizMeasureUnit.setEditable(true);
        bizMeasureUnit.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7MeasureUnitQuery");
        bizMeasureUnit.setDisplayFormat("$name$");
        bizMeasureUnit.setEditFormat("$number$");
        bizMeasureUnit.setCommitFormat("$number$");
        this.detailTable.getColumn("measureUnit").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizMeasureUnit));
        KDTextField txtDesc = new KDTextField();
        txtDesc.setMaxLength(80);
        this.detailTable.getColumn("number").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtDesc));
        this.detailTable.getColumn("assetName").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtDesc));
        this.detailTable.getColumn("description").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtDesc));
        this.detailTable.getColumn("specs").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtDesc));
    }

    private void formatTableColumn(KDTable table, String[] colNames, int scale) {
        KDFormattedTextField txtAmtFieldFacAmount = new KDFormattedTextField(1);
        txtAmtFieldFacAmount.setPrecision(scale);
        txtAmtFieldFacAmount.setMaximumValue((Comparable)FaClientUtils.MAX_DECIMAL);
        txtAmtFieldFacAmount.setNegatived(false);
        txtAmtFieldFacAmount.setHorizontalAlignment(4);
        for (int i = 0; i < colNames.length; ++i) {
            table.getColumn(colNames[i]).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtAmtFieldFacAmount));
            table.getColumn(colNames[i]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            table.getColumn(colNames[i]).getStyleAttributes().setNumberFormat(FaClientUtils.getDecimalFormat(scale));
        }
    }

    private void initNumericTxt() throws Exception {
        this.txtHireNaturalAmt.setNegatived(false);
        this.txtSubsNaturalAmt.setNegatived(false);
        this.txtBargainTime.setNegatived(false);
        this.txtLeasedTime.setNegatived(false);
        this.txtRemainTime.setNegatived(false);
        this.txtHireOriginAmt.setHorizontalAlignment(4);
        this.txtHireOriginAmt.setNegatived(false);
        this.txtHireOriginAmt.setMaximumValue((Comparable)LCMClientUtils.MAX_DECIMAL);
        this.txtSubsOriginAmt.setHorizontalAlignment(4);
        this.txtSubsOriginAmt.setNegatived(false);
        this.txtSubsOriginAmt.setMaximumValue((Comparable)LCMClientUtils.MAX_DECIMAL);
        this.txtHireExRate.setHorizontalAlignment(4);
        this.txtHireExRate.setNegatived(false);
        this.txtHireExRate.setMaximumValue((Comparable)LCMClientUtils.MAX_DECIMAL);
        this.txtSubsExRate.setHorizontalAlignment(4);
        this.txtSubsExRate.setNegatived(false);
        this.txtSubsExRate.setMaximumValue((Comparable)LCMClientUtils.MAX_DECIMAL);
        this.setExRateAndScale(this.comboHireCurrency, this.txtHireOriginAmt, this.txtHireExRate, false, HIRE_TYPE);
        this.setExRateAndScale(this.comboSubsCurrency, this.txtSubsOriginAmt, this.txtSubsExRate, false, SUBS_TYPE);
        this.setComponentPrecision(new Object[]{this.txtHireNaturalAmt, this.txtSubsNaturalAmt}, this.getCurrencyScale());
        this.setComponentPrecision(new Object[]{this.txtBargainTime, this.txtLeasedTime, this.txtRemainTime}, 0);
    }

    private void setExRateAndScale(KDComboBox comboCurrency, KDFormattedTextField txtOriginAmt, KDFormattedTextField txtExRate, boolean chageValue, String type) {
        try {
            BigDecimal rate = new BigDecimal("1.00");
            CurrencyInfo srcCyInfo = (CurrencyInfo)comboCurrency.getSelectedItem();
            CurrencyInfo desCyInfo = this.getBaseCurrency();
            int rateScale = desCyInfo.getPrecision();
            if (srcCyInfo != null && desCyInfo != null) {
                int originScale = srcCyInfo.getPrecision();
                txtOriginAmt.setPrecision(originScale);
                if (srcCyInfo.getId().equals((Object)desCyInfo.getId())) {
                    rateScale = srcCyInfo.getPrecision();
                    txtExRate.setEnabled(false);
                } else {
                    txtExRate.setEnabled(true);
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("name"));
                    sic.add(new SelectorItemInfo("baseExchangeTable.*"));
                    ObjectUuidPK companyPK = new ObjectUuidPK(this.getCurCompany().getId());
                    CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)companyPK, sic);
                    ExchangeTableInfo exchangeTableInfo = companyInfo.getBaseExchangeTable();
                    if (exchangeTableInfo != null) {
                        IExchangeRate iExchangeRate = ExchangeRateFactory.getRemoteInstance();
                        ExchangeRateInfo exchangeRateInfo = iExchangeRate.getExchangeRate((IObjectPK)new ObjectUuidPK(exchangeTableInfo.getId()), (IObjectPK)new ObjectUuidPK(srcCyInfo.getId()), (IObjectPK)new ObjectUuidPK(desCyInfo.getId()), (Date)this.getCurrPeriod().getEndDate());
                        if (exchangeRateInfo != null) {
                            rate = exchangeRateInfo.getConvertRate();
                            rateScale = exchangeRateInfo.getPrecision();
                            if (HIRE_TYPE.equals(type)) {
                                this.hireConvertMode = exchangeRateInfo.getConvertMode() == null ? 0 : exchangeRateInfo.getConvertMode().getValue();
                            } else if (SUBS_TYPE.equals(type)) {
                                this.subsConvertMode = exchangeRateInfo.getConvertMode() == null ? 0 : exchangeRateInfo.getConvertMode().getValue();
                            }
                        } else {
                            MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)RES_PATH, (String)"noLocalCurrencyExRate"), srcCyInfo.getName()));
                            txtExRate.setValue(null);
                            return;
                        }
                    }
                }
            }
            txtExRate.setPrecision(rateScale);
            if (chageValue) {
                txtExRate.setValue((Object)rate);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
            SysUtil.abort();
        }
    }

    private void loadCurrency() {
        CurrencyCollection currencyCollection = this.getCurrencyCollection();
        Vector<CurrencyInfo> tempCbDatas = new Vector<CurrencyInfo>();
        int size = currencyCollection.size();
        for (int i = 0; i < size; ++i) {
            tempCbDatas.addElement(currencyCollection.get(i));
        }
        this.comboHireCurrency.setModel(new DefaultComboBoxModel(tempCbDatas));
        this.comboSubsCurrency.setModel(new DefaultComboBoxModel(tempCbDatas));
        CurrencyInfo hireCurrency = this.editData.getHireCurrency();
        if (this.editData.getHireCurrency() == null) {
            hireCurrency = this.getBaseCurrency();
        }
        for (int i = 0; i < currencyCollection.size(); ++i) {
            if (!currencyCollection.get(i).getId().equals((Object)hireCurrency.getId())) continue;
            this.comboHireCurrency.setSelectedItem((Object)currencyCollection.get(i));
        }
        CurrencyInfo subsCurrency = this.editData.getSubsCurrency();
        if (this.editData.getSubsCurrency() == null) {
            subsCurrency = this.getBaseCurrency();
        }
        for (int i = 0; i < currencyCollection.size(); ++i) {
            if (!currencyCollection.get(i).getId().equals((Object)subsCurrency.getId())) continue;
            this.comboSubsCurrency.setSelectedItem((Object)currencyCollection.get(i));
        }
    }

    private void lockCurrency() {
        CurrencyInfo srcCyInfo = (CurrencyInfo)this.comboHireCurrency.getSelectedItem();
        CurrencyInfo desCyInfo = this.getBaseCurrency();
        if (srcCyInfo != null && desCyInfo != null) {
            boolean editable = !(LeaseBizStatusEnum.RELETING.equals((Object)this.editData.getBizStatus()) && "002".equals(this.editData.getFaLeaseType().getNumber()) || !"ADDNEW".equals(this.getOprtState()) && !"EDIT".equals(this.getOprtState()));
            editable = editable && !srcCyInfo.getId().equals((Object)desCyInfo.getId());
            this.txtHireExRate.setEditable(editable);
        }
        if ((srcCyInfo = (CurrencyInfo)this.comboSubsCurrency.getSelectedItem()) != null && desCyInfo != null) {
            if (srcCyInfo.getId().equals((Object)desCyInfo.getId())) {
                this.txtSubsExRate.setEditable(false);
            } else {
                this.txtSubsExRate.setEditable(true);
            }
        }
    }

    public void actionValueChanged(KDTPropertyChangeEvent e) {
        if (this.getDetailTable().getRowCount() == 0) {
            return;
        }
        int changeColIndex = e.getColIndex();
        int changeRowIndex = e.getRowIndex();
        int quantityColIndex = this.detailTable.getColumnIndex("quantity");
        if (this.detailTable.getRow(changeRowIndex).getCell("number").getValue() == null) {
            return;
        }
        String info = this.verifyDetailTable(changeRowIndex, changeColIndex, e);
        if (info != null) {
            ICell iCell = this.detailTable.getCell(changeRowIndex, changeColIndex);
            iCell.setValue(e.getOldValue());
            MsgBox.showInfo((Component)((Object)this), (String)info);
            return;
        }
        if (changeColIndex == quantityColIndex) {
            FaCurCardInfo curCard = this.getCurCardInfo(this.detailTable.getRow(changeRowIndex).getCell("FaCurCardID").getValue().toString());
            BigDecimal quantity = new BigDecimal(e.getNewValue().toString());
            this.displayAssetValueAndNeatValue(this.detailTable, changeRowIndex, curCard, quantity);
            this.calcTotalAmount();
        }
    }

    private String verifyDetailTable(int activeRow, int activeCol, KDTPropertyChangeEvent e) {
        int quantityColIndex = this.detailTable.getColumnIndex("quantity");
        int evaluateColIndex = this.detailTable.getColumnIndex("evaluateValue");
        int insuranceColIndex = this.detailTable.getColumnIndex("insuranceAmt");
        int bailColIndex = this.detailTable.getColumnIndex("bailAmt");
        int attornColIndex = this.detailTable.getColumnIndex("attornAmt");
        if (activeCol == quantityColIndex || activeCol == evaluateColIndex || activeCol == insuranceColIndex || activeCol == bailColIndex || activeCol == attornColIndex) {
            BigDecimal assetAmt;
            Object tmpObj = e.getNewValue();
            BigDecimal value = null;
            if (tmpObj == null) {
                if (activeCol == quantityColIndex) {
                    return EASResource.getString((String)RES_PATH, (String)"QuantityIsNull");
                }
                return null;
            }
            if (!tmpObj.toString().matches("[0-9]+[.]?[0-9]*")) {
                return EASResource.getString((String)RES_PATH, (String)"InputNumber");
            }
            value = new BigDecimal(tmpObj.toString());
            if (value.compareTo(new BigDecimal("0")) < 0) {
                return EASResource.getString((String)RES_PATH, (String)"ValueLessThanZero");
            }
            if ((evaluateColIndex == activeCol || quantityColIndex == activeCol) && value.compareTo(ZERO) < 0) {
                return EASResource.getString((String)RES_PATH, (String)"ValueMoreThanZero");
            }
            if (activeCol == quantityColIndex && value.compareTo(assetAmt = new BigDecimal(this.detailTable.getRow(activeRow).getCell("assetAmt").getValue().toString())) > 0) {
                return EASResource.getString((String)RES_PATH, (String)"QuantityCompareToAssetAmt");
            }
        }
        return null;
    }

    private void displayAssetValueAndNeatValue(KDTable kdtable, int rowIndex, FaCurCardInfo curCard, BigDecimal quantity) {
        BigDecimal assetValue = curCard.getAssetValue();
        BigDecimal assetAmt = curCard.getAssetAmt();
        assetValue = assetValue.multiply(quantity).divide(assetAmt, this.getCurrencyScale());
        kdtable.getRow(rowIndex).getCell("assetValue").setValue((Object)assetValue);
    }

    private void setTable(FaCurCardCollection cardInfos) {
        if (cardInfos != null && cardInfos.size() > 0) {
            KDTable kdtable = this.getDetailTable();
            int rowNums = cardInfos.size();
            for (int i = 0; i < rowNums; ++i) {
                FaCurCardInfo cardInfo = cardInfos.get(i);
                cardInfo.setPropertyValue(this.getCurCardInfo(cardInfo.getId().toString()).getPropertyValue());
                if (this.isDuplicate(cardInfo.getId().toString())) continue;
                FaLeaseBillEntryInfo billEntryInfo = this.initLeaseBillEntryInfo(cardInfo);
                this.loadLineFields(kdtable, kdtable.addRow(), (IObjectValue)billEntryInfo);
                kdtable.setEditable(true);
                kdtable.setEnabled(true);
            }
        }
    }

    private void setTableUS(List cardInfos) {
        if (cardInfos != null && cardInfos.size() > 0) {
            KDTable kdtable = this.getDetailTable();
            int rowNums = cardInfos.size();
            for (int i = 0; i < rowNums; ++i) {
                FaCurCardInfo cardInfo = this.getCurCardDetailInfo(cardInfos.get(i).toString());
                if (this.isDuplicate(cardInfo.getId().toString())) continue;
                FaLeaseBillEntryInfo billEntryInfo = this.initLeaseBillEntryInfo(cardInfo);
                this.loadLineFields(kdtable, kdtable.addRow(), (IObjectValue)billEntryInfo);
            }
        }
    }

    public SelectorItemCollection getCurCardSelectors() {
        return AbstractFaLeaseBillEditUI.getCurCardSelectors(0);
    }

    private boolean isDuplicate(String cardID) {
        KDTable kdtable = this.getDetailTable();
        int count = kdtable.getRowCount();
        for (int j = 0; j < count; ++j) {
            Object oldID = kdtable.getRow(j).getCell("FaCurCardID").getValue();
            if (!oldID.toString().equals(cardID)) continue;
            return true;
        }
        return false;
    }

    private FaLeaseBillEntryInfo initLeaseBillEntryInfo(FaCurCardInfo curCard) {
        FaLeaseBillEntryInfo entryInfo = new FaLeaseBillEntryInfo();
        entryInfo.setFaBizCard(FaClientUtils.CurCard2BizCard(curCard));
        entryInfo.setFaCurCard(curCard);
        entryInfo.setQuantity(curCard.getAssetAmt());
        entryInfo.setAssetValue(curCard.getAssetValue());
        entryInfo.setEvaluateValue(curCard.getAssetValue());
        entryInfo.setMonOriginHireAmt(ZERO);
        entryInfo.setMonLocalHireAmt(ZERO);
        entryInfo.setHireOriginAmt(ZERO);
        entryInfo.setHireLocalAmt(ZERO);
        return entryInfo;
    }

    protected FaCurCardInfo getCurCardDetailInfo(String curCardID) {
        FaCurCardInfo curCardInfo = new FaCurCardInfo();
        try {
            curCardInfo = FaCurCardFactory.getRemoteInstance().getFaCurCardInfo((IObjectPK)new ObjectUuidPK(curCardID), this.getCurCardDetailSelectors());
            this.fullFaDefPropertyValueInfo(curCardInfo);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return curCardInfo;
    }

    public SelectorItemCollection getCurCardDetailSelectors() {
        return AbstractFaLeaseBillEditUI.getCurCardSelectors(0);
    }

    protected FaCurCardInfo getCurCardInfo(String curCardID) {
        FaCurCardInfo curCardInfo = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("assetValue"));
        sic.add(new SelectorItemInfo("assetAmt"));
        sic.add(new SelectorItemInfo("propertyValue.*"));
        try {
            curCardInfo = FaCurCardFactory.getRemoteInstance().getFaCurCardInfo((IObjectPK)new ObjectUuidPK(curCardID), sic);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return curCardInfo;
    }

    private void fullFaDefPropertyValueInfo(FaCardInfo card) throws EASBizException, BOSException {
        FaDefPropertyValueInfo p = card.getPropertyValue();
        if (p != null) {
            p = FaDefPropertyValueFactory.getRemoteInstance().getFaDefPropertyValueInfo((IObjectPK)new ObjectUuidPK(p.getId()));
            card.setPropertyValue(p);
        }
    }

    @Override
    protected String[] getFormatColumns() {
        return new String[]{"assetValue", "hireLocalAmt", "unAssuredAmt", "evaluateValue", "insuranceAmt", "bailAmt", "attornAmt", "monLocalHireAmt", "initAmt"};
    }

    @Override
    protected String[] getAssetAmtColumns() {
        return new String[]{"assetAmt", "quantity"};
    }

    @Override
    protected String[] getEditableColumn() {
        return new String[]{"evaluateValue", "hasInsurance", "assetValue", "bailAmt", "attornAmt", "description", "monOriginHireAmt", "initAmt", "unAssuredAmt"};
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        this.addPrintData();
        BillBaseCollection billCol = new BillBaseCollection();
        billCol.add((BillBaseInfo)this.editData);
        KDNoteHelper appHlp = new KDNoteHelper();
        KDTable[] tables = new KDTable[]{this.getDetailTable()};
        BOSQueryDelegate data = FaPrintHelper.getPrintManagerForFaLeaseBillEditUI((IObjectCollection)billCol, tables);
        appHlp.printPreview(this.getPrintPath(), (Object)data, (Component)((Object)this));
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        this.addPrintData();
        BillBaseCollection billCol = new BillBaseCollection();
        billCol.add((BillBaseInfo)this.editData);
        KDNoteHelper appHlp = new KDNoteHelper();
        KDTable[] tables = new KDTable[]{this.getDetailTable()};
        BOSQueryDelegate data = FaPrintHelper.getPrintManagerForFaLeaseBillEditUI((IObjectCollection)billCol, tables);
        appHlp.print(this.getPrintPath(), (Object)data, (Component)((Object)this));
    }

    private void addPrintData() {
        DateUnitEnum measureUnit = (DateUnitEnum)((Object)this.comboMeasureUnit.getSelectedItem());
        String leasedTime = measureUnit == null ? this.txtLeasedTime.getText() : this.txtLeasedTime.getText() + measureUnit.getAlias();
        String remainTime = measureUnit == null ? this.txtRemainTime.getText() : this.txtRemainTime.getText() + measureUnit.getAlias();
        this.editData.put("leasedTime", leasedTime);
        this.editData.put("remainTime", remainTime);
        this.editData.put("assetValueTotal", this.lblAssetValue.getText());
        this.editData.put("evaluateValueTotal", this.lblEvaluateValue.getText());
        this.editData.put("monOriginHireAmtTotal", this.lblMonthOrginHireAmt.getText());
        this.editData.put("monLocalHireAmtTotal", this.lblMonLocalHireAmt.getText());
        this.editData.put("initAmtTotal", this.lblInitAmt.getText());
        this.editData.put("unAssuredAmTotal", this.lblUnAssuredAmt.getText());
        this.editData.put("insuranceAmtTotal", this.lblInsuranceAmt.getText());
        this.editData.put("attornAmtTotal", this.lblAttornAmt.getText());
        this.editData.put("bailAmtTotal", this.lblBailAmt.getText());
        this.editData.put("rentQuantity", this.lblQuantity.getText());
        if (this.editData.getPayMode() != null) {
            this.editData.put("payMode.name", this.editData.getPayMode().getAlias());
        }
    }

    @Override
    protected String getPrintPath() {
        return "/FI/FA/FaLeaseBill";
    }

    @Override
    public void loadFields() {
        this.bindDefProperty();
        super.loadFields();
        this.calLeaseTime();
        this.setOrigCurrencyRate();
        this.calcTotalAmount();
        this.doInsurance();
        this.lockLeaseContractFeild();
        this.lockCurrency();
        this.loadLeaseDetail();
        this.loadCurrency();
    }

    private void bindDefProperty() {
        if (!this.initDefPropertyBind) {
            try {
                FaDefEntityManager.bindDefProperty((String)"faLeaseBillEntry.faBizCard.", (KDTable)this.detailTable, (String)this.resHelper.getString("detailTable.formatXml"), (DataBinder)this.dataBinder);
                this.initDefPropertyBind = true;
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
    }

    private void calLeaseTime() {
        java.sql.Date beginDate = this.pkBeginDate.getSqlDate();
        java.sql.Date endDate = this.pkEndDate.getSqlDate();
        BigDecimal bargainTime = this.txtBargainTime.getBigDecimalValue();
        DateUnitEnum measureUnit = (DateUnitEnum)((Object)this.comboMeasureUnit.getSelectedItem());
        BigDecimal leasedTime = FaClientUtils.calLeasedTime(beginDate, endDate, bargainTime, measureUnit);
        this.txtLeasedTime.setValue((Object)leasedTime);
        this.txtRemainTime.setValue((Object)this.txtBargainTime.getBigDecimalValue().subtract(leasedTime));
    }

    private void calcTotalAmount() {
        int baseScale;
        BigDecimal clrAssetValue = ZERO;
        BigDecimal clrMonthOrginHireAmt = ZERO;
        BigDecimal clrmonLocalHireAmt = ZERO;
        BigDecimal clrQuantity = ZERO;
        BigDecimal clrInsuranceAmt = ZERO;
        BigDecimal clrBailAmt = ZERO;
        BigDecimal clrAttornAmt = ZERO;
        BigDecimal clrUnAssuredAmt = ZERO;
        BigDecimal clrInitAmt = ZERO;
        BigDecimal clrEvaluateValue = ZERO;
        for (int i = 0; i < this.detailTable.getRowCount(); ++i) {
            IRow row = this.detailTable.getRow(i);
            BigDecimal cellAssetValue = row.getCell("assetValue").getValue() == null ? ZERO : (BigDecimal)row.getCell("assetValue").getValue();
            BigDecimal quantity = new BigDecimal(row.getCell("quantity").getValue() == null ? "0" : row.getCell("quantity").getValue().toString());
            BigDecimal monLocalHireAmt = new BigDecimal(row.getCell("monLocalHireAmt").getValue() == null ? "0" : row.getCell("monLocalHireAmt").getValue().toString());
            BigDecimal insuranceAmt = new BigDecimal(row.getCell("insuranceAmt").getValue() == null ? "0" : row.getCell("insuranceAmt").getValue().toString());
            BigDecimal bailAmt = new BigDecimal(row.getCell("bailAmt").getValue() == null ? "0" : row.getCell("bailAmt").getValue().toString());
            BigDecimal attornAmt = new BigDecimal(row.getCell("attornAmt").getValue() == null ? "0" : row.getCell("attornAmt").getValue().toString());
            BigDecimal monthOrginHireAmt = new BigDecimal(row.getCell("monOriginHireAmt").getValue() == null ? "0" : row.getCell("monOriginHireAmt").getValue().toString());
            BigDecimal initAmt = new BigDecimal(row.getCell("initAmt").getValue() == null ? "0" : row.getCell("initAmt").getValue().toString());
            BigDecimal evaluateValue = new BigDecimal(row.getCell("evaluateValue").getValue() == null ? "0" : row.getCell("evaluateValue").getValue().toString());
            BigDecimal unAssuredAmt = new BigDecimal(row.getCell("unAssuredAmt").getValue() == null ? "0" : row.getCell("unAssuredAmt").getValue().toString());
            clrAssetValue = clrAssetValue.add(cellAssetValue);
            clrQuantity = clrQuantity.add(quantity);
            clrmonLocalHireAmt = clrmonLocalHireAmt.add(monLocalHireAmt);
            clrInsuranceAmt = clrInsuranceAmt.add(insuranceAmt);
            clrBailAmt = clrBailAmt.add(bailAmt);
            clrAttornAmt = clrAttornAmt.add(attornAmt);
            clrMonthOrginHireAmt = clrMonthOrginHireAmt.add(monthOrginHireAmt);
            clrInitAmt = clrInitAmt.add(initAmt);
            clrEvaluateValue = clrEvaluateValue.add(evaluateValue);
            clrUnAssuredAmt = clrUnAssuredAmt.add(unAssuredAmt);
        }
        int originScale = baseScale = this.getCurrencyScale();
        if (this.comboHireCurrency.getSelectedItem() != null) {
            CurrencyInfo hireCurrency = (CurrencyInfo)this.comboHireCurrency.getSelectedItem();
            originScale = hireCurrency.getPrecision();
        }
        this.lblAssetValue.setText(FaClientUtils.formatDecimal(clrAssetValue, baseScale));
        this.lblEvaluateValue.setText(FaClientUtils.formatDecimal(clrEvaluateValue, baseScale));
        this.lblMonthOrginHireAmt.setText(FaClientUtils.formatDecimal(clrMonthOrginHireAmt, originScale));
        this.lblMonLocalHireAmt.setText(FaClientUtils.formatDecimal(clrmonLocalHireAmt, baseScale));
        this.lblInitAmt.setText(FaClientUtils.formatDecimal(clrInitAmt, baseScale));
        this.lblQuantity.setText(FaClientUtils.formatDecimal(clrQuantity, this.getFAQuantityScale()));
        this.lblUnAssuredAmt.setText(FaClientUtils.formatDecimal(clrUnAssuredAmt, baseScale));
        this.lblInsuranceAmt.setText(FaClientUtils.formatDecimal(clrInsuranceAmt, baseScale));
        this.lblBailAmt.setText(FaClientUtils.formatDecimal(clrBailAmt, baseScale));
        this.lblAttornAmt.setText(FaClientUtils.formatDecimal(clrAttornAmt, baseScale));
    }

    private PeriodInfo getCurrPeriod() {
        PeriodInfo currenctPeriod = null;
        try {
            currenctPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.getCurCompany());
        }
        catch (Exception ex) {
            this.handleException(ex);
            SysUtil.abort();
        }
        if (currenctPeriod == null) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.notConfigStartPeriod");
            MsgBox.showInfo((Component)((Object)this), (String)strMsg);
            SysUtil.abort();
        }
        return currenctPeriod;
    }

    private CurrencyInfo getBaseCurrency() {
        if (this.baseCurrency == null) {
            ObjectUuidPK pk = new ObjectUuidPK(this.getCurCompany().getBaseCurrency().getId());
            try {
                this.baseCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)pk);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return this.baseCurrency;
    }

    private CurrencyCollection getCurrencyCollection() {
        if (this.initCurrencyCollection == null) {
            this.initCurrencyCollection = (CurrencyCollection)this.initUiInfo.get("currencyCollection");
        }
        if (this.oprtState == null || !"VIEW".equals(this.oprtState)) {
            CurrencyCollection currencyCollection = new CurrencyCollection();
            int size = this.initCurrencyCollection.size();
            for (int i = 0; i < size; ++i) {
                CurrencyInfo currencyInfo = this.initCurrencyCollection.get(i);
                if (currencyInfo.getDeletedStatus().getValue() == 2) continue;
                currencyCollection.add(currencyInfo);
            }
            return currencyCollection;
        }
        return this.initCurrencyCollection;
    }

    @Override
    protected void beforeStoreFields(ActionEvent e) throws Exception {
        String info;
        if (e == null || e != null && this.getActionFromActionEvent(e).equals(this.actionSubmit)) {
            KDTable detailTable;
            int rowCount;
            PeriodInfo currPeriod;
            java.sql.Date deliverDate;
            if (this.txtHireCompany.getText() == null || this.txtHireCompany.getText().trim().equals("")) {
                info = EASResource.getString((String)RES_PATH, (String)"HireIsNull");
                MsgBox.showInfo((String)info);
                this.txtHireCompany.requestFocus();
                SysUtil.abort();
            }
            if (this.txtLeaseCompany.getText() == null || this.txtLeaseCompany.getText().trim().equals("")) {
                info = EASResource.getString((String)RES_PATH, (String)"RenterIsNull");
                MsgBox.showInfo((String)info);
                this.txtLeaseCompany.requestFocus();
                SysUtil.abort();
            }
            if (this.prmtFaLeaseType.getValue() == null) {
                info = EASResource.getString((String)RES_PATH, (String)"LeaseTypeIsNull");
                MsgBox.showInfo((String)info);
                this.prmtFaLeaseType.requestFocus();
                SysUtil.abort();
            }
            if (DateTimeUtils.dayAfter((Date)(deliverDate = this.pkDeliverDate.getSqlDate()), (Date)(currPeriod = this.getCurrPeriod()).getEndDate()) || DateTimeUtils.dayBefore((Date)deliverDate, (Date)currPeriod.getBeginDate())) {
                info = MessageFormat.format(EASResource.getString((String)RES_PATH, (String)"currPeriodIs"), currPeriod.toString()) + "\uff0c" + EASResource.getString((String)RES_PATH, (String)"deliverDateNotInCurrPeiord");
                MsgBox.showInfo((String)info);
                this.pkDeliverDate.requestFocus();
                SysUtil.abort();
            }
            if (this.pkSignatureDate.getValue() != null && ((Date)this.pkSignatureDate.getValue()).compareTo((Date)this.pkDeliverDate.getValue()) > 0) {
                info = EASResource.getString((String)RES_PATH, (String)"signatureDateMorethanDeliverDate");
                MsgBox.showInfo((String)info);
                this.pkDeliverDate.requestFocus();
                SysUtil.abort();
            }
            if (this.pkDeliverDate.getValue() != null && ((Date)this.pkDeliverDate.getValue()).compareTo((Date)this.pkBeginDate.getValue()) > 0) {
                info = EASResource.getString((String)RES_PATH, (String)"deliverDateMorethanBeginDate");
                MsgBox.showInfo((String)info);
                this.pkBeginDate.requestFocus();
                SysUtil.abort();
            }
            if (this.txtBargainTime.getBigDecimalValue().floatValue() <= 0.0f) {
                info = EASResource.getString((String)RES_PATH, (String)"BargainTimeMoreZero");
                MsgBox.showInfo((String)info);
                this.txtBargainTime.requestFocus();
                SysUtil.abort();
            }
            boolean isOk = true;
            Object timeUnit = this.comboMeasureUnit.getSelectedItem();
            if (FaPayModeEnum.YEAR_PAY.equals(this.comboBoxPayMode.getSelectedItem()) || FaPayModeEnum.SEASON_PAY.equals(this.comboBoxPayMode.getSelectedItem())) {
                if (DateUnitEnum.MONTH.equals(timeUnit) || DateUnitEnum.DAY.equals(timeUnit)) {
                    isOk = false;
                }
            } else if (FaPayModeEnum.MONTH_PAY.equals(this.comboBoxPayMode.getSelectedItem()) && DateUnitEnum.DAY.equals(timeUnit)) {
                isOk = false;
            }
            if (!isOk) {
                info = EASResource.getString((String)RES_PATH, (String)"leaseTimeUnitMorethanPayMode");
                MsgBox.showInfo((String)info);
                this.comboBoxPayMode.requestFocus();
                SysUtil.abort();
            }
            if (this.comboHireCurrency.getSelectedItem() == null) {
                info = EASResource.getString((String)RES_PATH, (String)"hireCurrencyIsNull");
                MsgBox.showInfo((String)info);
                this.comboHireCurrency.requestFocus();
                SysUtil.abort();
            }
            if (this.txtHireExRate.getBigDecimalValue() == null || this.txtHireExRate.getBigDecimalValue().compareTo(ZERO) <= 0) {
                info = EASResource.getString((String)RES_PATH, (String)"exRateLessZeroIsNull");
                MsgBox.showInfo((String)info);
                this.txtHireExRate.requestFocus();
                SysUtil.abort();
            }
            if (this.comboSubsCurrency.getSelectedItem() != null && this.txtSubsExRate.getBigDecimalValue() == null) {
                info = EASResource.getString((String)RES_PATH, (String)"subsExRateIsNull");
                MsgBox.showInfo((String)info);
                this.txtSubsExRate.requestFocus();
                SysUtil.abort();
            }
            if (this.comboSubsCurrency.getSelectedItem() != null && this.txtSubsExRate.getBigDecimalValue() != null && this.txtSubsExRate.getBigDecimalValue().compareTo(ZERO) <= 0) {
                info = EASResource.getString((String)RES_PATH, (String)"exRateLessZeroIsNull");
                MsgBox.showInfo((String)info);
                this.txtSubsExRate.requestFocus();
                SysUtil.abort();
            }
            if ((rowCount = (detailTable = this.getDetailTable()).getRowCount()) == 0) {
                info = EASResource.getString((String)RES_PATH, (String)"LeaseDetailIsNull");
                MsgBox.showInfo((String)info);
                SysUtil.abort();
            }
            int assetAmtCol = detailTable.getColumnIndex("assetAmt");
            int quantityCol = detailTable.getColumnIndex("quantity");
            int count = detailTable.getRowCount();
            for (int i = 0; i < count; ++i) {
                BigDecimal assetAmt = (BigDecimal)detailTable.getCell(i, assetAmtCol).getValue();
                BigDecimal quantity = new BigDecimal(detailTable.getCell(i, quantityCol).getValue().toString());
                if (quantity == null) {
                    info = EASResource.getString((String)RES_PATH, (String)"QuantityIsNull");
                    MsgBox.showInfo((String)info);
                    detailTable.getSelectManager().select(i, quantityCol);
                    SysUtil.abort();
                } else if (quantity.compareTo(assetAmt) > 0) {
                    info = EASResource.getString((String)RES_PATH, (String)"QuantityCompareToAssetAmt");
                    MsgBox.showInfo((String)info);
                    detailTable.getSelectManager().select(i, quantityCol);
                    SysUtil.abort();
                }
                BigDecimal monOriginHireAmt = (BigDecimal)detailTable.getCell(i, "monOriginHireAmt").getValue();
                if (!FaPayModeEnum.APERIODIC_PAY.equals(this.comboBoxPayMode.getSelectedItem()) && !FaPayModeEnum.ONE_PAY.equals(this.comboBoxPayMode.getSelectedItem()) && monOriginHireAmt == null) {
                    info = EASResource.getString((String)RES_PATH, (String)"isNull");
                    info = detailTable.getHeadRow(0).getCell("monOriginHireAmt").getValue().toString() + info;
                    MsgBox.showInfo((String)info);
                    detailTable.getEditManager().editCellAt(i, detailTable.getColumnIndex("monOriginHireAmt"));
                    SysUtil.abort();
                }
                if (detailTable.getCell(i, "hireOriginAmt").getValue() != null) continue;
                info = EASResource.getString((String)RES_PATH, (String)"hireOriginAmtIsNull");
                MsgBox.showInfo((String)info);
                detailTable.getEditManager().editCellAt(i, detailTable.getColumnIndex("hireOriginAmt"));
                SysUtil.abort();
            }
        }
        String monthHireAmtTitle = (String)this.detailTable.getHeadRow(0).getCell("monLocalHireAmt").getValue();
        String hireOriginAmtTitme = (String)this.detailTable.getHeadRow(0).getCell("hireOriginAmt").getValue();
        String hireLocalAmtTitme = (String)this.detailTable.getHeadRow(0).getCell("hireLocalAmt").getValue();
        String morethanMax = EASResource.getString((String)RES_PATH, (String)"morethanMax");
        morethanMax = morethanMax.replaceFirst("[{}]", FaClientUtils.MAX_DECIMAL.toString()).replaceFirst("}", "");
        int count = this.detailTable.getRowCount();
        for (int i = 0; i < count; ++i) {
            BigDecimal monLocalHireAmt = (BigDecimal)this.detailTable.getCell(i, "monLocalHireAmt").getValue();
            BigDecimal hireOriginAmt = (BigDecimal)this.detailTable.getCell(i, "hireOriginAmt").getValue();
            BigDecimal hireLocalAmt = (BigDecimal)this.detailTable.getCell(i, "hireLocalAmt").getValue();
            String leaseDetailNoRow = EASResource.getString((String)RES_PATH, (String)"leaseDetailNoRow").replaceFirst("[{}]", String.valueOf(i + 1)).replaceFirst("}", "");
            if (monLocalHireAmt != null && monLocalHireAmt.compareTo(FaClientUtils.MAX_DECIMAL) > 0) {
                MsgBox.showInfo((String)(leaseDetailNoRow + monthHireAmtTitle + morethanMax));
                SysUtil.abort();
            }
            if (hireOriginAmt != null && hireOriginAmt.compareTo(FaClientUtils.MAX_DECIMAL) > 0) {
                MsgBox.showInfo((String)(leaseDetailNoRow + hireOriginAmtTitme + morethanMax));
                SysUtil.abort();
            }
            if (hireLocalAmt == null || hireLocalAmt.compareTo(FaClientUtils.MAX_DECIMAL) <= 0) continue;
            MsgBox.showInfo((String)(leaseDetailNoRow + hireLocalAmtTitme + morethanMax));
            SysUtil.abort();
        }
        if (this.txtHireOriginAmt.getBigDecimalValue() != null && this.txtHireOriginAmt.getBigDecimalValue().compareTo(FaClientUtils.MAX_DECIMAL) > 0) {
            info = EASResource.getString((String)RES_PATH, (String)"hireOriginAmtMorethanMax");
            MsgBox.showInfo((String)info.replaceFirst("[{}]", FaClientUtils.MAX_DECIMAL.toString()).replaceFirst("}", ""));
            this.txtHireOriginAmt.requestFocus();
            SysUtil.abort();
        }
        if (this.txtHireNaturalAmt.getBigDecimalValue() != null && this.txtHireNaturalAmt.getBigDecimalValue().compareTo(FaClientUtils.MAX_DECIMAL) > 0) {
            info = EASResource.getString((String)RES_PATH, (String)"hireLocalAmtMorethanMax");
            MsgBox.showInfo((String)info.replaceFirst("[{}]", FaClientUtils.MAX_DECIMAL.toString()).replaceFirst("}", ""));
            this.txtHireNaturalAmt.requestFocus();
            SysUtil.abort();
        }
        if (this.txtSubsNaturalAmt.getBigDecimalValue() != null && this.txtSubsNaturalAmt.getBigDecimalValue().compareTo(FaClientUtils.MAX_DECIMAL) > 0) {
            info = EASResource.getString((String)RES_PATH, (String)"subsLocalAmtMorethanMax");
            MsgBox.showInfo((String)info.replaceFirst("[{}]", FaClientUtils.MAX_DECIMAL.toString()).replaceFirst("}", ""));
            this.txtSubsNaturalAmt.requestFocus();
            SysUtil.abort();
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        BigDecimal sumShouldPayment = ZERO;
        this.leaseTable.refresh();
        this.fillLeaseTable();
        for (int i = 0; i < this.leaseTable.getRowCount(); ++i) {
            BigDecimal shouldPayment = (BigDecimal)this.leaseTable.getCell(i, "shouldPayment").getValue();
            sumShouldPayment = sumShouldPayment.add(shouldPayment == null ? ZERO : shouldPayment);
        }
        BigDecimal totalHireOrginAmt = this.txtHireNaturalAmt.getBigDecimalValue();
        boolean isHidedShouldPayment = this.leaseTable.getColumn("shouldPayment").getStyleAttributes().isHided();
        if (!isHidedShouldPayment && sumShouldPayment != null && totalHireOrginAmt != null && sumShouldPayment.compareTo(totalHireOrginAmt) != 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RES_PATH, (String)"notCompareToAmt"));
            SysUtil.abort();
        }
        super.actionSubmit_actionPerformed(e);
    }

    private KDTable getLeaseTable() {
        return this.leaseTable;
    }

    private void fillLeaseTable() {
        for (int i = 0; i < this.detailTable.getRowCount(); ++i) {
            this.calEntryHireAmt(i);
        }
        this.calTotalHireAmt();
        this.fillLeaseDetails();
    }

    private void fillLeaseDetails() {
        this.leaseTable.removeRows();
        BigDecimal amount = this.txtHireNaturalAmt.getBigDecimalValue();
        java.sql.Date beginDate = this.pkBeginDate.getSqlDate();
        java.sql.Date endDate = this.pkEndDate.getSqlDate();
        int bargainTime = this.txtBargainTime.getBigDecimalValue().intValue();
        DateUnitEnum measureUnit = (DateUnitEnum)((Object)this.comboMeasureUnit.getSelectedItem());
        String[] timeZone = null;
        int lineCount = Integer.MAX_VALUE;
        if (FaPayModeEnum.YEAR_PAY.equals(this.comboBoxPayMode.getSelectedItem())) {
            timeZone = FaLeaseUtils.getYearZone(beginDate, endDate);
            lineCount = measureUnit == DateUnitEnum.YEAR ? bargainTime : (measureUnit == DateUnitEnum.MONTH ? (int)Math.ceil((double)bargainTime / 12.0) : Integer.MAX_VALUE);
        } else if (FaPayModeEnum.SEASON_PAY.equals(this.comboBoxPayMode.getSelectedItem())) {
            timeZone = FaLeaseUtils.getSeasonZone(beginDate, endDate);
            lineCount = measureUnit == DateUnitEnum.YEAR ? bargainTime * 4 : (measureUnit == DateUnitEnum.MONTH ? (int)Math.ceil((double)bargainTime / 3.0) : Integer.MAX_VALUE);
        } else if (FaPayModeEnum.MONTH_PAY.equals(this.comboBoxPayMode.getSelectedItem())) {
            timeZone = FaLeaseUtils.getMonthZone(beginDate, endDate);
            lineCount = measureUnit == DateUnitEnum.YEAR ? bargainTime * 12 : (measureUnit == DateUnitEnum.MONTH ? bargainTime : Integer.MAX_VALUE);
        } else if (FaPayModeEnum.DAY_PAY.equals(this.comboBoxPayMode.getSelectedItem())) {
            timeZone = FaLeaseUtils.getDayZone(beginDate, endDate);
        } else {
            this.leaseTable.addRow();
            return;
        }
        BigDecimal sumValue = new BigDecimal("0");
        lineCount = Math.min(timeZone.length, lineCount);
        BigDecimal cellValue = amount.divide(new BigDecimal(lineCount), this.scale, 4);
        for (int i = 0; i < lineCount - 1; ++i) {
            this.leaseTable.addRow();
            this.leaseTable.getCell(i, "measureUnit").setValue((Object)timeZone[i]);
            this.leaseTable.getCell(i, "shouldPayment").setValue((Object)cellValue);
            sumValue = sumValue.add(cellValue);
        }
        this.leaseTable.addRow();
        this.leaseTable.getCell(lineCount - 1, "measureUnit").setValue((Object)timeZone[lineCount - 1]);
        this.leaseTable.getCell(lineCount - 1, "shouldPayment").setValue((Object)amount.subtract(sumValue));
    }

    private void loadLeaseBalance(String billId) throws BOSException {
        CoreBaseCollection balances = this.getBalance(billId);
        FaLeaseBalanceEntryCollection entries = new FaLeaseBalanceEntryCollection();
        if (balances.size() == 0) {
            return;
        }
        entries = ((FaLeaseBalanceBillInfo)balances.get(0)).getEntry();
        entries = FaLeaseUtils.resortBalance(entries);
        for (int i = 0; i < entries.size(); ++i) {
            FaLeaseBalanceEntryInfo entry = entries.get(i);
            int rowIndex = entry.getSeq() - 1;
            IRow row = this.leaseTable.getRow(rowIndex);
            if (row == null) {
                row = this.leaseTable.addRow();
            }
            row.getCell("actualPayment").setValue((Object)entry.getActualPayment().setScale(this.scale, 4));
            row.getCell("paymentType").setValue((Object)entry.getPaymentType().toString());
            row.getCell("paymentDate").setValue((Object)entry.getPaymentDate());
            row.getCell("balanceType").setValue(entry.getBalanceType() == null ? null : entry.getBalanceType().getName());
            row.getCell("balanceNumber").setValue((Object)entry.getBalanceNumber());
            row.getCell("bank").setValue(entry.getBank() == null ? null : entry.getBank().getName());
            row.getCell("paymentAccount").setValue(entry.getPaymentAccount() == null ? null : entry.getPaymentAccount().getName());
            row.getCell("paymentAcctView").setValue(entry.getPaymentAcctView() == null ? null : entry.getPaymentAcctView().getNumber() + " - " + entry.getPaymentAcctView().getName());
            row.getCell("paymentOppAcctView").setValue(entry.getPaymentOppAcctView() == null ? null : entry.getPaymentOppAcctView().getNumber() + " - " + entry.getPaymentOppAcctView().getName());
            row.getCell("relatedNumber").setValue((Object)entry.getRelatedNumber());
            row.getCell("realPayment").setValue((Object)entry.getRealPayment().setScale(this.scale, 4));
            row.getCell("feeAcctView").setValue(entry.getFeeAcctView() == null ? null : entry.getFeeAcctView().getNumber() + " - " + entry.getFeeAcctView().getName());
            row.getCell("feeOppAcctView").setValue(entry.getFeeOppAcctView() == null ? null : entry.getFeeOppAcctView().getNumber() + " - " + entry.getFeeOppAcctView().getName());
            row.getCell("handler").setValue((Object)entry.getHandler().getName());
            String isCheck = entry.getCheckedStatus().getValue() == 2 ? EASResource.getString((String)RES_PATH, (String)"hasAudit") : (entry.isCheckStatus() ? EASResource.getString((String)RES_PATH, (String)"hasCheck") : EASResource.getString((String)RES_PATH, (String)"hasSubmit"));
            row.getCell("checkedStatus").setValue((Object)isCheck);
            String vchNumber = this.getVchNumber(entry.getId().toString());
            row.getCell("vchNumber").setValue((Object)(vchNumber == null ? null : vchNumber));
            row.getCell("isPayment").setValue((Object)(entry.isIsPayment() ? EASResource.getString((String)RES_PATH, (String)"paymentBill") : EASResource.getString((String)RES_PATH, (String)"gatheringBill")));
            row.getCell("id").setValue((Object)entry.getId().toString());
        }
    }

    private CoreBaseCollection getBalance(String billId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new String("entry.actualPayment"));
        sic.add(new String("entry.paymentType"));
        sic.add(new String("entry.paymentDate"));
        sic.add(new String("entry.balanceType.name"));
        sic.add(new String("entry.balanceNumber"));
        sic.add(new String("entry.bank.name"));
        sic.add(new String("entry.paymentAccount.name"));
        sic.add(new String("entry.paymentAccount.number"));
        sic.add(new String("entry.paymentAcctView.name"));
        sic.add(new String("entry.paymentAcctView.number"));
        sic.add(new String("entry.paymentOppAcctView.name"));
        sic.add(new String("entry.relatedNumber"));
        sic.add(new String("entry.realPayment"));
        sic.add(new String("entry.feeAcctView.name"));
        sic.add(new String("entry.feeAcctView.number"));
        sic.add(new String("entry.feeOppAcctView.name"));
        sic.add(new String("entry.feeOppAcctView.number"));
        sic.add(new String("entry.handler.name"));
        sic.add(new String("entry.checkedStatus"));
        sic.add(new String("entry.checkStatus"));
        sic.add(new String("entry.voucher.number"));
        sic.add(new String("entry.seq"));
        sic.add(new String("entry.isPayment"));
        sic.add(new String("entry.id"));
        sic.add(new String("id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("leaseOutBill.id", (Object)billId));
        filter.setMaskString("#0");
        view.setFilter(filter);
        String oql = "select *,entry.*,entry.paymentAccount.name,entry.paymentAccount.number,entry.paymentAcctView.name,entry.paymentAcctView.number,entry.paymentOppAcctView.name,entry.paymentOppAcctView.number,";
        oql = oql + "entry.feeAcctView.name,entry.feeAcctView.number,entry.feeOppAcctView.name,entry.feeOppAcctView.number,entry.bank.name,entry.balanceType.name,entry.handler.name ";
        CoreBaseCollection balances = FaLeaseBalanceBillFactory.getRemoteInstance().getCollection(oql + "where leaseOutBill.id='" + billId + "'");
        return balances;
    }

    private String getVchNumber(String srcBillId) throws BOSException {
        String vchNumber = null;
        ArrayList relationCollection = BOTRelationFactory.getRemoteInstance().getDestObjIdByDestType(srcBillId, VOUCHERTYPE);
        if (relationCollection != null && relationCollection.size() > 0) {
            HashSet<String> keySet = new HashSet<String>();
            keySet.add(relationCollection.get(0).toString());
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("number"));
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", keySet, CompareType.INCLUDE));
            VoucherCollection vchCollection = VoucherFactory.getRemoteInstance().getVoucherCollection(view);
            if (vchCollection != null && vchCollection.get(0) != null) {
                vchNumber = vchCollection.get(0).getNumber().toString();
            }
        }
        return vchNumber;
    }

    private void comboHireCurrency_itemStateChanged(ItemEvent e) {
        if (e == null || e.getStateChange() != 1) {
            return;
        }
        this.setOrigCurrencyRate();
        this.setExRateAndScale(this.comboHireCurrency, this.txtHireOriginAmt, this.txtHireExRate, "ADDNEW".equals(this.getOprtState()) || "EDIT".equals(this.getOprtState()), HIRE_TYPE);
        this.lockCurrency();
    }

    private void comboSubsCurrency_itemStateChanged(ItemEvent e) {
        if (e == null || e.getStateChange() != 1) {
            return;
        }
        this.setExRateAndScale(this.comboSubsCurrency, this.txtSubsOriginAmt, this.txtSubsExRate, "ADDNEW".equals(this.getOprtState()) || "EDIT".equals(this.getOprtState()), HIRE_TYPE);
        if ("ADDNEW".equals(this.getOprtState()) || "EDIT".equals(this.getOprtState())) {
            boolean editable;
            boolean bl = editable = e.getItem() != null;
            if (!editable) {
                this.txtSubsOriginAmt.setValue(null);
                this.txtSubsExRate.setValue(null);
            }
            this.txtSubsOriginAmt.setEditable(editable);
            this.txtSubsExRate.setEditable(editable);
        }
        this.lockCurrency();
    }

    public HashMap gethmParam() {
        HashMap hmParam = new HashMap();
        try {
            hmParam = FaManageUtils.getFAParameter(this.getCurrentCompany().getId());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return hmParam;
    }

    @Override
    protected FilterInfo getCardFilter() {
        FilterInfo filter = super.getCardFilter();
        boolean isAutoCreateChangeBillByRequi = "true".equals(this.gethmParam().get("FA_044").toString());
        if (isAutoCreateChangeBillByRequi) {
            String hasRequisitionNotRefunding = "select FCurCardID from T_FA_FaRequisitionedBillEntry billEntry inner join T_FA_FaCurCard curCard on curCard.FID = billEntry.FCurCardID where curCard.FKeeperID not in (select FManageID from T_FA_FaTreasuryManage) and curCard.FCompanyID = '" + this.getCurrentCompanyID() + "'";
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)hasRequisitionNotRefunding, CompareType.NOTINNER));
        }
        String hasBorrowingNotReturn = "select FCurCardID from T_FA_FaBorrowingEntry where FIsReturned = 0";
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)hasBorrowingNotReturn, CompareType.NOTINNER));
        return filter;
    }
}

