/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.NewAdminF7;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.basedata.org.client.f7.NewCostCenterF7;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.FaUtils;
import com.kingdee.eas.fi.fa.basedata.client.FaContractCatPromptBox;
import com.kingdee.eas.fi.fa.manage.FaLeaseChangeBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaLeaseChangeBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseChangeBillFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseChangeBillInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillNewCollection;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.fa.manage.FaLessorTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaRentDirectionEnum;
import com.kingdee.eas.fi.fa.manage.IFaLeaseChangeBill;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaLeaseChangeBillEditUI;
import com.kingdee.eas.fi.fa.manage.client.CommonQueryLeaseDialog;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.manage.client.FaPrintHelper;
import com.kingdee.eas.fi.fa.manage.client.flutils.FlUtils;
import com.kingdee.eas.framework.BillBaseCollection;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class FaLeaseChangeBillEditUI
extends AbstractFaLeaseChangeBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(FaLeaseChangeBillEditUI.class);
    private CompanyOrgUnitInfo currCompany;
    private PeriodInfo currPeriod;
    private FaRentDirectionEnum curRentDir = FaRentDirectionEnum.RENT_IN;
    private int currPrecision = 2;
    private boolean isUseWorkflow;
    private static String RES_PATH_CARD = "com.kingdee.eas.fi.fa.manage.FaCardResource";
    private static String RES_PATH_LEASECHANGE = "com.kingdee.eas.fi.fa.manage.FaLeaseChangeResource";
    private static final String KEY_LEASEINBILL = "leaseInBill";
    private static final String KEY_LEASEINNUM = "leaseInNum";
    private static final String KEY_CONTRACTNUM = "contractNum";
    private static final String KEY_CONTRACTNAMEOLD = "contractNameOld";
    private static final String KEY_CONTRACTNAMENEW = "contractNameNew";
    private static final String KEY_CONTRACTCATOLD = "contractCatOld";
    private static final String KEY_CONTRACTCATNEW = "contractCatNew";
    private static final String KEY_RENTINOUTOBJOLD = "rentInOutObjOld";
    private static final String KEY_RENTINOUTOBJNEW = "rentInOutObjNew";
    private static final String KEY_RENTINOUTOBJTYPENEW = "rentInOutObjTypeNew";
    private static final String KEY_RENTINOUTOBJTYPEOLD = "rentInOutObjTypeOld";
    private static final String KEY_INNERCOMPANYOLD = "innerCompanyOld";
    private static final String KEY_INNERCOMPANYNEW = "innerCompanyNew";
    private static final String KEY_CUSTOMEROLD = "customerOld";
    private static final String KEY_CUSTOMERNEW = "customerNew";
    private static final String KEY_SUPPLIEROLD = "supplierOld";
    private static final String KEY_SUPPLIERNEW = "supplierNew";
    private static final String KEY_USEDEPARTMENTOLD = "useDepartmentOld";
    private static final String KEY_USEDEPARTMENTNEW = "useDepartmentNew";
    private static final String KEY_COSTCENTEROLD = "costCenterOld";
    private static final String KEY_COSTCENTERNEW = "costCenterNew";
    private static final String KEY_INITASSET = "initAsset";
    private static final String KEY_INITLIABILITY = "initLiability";
    private static final String KEY_UNFNFEE = "unFnFee";
    private static final String KEY_RECEIVEDORPAIDAMT = "receivedOrPaidAmt";
    private static final String KEY_ACCDEPR = "accDepr";
    private static final String KEY_ACCINTERESTEXPE = "accInterestExp";
    private static final String KEY_BIZSTATUSOLD = "bizStatusOld";
    private static final String KEY_FIVOUCHERED = "fiVouchered";
    private static final String KEY_InitialAssetDecValue = "initialAssetDecValue";
    private ObjectValueRender nameRender = new ObjectValueRender();
    private ObjectValueRender displayNameRender = new ObjectValueRender();
    private FaLeaseChangeBillEntryCollection entriesOld;

    public void onLoad() throws Exception {
        this.currCompany = this.getCurrentCompany();
        this.currPrecision = this.currCompany.getBaseCurrency().getPrecision();
        this.currPeriod = this.getCurrPeriod();
        FaClientUtils.checkBeforeOnload4Fl(this.getUIContext(), this.currCompany);
        super.onLoad();
        this.initCtrlComponent();
        this.initUI();
        this.getMainStatusBar().setPerTitle(this.getStatusBarTitle());
    }

    public FaLeaseChangeBillEditUI() throws Exception {
        this.nameRender.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.displayNameRender.setFormat((IDataFormat)new BizDataFormat("$displayName$"));
    }

    protected void checkPeriod() {
        if (this.currPeriod == null) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.notConfigStartPeriod");
            MsgBox.showInfo((Component)((Object)this), (String)strMsg);
            SysUtil.abort();
        }
    }

    protected String getStatusBarTitle() {
        if (this.currCompany != null && !this.currCompany.isIsBizUnit()) {
            return null;
        }
        if (this.currPeriod == null) {
            return null;
        }
        return EASResource.getString((String)RES_PATH_CARD, (String)"currentPeriod") + MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"displayPeriod"), this.currPeriod.getPeriodYear(), this.currPeriod.getPeriodNumber());
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        if ("EDIT".equals(oprtType) || "ADDNEW".equals(oprtType)) {
            this.btnAddRow.setEnabled(true);
            this.btnDeleteRow.setEnabled(true);
        } else {
            this.btnAddRow.setEnabled(false);
            this.btnDeleteRow.setEnabled(false);
        }
    }

    private void initUI() throws Exception {
        this.setPreferredSize(new Dimension(1050, 629));
        this.menuTable1.setVisible(false);
        this.menuTable1.setEnabled(false);
        this.btnAddLine.setVisible(false);
        this.btnAddLine.setEnabled(false);
        this.btnInsertLine.setVisible(false);
        this.btnInsertLine.setEnabled(false);
        this.btnRemoveLine.setVisible(false);
        this.btnRemoveLine.setEnabled(false);
        this.menuItemCreateFrom.setVisible(false);
        this.menuItemCreateFrom.setEnabled(false);
        this.btnCreateFrom.setVisible(false);
        this.btnCreateFrom.setEnabled(false);
        this.btnRemove.setVisible(false);
        this.btnRemove.setEnabled(false);
        this.actionCopyFrom.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionTraceUp.setVisible(false);
        this.actionVoucher.setVisible(true);
        this.actionDelVoucher.setVisible(true);
        this.setWorkflowVisible();
        this.txtNumber.setEnabled(true);
        this.txtNumber.setEditable(false);
        this.comboRentDirection.setEnabled(false);
        this.comboRentDirection.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (FaLeaseChangeBillEditUI.this.curRentDir.getValue() != ((FaRentDirectionEnum)((Object)e.getItem())).getValue() && e.getStateChange() == 1) {
                    FaLeaseChangeBillEditUI.this.comboRentDirection.setSelectedItem((Object)FaRentDirectionEnum.RENT_IN, false);
                }
            }
        });
        this.btnAddRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FaLeaseChangeBillEditUI.this.onAddRow(e);
            }
        });
        this.btnDeleteRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FaLeaseChangeBillEditUI.this.actionRemoveLine_actionPerformed(e);
                    FaLeaseChangeBillEditUI.this.calcTableTotalAmt();
                }
                catch (Exception ex) {
                    FaLeaseChangeBillEditUI.this.handleException(ex);
                }
            }
        });
        this.pkDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                Date changeDate = (Date)eventObj.getNewValue();
                if (FaLeaseChangeBillEditUI.this.currPeriod != null && (DateTimeUtils.dayBefore((Date)changeDate, (Date)FaLeaseChangeBillEditUI.this.currPeriod.getBeginDate()) || DateTimeUtils.dayAfter((Date)changeDate, (Date)FaLeaseChangeBillEditUI.this.currPeriod.getEndDate()))) {
                    FaLeaseChangeBillEditUI.this.pkDate.setValue(eventObj.getOldValue(), false);
                    FaLeaseChangeBillEditUI.this.pkDate.requestFocus();
                    MsgBox.showInfo((Component)((Object)FaLeaseChangeBillEditUI.this), (String)EASResource.getString((String)RES_PATH_LEASECHANGE, (String)"DATE_OUT_PERIOD"));
                    SysUtil.abort();
                }
                FaLeaseChangeBillEditUI.this.updateRcvPaidColumn();
            }
        });
        this.txtDescription.setMaxLength(200);
        this.calcTableTotalAmt();
        KDBizPromptBox prmtContractCat = new KDBizPromptBox();
        FaContractCatPromptBox faContractCatPromptBox = new FaContractCatPromptBox((CoreUIObject)this);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)true));
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
        viewInfo.setFilter(filterInfo);
        prmtContractCat.setSelector((KDPromptSelector)faContractCatPromptBox);
        prmtContractCat.setQueryInfo("com.kingdee.eas.fi.fa.basedata.app.FaContractCatF7Query");
        prmtContractCat.setEntityViewInfo(viewInfo);
        prmtContractCat.setEditable(true);
        prmtContractCat.setDisplayFormat("$longnumber$ $name$");
        prmtContractCat.setEditFormat("$longnumber$");
        prmtContractCat.setCommitFormat("$longnumber$");
        KDTDefaultCellEditor prmtCCCellEditor = new KDTDefaultCellEditor((IKDEditor)prmtContractCat);
        this.kdtEntries.getColumn(KEY_CONTRACTCATOLD).setEditor((ICellEditor)prmtCCCellEditor);
        this.kdtEntries.getColumn(KEY_CONTRACTCATNEW).setEditor((ICellEditor)prmtCCCellEditor);
        KDBizPromptBox prmtUseDepartment = new KDBizPromptBox();
        prmtUseDepartment.setEditable(true);
        prmtUseDepartment.setQueryInfo("com.kingdee.eas.sem.mp.app.AdminOrgUnitF7");
        prmtUseDepartment.setDisplayFormat("$number$");
        prmtUseDepartment.setEditFormat("$number$");
        prmtUseDepartment.setCommitFormat("$number$");
        NewAdminF7 adminF7 = new NewAdminF7((IUIObject)this);
        prmtUseDepartment.setSelector((KDPromptSelector)adminF7);
        this.kdtEntries.getColumn(KEY_USEDEPARTMENTNEW).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtUseDepartment));
        KDBizPromptBox prmtCostCenter = FaClientUtils.getAsstTypeItemF7();
        NewCostCenterF7 costCenterF7 = new NewCostCenterF7((IUIObject)this);
        costCenterF7.setNeedAddOrgRange(true);
        prmtCostCenter.setQueryInfo("com.kingdee.eas.basedata.org.app.CostCenterItemQuery");
        prmtCostCenter.setSelector((KDPromptSelector)costCenterF7);
        prmtCostCenter.setEditable(true);
        prmtCostCenter.setDisplayFormat("$number$ $name$");
        prmtCostCenter.setEditFormat("$number$");
        prmtCostCenter.setCommitFormat("$number$");
        this.kdtEntries.getColumn(KEY_COSTCENTERNEW).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtCostCenter));
        this.kdtEntries.getColumn(KEY_COSTCENTERNEW).setRequired(true);
        KDTextField txtField = new KDTextField();
        txtField.setMaxLength(200);
        KDTDefaultCellEditor txtCellEditor = new KDTDefaultCellEditor((JTextField)txtField);
        this.kdtEntries.getColumn(KEY_RENTINOUTOBJOLD).setEditor((ICellEditor)txtCellEditor);
        this.kdtEntries.getColumn(KEY_RENTINOUTOBJNEW).setEditor((ICellEditor)txtCellEditor);
        this.kdtEntries.getColumn(KEY_CONTRACTNAMEOLD).setEditor((ICellEditor)txtCellEditor);
        this.kdtEntries.getColumn(KEY_CONTRACTNAMENEW).setEditor((ICellEditor)txtCellEditor);
        KDComboBox cmbRentInOut = new KDComboBox();
        cmbRentInOut.addItems(FaLessorTypeEnum.getEnumList().toArray());
        KDTDefaultCellEditor cmbCellEditor = new KDTDefaultCellEditor((JComboBox)cmbRentInOut);
        this.kdtEntries.getColumn(KEY_RENTINOUTOBJTYPENEW).setEditor((ICellEditor)cmbCellEditor);
        this.kdtEntries.getColumn(KEY_RENTINOUTOBJTYPEOLD).setEditor((ICellEditor)cmbCellEditor);
        KDBizPromptBox prmtRentInOut = new KDBizPromptBox();
        KDTDefaultCellEditor rentInOutCellEditor = new KDTDefaultCellEditor((IKDEditor)prmtRentInOut);
        this.kdtEntries.getColumn(KEY_RENTINOUTOBJNEW).setEditor((ICellEditor)rentInOutCellEditor);
        this.kdtEntries.getColumn(KEY_RENTINOUTOBJOLD).setEditor((ICellEditor)rentInOutCellEditor);
        this.kdtEntries.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                FaLeaseChangeBillEditUI.this.onActiveRentInOutObjCellChanged(e);
            }
        });
        this.kdtEntries.addKDTEditListener(new KDTEditListener(){

            public void editValueChanged(KDTEditEvent e) {
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                if (e.getColIndex() == FaLeaseChangeBillEditUI.this.kdtEntries.getColumnIndex(FaLeaseChangeBillEditUI.KEY_RENTINOUTOBJTYPENEW) && FaLeaseChangeBillEditUI.this.isObjChange(e.getOldValue(), e.getValue())) {
                    FaLeaseChangeBillEditUI.this.kdtEntries.getCell(e.getRowIndex(), FaLeaseChangeBillEditUI.KEY_RENTINOUTOBJNEW).setValue(null);
                    FaLeaseChangeBillEditUI.this.setNewRentInOutObjs(e.getRowIndex(), null, null, null);
                }
                if (e.getColIndex() == FaLeaseChangeBillEditUI.this.kdtEntries.getColumnIndex(FaLeaseChangeBillEditUI.KEY_RENTINOUTOBJNEW)) {
                    FaLeaseChangeBillEditUI.this.updateRentInOutData(e.getRowIndex());
                }
            }

            public void editStarting(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editCanceled(KDTEditEvent e) {
            }
        });
        String[] keyArr = new String[]{KEY_INITASSET, KEY_INITLIABILITY, KEY_UNFNFEE, KEY_RECEIVEDORPAIDAMT, KEY_ACCDEPR, KEY_ACCINTERESTEXPE};
        FaClientUtils.changeTableNumberFormat(this.kdtEntries, keyArr, FaClientUtils.getDecimalFormat(this.currPrecision));
    }

    protected void initCtrlComponent() throws Exception {
        FaUtils.freezeTable((KDTable)this.getDetailTable(), (int)2);
    }

    private boolean isObjChange(Object oldObj, Object newObj) {
        if (oldObj == null && newObj != null) {
            return true;
        }
        if (oldObj != null && newObj == null) {
            return true;
        }
        if (oldObj == null && newObj == null) {
            return false;
        }
        return !oldObj.equals(newObj);
    }

    private void onPrmtRentInOutDataChange(DataChangeEvent eventObj) {
        int activeIndex = this.kdtEntries.getSelectManager().getActiveRowIndex();
        ICell rentInOutTypeCell = this.kdtEntries.getCell(activeIndex, KEY_RENTINOUTOBJTYPENEW);
        if (rentInOutTypeCell.getValue() == null) {
            this.setNewRentInOutObjs(activeIndex, null, null, null);
            return;
        }
        FaLessorTypeEnum item = (FaLessorTypeEnum)((Object)rentInOutTypeCell.getValue());
        switch (item.getValue()) {
            case 3: {
                this.setNewRentInOutObjs(activeIndex, eventObj.getNewValue(), null, null);
                break;
            }
            case 2: {
                this.setNewRentInOutObjs(activeIndex, null, eventObj.getNewValue(), null);
                break;
            }
            case 1: {
                this.setNewRentInOutObjs(activeIndex, null, null, eventObj.getNewValue());
                break;
            }
        }
    }

    private void updateRentInOutData(int rowIndex) {
        ICell rentInOutTypeCell = this.kdtEntries.getCell(rowIndex, KEY_RENTINOUTOBJTYPENEW);
        if (rentInOutTypeCell.getValue() == null || "".equals(rentInOutTypeCell.getValue())) {
            this.setNewRentInOutObjs(rowIndex, null, null, null);
            return;
        }
        FaLessorTypeEnum item = (FaLessorTypeEnum)((Object)rentInOutTypeCell.getValue());
        Object obj = this.kdtEntries.getCell(rowIndex, KEY_RENTINOUTOBJNEW).getValue();
        switch (item.getValue()) {
            case 3: {
                this.setNewRentInOutObjs(rowIndex, obj, null, null);
                break;
            }
            case 2: {
                this.setNewRentInOutObjs(rowIndex, null, obj, null);
                break;
            }
            case 1: {
                this.setNewRentInOutObjs(rowIndex, null, null, obj);
                break;
            }
        }
    }

    private void setNewRentInOutObjs(int activeIndex, Object company, Object customer, Object supplier) {
        this.kdtEntries.getCell(activeIndex, KEY_INNERCOMPANYNEW).setValue(company);
        this.kdtEntries.getCell(activeIndex, KEY_CUSTOMERNEW).setValue(customer);
        this.kdtEntries.getCell(activeIndex, KEY_SUPPLIERNEW).setValue(supplier);
    }

    private void onActiveRentInOutObjCellChanged(KDTActiveCellEvent e) {
        if (e.getColumnIndex() != this.kdtEntries.getColumnIndex(KEY_RENTINOUTOBJNEW)) {
            return;
        }
        ICell cell = this.kdtEntries.getCell(e.getRowIndex(), KEY_RENTINOUTOBJTYPENEW);
        if (cell == null) {
            return;
        }
        Object item = cell.getValue();
        KDBizPromptBox prmtRentInOut = (KDBizPromptBox)this.kdtEntries.getColumn(KEY_RENTINOUTOBJNEW).getEditor().getComponent();
        if (item == null || item == FaLessorTypeEnum.NONE) {
            prmtRentInOut.setValue(null);
            prmtRentInOut.setEnabled(false);
            return;
        }
        FaLessorTypeEnum lessorTypeItem = (FaLessorTypeEnum)((Object)item);
        if (lessorTypeItem.getValue() == 3) {
            prmtRentInOut.setEnabled(true);
            prmtRentInOut.setValue(null);
            NewCompanyF7 aCompanyF7 = new NewCompanyF7((IUIObject)this);
            aCompanyF7.setRootUnitID("00000000-0000-0000-0000-000000000000CCE7AED4");
            aCompanyF7.setNeedAddOrgRange(false);
            prmtRentInOut.setSelector((KDPromptSelector)aCompanyF7);
            prmtRentInOut.setFilterInfoProducer((IFilterInfoProducer)new NewOrgUnitFilterInfoProducer(OrgType.Company));
            prmtRentInOut.setEnabledMultiSelection(false);
            prmtRentInOut.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
            prmtRentInOut.setCommitFormat("$number$;$code$");
            prmtRentInOut.setDisplayFormat("$name$");
            prmtRentInOut.setEditFormat("$number$");
        } else if (lessorTypeItem.getValue() == 2) {
            prmtRentInOut.setEnabled(true);
            prmtRentInOut.setData(null);
            prmtRentInOut.setSelector(null);
            prmtRentInOut.setCommitFormat("$number$;$mnemonicCode$;$name$");
            prmtRentInOut.setEditFormat("$number$");
            prmtRentInOut.setDisplayFormat("$name$");
            prmtRentInOut.setFilterInfoProducer(null);
            prmtRentInOut.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7CustomerWithDefaultStandardQuery");
        } else if (lessorTypeItem.getValue() == 1) {
            prmtRentInOut.setEnabled(true);
            prmtRentInOut.setData(null);
            prmtRentInOut.setSelector(null);
            prmtRentInOut.setCommitFormat("$number$;$mnemonicCode$;$name$");
            prmtRentInOut.setEditFormat("$number$");
            prmtRentInOut.setDisplayFormat("$name$");
            prmtRentInOut.setFilterInfoProducer(null);
            prmtRentInOut.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7SupplierWithDefaultStandardQuery");
        }
    }

    private void onAddRow(ActionEvent e) {
        try {
            CommonQueryLeaseDialog dialog = this.initDialog();
            if (dialog.show() || dialog.hasKeyValue()) {
                IObjectCollection leaseBillCol = dialog.getSelectedLeaseBillCol();
                this.setTable(leaseBillCol, e);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    protected void setWorkflowVisible() throws EASBizException, BOSException {
        this.isUseWorkflow = FaManageUtils.isUseWorkflow(null, this.getCurrentCompany().getId().toString(), ((Object)((Object)this)).getClass());
        this.actionAudit.setBindWorkFlow(this.isUseWorkflow && this.isBindWorkFlow());
        this.actionUnAudit.setBindWorkFlow(this.isUseWorkflow && this.isBindWorkFlow());
        this.actionSubmit.setBindWorkFlow(this.isUseWorkflow && this.isBindWorkFlow());
        this.actionRemove.setBindWorkFlow(this.isUseWorkflow && this.isBindWorkFlow());
        this.menuTool.setVisible(false);
        if (this.isUseWorkflow && this.isBindWorkFlow()) {
            this.menuItemAudit.setAction(null);
            this.btnAudit.setAction(null);
        }
        this.menuItemAudit.setVisible(!this.isUseWorkflow && this.isBindWorkFlow());
        this.btnAudit.setVisible(!this.isUseWorkflow && this.isBindWorkFlow());
        this.hideOrShowWorkflow(this.isUseWorkflow);
        this.hideOrShowAuditResult(this.isUseWorkflow);
    }

    public boolean isBindWorkFlow() {
        return true;
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        this.setDefaultValue(dataObject);
    }

    protected void setDefaultValue(IObjectValue dataObject) {
        FaLeaseChangeBillInfo billInfo = (FaLeaseChangeBillInfo)dataObject;
        if (billInfo.getId() == null || billInfo.getId().equals((Object)"")) {
            try {
                CompanyOrgUnitInfo company = this.getCurrentCompany();
                billInfo.setCompany(company);
                billInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
                billInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
                billInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
                billInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
                billInfo.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
                billInfo.setFiVouchered(false);
                UserInfo aUserInfo = SysContext.getSysContext().getCurrentUserInfo();
                billInfo.setHandler(aUserInfo);
                billInfo.setCreator(aUserInfo);
                billInfo.setPeriod(this.getCurrPeriod());
                billInfo.setLastUpdateTime(null);
                billInfo.setLastUpdateUser(null);
                billInfo.setAuditor(null);
                billInfo.setCreateTime(null);
                billInfo.setBizDate(null);
                billInfo.setNumber(this.getRuleNumber(billInfo));
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        }
    }

    protected void setDefaultUIButtonStatus() {
        if (this.editData != null) {
            this.actionAudit.setEnabled(this.editData.getCheckedStatus() != CheckedStatusEnum.AUDITED);
            this.actionUnAudit.setEnabled(this.editData.getCheckedStatus() == CheckedStatusEnum.AUDITED);
        } else {
            this.actionAudit.setEnabled(true);
            this.actionUnAudit.setEnabled(false);
        }
        if (FaClientUtils.isFromWorkflow(this.getUIContext())) {
            this.actionEdit.setEnabled(false);
        }
        if (this.editData != null) {
            if (OprtState.ADDNEW.equals(this.getOprtState()) || OprtState.EDIT.equals(this.getOprtState())) {
                this.actionEdit.setEnabled(false);
            } else {
                this.actionEdit.setEnabled(this.editData.getCheckedStatus() != CheckedStatusEnum.AUDITED);
            }
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.entriesOld = this.editData.getEntries();
        this.setOprtState(this.getOprtState());
        this.pkCreateTime.setTimePattern("yyyy-MM-dd hh:MM:ss");
        this.pkLastUpdateTime.setTimePattern("yyyy-MM-dd hh:MM:ss");
        if ("ADDNEW".equals(this.getOprtState())) {
            try {
                if (this.editData.getEffectedStatus() == null) {
                    this.pkCreateTime.setTimePattern("");
                    this.pkLastUpdateTime.setTimePattern("");
                }
                PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)this.getCurrentCompany());
                this.pkDate.setValue((Object)currPeriodInfo.getEndDate());
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        this.updateDapBtnStatus();
        this.setDefaultUIButtonStatus();
    }

    private void updateDapBtnStatus() {
        block5: {
            if (this.editData.getCheckedStatus() == CheckedStatusEnum.AUDITED) {
                try {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(KEY_FIVOUCHERED);
                    CoreBaseInfo sourceBill = this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(this.editData.getId()), sic);
                    if (sourceBill.getBoolean(KEY_FIVOUCHERED)) {
                        this.actionVoucher.setEnabled(false);
                        this.actionDelVoucher.setEnabled(true);
                        break block5;
                    }
                    this.actionVoucher.setEnabled(true);
                    this.actionDelVoucher.setEnabled(false);
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            } else {
                this.actionVoucher.setEnabled(false);
                this.actionDelVoucher.setEnabled(false);
            }
        }
    }

    private void setTable(IObjectCollection leaseBillCol, ActionEvent e) throws Exception {
        if (leaseBillCol != null && leaseBillCol.size() > 0 && this.comboRentDirection.getSelectedIndex() == 0 && leaseBillCol instanceof FaLeaseInBillNewCollection) {
            int rowCount = this.kdtEntries.getRowCount();
            Set<String> idSet = this.col2IdSet(leaseBillCol);
            Map<String, BigDecimal> rpAmtMap = this.getRcvPaidAmt(idSet);
            Map<String, BigDecimal[]> diAmtMap = this.getDeprInterestAmt(idSet);
            Map<String, BigDecimal[]> initAmtMap = this.getInitAmt(idSet);
            block0: for (int i = 0; i < leaseBillCol.size(); ++i) {
                for (int j = 0; j < rowCount; ++j) {
                    String leaseId1 = this.getString(leaseBillCol.getObject(i).get("id"));
                    String leaseId2 = ((FaLeaseInBillNewInfo)this.kdtEntries.getRow(j).getCell(KEY_LEASEINBILL).getValue()).getId().toString();
                    if (leaseId2.equals(leaseId1)) continue block0;
                }
                this.actionAddLine_actionPerformed(e);
                String leaseInBillId = this.getString(leaseBillCol.getObject(i).get("id"));
                IRow row = this.kdtEntries.getRow(this.kdtEntries.getRowCount() - 1);
                row.getCell(KEY_LEASEINBILL).setValue((Object)leaseBillCol.getObject(i));
                row.getCell(KEY_LEASEINNUM).setValue((Object)this.getString(leaseBillCol.getObject(i).get("number")));
                row.getCell(KEY_CONTRACTCATOLD).setValue(leaseBillCol.getObject(i).get("contractCat"));
                row.getCell(KEY_CONTRACTCATNEW).setValue(leaseBillCol.getObject(i).get("contractCat"));
                row.getCell(KEY_CONTRACTNUM).setValue((Object)this.getString(leaseBillCol.getObject(i).get("contractNumber")));
                row.getCell(KEY_CONTRACTNAMEOLD).setValue(leaseBillCol.getObject(i).get("contractName"));
                row.getCell(KEY_CONTRACTNAMENEW).setValue(leaseBillCol.getObject(i).get("contractName"));
                row.getCell(KEY_USEDEPARTMENTOLD).setValue(leaseBillCol.getObject(i).get("useDepartment"));
                row.getCell(KEY_USEDEPARTMENTNEW).setValue(leaseBillCol.getObject(i).get("useDepartment"));
                row.getCell(KEY_COSTCENTEROLD).setValue(leaseBillCol.getObject(i).get("costCenter"));
                row.getCell(KEY_COSTCENTERNEW).setValue(leaseBillCol.getObject(i).get("costCenter"));
                row.getCell(KEY_RENTINOUTOBJTYPEOLD).setValue((Object)this.getLessorType(leaseBillCol.getObject(i).get("lessorType")));
                row.getCell(KEY_RENTINOUTOBJTYPENEW).setValue((Object)this.getLessorType(leaseBillCol.getObject(i).get("lessorType")));
                row.getCell(KEY_RENTINOUTOBJOLD).setValue((Object)this.getString(leaseBillCol.getObject(i).get("lessor")));
                row.getCell(KEY_RENTINOUTOBJNEW).setValue((Object)this.getString(leaseBillCol.getObject(i).get("lessor")));
                row.getCell(KEY_INNERCOMPANYNEW).setValue(leaseBillCol.getObject(i).get("innerCompanyLessor"));
                row.getCell(KEY_INNERCOMPANYOLD).setValue(leaseBillCol.getObject(i).get("innerCompanyLessor"));
                row.getCell(KEY_CUSTOMERNEW).setValue(leaseBillCol.getObject(i).get("customerLessor"));
                row.getCell(KEY_CUSTOMEROLD).setValue(leaseBillCol.getObject(i).get("customerLessor"));
                row.getCell(KEY_SUPPLIERNEW).setValue(leaseBillCol.getObject(i).get("supplierLessor"));
                row.getCell(KEY_SUPPLIEROLD).setValue(leaseBillCol.getObject(i).get("supplierLessor"));
                row.getCell(KEY_INITASSET).setValue((Object)this.getBD(initAmtMap.get(leaseInBillId)[0], this.currPrecision));
                row.getCell(KEY_INITLIABILITY).setValue((Object)this.getBD(initAmtMap.get(leaseInBillId)[1], this.currPrecision));
                row.getCell(KEY_UNFNFEE).setValue((Object)this.getBD(initAmtMap.get(leaseInBillId)[2], this.currPrecision));
                row.getCell(KEY_RECEIVEDORPAIDAMT).setValue((Object)this.getBD(rpAmtMap.get(leaseInBillId), this.currPrecision));
                row.getCell(KEY_ACCDEPR).setValue((Object)this.getBD(diAmtMap.get(this.getString(leaseInBillId))[0], this.currPrecision));
                row.getCell(KEY_ACCINTERESTEXPE).setValue((Object)this.getBD(diAmtMap.get(this.getString(leaseInBillId))[1], this.currPrecision));
                row.getCell(KEY_BIZSTATUSOLD).setValue(null);
                row.getCell(KEY_InitialAssetDecValue).setValue(leaseBillCol.getObject(i).get(KEY_InitialAssetDecValue));
            }
            this.calcTableTotalAmt();
        }
    }

    private void updateRcvPaidColumn() {
        int count = this.kdtEntries.getRowCount();
        if (count <= 0) {
            return;
        }
        if (this.comboRentDirection.getSelectedIndex() == 0) {
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < count; ++i) {
                idSet.add(((FaLeaseInBillNewInfo)this.kdtEntries.getRow(i).getCell(KEY_LEASEINBILL).getValue()).getId().toString());
            }
            try {
                Map<String, BigDecimal> rpAmtMap = this.getRcvPaidAmt(idSet);
                for (int i = 0; i < count; ++i) {
                    IRow row = this.kdtEntries.getRow(i);
                    String leaseInBillId = ((FaLeaseInBillNewInfo)this.kdtEntries.getRow(i).getCell(KEY_LEASEINBILL).getValue()).getId().toString();
                    row.getCell(KEY_RECEIVEDORPAIDAMT).setValue((Object)this.getBD(rpAmtMap.get(leaseInBillId), this.currPrecision));
                }
                this.calcTableTotalAmt();
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    private void calcTableTotalAmt() {
        BigDecimal ZERO;
        BigDecimal initAsset = ZERO = BigDecimal.ZERO.setScale(this.currPrecision);
        BigDecimal initLb = ZERO;
        BigDecimal unFnFee = ZERO;
        BigDecimal accDepr = ZERO;
        BigDecimal accInterestExpe = ZERO;
        for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
            initAsset = initAsset.add(this.getBD((BigDecimal)this.kdtEntries.getCell(i, KEY_INITASSET).getValue(), this.currPrecision));
            initLb = initLb.add(this.getBD((BigDecimal)this.kdtEntries.getCell(i, KEY_INITLIABILITY).getValue(), this.currPrecision));
            unFnFee = unFnFee.add(this.getBD((BigDecimal)this.kdtEntries.getCell(i, KEY_UNFNFEE).getValue(), this.currPrecision));
            accDepr = accDepr.add(this.getBD((BigDecimal)this.kdtEntries.getCell(i, KEY_ACCDEPR).getValue(), this.currPrecision));
            accInterestExpe = accInterestExpe.add(this.getBD((BigDecimal)this.kdtEntries.getCell(i, KEY_ACCINTERESTEXPE).getValue(), this.currPrecision));
        }
        this.lblInitAssetTotalValue.setText(initAsset.toString());
        this.lblInitLiabilityTotalValue.setText(initLb.toString());
        this.lblUnFnFeeTotalValue.setText(unFnFee.toString());
        this.lblAccDepreTotalValue.setText(accDepr.toString());
        this.lblAccInterestExpeTotalValue.setText(accInterestExpe.toString());
    }

    private Map<String, BigDecimal> getRcvPaidAmt(Set<String> idSet) throws BOSException, EASBizException {
        return FaLeaseChangeBillFactory.getRemoteInstance().getRcvPaidAmt(idSet, (Date)this.pkDate.getValue(), (FaRentDirectionEnum)((Object)this.comboRentDirection.getSelectedItem()));
    }

    private Map<String, BigDecimal[]> getDeprInterestAmt(Set<String> idSet) throws BOSException, EASBizException {
        return FaLeaseChangeBillFactory.getRemoteInstance().getDeprInterestAmt(idSet, (FaRentDirectionEnum)((Object)this.comboRentDirection.getSelectedItem()));
    }

    private Map<String, BigDecimal[]> getInitAmt(Set<String> idSet) throws BOSException, EASBizException {
        return FaLeaseChangeBillFactory.getRemoteInstance().getInitAmt(idSet, (FaRentDirectionEnum)((Object)this.comboRentDirection.getSelectedItem()));
    }

    private Set<String> col2IdSet(IObjectCollection col) {
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < col.size(); ++i) {
            idSet.add(col.getObject(i).get("id").toString());
        }
        return idSet;
    }

    private String getString(Object o) {
        return o == null ? "" : o.toString();
    }

    private BigDecimal getBD(Object o, int scale) {
        return o == null ? BigDecimal.ZERO.setScale(scale) : ((BigDecimal)o).setScale(scale, RoundingMode.HALF_UP);
    }

    private FaLessorTypeEnum getLessorType(Object o) {
        if (o == null) {
            return null;
        }
        FaLessorTypeEnum item = null;
        switch ((Integer)o) {
            case 2: {
                item = FaLessorTypeEnum.CUSTOMER;
                break;
            }
            case 3: {
                item = FaLessorTypeEnum.INNER_COMPAY;
                break;
            }
            case 1: {
                item = FaLessorTypeEnum.SUPPLIER;
                break;
            }
        }
        return item;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (e == null || e == this.actionSave.getActionEvent()) {
            return;
        }
        if (this.pkDate.getValue() == null) {
            this.pkDate.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH_LEASECHANGE, (String)"DATE_NOT_NULL"));
            SysUtil.abort();
        } else {
            Date changeDate = (Date)this.pkDate.getValue();
            if (this.currPeriod != null && (DateTimeUtils.dayBefore((Date)changeDate, (Date)this.currPeriod.getBeginDate()) || DateTimeUtils.dayAfter((Date)changeDate, (Date)this.currPeriod.getEndDate()))) {
                this.pkDate.requestFocus();
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH_LEASECHANGE, (String)"DATE_OUT_PERIOD"));
                SysUtil.abort();
            }
        }
        if (this.kdtEntries.getRowCount() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH_LEASECHANGE, (String)"AT_LEASET_ONE_ENTRY"));
            SysUtil.abort();
        }
        for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
            IRow row = this.kdtEntries.getRow(i);
            String entryStr = EASResource.getString((String)RES_PATH_LEASECHANGE, (String)"ENTRY");
            if (row.getCell(KEY_CONTRACTCATNEW).getValue() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)(entryStr + (i + 1) + EASResource.getString((String)RES_PATH_LEASECHANGE, (String)"CONTRACT_CAT_NOT_NULL")));
                SysUtil.abort();
            }
            if (row.getCell(KEY_CONTRACTNAMENEW).getValue() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)(entryStr + (i + 1) + EASResource.getString((String)RES_PATH_LEASECHANGE, (String)"CONTRACT_NAME_NOT_NULL")));
                SysUtil.abort();
            }
            if (row.getCell(KEY_RENTINOUTOBJTYPENEW).getValue() == null || row.getCell(KEY_RENTINOUTOBJTYPENEW).getValue() == FaLessorTypeEnum.NONE || row.getCell(KEY_RENTINOUTOBJNEW).getValue() != null) continue;
            MsgBox.showInfo((Component)((Object)this), (String)(entryStr + (i + 1) + EASResource.getString((String)RES_PATH_LEASECHANGE, (String)"RENTINOUTOBJ_NOT_NULL")));
            SysUtil.abort();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
    }

    protected IObjectValue createNewData() {
        FaLeaseChangeBillInfo billInfo = new FaLeaseChangeBillInfo();
        billInfo.setNumber(this.getRuleNumber(billInfo));
        billInfo.setCompany(this.getCurrentCompany());
        billInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        billInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        billInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
        billInfo.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        billInfo.setFiVouchered(false);
        UserInfo currUser = SysContext.getSysContext().getCurrentUserInfo();
        billInfo.setHandler(currUser);
        billInfo.setCreator(currUser);
        billInfo.setCreateTime(null);
        billInfo.setLastUpdateTime(null);
        billInfo.setPeriod(this.getCurrPeriod());
        try {
            billInfo.setCompany(this.getCurrentCompany());
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return billInfo;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return new FaLeaseChangeBillEntryInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getRuleNumber(FaLeaseChangeBillInfo billInfo) {
        String number = null;
        ICodingRuleManager iCodingRuleManager = null;
        CompanyOrgUnitInfo company = this.getCurrentCompany();
        try {
            if (billInfo.getCompany() == null) {
                billInfo.setCompany(company);
            }
            iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            boolean isCodingRule = iCodingRuleManager.isExist((IObjectValue)billInfo, company.getId().toString());
            boolean isViewCodeRule = iCodingRuleManager.isAddView((IObjectValue)billInfo, company.getId().toString());
            number = isCodingRule && isViewCodeRule ? iCodingRuleManager.readNumber((IObjectValue)billInfo, company.getId().toString()) : "";
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        finally {
            if (number == null) {
                SysUtil.abort();
            }
        }
        return number;
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FaLeaseChangeBillFactory.getRemoteInstance();
    }

    private CommonQueryLeaseDialog initDialog() throws Exception {
        FilterInfo filter = new FilterInfo();
        if (this.kdtEntries.getRowCount() > 0) {
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
                FaLeaseInBillNewInfo billInfo = (FaLeaseInBillNewInfo)this.kdtEntries.getCell(i, KEY_LEASEINBILL).getValue();
                idSet.add(billInfo.getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.NOTINCLUDE));
        }
        CommonQueryLeaseDialog dialog = new CommonQueryLeaseDialog(filter, true);
        if (this.getUIWindow() == null) {
            dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            dialog.setOwner((Component)((Object)this));
        }
        dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        dialog.setEntityViewInfo(new EntityViewInfo());
        if (this.comboRentDirection.getSelectedIndex() == 0) {
            dialog.setQueryObjectPK((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.fa.manage", "FaLeaseInNewQuery"));
            dialog.setRentDirection(FaRentDirectionEnum.RENT_IN);
        } else {
            dialog.setRentDirection(FaRentDirectionEnum.RENT_OUT);
        }
        dialog.setTitle(EASResource.getString((String)RES_PATH_LEASECHANGE, (String)"LEASEBILL_SEARCH_DIALOG_TITLE"));
        dialog.setHeight(525);
        return dialog;
    }

    public HashMap gethmParamD() {
        HashMap hmParam = new HashMap();
        try {
            hmParam = FaManageUtils.getFAParameter(this.getCurrentCompany().getId());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return hmParam;
    }

    protected CompanyOrgUnitInfo getCurrentCompany() {
        if (this.currCompany == null) {
            try {
                String companyID = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
                this.currCompany = this.getCompanyById(companyID);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return this.currCompany;
    }

    protected PeriodInfo getCurrPeriod() {
        try {
            if (this.currPeriod == null) {
                this.currPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)this.currCompany);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this.currPeriod;
    }

    protected CompanyOrgUnitInfo getCompanyById(String companyID) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("basecurrency.precision"));
        sic.add(new SelectorItemInfo("isbizunit"));
        return CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID), sic);
    }

    protected void prepareMutexParameter(ActionEvent arg0, MutexParameter arg1) {
        super.prepareMutexParameter(arg0, arg1);
        CompanyOrgUnitInfo company = this.getCurrentCompany();
        if (company != null) {
            arg1.setOrgUnitID(company.getId());
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData != null && this.editData.getId() != null) {
            this.getBizInterface().checkStatusValid((CoreBaseInfo)this.editData);
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        try {
            this.pkCreateTime.setTimePattern("");
            this.pkLastUpdateTime.setTimePattern("");
            PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)this.getCurrentCompany());
            this.pkDate.setValue((Object)currPeriodInfo.getEndDate());
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData != null && this.editData.getId() != null) {
            if (MsgBox.isOk((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RES_PATH_CARD, (String)"IF_UNAUDIT"))) && FaClientUtils.isCanUnAudit((Component)((Object)this))) {
                ((IFaLeaseChangeBill)this.getBizInterface()).unpassAudit((IObjectPK)new ObjectUuidPK(this.editData.getId()), this.editData);
                this.showAuditMessage(EASResource.getString((String)RES_PATH_CARD, (String)"UNAUDIT_SUCCESS"));
                this.editData = FaLeaseChangeBillFactory.getRemoteInstance().getFaLeaseChangeBillInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()), this.getSelectors());
                this.setDataObject((IObjectValue)this.editData);
                this.loadFields();
                this.setOprtState("VIEW");
                this.lockUIForAudited(false);
            } else {
                SysUtil.abort();
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"SAVE_FIRST"));
        }
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData != null && this.editData.getId() != null) {
            if (MsgBox.isOk((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RES_PATH_CARD, (String)"IF_AUDIT")))) {
                ((IFaLeaseChangeBill)this.getBizInterface()).passAudit((IObjectPK)new ObjectUuidPK(this.editData.getId()), this.editData);
                this.showAuditMessage(EASResource.getString((String)RES_PATH_CARD, (String)"AUDIT_SUCCESS"));
                this.editData = FaLeaseChangeBillFactory.getRemoteInstance().getFaLeaseChangeBillInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()), this.getSelectors());
                this.setDataObject((IObjectValue)this.editData);
                this.loadFields();
                this.setOprtState("VIEW");
                this.lockUIForAudited(true);
            } else {
                SysUtil.abort();
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"SAVE_FIRST"));
        }
    }

    protected void lockUIForAudited(boolean isAudited) {
        if (isAudited) {
            this.lockUIForViewStatus();
        }
        this.actionEdit.setEnabled(!isAudited);
        this.actionSave.setEnabled(false);
        this.actionSubmit.setEnabled(false);
        this.actionRemove.setEnabled(false);
        if (this.getDetailTable() != null) {
            this.getDetailTable().setEnabled(!isAudited);
        }
    }

    private void showAuditMessage(String str) {
        this.setMessageText(FrameWorkUtils.getClassAlias((CoreBaseInfo)new FaLeaseChangeBillInfo()) + " " + str);
        this.showMessage();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        String selectorAll = System.getProperty("selector.all");
        if (StringUtils.isEmpty((String)selectorAll)) {
            selectorAll = "true";
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("creator.*"));
        } else {
            sic.add(new SelectorItemInfo("creator.id"));
            sic.add(new SelectorItemInfo("creator.number"));
            sic.add(new SelectorItemInfo("creator.name"));
        }
        sic.add(new SelectorItemInfo("createTime"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("lastUpdateUser.*"));
        } else {
            sic.add(new SelectorItemInfo("lastUpdateUser.id"));
            sic.add(new SelectorItemInfo("lastUpdateUser.number"));
            sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        }
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("auditor.*"));
        } else {
            sic.add(new SelectorItemInfo("auditor.id"));
            sic.add(new SelectorItemInfo("auditor.number"));
            sic.add(new SelectorItemInfo("auditor.name"));
        }
        sic.add(new SelectorItemInfo("rentDirection"));
        sic.add(new SelectorItemInfo("date"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("entries.contractNameNew"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("entries.*"));
        }
        sic.add(new SelectorItemInfo("entries.rentInOutObjNew"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.rentInOutObjOld"));
        sic.add(new SelectorItemInfo("entries.contractNameOld"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("entries.costCenterOld.*"));
        } else {
            sic.add(new SelectorItemInfo("entries.costCenterOld.id"));
            sic.add(new SelectorItemInfo("entries.costCenterOld.name"));
            sic.add(new SelectorItemInfo("entries.costCenterOld.number"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("entries.contractCatOld.*"));
        } else {
            sic.add(new SelectorItemInfo("entries.contractCatOld.id"));
            sic.add(new SelectorItemInfo("entries.contractCatOld.name"));
            sic.add(new SelectorItemInfo("entries.contractCatOld.number"));
        }
        sic.add(new SelectorItemInfo("entries.leaseInBill.number"));
        sic.add(new SelectorItemInfo("entries.leaseInBill.id"));
        sic.add(new SelectorItemInfo("entries.leaseInBill.contractNumber"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("entries.useDepartmentOld.*"));
        } else {
            sic.add(new SelectorItemInfo("entries.useDepartmentOld.id"));
            sic.add(new SelectorItemInfo("entries.useDepartmentOld.name"));
            sic.add(new SelectorItemInfo("entries.useDepartmentOld.number"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("entries.costCenterNew.*"));
        } else {
            sic.add(new SelectorItemInfo("entries.costCenterNew.id"));
            sic.add(new SelectorItemInfo("entries.costCenterNew.name"));
            sic.add(new SelectorItemInfo("entries.costCenterNew.number"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("entries.useDepartmentNew.*"));
        } else {
            sic.add(new SelectorItemInfo("entries.useDepartmentNew.id"));
            sic.add(new SelectorItemInfo("entries.useDepartmentNew.name"));
            sic.add(new SelectorItemInfo("entries.useDepartmentNew.number"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("entries.contractCatNew.*"));
        } else {
            sic.add(new SelectorItemInfo("entries.contractCatNew.id"));
            sic.add(new SelectorItemInfo("entries.contractCatNew.name"));
            sic.add(new SelectorItemInfo("entries.contractCatNew.number"));
        }
        sic.add(new SelectorItemInfo("entries.bizStatusOld"));
        sic.add(new SelectorItemInfo("entries.accDepr"));
        sic.add(new SelectorItemInfo("entries.accInterestExp"));
        sic.add(new SelectorItemInfo("entries.rcvOrPaidRent"));
        sic.add(new SelectorItemInfo("entries.initAsset"));
        sic.add(new SelectorItemInfo("entries.initLiability"));
        sic.add(new SelectorItemInfo("entries.unFncFee"));
        sic.add(new SelectorItemInfo("entries.rentInOutObjTypeOld"));
        sic.add(new SelectorItemInfo("entries.rentInOutObjTypeNew"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("entries.innerCompanyLessorOld.*"));
        } else {
            sic.add(new SelectorItemInfo("entries.innerCompanyLessorOld.id"));
            sic.add(new SelectorItemInfo("entries.innerCompanyLessorOld.name"));
            sic.add(new SelectorItemInfo("entries.innerCompanyLessorOld.number"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("entries.innerCompanyLessorNew.*"));
        } else {
            sic.add(new SelectorItemInfo("entries.innerCompanyLessorNew.id"));
            sic.add(new SelectorItemInfo("entries.innerCompanyLessorNew.name"));
            sic.add(new SelectorItemInfo("entries.innerCompanyLessorNew.number"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("entries.customerLessorOld.*"));
        } else {
            sic.add(new SelectorItemInfo("entries.customerLessorOld.id"));
            sic.add(new SelectorItemInfo("entries.customerLessorOld.name"));
            sic.add(new SelectorItemInfo("entries.customerLessorOld.number"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("entries.customerLessorNew.*"));
        } else {
            sic.add(new SelectorItemInfo("entries.customerLessorNew.id"));
            sic.add(new SelectorItemInfo("entries.customerLessorNew.name"));
            sic.add(new SelectorItemInfo("entries.customerLessorNew.number"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("entries.supplierLessorOld.*"));
        } else {
            sic.add(new SelectorItemInfo("entries.supplierLessorOld.id"));
            sic.add(new SelectorItemInfo("entries.supplierLessorOld.name"));
            sic.add(new SelectorItemInfo("entries.supplierLessorOld.number"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("entries.supplierLessorNew.*"));
        } else {
            sic.add(new SelectorItemInfo("entries.supplierLessorNew.id"));
            sic.add(new SelectorItemInfo("entries.supplierLessorNew.name"));
            sic.add(new SelectorItemInfo("entries.supplierLessorNew.number"));
        }
        sic.add(new SelectorItemInfo("effectedStatus"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        sic.add(new SelectorItemInfo("handler.name"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("company.name"));
        return sic;
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.updatePrintData();
        this.invokePrint(true);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.updatePrintData();
        this.invokePrint(false);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkForGenVoucher4Fl();
        super.actionVoucher_actionPerformed(e);
        this.updateDapBtnStatus();
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
        this.updateDapBtnStatus();
    }

    private void updatePrintData() {
        this.editData.put("initAssetTotal", this.lblInitAssetTotalValue.getText());
        this.editData.put("initLiabilityTotal", this.lblInitLiabilityTotalValue.getText());
        this.editData.put("unFnFeeTotal", this.lblUnFnFeeTotalValue.getText());
        this.editData.put("accDepreTotal", this.lblAccDepreTotalValue.getText());
        this.editData.put("accInterestExpeTotal", this.lblAccInterestExpeTotalValue.getText());
        FaLeaseChangeBillEntryCollection entries = this.editData.getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            entries.get(i).put("entries.receivedOrPaidAmt", this.kdtEntries.getRow(i).getCell(KEY_RECEIVEDORPAIDAMT).getValue());
            entries.get(i).put("entries.accDepr", this.kdtEntries.getRow(i).getCell(KEY_ACCDEPR).getValue());
            entries.get(i).put("entries.accInterestExpe", this.kdtEntries.getRow(i).getCell(KEY_ACCINTERESTEXPE).getValue());
        }
    }

    private void invokePrint(boolean preview) throws Exception {
        this.storeFields();
        BillBaseCollection billCol = new BillBaseCollection();
        billCol.add((BillBaseInfo)this.editData);
        KDNoteHelper appHlp = new KDNoteHelper();
        KDTable[] tables = new KDTable[]{this.getDetailTable()};
        BOSQueryDelegate data = FaPrintHelper.getPrintManagerForFaLeaseChangeBillEditUI((IObjectCollection)billCol, tables);
        if (preview) {
            appHlp.printPreview("/FI/FL/FaLeaseChangeBill", (Object)data, (Component)((Object)this));
        } else {
            appHlp.print("/FI/FL/FaLeaseChangeBill", (Object)data, (Component)((Object)this));
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    public void beforeActionPerformed(ActionEvent e) {
        super.beforeActionPerformed(e);
        FlUtils.checkAdjustmentPeriodForNLM(e.getActionCommand());
    }
}

