/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.manage.FaLeaseChangeBillFactory;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaLeaseChangeBillListUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.manage.client.FaLeaseChangeBillEditUI;
import com.kingdee.eas.fi.fa.manage.client.FaLeaseChangeBillFilterUI;
import com.kingdee.eas.fi.fa.manage.client.flutils.FlUtils;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class FaLeaseChangeBillListUI
extends AbstractFaLeaseChangeBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(FaLeaseChangeBillListUI.class);
    private CompanyOrgUnitInfo curCompany;
    private int currPrecision = 2;
    CommonQueryDialog dialog;
    private boolean isUseWorkflow;
    private KDTSelectListener selectLineListener;
    private static String RES_PATH = "com.kingdee.eas.fi.fa.manage.FaCardResource";
    private static final String KEY_NUMBER = "number";
    private static final String KEY_DATE = "date";
    private static final String KEY_RENTDIRECTION = "rentDirection";
    private static final String KEY_LEASEINBILL_ID = "leaseInBill.id";
    private static final String KEY_LEASEINBILL_INITIALASSET = "leaseInBill.initialAsset";
    private static final String KEY_LEASEINBILL_INITIALLIABILITY = "leaseInBill.initialLiability";
    private static final String KEY_LEASEINBILL_UNRECOGNIZEDFINANCEFEE = "leaseInBill.unrecognizedFinanceFee";
    private static final String KEY_ACCDEPR = "depreAndAmort.acumDepreAmt";
    private static final String KEY_ACCINTERESTEXPE = "depreAndAmort.acumInterestExpe";
    private static final String KEY_RECEIVEDORPAIDAMT = "receivedOrPaidAmt";
    private static final String KEY_CHECKEDSTATUS = "checkedStatus";
    private static final String KEY_FIVOUCHERED = "fiVouchered";

    public FaLeaseChangeBillListUI() throws Exception {
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                FaLeaseChangeBillListUI.this.changeTableMerge(e);
            }
        });
        this.selectLineListener = new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                FaLeaseChangeBillListUI.this.onTableSelectChanged();
            }
        };
        this.tblMain.addKDTSelectListener(this.selectLineListener);
    }

    private void onTableSelectChanged() {
        ICell cell;
        Object keyValue;
        int rowIndex;
        IRow row;
        KDTSelectBlock selectBlock;
        this.actionVoucher.setVisible(true);
        this.actionDelVoucher.setVisible(true);
        if (KEY_CHECKEDSTATUS != null && this.tblMain.getColumn(KEY_CHECKEDSTATUS) != null && (selectBlock = this.tblMain.getSelectManager().get()) != null && (row = this.tblMain.getRow(rowIndex = selectBlock.getTop())) != null && (keyValue = (cell = row.getCell(KEY_CHECKEDSTATUS)).getValue()) != null && keyValue instanceof BizEnumValueInfo) {
            if (((BizEnumValueInfo)keyValue).getValue().toString().equals("2")) {
                this.actionAudit.setEnabled(false);
                this.btnAudit.setEnabled(false);
                this.menuItemAudit.setEnabled(false);
                this.actionUnAudit.setEnabled(true);
                this.btnUnAudit.setEnabled(true);
                this.menuItemUnAudit.setEnabled(true);
                this.actionEdit.setEnabled(false);
                this.menuItemEdit.setEnabled(false);
                ICell cellFiVc = row.getCell(KEY_FIVOUCHERED);
                Object isVc = cellFiVc.getValue();
                if (isVc != null && isVc instanceof Boolean && ((Boolean)isVc).booleanValue()) {
                    this.actionVoucher.setEnabled(false);
                    this.actionDelVoucher.setEnabled(true);
                } else {
                    this.actionVoucher.setEnabled(true);
                    this.actionDelVoucher.setEnabled(false);
                }
            } else {
                this.actionAudit.setEnabled(true);
                this.btnAudit.setEnabled(true);
                this.menuItemAudit.setEnabled(true);
                this.actionUnAudit.setEnabled(false);
                this.btnUnAudit.setEnabled(false);
                this.menuItemUnAudit.setEnabled(false);
                this.actionEdit.setEnabled(true);
                this.menuItemEdit.setEnabled(true);
                this.actionVoucher.setEnabled(false);
                this.actionDelVoucher.setEnabled(false);
            }
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.curCompany = this.getCurrentCompany();
        this.currPrecision = this.curCompany.getBaseCurrency().getPrecision();
        this.mergeTable();
        this.initUI();
    }

    private void mergeTable() {
        this.tblMain.checkParsed();
        this.tblMain.getGroupManager().setGroup(true);
        int size = this.getMergeColumns().length;
        for (int i = 0; i < size; ++i) {
            this.tblMain.getColumn(this.getMergeColumns()[i]).setGroup(true);
            this.tblMain.getColumn(this.getMergeColumns()[i]).setMergeable(true);
        }
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog == null) {
            try {
                FaClientUtils.checkBeforeOnload4Fl(this.getUIContext(), SysContext.getSysContext().getCurrentFIUnit());
                this.dialog = super.initCommonQueryDialog();
                this.dialog.addUserPanel((KDPanel)new FaLeaseChangeBillFilterUI());
                this.dialog.setHeight(320);
                this.dialog.setWidth(480);
                this.dialog.getCommonQueryParam().setEntityViewInfo(new EntityViewInfo());
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        }
        return this.dialog;
    }

    private void initUI() throws EASBizException, BOSException {
        this.actionCopyTo.setVisible(false);
        this.actionTraceUp.setVisible(false);
        this.actionCreateTo.setVisible(false);
        this.onTableSelectChanged();
        this.setWorkflowVisible();
        String[] keyArr = new String[]{KEY_LEASEINBILL_INITIALASSET, KEY_LEASEINBILL_INITIALLIABILITY, KEY_LEASEINBILL_UNRECOGNIZEDFINANCEFEE, KEY_RECEIVEDORPAIDAMT, KEY_ACCDEPR, KEY_ACCINTERESTEXPE};
        FaClientUtils.changeTableNumberFormat(this.getDetailTable(), keyArr, FaClientUtils.getDecimalFormat(this.currPrecision));
    }

    private String[] getMergeColumns() {
        return new String[]{KEY_NUMBER, KEY_DATE};
    }

    private void changeTableMerge(KDTDataRequestEvent e) {
        this.tblMain.setVerticalGridLineVisible(true);
        this.tblMain.setHorizonGridLineVisible(true);
        for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
            Object keyValue;
            IRow row = this.tblMain.getRow(i);
            if (row.getCell(KEY_CHECKEDSTATUS) == null || row.getCell(KEY_CHECKEDSTATUS).getValue() == null || (keyValue = row.getCell(KEY_CHECKEDSTATUS).getValue()) == null || !(keyValue instanceof BizEnumValueInfo)) continue;
            if (((BizEnumValueInfo)keyValue).getValue().toString().equals("2")) {
                row.getStyleAttributes().setBackground(FaClientUtils.colorAudit);
                continue;
            }
            row.getStyleAttributes().setBackground(FaClientUtils.colorNoAudit);
        }
    }

    protected void setWorkflowVisible() throws EASBizException, BOSException {
        this.isUseWorkflow = FaManageUtils.isUseWorkflow(null, this.getCurrentCompany().getId().toString(), ((Object)((Object)this)).getClass());
        this.actionAudit.setBindWorkFlow(this.isUseWorkflow && this.isBindWorkFlow());
        this.actionUnAudit.setBindWorkFlow(this.isUseWorkflow && this.isBindWorkFlow());
        this.actionRemove.setBindWorkFlow(this.isUseWorkflow && this.isBindWorkFlow());
        this.menuTool.setVisible(false);
        if (this.isUseWorkflow && this.isBindWorkFlow()) {
            this.menuItemAudit.setAction(null);
            this.btnAudit.setAction(null);
        }
        this.menuItemAudit.setVisible(!this.isUseWorkflow && this.isBindWorkFlow());
        this.btnAudit.setVisible(!this.isUseWorkflow && this.isBindWorkFlow());
        this.hideOrShowWorkflow(this.isUseWorkflow);
        this.hideOrShowAuditResult(this.isUseWorkflow);
    }

    public boolean isBindWorkFlow() {
        return true;
    }

    public void onGetRowSet(IRowSet rowSet) {
        super.onGetRowSet(rowSet);
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            if (this.tblMain.getCell(i, KEY_LEASEINBILL_INITIALASSET).getValue() == null) {
                this.tblMain.getCell(i, KEY_LEASEINBILL_INITIALASSET).setValue((Object)BigDecimal.ZERO);
            }
            if (this.tblMain.getCell(i, KEY_LEASEINBILL_INITIALLIABILITY).getValue() == null) {
                this.tblMain.getCell(i, KEY_LEASEINBILL_INITIALLIABILITY).setValue((Object)BigDecimal.ZERO);
            }
            if (this.tblMain.getCell(i, KEY_LEASEINBILL_UNRECOGNIZEDFINANCEFEE).getValue() == null) {
                this.tblMain.getCell(i, KEY_LEASEINBILL_UNRECOGNIZEDFINANCEFEE).setValue((Object)BigDecimal.ZERO);
            }
            if (this.tblMain.getCell(i, KEY_RECEIVEDORPAIDAMT).getValue() == null) {
                this.tblMain.getCell(i, KEY_RECEIVEDORPAIDAMT).setValue((Object)BigDecimal.ZERO);
            }
            if (this.tblMain.getCell(i, KEY_ACCDEPR).getValue() == null) {
                this.tblMain.getCell(i, KEY_ACCDEPR).setValue((Object)BigDecimal.ZERO);
            }
            if (this.tblMain.getCell(i, KEY_ACCINTERESTEXPE).getValue() != null) continue;
            this.tblMain.getCell(i, KEY_ACCINTERESTEXPE).setValue((Object)BigDecimal.ZERO);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FaLeaseChangeBillFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return FaLeaseChangeBillEditUI.class.getName();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    protected CompanyOrgUnitInfo getCurrentCompany() throws BOSException, EASBizException {
        if (this.curCompany == null) {
            String companyID = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            this.curCompany = this.getCompanyById(companyID);
        }
        return this.curCompany;
    }

    protected CompanyOrgUnitInfo getCompanyById(String companyID) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("basecurrency.precision"));
        sic.add(new SelectorItemInfo("isbizunit"));
        sic.add(new SelectorItemInfo("accountTable"));
        return CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID), sic);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (MsgBox.isOk((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"IF_AUDIT")))) {
            FaClientUtils.batchOperaction((ListUI)this, this.getSelectedIdValues(), this.getBizInterface(), EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource.bill"), EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource.audit"), "passAudit", new Class[]{IObjectPK.class, BillBaseInfo.class});
            this.refresh(null);
        } else {
            SysUtil.abort();
        }
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (MsgBox.isOk((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"IF_UNAUDIT"))) && FaClientUtils.isCanUnAudit((Component)((Object)this))) {
            FaClientUtils.batchOperaction((ListUI)this, this.getSelectedIdValues(), this.getBizInterface(), EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource.bill"), EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource.unaudit"), "unpassAudit", new Class[]{IObjectPK.class, BillBaseInfo.class});
            this.refresh(null);
        } else {
            SysUtil.abort();
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.getSelectedIdValues().size() > 0) {
            int selectIdValuesSize = this.getSelectedIdValues().size();
            for (int i = 0; i < selectIdValuesSize; ++i) {
                try {
                    String pk = this.getSelectedIdValues().get(i).toString();
                    this.setOprtState("REMOVE");
                    this.pubFireVOChangeListener(pk);
                    continue;
                }
                catch (Throwable ex) {
                    this.handUIException(ex);
                    this.abort();
                }
            }
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkForGenVoucher4Fl();
        super.actionVoucher_actionPerformed(e);
    }

    protected boolean isFootVisible() {
        return true;
    }

    public void beforeActionPerformed(ActionEvent e) {
        super.beforeActionPerformed(e);
        FlUtils.checkAdjustmentPeriodForNLM(e.getActionCommand());
    }
}

