/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.FaBasedataTypeEnum;
import com.kingdee.eas.fi.fa.basedata.FaLeaseTypeInfo;
import com.kingdee.eas.fi.fa.basedata.FaUtils;
import com.kingdee.eas.fi.fa.basedata.client.FaCatPromptBox;
import com.kingdee.eas.fi.fa.manage.DateUnitEnum;
import com.kingdee.eas.fi.fa.manage.FALeaseContractCollection;
import com.kingdee.eas.fi.fa.manage.FALeaseContractFactory;
import com.kingdee.eas.fi.fa.manage.FALeaseContractInfo;
import com.kingdee.eas.fi.fa.manage.FaBillOriginEnum;
import com.kingdee.eas.fi.fa.manage.FaChangeBillInfo;
import com.kingdee.eas.fi.fa.manage.FaClearBillInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceBillFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceBillInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceInEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceInEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillCollection;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaPayModeEnum;
import com.kingdee.eas.fi.fa.manage.IFaLeaseInBill;
import com.kingdee.eas.fi.fa.manage.LeaseBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaLeaseInEditUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.manage.client.FaLeaseUtils;
import com.kingdee.eas.fi.fa.manage.client.FaPrintHelper;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.lcm.client.LCMClientUtils;
import com.kingdee.eas.framework.BillBaseCollection;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class FaLeaseInEditUI
extends AbstractFaLeaseInEditUI {
    private static final long serialVersionUID = -516334261202692044L;
    private static final Logger logger = CoreUIObject.getLogger(FaLeaseInEditUI.class);
    private static final String RES_PATH = "com.kingdee.eas.fi.fa.manage.FaLeaseResource";
    private static final String WORK_LEASE_TYPE = "001";
    private static final BigDecimal DEFAULT_BARGAINTIME = new BigDecimal("1.0");
    private CurrencyInfo baseCurrency;
    private CurrencyCollection initCurrencyCollection;
    protected static final String FROM_LINK = "Link";
    private int scale = 0;
    private int hireConvertMode = 0;
    private int subsConvertMode = 0;
    private static final String HIRE_TYPE = "hire_type";
    private static final String SUBS_TYPE = "subs_type";
    private KDFormattedTextField textField = new KDFormattedTextField();
    private static final String VOUCHERTYPE = new VoucherInfo().getBOSType().toString();

    @Override
    public void onLoad() throws Exception {
        if (this.getUIContext().get(FROM_LINK) != null && this.getUIContext().get(FROM_LINK).equals(Boolean.TRUE)) {
            this.menuBar.removeAll();
            this.menuBar.setVisible(false);
            this.toolBar.removeAll();
            this.toolBar.add((Component)new KDLabel());
        }
        super.onLoad();
        this.menuItemAudit.setAccelerator(KeyStroke.getKeyStroke("ctrl U"));
        this.menuItemUnAudit.setAccelerator(KeyStroke.getKeyStroke("ctrl shift U"));
        this.leaseTable.checkParsed();
        FaUtils.freezeTable((KDTable)this.leaseTable, (int)4);
        this.leaseTable.getStyleAttributes().setLocked(true);
        this.leaseTable.getSelectManager().setSelectMode(2);
        this.scale = this.getCurrencyScale();
        FaClientUtils.changeTableNumberFormat(this.leaseTable, new String[]{"shouldPayment", "actualPayment", "realPayment"}, FaClientUtils.getDecimalFormat(this.scale));
        FaClientUtils.changeTableTextFormat(this.leaseTable, new String[]{"balanceNumber", "relatedNumber"});
        this.textField.setDataType(1);
        this.textField.setHorizontalAlignment(4);
        this.textField.setNegatived(false);
        this.textField.setPrecision(this.scale);
        this.textField.setMaximumValue((Comparable)FaClientUtils.MAX_DECIMAL);
        this.textField.setMinimumValue((Comparable)ZERO);
        this.leaseTable.getColumn("shouldPayment").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)this.textField));
        this.leaseTable.getColumn("shouldPayment").getStyleAttributes().setNumberFormat(FaClientUtils.getDecimalFormat(this.scale));
        this.leaseTable.getColumn("shouldPayment").getStyleAttributes().setLocked(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.calLeaseTime();
        this.calcTotalAmount();
        this.setOrigCurrencyRate();
        this.lockLeaseContractFeild();
        this.doInsurance();
        this.lockCurrency();
        this.loadLeaseDetail();
        this.loadCurrency();
    }

    @Override
    public void storeFields() {
        int i;
        super.storeFields();
        for (i = 0; i < this.editData.getEntry().size(); ++i) {
            FaLeaseInBillEntryInfo entryInfo;
            entryInfo.setInitAmt((entryInfo = this.editData.getEntry().get(i)).getInitAmt() == null ? ZERO : entryInfo.getInitAmt());
            if (entryInfo.isHasInsurance() && entryInfo.getInsuranceAmt() == null) {
                entryInfo.setInsuranceAmt(ZERO);
            }
            if (this.editData.getLeaseType() == null || !"002".equals(this.editData.getLeaseType().getNumber())) continue;
            entryInfo.setUnAssuredAmt(entryInfo.getUnAssuredAmt() == null ? ZERO : entryInfo.getUnAssuredAmt());
        }
        this.editData.getBalanceEntry().clear();
        for (i = 0; i < this.leaseTable.getRowCount(); ++i) {
            FaLeaseBalanceInEntryInfo info = new FaLeaseBalanceInEntryInfo();
            info.setMeasureUnit(this.leaseTable.getCell(i, "measureUnit").getValue() == null ? null : this.leaseTable.getCell(i, "measureUnit").getValue().toString());
            info.setShouldPayment(this.leaseTable.getCell(i, "shouldPayment").getValue() == null ? null : (BigDecimal)this.leaseTable.getCell(i, "shouldPayment").getValue());
            info.setBillNumber(this.editData.getNumber());
            info.setSeq(i + 1);
            this.editData.getBalanceEntry().add(info);
        }
    }

    @Override
    protected boolean isNeedCodeRule() {
        return true;
    }

    private void doDetailInsurance(int rowIndex) {
        Boolean hasInsurance = (Boolean)this.detailTable.getCell(rowIndex, "hasInsurance").getValue();
        if (hasInsurance.booleanValue()) {
            this.detailTable.getCell(rowIndex, "insuranceAmt").getStyleAttributes().setLocked(false);
        } else {
            this.detailTable.getCell(rowIndex, "insuranceAmt").setValue(null);
            this.detailTable.getCell(rowIndex, "insuranceAmt").getStyleAttributes().setLocked(true);
        }
    }

    private void doInsurance() {
        for (int i = 0; i < this.getDetailTable().getRowCount(); ++i) {
            this.doDetailInsurance(i);
        }
    }

    private void calLeaseTime() {
        java.sql.Date beginDate = this.pkBeginDate.getSqlDate();
        java.sql.Date endDate = this.pkEndDate.getSqlDate();
        BigDecimal bargainTime = this.txtBargainTime.getBigDecimalValue();
        DateUnitEnum measureUnit = (DateUnitEnum)((Object)this.comboMeasureUnit.getSelectedItem());
        BigDecimal leasedTime = FaClientUtils.calLeasedTime(beginDate, endDate, bargainTime, measureUnit);
        this.txtLeasedTime.setValue((Object)leasedTime);
        this.txtRemainTime.setValue((Object)this.txtBargainTime.getBigDecimalValue().subtract(leasedTime));
    }

    @Override
    protected void initCtrlComponent() throws Exception {
        this.initNumericTxt();
        this.initDetailTable();
        this.setCardNumberEnabled();
        this.setHireAmtColumnTitle();
        this.setHideDetailColumn();
        this.pkSignatureDate.setSupportedEmpty(false);
        this.pkBeginDate.setSupportedEmpty(false);
        this.pkDeliverDate.setSupportedEmpty(false);
        FaClientUtils.changeTextField((JComponent)((Object)this), true, false);
        this.btnAddEntry.setText(null);
        this.btnDelEntry.setText(null);
    }

    private void loadCurrency() {
        CurrencyCollection currencyCollection = this.getCurrencyCollection();
        Vector<CurrencyInfo> tempCbDatas = new Vector<CurrencyInfo>();
        int size = currencyCollection.size();
        for (int i = 0; i < size; ++i) {
            tempCbDatas.addElement(currencyCollection.get(i));
        }
        this.comboHireCurrency.setModel(new DefaultComboBoxModel(tempCbDatas));
        this.comboSubsCurrency.setModel(new DefaultComboBoxModel(tempCbDatas));
        CurrencyInfo hireCurrency = this.editData.getHireCurrency();
        if (this.editData.getHireCurrency() == null) {
            hireCurrency = this.getBaseCurrency();
        }
        for (int i = 0; i < currencyCollection.size(); ++i) {
            if (!currencyCollection.get(i).getId().equals((Object)hireCurrency.getId())) continue;
            this.comboHireCurrency.setSelectedItem((Object)currencyCollection.get(i));
        }
        CurrencyInfo subsCurrency = this.editData.getSubsCurrency();
        if (this.editData.getSubsCurrency() == null) {
            subsCurrency = this.getBaseCurrency();
        }
        for (int i = 0; i < currencyCollection.size(); ++i) {
            if (!currencyCollection.get(i).getId().equals((Object)subsCurrency.getId())) continue;
            this.comboSubsCurrency.setSelectedItem((Object)currencyCollection.get(i));
        }
    }

    private void lockCurrency() {
        CurrencyInfo srcCyInfo = (CurrencyInfo)this.comboHireCurrency.getSelectedItem();
        CurrencyInfo desCyInfo = this.getBaseCurrency();
        if (srcCyInfo != null && desCyInfo != null) {
            boolean editable = !(LeaseBizStatusEnum.RELETING.equals((Object)this.editData.getBizStatus()) && "002".equals(this.editData.getLeaseType().getNumber()) || !"ADDNEW".equals(this.getOprtState()) && !"EDIT".equals(this.getOprtState()));
            editable = editable && !srcCyInfo.getId().equals((Object)desCyInfo.getId());
            this.txtHireExRate.setEditable(editable);
        }
        if ((srcCyInfo = (CurrencyInfo)this.comboSubsCurrency.getSelectedItem()) != null && desCyInfo != null) {
            if (srcCyInfo.getId().equals((Object)desCyInfo.getId())) {
                this.txtSubsExRate.setEditable(false);
            } else {
                this.txtSubsExRate.setEditable(true);
            }
        }
    }

    private void lockLeaseContractFeild() {
        boolean fromContract = FaBillOriginEnum.FROM_LEASECONTRACT.equals((Object)this.editData.getBillType());
        this.txtBargainNum.setEditable(!fromContract);
        this.txtSignaturePlace.setEditable(!fromContract);
        this.txtCautioner.setEditable(!fromContract);
        boolean fromRelet = LeaseBizStatusEnum.RELETING.equals((Object)this.editData.getBizStatus());
        this.txtLeaseCompany.setEditable(!fromContract && !fromRelet);
        this.txtHireCompany.setEditable(!fromContract && !fromRelet);
        this.prmtLeaseType.setEnabled(this.prmtLeaseType.getValue() == null || !LeaseBizStatusEnum.RELETING.equals((Object)this.editData.getBizStatus()));
        boolean editable = !fromRelet && ("ADDNEW".equals(this.getOprtState()) || "EDIT".equals(this.getOprtState()));
        this.actionAddLine.setEnabled(editable);
        this.actionInsertLine.setEnabled(editable);
        this.actionRemoveLine.setEnabled(editable);
        if (!editable) {
            for (int i = 0; i < this.detailTable.getColumnCount(); ++i) {
                this.detailTable.getColumn(i).getStyleAttributes().setLocked(true);
            }
            editable = "ADDNEW".equals(this.getOprtState()) || "EDIT".equals(this.getOprtState());
            this.detailTable.getColumn("attornAmt").getStyleAttributes().setLocked(!editable);
            this.detailTable.getColumn("deprLife").getStyleAttributes().setLocked(!editable);
            this.detailTable.getColumn("insuranceAmt").getStyleAttributes().setLocked(!editable);
        }
        editable = !fromRelet || this.editData.getLeaseType() == null || !"002".equals(this.editData.getLeaseType().getNumber());
        this.comboHireCurrency.setEnabled(editable);
        this.txtHireExRate.setEditable(editable);
        this.detailTable.getColumn("monOriginHireAmt").getStyleAttributes().setLocked(!editable);
        if (FaPayModeEnum.APERIODIC_PAY.equals(this.comboPayMode.getSelectedItem()) || FaPayModeEnum.ONE_PAY.equals(this.comboPayMode.getSelectedItem())) {
            this.detailTable.getColumn("hireOriginAmt").getStyleAttributes().setLocked(!editable);
        }
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.pnlCardInfo.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(1, 0, 985, 180));
        this.pnlPayAmt.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(1, 0, 985, 180));
        this.contEntry.getContentPane().putClientProperty("OriginalBounds", new Rectangle(9, 230, 992, 217));
    }

    private void initDetailTable() {
        this.btnAddEntry.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelEntry.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        KDBizPromptBox bizAssetCat = new KDBizPromptBox();
        FaCatPromptBox aFaCatPromptBox = new FaCatPromptBox((CoreUIObject)this);
        bizAssetCat.setSelector((KDPromptSelector)aFaCatPromptBox);
        bizAssetCat.setEntityViewInfo(FaClientUtils.getOrgSplitViewInfo(FaBasedataTypeEnum.CAT));
        bizAssetCat.setEditable(true);
        bizAssetCat.setQueryInfo("com.kingdee.eas.fi.fa.basedata.FaCatQuery");
        bizAssetCat.setDisplayFormat("$name$");
        bizAssetCat.setEditFormat("$number$");
        bizAssetCat.setCommitFormat("$number$");
        this.detailTable.getColumn("assetCat").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizAssetCat));
        KDBizPromptBox bizMeasureUnit = new KDBizPromptBox();
        bizMeasureUnit.setEditable(true);
        bizMeasureUnit.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7MeasureUnitQuery");
        bizMeasureUnit.setDisplayFormat("$name$");
        bizMeasureUnit.setEditFormat("$number$");
        bizMeasureUnit.setCommitFormat("$number$");
        this.detailTable.getColumn("measureUnit").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizMeasureUnit));
        this.formatTableColumn(this.detailTable, new String[]{"deprLife"}, 0);
        KDTextField txtDesc = new KDTextField();
        txtDesc.setMaxLength(80);
        this.detailTable.getColumn("cardNumber").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtDesc));
        this.detailTable.getColumn("cardName").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtDesc));
        this.detailTable.getColumn("description").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtDesc));
        this.detailTable.getColumn("specs").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtDesc));
    }

    public void initListener() {
        super.initListener();
        this.pkBeginDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if ("ADDNEW".equals(FaLeaseInEditUI.this.getOprtState()) || "EDIT".equals(FaLeaseInEditUI.this.getOprtState())) {
                    if (!FaLeaseInEditUI.this.calEndDate()) {
                        FaLeaseInEditUI.this.pkBeginDate.setValue(e.getOldValue());
                    }
                    FaLeaseInEditUI.this.calLeaseTime();
                }
            }
        });
        this.pkEndDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if ("ADDNEW".equals(FaLeaseInEditUI.this.getOprtState()) || "EDIT".equals(FaLeaseInEditUI.this.getOprtState())) {
                    for (int i = 0; i < FaLeaseInEditUI.this.detailTable.getRowCount(); ++i) {
                        FaLeaseInEditUI.this.calEntryHireAmt(i);
                    }
                    FaLeaseInEditUI.this.calTotalHireAmt();
                }
            }
        });
        this.txtBargainTime.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if ("ADDNEW".equals(FaLeaseInEditUI.this.getOprtState()) || "EDIT".equals(FaLeaseInEditUI.this.getOprtState())) {
                    if (!FaLeaseInEditUI.this.calEndDate() || FaLeaseInEditUI.this.txtBargainTime.getBigDecimalValue().floatValue() < 1.0f) {
                        FaLeaseInEditUI.this.txtBargainTime.setValue(e.getOldValue());
                    }
                    FaLeaseInEditUI.this.calLeaseTime();
                }
            }
        });
        this.prmtLeaseType.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                FaLeaseInEditUI.this.setHideDetailColumn();
                FaLeaseInEditUI.this.setCardNumberEnabled();
            }
        });
        this.comboMeasureUnit.addItemListener(new ItemListener(){
            Object oldValue = null;

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    this.oldValue = e.getItem();
                }
                if (e.getStateChange() == 1) {
                    if (!FaLeaseInEditUI.this.calEndDate()) {
                        FaLeaseInEditUI.this.comboMeasureUnit.setSelectedItem(this.oldValue);
                    }
                    FaLeaseInEditUI.this.calLeaseTime();
                }
            }
        });
        this.comboPayMode.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FaLeaseInEditUI.this.setHireAmtColumnTitle();
                    if ("ADDNEW".equals(FaLeaseInEditUI.this.getOprtState()) || "EDIT".equals(FaLeaseInEditUI.this.getOprtState())) {
                        for (int i = 0; i < FaLeaseInEditUI.this.detailTable.getRowCount(); ++i) {
                            FaLeaseInEditUI.this.calEntryHireAmt(i);
                        }
                        FaLeaseInEditUI.this.calTotalHireAmt();
                    }
                }
            }
        });
        this.comboPayMode.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FaLeaseInEditUI.this.setHireAmtColumnTitle();
                if ("ADDNEW".equals(FaLeaseInEditUI.this.getOprtState()) || "EDIT".equals(FaLeaseInEditUI.this.getOprtState())) {
                    for (int i = 0; i < FaLeaseInEditUI.this.detailTable.getRowCount(); ++i) {
                        FaLeaseInEditUI.this.calEntryHireAmt(i);
                    }
                    FaLeaseInEditUI.this.calTotalHireAmt();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                FaLeaseInEditUI.this.setHireAmtColumnTitle();
                if ("ADDNEW".equals(FaLeaseInEditUI.this.getOprtState()) || "EDIT".equals(FaLeaseInEditUI.this.getOprtState())) {
                    for (int i = 0; i < FaLeaseInEditUI.this.detailTable.getRowCount(); ++i) {
                        FaLeaseInEditUI.this.calEntryHireAmt(i);
                    }
                    FaLeaseInEditUI.this.calTotalHireAmt();
                }
            }
        });
        this.comboHireCurrency.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FaLeaseInEditUI.this.comboHireCurrency_itemStateChanged(e);
            }
        });
        this.txtHireExRate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if ("ADDNEW".equals(FaLeaseInEditUI.this.getOprtState()) || "EDIT".equals(FaLeaseInEditUI.this.getOprtState())) {
                    FaLeaseInEditUI.this.hireExRateChanged();
                    FaLeaseInEditUI.this.calcTotalAmount();
                }
            }
        });
        this.comboSubsCurrency.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FaLeaseInEditUI.this.comboSubsCurrency_itemStateChanged(e);
            }
        });
        this.txtSubsExRate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if ("ADDNEW".equals(FaLeaseInEditUI.this.getOprtState()) || "EDIT".equals(FaLeaseInEditUI.this.getOprtState())) {
                    FaLeaseInEditUI.this.calSubsLocalAmt();
                }
            }
        });
        this.txtSubsOriginAmt.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if ("ADDNEW".equals(FaLeaseInEditUI.this.getOprtState()) || "EDIT".equals(FaLeaseInEditUI.this.getOprtState())) {
                    FaLeaseInEditUI.this.calSubsLocalAmt();
                }
            }
        });
        this.detailTable.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                FaLeaseInEditUI.this.calAmount(e);
                FaLeaseInEditUI.this.setHireAmtColumnTitle();
            }
        });
    }

    private void loadLeaseDetail() {
        FaLeaseBalanceInEntryCollection resultCollection = new FaLeaseBalanceInEntryCollection();
        if (this.editData.getBalanceEntry() != null && this.editData.getBalanceEntry().size() > 0) {
            resultCollection = FaLeaseUtils.resortBalanceIn(this.editData.getBalanceEntry());
        }
        String[] timeZone = resultCollection.size() == 0 ? null : new String[resultCollection.size()];
        for (int i = 0; i < resultCollection.size(); ++i) {
            timeZone[i] = resultCollection.get(i).getMeasureUnit();
        }
        int payMode = this.editData.getPayMode() == null ? null : Integer.valueOf(this.editData.getPayMode().getValue());
        timeZone = FaLeaseUtils.formatTimeZone(payMode, timeZone);
        for (int i = 0; i < this.leaseTable.getRowCount(); ++i) {
            if (this.editData.getBalanceEntry() == null || this.editData.getBalanceEntry().get(i) == null) continue;
            this.leaseTable.getCell(i, "measureUnit").setValue(timeZone == null ? null : timeZone[i]);
            this.leaseTable.getCell(i, "shouldPayment").setValue((Object)this.editData.getBalanceEntry().get(i).getShouldPayment());
            this.leaseTable.getCell(i, "seq").setValue((Object)this.editData.getBalanceEntry().get(i).getSeq());
        }
        if (this.leaseTable.getRowCount() > 0 && this.editData != null && this.editData.getId() != null) {
            try {
                this.loadLeaseBalance(this.editData.getId().toString());
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
    }

    @Override
    protected boolean isEntryModify() {
        return super.isEntryModify();
    }

    protected void unLockUI() {
        super.unLockUI();
        this.lockLeaseContractFeild();
        this.setCardNumberEnabled();
        this.lockCurrency();
        this.txtSubsOriginAmt.setEditable(this.comboSubsCurrency.getSelectedItem() != null);
        this.txtSubsExRate.setEditable(this.comboSubsCurrency.getSelectedItem() != null);
    }

    @Override
    protected void initBtnStatus() throws Exception {
        super.initBtnStatus();
        if (this.editData == null || this.editData.getLeaseType() == null) {
            return;
        }
        boolean editable = !LeaseBizStatusEnum.RELETING.equals((Object)this.editData.getBizStatus()) && ("ADDNEW".equals(this.getOprtState()) || "EDIT".equals(this.getOprtState()));
        this.actionAddLine.setEnabled(editable);
        this.actionInsertLine.setEnabled(editable);
        this.actionRemoveLine.setEnabled(editable);
    }

    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        String bargainNum = this.txtBargainNum.getText();
        if (bargainNum != null && bargainNum.trim().length() > 0) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.getCurCompany().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)bargainNum));
            viewInfo.setFilter(filter);
            FALeaseContractCollection col = FALeaseContractFactory.getRemoteInstance().getFALeaseContractCollection(viewInfo);
            if (col != null && col.size() > 0) {
                BOSObjectType bosType = new FALeaseContractInfo().getBOSType();
                HashMap idList = new HashMap();
                for (int i = 0; i < col.size(); ++i) {
                    if (idList.get(bosType.toString()) == null) {
                        idList.put(bosType.toString(), new Vector());
                    }
                    ((Vector)idList.get(bosType.toString())).add(col.get(i).getId().toString());
                }
                FaClientUtils.showTraceUI((CoreUI)this, idList, 1);
                return;
            }
        }
        if (this.editData.getSourceBillId() != null && FaBillOriginEnum.FROM_LEASEIN_RELET.equals((Object)this.editData.getBillType())) {
            FaLeaseInBillInfo billInfo = FaLeaseInBillFactory.getRemoteInstance().getFaLeaseInBillInfo((IObjectPK)new ObjectUuidPK(this.editData.getSourceBillId()));
            HashMap idList = new HashMap();
            BOSObjectType bosType = this.editData.getBOSType();
            if (idList.get(bosType.toString()) == null) {
                idList.put(bosType.toString(), new Vector());
            }
            ((Vector)idList.get(bosType.toString())).add(billInfo.getId().toString());
            FaClientUtils.showTraceUI((CoreUI)this, idList, 1);
            return;
        }
        throw new BTPException(BTPException.DESTBILLNULL);
    }

    @Override
    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            throw new BTPException(BTPException.DESTBILLNULL);
        }
        IFaLeaseInBill iFaLeaseInBill = FaLeaseInBillFactory.getRemoteInstance();
        FaLeaseInBillInfo billInfo = iFaLeaseInBill.getFaLeaseInBillInfo("select id,fiVouchered,voucher.id,clearBill.id,entry.faCurCard.id,entry.changeBill.id where id ='" + this.editData.getId().toString() + "'");
        FaLeaseInBillEntryCollection entries = billInfo.getEntry();
        HashMap ids = new HashMap();
        Vector<String> cardBillVector = new Vector<String>();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            FaLeaseInBillEntryInfo entry = entries.get(i);
            if (entry.getFaCurCard() == null || entry.getFaCurCard().getId() == null) continue;
            cardBillVector.add(entry.getFaCurCard().getId().toString());
        }
        if (cardBillVector.size() > 0) {
            ids.put(new FaCurCardInfo().getBOSType().toString(), cardBillVector);
        }
        Vector<String> changeBillVector = new Vector<String>();
        int size2 = entries.size();
        for (int i = 0; i < size2; ++i) {
            FaLeaseInBillEntryInfo entry = entries.get(i);
            if (entry.getChangeBill() == null || entry.getChangeBill().getId() == null) continue;
            changeBillVector.add(entry.getChangeBill().getId().toString());
        }
        if (changeBillVector.size() > 0) {
            ids.put(new FaChangeBillInfo().getBOSType().toString(), changeBillVector);
        }
        Vector<String> leaseInBillVector = new Vector<String>();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)this.editData.getId().toString()));
        viewInfo.setFilter(filter);
        FaLeaseInBillCollection col = iFaLeaseInBill.getFaLeaseInBillCollection(viewInfo);
        if (col != null && col.size() > 0) {
            leaseInBillVector.add(col.get(0).getId().toString());
            ids.put(billInfo.getBOSType().toString(), leaseInBillVector);
        }
        Vector<String> clearBillVector = new Vector<String>();
        if (billInfo.getClearBill() != null && billInfo.getClearBill().getId() != null) {
            clearBillVector.add(billInfo.getClearBill().getId().toString());
            ids.put(new FaClearBillInfo().getBOSType().toString(), clearBillVector);
        }
        if (billInfo.isFiVouchered()) {
            Vector<String> voucherBillVector = new Vector<String>();
            IBOTRelation iBotRelation = BOTRelationFactory.getRemoteInstance();
            BOTRelationCollection relationCollection = iBotRelation.getCollection(new EntityViewInfo("where srcObjectID ='" + billInfo.getId() + "' and destEntityID ='" + new VoucherInfo().getBOSType().toString() + "'"));
            if (relationCollection.size() > 0) {
                for (BOTRelationInfo relationInfo : relationCollection) {
                    voucherBillVector.add(relationInfo.getDestObjectID());
                }
            }
            if (voucherBillVector.size() > 0) {
                ids.put(new VoucherInfo().getBOSType().toString(), voucherBillVector);
            }
        }
        if (ids.size() == 0) {
            throw new BTPException(BTPException.DESTBILLNULL);
        }
        this.showTraceUI(ids, 0);
    }

    private void setOrigCurrencyRate() {
        CurrencyInfo currencyInfo = (CurrencyInfo)this.comboHireCurrency.getSelectedItem();
        int scale = currencyInfo == null ? this.getCurrencyScale() : currencyInfo.getPrecision();
        this.formatTableColumn(this.detailTable, new String[]{"monOriginHireAmt", "hireOriginAmt"}, scale);
    }

    private void setExRateAndScale(KDComboBox comboCurrency, KDFormattedTextField txtOriginAmt, KDFormattedTextField txtExRate, boolean chageValue, String type) {
        try {
            BigDecimal rate = new BigDecimal("1.00");
            CurrencyInfo srcCyInfo = (CurrencyInfo)comboCurrency.getSelectedItem();
            CurrencyInfo desCyInfo = this.getBaseCurrency();
            int rateScale = desCyInfo.getPrecision();
            if (srcCyInfo != null && desCyInfo != null) {
                int originScale = srcCyInfo.getPrecision();
                txtOriginAmt.setPrecision(originScale);
                if (srcCyInfo.getId().equals((Object)desCyInfo.getId())) {
                    rateScale = srcCyInfo.getPrecision();
                    txtExRate.setEditable(false);
                } else {
                    txtExRate.setEditable(true);
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("name"));
                    sic.add(new SelectorItemInfo("baseExchangeTable.*"));
                    ObjectUuidPK companyPK = new ObjectUuidPK(this.getCurCompany().getId());
                    CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)companyPK, sic);
                    ExchangeTableInfo exchangeTableInfo = companyInfo.getBaseExchangeTable();
                    if (exchangeTableInfo != null) {
                        IExchangeRate iExchangeRate = ExchangeRateFactory.getRemoteInstance();
                        ExchangeRateInfo exchangeRateInfo = iExchangeRate.getExchangeRate((IObjectPK)new ObjectUuidPK(exchangeTableInfo.getId()), (IObjectPK)new ObjectUuidPK(srcCyInfo.getId()), (IObjectPK)new ObjectUuidPK(desCyInfo.getId()), (Date)this.getCurrPeriod().getEndDate());
                        if (exchangeRateInfo != null) {
                            rate = exchangeRateInfo.getConvertRate();
                            rateScale = exchangeRateInfo.getPrecision();
                            if (HIRE_TYPE.equals(type)) {
                                this.hireConvertMode = exchangeRateInfo.getConvertMode() == null ? 0 : exchangeRateInfo.getConvertMode().getValue();
                            } else if (SUBS_TYPE.equals(type)) {
                                this.subsConvertMode = exchangeRateInfo.getConvertMode() == null ? 0 : exchangeRateInfo.getConvertMode().getValue();
                            }
                        } else {
                            MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)RES_PATH, (String)"noLocalCurrencyExRate"), srcCyInfo.getName()));
                            txtExRate.setValue(null);
                            return;
                        }
                    }
                }
            }
            txtExRate.setPrecision(rateScale);
            if (chageValue) {
                txtExRate.setValue((Object)rate);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
            SysUtil.abort();
        }
    }

    private void setHireAmtColumnTitle() {
        if (this.comboPayMode.getSelectedItem() == FaPayModeEnum.ONE_PAY || this.comboPayMode.getSelectedItem() == FaPayModeEnum.APERIODIC_PAY) {
            int i;
            this.getDetailTable().getColumn("monOriginHireAmt").getStyleAttributes().setHided(true);
            this.getDetailTable().getColumn("monLocalHireAmt").getStyleAttributes().setHided(true);
            this.getDetailTable().getColumn("hireOriginAmt").getStyleAttributes().setLocked(false);
            for (i = 0; i < this.getDetailTable().getRowCount(); ++i) {
                this.getDetailTable().getCell(i, "monOriginHireAmt").setValue((Object)ZERO);
                this.getDetailTable().getCell(i, "monLocalHireAmt").setValue((Object)ZERO);
            }
            this.getLeaseTable().checkParsed();
            this.getLeaseTable().getColumn("measureUnit").getStyleAttributes().setHided(true);
            this.getLeaseTable().getColumn("shouldPayment").getStyleAttributes().setHided(true);
            for (i = 0; i < this.getLeaseTable().getRowCount(); ++i) {
                this.getLeaseTable().getCell(i, "measureUnit").setValue(null);
                this.getLeaseTable().getCell(i, "shouldPayment").setValue(null);
            }
        } else {
            this.getDetailTable().getColumn("hireOriginAmt").getStyleAttributes().setLocked(true);
            this.getDetailTable().getColumn("monOriginHireAmt").getStyleAttributes().setHided(false);
            this.getDetailTable().getColumn("monLocalHireAmt").getStyleAttributes().setHided(false);
            this.getLeaseTable().checkParsed();
            this.getLeaseTable().getColumn("measureUnit").getStyleAttributes().setHided(false);
            this.getLeaseTable().getColumn("shouldPayment").getStyleAttributes().setHided(false);
            String originColumnName = "";
            String localColumnName = "";
            String measureUnitColumnName = "";
            if (this.comboPayMode.getSelectedItem() == FaPayModeEnum.YEAR_PAY) {
                originColumnName = EASResource.getString((String)RES_PATH, (String)"yearOHireAmt");
                localColumnName = EASResource.getString((String)RES_PATH, (String)"yearLHireAmt");
                measureUnitColumnName = EASResource.getString((String)RES_PATH, (String)"year2");
            } else if (this.comboPayMode.getSelectedItem() == FaPayModeEnum.SEASON_PAY) {
                originColumnName = EASResource.getString((String)RES_PATH, (String)"seaOHireAmt");
                localColumnName = EASResource.getString((String)RES_PATH, (String)"seaLHireAmt");
                measureUnitColumnName = EASResource.getString((String)RES_PATH, (String)"season2");
            } else if (this.comboPayMode.getSelectedItem() == FaPayModeEnum.MONTH_PAY) {
                originColumnName = EASResource.getString((String)RES_PATH, (String)"monthOHireAmt");
                localColumnName = EASResource.getString((String)RES_PATH, (String)"monthLHireAmt");
                measureUnitColumnName = EASResource.getString((String)RES_PATH, (String)"month2");
            } else if (this.comboPayMode.getSelectedItem() == FaPayModeEnum.DAY_PAY) {
                originColumnName = EASResource.getString((String)RES_PATH, (String)"dayOHireAmt");
                localColumnName = EASResource.getString((String)RES_PATH, (String)"dayLHireAmt");
                measureUnitColumnName = EASResource.getString((String)RES_PATH, (String)"day");
            }
            this.getDetailTable().getHeadRow(0).getCell("monOriginHireAmt").setValue((Object)originColumnName);
            this.getDetailTable().getHeadRow(0).getCell("monLocalHireAmt").setValue((Object)localColumnName);
            this.getLeaseTable().getHeadRow(0).getCell("measureUnit").setValue((Object)measureUnitColumnName);
            String totalText = EASResource.getString((String)RES_PATH, (String)"total");
            this.kDLabelContainer3.setBoundLabelText(originColumnName + totalText);
            this.kDLabelContainer4.setBoundLabelText(localColumnName + totalText);
        }
        this.calcTotalAmount();
        this.fillLeaseTable();
    }

    private void setHideDetailColumn() {
        FaLeaseTypeInfo leaseTypeInfo = (FaLeaseTypeInfo)this.prmtLeaseType.getValue();
        boolean isLock = leaseTypeInfo != null && leaseTypeInfo.getNumber().equals(WORK_LEASE_TYPE);
        boolean fromRelet = LeaseBizStatusEnum.RELETING.equals((Object)this.editData.getBizStatus());
        this.getDetailTable().getColumn("cardNumber").getStyleAttributes().setHided(isLock);
        this.getDetailTable().getColumn("assetValue").getStyleAttributes().setHided(isLock);
        this.getDetailTable().getColumn("attornAmt").getStyleAttributes().setHided(isLock);
        this.getDetailTable().getColumn("deprLife").getStyleAttributes().setHided(isLock);
        this.getDetailTable().getColumn("unAssuredAmt").getStyleAttributes().setHided(isLock);
        this.getDetailTable().getColumn("fairAmt").getStyleAttributes().setHided(isLock);
        boolean viewStatus = !"ADDNEW".equals(this.getOprtState()) && !"EDIT".equals(this.getOprtState());
        this.getDetailTable().getColumn("assetValue").getStyleAttributes().setLocked(isLock || fromRelet || viewStatus);
        this.getDetailTable().getColumn("attornAmt").getStyleAttributes().setLocked(isLock || viewStatus);
        this.getDetailTable().getColumn("deprLife").getStyleAttributes().setLocked(isLock || viewStatus);
        this.getDetailTable().getColumn("unAssuredAmt").getStyleAttributes().setLocked(isLock || fromRelet || viewStatus);
        this.getDetailTable().getColumn("fairAmt").getStyleAttributes().setLocked(isLock || fromRelet || viewStatus);
        if (isLock) {
            for (int i = 0; i < this.getDetailTable().getRowCount(); ++i) {
                this.getDetailTable().getCell(i, "cardNumber").setValue(null);
                this.getDetailTable().getCell(i, "assetValue").setValue(null);
                this.getDetailTable().getCell(i, "attornAmt").setValue((Object)ZERO);
                this.getDetailTable().getCell(i, "deprLife").setValue(null);
                this.getDetailTable().getCell(i, "unAssuredAmt").setValue(null);
                this.getDetailTable().getCell(i, "fairAmt").setValue(null);
            }
            this.getDetailTable().getColumn("assetCat").getStyleAttributes().setBackground(this.getDetailTable().getColumn("specs").getStyleAttributes().getBackground());
        } else {
            this.getDetailTable().getColumn("assetCat").getStyleAttributes().setBackground(this.getDetailTable().getRequiredColor());
        }
        this.calcTotalAmount();
        this.tHelper.saveConfig(this.getDetailTable());
    }

    private boolean calEndDate() {
        Object measureUnit = this.comboMeasureUnit.getSelectedItem();
        java.sql.Date beginDate = this.pkBeginDate.getSqlDate();
        BigDecimal bargainTeim = this.txtBargainTime.getBigDecimalValue();
        if (beginDate != null && bargainTeim != null) {
            Date newDate = null;
            if (DateUnitEnum.DAY.equals(measureUnit)) {
                newDate = DateTimeUtils.addDay((Date)beginDate, (long)bargainTeim.intValue());
            } else if (DateUnitEnum.MONTH.equals(measureUnit)) {
                newDate = DateTimeUtils.addMonth((Date)beginDate, (int)bargainTeim.intValue());
                if (bargainTeim.doubleValue() - (double)bargainTeim.intValue() > 0.0) {
                    int maxDays = DateTimeUtils.daysOfMonth((int)DateTimeUtils.getYear((Date)newDate), (int)DateTimeUtils.getMonth((Date)newDate));
                    double days = (double)maxDays * (bargainTeim.doubleValue() - (double)bargainTeim.intValue());
                    newDate = DateTimeUtils.addDay((Date)newDate, (long)new Double(days).intValue());
                }
            } else if (DateUnitEnum.YEAR.equals(measureUnit)) {
                newDate = DateTimeUtils.addYear((Date)beginDate, (int)bargainTeim.intValue());
                if (bargainTeim.doubleValue() - (double)bargainTeim.intValue() > 0.0) {
                    Double months = new Double(12.0 * (bargainTeim.doubleValue() - (double)bargainTeim.intValue()));
                    newDate = DateTimeUtils.addMonth((Date)newDate, (int)months.intValue());
                    if (months - (double)months.intValue() > 0.0) {
                        int maxDays = DateTimeUtils.daysOfMonth((int)DateTimeUtils.getYear((Date)newDate), (int)DateTimeUtils.getMonth((Date)newDate));
                        double days = (double)maxDays * (months - (double)months.intValue());
                        newDate = DateTimeUtils.addDay((Date)newDate, (long)new Double(days).intValue());
                    }
                }
            }
            if (DateTimeUtils.getYear((Date)newDate) > 9999) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"leaseTimeOver"));
                return false;
            }
            newDate = new Date(newDate.getTime() - 86400000L);
            this.pkEndDate.setValue((Object)newDate);
        }
        return true;
    }

    private void hireExRateChanged() {
        for (int i = 0; i < this.detailTable.getRowCount(); ++i) {
            this.calMonthHireAmt(i);
            this.calEntryHireAmt(i);
        }
        this.calTotalHireAmt();
    }

    private void calSubsLocalAmt() {
        BigDecimal subsExRate = this.txtSubsExRate.getBigDecimalValue();
        BigDecimal subsOrginAmt = this.txtSubsOriginAmt.getBigDecimalValue();
        if (subsExRate != null && subsOrginAmt != null) {
            CurrencyInfo currencyInfo = (CurrencyInfo)this.comboSubsCurrency.getSelectedItem();
            int scale = currencyInfo == null ? this.getCurrencyScale() : currencyInfo.getPrecision();
            BigDecimal subsLocalAmt = FaClientUtils.getLocalAmount(this.subsConvertMode, subsExRate, scale, subsOrginAmt);
            subsLocalAmt = subsLocalAmt.setScale(scale, 4);
            this.txtSubsNaturalAmt.setValue((Object)subsLocalAmt);
        }
    }

    private void calAmount(KDTEditEvent e) {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (colIndex == this.detailTable.getColumnIndex("monOriginHireAmt")) {
            this.calMonthHireAmt(rowIndex);
            this.calEntryHireAmt(rowIndex);
            this.calTotalHireAmt();
        } else if (colIndex == this.detailTable.getColumnIndex("hireOriginAmt") && (FaPayModeEnum.ONE_PAY.equals(this.comboPayMode.getSelectedItem()) || FaPayModeEnum.APERIODIC_PAY.equals(this.comboPayMode.getSelectedItem()))) {
            BigDecimal originHireAmt = (BigDecimal)this.detailTable.getCell(rowIndex, "hireOriginAmt").getValue();
            BigDecimal exRate = this.txtHireExRate.getBigDecimalValue();
            if (originHireAmt != null && exRate != null) {
                BigDecimal localHireAmt = FaClientUtils.getLocalAmount(this.hireConvertMode, exRate, this.scale, originHireAmt);
                this.detailTable.getCell(rowIndex, "hireLocalAmt").setValue((Object)localHireAmt.setScale(this.getCurrencyScale(), 4));
            }
            this.calTotalHireAmt();
        } else if (colIndex == this.detailTable.getColumnIndex("hasInsurance")) {
            this.doDetailInsurance(rowIndex);
        }
        if (e.getValue() instanceof BigDecimal) {
            this.calcTotalAmount();
        }
    }

    private void calMonthHireAmt(int rowIndex) {
        BigDecimal monOriginHireAmt = (BigDecimal)this.detailTable.getCell(rowIndex, "monOriginHireAmt").getValue();
        BigDecimal exRate = this.txtHireExRate.getBigDecimalValue();
        if (monOriginHireAmt != null && exRate != null) {
            BigDecimal monLocalHireAmt = FaClientUtils.getLocalAmount(this.hireConvertMode, exRate, this.scale, monOriginHireAmt);
            this.detailTable.getCell(rowIndex, "monLocalHireAmt").setValue((Object)monLocalHireAmt.setScale(this.getCurrencyScale(), 4));
        }
    }

    private void calEntryHireAmt(int rowIndex) {
        BigDecimal monOriginHireAmt = (BigDecimal)this.detailTable.getCell(rowIndex, "monOriginHireAmt").getValue();
        BigDecimal exRate = this.txtHireExRate.getBigDecimalValue();
        BigDecimal hireOrginAmt = ZERO;
        BigDecimal hireLocalAmt = ZERO;
        DateUnitEnum measureUnit = (DateUnitEnum)((Object)this.comboMeasureUnit.getSelectedItem());
        java.sql.Date beginDate = this.pkBeginDate.getSqlDate();
        java.sql.Date endDate = this.pkEndDate.getSqlDate();
        int bargainTime = this.txtBargainTime.getBigDecimalValue().intValue();
        String[] timeZone = null;
        int lineCount = Integer.MAX_VALUE;
        if (FaPayModeEnum.YEAR_PAY.equals(this.comboPayMode.getSelectedItem())) {
            timeZone = FaLeaseUtils.getYearZone(beginDate, endDate);
            lineCount = measureUnit == DateUnitEnum.YEAR ? bargainTime : (measureUnit == DateUnitEnum.MONTH ? (int)Math.ceil((double)bargainTime / 12.0) : Integer.MAX_VALUE);
        } else if (FaPayModeEnum.SEASON_PAY.equals(this.comboPayMode.getSelectedItem())) {
            timeZone = FaLeaseUtils.getSeasonZone(beginDate, endDate);
            lineCount = measureUnit == DateUnitEnum.YEAR ? bargainTime * 4 : (measureUnit == DateUnitEnum.MONTH ? (int)Math.ceil((double)bargainTime / 3.0) : Integer.MAX_VALUE);
        } else if (FaPayModeEnum.MONTH_PAY.equals(this.comboPayMode.getSelectedItem())) {
            timeZone = FaLeaseUtils.getMonthZone(beginDate, endDate);
            lineCount = measureUnit == DateUnitEnum.YEAR ? bargainTime * 12 : (measureUnit == DateUnitEnum.MONTH ? bargainTime : Integer.MAX_VALUE);
        } else if (FaPayModeEnum.DAY_PAY.equals(this.comboPayMode.getSelectedItem())) {
            timeZone = FaLeaseUtils.getDayZone(beginDate, endDate);
        } else {
            return;
        }
        lineCount = Math.min(timeZone.length, lineCount);
        hireOrginAmt = monOriginHireAmt == null ? ZERO : monOriginHireAmt.multiply(new BigDecimal(lineCount));
        this.detailTable.getCell(rowIndex, "hireOriginAmt").setValue((Object)hireOrginAmt);
        if (exRate != null) {
            hireLocalAmt = FaClientUtils.getLocalAmount(this.hireConvertMode, exRate, this.scale, hireOrginAmt);
            hireLocalAmt = hireLocalAmt.setScale(this.getCurrencyScale(), 4);
            this.detailTable.getCell(rowIndex, "hireLocalAmt").setValue((Object)hireLocalAmt);
        }
    }

    private void calTotalHireAmt() {
        BigDecimal totalHireOrginAmt = ZERO;
        BigDecimal totalHireLocalAmt = ZERO;
        for (int i = 0; i < this.detailTable.getRowCount(); ++i) {
            BigDecimal hireLocalAmt;
            BigDecimal hireOrginAmt = (BigDecimal)this.detailTable.getCell(i, "hireOriginAmt").getValue();
            if (hireOrginAmt != null) {
                totalHireOrginAmt = totalHireOrginAmt.add(hireOrginAmt);
            }
            if ((hireLocalAmt = (BigDecimal)this.detailTable.getCell(i, "hireLocalAmt").getValue()) == null) continue;
            totalHireLocalAmt = totalHireLocalAmt.add(hireLocalAmt);
        }
        this.txtHireOriginAmt.setValue((Object)totalHireOrginAmt);
        this.txtHireNaturalAmt.setValue((Object)totalHireLocalAmt);
    }

    private void setCardNumberEnabled() {
        boolean isLock;
        if (!"ADDNEW".equals(this.getOprtState()) && !"EDIT".equals(this.getOprtState())) {
            return;
        }
        HashMap hmResult = null;
        try {
            hmResult = FaManageUtils.getFAParameter(this.getCurCompany().getId());
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (hmResult == null || hmResult.size() == 0) {
            this.getDetailTable().getColumn("cardNumber").getStyleAttributes().setLocked(true);
            return;
        }
        String autoCode = (String)hmResult.get("FA_001");
        FaLeaseTypeInfo leaseTypeInfo = (FaLeaseTypeInfo)this.prmtLeaseType.getValue();
        boolean bl = isLock = leaseTypeInfo != null && leaseTypeInfo.getNumber().equals(WORK_LEASE_TYPE);
        if (isLock || autoCode == null || autoCode.trim().length() == 0 || autoCode.trim().equalsIgnoreCase("true")) {
            this.getDetailTable().getColumn("cardNumber").getStyleAttributes().setLocked(true);
        } else {
            this.getDetailTable().getColumn("cardNumber").getStyleAttributes().setLocked(false);
            this.getDetailTable().getColumn("cardNumber").getStyleAttributes().setBackground(this.getDetailTable().getRequiredColor());
        }
    }

    @Override
    protected String[] getFormatColumns() {
        return new String[]{"monLocalHireAmt", "hireLocalAmt", "assetValue", "fairAmt", "initAmt", "unAssuredAmt", "insuranceAmt", "bailAmt", "attornAmt"};
    }

    @Override
    protected String[] getAssetAmtColumns() {
        return new String[]{"quantity"};
    }

    @Override
    protected String[] getEditableColumn() {
        return new String[]{"assetCat", "cardNumber", "cardName", "specs", "measureUnit", "quantity", "monOriginHireAmt", "assetValue", "fairAmt", "initAmt", "unAssuredAmt", "hasInsurance", "bailAmt", "attornAmt", "deprLife", "description"};
    }

    private void formatTableColumn(KDTable table, String[] colNames, int scale) {
        KDFormattedTextField txtAmtFieldFacAmount = new KDFormattedTextField(1);
        txtAmtFieldFacAmount.setPrecision(scale);
        txtAmtFieldFacAmount.setMaximumValue((Comparable)FaClientUtils.MAX_DECIMAL);
        txtAmtFieldFacAmount.setNegatived(false);
        txtAmtFieldFacAmount.setHorizontalAlignment(4);
        for (int i = 0; i < colNames.length; ++i) {
            table.getColumn(colNames[i]).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtAmtFieldFacAmount));
            table.getColumn(colNames[i]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            table.getColumn(colNames[i]).getStyleAttributes().setNumberFormat(FaClientUtils.getDecimalFormat(scale));
        }
    }

    private void initNumericTxt() throws Exception {
        this.txtHireNaturalAmt.setNegatived(false);
        this.txtSubsNaturalAmt.setNegatived(false);
        this.txtBargainTime.setNegatived(false);
        this.txtLeasedTime.setNegatived(false);
        this.txtRemainTime.setNegatived(false);
        this.txtHireOriginAmt.setHorizontalAlignment(4);
        this.txtHireOriginAmt.setNegatived(false);
        this.txtHireOriginAmt.setMaximumValue((Comparable)LCMClientUtils.MAX_DECIMAL);
        this.txtSubsOriginAmt.setHorizontalAlignment(4);
        this.txtSubsOriginAmt.setNegatived(false);
        this.txtSubsOriginAmt.setMaximumValue((Comparable)LCMClientUtils.MAX_DECIMAL);
        this.txtHireExRate.setHorizontalAlignment(4);
        this.txtHireExRate.setNegatived(false);
        this.txtHireExRate.setMaximumValue((Comparable)LCMClientUtils.MAX_DECIMAL);
        this.txtSubsExRate.setHorizontalAlignment(4);
        this.txtSubsExRate.setNegatived(false);
        this.txtSubsExRate.setMaximumValue((Comparable)LCMClientUtils.MAX_DECIMAL);
        this.setExRateAndScale(this.comboHireCurrency, this.txtHireOriginAmt, this.txtHireExRate, false, HIRE_TYPE);
        this.setExRateAndScale(this.comboSubsCurrency, this.txtSubsOriginAmt, this.txtSubsExRate, false, SUBS_TYPE);
        this.setComponentPrecision(new Object[]{this.txtHireNaturalAmt, this.txtSubsNaturalAmt}, this.getCurrencyScale());
        this.setComponentPrecision(new Object[]{this.txtBargainTime, this.txtLeasedTime, this.txtRemainTime}, 0);
    }

    @Override
    protected IObjectValue createNewData() {
        this.detailTable.removeRows();
        FaLeaseInBillInfo leaseInBillInfo = new FaLeaseInBillInfo();
        Date today = new Date();
        today = DateTimeUtils.truncateDate((Date)today);
        try {
            PeriodInfo currenctPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.getCurCompany());
            if (currenctPeriod != null) {
                if (DateTimeUtils.dayBefore((Date)today, (Date)currenctPeriod.getBeginDate())) {
                    today = currenctPeriod.getBeginDate();
                }
                if (DateTimeUtils.dayAfter((Date)today, (Date)currenctPeriod.getEndDate())) {
                    today = currenctPeriod.getEndDate();
                }
                today = new Date(today.getTime());
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        leaseInBillInfo.setCompany(this.currCompany);
        leaseInBillInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        leaseInBillInfo.setSignatureDate(today);
        leaseInBillInfo.setBeginDate(today);
        leaseInBillInfo.setDeliverDate(today);
        leaseInBillInfo.setBizStatus(LeaseBizStatusEnum.CHECKING);
        leaseInBillInfo.setMeasureUnit(DateUnitEnum.YEAR);
        leaseInBillInfo.setBargainTime(DEFAULT_BARGAINTIME);
        Date endDate = DateTimeUtils.addYear((Date)today, (int)DEFAULT_BARGAINTIME.intValue());
        leaseInBillInfo.setEndDate(new Date(endDate.getTime() - 86400000L));
        leaseInBillInfo.setPayMode(FaPayModeEnum.MONTH_PAY);
        leaseInBillInfo.setHireOriginAmt(ZERO);
        leaseInBillInfo.setHireNaturalAmt(ZERO);
        leaseInBillInfo.setSubsOriginAmt(ZERO);
        leaseInBillInfo.setSubsNaturalAmt(ZERO);
        BigDecimal ONE = new BigDecimal("1.00");
        leaseInBillInfo.setHireExRate(ONE);
        leaseInBillInfo.setSubsExRate(ONE);
        leaseInBillInfo.getEntry().add((FaLeaseInBillEntryInfo)this.createNewDetailData(this.detailTable));
        return leaseInBillInfo;
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue newData) {
        FaLeaseInBillInfo leaseInBillInfo = (FaLeaseInBillInfo)newData;
        Date today = new Date();
        today = DateTimeUtils.truncateDate((Date)today);
        try {
            PeriodInfo currenctPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.getCurCompany());
            if (currenctPeriod != null) {
                if (DateTimeUtils.dayBefore((Date)today, (Date)currenctPeriod.getBeginDate())) {
                    today = currenctPeriod.getBeginDate();
                }
                if (DateTimeUtils.dayAfter((Date)today, (Date)currenctPeriod.getEndDate())) {
                    today = currenctPeriod.getEndDate();
                }
                today = new Date(today.getTime());
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        leaseInBillInfo.setBargainNum(null);
        leaseInBillInfo.setSignatureDate(today);
        leaseInBillInfo.setBeginDate(today);
        leaseInBillInfo.setDeliverDate(today);
        leaseInBillInfo.setMeasureUnit(DateUnitEnum.YEAR);
        leaseInBillInfo.setBargainTime(DEFAULT_BARGAINTIME);
        Date endDate = DateTimeUtils.addYear((Date)today, (int)DEFAULT_BARGAINTIME.intValue());
        leaseInBillInfo.setEndDate(new Date(endDate.getTime() - 86400000L));
        leaseInBillInfo.setCompany(this.currCompany);
        leaseInBillInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        leaseInBillInfo.setCreateTime(null);
        leaseInBillInfo.setFiVouchered(false);
        leaseInBillInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        leaseInBillInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
        leaseInBillInfo.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        leaseInBillInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        leaseInBillInfo.setBizStatus(LeaseBizStatusEnum.CHECKING);
        leaseInBillInfo.setString("billType", null);
        leaseInBillInfo.setAuditor(null);
        leaseInBillInfo.setAuditTime(null);
        if (leaseInBillInfo.getEntry() != null) {
            leaseInBillInfo.getEntry().clear();
        }
    }

    protected void afterRemoveLine(KDTable table, IObjectValue lineData) {
        this.calTotalHireAmt();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("hireCurrency.id"));
        sic.add(new SelectorItemInfo("hireCurrency.number"));
        sic.add(new SelectorItemInfo("hireCurrency.name"));
        sic.add(new SelectorItemInfo("hireCurrency.isoCode"));
        sic.add(new SelectorItemInfo("hireCurrency.sign"));
        sic.add(new SelectorItemInfo("hireCurrency.baseUnit"));
        sic.add(new SelectorItemInfo("hireCurrency.precision"));
        sic.add(new SelectorItemInfo("hireCurrency.deletedStatus"));
        sic.add(new SelectorItemInfo("subsCurrency.id"));
        sic.add(new SelectorItemInfo("subsCurrency.number"));
        sic.add(new SelectorItemInfo("subsCurrency.name"));
        sic.add(new SelectorItemInfo("subsCurrency.isoCode"));
        sic.add(new SelectorItemInfo("subsCurrency.sign"));
        sic.add(new SelectorItemInfo("subsCurrency.baseUnit"));
        sic.add(new SelectorItemInfo("subsCurrency.precision"));
        sic.add(new SelectorItemInfo("subsCurrency.deletedStatus"));
        sic.add(new SelectorItemInfo("entry.faCurCard.id"));
        sic.add(new SelectorItemInfo("entry.faCurCard.number"));
        sic.add(new SelectorItemInfo("entry.faCurCard.assetName"));
        sic.add(new SelectorItemInfo("entry.faCurCard.specs"));
        sic.add(new SelectorItemInfo("entry.faCurCard.assetCat.number"));
        sic.add(new SelectorItemInfo("entry.faCurCard.assetCat.name"));
        sic.add(new SelectorItemInfo("entry.faCurCard.measureUnit.name"));
        return sic;
    }

    private void calcTotalAmount() {
        int baseScale;
        BigDecimal clrAssetValue = ZERO;
        BigDecimal clrMonthOrginHireAmt = ZERO;
        BigDecimal clrmonLocalHireAmt = ZERO;
        BigDecimal clrQuantity = ZERO;
        BigDecimal clrInsuranceAmt = ZERO;
        BigDecimal clrBailAmt = ZERO;
        BigDecimal clrAttornAmt = ZERO;
        BigDecimal clrUnAssuredAmt = ZERO;
        BigDecimal clrInitAmt = ZERO;
        BigDecimal clrEvaluateValue = ZERO;
        for (int i = 0; i < this.detailTable.getRowCount(); ++i) {
            IRow row = this.detailTable.getRow(i);
            BigDecimal cellAssetValue = row.getCell("assetValue").getValue() == null ? ZERO : (BigDecimal)row.getCell("assetValue").getValue();
            BigDecimal quantity = new BigDecimal(row.getCell("quantity").getValue() == null ? "0" : row.getCell("quantity").getValue().toString());
            BigDecimal monLocalHireAmt = new BigDecimal(row.getCell("monLocalHireAmt").getValue() == null ? "0" : row.getCell("monLocalHireAmt").getValue().toString());
            BigDecimal insuranceAmt = new BigDecimal(row.getCell("insuranceAmt").getValue() == null ? "0" : row.getCell("insuranceAmt").getValue().toString());
            BigDecimal bailAmt = new BigDecimal(row.getCell("bailAmt").getValue() == null ? "0" : row.getCell("bailAmt").getValue().toString());
            BigDecimal attornAmt = new BigDecimal(row.getCell("attornAmt").getValue() == null ? "0" : row.getCell("attornAmt").getValue().toString());
            BigDecimal monthOrginHireAmt = new BigDecimal(row.getCell("monOriginHireAmt").getValue() == null ? "0" : row.getCell("monOriginHireAmt").getValue().toString());
            BigDecimal initAmt = new BigDecimal(row.getCell("initAmt").getValue() == null ? "0" : row.getCell("initAmt").getValue().toString());
            BigDecimal evaluateValue = new BigDecimal(row.getCell("fairAmt").getValue() == null ? "0" : row.getCell("fairAmt").getValue().toString());
            BigDecimal unAssuredAmt = new BigDecimal(row.getCell("unAssuredAmt").getValue() == null ? "0" : row.getCell("unAssuredAmt").getValue().toString());
            clrAssetValue = clrAssetValue.add(cellAssetValue);
            clrQuantity = clrQuantity.add(quantity);
            clrmonLocalHireAmt = clrmonLocalHireAmt.add(monLocalHireAmt);
            clrInsuranceAmt = clrInsuranceAmt.add(insuranceAmt);
            clrBailAmt = clrBailAmt.add(bailAmt);
            clrAttornAmt = clrAttornAmt.add(attornAmt);
            clrMonthOrginHireAmt = clrMonthOrginHireAmt.add(monthOrginHireAmt);
            clrInitAmt = clrInitAmt.add(initAmt);
            clrEvaluateValue = clrEvaluateValue.add(evaluateValue);
            clrUnAssuredAmt = clrUnAssuredAmt.add(unAssuredAmt);
        }
        int originScale = baseScale = this.getCurrencyScale();
        if (this.comboHireCurrency.getSelectedItem() != null) {
            CurrencyInfo hireCurrency = (CurrencyInfo)this.comboHireCurrency.getSelectedItem();
            originScale = hireCurrency.getPrecision();
        }
        this.lblTotalAssetValue.setText(FaClientUtils.formatNumber(clrAssetValue, baseScale));
        this.lblTotalFairAmt.setText(FaClientUtils.formatNumber(clrEvaluateValue, baseScale));
        this.lblTotaMonOriginHireAmt.setText(FaClientUtils.formatNumber(clrMonthOrginHireAmt, originScale));
        this.lblTotalMonLocalHireAmt.setText(FaClientUtils.formatNumber(clrmonLocalHireAmt, baseScale));
        this.lblTotalInitAmt.setText(FaClientUtils.formatNumber(clrInitAmt, baseScale));
        this.lblTotalQuantity.setText(FaClientUtils.formatNumber(clrQuantity, this.getFAQuantityScale()));
        this.lblTotalUnAssuredAmt.setText(FaClientUtils.formatNumber(clrUnAssuredAmt, baseScale));
        this.lblTotalInsuranceAmt.setText(FaClientUtils.formatNumber(clrInsuranceAmt, baseScale));
        this.lblTotalBailAmt.setText(FaClientUtils.formatNumber(clrBailAmt, baseScale));
        this.lblTotalAttornAmt.setText(FaClientUtils.formatNumber(clrAttornAmt, baseScale));
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return FaLeaseInBillFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewDetailData(KDTable table) {
        FaLeaseInBillEntryInfo entryInfo = new FaLeaseInBillEntryInfo();
        entryInfo.setQuantity(ZERO);
        entryInfo.setAssetValue(ZERO);
        entryInfo.setAttornAmt(ZERO);
        entryInfo.setBailAmt(ZERO);
        entryInfo.setFairAmt(ZERO);
        entryInfo.setMonOriginHireAmt(ZERO);
        entryInfo.setMonLocalHireAmt(ZERO);
        entryInfo.setHireOriginAmt(ZERO);
        entryInfo.setHireLocalAmt(ZERO);
        entryInfo.setInitAmt(ZERO);
        entryInfo.setUnAssuredAmt(ZERO);
        entryInfo.setInsuranceAmt(ZERO);
        return entryInfo;
    }

    private CurrencyInfo getBaseCurrency() {
        if (this.baseCurrency == null) {
            this.baseCurrency = (CurrencyInfo)this.initUiInfo.get("baseCurrency");
        }
        return this.baseCurrency;
    }

    private CurrencyCollection getCurrencyCollection() {
        if (this.initCurrencyCollection == null) {
            this.initCurrencyCollection = (CurrencyCollection)this.initUiInfo.get("currencyCollection");
        }
        if (this.oprtState == null || !"VIEW".equals(this.oprtState)) {
            CurrencyCollection currencyCollection = new CurrencyCollection();
            int size = this.initCurrencyCollection.size();
            for (int i = 0; i < size; ++i) {
                CurrencyInfo currencyInfo = this.initCurrencyCollection.get(i);
                if (currencyInfo.getDeletedStatus().getValue() == 2) continue;
                currencyCollection.add(currencyInfo);
            }
            return currencyCollection;
        }
        return this.initCurrencyCollection;
    }

    private PeriodInfo getCurrPeriod() {
        PeriodInfo currenctPeriod = null;
        try {
            currenctPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.getCurCompany());
        }
        catch (Exception ex) {
            this.handleException(ex);
            SysUtil.abort();
        }
        if (currenctPeriod == null) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.notConfigStartPeriod");
            MsgBox.showInfo((Component)((Object)this), (String)strMsg);
            SysUtil.abort();
        }
        return currenctPeriod;
    }

    @Override
    protected boolean isShowCardFilter() {
        return false;
    }

    @Override
    protected String getEntryKeyName() {
        return "entry";
    }

    @Override
    protected String getPrintPath() {
        return "/FI/FA/FaLeaseInBill";
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        this.addPrintData();
        BillBaseCollection billCol = new BillBaseCollection();
        billCol.add((BillBaseInfo)this.editData);
        KDNoteHelper appHlp = new KDNoteHelper();
        KDTable[] tables = new KDTable[]{this.getDetailTable()};
        BOSQueryDelegate data = FaPrintHelper.getPrintManagerForFaLeaseInBillEditUI((IObjectCollection)billCol, tables);
        appHlp.printPreview(this.getPrintPath(), (Object)data, (Component)((Object)this));
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        this.addPrintData();
        BillBaseCollection billCol = new BillBaseCollection();
        billCol.add((BillBaseInfo)this.editData);
        KDNoteHelper appHlp = new KDNoteHelper();
        KDTable[] tables = new KDTable[]{this.getDetailTable()};
        BOSQueryDelegate data = FaPrintHelper.getPrintManagerForFaLeaseInBillEditUI((IObjectCollection)billCol, tables);
        appHlp.print(this.getPrintPath(), (Object)data, (Component)((Object)this));
    }

    private void addPrintData() {
        DateUnitEnum measureUnit = (DateUnitEnum)((Object)this.comboMeasureUnit.getSelectedItem());
        String leasedTime = measureUnit == null ? this.txtLeasedTime.getText() : this.txtLeasedTime.getText() + measureUnit.getAlias();
        String remainTime = measureUnit == null ? this.txtRemainTime.getText() : this.txtRemainTime.getText() + measureUnit.getAlias();
        this.editData.put("leasedTime", leasedTime);
        this.editData.put("remainTime", remainTime);
        this.editData.put("assetValueTotal", this.lblTotalAssetValue.getText());
        this.editData.put("evaluateValueTotal", this.lblTotalFairAmt.getText());
        this.editData.put("monOriginHireAmtTotal", this.lblTotaMonOriginHireAmt.getText());
        this.editData.put("monLocalHireAmtTotal", this.lblTotalMonLocalHireAmt.getText());
        this.editData.put("initAmtTotal", this.lblTotalInitAmt.getText());
        this.editData.put("unAssuredAmTotal", this.lblTotalUnAssuredAmt.getText());
        this.editData.put("insuranceAmtTotal", this.lblTotalInsuranceAmt.getText());
        this.editData.put("attornAmtTotal", this.lblTotalAttornAmt.getText());
        this.editData.put("bailAmtTotal", this.lblTotalBailAmt.getText());
        this.editData.put("rentQuantity", this.lblTotalQuantity.getText());
        if (this.editData.getPayMode() != null) {
            this.editData.put("payMode.name", this.editData.getPayMode().getAlias());
        }
    }

    @Override
    protected void beforeStoreFields(ActionEvent e) throws Exception {
        String info;
        if (e == null || e != null && this.getActionFromActionEvent(e).equals(this.actionSubmit)) {
            String autoCode;
            HashMap hmResult;
            KDTable detailTable;
            int rowCount;
            PeriodInfo currPeriod;
            java.sql.Date deliverDate;
            if (this.txtHireCompany.getText() == null || this.txtHireCompany.getText().trim().equals("")) {
                info = EASResource.getString((String)RES_PATH, (String)"HireIsNull");
                MsgBox.showInfo((String)info);
                this.txtHireCompany.requestFocus();
                SysUtil.abort();
            }
            if (this.txtLeaseCompany.getText() == null || this.txtLeaseCompany.getText().trim().equals("")) {
                info = EASResource.getString((String)RES_PATH, (String)"RenterIsNull");
                MsgBox.showInfo((String)info);
                this.txtLeaseCompany.requestFocus();
                SysUtil.abort();
            }
            if (this.prmtLeaseType.getValue() == null) {
                info = EASResource.getString((String)RES_PATH, (String)"LeaseTypeIsNull");
                MsgBox.showInfo((String)info);
                this.prmtLeaseType.requestFocus();
                SysUtil.abort();
            }
            if (DateTimeUtils.dayAfter((Date)(deliverDate = this.pkDeliverDate.getSqlDate()), (Date)(currPeriod = this.getCurrPeriod()).getEndDate()) || DateTimeUtils.dayBefore((Date)deliverDate, (Date)currPeriod.getBeginDate())) {
                info = MessageFormat.format(EASResource.getString((String)RES_PATH, (String)"currPeriodIs"), currPeriod.toString()) + "\uff0c" + EASResource.getString((String)RES_PATH, (String)"deliverDateNotInCurrPeiord");
                MsgBox.showInfo((String)info);
                this.pkDeliverDate.requestFocus();
                SysUtil.abort();
            }
            if (this.pkSignatureDate.getValue() != null && ((Date)this.pkSignatureDate.getValue()).compareTo((Date)this.pkDeliverDate.getValue()) > 0) {
                info = EASResource.getString((String)RES_PATH, (String)"signatureDateMorethanDeliverDate");
                MsgBox.showInfo((String)info);
                this.pkDeliverDate.requestFocus();
                SysUtil.abort();
            }
            if (this.pkDeliverDate.getValue() != null && ((Date)this.pkDeliverDate.getValue()).compareTo((Date)this.pkBeginDate.getValue()) > 0) {
                info = EASResource.getString((String)RES_PATH, (String)"deliverDateMorethanBeginDate");
                MsgBox.showInfo((String)info);
                this.pkBeginDate.requestFocus();
                SysUtil.abort();
            }
            if (this.txtBargainTime.getBigDecimalValue().floatValue() <= 0.0f) {
                info = EASResource.getString((String)RES_PATH, (String)"BargainTimeMoreZero");
                MsgBox.showInfo((String)info);
                this.txtBargainTime.requestFocus();
                SysUtil.abort();
            }
            boolean isOk = true;
            Object timeUnit = this.comboMeasureUnit.getSelectedItem();
            if (FaPayModeEnum.YEAR_PAY.equals(this.comboPayMode.getSelectedItem()) || FaPayModeEnum.SEASON_PAY.equals(this.comboPayMode.getSelectedItem())) {
                if (DateUnitEnum.MONTH.equals(timeUnit) || DateUnitEnum.DAY.equals(timeUnit)) {
                    isOk = false;
                }
            } else if (FaPayModeEnum.MONTH_PAY.equals(this.comboPayMode.getSelectedItem()) && DateUnitEnum.DAY.equals(timeUnit)) {
                isOk = false;
            }
            if (!isOk) {
                info = EASResource.getString((String)RES_PATH, (String)"leaseTimeUnitMorethanPayMode");
                MsgBox.showInfo((String)info);
                this.comboPayMode.requestFocus();
                SysUtil.abort();
            }
            if (this.comboHireCurrency.getSelectedItem() == null) {
                info = EASResource.getString((String)RES_PATH, (String)"hireCurrencyIsNull");
                MsgBox.showInfo((String)info);
                this.comboHireCurrency.requestFocus();
                SysUtil.abort();
            }
            if (this.txtHireExRate.getBigDecimalValue() == null || this.txtHireExRate.getBigDecimalValue().compareTo(ZERO) <= 0) {
                info = EASResource.getString((String)RES_PATH, (String)"exRateLessZeroIsNull");
                MsgBox.showInfo((String)info);
                this.txtHireExRate.requestFocus();
                SysUtil.abort();
            }
            if (this.comboSubsCurrency.getSelectedItem() != null && this.txtSubsExRate.getBigDecimalValue() == null) {
                info = EASResource.getString((String)RES_PATH, (String)"subsExRateIsNull");
                MsgBox.showInfo((String)info);
                this.txtSubsExRate.requestFocus();
                SysUtil.abort();
            }
            if (this.comboSubsCurrency.getSelectedItem() != null && this.txtSubsExRate.getBigDecimalValue() != null && this.txtSubsExRate.getBigDecimalValue().compareTo(ZERO) <= 0) {
                info = EASResource.getString((String)RES_PATH, (String)"exRateLessZeroIsNull");
                MsgBox.showInfo((String)info);
                this.txtSubsExRate.requestFocus();
                SysUtil.abort();
            }
            if ((rowCount = (detailTable = this.getDetailTable()).getRowCount()) == 0) {
                info = EASResource.getString((String)RES_PATH, (String)"LeaseDetailIsNull");
                MsgBox.showInfo((String)info);
                SysUtil.abort();
            }
            boolean isAutoNumber = true;
            if (((FaLeaseTypeInfo)this.prmtLeaseType.getValue()).getNumber().equals("002") && (hmResult = FaManageUtils.getFAParameter(this.getCurCompany().getId())).size() > 0 && ((autoCode = (String)hmResult.get("FA_001")) == null || autoCode.trim().equalsIgnoreCase("false"))) {
                isAutoNumber = false;
            }
            int count = detailTable.getRowCount();
            for (int i = 0; i < count; ++i) {
                BigDecimal quantity;
                Object measureUnit;
                Object cardNumber;
                Object cardName;
                Object assetCat = detailTable.getCell(i, "assetCat").getValue();
                if (assetCat == null && ((FaLeaseTypeInfo)this.prmtLeaseType.getValue()).getNumber().equals("002")) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"assetCatIsNull"));
                    detailTable.getEditManager().editCellAt(i, detailTable.getColumnIndex("assetCat"));
                    SysUtil.abort();
                }
                if ((cardName = detailTable.getCell(i, "cardName").getValue()) == null || cardName.toString().trim().length() == 0) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"cardNameIsNull"));
                    detailTable.getEditManager().editCellAt(i, detailTable.getColumnIndex("cardName"));
                    SysUtil.abort();
                }
                if (!(isAutoNumber || (cardNumber = detailTable.getCell(i, "cardNumber").getValue()) != null && cardNumber.toString().trim().length() != 0)) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"cardNumberIsNull"));
                    detailTable.getEditManager().editCellAt(i, detailTable.getColumnIndex("cardNumber"));
                    SysUtil.abort();
                }
                if ((measureUnit = detailTable.getCell(i, "measureUnit").getValue()) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"measureUnitIsNull"));
                    detailTable.getEditManager().editCellAt(i, detailTable.getColumnIndex("measureUnit"));
                    SysUtil.abort();
                }
                if ((quantity = (BigDecimal)detailTable.getCell(i, "quantity").getValue()) == null || quantity.doubleValue() <= 0.0) {
                    info = EASResource.getString((String)RES_PATH, (String)"QuantityMoreThanZero");
                    MsgBox.showInfo((String)info);
                    detailTable.getEditManager().editCellAt(i, detailTable.getColumnIndex("quantity"));
                    SysUtil.abort();
                }
                BigDecimal monOriginHireAmt = (BigDecimal)detailTable.getCell(i, "monOriginHireAmt").getValue();
                if (!FaPayModeEnum.APERIODIC_PAY.equals(this.comboPayMode.getSelectedItem()) && !FaPayModeEnum.ONE_PAY.equals(this.comboPayMode.getSelectedItem()) && monOriginHireAmt == null) {
                    info = EASResource.getString((String)RES_PATH, (String)"isNull");
                    info = detailTable.getHeadRow(0).getCell("monOriginHireAmt").getValue().toString() + info;
                    MsgBox.showInfo((String)info);
                    detailTable.getEditManager().editCellAt(i, detailTable.getColumnIndex("monOriginHireAmt"));
                    SysUtil.abort();
                }
                if (detailTable.getCell(i, "hireOriginAmt").getValue() == null) {
                    info = EASResource.getString((String)RES_PATH, (String)"hireOriginAmtIsNull");
                    MsgBox.showInfo((String)info);
                    detailTable.getEditManager().editCellAt(i, detailTable.getColumnIndex("hireOriginAmt"));
                    SysUtil.abort();
                }
                if (!"002".equals(((FaLeaseTypeInfo)this.prmtLeaseType.getValue()).getNumber())) continue;
                if (detailTable.getCell(i, "assetValue").getValue() == null) {
                    info = EASResource.getString((String)RES_PATH, (String)"assetValueIsNull");
                    MsgBox.showInfo((String)info);
                    detailTable.getEditManager().editCellAt(i, detailTable.getColumnIndex("assetValue"));
                    SysUtil.abort();
                }
                if (detailTable.getCell(i, "deprLife").getValue() != null) continue;
                info = EASResource.getString((String)RES_PATH, (String)"deprLifeIsNull");
                MsgBox.showInfo((String)info);
                detailTable.getEditManager().editCellAt(i, detailTable.getColumnIndex("deprLife"));
                SysUtil.abort();
            }
        }
        String monthHireAmtTitle = (String)this.detailTable.getHeadRow(0).getCell("monLocalHireAmt").getValue();
        String hireOriginAmtTitme = (String)this.detailTable.getHeadRow(0).getCell("hireOriginAmt").getValue();
        String hireLocalAmtTitme = (String)this.detailTable.getHeadRow(0).getCell("hireLocalAmt").getValue();
        String morethanMax = EASResource.getString((String)RES_PATH, (String)"morethanMax");
        morethanMax = morethanMax.replaceFirst("[{}]", FaClientUtils.MAX_DECIMAL.toString()).replaceFirst("}", "");
        int count = this.detailTable.getRowCount();
        for (int i = 0; i < count; ++i) {
            BigDecimal monLocalHireAmt = (BigDecimal)this.detailTable.getCell(i, "monLocalHireAmt").getValue();
            BigDecimal hireOriginAmt = (BigDecimal)this.detailTable.getCell(i, "hireOriginAmt").getValue();
            BigDecimal hireLocalAmt = (BigDecimal)this.detailTable.getCell(i, "hireLocalAmt").getValue();
            String leaseDetailNoRow = EASResource.getString((String)RES_PATH, (String)"leaseDetailNoRow").replaceFirst("[{}]", String.valueOf(i + 1)).replaceFirst("}", "");
            if (monLocalHireAmt != null && monLocalHireAmt.compareTo(FaClientUtils.MAX_DECIMAL) > 0) {
                MsgBox.showInfo((String)(leaseDetailNoRow + monthHireAmtTitle + morethanMax));
                SysUtil.abort();
            }
            if (hireOriginAmt != null && hireOriginAmt.compareTo(FaClientUtils.MAX_DECIMAL) > 0) {
                MsgBox.showInfo((String)(leaseDetailNoRow + hireOriginAmtTitme + morethanMax));
                SysUtil.abort();
            }
            if (hireLocalAmt == null || hireLocalAmt.compareTo(FaClientUtils.MAX_DECIMAL) <= 0) continue;
            MsgBox.showInfo((String)(leaseDetailNoRow + hireLocalAmtTitme + morethanMax));
            SysUtil.abort();
        }
        if (this.txtHireOriginAmt.getBigDecimalValue() != null && this.txtHireOriginAmt.getBigDecimalValue().compareTo(FaClientUtils.MAX_DECIMAL) > 0) {
            info = EASResource.getString((String)RES_PATH, (String)"hireOriginAmtMorethanMax");
            MsgBox.showInfo((String)info.replaceFirst("[{}]", FaClientUtils.MAX_DECIMAL.toString()).replaceFirst("}", ""));
            this.txtHireOriginAmt.requestFocus();
            SysUtil.abort();
        }
        if (this.txtHireNaturalAmt.getBigDecimalValue() != null && this.txtHireNaturalAmt.getBigDecimalValue().compareTo(FaClientUtils.MAX_DECIMAL) > 0) {
            info = EASResource.getString((String)RES_PATH, (String)"hireLocalAmtMorethanMax");
            MsgBox.showInfo((String)info.replaceFirst("[{}]", FaClientUtils.MAX_DECIMAL.toString()).replaceFirst("}", ""));
            this.txtHireNaturalAmt.requestFocus();
            SysUtil.abort();
        }
        if (this.txtSubsNaturalAmt.getBigDecimalValue() != null && this.txtSubsNaturalAmt.getBigDecimalValue().compareTo(FaClientUtils.MAX_DECIMAL) > 0) {
            info = EASResource.getString((String)RES_PATH, (String)"subsLocalAmtMorethanMax");
            MsgBox.showInfo((String)info.replaceFirst("[{}]", FaClientUtils.MAX_DECIMAL.toString()).replaceFirst("}", ""));
            this.txtSubsNaturalAmt.requestFocus();
            SysUtil.abort();
        }
    }

    @Override
    protected void addLine(KDTable table) {
        if (table == null) {
            return;
        }
        IObjectValue detailData = this.createNewDetailData(table);
        IRow row = table.addRow();
        this.loadLineFields(table, row, detailData);
        this.afterAddLine(table, detailData);
    }

    protected void afterAddLine(KDTable table, IObjectValue lineData) {
        table.setEditable(true);
        table.setEnabled(true);
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        BigDecimal sumShouldPayment = ZERO;
        for (int i = 0; i < this.leaseTable.getRowCount(); ++i) {
            BigDecimal tempShouldPayment = (BigDecimal)this.leaseTable.getCell(i, "shouldPayment").getValue();
            sumShouldPayment = sumShouldPayment.add(tempShouldPayment == null ? ZERO : tempShouldPayment);
        }
        BigDecimal totalHireOrginAmt = this.txtHireNaturalAmt.getBigDecimalValue();
        boolean isHidedShouldPayment = this.leaseTable.getColumn("shouldPayment").getStyleAttributes().isHided();
        if (!isHidedShouldPayment && sumShouldPayment != null && totalHireOrginAmt != null && sumShouldPayment.compareTo(totalHireOrginAmt) != 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RES_PATH, (String)"notCompareToAmt"));
            SysUtil.abort();
        }
        super.actionSubmit_actionPerformed(e);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    private KDTable getLeaseTable() {
        return this.leaseTable;
    }

    private void fillLeaseTable() {
        for (int i = 0; i < this.detailTable.getRowCount(); ++i) {
            this.calEntryHireAmt(i);
        }
        this.calTotalHireAmt();
        this.fillLeaseDetails();
    }

    private void fillLeaseDetails() {
        this.leaseTable.removeRows();
        BigDecimal amount = this.txtHireNaturalAmt.getBigDecimalValue();
        java.sql.Date beginDate = this.pkBeginDate.getSqlDate();
        java.sql.Date endDate = this.pkEndDate.getSqlDate();
        int bargainTime = this.txtBargainTime.getBigDecimalValue().intValue();
        DateUnitEnum measureUnit = (DateUnitEnum)((Object)this.comboMeasureUnit.getSelectedItem());
        String[] timeZone = null;
        int lineCount = Integer.MAX_VALUE;
        if (FaPayModeEnum.YEAR_PAY.equals(this.comboPayMode.getSelectedItem())) {
            timeZone = FaLeaseUtils.getYearZone(beginDate, endDate);
            lineCount = measureUnit == DateUnitEnum.YEAR ? bargainTime : (measureUnit == DateUnitEnum.MONTH ? (int)Math.ceil((double)bargainTime / 12.0) : Integer.MAX_VALUE);
        } else if (FaPayModeEnum.SEASON_PAY.equals(this.comboPayMode.getSelectedItem())) {
            timeZone = FaLeaseUtils.getSeasonZone(beginDate, endDate);
            lineCount = measureUnit == DateUnitEnum.YEAR ? bargainTime * 4 : (measureUnit == DateUnitEnum.MONTH ? (int)Math.ceil((double)bargainTime / 3.0) : Integer.MAX_VALUE);
        } else if (FaPayModeEnum.MONTH_PAY.equals(this.comboPayMode.getSelectedItem())) {
            timeZone = FaLeaseUtils.getMonthZone(beginDate, endDate);
            lineCount = measureUnit == DateUnitEnum.YEAR ? bargainTime * 12 : (measureUnit == DateUnitEnum.MONTH ? bargainTime : Integer.MAX_VALUE);
        } else if (FaPayModeEnum.DAY_PAY.equals(this.comboPayMode.getSelectedItem())) {
            timeZone = FaLeaseUtils.getDayZone(beginDate, endDate);
        } else {
            this.leaseTable.addRow();
            return;
        }
        BigDecimal sumValue = new BigDecimal("0");
        lineCount = Math.min(timeZone.length, lineCount);
        BigDecimal cellValue = amount.divide(new BigDecimal(lineCount), this.scale, 4);
        for (int i = 0; i < lineCount - 1; ++i) {
            this.leaseTable.addRow();
            this.leaseTable.getCell(i, "measureUnit").setValue((Object)timeZone[i]);
            this.leaseTable.getCell(i, "shouldPayment").setValue((Object)cellValue);
            sumValue = sumValue.add(cellValue);
        }
        this.leaseTable.addRow();
        this.leaseTable.getCell(lineCount - 1, "measureUnit").setValue((Object)timeZone[lineCount - 1]);
        this.leaseTable.getCell(lineCount - 1, "shouldPayment").setValue((Object)amount.subtract(sumValue));
    }

    private void loadLeaseBalance(String billId) throws BOSException {
        CoreBaseCollection balances = this.getBalance(billId);
        FaLeaseBalanceEntryCollection entries = new FaLeaseBalanceEntryCollection();
        if (balances.size() == 0) {
            return;
        }
        entries = ((FaLeaseBalanceBillInfo)balances.get(0)).getEntry();
        entries = FaLeaseUtils.resortBalance(entries);
        for (int i = 0; i < entries.size(); ++i) {
            FaLeaseBalanceEntryInfo entry = entries.get(i);
            int rowIndex = entry.getSeq() - 1;
            IRow row = this.leaseTable.getRow(rowIndex);
            if (row == null) {
                row = this.leaseTable.addRow();
            }
            row.getCell("actualPayment").setValue((Object)entry.getActualPayment().setScale(this.scale, 4));
            row.getCell("paymentType").setValue((Object)entry.getPaymentType().toString());
            row.getCell("paymentDate").setValue((Object)entry.getPaymentDate());
            row.getCell("balanceType").setValue(entry.getBalanceType() == null ? null : entry.getBalanceType().getName());
            row.getCell("balanceNumber").setValue((Object)entry.getBalanceNumber());
            row.getCell("bank").setValue(entry.getBank() == null ? null : entry.getBank().getName());
            row.getCell("paymentAccount").setValue(entry.getPaymentAccount() == null ? null : entry.getPaymentAccount().getName());
            row.getCell("paymentAcctView").setValue(entry.getPaymentAcctView() == null ? null : entry.getPaymentAcctView().getNumber() + " - " + entry.getPaymentAcctView().getName());
            row.getCell("paymentOppAcctView").setValue(entry.getPaymentOppAcctView() == null ? null : entry.getPaymentOppAcctView().getNumber() + " - " + entry.getPaymentOppAcctView().getName());
            row.getCell("relatedNumber").setValue((Object)entry.getRelatedNumber());
            row.getCell("realPayment").setValue((Object)entry.getRealPayment().setScale(this.scale, 4));
            row.getCell("feeAcctView").setValue(entry.getFeeAcctView() == null ? null : entry.getFeeAcctView().getNumber() + " - " + entry.getFeeAcctView().getName());
            row.getCell("feeOppAcctView").setValue(entry.getFeeOppAcctView() == null ? null : entry.getFeeOppAcctView().getNumber() + " - " + entry.getFeeOppAcctView().getName());
            row.getCell("handler").setValue((Object)entry.getHandler().getName());
            String isCheck = entry.getCheckedStatus().getValue() == 2 ? EASResource.getString((String)RES_PATH, (String)"hasAudit") : (entry.isCheckStatus() ? EASResource.getString((String)RES_PATH, (String)"hasCheck") : EASResource.getString((String)RES_PATH, (String)"hasSubmit"));
            row.getCell("checkedStatus").setValue((Object)isCheck);
            String vchNumber = this.getVchNumber(entry.getId().toString());
            row.getCell("vchNumber").setValue((Object)(vchNumber == null ? null : vchNumber));
            row.getCell("isPayment").setValue((Object)(entry.isIsPayment() ? EASResource.getString((String)RES_PATH, (String)"paymentBill") : EASResource.getString((String)RES_PATH, (String)"gatheringBill")));
            row.getCell("id").setValue((Object)entry.getId().toString());
        }
    }

    private CoreBaseCollection getBalance(String billId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new String("entry.actualPayment"));
        sic.add(new String("entry.paymentType"));
        sic.add(new String("entry.paymentDate"));
        sic.add(new String("entry.balanceType.name"));
        sic.add(new String("entry.balanceNumber"));
        sic.add(new String("entry.bank.name"));
        sic.add(new String("entry.paymentAccount.name"));
        sic.add(new String("entry.paymentAccount.number"));
        sic.add(new String("entry.paymentAcctView.name"));
        sic.add(new String("entry.paymentAcctView.number"));
        sic.add(new String("entry.paymentOppAcctView.name"));
        sic.add(new String("entry.relatedNumber"));
        sic.add(new String("entry.realPayment"));
        sic.add(new String("entry.feeAcctView.name"));
        sic.add(new String("entry.feeAcctView.number"));
        sic.add(new String("entry.feeOppAcctView.name"));
        sic.add(new String("entry.feeOppAcctView.number"));
        sic.add(new String("entry.handler.name"));
        sic.add(new String("entry.checkedStatus"));
        sic.add(new String("entry.checkStatus"));
        sic.add(new String("entry.voucher.number"));
        sic.add(new String("entry.seq"));
        sic.add(new String("entry.isPayment"));
        sic.add(new String("entry.id"));
        sic.add(new String("id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("leaseInBill.id", (Object)billId));
        filter.setMaskString("#0");
        view.setFilter(filter);
        String oql = "select *,entry.*,entry.paymentAccount.name,entry.paymentAccount.number,entry.paymentAcctView.name,entry.paymentAcctView.number,entry.paymentOppAcctView.name,entry.paymentOppAcctView.number,";
        oql = oql + "entry.feeAcctView.name,entry.feeAcctView.number,entry.feeOppAcctView.name,entry.feeOppAcctView.number,entry.bank.name,entry.balanceType.name,entry.handler.name ";
        CoreBaseCollection balances = FaLeaseBalanceBillFactory.getRemoteInstance().getCollection(oql + "where leaseInBill.id='" + billId + "'");
        return balances;
    }

    private String getVchNumber(String srcBillId) throws BOSException {
        String vchNumber = null;
        ArrayList relationCollection = BOTRelationFactory.getRemoteInstance().getDestObjIdByDestType(srcBillId, VOUCHERTYPE);
        if (relationCollection != null && relationCollection.size() > 0) {
            HashSet<String> keySet = new HashSet<String>();
            keySet.add(relationCollection.get(0).toString());
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("number"));
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", keySet, CompareType.INCLUDE));
            VoucherCollection vchCollection = VoucherFactory.getRemoteInstance().getVoucherCollection(view);
            if (vchCollection != null && vchCollection.get(0) != null) {
                vchNumber = vchCollection.get(0).getNumber().toString();
            }
        }
        return vchNumber;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.setClassName(this.getUIHandlerClassName());
            clientHanlder.setRequestContext((Serializable)request);
            request.put("COMPANY", (Object)SysContext.getSysContext().getCurrentFIUnit());
            request.put("USERINFO", (Object)SysContext.getSysContext().getCurrentUserInfo());
        }
        return clientHanlder;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    private void comboHireCurrency_itemStateChanged(ItemEvent e) {
        if (e == null || e.getStateChange() != 1) {
            return;
        }
        this.setOrigCurrencyRate();
        this.setExRateAndScale(this.comboHireCurrency, this.txtHireOriginAmt, this.txtHireExRate, "ADDNEW".equals(this.getOprtState()) || "EDIT".equals(this.getOprtState()), HIRE_TYPE);
        this.lockCurrency();
    }

    private void comboSubsCurrency_itemStateChanged(ItemEvent e) {
        if (e == null || e.getStateChange() != 1) {
            return;
        }
        this.setExRateAndScale(this.comboSubsCurrency, this.txtSubsOriginAmt, this.txtSubsExRate, "ADDNEW".equals(this.getOprtState()) || "EDIT".equals(this.getOprtState()), SUBS_TYPE);
        if ("ADDNEW".equals(this.getOprtState()) || "EDIT".equals(this.getOprtState())) {
            boolean editable;
            boolean bl = editable = e.getItem() != null;
            if (!editable) {
                this.txtSubsOriginAmt.setValue(null);
                this.txtSubsExRate.setValue(null);
            }
            this.txtSubsOriginAmt.setEditable(editable);
            this.txtSubsExRate.setEditable(editable);
        }
        this.lockCurrency();
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.loadCurrency();
    }
}

