/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.FaContractCatInfo;
import com.kingdee.eas.fi.fa.basedata.client.FaContractCatPromptBox;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaLeaseNewDepCostSharingFilterUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.rpt.FaListFactory;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class FaLeaseNewDepCostSharingFilterUI
extends AbstractFaLeaseNewDepCostSharingFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(FaLeaseNewDepCostSharingFilterUI.class);
    private CompanyOrgUnitInfo aCompanyOrgUnitInfo = null;
    private HashMap periodCollection = new HashMap();
    private PeriodInfo currPeriod = null;
    private PeriodInfo startPeriod = null;
    private boolean isLoadData = false;
    private Integer minPeriodYear;
    private Integer maxPeriodYear;
    private Integer minPeriodStartNumber;
    private Integer maxPerioEndNumber;

    public FaLeaseNewDepCostSharingFilterUI() throws Exception {
        if (this.aCompanyOrgUnitInfo == null) {
            this.aCompanyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
            this.prmtCompany.setEnabled(false);
            this.prmtCompany.setData((Object)this.aCompanyOrgUnitInfo.getName());
        }
        FaClientUtils.checkBeforeOnload4Fl(this.getUIContext(), this.aCompanyOrgUnitInfo);
        this.currPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)this.aCompanyOrgUnitInfo);
        if (this.currPeriod == null) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaLeaseNewResource.Lease_Period_Is_Null");
            MsgBox.showInfo((Component)((Object)this), (String)strMsg);
            SysUtil.abort();
        }
        this.addListener();
        this.initControl();
        this.startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)this.aCompanyOrgUnitInfo);
        SpinnerNumberModel yearMinNumberModel = new SpinnerNumberModel();
        yearMinNumberModel.setMinimum(new Integer(this.startPeriod.getPeriodYear()));
        yearMinNumberModel.setMaximum(new Integer(this.currPeriod.getPeriodYear()));
        SpinnerNumberModel yearMaxNumberModel = new SpinnerNumberModel();
        yearMaxNumberModel.setMinimum(new Integer(this.startPeriod.getPeriodYear()));
        yearMaxNumberModel.setMaximum(new Integer(this.currPeriod.getPeriodYear()));
        this.minPeriodYear = this.startPeriod.getPeriodYear();
        this.maxPeriodYear = this.currPeriod.getPeriodYear();
        this.minPeriodStartNumber = this.startPeriod.getPeriodNumber();
        this.maxPerioEndNumber = this.currPeriod.getPeriodNumber();
        this.sldYearFrom.setModel((SpinnerModel)yearMinNumberModel);
        this.sldYearTo.setModel((SpinnerModel)yearMaxNumberModel);
        this.sldYearFrom.setValue((Object)new Integer(this.currPeriod.getPeriodYear()));
        this.sldYearTo.setValue((Object)new Integer(this.currPeriod.getPeriodYear()));
        this.sldPeriodFrom.setValue((Object)new Integer(this.currPeriod.getPeriodNumber()));
        this.sldPeriodTo.setValue((Object)new Integer(this.currPeriod.getPeriodNumber()));
        PeriodCollection periods = PeriodFactory.getRemoteInstance().getPeriodCollection("where periodType.id='" + this.aCompanyOrgUnitInfo.getAccountPeriodType().getId() + "' and periodYear>=" + this.startPeriod.getPeriodYear());
        for (int i = 0; i < periods.size(); ++i) {
            PeriodInfo period = periods.get(i);
            this.periodCollection.put(period.getPeriodYear() + "" + period.getPeriodNumber(), period);
        }
    }

    private void initControl() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)true));
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
        viewInfo.setFilter(filterInfo);
        FaContractCatPromptBox faContractCatPromptBox = new FaContractCatPromptBox((CoreUIObject)this);
        this.bizPromptContractType.setEntityViewInfo(viewInfo);
        this.bizPromptContractType.setSelector((KDPromptSelector)faContractCatPromptBox);
        this.bizPromptContractType.setEnabledMultiSelection(true);
        this.bizPromptContractType.setQueryInfo("com.kingdee.eas.fi.fa.basedata.app.FaContractCatF7Query");
        this.bizPromptContractType.setEditable(true);
        this.bizPromptContractType.setEditFormat("$number$");
        this.bizPromptContractType.setDisplayFormat("$number$ - $name$");
        this.bizPromptContractType.setCommitFormat("$number$");
    }

    private void addListener() {
        this.sldYearFrom.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    FaLeaseNewDepCostSharingFilterUI.this.fireStartYearChange();
                }
                catch (Exception ex) {
                    FaLeaseNewDepCostSharingFilterUI.this.handUIException(ex);
                }
                FaLeaseNewDepCostSharingFilterUI.this.firePeriodChange(e);
            }
        });
        this.sldYearTo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    FaLeaseNewDepCostSharingFilterUI.this.fireEndYearChange();
                }
                catch (Exception ex) {
                    FaLeaseNewDepCostSharingFilterUI.this.handUIException(ex);
                }
                FaLeaseNewDepCostSharingFilterUI.this.firePeriodChange(e);
            }
        });
        this.sldPeriodFrom.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaLeaseNewDepCostSharingFilterUI.this.firePeriodChange(e);
            }
        });
        this.sldPeriodTo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaLeaseNewDepCostSharingFilterUI.this.firePeriodChange(e);
            }
        });
    }

    private int getPeriodNumber(int year, int number) {
        if (number > 13 || number < 1) {
            throw new IllegalArgumentException("period number illeagle: number > 13 || number< 1");
        }
        return year * 100 + number;
    }

    private void fireStartYearChange() throws EASBizException, BOSException {
        String periodTypeID = FaClientUtils.getCurrentCompany().getAccountPeriodType().getId().toString();
        int periodYear = this.sldYearFrom.getIntegerVlaue();
        try {
            int periodNum = FaListFactory.getRemoteInstance().findPeriodNum(periodYear, periodTypeID);
            Integer minPeriod = new Integer(1);
            Integer maxPeriod = new Integer(periodNum);
            SpinnerNumberModel periodSpinnerNumberModel = new SpinnerNumberModel();
            if (this.minPeriodYear == null) {
                this.minPeriodYear = this.sldYearFrom.getIntegerVlaue();
            }
            if (this.maxPeriodYear == null) {
                this.maxPeriodYear = this.sldYearFrom.getIntegerVlaue();
            }
            if (periodYear == this.minPeriodYear) {
                Integer n = minPeriod = this.minPeriodStartNumber == null ? new Integer(0) : this.minPeriodStartNumber;
            }
            if (periodYear == this.maxPeriodYear) {
                maxPeriod = this.maxPerioEndNumber == null ? new Integer(0) : this.maxPerioEndNumber;
            }
            periodSpinnerNumberModel.setMinimum(minPeriod);
            periodSpinnerNumberModel.setMaximum(maxPeriod);
            this.sldPeriodFrom.setModel((SpinnerModel)periodSpinnerNumberModel);
            this.sldPeriodFrom.setValue((Object)minPeriod);
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
    }

    private void firePeriodChange(ChangeEvent e) {
        int endPeriod;
        int startPeriod = this.sldYearFrom.getIntegerVlaue() * 100 + this.sldPeriodFrom.getIntegerVlaue();
        if (startPeriod > (endPeriod = this.sldYearTo.getIntegerVlaue() * 100 + this.sldPeriodTo.getIntegerVlaue())) {
            if (e.getSource() == this.sldYearFrom || e.getSource() == this.sldPeriodFrom) {
                this.sldYearTo.setValue(this.sldYearFrom.getValue());
                this.sldPeriodTo.setValue(this.sldPeriodFrom.getValue());
            } else if (!this.isLoadData) {
                this.sldYearFrom.setValue(this.sldYearTo.getValue());
                this.sldPeriodFrom.setValue(this.sldPeriodTo.getValue());
            }
        }
    }

    private void fireEndYearChange() throws EASBizException, BOSException {
        String periodTypeID = FaClientUtils.getCurrentCompany().getAccountPeriodType().getId().toString();
        int periodYear = this.sldYearTo.getIntegerVlaue();
        try {
            int periodNum = FaListFactory.getRemoteInstance().findPeriodNum(periodYear, periodTypeID);
            Integer minPeriod = new Integer(1);
            Integer maxPeriod = new Integer(periodNum);
            SpinnerNumberModel periodSpinnerNumberModel = new SpinnerNumberModel();
            if (this.minPeriodYear == null) {
                this.minPeriodYear = this.sldYearFrom.getIntegerVlaue();
            }
            if (this.maxPeriodYear == null) {
                this.maxPeriodYear = this.sldYearFrom.getIntegerVlaue();
            }
            if (periodYear == this.minPeriodYear) {
                Integer n = minPeriod = this.minPeriodStartNumber == null ? new Integer(0) : this.minPeriodStartNumber;
            }
            if (periodYear == this.maxPeriodYear) {
                maxPeriod = this.maxPerioEndNumber == null ? new Integer(0) : this.maxPerioEndNumber;
            }
            periodSpinnerNumberModel.setMinimum(minPeriod);
            periodSpinnerNumberModel.setMaximum(maxPeriod);
            this.sldPeriodTo.setModel((SpinnerModel)periodSpinnerNumberModel);
            this.sldPeriodTo.setValue((Object)minPeriod);
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
    }

    public FilterInfo getFilterInfo() {
        FilterItemInfo templateFilterItemInfo;
        Object data;
        StringBuffer sbFormula = new StringBuffer();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        int i = 0;
        CustomerParams periodMap = new CustomerParams();
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        if (aCompanyOrgUnitInfo != null && aCompanyOrgUnitInfo.getId() != null) {
            FilterItemInfo companyFilterItemInfo = new FilterItemInfo("company.id", (Object)aCompanyOrgUnitInfo.getId().toString());
            items.add(companyFilterItemInfo);
            sbFormula.append(" #" + i++);
        }
        if ((data = this.bizPromptContractType.getData()) != null) {
            HashSet<String> typeIdSet = new HashSet<String>();
            if (data instanceof Object[]) {
                Object[] objs;
                for (Object obj : objs = (Object[])data) {
                    FaContractCatInfo cat = (FaContractCatInfo)obj;
                    if (cat == null) continue;
                    typeIdSet.add(cat.getId().toString());
                }
            } else if (data instanceof FaContractCatInfo) {
                FaContractCatInfo cat = (FaContractCatInfo)data;
                typeIdSet.add(cat.getId().toString());
            }
            FilterItemInfo templateFilterItemInfo2 = new FilterItemInfo("leaseInBill.contractCat.id", typeIdSet, CompareType.INCLUDE);
            items.add(templateFilterItemInfo2);
            sbFormula.append(" and #" + i++);
        }
        if (this.txtNumberFrom.getText() != null && this.txtNumberFrom.getText().trim().length() > 0) {
            templateFilterItemInfo = new FilterItemInfo("leaseInBill.number", (Object)this.txtNumberFrom.getText().trim(), CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo);
            sbFormula.append(" and #" + i++);
        }
        if (this.txtNumberTo.getText() != null && this.txtNumberTo.getText().trim().length() > 0) {
            templateFilterItemInfo = new FilterItemInfo("leaseInBill.number", (Object)this.txtNumberTo.getText().trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo);
            sbFormula.append(" and #" + i++);
        }
        if (this.sldPeriodFrom.getValue() != null) {
            int yearFrom = this.sldYearFrom.getIntegerVlaue();
            int numberFrom = this.sldPeriodFrom.getIntegerVlaue();
            periodMap.putInt("period.periodYearFrom", yearFrom);
            periodMap.putInt("period.periodNumberFrom", numberFrom);
            int startPeriodNumber = this.getPeriodNumber(yearFrom, numberFrom);
            FilterItemInfo startPeriod = new FilterItemInfo("period.number", (Object)startPeriodNumber, CompareType.GREATER_EQUALS);
            items.add(startPeriod);
            sbFormula.append(" and #" + i++ + " ");
        }
        if (this.sldPeriodTo.getValue() != null) {
            int yearTo = this.sldYearTo.getIntegerVlaue();
            int numberTo = this.sldPeriodTo.getIntegerVlaue();
            periodMap.putInt("period.periodYearTo", yearTo);
            periodMap.putInt("period.periodNumberTo", numberTo);
            int toPeriodNumber = this.getPeriodNumber(yearTo, numberTo);
            FilterItemInfo endPeriod = new FilterItemInfo("period.number", (Object)toPeriodNumber, CompareType.LESS_EQUALS);
            items.add(endPeriod);
            sbFormula.append(" and #" + i++ + " ");
        }
        if (sbFormula.toString().length() != 0) {
            filter.setMaskString(sbFormula.toString());
        }
        this.setCustomerParams(periodMap);
        return filter;
    }

    public void clear() {
        super.clear();
        this.sldYearFrom.setValue((Object)new Integer(this.currPeriod.getPeriodYear()));
        this.sldYearTo.setValue((Object)new Integer(this.currPeriod.getPeriodYear()));
        this.sldPeriodFrom.setValue((Object)new Integer(this.currPeriod.getPeriodNumber()));
        this.sldPeriodTo.setValue((Object)new Integer(this.currPeriod.getPeriodNumber()));
        this.txtNumberFrom.setText(null);
        this.txtNumberTo.setText(null);
        this.bizPromptContractType.setData(null);
    }
}

