/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.client.BankF7Selector;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.client.AccountClientUtils;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceBillFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceBillInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceEntryInfo;
import com.kingdee.eas.fi.fa.manage.LeasePaymentTypeEnum;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaLeasePaymentUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.MessageFormat;
import java.util.Map;

public class FaLeasePaymentUI
extends AbstractFaLeasePaymentUI {
    private boolean isPayment = false;
    private int currencyScale = 0;
    private String CARD_RES_PATH = "com.kingdee.eas.fi.fa.manage.FaCardResource";
    private static final String LES_RES_PATH = "com.kingdee.eas.fi.fa.manage.FaLeaseResource";
    DataChangeListener dataChangeListener = new DataChangeListener(){

        public void dataChanged(DataChangeEvent e) {
            AccountViewInfo data = (AccountViewInfo)e.getNewValue();
            if (data != null && data.getId() != null) {
                String info;
                KDBizPromptBox promptBox;
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("isLeaf"));
                sic.add(new SelectorItemInfo("isSelfFreeze"));
                sic.add(new SelectorItemInfo("isParentFreeze"));
                AccountViewInfo accViewInfo = new AccountViewInfo();
                try {
                    accViewInfo = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(data.getId().toString()), sic);
                }
                catch (EASBizException e1) {
                    accViewInfo = data;
                }
                catch (BOSException e1) {
                    accViewInfo = data;
                }
                if (!accViewInfo.isIsLeaf()) {
                    promptBox = (KDBizPromptBox)e.getSource();
                    promptBox.setData(e.getOldValue());
                    info = EASResource.getString((String)FaLeasePaymentUI.this.CARD_RES_PATH, (String)"FaCurCardEditUI_IsLeafAccount");
                    MsgBox.showInfo((Component)((Object)FaLeasePaymentUI.this), (String)info);
                    promptBox.requestFocus();
                    SysUtil.abort();
                }
                if (accViewInfo.isIsSelfFreeze() || accViewInfo.isIsParentFreeze()) {
                    promptBox = (KDBizPromptBox)e.getSource();
                    promptBox.setData(e.getOldValue());
                    info = EASResource.getString((String)FaLeasePaymentUI.this.CARD_RES_PATH, (String)"Account_Is_Freeze");
                    MsgBox.showInfo((Component)((Object)FaLeasePaymentUI.this), (String)info);
                    promptBox.requestFocus();
                    SysUtil.abort();
                }
            }
        }
    };

    public void onLoad() throws Exception {
        Map uicontext = this.getUIContext();
        if (uicontext.get("isPayment") == null) {
            String id = uicontext.get("ID").toString();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("isPayment"));
            IObjectValue obj = DynamicObjectFactory.getRemoteInstance().getValue(BOSUuid.getBOSObjectType((String)id, (boolean)true), (IObjectPK)new ObjectUuidPK(id), sic);
            this.isPayment = obj.getBoolean("isPayment");
        } else {
            this.isPayment = (Boolean)this.getUIContext().get("isPayment");
        }
        this.currencyScale = FaClientUtils.getCurrencyScale();
        FaClientUtils.setComponentPrecision(new Object[]{this.txtActualPayment, this.txtRealPayment}, this.currencyScale);
        super.onLoad();
        this.initBizCtrl();
    }

    private void initBizCtrl() {
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        AccountPromptBox acctViewF7 = FaClientUtils.getAccountPromptBox((IUIObject)this, company);
        EntityViewInfo view = new EntityViewInfo();
        AccountClientUtils.checkCompanyAccountTable((CoreUI)this, (CompanyOrgUnitInfo)company);
        FilterInfo filterInfo = FaClientUtils.getAccountViewFilter((String)company.getCU().getId().toString(), (String)company.getAccountTable().getId().toString());
        view.setFilter(filterInfo);
        this.prmtFeeAcctView.setEntityViewInfo(view);
        this.prmtFeeAcctView.setSelector((KDPromptSelector)acctViewF7);
        this.prmtFeeOppAcctView.setEntityViewInfo(view);
        this.prmtFeeOppAcctView.setSelector((KDPromptSelector)acctViewF7);
        this.prmtPaymentAcctView.setEntityViewInfo(view);
        this.prmtPaymentAcctView.setSelector((KDPromptSelector)acctViewF7);
        this.prmtPaymentOppAcctView.setEntityViewInfo(view);
        this.prmtPaymentOppAcctView.setSelector((KDPromptSelector)acctViewF7);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isBank", (Object)new Boolean(true)));
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Boolean(true)));
        view = new EntityViewInfo();
        view.setFilter(filter);
        this.prmtBank.setEntityViewInfo(view);
        this.prmtBank.setSelector((KDPromptSelector)new BankF7Selector((IUIObject)this, this.prmtBank));
        this.btnRemove.setVisible(true);
        this.btnVoucher.setVisible(true);
        this.btnDelVoucher.setVisible(true);
        String pay_str = EASResource.getString((String)LES_RES_PATH, (String)"payment");
        String recv_str = EASResource.getString((String)LES_RES_PATH, (String)"receivement");
        String incoming_str = EASResource.getString((String)LES_RES_PATH, (String)"incoming");
        String fee_str = EASResource.getString((String)LES_RES_PATH, (String)"fee");
        String shoufukuan1 = this.isPayment ? recv_str : pay_str;
        String shoufukuan2 = this.isPayment ? pay_str : recv_str;
        String feiyong1 = this.isPayment ? incoming_str : fee_str;
        String feiyong2 = this.isPayment ? fee_str : incoming_str;
        this.contNumber.setBoundLabelText(this.contNumber.getBoundLabelText().replaceAll(shoufukuan1, shoufukuan2));
        this.contBank.setBoundLabelText(this.contBank.getBoundLabelText().replaceAll(shoufukuan1, shoufukuan2));
        this.contPaymentAccount.setBoundLabelText(this.contPaymentAccount.getBoundLabelText().replaceAll(shoufukuan1, shoufukuan2));
        this.contPaymentAcctView.setBoundLabelText(this.contPaymentAcctView.getBoundLabelText().replaceAll(shoufukuan1, shoufukuan2));
        this.contPaymentOppAcctView.setBoundLabelText(this.contPaymentOppAcctView.getBoundLabelText().replaceAll(shoufukuan1, shoufukuan2));
        this.contPaymentType.setBoundLabelText(this.contPaymentType.getBoundLabelText().replaceAll(shoufukuan1, shoufukuan2));
        this.contPaymentDate.setBoundLabelText(this.contPaymentDate.getBoundLabelText().replaceAll(shoufukuan1, shoufukuan2));
        this.contActualPayment.setBoundLabelText(this.contActualPayment.getBoundLabelText().replaceAll(shoufukuan1, shoufukuan2));
        this.contRealPayment.setBoundLabelText(this.contRealPayment.getBoundLabelText().replaceAll(feiyong1, feiyong2));
        this.contFeeAcctView.setBoundLabelText(this.contFeeAcctView.getBoundLabelText().replaceAll(feiyong1, feiyong2));
        this.contFeeOppAcctView.setBoundLabelText(this.contFeeOppAcctView.getBoundLabelText().replaceAll(feiyong1, feiyong2));
        this.hideOrShowAuditResult(false);
        this.initDataStatus();
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        this.prmtPaymentAccount.setEnabled(!"VIEW".equals(oprtType) && this.prmtBank.getValue() != null);
    }

    protected void initListener() {
        super.initListener();
        this.prmtBank.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                BankInfo newValue = (BankInfo)e.getNewValue();
                if (newValue == null) {
                    FaLeasePaymentUI.this.prmtPaymentAccount.setValue(null);
                    FaLeasePaymentUI.this.prmtPaymentAccount.setEnabled(false);
                } else {
                    FaLeasePaymentUI.this.prmtPaymentAccount.setEnabled(true);
                    FaLeasePaymentUI.this.prmtPaymentAccount.getQueryAgent().resetRuntimeEntityView();
                    EntityViewInfo view = FaLeasePaymentUI.this.getAccountBankEvi(SysContext.getSysContext().getCurrentFIUnit().getId().toString(), newValue.getId().toString());
                    FaLeasePaymentUI.this.prmtPaymentAccount.setEntityViewInfo(view);
                }
            }
        });
        this.prmtFeeAcctView.addDataChangeListener(this.dataChangeListener);
        this.prmtFeeOppAcctView.addDataChangeListener(this.dataChangeListener);
        this.prmtPaymentAcctView.addDataChangeListener(this.dataChangeListener);
        this.prmtPaymentOppAcctView.addDataChangeListener(this.dataChangeListener);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
        this.setOprtState(OprtState.ADDNEW);
        this.editData = (FaLeaseBalanceEntryInfo)this.createNewData();
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
        this.unLockUI();
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkForGenVoucher();
        super.actionVoucher_actionPerformed(e);
        this.editData = (FaLeaseBalanceEntryInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(this.editData.getId()), this.getSelectors());
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
        if (this.editData.isFiVouchered()) {
            this.setSaved(true);
        }
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
        this.editData = (FaLeaseBalanceEntryInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(this.editData.getId()), this.getSelectors());
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
        if (!this.editData.isFiVouchered()) {
            this.setSaved(true);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.initDataStatus();
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkHasSaved();
        if (MsgBox.isOk((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.CARD_RES_PATH, (String)"IF_AUDIT")))) {
            FaLeaseBalanceBillFactory.getRemoteInstance().auditBill((IObjectPK)new ObjectUuidPK(this.editData.getId()));
            this.setSaved(true);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.CARD_RES_PATH, (String)"AUDIT_SUCCESS"));
            this.editData = (FaLeaseBalanceEntryInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(this.editData.getId()), this.getSelectors());
            this.setDataObject((IObjectValue)this.editData);
            this.loadFields();
            this.lockUIForAudited(false, false);
        } else {
            SysUtil.abort();
        }
    }

    protected void lockUIForAudited(boolean enableEdit, boolean lockUI) {
        if (lockUI) {
            this.lockUIForViewStatus();
        }
        this.actionEdit.setEnabled(enableEdit);
        this.actionSave.setEnabled(false);
        this.actionSubmit.setEnabled(false);
        this.actionRemove.setEnabled(false);
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkHasSaved();
        if (MsgBox.isOk((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.CARD_RES_PATH, (String)"IF_UNAUDIT")))) {
            FaLeaseBalanceBillFactory.getRemoteInstance().unauditBill((IObjectPK)new ObjectUuidPK(this.editData.getId()));
            this.setSaved(true);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.CARD_RES_PATH, (String)"UNAUDIT_SUCCESS"));
            this.editData = (FaLeaseBalanceEntryInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(this.editData.getId()), this.getSelectors());
            this.setDataObject((IObjectValue)this.editData);
            this.loadFields();
            this.lockUIForAudited(false, false);
        } else {
            SysUtil.abort();
        }
    }

    @Override
    public void actionCheck_actionPerformed(ActionEvent e) throws Exception {
        this.checkHasSaved();
        boolean hasConfirm = false;
        if (this.isModify()) {
            hasConfirm = true;
            if (MsgBox.isOk((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)LES_RES_PATH, (String)"dataModifiedSave")))) {
                this.actionSubmit_actionPerformed(e);
            }
        }
        if (hasConfirm || MsgBox.isOk((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.CARD_RES_PATH, (String)"IF_CHECK")))) {
            FaLeaseBalanceBillFactory.getRemoteInstance().checkBill((IObjectPK)new ObjectUuidPK(this.editData.getId()));
            this.setSaved(true);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.CARD_RES_PATH, (String)"CHECK_SUCCESS"));
            this.editData = (FaLeaseBalanceEntryInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(this.editData.getId()), this.getSelectors());
            this.setDataObject((IObjectValue)this.editData);
            this.loadFields();
            this.lockUIForAudited(false, true);
        } else {
            SysUtil.abort();
        }
    }

    @Override
    public void actionUncheck_actionPerformed(ActionEvent e) throws Exception {
        this.checkHasSaved();
        if (MsgBox.isOk((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.CARD_RES_PATH, (String)"IF_UNCHECK")))) {
            FaLeaseBalanceBillFactory.getRemoteInstance().unCheckBill((IObjectPK)new ObjectUuidPK(this.editData.getId()));
            this.setSaved(true);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.CARD_RES_PATH, (String)"UNCHECK_SUCCESS"));
            this.editData = (FaLeaseBalanceEntryInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(this.editData.getId()), this.getSelectors());
            this.setDataObject((IObjectValue)this.editData);
            this.loadFields();
            this.actionEdit.setEnabled(true);
            this.actionRemove.setEnabled(false);
            this.actionSubmit.setEnabled(false);
            this.lockUIForAudited(true, false);
        } else {
            SysUtil.abort();
        }
    }

    private void checkHasSaved() {
        if (this.editData == null || this.editData.getId() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.CARD_RES_PATH, (String)"SAVE_FIRST"));
        }
    }

    protected boolean isShowAttachmentAction() {
        return false;
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if ("EDIT".equals(this.getOprtState()) || "ADDNEW".equals(this.getOprtState())) {
            if (this.editData != null && this.editData.getId() != null) {
                if (this.editData.getCheckedStatus().getValue() == 2) {
                    this.actionSubmit.setEnabled(false);
                    this.actionEdit.setEnabled(false);
                    this.actionRemove.setEnabled(false);
                } else if (this.editData.isCheckStatus()) {
                    this.actionSubmit.setEnabled(false);
                    this.actionEdit.setEnabled(false);
                    this.actionRemove.setEnabled(false);
                } else {
                    this.actionSubmit.setEnabled(true);
                    this.actionEdit.setEnabled(false);
                    this.actionRemove.setEnabled(true);
                }
            } else {
                this.actionSubmit.setEnabled(true);
                this.actionEdit.setEnabled(false);
                this.actionRemove.setEnabled(false);
            }
        } else if ("VIEW".equals(this.getOprtState())) {
            this.actionSubmit.setEnabled(false);
            this.actionEdit.setEnabled(this.editData == null ? true : !this.editData.isCheckStatus());
            this.actionRemove.setEnabled(false);
        }
        if (this.editData != null && this.editData.getId() != null) {
            if (this.editData.getCheckedStatus().getValue() == 2) {
                this.actionCheck.setEnabled(false);
                this.actionUnAudit.setEnabled(!this.editData.isFiVouchered());
                this.actionAudit.setEnabled(false);
                this.actionUncheck.setEnabled(false);
            } else if (this.editData.isCheckStatus()) {
                this.actionAudit.setEnabled(true);
                this.actionUnAudit.setEnabled(false);
                this.actionCheck.setEnabled(false);
                this.actionUncheck.setEnabled(true);
            } else {
                this.actionAudit.setEnabled(false);
                this.actionUnAudit.setEnabled(false);
                this.actionCheck.setEnabled(true);
                this.actionUncheck.setEnabled(false);
            }
        } else {
            this.actionAudit.setEnabled(false);
            this.actionUnAudit.setEnabled(false);
            this.actionCheck.setEnabled(false);
            this.actionUncheck.setEnabled(false);
        }
        if (this.editData != null && this.editData.getId() != null) {
            this.actionVoucher.setEnabled(this.editData.getCheckedStatus().getValue() == 2 && !this.editData.isFiVouchered());
            this.actionDelVoucher.setEnabled(this.editData.isFiVouchered());
        } else {
            this.actionVoucher.setEnabled(false);
            this.actionDelVoucher.setEnabled(false);
        }
    }

    protected IObjectValue createNewData() {
        try {
            Map uicontext = this.getUIContext();
            CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
            IObjectValue bill = (IObjectValue)uicontext.get("bill");
            java.util.Date beginDate = bill.getUtilDate("beginDate");
            java.util.Date endDate = bill.getUtilDate("endDate");
            java.util.Date today = DateTimeUtils.truncateDate((java.util.Date)new java.util.Date());
            Integer seq = (Integer)uicontext.get("seq");
            FaLeaseBalanceEntryInfo info = new FaLeaseBalanceEntryInfo();
            info.setSeq(seq);
            info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            today = today.before(beginDate) ? beginDate : (today.after(endDate) ? endDate : today);
            PeriodInfo period = FaClientUtils.getCurrentPeriod(company.getId().toString());
            today = today.before(period.getBeginDate()) ? period.getBeginDate() : (today.after(period.getEndDate()) ? period.getEndDate() : today);
            info.setPaymentDate(today);
            info.setPaymentType(LeasePaymentTypeEnum.LEASE_AMOUNT);
            info.setIsPayment(this.isPayment);
            info.setCompany(company);
            boolean existCodingRule = true;
            ICodingRuleManager iCodingRule = CodingRuleManagerFactory.getRemoteInstance();
            existCodingRule = iCodingRule.isExist((IObjectValue)info, company.getId().toString(), "isPayment");
            if (existCodingRule) {
                info.setNumber(iCodingRule.readNumber((IObjectValue)info, company.getId().toString(), "isPayment", ""));
            }
            if (!existCodingRule) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)LES_RES_PATH, (String)"leaseCodingruleNotEnabled"));
                SysUtil.abort();
            }
            info.setBargainNum(bill.getString("bargainNum"));
            info.setLeaseNumber(bill.getString("number"));
            info.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
            info.setPeriod(period);
            info.put("billId", bill.get("id").toString());
            info.put("lastUpdateTime", bill.getTimestamp("lastUpdateTime"));
            return info;
        }
        catch (Exception e) {
            this.handleException(e);
            SysUtil.abort();
            return null;
        }
    }

    protected String getEntryKeyName() {
        return "";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FaLeaseBalanceEntryFactory.getRemoteInstance();
    }

    public String getUITitle() {
        String ui_str = EASResource.getString((String)LES_RES_PATH, (String)"ui");
        return this.isPayment ? MessageFormat.format(ui_str, EASResource.getString((String)LES_RES_PATH, (String)"paymentBill")) : MessageFormat.format(ui_str, EASResource.getString((String)LES_RES_PATH, (String)"gatheringBill"));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.btnCheck.setIcon(EASResource.getIcon((String)"imgTbtn_review"));
        this.btnUncheck.setIcon(EASResource.getIcon((String)"imgTbtn_unreview"));
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        BigDecimal realPayment;
        BigDecimal actualPayment;
        CompanyOrgUnitInfo company;
        PeriodInfo period;
        super.verifyInput(e);
        Map uicontext = this.getUIContext();
        StringBuffer msg = new StringBuffer();
        boolean hasError = false;
        if (this.editData.getNumber() == null) {
            this.appendMsg(msg, this.isPayment ? EASResource.getString((String)LES_RES_PATH, (String)"paymentNumRequired") : EASResource.getString((String)LES_RES_PATH, (String)"receivementNumRequired"));
            hasError = true;
            this.txtNumber.requestFocus();
        }
        if (this.editData.getPaymentDate() == null) {
            this.appendMsg(msg, this.isPayment ? EASResource.getString((String)LES_RES_PATH, (String)"paymentDayRequired") : EASResource.getString((String)LES_RES_PATH, (String)"receivementDayRequired"));
            if (!hasError) {
                hasError = true;
                this.pkPaymentDate.requestFocus();
            }
        }
        IObjectValue bill = (IObjectValue)uicontext.get("bill");
        java.util.Date beginDate = bill.getUtilDate("beginDate");
        java.util.Date endDate = bill.getUtilDate("endDate");
        Date paymentDate = this.pkPaymentDate.getSqlDate();
        if (paymentDate.before(beginDate) || paymentDate.after(endDate)) {
            this.appendMsg(msg, this.isPayment ? EASResource.getString((String)LES_RES_PATH, (String)"paymentDayInZone") : EASResource.getString((String)LES_RES_PATH, (String)"receivementDayInZone"));
            if (!hasError) {
                hasError = true;
                this.pkPaymentDate.requestFocus();
            }
        }
        if (paymentDate.before((period = FaClientUtils.getCurrentPeriod((company = SysContext.getSysContext().getCurrentFIUnit()).getId().toString())).getBeginDate()) || paymentDate.after(period.getEndDate())) {
            this.appendMsg(msg, this.isPayment ? EASResource.getString((String)LES_RES_PATH, (String)"paymentDayInPeriod") : EASResource.getString((String)LES_RES_PATH, (String)"receivementDayInPeriod"));
            if (!hasError) {
                hasError = true;
                this.pkPaymentDate.requestFocus();
            }
        }
        if ((actualPayment = this.txtActualPayment.getBigDecimalValue()) == null || actualPayment.compareTo(new BigDecimal("0")) <= 0) {
            this.appendMsg(msg, this.isPayment ? EASResource.getString((String)LES_RES_PATH, (String)"payMustGT0") : EASResource.getString((String)LES_RES_PATH, (String)"receiveMustGT0"));
            if (!hasError) {
                hasError = true;
                this.txtActualPayment.requestFocus();
            }
        }
        if ((realPayment = this.txtRealPayment.getBigDecimalValue()) == null || realPayment.compareTo(new BigDecimal("0")) < 0) {
            this.appendMsg(msg, this.isPayment ? EASResource.getString((String)LES_RES_PATH, (String)"affirmPayMustGE0") : EASResource.getString((String)LES_RES_PATH, (String)"affirmReceiveMustGE0"));
            if (!hasError) {
                hasError = true;
                this.txtRealPayment.requestFocus();
            }
        }
        if (actualPayment != null && realPayment != null && realPayment.compareTo(actualPayment) > 0) {
            this.appendMsg(msg, this.isPayment ? EASResource.getString((String)LES_RES_PATH, (String)"affirmFeeMustLTPay") : EASResource.getString((String)LES_RES_PATH, (String)"affirmIncomingMustLTReceive"));
            if (!hasError) {
                hasError = true;
                this.txtRealPayment.requestFocus();
            }
        }
        if (this.prmtHandler.getValue() == null) {
            this.appendMsg(msg, EASResource.getString((String)LES_RES_PATH, (String)"handlerRequired"));
            if (!hasError) {
                hasError = true;
                this.prmtHandler.requestFocus();
            }
        }
        if (msg.length() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)msg.toString());
            SysUtil.abort();
        }
        if (this.comboPaymentType.getSelectedIndex() == 0 && this.isPayment) {
            String id = bill.getBOSUuid("id").toString();
            BigDecimal sum = new BigDecimal("0");
            CoreBaseCollection bals = FaLeaseBalanceBillFactory.getRemoteInstance().getCollection("select id,entry.paymentType,entry.actualPayment,entry.isPayment where leaseInBill.id='" + id + "'");
            if (bals.size() > 0) {
                FaLeaseBalanceBillInfo info = (FaLeaseBalanceBillInfo)bals.get(0);
                for (int i = 0; i < info.getEntry().size(); ++i) {
                    FaLeaseBalanceEntryInfo entry = info.getEntry().get(i);
                    if (this.editData.getId() != null && entry.getId().toString().equals(this.editData.getId().toString()) || !entry.isIsPayment() || entry.getPaymentType().getValue() != 0) continue;
                    sum = sum.add(entry.getActualPayment());
                }
            }
            if (sum.add(this.txtActualPayment.getBigDecimalValue()).compareTo(bill.getBigDecimal("hireNaturalAmt")) > 0) {
                this.txtActualPayment.requestFocus();
                MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)LES_RES_PATH, (String)"paymentOverflow"), bill.getBigDecimal("hireNaturalAmt").setScale(this.currencyScale, 4)));
                SysUtil.abort();
            }
        }
    }

    private void appendMsg(StringBuffer msg, String err) {
        if (msg.length() == 0) {
            msg.append(err);
        } else {
            msg.append("," + err);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new String("*"));
        sic.add(new String("company.number"));
        sic.add(new String("CU.number"));
        return sic;
    }

    public IObjectPK runSubmit() throws Exception {
        IObjectPK pk = this.getBizInterface().submit((CoreBaseInfo)this.editData);
        this.setOprtState(OprtState.EDIT);
        return pk;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    protected KDTable getDetailTable() {
        return null;
    }

    private EntityViewInfo getAccountBankEvi(String companyId, String bankId) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("bank.id", (Object)bankId));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        evi.setFilter(filter);
        return evi;
    }

    protected boolean isModifySave() {
        return false;
    }
}

