/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceInEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceInEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceOutEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceOutEntryInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.LocaleUtils;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class FaLeaseUtils {
    private static final Logger logger = Logger.getLogger(FaLeaseUtils.class);
    private static final String RES_PATH = "com.kingdee.eas.fi.fa.manage.FaLeaseResource";
    private static final String year_str_l2 = FaResUtil.getRes((String)"com.kingdee.eas.fi.fa.manage.FaLeaseResource", (String)"year", (Locale)LocaleUtils.getLocale((String)"l2"));
    private static final String year_str_l3 = FaResUtil.getRes((String)"com.kingdee.eas.fi.fa.manage.FaLeaseResource", (String)"year", (Locale)LocaleUtils.getLocale((String)"l3"));
    private static final String BLANK_STR = " ";
    private static final String COMMA_STR = ",";
    private static Locale locale;

    public static String[] getYearZone(Date beginDate, Date endDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(beginDate);
        int startYear = cal.get(1);
        cal.setTime(endDate);
        int endYear = cal.get(1);
        ArrayList<String> result = new ArrayList<String>();
        if (FaLeaseUtils.getCurrentLocale().toString().equals("l1")) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy");
            for (int i = 0; i <= endYear - startYear; ++i) {
                cal.set(1, startYear + i);
                result.add(dateFormat.format(cal.getTime()));
            }
        } else {
            String year_format = EASResource.getString((String)RES_PATH, (String)"year_format");
            for (int i = 0; i <= endYear - startYear; ++i) {
                result.add(MessageFormat.format(year_format, new Integer(startYear + i).toString()));
            }
        }
        return result.toArray(new String[0]);
    }

    public static String[] getSeasonZone(Date beginDate, Date endDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(beginDate);
        int beginMonth = cal.get(2) + 1;
        int beginYear = cal.get(1);
        cal.setTime(endDate);
        int endMonth = cal.get(2) + 1;
        int endYear = cal.get(1);
        int month = beginMonth;
        int year = beginYear;
        ArrayList<String> result = new ArrayList<String>();
        while (year <= endYear && (year != endYear || month <= endMonth)) {
            result.add(MessageFormat.format(EASResource.getString((String)RES_PATH, (String)"season_format"), new Integer(year).toString(), month <= 3 ? "1" : (month <= 6 ? "2" : (month <= 9 ? "3" : "4"))));
            if ((month += 3) <= 12) continue;
            month = 1;
            ++year;
        }
        String lastSeason = MessageFormat.format(EASResource.getString((String)RES_PATH, (String)"season_format"), new Integer(endYear).toString(), endMonth <= 3 ? "1" : (endMonth <= 6 ? "2" : (endMonth <= 9 ? "3" : "4")));
        if (!result.contains(lastSeason)) {
            result.add(lastSeason);
        }
        return result.toArray(new String[0]);
    }

    public static String[] getMonthZone(Date beginDate, Date endDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(beginDate);
        int beginMonth = cal.get(2) + 1;
        int beginYear = cal.get(1);
        cal.setTime(endDate);
        int endMonth = cal.get(2) + 1;
        int endYear = cal.get(1);
        int month = beginMonth;
        int year = beginYear;
        ArrayList<String> result = new ArrayList<String>();
        if (FaLeaseUtils.getCurrentLocale().toString().equals("l1")) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("MM/yyyy");
            while (year <= endYear && (year != endYear || month <= endMonth)) {
                cal.set(1, year);
                cal.set(2, month);
                result.add(dateFormat.format(cal.getTime()));
                if (++month <= 12) continue;
                month = 1;
                ++year;
            }
        } else {
            String month_format = EASResource.getString((String)RES_PATH, (String)"month_format");
            while (year <= endYear && (year != endYear || month <= endMonth)) {
                result.add(MessageFormat.format(month_format, new Integer(year).toString(), new Integer(month).toString()));
                if (++month <= 12) continue;
                month = 1;
                ++year;
            }
        }
        return result.toArray(new String[0]);
    }

    public static String[] getDayZone(Date beginDate, Date endDate) {
        int[] days = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        int[] days_of_special = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        Calendar cal = Calendar.getInstance();
        cal.setTime(beginDate);
        int beginMonth = cal.get(2) + 1;
        int beginYear = cal.get(1);
        int beginDay = cal.get(5);
        cal.setTime(endDate);
        int endMonth = cal.get(2) + 1;
        int endYear = cal.get(1);
        int endDay = cal.get(5);
        int month = beginMonth;
        int year = beginYear;
        int day = beginDay;
        ArrayList<String> result = new ArrayList<String>();
        if (FaLeaseUtils.getCurrentLocale().toString().equals("l1")) {
            boolean isSpecialYear = year % 400 == 0 || year % 400 != 0 && year % 4 == 0;
            SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
            while (!(year > endYear || year == endYear && month > endMonth || year == endYear && month == endMonth && day > endDay)) {
                int maxDayOfMonth = isSpecialYear ? days_of_special[month - 1] : days[month - 1];
                cal.set(1, year);
                cal.set(2, month);
                cal.set(5, day);
                result.add(dateFormat.format(cal.getTime()));
                if (++day > maxDayOfMonth) {
                    day = 1;
                    ++month;
                }
                if (month <= 12) continue;
                month = 1;
                isSpecialYear = ++year % 400 == 0 || year % 400 != 0 && year % 4 == 0;
            }
        } else {
            boolean isSpecialYear = year % 400 == 0 || year % 400 != 0 && year % 4 == 0;
            String day_format = EASResource.getString((String)RES_PATH, (String)"day_format");
            while (!(year > endYear || year == endYear && month > endMonth || year == endYear && month == endMonth && day > endDay)) {
                int maxDayOfMonth = isSpecialYear ? days_of_special[month - 1] : days[month - 1];
                result.add(MessageFormat.format(day_format, new Integer(year).toString(), new Integer(month).toString(), new Integer(day).toString()));
                if (++day > maxDayOfMonth) {
                    day = 1;
                    ++month;
                }
                if (month <= 12) continue;
                month = 1;
                isSpecialYear = ++year % 400 == 0 || year % 400 != 0 && year % 4 == 0;
            }
        }
        return result.toArray(new String[0]);
    }

    private static Locale getCurrentLocale() {
        return SysContext.getSysContext().getLocale();
    }

    public static int[] parseYearZone(String measureUnitText) {
        int year;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy");
        Calendar cal = Calendar.getInstance(LocaleUtils.getLocale((String)"l1"));
        try {
            Date date = dateFormat.parse(measureUnitText);
            cal.setTime(date);
            year = cal.get(1);
        }
        catch (ParseException e) {
            logger.error((Object)e);
            year = measureUnitText.contains(year_str_l2) ? Integer.parseInt(measureUnitText.substring(0, measureUnitText.indexOf(year_str_l2))) : Integer.parseInt(measureUnitText.substring(0, measureUnitText.indexOf(year_str_l3)));
        }
        return new int[]{year};
    }

    public static int[] parseSeasonZone(String measureUnitText) {
        int season;
        int year;
        if (measureUnitText.contains(year_str_l2)) {
            String season_str = FaResUtil.getRes((String)RES_PATH, (String)"season", (Locale)LocaleUtils.getLocale((String)"l2"));
            year = Integer.parseInt(measureUnitText.substring(0, measureUnitText.indexOf(year_str_l2)));
            season = Integer.parseInt(measureUnitText.substring(measureUnitText.indexOf(year_str_l2) + 1, measureUnitText.indexOf(season_str)));
        } else if (measureUnitText.contains(year_str_l3)) {
            String season_str = FaResUtil.getRes((String)RES_PATH, (String)"season", (Locale)LocaleUtils.getLocale((String)"l3"));
            year = Integer.parseInt(measureUnitText.substring(0, measureUnitText.indexOf(year_str_l3)));
            season = Integer.parseInt(measureUnitText.substring(measureUnitText.indexOf(year_str_l3) + 1, measureUnitText.indexOf(season_str)));
        } else {
            year = Integer.parseInt(measureUnitText.substring(measureUnitText.indexOf(COMMA_STR) + 1));
            season = Integer.parseInt(measureUnitText.substring(measureUnitText.indexOf(BLANK_STR) + 1, measureUnitText.indexOf(COMMA_STR)));
        }
        return new int[]{year, season};
    }

    public static int[] parseMonthZone(String measureUnitText) {
        int month;
        int year;
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/yyyy");
        Calendar cal = Calendar.getInstance(LocaleUtils.getLocale((String)"l1"));
        try {
            Date date = dateFormat.parse(measureUnitText);
            cal.setTime(date);
            year = cal.get(1);
            month = cal.get(2);
        }
        catch (ParseException e) {
            logger.error((Object)e);
            if (measureUnitText.contains(year_str_l2)) {
                String month_str = FaResUtil.getRes((String)RES_PATH, (String)"month", (Locale)LocaleUtils.getLocale((String)"l2"));
                year = Integer.parseInt(measureUnitText.substring(0, measureUnitText.indexOf(year_str_l2)));
                month = Integer.parseInt(measureUnitText.substring(measureUnitText.indexOf(year_str_l2) + 1, measureUnitText.indexOf(month_str)));
            }
            String month_str = FaResUtil.getRes((String)RES_PATH, (String)"month", (Locale)LocaleUtils.getLocale((String)"l3"));
            year = Integer.parseInt(measureUnitText.substring(0, measureUnitText.indexOf(year_str_l3)));
            month = Integer.parseInt(measureUnitText.substring(measureUnitText.indexOf(year_str_l3) + 1, measureUnitText.indexOf(month_str)));
        }
        return new int[]{year, month};
    }

    public static int[] parseDayZone(String measureUnitText) {
        int day;
        int month;
        int year;
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
        Calendar cal = Calendar.getInstance(LocaleUtils.getLocale((String)"l1"));
        try {
            Date date = dateFormat.parse(measureUnitText);
            cal.setTime(date);
            year = cal.get(1);
            month = cal.get(2);
            day = cal.get(5);
        }
        catch (ParseException e) {
            logger.error((Object)e);
            if (measureUnitText.contains(year_str_l2)) {
                String month_str = FaResUtil.getRes((String)RES_PATH, (String)"month", (Locale)LocaleUtils.getLocale((String)"l2"));
                String day_str = FaResUtil.getRes((String)RES_PATH, (String)"day", (Locale)LocaleUtils.getLocale((String)"l2"));
                year = Integer.parseInt(measureUnitText.substring(0, measureUnitText.indexOf(year_str_l2)));
                month = Integer.parseInt(measureUnitText.substring(measureUnitText.indexOf(year_str_l2) + 1, measureUnitText.indexOf(month_str)));
                day = Integer.parseInt(measureUnitText.substring(measureUnitText.indexOf(month_str) + 1, measureUnitText.indexOf(day_str)));
            }
            String month_str = FaResUtil.getRes((String)RES_PATH, (String)"month", (Locale)LocaleUtils.getLocale((String)"l3"));
            String day_str = FaResUtil.getRes((String)RES_PATH, (String)"day", (Locale)LocaleUtils.getLocale((String)"l3"));
            year = Integer.parseInt(measureUnitText.substring(0, measureUnitText.indexOf(year_str_l3)));
            month = Integer.parseInt(measureUnitText.substring(measureUnitText.indexOf(year_str_l3) + 1, measureUnitText.indexOf(month_str)));
            day = Integer.parseInt(measureUnitText.substring(measureUnitText.indexOf(month_str) + 1, measureUnitText.indexOf(day_str)));
        }
        return new int[]{year, month, day};
    }

    private static String[] formatYearZone(String[] timeZone) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        int[] parseYearResult = FaLeaseUtils.parseYearZone(timeZone[0]);
        cal.set(1, parseYearResult[0]);
        Date beginDate = cal.getTime();
        parseYearResult = FaLeaseUtils.parseYearZone(timeZone[timeZone.length - 1]);
        cal.set(1, parseYearResult[0]);
        Date endDate = cal.getTime();
        return FaLeaseUtils.getYearZone(beginDate, endDate);
    }

    private static String[] formatSeaonZone(String[] timeZone) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        int[] parseSeasonResult = FaLeaseUtils.parseSeasonZone(timeZone[0]);
        cal.set(1, parseSeasonResult[0]);
        cal.set(2, parseSeasonResult[1] <= 1 ? 2 : (parseSeasonResult[1] <= 2 ? 5 : (parseSeasonResult[1] <= 3 ? 9 : 11)));
        Date beginDate = cal.getTime();
        parseSeasonResult = FaLeaseUtils.parseSeasonZone(timeZone[timeZone.length - 1]);
        cal.set(1, parseSeasonResult[0]);
        cal.set(2, parseSeasonResult[1] <= 1 ? 2 : (parseSeasonResult[1] <= 2 ? 5 : (parseSeasonResult[1] <= 3 ? 9 : 11)));
        Date endDate = cal.getTime();
        return FaLeaseUtils.getSeasonZone(beginDate, endDate);
    }

    private static String[] formatMonthZone(String[] timeZone) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        int[] parseMonthResult = FaLeaseUtils.parseMonthZone(timeZone[0]);
        cal.set(1, parseMonthResult[0]);
        cal.set(2, parseMonthResult[1] - 1);
        Date beginDate = cal.getTime();
        parseMonthResult = FaLeaseUtils.parseMonthZone(timeZone[timeZone.length - 1]);
        cal.set(1, parseMonthResult[0]);
        cal.set(2, parseMonthResult[1] - 1);
        Date endDate = cal.getTime();
        return FaLeaseUtils.getMonthZone(beginDate, endDate);
    }

    private static String[] formatDayZone(String[] timeZone) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        int[] parseDayResult = FaLeaseUtils.parseDayZone(timeZone[0]);
        cal.set(1, parseDayResult[0]);
        cal.set(2, parseDayResult[1] - 1);
        cal.set(5, parseDayResult[2]);
        Date beginDate = cal.getTime();
        parseDayResult = FaLeaseUtils.parseDayZone(timeZone[timeZone.length - 1]);
        cal.set(1, parseDayResult[0]);
        cal.set(2, parseDayResult[1] - 1);
        cal.set(5, parseDayResult[2]);
        Date endDate = cal.getTime();
        return FaLeaseUtils.getDayZone(beginDate, endDate);
    }

    public static String[] formatTimeZone(int payMode, String[] timeZone) {
        if (timeZone == null || timeZone.length == 0) {
            return timeZone;
        }
        String[] formatResult = null;
        switch (payMode) {
            case 0: {
                formatResult = FaLeaseUtils.formatYearZone(timeZone);
                break;
            }
            case 1: {
                formatResult = FaLeaseUtils.formatSeaonZone(timeZone);
                break;
            }
            case 2: {
                formatResult = FaLeaseUtils.formatMonthZone(timeZone);
                break;
            }
            case 3: {
                formatResult = FaLeaseUtils.formatDayZone(timeZone);
                break;
            }
        }
        return formatResult;
    }

    public static FaLeaseBalanceInEntryCollection resortBalanceIn(FaLeaseBalanceInEntryCollection balanceEntry) {
        Object[] cardArray = balanceEntry.toArray();
        Arrays.sort(cardArray, new Comparator(){

            public int compare(Object _p1, Object _p2) {
                FaLeaseBalanceInEntryInfo p1 = (FaLeaseBalanceInEntryInfo)_p1;
                FaLeaseBalanceInEntryInfo p2 = (FaLeaseBalanceInEntryInfo)_p2;
                return p1.getSeq() - p2.getSeq();
            }
        });
        FaLeaseBalanceInEntryCollection result = new FaLeaseBalanceInEntryCollection();
        for (int i = 0; i < cardArray.length; ++i) {
            result.add((FaLeaseBalanceInEntryInfo)cardArray[i]);
        }
        return result;
    }

    public static FaLeaseBalanceOutEntryCollection resortBalanceOut(FaLeaseBalanceOutEntryCollection balanceEntry) {
        Object[] cardArray = balanceEntry.toArray();
        Arrays.sort(cardArray, new Comparator(){

            public int compare(Object _p1, Object _p2) {
                FaLeaseBalanceOutEntryInfo p1 = (FaLeaseBalanceOutEntryInfo)_p1;
                FaLeaseBalanceOutEntryInfo p2 = (FaLeaseBalanceOutEntryInfo)_p2;
                return p1.getSeq() - p2.getSeq();
            }
        });
        FaLeaseBalanceOutEntryCollection result = new FaLeaseBalanceOutEntryCollection();
        for (int i = 0; i < cardArray.length; ++i) {
            result.add((FaLeaseBalanceOutEntryInfo)cardArray[i]);
        }
        return result;
    }

    public static FaLeaseBalanceEntryCollection resortBalance(FaLeaseBalanceEntryCollection entries) {
        Object[] cardArray = entries.toArray();
        Arrays.sort(cardArray, new Comparator(){

            public int compare(Object _p1, Object _p2) {
                FaLeaseBalanceEntryInfo p1 = (FaLeaseBalanceEntryInfo)_p1;
                FaLeaseBalanceEntryInfo p2 = (FaLeaseBalanceEntryInfo)_p2;
                return p1.getSeq() - p2.getSeq();
            }
        });
        FaLeaseBalanceEntryCollection result = new FaLeaseBalanceEntryCollection();
        for (int i = 0; i < cardArray.length; ++i) {
            result.add((FaLeaseBalanceEntryInfo)cardArray[i]);
        }
        return result;
    }
}

