/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.ctrl.extendcontrols.ext.CommonF7KDTableListener;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.client.PersonF7Filter;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaMaintainQueryDialogUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class FaMaintainQueryDialogUI
extends AbstractFaMaintainQueryDialogUI {
    private static final Logger logger = CoreUIObject.getLogger(FaMaintainQueryDialogUI.class);
    static String COMPANYID = "company.id";
    static String NUMBER = "number";
    static String MAINTAINBEGINDATE = "maintainBeginDate";
    static String MAINTAINENDDATE = "maintainEndDate";
    static String MAINTENANCEMANID = "maintenanceMan.id";
    static String MAINTAINADDRESS = "maintainAddress";
    static String FABIZCARDID = "maintainEntry.faBizCard.id";
    static String FACURCARDID = "maintainEntry.faCurCard.id";
    static String CHECKEDSTATUS = "checkedStatus";
    protected CommonF7KDTableListener myCommonF7KDTableListener = this.createCommonF7KDTableListener();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.initControl();
        this.initF7();
    }

    protected void initF7() throws Exception {
        HashMap map = new HashMap();
        HashMap hmParam = this.gethmParam();
        boolean isRange = "true".equals(hmParam.get("FA_040").toString());
        PersonPromptBox personPromptBox = FaClientUtils.getRangePersonF7(isRange, map, (IUIObject)this);
        this.prmpMaintenanceMan.setSelector((KDPromptSelector)personPromptBox);
        this.prmpMaintenanceMan.setFilterInfoProducer((IFilterInfoProducer)new PersonF7Filter(map));
        this.prmpMaintenanceMan.setHasCUDefaultFilter(false);
        EntityViewInfo myevi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        myevi.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString()));
        fic.add(new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentOrgUnit().getId().toString()));
        filter.setMaskString("#0 and #1");
        this.prmpMaintenanceCard.setEntityViewInfo(myevi);
        this.prmpMaintenanceCard.setQueryInfo("com.kingdee.eas.fi.fa.manage.FaCurCardForMaintainQuery");
        this.prmpMaintenanceCard.setDisplayFormat("$assetName$");
        this.prmpMaintenanceCard.setEditFormat("$number$");
        this.prmpMaintenanceCard.setCommitFormat("$number$");
        this.prmpMaintenanceCard.addCommonF7KDTableListener(this.myCommonF7KDTableListener);
    }

    protected void initControl() throws Exception {
        this.rdoAll.setSelected(true);
        this.clear();
    }

    protected CommonF7KDTableListener createCommonF7KDTableListener() {
        return new CommonF7KDTableListener(){

            public void onTableStructureCreated(final KDTable table) {
                table.addKDTDataFillListener(new KDTDataFillListener(){

                    public void afterDataFill(KDTDataRequestEvent e) {
                        try {
                            table.getColumn("assetAmt").getStyleAttributes().setNumberFormat(FaClientUtils.getFormatPatternForColumn(FaMaintainQueryDialogUI.this.getAmtPrecision()));
                        }
                        catch (Exception e1) {
                            logger.error((Object)e1);
                        }
                    }
                });
            }
        };
    }

    protected HashMap gethmParam() {
        HashMap hmParam = null;
        try {
            hmParam = FaManageUtils.getFAParameter(SysContext.getSysContext().getCurrentFIUnit().getId());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return hmParam;
    }

    protected int getAmtPrecision() throws Exception {
        return Integer.parseInt(this.gethmParam().get("FA_008").toString());
    }

    public FilterInfo getFilterInfo() {
        FilterItemCollection filterItems = this.filterInfo.getFilterItems();
        filterItems.clear();
        StringBuffer sbFormula = new StringBuffer();
        int i = 0;
        filterItems.add(new FilterItemInfo(COMPANYID, (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
        sbFormula.append("#" + i++);
        if (!StringUtils.isEmpty((String)this.txtMaintainNumber.getText())) {
            filterItems.add(new FilterItemInfo(NUMBER, (Object)this.txtMaintainNumber.getText()));
            sbFormula.append(" and #" + i++);
        }
        if (this.pkMaintainBeginDate.getValue() != null) {
            filterItems.add(new FilterItemInfo(MAINTAINBEGINDATE, (Object)DateTimeUtils.truncateDate((Date)((Date)this.pkMaintainBeginDate.getValue())), CompareType.GREATER_EQUALS));
            sbFormula.append(" and #" + i++);
        }
        if (this.pkMaintainEndDate.getValue() != null) {
            filterItems.add(new FilterItemInfo(MAINTAINENDDATE, (Object)DateTimeUtils.truncateDate((Date)((Date)this.pkMaintainEndDate.getValue())), CompareType.LESS_EQUALS));
            sbFormula.append(" and #" + i++);
        }
        if (this.prmpMaintenanceMan.getData() != null) {
            filterItems.add(new FilterItemInfo(MAINTENANCEMANID, (Object)((PersonInfo)this.prmpMaintenanceMan.getData()).getId()));
            sbFormula.append(" and #" + i++);
        }
        if (!StringUtils.isEmpty((String)this.txtMaintenanceAddress.getText())) {
            filterItems.add(new FilterItemInfo(MAINTAINADDRESS, (Object)this.txtMaintenanceAddress.getText()));
            sbFormula.append(" and #" + i++);
        }
        if (this.prmpMaintenanceCard.getData() != null) {
            filterItems.add(new FilterItemInfo(FACURCARDID, (Object)((FaCurCardInfo)this.prmpMaintenanceCard.getData()).getId().toString()));
            sbFormula.append(" and #" + i++);
        }
        if (this.rdoNoAuditing.isSelected()) {
            filterItems.add(new FilterItemInfo(CHECKEDSTATUS, (Object)new Integer(1)));
            sbFormula.append(" and #" + i++);
        } else if (this.rdoAuditing.isSelected()) {
            filterItems.add(new FilterItemInfo(CHECKEDSTATUS, (Object)new Integer(2)));
            sbFormula.append(" and #" + i++);
        }
        this.filterInfo.setMaskString(sbFormula.toString());
        return this.filterInfo;
    }

    public void clear() {
        this.txtMaintainNumber.setText(null);
        this.pkMaintainBeginDate.setValue(null);
        this.pkMaintainEndDate.setValue(null);
        this.prmpMaintenanceMan.setData(null);
        this.txtMaintenanceAddress.setText(null);
        this.prmpMaintenanceCard.setData(null);
        this.rdoAll.setSelected(true);
    }

    @Override
    protected void rdoNoAuditing_actionPerformed(ActionEvent e) throws Exception {
        if (this.rdoNoAuditing.isSelected()) {
            this.rdoAuditing.setSelected(false);
            this.rdoAll.setSelected(false);
        }
    }

    @Override
    protected void rdoAuditing_actionPerformed(ActionEvent e) throws Exception {
        if (this.rdoAuditing.isSelected()) {
            this.rdoNoAuditing.setSelected(false);
            this.rdoAll.setSelected(false);
        }
    }

    @Override
    protected void rdoAll_actionPerformed(ActionEvent e) throws Exception {
        if (this.rdoAll.isSelected()) {
            this.rdoAuditing.setSelected(false);
            this.rdoNoAuditing.setSelected(false);
        }
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        try {
            this.clear();
            FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter().getFilterItems();
            if (currentFilterItemCollection == null || currentFilterItemCollection.size() == 0) {
                return;
            }
            int currentFilterItemCollectionSize = currentFilterItemCollection.size();
            for (int i = 0; i < currentFilterItemCollectionSize; ++i) {
                SelectorItemCollection sic;
                ObjectStringPK pk;
                String number;
                FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
                if (filterItemInfo.getPropertyName().equals("number")) {
                    number = filterItemInfo.getCompareValue().toString();
                    this.txtMaintainNumber.setText(number);
                }
                if (filterItemInfo.getPropertyName().equals("maintainBeginDate") && filterItemInfo.getCompareType().getName().equals(CompareType.GREATER_EQUALS.getName())) {
                    Object startDate = filterItemInfo.getCompareValue();
                    this.pkMaintainBeginDate.setValue(startDate);
                }
                if (filterItemInfo.getPropertyName().equals("maintainEndDate") && filterItemInfo.getCompareType().getName().equals(CompareType.LESS_EQUALS.getName())) {
                    Object endDate = filterItemInfo.getCompareValue();
                    this.pkMaintainEndDate.setValue(endDate);
                }
                if (filterItemInfo.getPropertyName().equals("maintenanceMan.id")) {
                    String maintenanceManId = filterItemInfo.getCompareValue().toString();
                    pk = new ObjectStringPK();
                    sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("number"));
                    sic.add(new SelectorItemInfo("name"));
                    sic.add(new SelectorItemInfo("isLeaf"));
                    pk.setKeyValue("id", (Object)maintenanceManId);
                    this.prmpMaintenanceMan.setData((Object)PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)pk, sic));
                }
                if (filterItemInfo.getPropertyName().equals("maintainAddress")) {
                    number = filterItemInfo.getCompareValue().toString();
                    this.txtMaintenanceAddress.setText(number);
                }
                if (filterItemInfo.getPropertyName().equals("maintainEntry.faCurCard.id")) {
                    String curcardId = filterItemInfo.getCompareValue().toString();
                    pk = new ObjectStringPK();
                    sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("number"));
                    sic.add(new SelectorItemInfo("assetName"));
                    sic.add(new SelectorItemInfo("isLeaf"));
                    pk.setKeyValue("id", (Object)curcardId);
                    this.prmpMaintenanceCard.setData((Object)FaCurCardFactory.getRemoteInstance().getBillBaseInfo((IObjectPK)pk, sic));
                }
                if (!filterItemInfo.getPropertyName().equals("checkedStatus")) continue;
                Object object = filterItemInfo.getCompareValue();
                Integer status = (Integer)object;
                if (status.compareTo(new Integer(1)) == 0) {
                    this.rdoNoAuditing.setSelected(true);
                    continue;
                }
                if (status.compareTo(new Integer(2)) == 0) {
                    this.rdoAuditing.setSelected(true);
                    continue;
                }
                if (status.compareTo(new Integer(3)) != 0) continue;
                this.rdoAll.setSelected(true);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }
}

