/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.FaBasicException;
import com.kingdee.eas.fi.fa.basedata.FaCatFactory;
import com.kingdee.eas.fi.fa.basedata.FaCatInfo;
import com.kingdee.eas.fi.fa.basedata.client.FaCatPromptBox;
import com.kingdee.eas.fi.fa.basedata.client.FaDisplyFormatter;
import com.kingdee.eas.fi.fa.basedata.client.FaEditFormatter;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaMatagFilterUI;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;

public class FaMatagFilterUI
extends AbstractFaMatagFilterUI {
    public FaMatagFilterUI() throws Exception {
        this.initControl();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void initControl() {
        this.billDateFrom.setValue((Object)new Date());
        this.billDateTo.setValue((Object)new Date());
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        FilterItemInfo companyFilterItemInfo = new FilterItemInfo("company.id", (Object)aCompanyOrgUnitInfo.getId().toString());
        filterInfo.getFilterItems().add(companyFilterItemInfo);
        viewInfo.setFilter(filterInfo);
        FaCatPromptBox aFaCatPromptBox = new FaCatPromptBox((CoreUIObject)this);
        this.faCatag.setSelector((KDPromptSelector)aFaCatPromptBox);
        this.faCatag.setDisplayFormatter((IFormatter)new FaDisplyFormatter());
        this.faCatag.setEditFormatter((IFormatter)new FaEditFormatter());
        this.faCatag.setEditable(true);
        this.faCatag.setCommitFormat("$number$");
        this.faCatag.setQueryInfo("com.kingdee.eas.fi.fa.basedata.FaCatQuery");
        this.faCatag.setEntityViewInfo(viewInfo);
        this.billDateFrom.setValue(null);
        this.billDateTo.setValue(null);
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.clear();
        if (entityViewInfo == null || entityViewInfo.getFilter() == null) {
            return;
        }
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter().getFilterItems();
        if (currentFilterItemCollection == null || currentFilterItemCollection.size() == 0) {
            return;
        }
        int currentFilterItemCollectionSize = currentFilterItemCollection.size();
        for (int i = 0; i < currentFilterItemCollectionSize; ++i) {
            String number;
            FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
            if (filterItemInfo.getPropertyName().equals("assetCat.id") || filterItemInfo.getPropertyName().equals("faMortagBillEntry.faCurCard.assetCat.id")) {
                String assetCatId = filterItemInfo.getCompareValue().toString();
                ObjectStringPK pk = new ObjectStringPK();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("isLeaf"));
                pk.setKeyValue("id", (Object)assetCatId);
                try {
                    this.faCatag.setData((Object)FaCatFactory.getRemoteInstance().getFaCatInfo((IObjectPK)pk, sic));
                }
                catch (FaBasicException e) {
                    this.handUIException(e);
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            }
            if (filterItemInfo.getPropertyName().equals("faCurCard.number") && filterItemInfo.getCompareType().getName().equals(CompareType.GREATER_EQUALS.getName())) {
                number = filterItemInfo.getCompareValue().toString();
                this.FaNumberFrom.setText(number);
            }
            if (filterItemInfo.getPropertyName().equals("faCurCard.number") && filterItemInfo.getCompareType().getName().equals(CompareType.LESS_EQUALS.getName())) {
                number = filterItemInfo.getCompareValue().toString();
                this.FaNumberTo.setText(number);
            }
            if (filterItemInfo.getPropertyName().equals("signatureDate") && filterItemInfo.getCompareType().getName().equals(CompareType.GREATER_EQUALS.getName())) {
                Object startDate = filterItemInfo.getCompareValue();
                this.billDateFrom.setValue(startDate);
            }
            if (filterItemInfo.getPropertyName().equals("signatureDate") && filterItemInfo.getCompareType().getName().equals(CompareType.LESS.getName())) {
                Object endDate = filterItemInfo.getCompareValue();
                this.billDateTo.setValue(endDate);
            }
            if (filterItemInfo.getPropertyName().equals("mortagageAmount") && filterItemInfo.getCompareType().getName().equals(CompareType.GREATER_EQUALS.getName())) {
                number = filterItemInfo.getCompareValue().toString();
                this.billAmountFrom.setText(number);
            }
            if (filterItemInfo.getPropertyName().equals("mortagageAmount") && filterItemInfo.getCompareType().getName().equals(CompareType.LESS_EQUALS.getName())) {
                number = filterItemInfo.getCompareValue().toString();
                this.billAmountTo.setText(number);
            }
            if (filterItemInfo.getPropertyName().equals("bargainNum") && filterItemInfo.getCompareType().getName().equals(CompareType.EQUALS.getName())) {
                number = filterItemInfo.getCompareValue().toString();
                this.contactNumber.setText(number);
            }
            if (filterItemInfo.getPropertyName().equals("mortagageCompany") && filterItemInfo.getCompareType().getName().equals(CompareType.EQUALS.getName())) {
                number = filterItemInfo.getCompareValue().toString();
                this.MatagCompany.setText(number);
            }
            if (!filterItemInfo.getPropertyName().equals("number") || !filterItemInfo.getCompareType().getName().equals(CompareType.EQUALS.getName())) continue;
            number = filterItemInfo.getCompareValue().toString();
            this.billCode.setText(number);
        }
    }

    public FilterInfo getFilterInfo() {
        FilterItemInfo templateFilterItemInfo;
        StringBuffer sbFormula = new StringBuffer();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        int i = 0;
        if (this.billCode.getText() != null && this.billCode.getText().trim().length() > 0) {
            templateFilterItemInfo = new FilterItemInfo("number", (Object)this.billCode.getText().trim());
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.billAmountFrom.getText() != null && this.billAmountFrom.getText().trim().length() > 0) {
            templateFilterItemInfo = new FilterItemInfo("mortagageAmount", (Object)this.billAmountFrom.getText().trim(), CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.billAmountTo.getText() != null && this.billAmountTo.getText().trim().length() > 0) {
            templateFilterItemInfo = new FilterItemInfo("mortagageAmount", (Object)this.billAmountTo.getText().trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.billDateFrom.isEnabled() && this.billDateFrom.getTimestamp() != null) {
            Date date = DateTimeUtils.truncateDate((Date)this.billDateFrom.getTimestamp());
            FilterItemInfo startDate = new FilterItemInfo("signatureDate", (Object)date, CompareType.GREATER_EQUALS);
            items.add(startDate);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.billDateTo.isEnabled() && this.billDateTo.getTimestamp() != null) {
            long date2Ms = DateTimeUtils.truncateDate((Date)((Date)this.billDateTo.getValue())).getTime() + 86400000L - 1L;
            Date date = new Date(date2Ms);
            FilterItemInfo endDate = new FilterItemInfo("signatureDate", (Object)date, CompareType.LESS);
            items.add(endDate);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.MatagCompany.getText() != null && this.MatagCompany.getText().trim().length() > 0) {
            FilterItemInfo templateFilterItemInfo2 = new FilterItemInfo("mortagageCompany", (Object)this.MatagCompany.getText().trim());
            items.add(templateFilterItemInfo2);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.faCatag.getData() != null) {
            FilterItemInfo templateFilterItemInfo3 = new FilterItemInfo("faMortagBillEntry.faCurCard.assetCat.id", (Object)((FaCatInfo)this.faCatag.getData()).getId().toString());
            items.add(templateFilterItemInfo3);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.FaNumberFrom.getText() != null && this.FaNumberFrom.getText().trim().length() > 0) {
            FilterItemInfo templateFilterItemInfo4 = new FilterItemInfo("faCurCard.number", (Object)this.FaNumberFrom.getText().trim(), CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo4);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.FaNumberTo.getText() != null && this.FaNumberTo.getText().trim().length() > 0) {
            FilterItemInfo templateFilterItemInfo5 = new FilterItemInfo("faCurCard.number", (Object)this.FaNumberTo.getText().trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo5);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.contactNumber.getText() != null && this.contactNumber.getText().trim().length() > 0) {
            FilterItemInfo templateFilterItemInfo6 = new FilterItemInfo("bargainNum", (Object)this.contactNumber.getText().trim());
            items.add(templateFilterItemInfo6);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (sbFormula.toString().length() != 0) {
            filter.setMaskString(sbFormula.toString());
        }
        return filter;
    }

    public void clear() {
        this.billCode.setText(null);
        this.billAmountFrom.setText(null);
        this.billAmountTo.setText(null);
        this.billDateFrom.setValue(null);
        this.billDateTo.setValue(null);
        this.MatagCompany.setText(null);
        this.faCatag.setData(null);
        this.FaNumberFrom.setText(null);
        this.FaNumberTo.setText(null);
        this.contactNumber.setText(null);
    }
}

