/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.client.PersonF7Filter;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.def.FaDefPropertyValueFactory;
import com.kingdee.eas.fi.fa.def.FaDefPropertyValueInfo;
import com.kingdee.eas.fi.fa.def.meta.FaDefEntityManager;
import com.kingdee.eas.fi.fa.manage.FaCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaMortagBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaMortagBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaMortagBillFactory;
import com.kingdee.eas.fi.fa.manage.FaMortagBillInfo;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaMortagBillEditUI;
import com.kingdee.eas.fi.fa.manage.client.CommonQueryWithResultDialog;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.manage.client.FaPrintHelper;
import com.kingdee.eas.fi.fa.manage.client.FaScanBarCodesEditUI;
import com.kingdee.eas.framework.BillBaseCollection;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JTextField;

public class FaMortagBillEditUI
extends AbstractFaMortagBillEditUI {
    private ICellEditor oldCellEditor = null;
    private KDBizPromptBox prmtKeeper = new KDBizPromptBox();
    private Object focusOwner = null;
    private boolean initDefPropertyBind = false;
    CurrencyInfo currencyInfo;
    private ObjectValueRender nameRender = new ObjectValueRender();
    private int srcCurrencyPrecision = 2;
    private int nativeCurrencyPrecision = 2;
    private int rateScale = 2;
    private boolean comBoxFuctionFireNeedPrecess = false;

    public FaMortagBillEditUI() throws Exception {
        this.nameRender.setFormat((IDataFormat)new BizDataFormat("$name$"));
    }

    @Override
    protected boolean isShowCardFilter() {
        return false;
    }

    private void addNewFaCards() throws Exception {
        FaCurCardCollection faInfoList = this.ChooseFaCardForMortag();
        if (faInfoList != null) {
            for (int j = 0; j < faInfoList.size(); ++j) {
                FaCurCardInfo cardInfo = faInfoList.get(j);
                String id = cardInfo.getId().toString();
                cardInfo = this.getCurCardInfo(id);
                if (this.checkFaCurCardInDetailTable(id)) continue;
                FaMortagBillEntryInfo entryLine = new FaMortagBillEntryInfo();
                entryLine.setFaBizCard(FaClientUtils.CurCard2BizCard(cardInfo));
                entryLine.setFaCurCard(cardInfo);
                entryLine.setQuantity(cardInfo.getAssetAmt());
                BigDecimal neatValue = cardInfo.getNeatValue();
                if (neatValue.floatValue() == 0.0f) continue;
                BigDecimal MortagageNumber = cardInfo.getAssetAmt();
                if (neatValue != null && MortagageNumber != null) {
                    entryLine.setShowAm(neatValue);
                    entryLine.setEvaluateAmt(neatValue);
                }
                IRow detialRow = null;
                detialRow = this.detailTable.addRow();
                this.loadLineFields(this.detailTable, detialRow, (IObjectValue)entryLine);
            }
        }
    }

    @Override
    public void actionScanPitch_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = null;
        IUIFactory factory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        uiWindow = factory.create(FaScanBarCodesEditUI.class.getName(), (Map)uiContext, null, null);
        uiWindow.show();
        uiWindow.getUIObject().getUIContext().get("keys");
        Set keys = new HashSet();
        keys = (Set)uiWindow.getUIObject().getUIContext().get("keys");
        if (keys == null) {
            return;
        }
        if (keys.size() <= 0) {
            return;
        }
        List<Object> al = Arrays.asList(keys.toArray());
        this.addNewFaCards(al);
        this.updateMortagCash();
        this.calcTotalAmount();
    }

    private void addNewFaCards(List faInfoList) throws Exception {
        if (faInfoList != null) {
            for (int j = 0; j < faInfoList.size(); ++j) {
                FaCurCardInfo cardInfo = this.getCurCardInfo(faInfoList.get(j).toString());
                String id = cardInfo.getId().toString();
                if (this.checkFaCurCardInDetailTable(id)) continue;
                FaMortagBillEntryInfo entryLine = new FaMortagBillEntryInfo();
                entryLine.setFaBizCard(FaClientUtils.CurCard2BizCard(cardInfo));
                entryLine.setFaCurCard(cardInfo);
                entryLine.setQuantity(cardInfo.getAssetAmt());
                BigDecimal neatValue = cardInfo.getNeatValue();
                if (neatValue.floatValue() == 0.0f) continue;
                BigDecimal MortagageNumber = cardInfo.getAssetAmt();
                if (neatValue != null && MortagageNumber != null) {
                    entryLine.setShowAm(neatValue);
                    entryLine.setEvaluateAmt(neatValue);
                }
                IRow detialRow = null;
                detialRow = this.detailTable.addRow();
                this.loadLineFields(this.detailTable, detialRow, (IObjectValue)entryLine);
            }
        }
    }

    protected FaCurCardInfo getCurCardInfo(String curCardID) {
        FaCurCardInfo curCardInfo = new FaCurCardInfo();
        try {
            curCardInfo = FaCurCardFactory.getRemoteInstance().getFaCurCardInfo((IObjectPK)new ObjectUuidPK(curCardID), this.getCurCardSelectors());
            this.fullFaDefPropertyValueInfo(curCardInfo);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return curCardInfo;
    }

    private void fullFaDefPropertyValueInfo(FaCardInfo card) throws EASBizException, BOSException {
        FaDefPropertyValueInfo p = card.getPropertyValue();
        if (p != null) {
            p = FaDefPropertyValueFactory.getRemoteInstance().getFaDefPropertyValueInfo((IObjectPK)new ObjectUuidPK(p.getId()));
            card.setPropertyValue(p);
        }
    }

    public SelectorItemCollection getCurCardSelectors() {
        return AbstractFaMortagBillEditUI.getCurCardSelectors(0);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setExchangeRatePrecision(Integer.toString(this.rateScale));
        if (this.editData.getSignatureDate() != null) {
            this.editData.setSignatureDate(new java.sql.Date(this.editData.getSignatureDate().getYear(), this.editData.getSignatureDate().getMonth(), this.editData.getSignatureDate().getDate()));
        }
        if (this.editData.getBeginDate() != null) {
            this.editData.setBeginDate(new java.sql.Date(this.editData.getBeginDate().getYear(), this.editData.getBeginDate().getMonth(), this.editData.getBeginDate().getDate()));
        }
        if (this.editData.getEndDate() != null) {
            this.editData.setEndDate(new java.sql.Date(this.editData.getEndDate().getYear(), this.editData.getEndDate().getMonth(), this.editData.getEndDate().getDate()));
        }
        this.editData.setCreditRate(this.editData.getCreditRate().setScale(this.rateScale));
    }

    @Override
    public void loadFields() {
        this.bindDefProperty();
        this.comBoxFuctionFireNeedPrecess = false;
        super.loadFields();
        this.initCurrencyComboxSelect();
        if (this.editData != null && this.editData.getNativeCurrencyPrecision() != null && this.editData.getNativeCurrencyPrecision().trim().length() > 0) {
            this.nativeCurrencyPrecision = Integer.parseInt(this.editData.getNativeCurrencyPrecision());
        }
        if (this.editData != null && this.editData.getExchangeRatePrecision() != null && this.editData.getExchangeRatePrecision().trim().length() > 0) {
            this.rateScale = Integer.parseInt(this.editData.getExchangeRatePrecision());
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.updateEditableState();
        this.comBoxFuctionFireNeedPrecess = true;
        this.calcTotalAmount();
    }

    private void bindDefProperty() {
        if (!this.initDefPropertyBind) {
            try {
                FaDefEntityManager.bindDefProperty((String)"faMortagBillEntry.faBizCard.", (KDTable)this.detailTable, (String)this.resHelper.getString("detailTable.formatXml"), (DataBinder)this.dataBinder);
                this.initDefPropertyBind = true;
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.focusOwner != null && this.focusOwner instanceof KDFormattedTextField) {
            KDFormattedTextField owner = (KDFormattedTextField)this.focusOwner;
            if (this.txtCreditRate.getName().equals(owner.getName())) {
                if (this.txtCreditRate.getBigDecimalValue() != null && this.txtCreditRate.getBigDecimalValue().compareTo(new BigDecimal("0")) < 0) {
                    MsgBox.showInfo((String)FaResUtil.getRes((String)"inputMustGreater"));
                    this.txtCreditRate.setValue(null);
                }
                this.updateCreditNaturalAmt();
            } else if (this.txtCreditOriginAmt.getName().equals(owner.getName())) {
                if (this.txtCreditOriginAmt.getBigDecimalValue() != null && this.txtCreditOriginAmt.getBigDecimalValue().compareTo(new BigDecimal("0")) < 0) {
                    MsgBox.showInfo((String)FaResUtil.getRes((String)"inputMustGreater"));
                    this.txtCreditOriginAmt.setValue(null);
                }
                this.updateCreditNaturalAmt();
            } else if (this.txtMortagageAmount.getName().equals(owner.getName())) {
                if (this.txtMortagageAmount.getBigDecimalValue() != null && this.txtMortagageAmount.getBigDecimalValue().compareTo(new BigDecimal("0")) < 0) {
                    MsgBox.showInfo((String)FaResUtil.getRes((String)"inputMustGreater"));
                    this.txtMortagageAmount.setValue(null);
                }
                this.updateMortagRate();
            }
        }
        super.actionSave_actionPerformed(e);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.focusOwner != null && this.focusOwner instanceof KDFormattedTextField) {
            boolean canPass = true;
            KDFormattedTextField owner = (KDFormattedTextField)this.focusOwner;
            if (this.txtCreditRate.getName().equals(owner.getName())) {
                if (this.txtCreditRate.getBigDecimalValue() != null && this.txtCreditRate.getBigDecimalValue().compareTo(new BigDecimal("0")) < 0) {
                    MsgBox.showInfo((String)FaResUtil.getRes((String)"inputMustGreater"));
                    this.txtCreditRate.setValue(null);
                    canPass = false;
                }
                this.updateCreditNaturalAmt();
                if (!canPass) {
                    return;
                }
            } else if (this.txtCreditOriginAmt.getName().equals(owner.getName())) {
                if (this.txtCreditOriginAmt.getBigDecimalValue() != null && this.txtCreditOriginAmt.getBigDecimalValue().compareTo(new BigDecimal("0")) < 0) {
                    MsgBox.showInfo((String)FaResUtil.getRes((String)"inputMustGreater"));
                    this.txtCreditOriginAmt.setValue(null);
                    canPass = false;
                }
                this.updateCreditNaturalAmt();
                if (!canPass) {
                    return;
                }
            } else if (this.txtMortagageAmount.getName().equals(owner.getName())) {
                if (this.txtMortagageAmount.getBigDecimalValue() != null && this.txtMortagageAmount.getBigDecimalValue().compareTo(new BigDecimal("0")) < 0) {
                    MsgBox.showInfo((String)FaResUtil.getRes((String)"inputMustGreater"));
                    this.txtMortagageAmount.setValue(null);
                    canPass = false;
                }
                this.updateMortagRate();
                if (!canPass) {
                    return;
                }
            }
        }
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    public void onLoad() throws Exception {
        this.comBoxFuctionFireNeedPrecess = false;
        this.initCurrencyComBox();
        super.onLoad();
        this.initContorlersViewPage();
        this.initPageContorlersActivity();
        this.initCurrencyComboxSelect();
        this.updatePrecision();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.updateEditableState();
        this.comBoxFuctionFireNeedPrecess = true;
        this.btnScanPitch.setIcon(EASResource.getIcon((String)"imgTbtn_applycondition"));
        this.actionScanPitch.setEnabled(false);
        this.actionScanPitch.setVisible(false);
        boolean isUseBarCode = Boolean.valueOf(String.valueOf(this.getFaParameter().get("FA_043")));
        if (isUseBarCode) {
            this.actionScanPitch.setEnabled(true);
            this.actionScanPitch.setVisible(true);
        }
        if (this.detailTable.getColumn("barCode") != null) {
            this.detailTable.getColumn("barCode").getStyleAttributes().setHided(!isUseBarCode);
        }
        if (this.editData != null && this.editData.getCheckedStatus() != null) {
            if (this.editData.getCheckedStatus().getValue() == 2 || OprtState.VIEW.equals(this.getOprtState())) {
                this.actionScanPitch.setEnabled(false);
            } else {
                this.actionScanPitch.setEnabled(true);
            }
        }
        this.bindDefProperty();
    }

    @Override
    protected HashMap getFaParameter() throws Exception {
        if (this.faParameter == null) {
            this.faParameter = FaClientUtils.getFAParameter(this.getCurrentCompany().getId());
        }
        return this.faParameter;
    }

    private CompanyOrgUnitInfo getCurrentCompany() throws Exception {
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        String companyId = null;
        companyId = FaClientUtils.isFromLink((CoreUIObject)this) ? (String)this.getUIContext().get("COMPANY_ID") : SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("accountPeriodType.id"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("reportCurrency.id"));
        sic.add(new SelectorItemInfo("reportCurrency.number"));
        sic.add(new SelectorItemInfo("reportCurrency.name"));
        sic.add(new SelectorItemInfo("baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("reportExchangeTable.id"));
        companyOrgUnitInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyId)), sic);
        return companyOrgUnitInfo;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("faMortagBillEntry.faCurCard.lastUpdateTime"));
        sic.add(new SelectorItemInfo("faMortagBillEntry.faCurCard.id"));
        sic.add(new SelectorItemInfo("faMortagBillEntry.faCurCard.bizStatus"));
        sic.add(new SelectorItemInfo("faMortagBillEntry.faBizCard.id"));
        sic.add(new SelectorItemInfo("faMortagBillEntry.faBizCard.neatValue"));
        sic.add(new SelectorItemInfo("creditCurrency.id"));
        sic.add(new SelectorItemInfo("creditCurrency.*"));
        sic.add(new SelectorItemInfo("exchangeRatePrecision"));
        sic.add(new SelectorItemInfo("nativeCurrencyPrecision"));
        sic.add(new SelectorItemInfo("faMortagBillEntry.faBizCard.lastUpdateTime"));
        sic.add(new SelectorItemInfo("effectedStatus"));
        sic.add("faMortagBillEntry.faBizCard.propertyValue.*");
        return sic;
    }

    @Override
    protected IObjectValue createNewDetailData(KDTable table) {
        return new FaMortagBillEntryInfo();
    }

    @Override
    protected IObjectValue createNewData() {
        FaMortagBillInfo info = new FaMortagBillInfo();
        info.setCompany(this.currCompany);
        Date currentDate = new Date();
        info.setBeginDate(new java.sql.Date(currentDate.getYear(), currentDate.getMonth(), currentDate.getDate()));
        info.setEndDate(new java.sql.Date(currentDate.getYear(), currentDate.getMonth(), currentDate.getDate()));
        info.setSignatureDate(new java.sql.Date(currentDate.getYear(), currentDate.getMonth(), currentDate.getDate()));
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setNativeCurrencyPrecision(Integer.toString(this.getCurrencyScale()));
        info.setCreditRate(ZERO);
        info.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        try {
            CurrencyInfo currency = this.getBaseCurrency();
            info.setCreditCurrency(currency);
            info.setCreditRate(new BigDecimal("1"));
        }
        catch (Exception e) {
            this.handleException(e);
            SysUtil.abort();
        }
        this.nativeCurrencyPrecision = this.getCurrencyScale();
        return info;
    }

    @Override
    protected KDTable getDetailTable() {
        return this.detailTable;
    }

    private void updateEditableState() {
        if (this.getOprtState() == "VIEW") {
            this.detailTable.getColumn("fa_remark").getStyleAttributes().setLocked(true);
            this.detailTable.getColumn("fa_safeBillNumber").getStyleAttributes().setLocked(true);
            this.detailTable.getColumn("fa_has_safe").getStyleAttributes().setLocked(true);
            this.detailTable.getColumn("fa_keepCost").getStyleAttributes().setLocked(true);
            this.detailTable.getColumn("fa_keeper").getStyleAttributes().setLocked(true);
            this.detailTable.getColumn("fa_mfa_valueOnAbout").getStyleAttributes().setLocked(true);
            this.detailTable.getColumn("fa_m_number").getStyleAttributes().setLocked(true);
            this.conmCurrency.setEnabled(false);
            this.pkBeginDate.setEnabled(false);
            this.pkEndDate.setEnabled(false);
            this.pkSignatureDate.setEnabled(false);
            this.pkBeginDate.setEditable(false);
            this.pkEndDate.setEditable(false);
            this.pkSignatureDate.setEditable(false);
        } else {
            this.detailTable.getColumn("fa_remark").getStyleAttributes().setLocked(false);
            this.detailTable.getColumn("fa_safeBillNumber").getStyleAttributes().setLocked(false);
            this.detailTable.getColumn("fa_has_safe").getStyleAttributes().setLocked(false);
            this.detailTable.getColumn("fa_keepCost").getStyleAttributes().setLocked(false);
            this.detailTable.getColumn("fa_keeper").getStyleAttributes().setLocked(false);
            this.detailTable.getColumn("fa_mfa_valueOnAbout").getStyleAttributes().setLocked(false);
            this.detailTable.getColumn("fa_m_number").getStyleAttributes().setLocked(false);
            this.conmCurrency.setEnabled(true);
            this.pkBeginDate.setEnabled(true);
            this.pkEndDate.setEnabled(true);
            this.pkSignatureDate.setEnabled(true);
            this.pkBeginDate.setEditable(true);
            this.pkEndDate.setEditable(true);
            this.pkSignatureDate.setEditable(true);
        }
        if (this.editData.getEffectedStatus() == null) {
            this.actionSave.setEnabled(true);
        } else {
            this.actionSave.setEnabled(EffectedStatusEnum.TEMPSTORE.equals((Object)this.editData.getEffectedStatus()) && !"VIEW".equals(this.getOprtState()));
        }
        if (this.editData != null && this.editData.getCheckedStatus() != null) {
            if (this.editData.getCheckedStatus().getValue() == 2 || OprtState.VIEW.equals(this.getOprtState())) {
                this.actionScanPitch.setEnabled(false);
            } else {
                this.actionScanPitch.setEnabled(true);
            }
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return FaMortagBillFactory.getRemoteInstance();
    }

    @Override
    protected void verifyBeforeSubmit(ActionEvent e) throws Exception {
        this.storeFields();
        super.verifyBeforeSubmit(e);
        if (this.txtBargainNum.getStringValue() == null || this.txtBargainNum.getStringValue().trim().length() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)FaResUtil.getRes((String)"htNumberCanNotNull"));
            this.txtBargainNum.requestFocus();
            SysUtil.abort();
        }
        if (this.pkSignatureDate.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)FaResUtil.getRes((String)"dateNumberCanNotNull"));
            this.pkSignatureDate.requestFocus();
            SysUtil.abort();
        }
        if (this.txtMortagageMan.getStringValue() == null || this.txtMortagageMan.getStringValue().trim().length() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)FaResUtil.getRes((String)"dyNumberCanNotNull"));
            this.txtMortagageMan.requestFocus();
            SysUtil.abort();
        }
        if (this.txtMortagageCompany.getStringValue() == null || this.txtMortagageCompany.getStringValue().trim().length() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)FaResUtil.getRes((String)"dyqNumberCanNotNull"));
            this.txtMortagageCompany.requestFocus();
            SysUtil.abort();
        }
        if (this.conmCurrency.getSelectedItem() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)FaResUtil.getRes((String)"currencyNumberCanNotNull"));
            this.conmCurrency.requestFocus();
            SysUtil.abort();
        }
        if (this.txtCreditRate.getStringValue() == null || this.txtCreditRate.getStringValue().trim().length() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)FaResUtil.getRes((String)"rateNumberCanNotNull"));
            this.txtCreditRate.requestFocus();
            SysUtil.abort();
        }
        if (this.txtCreditOriginAmt.getStringValue() == null || this.txtCreditOriginAmt.getStringValue().trim().length() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(FaResUtil.getRes((String)"canNotNull"), FaResUtil.getRes((String)"loanAmount") + "\uff08" + FaResUtil.getRes((String)"originCurrency") + "\uff09"));
            this.txtCreditOriginAmt.requestFocus();
            SysUtil.abort();
        }
        if (this.txtCreditNaturalAmt.getStringValue() == null || this.txtCreditNaturalAmt.getStringValue().trim().length() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(FaResUtil.getRes((String)"canNotNull"), FaResUtil.getRes((String)"loanAmount") + "\uff08" + FaResUtil.getRes((String)"origCurrency") + "\uff09"));
            this.txtCreditNaturalAmt.requestFocus();
            SysUtil.abort();
        }
        if (this.txtMortagageAmount.getStringValue() == null || this.txtMortagageAmount.getStringValue().trim().length() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)FaResUtil.getRes((String)"dyAmountNumberCanNotNull"));
            this.txtMortagageAmount.requestFocus();
            SysUtil.abort();
        }
        if (this.txtMortagageRate.getStringValue() == null || this.txtMortagageRate.getStringValue().trim().length() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)FaResUtil.getRes((String)"dyRateNumberCanNotNull"));
            this.txtMortagageRate.requestFocus();
            SysUtil.abort();
        }
        if (this.pkBeginDate.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)FaResUtil.getRes((String)"dyStartDateNumberCanNotNull"));
            this.pkBeginDate.requestFocus();
            SysUtil.abort();
        }
        if (this.pkEndDate.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)FaResUtil.getRes((String)"dyEndDateNumberCanNotNull"));
            this.pkEndDate.requestFocus();
            SysUtil.abort();
        }
        Date bg = (Date)this.pkBeginDate.getValue();
        Date sd = (Date)this.pkSignatureDate.getValue();
        Date ed = (Date)this.pkEndDate.getValue();
        if (bg.before(sd)) {
            MsgBox.showInfo((Component)((Object)this), (String)FaResUtil.getRes((String)"GrearerMortag"));
            this.pkBeginDate.requestFocus();
            SysUtil.abort();
        }
        if (ed.before(bg)) {
            MsgBox.showInfo((Component)((Object)this), (String)FaResUtil.getRes((String)"mortagStartDateLessEndDate"));
            this.pkBeginDate.requestFocus();
            SysUtil.abort();
        }
        if (this.txtCreditRate.getBigDecimalValue().compareTo(new BigDecimal("0")) <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)(FaResUtil.getRes((String)"rateGreater") + FaResUtil.getRes((String)"gantanhao")));
            this.txtCreditRate.requestFocus();
            SysUtil.abort();
        }
        if (this.txtCreditOriginAmt.getBigDecimalValue().compareTo(new BigDecimal("0")) <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)(MessageFormat.format(FaResUtil.getRes((String)"mustGreater"), FaResUtil.getRes((String)"loanAmount") + "\uff08" + FaResUtil.getRes((String)"originCurrency") + "\uff09") + FaResUtil.getRes((String)"gantanhao")));
            this.txtCreditOriginAmt.requestFocus();
            SysUtil.abort();
        }
        if (this.txtMortagageAmount.getBigDecimalValue().compareTo(new BigDecimal("0")) <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)(FaResUtil.getRes((String)"mortagAmount") + FaResUtil.getRes((String)"gantanhao")));
            this.txtMortagageAmount.requestFocus();
            SysUtil.abort();
        }
        if (this.txtMortagageRate.getBigDecimalValue().compareTo(new BigDecimal(0)) <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)(FaResUtil.getRes((String)"mortagRate") + FaResUtil.getRes((String)"gantanhao")));
            this.txtMortagageRate.requestFocus();
            SysUtil.abort();
        }
        int rowCount = this.detailTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            FaMortagBillEntryInfo ifo = (FaMortagBillEntryInfo)this.detailTable.getRow(i).getUserObject();
            if (ifo.getFaCurCard() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)FaResUtil.getRes((String)"entriesAssetNull"));
                SysUtil.abort();
            }
            if (this.detailTable.getRow(i).getCell("fa_m_number").getValue() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)FaResUtil.getRes((String)"entriesAmtNull"));
                SysUtil.abort();
            }
            if (new BigDecimal(this.detailTable.getRow(i).getCell("fa_m_number").getValue().toString()).compareTo(new BigDecimal("0")) <= 0) {
                MsgBox.showInfo((Component)((Object)this), (String)(FaResUtil.getRes((String)"entriesAmtGreater") + FaResUtil.getRes((String)"gantanhao")));
                SysUtil.abort();
            }
            if (this.detailTable.getRow(i).getCell("fa_mfa_valueOnbook").getValue() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)FaResUtil.getRes((String)"entriesValuateNull"));
                SysUtil.abort();
            }
            if (new BigDecimal(this.detailTable.getRow(i).getCell("fa_mfa_valueOnbook").getValue().toString()).compareTo(new BigDecimal("0")) > 0) continue;
            MsgBox.showInfo((Component)((Object)this), (String)(FaResUtil.getRes((String)"entriesValuateGreater") + FaResUtil.getRes((String)"gantanhao")));
            SysUtil.abort();
        }
        if (rowCount == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)FaResUtil.getRes((String)"noEntries1"));
            SysUtil.abort();
        }
    }

    @Override
    protected String getEntryKeyName() {
        return "faMortagBillEntry";
    }

    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        this.addNewFaCards();
        this.updateMortagCash();
        this.calcTotalAmount();
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
        this.updateMortagCash();
        this.calcTotalAmount();
    }

    private FaCurCardCollection ChooseFaCardForMortag() throws Exception {
        CommonQueryWithResultDialog dialog = this.initCardSelectDialog();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("neatValue", (Object)new BigDecimal("0"), CompareType.GREATER));
        dialog.getCardFilterProcessor().setFilterInfo(filter);
        if (dialog.show() || dialog.hasKeyValue()) {
            return dialog.getSelectedCards();
        }
        return null;
    }

    protected void initListener() {
        super.initListener();
        this.txtCreditOriginAmt.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                FaMortagBillEditUI.this.updateCreditNaturalAmt();
            }
        });
        this.conmCurrency.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FaMortagBillEditUI.this.conmCurrency_itemStateChanged(e);
            }
        });
    }

    private boolean checkFaCurCardInDetailTable(String FaCardID) {
        int rowCounts = this.detailTable.getRowCount();
        IRow currentRow = null;
        for (int i = 0; i < rowCounts; ++i) {
            currentRow = this.detailTable.getRow(i);
            FaMortagBillEntryInfo info = (FaMortagBillEntryInfo)currentRow.getUserObject();
            if (!FaCardID.equals(info.getFaCurCard().getId().toString())) continue;
            return true;
        }
        return false;
    }

    private void updateValueOnBook(int row) {
        IRow changeRow = this.detailTable.getRow(row);
        if (changeRow != null) {
            if (changeRow.getCell("fa_m_number").getValue() == null) {
                changeRow.getCell("fa_mfa_valueOnbook").setValue(null);
            } else {
                int scale = this.getCurrencyScale();
                FaMortagBillEntryInfo info = (FaMortagBillEntryInfo)changeRow.getUserObject();
                BigDecimal allMortagageNumber = info.getFaBizCard().getAssetAmt();
                BigDecimal MortagageNumber = new BigDecimal(changeRow.getCell("fa_m_number").getValue().toString());
                BigDecimal valueOnBook = info.getFaBizCard().getNeatValue().multiply(MortagageNumber).divide(allMortagageNumber, scale, 4);
                changeRow.getCell("fa_mfa_valueOnbook").setValue((Object)valueOnBook);
                changeRow.getCell("fa_mfa_valueOnAbout").setValue((Object)valueOnBook);
            }
        }
        this.calcTotalAmount();
    }

    private void updateMortagCash() {
        BigDecimal amt = new BigDecimal("0.000");
        int rowCount = this.detailTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.detailTable.getRow(i);
            if (row.getCell("fa_mfa_valueOnbook").getValue() == null) continue;
            amt = amt.add(new BigDecimal(row.getCell("fa_mfa_valueOnbook").getValue().toString()));
        }
        this.txtMortagageAmount.setValue((Object)amt);
        this.updateMortagRate();
    }

    private void updateCreditNaturalAmt() {
        if (this.txtCreditOriginAmt.getBigDecimalValue() != null && this.txtCreditRate.getBigDecimalValue() != null) {
            BigDecimal srcAmt = this.txtCreditOriginAmt.getBigDecimalValue();
            BigDecimal eRate = this.txtCreditRate.getBigDecimalValue();
            this.txtCreditNaturalAmt.setValue((Object)eRate.multiply(srcAmt));
        } else {
            this.txtCreditNaturalAmt.setValue(null);
        }
        this.updateMortagRate();
    }

    private void updateMortagRate() {
        BigDecimal NaturalAmt = this.txtCreditNaturalAmt.getBigDecimalValue();
        BigDecimal MortagageAmount = this.txtMortagageAmount.getBigDecimalValue();
        if (NaturalAmt != null && MortagageAmount != null && MortagageAmount.compareTo(new BigDecimal("0")) > 0) {
            this.txtMortagageRate.setValue((Object)NaturalAmt.multiply(new BigDecimal("100.0000")).divide(MortagageAmount, 5));
        } else {
            this.txtMortagageRate.setValue(null);
        }
    }

    private void initChangeTextField(final Object c) {
        if (c instanceof KDFormattedTextField) {
            ((KDFormattedTextField)c).setSelectAllOnFocus(true);
            ((KDFormattedTextField)c).setRemoveingZeroInDispaly(false);
            ((KDFormattedTextField)c).setRemoveingZeroInEdit(false);
            ((KDFormattedTextField)c).addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    FaMortagBillEditUI.this.focusOwner = c;
                }

                @Override
                public void focusLost(FocusEvent e) {
                    FaMortagBillEditUI.this.focusOwner = null;
                }
            });
        }
        if (c instanceof KDTextField) {
            ((KDTextField)c).addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    ((KDTextField)c).selectAll();
                    FaMortagBillEditUI.this.focusOwner = c;
                }

                @Override
                public void focusLost(FocusEvent e) {
                    FaMortagBillEditUI.this.focusOwner = null;
                }
            });
        }
    }

    private void initCurrencyComBox() {
        try {
            CurrencyCollection currencyCollection = FaClientUtils.setCurrencyCombo(this.getCurrentCompany(), this.oprtState);
            Vector<CurrencyInfo> tempCbDatas = new Vector<CurrencyInfo>();
            int size = currencyCollection.size();
            for (int i = 0; i < size; ++i) {
                tempCbDatas.addElement(currencyCollection.get(i));
            }
            this.conmCurrency.setModel(new DefaultComboBoxModel(tempCbDatas));
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void conmCurrency_itemStateChanged(ItemEvent e) {
        if (!this.comBoxFuctionFireNeedPrecess) {
            return;
        }
        try {
            if (e.getStateChange() != 1) {
                return;
            }
            if (this.currCompany == null || e == null || e.getItem() == null) {
                this.txtCreditRate.setValue((Object)new BigDecimal("0"));
                this.rateScale = 2;
                this.updateCreditNaturalAmt();
                return;
            }
            CurrencyInfo srcCyInfo = (CurrencyInfo)e.getItem();
            if (srcCyInfo != null) {
                this.srcCurrencyPrecision = srcCyInfo.getPrecision();
            }
            CurrencyInfo desCyInfo = this.currCompany.getBaseCurrency();
            if (srcCyInfo == null || srcCyInfo.getId() == null || srcCyInfo.getId().toString().trim().length() == 0 || desCyInfo == null || desCyInfo.getId() == null || desCyInfo.getId().toString().trim().length() == 0) {
                this.txtCreditRate.setValue((Object)new BigDecimal("0"));
                this.rateScale = 2;
                this.updateCreditNaturalAmt();
                this.updatePrecision();
                return;
            }
            if (srcCyInfo.getId().toString().trim().equals(desCyInfo.getId().toString().trim())) {
                this.txtCreditRate.setValue((Object)new BigDecimal(1.0));
                this.rateScale = 2;
                this.updateCreditNaturalAmt();
                this.updatePrecision();
                return;
            }
            ExchangeTableInfo exchangeTableInfo = this.currCompany.getBaseExchangeTable();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("baseExchangeTable.*"));
            ObjectUuidPK pk = new ObjectUuidPK(this.getCurCompany().getId());
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)pk, sic);
            exchangeTableInfo = companyInfo.getBaseExchangeTable();
            if (exchangeTableInfo == null) {
                this.txtCreditRate.setValue((Object)new BigDecimal("0.000"));
                this.rateScale = 2;
                this.updateCreditNaturalAmt();
                this.updatePrecision();
                return;
            }
            IExchangeRate iExchangeRate = ExchangeRateFactory.getRemoteInstance();
            ExchangeRateInfo exchangeRateInfo = null;
            exchangeRateInfo = iExchangeRate.getExchangeRate((IObjectPK)new ObjectUuidPK(exchangeTableInfo.getId()), (IObjectPK)new ObjectUuidPK(srcCyInfo.getId()), (IObjectPK)new ObjectUuidPK(desCyInfo.getId()), null);
            if (exchangeRateInfo != null) {
                BigDecimal rate = exchangeRateInfo.getConvertRate();
                this.rateScale = exchangeRateInfo.getPrecision();
                this.txtCreditRate.setValue((Object)rate);
                this.updateCreditNaturalAmt();
            } else {
                this.txtCreditRate.setValue((Object)new BigDecimal("0.000"));
                this.rateScale = 2;
                this.updateCreditNaturalAmt();
            }
            this.updatePrecision();
        }
        catch (Exception exc) {
            this.handUIException(exc);
        }
    }

    private void initContorlersViewPage() throws Exception {
        this.txtNumber.setRequired(true);
        this.txtBargainNum.setRequired(true);
        this.pkSignatureDate.setRequired(true);
        this.txtMortagageMan.setRequired(true);
        this.txtMortagageCompany.setRequired(true);
        this.conmCurrency.setRequired(true);
        this.txtCreditRate.setRequired(true);
        this.txtCreditOriginAmt.setRequired(true);
        this.txtCreditNaturalAmt.setRequired(true);
        this.txtMortagageAmount.setRequired(true);
        this.txtMortagageRate.setRequired(true);
        this.pkBeginDate.setRequired(true);
        this.pkEndDate.setRequired(true);
        this.txtCreditRate.setHorizontalAlignment(4);
        this.txtCreditOriginAmt.setHorizontalAlignment(4);
        this.txtCreditNaturalAmt.setHorizontalAlignment(4);
        this.txtMortagageAmount.setHorizontalAlignment(4);
        this.txtMortagageRate.setHorizontalAlignment(4);
        this.prmtSignaturePlace.setEditable(true);
        this.prmtSignaturePlace.setDisplayFormat("$name$");
        this.prmtSignaturePlace.setEditFormat("$number$");
        this.prmtSignaturePlace.setCommitFormat("$number$");
        String[] editableColumn = new String[]{"fa_remark", "fa_safeBillNumber", "fa_has_safe", "fa_keepCost", "fa_keeper", "fa_mfa_valueOnAbout", "fa_m_number"};
        this.setEditableColumn(true, false, editableColumn);
        KDTextField txtFaRemark = new KDTextField();
        txtFaRemark.setMaxLength(80);
        this.getDetailTable().getColumn("fa_remark").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtFaRemark));
        KDTextField txtFaSafeBillNumber = new KDTextField();
        txtFaSafeBillNumber.setMaxLength(80);
        this.getDetailTable().getColumn("fa_safeBillNumber").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtFaSafeBillNumber));
        this.contDetailTable.removeButton((JButton)this.btnInsert);
        this.contDetailTable.removeButton((JButton)this.btnDelete);
        this.contDetailTable.addButton((JButton)this.btnInsert);
        this.contDetailTable.addButton((JButton)this.btnDelete);
        this.btnInsert.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo item = new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        filterInfo.getFilterItems().add(item);
        viewInfo.setFilter(filterInfo);
        this.prmtKeeper.setEntityViewInfo(viewInfo);
        this.prmtKeeper.setEditable(true);
        this.prmtKeeper.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
        this.prmtKeeper.setDisplayFormat("$name$");
        this.prmtKeeper.setEditFormat("$number$");
        this.prmtKeeper.setCommitFormat("$number$");
        this.prmtKeeper.setSelector((KDPromptSelector)new PersonPromptBox());
        HashMap map = new HashMap();
        boolean isRange = "true".equals(this.getFaParameter().get("FA_040").toString());
        PersonPromptBox personPromtBox = FaClientUtils.getRangePersonF7(isRange, map, (IUIObject)this);
        this.prmtKeeper.setSelector((KDPromptSelector)personPromtBox);
        this.prmtKeeper.setFilterInfoProducer((IFilterInfoProducer)new PersonF7Filter(map));
        this.prmtKeeper.setHasCUDefaultFilter(false);
        this.detailTable.getColumn("fa_keeper").setRenderer((IBasicRender)this.nameRender);
        this.oldCellEditor = this.detailTable.getColumn("fa_keeper").getEditor();
        this.detailTable.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                int prevRow = e.getPrevRowIndex();
                int prevCol = e.getPrevColumnIndex();
                if (prevCol == FaMortagBillEditUI.this.detailTable.getColumnIndex("fa_keeper") && FaMortagBillEditUI.this.detailTable.getCell(prevRow, prevCol) != null) {
                    FaMortagBillEditUI.this.detailTable.getCell(prevRow, prevCol).setEditor(FaMortagBillEditUI.this.oldCellEditor);
                }
                int currRow = e.getRowIndex();
                int currCol = e.getColumnIndex();
                if (currCol == FaMortagBillEditUI.this.detailTable.getColumnIndex("fa_keeper")) {
                    FaMortagBillEditUI.this.detailTable.getCell(currRow, currCol).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)FaMortagBillEditUI.this.prmtKeeper));
                }
            }
        });
        KDFormattedTextField textformat = new KDFormattedTextField(1);
        textformat.setPrecision(3);
        this.detailTable.getColumn("fa_m_number").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)textformat));
        this.detailTable.getColumn("fa_mfa_valueOnbook").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)textformat));
        this.detailTable.getColumn("fa_mfa_valueOnAbout").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)textformat));
        this.detailTable.getColumn("fa_keepCost").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)textformat));
    }

    private void initPageContorlersActivity() {
        this.initChangeTextField(this.txtBargainNum);
        this.initChangeTextField(this.txtMortagageMan);
        this.initChangeTextField(this.txtMortagageCompany);
        this.initChangeTextField(this.txtCreditRate);
        this.initChangeTextField(this.txtCreditOriginAmt);
        this.initChangeTextField(this.txtCreditNaturalAmt);
        this.initChangeTextField(this.txtMortagageAmount);
        this.initChangeTextField(this.txtMortagageRate);
        this.initChangeTextField(this.txtCreditNumber);
        this.initChangeTextField(this.txtDescription);
        this.detailTable.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                if (e.getColIndex() == FaMortagBillEditUI.this.detailTable.getColumnIndex("fa_m_number")) {
                    if (FaMortagBillEditUI.this.detailTable.getCell(e.getRowIndex(), e.getColIndex()).getValue() != null && new BigDecimal(FaMortagBillEditUI.this.detailTable.getCell(e.getRowIndex(), e.getColIndex()).getValue().toString()).compareTo(new BigDecimal("0")) < 0) {
                        MsgBox.showInfo((String)FaResUtil.getRes((String)"inputAssetAmtGreater"));
                        FaMortagBillEditUI.this.detailTable.getCell(e.getRowIndex(), e.getColIndex()).setValue(e.getOldValue());
                    }
                    IRow row = FaMortagBillEditUI.this.detailTable.getRow(e.getRowIndex());
                    FaMortagBillEntryInfo info = (FaMortagBillEntryInfo)row.getUserObject();
                    BigDecimal sssetAmt = info.getFaBizCard().getAssetAmt();
                    if (FaMortagBillEditUI.this.detailTable.getCell(e.getRowIndex(), e.getColIndex()).getValue() != null && new BigDecimal(FaMortagBillEditUI.this.detailTable.getCell(e.getRowIndex(), e.getColIndex()).getValue().toString()).compareTo(sssetAmt) > 0) {
                        MsgBox.showWarning((String)FaResUtil.getRes((String)"inputAssetAmtLess"));
                        FaMortagBillEditUI.this.detailTable.getCell(e.getRowIndex(), e.getColIndex()).setValue(e.getOldValue());
                    }
                    FaMortagBillEditUI.this.updateValueOnBook(e.getRowIndex());
                    FaMortagBillEditUI.this.updateMortagCash();
                }
                if (e.getColIndex() == FaMortagBillEditUI.this.detailTable.getColumnIndex("fa_mfa_valueOnAbout") && FaMortagBillEditUI.this.detailTable.getCell(e.getRowIndex(), e.getColIndex()).getValue() != null && new BigDecimal(FaMortagBillEditUI.this.detailTable.getCell(e.getRowIndex(), e.getColIndex()).getValue().toString()).compareTo(new BigDecimal("0")) < 0) {
                    MsgBox.showInfo((String)FaResUtil.getRes((String)"inputGreater"));
                    FaMortagBillEditUI.this.detailTable.getCell(e.getRowIndex(), e.getColIndex()).setValue(null);
                }
                if (e.getColIndex() == FaMortagBillEditUI.this.detailTable.getColumnIndex("fa_keepCost") && FaMortagBillEditUI.this.detailTable.getCell(e.getRowIndex(), e.getColIndex()).getValue() != null && new BigDecimal(FaMortagBillEditUI.this.detailTable.getCell(e.getRowIndex(), e.getColIndex()).getValue().toString()).compareTo(new BigDecimal("0")) < 0) {
                    MsgBox.showInfo((String)FaResUtil.getRes((String)"inputGreater"));
                    FaMortagBillEditUI.this.detailTable.getCell(e.getRowIndex(), e.getColIndex()).setValue(null);
                }
            }
        });
        this.txtCreditOriginAmt.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                if (FaMortagBillEditUI.this.txtCreditOriginAmt.getBigDecimalValue() != null && FaMortagBillEditUI.this.txtCreditOriginAmt.getBigDecimalValue().compareTo(new BigDecimal("0")) < 0) {
                    MsgBox.showInfo((String)FaResUtil.getRes((String)"inputMustGreater"));
                    FaMortagBillEditUI.this.txtCreditOriginAmt.setValue(null);
                }
                FaMortagBillEditUI.this.updateCreditNaturalAmt();
            }
        });
        this.txtCreditRate.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                if (FaMortagBillEditUI.this.txtCreditRate.getBigDecimalValue() != null && FaMortagBillEditUI.this.txtCreditRate.getBigDecimalValue().compareTo(new BigDecimal("0")) < 0) {
                    MsgBox.showInfo((String)FaResUtil.getRes((String)"inputMustGreater"));
                    FaMortagBillEditUI.this.txtCreditRate.setValue(null);
                }
                FaMortagBillEditUI.this.updateCreditNaturalAmt();
            }
        });
        this.txtMortagageAmount.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                if (FaMortagBillEditUI.this.txtMortagageAmount.getBigDecimalValue() != null && FaMortagBillEditUI.this.txtMortagageAmount.getBigDecimalValue().compareTo(new BigDecimal("0")) < 0) {
                    MsgBox.showInfo((String)FaResUtil.getRes((String)"inputMustGreater"));
                    FaMortagBillEditUI.this.txtMortagageAmount.setValue(null);
                }
                FaMortagBillEditUI.this.updateMortagRate();
            }
        });
    }

    private void initCurrencyComboxSelect() {
        if (this.editData == null) {
            return;
        }
        CurrencyInfo info = this.editData.getCreditCurrency();
        if (info != null) {
            this.srcCurrencyPrecision = info.getPrecision();
        }
        if (info != null) {
            int i;
            int items = this.conmCurrency.getItemCount();
            for (i = 0; i < items; ++i) {
                CurrencyInfo infoSelect = (CurrencyInfo)this.conmCurrency.getItemAt(i);
                if (!info.getId().equals((Object)infoSelect.getId())) continue;
                this.comBoxFuctionFireNeedPrecess = false;
                this.conmCurrency.setSelectedIndex(i);
                this.comBoxFuctionFireNeedPrecess = true;
                break;
            }
            if (i > items) {
                this.comBoxFuctionFireNeedPrecess = false;
                this.conmCurrency.setSelectedIndex(-1);
                this.comBoxFuctionFireNeedPrecess = true;
            }
        } else if (this.conmCurrency.getItemCount() > 0) {
            this.comBoxFuctionFireNeedPrecess = false;
            this.conmCurrency.setSelectedIndex(0);
            this.comBoxFuctionFireNeedPrecess = true;
            ItemEvent evtItem = new ItemEvent((ItemSelectable)this.conmCurrency, this.conmCurrency.getSelectedIndex(), this.conmCurrency.getSelectedItem(), 1);
            this.comBoxFuctionFireNeedPrecess = true;
            this.conmCurrency_itemStateChanged(evtItem);
        }
    }

    private void updatePrecision() {
        this.txtCreditOriginAmt.setPrecision(this.srcCurrencyPrecision);
        this.txtCreditRate.setPrecision(this.rateScale);
        this.txtCreditNaturalAmt.setPrecision(this.nativeCurrencyPrecision);
        this.txtMortagageAmount.setPrecision(this.nativeCurrencyPrecision);
        this.txtMortagageRate.setPrecision(2);
        this.txtCreditRate.setRemoveingZeroInDispaly(false);
    }

    @Override
    protected boolean isNeedCodeRule() {
        return true;
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue newData) {
        FaMortagBillInfo aMortagBillInfo = (FaMortagBillInfo)newData;
        String number = this.getRuleNumber(aMortagBillInfo);
        aMortagBillInfo.setNumber(number);
        this.txtNumber.setText(number);
        aMortagBillInfo.setSignatureDate(DateTimeUtils.truncateDate((Date)new Date()));
        aMortagBillInfo.setBeginDate(DateTimeUtils.truncateDate((Date)new Date()));
        aMortagBillInfo.setEndDate(DateTimeUtils.truncateDate((Date)new Date()));
        aMortagBillInfo.setCompany(this.currCompany);
        aMortagBillInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        aMortagBillInfo.setCreateTime(null);
        aMortagBillInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        aMortagBillInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
        aMortagBillInfo.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        aMortagBillInfo.setFiVouchered(false);
        FaMortagBillEntryCollection mortagBillColl = aMortagBillInfo.getFaMortagBillEntry();
        for (int i = 0; i < mortagBillColl.size(); ++i) {
            FaMortagBillEntryInfo aFaMortagBillEntryInfo = mortagBillColl.get(i);
            aFaMortagBillEntryInfo.setId(null);
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(this.getCurCompany().getId().toString());
        super.actionEdit_actionPerformed(e);
        this.updateEditableState();
    }

    @Override
    protected String getPrintPath() {
        return "/FI/FA/FaMortagBill";
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        this.editData.put("assetValueTotal", this.lblAssetValue.getText());
        this.editData.put("neatValueTotal", this.lblNeatValue.getText());
        this.editData.put("accuDeprTotal", this.lblAccuDepr.getText());
        BillBaseCollection billCol = new BillBaseCollection();
        billCol.add((BillBaseInfo)this.editData);
        KDNoteHelper appHlp = new KDNoteHelper();
        KDTable[] tables = new KDTable[]{this.getDetailTable()};
        BOSQueryDelegate data = FaPrintHelper.getPrintManagerForFaMortagBillEditUI((IObjectCollection)billCol, tables);
        appHlp.printPreview(this.getPrintPath(), (Object)data, (Component)((Object)this));
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        this.editData.put("assetValueTotal", this.lblAssetValue.getText());
        this.editData.put("neatValueTotal", this.lblNeatValue.getText());
        this.editData.put("accuDeprTotal", this.lblAccuDepr.getText());
        BillBaseCollection billCol = new BillBaseCollection();
        billCol.add((BillBaseInfo)this.editData);
        KDNoteHelper appHlp = new KDNoteHelper();
        KDTable[] tables = new KDTable[]{this.getDetailTable()};
        BOSQueryDelegate data = FaPrintHelper.getPrintManagerForFaMortagBillEditUI((IObjectCollection)billCol, tables);
        appHlp.print(this.getPrintPath(), (Object)data, (Component)((Object)this));
    }

    private void calcTotalAmount() {
        BigDecimal clrAssetValue = ZERO;
        BigDecimal clrNeatValue = ZERO;
        BigDecimal clrAccuDepr = ZERO;
        int scale = this.getCurrencyScale();
        for (int i = 0; i < this.detailTable.getRowCount(); ++i) {
            IRow row = this.detailTable.getRow(i);
            BigDecimal cellAssetValue = row.getCell("assetValue").getValue() == null ? ZERO : (BigDecimal)row.getCell("assetValue").getValue();
            BigDecimal cellInitEvalValue = row.getCell("initEvalValue").getValue() == null ? ZERO : (BigDecimal)row.getCell("initEvalValue").getValue();
            BigDecimal cellAccuDepr = row.getCell("accuDepr").getValue() == null ? ZERO : (BigDecimal)row.getCell("accuDepr").getValue();
            boolean isEvaledBefore = Boolean.valueOf(row.getCell("isEvaledBefore").getValue().toString());
            boolean calcuByEvaluate = Boolean.valueOf(row.getCell("calcuByEvaluate").getValue().toString());
            isEvaledBefore = isEvaledBefore && calcuByEvaluate;
            BigDecimal assetAmt = new BigDecimal(row.getCell("fa_fa_Number").getValue().toString());
            BigDecimal quantity = new BigDecimal(row.getCell("fa_m_number").getValue() == null ? "0" : row.getCell("fa_m_number").getValue().toString());
            cellInitEvalValue = cellInitEvalValue.multiply(quantity).divide(assetAmt, this.currencyScale, 4);
            cellAssetValue = cellAssetValue.multiply(quantity).divide(assetAmt, scale, 4);
            cellAccuDepr = cellAccuDepr.multiply(quantity).divide(assetAmt, scale, 4);
            clrAssetValue = clrAssetValue.add(cellAssetValue);
            clrNeatValue = clrNeatValue.add(isEvaledBefore ? cellInitEvalValue.subtract(cellAccuDepr) : cellAssetValue.subtract(cellAccuDepr));
            clrAccuDepr = clrAccuDepr.add(cellAccuDepr);
        }
        this.lblAssetValue.setText(FaClientUtils.formatDecimal(clrAssetValue, scale));
        this.lblNeatValue.setText(FaClientUtils.formatDecimal(clrNeatValue, scale));
        this.lblAccuDepr.setText(FaClientUtils.formatDecimal(clrAccuDepr, scale));
    }

    @Override
    protected String[] getFormatColumns() {
        return new String[]{"fa_mfa_valueOnbook", "fa_mfa_valueOnAbout", "fa_keepCost"};
    }

    @Override
    protected String[] getAssetAmtColumns() {
        return new String[]{"fa_m_number", "fa_fa_Number"};
    }

    @Override
    public boolean isBindWorkFlow() {
        return false;
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        boolean isViewState = "VIEW".equals(this.oprtState) || "FINDVIEW".equals(this.oprtState);
        this.actionInsertLine.setEnabled(!isViewState);
        this.actionRemoveLine.setEnabled(!isViewState);
    }

    @Override
    protected void setDefaultValue(IObjectValue dataObject) {
    }

    private CurrencyInfo getBaseCurrency() throws Exception {
        if (this.currencyInfo == null) {
            this.currencyInfo = this.getCurrentCompany().getBaseCurrency();
        }
        return this.currencyInfo;
    }

    @Override
    protected void initCtrlComponent() throws Exception {
        super.initCtrlComponent();
        this.MenuItemAttachment.setVisible(true);
        this.MenuItemAttachment.setEnabled(true);
        this.btnAttachment.setVisible(true);
        this.btnAttachment.setEnabled(true);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        String boID = this.getSelectBOID();
        if (boID == null) {
            return;
        }
        acm.showAttachmentListUIByBoID(boID, (Object)this, true);
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(this.getCurCompany().getId().toString());
        super.actionAddNew_actionPerformed(e);
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(this.getCurCompany().getId().toString());
        super.actionCopy_actionPerformed(e);
    }
}

