/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.access.MetaDataAccessLoader;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.def.meta.FaDefQueryManager;
import com.kingdee.eas.fi.fa.manage.FaBillBaseInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaMortagBillFactory;
import com.kingdee.eas.fi.fa.manage.FaMortagBillInfo;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaMortagBillListUI;
import com.kingdee.eas.fi.fa.manage.client.FACommonProcessor;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.manage.client.FaMatagFilterUI;
import com.kingdee.eas.fi.fa.manage.client.FaMortagBillEditUI;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;

public class FaMortagBillListUI
extends AbstractFaMortagBillListUI {
    CommonQueryDialog commonQuerydialog = null;

    @Override
    protected FaBillBaseInfo getBillInfo() {
        return new FaMortagBillInfo();
    }

    public String getUITitle() {
        return FaResUtil.getRes((String)"mortag");
    }

    public FaMortagBillListUI() throws Exception {
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                FaMortagBillListUI.this.tblMain.getColumn("mortagageRate").getStyleAttributes().setNumberFormat(FaClientUtils.getDecimalFormat(2));
                for (int rowIndex = 0; rowIndex < FaMortagBillListUI.this.tblMain.getBody().size(); ++rowIndex) {
                    IRow row = FaMortagBillListUI.this.tblMain.getRow(rowIndex);
                    int srcCurrencyPresion = Integer.parseInt(row.getCell("srcCurrencyPresion").getValue().toString());
                    int nativeCurrencyPresion = Integer.parseInt(row.getCell("nativeCurrencyPresion").getValue().toString());
                    int exchangeRatePrecision = Integer.parseInt(row.getCell("exchangeRatePrecision").getValue().toString());
                    row.getCell("creditRate").getStyleAttributes().setNumberFormat(FaClientUtils.getDecimalFormat(exchangeRatePrecision));
                    row.getCell("creditOriginAmt").getStyleAttributes().setNumberFormat(FaClientUtils.getDecimalFormat(srcCurrencyPresion));
                    String prefixStr = FaClientUtils.getDecimalFormat(nativeCurrencyPresion);
                    row.getCell("creditNaturalAmt").getStyleAttributes().setNumberFormat(prefixStr);
                    row.getCell("mortagageAmount").getStyleAttributes().setNumberFormat(prefixStr);
                    row.getCell("faMortagBillEntry.keepAmt").getStyleAttributes().setNumberFormat(prefixStr);
                    row.getCell("faMortagBillEntry.showAm").getStyleAttributes().setNumberFormat(prefixStr);
                }
            }
        });
        FaDefQueryManager.addDefProperty((IMetaDataPK)this.mainQueryPK, (String)"faBizCard", (KDTable)this.tblMain, (ResourceBundleHelper)this.resHelper);
    }

    public String getTableFormatXml() {
        return this.tblMain.getFormatXml();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return FaMortagBillFactory.getRemoteInstance();
    }

    @Override
    protected String getEditUIName() {
        return FaMortagBillEditUI.class.getName();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.checkBeforeOnload();
        this.menuItemImportData.setAccelerator(KeyStroke.getKeyStroke("ctrl I"));
        this.menuItemExportData.setAccelerator(KeyStroke.getKeyStroke("ctrl shift E"));
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.allignDecimalColumn(new String[]{"mortagageRate", "creditRate", "creditOriginAmt", "creditNaturalAmt", "mortagageAmount", "faMortagBillEntry.keepAmt", "faMortagBillEntry.showAm"});
        FaClientUtils.fmtDate(this.tblMain, new String[]{"signatureDate", "beginDate", "endDate"});
        FaManageUtils.freezeTable((KDTable)this.tblMain, (int)4);
        this.getMainStatusBar().setPerTitle(FMClientHelper.getSysStatusBarTitle((CoreUI)this));
    }

    private void allignDecimalColumn(String[] columns) {
        for (int i = 0; i < columns.length; ++i) {
            this.tblMain.getColumn(columns[i]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    @Override
    protected boolean isShowCardFilter() {
        return false;
    }

    @Override
    protected String[] getMergeColumns() {
        String[] cols = new String[]{"faMortagBillEntry.id", "number", "bargainNum", "signatureDate", "signaturePlace.name", "mortagageMan", "mortagageCompany", "creditCurrency.name", "creditRate", "creditOriginAmt", "creditNaturalAmt", "mortagageAmount", "mortagageRate", "beginDate", "endDate", "description", "checkedStatus", "creator.name", "auditor.name"};
        return cols;
    }

    @Override
    protected boolean initDefaultFilter() {
        return false;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.commonQuerydialog == null) {
            if (this.mainQuery == null) {
                this.mainQuery = new EntityViewInfo();
            }
            this.commonQuerydialog = super.initCommonQueryDialog();
            this.commonQuerydialog.setWidth(520);
            this.commonQuerydialog.setHeight(320);
            this.commonQuerydialog.setShowFilter(true);
            this.commonQuerydialog.setShowSorter(true);
            try {
                this.commonQuerydialog.addUserPanel((KDPanel)new FaMatagFilterUI());
                FACommonProcessor processor = new FACommonProcessor();
                processor.set("parentDialog", this.commonQuerydialog);
                this.commonQuerydialog.setProcessor((IProcessor)processor);
                MetaDataAccessLoader.Description customQueryLoader = new MetaDataAccessLoader.Description(new String[]{"com.kingdee.eas.fi.fa.def.app.FaDynQueryLoader"});
                customQueryLoader.setParam("fullJoinEntityName", (Object)"faBizCard");
                customQueryLoader.setParam("companyId", (Object)this.getCurCompany().getId().toString());
                this.commonQuerydialog.setCustomQueryLoader(customQueryLoader);
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        }
        return this.commonQuerydialog;
    }

    @Override
    public boolean isBindWorkFlow() {
        return false;
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(this.getCurCompany().getId().toString());
        FaMortagBillInfo info = new FaMortagBillInfo();
        String companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        if (companyId != null && iCodingRuleManager.getCodingRule((IObjectValue)info, companyId) == null) {
            IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            EntityObjectInfo entity = null;
            entity = loader.getEntity(info.getBOSType());
            String name = entity.getAlias();
            if (name == null) {
                name = entity.getName();
            }
            throw new CodingRuleException(CodingRuleException.ERROR_CR_NOTEXIST, (Object[])new String[]{name});
        }
        super.actionAddNew_actionPerformed(e);
    }

    @Override
    protected void initBtnStatus() {
        super.initBtnStatus();
        this.MenuItemAttachment.setVisible(true);
        this.MenuItemAttachment.setEnabled(true);
        this.btnAttachment.setVisible(true);
        this.btnAttachment.setEnabled(true);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(this.getCurCompany().getId().toString());
        if (this.getSelectedIdValues().size() > 0) {
            int selectIdValuesSize = this.getSelectedIdValues().size();
            for (int i = 0; i < selectIdValuesSize; ++i) {
                try {
                    String pk = this.getSelectedIdValues().get(i).toString();
                    this.setOprtState("REMOVE");
                    this.pubFireVOChangeListener(pk);
                    continue;
                }
                catch (Throwable ex) {
                    this.handUIException(ex);
                    this.abort();
                }
            }
        }
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(this.getCurCompany().getId().toString());
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(this.getCurCompany().getId().toString());
        super.actionAudit_actionPerformed(e);
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkAdjustmentPeriod(this.getCurCompany().getId().toString());
        super.actionUnAudit_actionPerformed(e);
    }
}

