/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QueryPanelTypeEnum;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.manage.IFaNRptBaseFacade;
import com.kingdee.eas.fi.fa.manage.client.AbstractFaNRptBaseUI;
import com.kingdee.eas.fi.fa.manage.client.FaNRptBaseFilterUI;
import com.kingdee.eas.fi.fa.manage.client.FaNRptTable;
import com.kingdee.eas.framework.report.RptFilterCollection;
import com.kingdee.eas.framework.report.RptFilterInfo;
import com.kingdee.eas.framework.report.RptFilterUtils;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.image.ImageObserver;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.log4j.Logger;

public abstract class FaNRptBaseUI
extends AbstractFaNRptBaseUI {
    private static final Logger logger = CoreUIObject.getLogger(FaNRptBaseUI.class);
    public static final String UICONTEXT_KEY_JOINQUERY_PARAMS = "FaNRptBaseUI.UICONTEXT_KEY_JOINQUERY_PARAMS";
    public static final DateFormat DF_LOG = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
    protected static final Color WARN_COLOR = new Color(246, 168, 46);
    public static final String RESOURCE = "com.kingdee.eas.fi.gl.GLNResource";
    public static Map<String, String> resourceCache = new HashMap<String, String>();
    private CommonQueryDialog commonQueryDialog;
    private FaNRptBaseFilterUI queryUI;
    protected FaNRptTable dataComponent;
    protected Map<String, Object> queryParams;
    protected int realAsstActColCount;
    private GLRptSysWaitUI sysWaitUI;
    protected boolean showAccountDc = false;
    protected boolean showByDispatchDc = false;
    protected boolean showByAccountDc = false;
    protected boolean isCompanyLevelMode = false;
    protected boolean isAccountLevelMode = false;
    protected boolean isAsstActLevelMode = false;
    protected boolean showCompanyLevel = false;
    protected boolean showAccountLevel = false;
    protected boolean showAsstActLevel = false;
    protected String placeholder = "  ";
    protected int companyTopLevel = 1;
    protected Map<String, Integer> colIndexes = new HashMap<String, Integer>();
    protected int dividerLocation = -1;
    protected IUIWindow searchUiWindow = null;
    protected Locale locate;

    public FaNRptBaseUI() throws Exception {
        this.dataComponent = this.createDataComponent();
        this.btnShowConsole.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
        this.btnClearConsole.setIcon(EASResource.getIcon((String)"imgTbtn_clear"));
        this.scrollPane.setBorder(BorderFactory.createLineBorder(new Color(180, 180, 180)));
        InputMap imEntry = this.getInputMap(2);
        KeyStroke key = KeyStroke.getKeyStroke(67, 3);
        imEntry.put(key, "switchConsole");
        ActionMap entryActionMap = this.getActionMap();
        entryActionMap.put("switchConsole", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FaNRptBaseUI.this.switchConsole();
            }
        });
    }

    public void initLayout() {
        super.initLayout();
        this.splitPane.setBottomComponent(null);
    }

    private void switchConsole() {
        Component c = this.splitPane.getBottomComponent();
        if (c != null) {
            this.dividerLocation = this.splitPane.getDividerLocation();
            this.splitPane.setBottomComponent(null);
        } else {
            this.splitPane.setBottomComponent((Component)this.scrollPane);
            int height = this.splitPane.getHeight() - this.splitPane.getDividerSize() - this.splitPane.getInsets().top - this.splitPane.getInsets().bottom;
            if (this.dividerLocation <= 0 || this.dividerLocation >= height) {
                this.dividerLocation = height - 200;
            }
            if (this.dividerLocation <= 0 || this.dividerLocation >= height) {
                this.dividerLocation = 200;
            }
            this.splitPane.setDividerLocation(this.dividerLocation);
        }
        this.revalidate();
        this.repaint();
    }

    public void showConsole() {
        if (this.splitPane.getBottomComponent() == null) {
            this.switchConsole();
        }
    }

    @Override
    public void actionShowConsole_actionPerformed(ActionEvent e) throws Exception {
        this.switchConsole();
    }

    @Override
    public void actionClearConsole_actionPerformed(ActionEvent e) throws Exception {
        this.txtConsole.setText("");
    }

    public Locale getLocate() {
        if (this.locate == null) {
            this.locate = SysContext.getSysContext().getLocale();
        }
        return this.locate;
    }

    public String getResource(String resName) {
        String key = resName + "_" + this.getLocate();
        if (resourceCache.containsKey(key)) {
            return resourceCache.get(key);
        }
        String name = ResourceBase.getString((String)RESOURCE, (String)resName, (Locale)this.getLocate());
        resourceCache.put(key, name);
        return name;
    }

    protected FaNRptTable createDataComponent() {
        FaNRptTable table = new FaNRptTable();
        table.setName("tblMain");
        return table;
    }

    protected FaNRptTable getTable() {
        return this.dataComponent;
    }

    protected KDTable getTableForCommon() {
        return this.dataComponent instanceof KDTable ? this.dataComponent : null;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.dataComponent.init(this, this.getINRpt(), new QueryAfterHandler(){

            @Override
            public void handle() throws EASBizException, BOSException {
                FaNRptBaseUI.this.afterQuery();
            }
        }, true);
        this.getTable().setMergeHeadMoveable(true);
        Map<String, Object> queryCondition = this.getDefaultQueryCondition();
        if (!this.checkCondition(queryCondition)) {
            this.showQueryDialog();
        } else {
            this.queryParams = queryCondition;
            this.query(this.queryParams);
        }
    }

    protected boolean checkCondition(Map<String, Object> queryCondition) {
        return queryCondition != null;
    }

    protected Map<String, Object> getDefaultQueryCondition() throws Exception {
        Map<String, Object> cond = null;
        cond = (Map<String, Object>)this.getUIContext().get(UICONTEXT_KEY_JOINQUERY_PARAMS);
        if (cond != null) {
            return cond;
        }
        String queryName = this.getQueryName();
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String className = ((Object)((Object)this)).getClass().getName();
        if (this.getCurrCompany() == null) {
            return null;
        }
        String companyId = this.getCurrCompany().getId().toString();
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        if (iQuery.hasDefaultSolution(className, queryName, companyId, userID)) {
            QuerySolutionInfo solutionInfo = iQuery.getDefaultSolution(className, queryName, companyId, userID);
            if (solutionInfo != null) {
                cond = this.getQueryCondByQuerySolution(solutionInfo);
            }
            if (cond == null) {
                cond = this.getSysDefaultQueryCond();
            }
            return cond;
        }
        return null;
    }

    protected Map<String, Object> getSysDefaultQueryCond() {
        return null;
    }

    protected Map<String, Object> getQueryCondByQuerySolution(QuerySolutionInfo solutionInfo) throws Exception {
        Map param = null;
        if (solutionInfo.getSolutionType() == SolutionTypeEnum.CUSTOMER_SOLUTION) {
            QueryPanelCollection queryPanels = solutionInfo.getQueryPanelInfo();
            int size = queryPanels.size();
            for (int i = 0; i < size; ++i) {
                QueryPanelInfo queryPanel;
                if (queryPanels.get(i).getQueryPanelType() != QueryPanelTypeEnum.CUSTOMER_PANEL || (queryPanel = queryPanels.get(i)) == null) continue;
                try {
                    CustomerParams cp = XMLBean.TransStrToCustParams((String)queryPanel.getCustomerParams());
                    Object paramObj = RptParamsUtil.getFromCustomerParams((CustomerParams)cp);
                    Map tparam = null;
                    tparam = paramObj instanceof RptFilterInfo || paramObj instanceof RptFilterCollection || paramObj instanceof RptFilterInfo[] || paramObj instanceof RptFilterCollection[] ? (Map)RptFilterUtils.toObjectFromRptFilterMap((Object)paramObj) : (Map)paramObj;
                    if (param == null) {
                        param = tparam;
                        continue;
                    }
                    param.putAll(tparam);
                    continue;
                }
                catch (Exception ex) {
                    logger.error((Object)"Load default query solution error!", (Throwable)ex);
                }
            }
        }
        return param;
    }

    protected CompanyOrgUnitInfo getCurrCompany() {
        CompanyOrgUnitInfo curCompany = null;
        curCompany = SysContext.getSysContext().getCurrentFIUnit();
        return curCompany;
    }

    protected void showQueryDialog() throws Exception {
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = this.initQueryDialog();
        }
        if (this.commonQueryDialog.show()) {
            this.queryParams = this.queryUI.getQueryParams();
            this.query(this.queryParams);
        } else {
            SysUtil.abort();
        }
    }

    protected CommonQueryDialog initQueryDialog() throws Exception {
        CommonQueryDialog dialog = new CommonQueryDialog();
        dialog.setOwner((Component)this.getUIContext().get("Owner"));
        dialog.setParentUIClassName(((Object)((Object)this)).getClass().getName());
        dialog.setQueryObjectPK((IMetaDataPK)MetaDataPK.create((String)this.getQueryName()));
        dialog.setShowFilter(this.isShowFilter());
        dialog.setShowSorter(this.isShowSorter());
        dialog.setShowToolbar(true);
        dialog.setDisShowRowCount(false);
        this.queryUI = this.getCustQueryPanel();
        this.queryUI.getUIContext().put("Owner", this);
        dialog.addUserPanel((KDPanel)this.queryUI);
        IProcessor processor = this.getQueryFilterProcessor(this.queryUI);
        if (processor != null) {
            dialog.setProcessor(processor);
        }
        dialog.getCommonQueryParam().setDialogName(this.queryUI.getUITitle());
        dialog.setMaxReturnCountVisible(false);
        this.setQueryDialogSize(dialog);
        return dialog;
    }

    protected void setQueryDialogSize(CommonQueryDialog dialog) {
    }

    protected IProcessor getQueryFilterProcessor(FaNRptBaseFilterUI filterUI) {
        return null;
    }

    protected abstract FaNRptBaseFilterUI getCustQueryPanel() throws Exception;

    protected boolean isShowSorter() {
        return false;
    }

    protected boolean isShowFilter() {
        return false;
    }

    protected String getQueryName() {
        return "com.kingdee.eas.fi.fa.manage.NRptEmptyQuery";
    }

    protected void disposeUIWindow() {
        super.disposeUIWindow();
        new Thread(new Runnable(){

            @Override
            public void run() {
                FaNRptBaseUI.this.releaseDataSource();
            }
        }).start();
    }

    protected void releaseDataSource() {
        this.dataComponent.closeQuery();
    }

    protected void afterQuery() {
        this.showDataUILayout();
        this.tableUserSetting();
    }

    protected void tableUserSetting() {
        this.tHelper.setDefaultUserData(null);
        this.tHelper.init();
        this.tHelper.setCanMoveColumn(true);
    }

    protected void showDataUILayout() {
        this.dataPanel.removeAll();
        this.dataPanel.add((Component)((Object)this.dataComponent), (Object)"Center");
        this.revalidate();
        this.setQueryingActionStatus(true);
        this.repaint();
    }

    public abstract IFaNRptBaseFacade getINRpt() throws BOSException;

    public int getColumnWidthByColumnName(String colName) {
        return 100;
    }

    public void initTableColumn(Map<String, Object> queryResult) {
    }

    public void fillDataToTable(List<String> colNames, List<List<String>> data, int startRowIndex) {
    }

    protected String getTotalColumn() {
        return null;
    }

    protected void afterFillTableRow(IRow row, List<String> rowData) {
    }

    protected String getBlankString(int fromLevel, int toLevel) {
        StringBuffer sbBlank = new StringBuffer();
        for (int i = fromLevel; i < toLevel; ++i) {
            sbBlank.append(this.placeholder);
        }
        return sbBlank.toString();
    }

    protected String getResourceName() {
        return "com.kingdee.eas.fi.gl.GLXResource";
    }

    protected void setColumnStyle(IColumn column) {
    }

    protected void query(Map<String, Object> queryParams) throws Exception {
        this.showWaitUI();
        this.dataComponent.query(queryParams);
    }

    protected void showWaitUI() {
        if (this.sysWaitUI == null) {
            this.sysWaitUI = new GLRptSysWaitUI((Component)((Object)this));
            this.sysWaitUI.setBorder(BorderFactory.createLineBorder(new Color(180, 180, 180)));
        }
        this.dataPanel.removeAll();
        this.dataPanel.add((Component)((Object)this.sysWaitUI), (Object)"Center");
        this.revalidate();
        this.setQueryingActionStatus(false);
        this.repaint();
    }

    protected void setQueryingActionStatus(boolean enable) {
        this.actionRefresh.setEnabled(enable);
        this.actionQuery.setEnabled(enable);
    }

    protected void handleError(Exception e) {
        if (e instanceof EASBizException) {
            MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
        } else {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.showQueryDialog();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        if (this.queryParams != null) {
            this.query(this.queryParams);
        }
    }

    public void checkSelected() {
        if (this.getTable().getRowCount() == 0 || this.getTable().getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    protected void initPopMenu(String uiClassName) {
        KDTMenuManager tm = this.getMenuManager(this.getTable());
        if (tm == null) {
            return;
        }
        KDPopupMenu pop = tm.getMenu();
        Component[] menus = pop.getComponents();
        for (int i = 0; i < menus.length; ++i) {
            Component comp = menus[i];
            if (comp.getName().indexOf("Copy") <= 0 && comp.getName().indexOf("Paste") <= 0) continue;
            comp.setVisible(false);
        }
    }

    public void info(String msg) {
        this.log(DF_LOG.format(new Date()) + " " + msg, Color.black);
    }

    public void warn(String msg) {
        this.log(DF_LOG.format(new Date()) + " " + msg, WARN_COLOR);
    }

    public void error(String msg) {
        this.log(DF_LOG.format(new Date()) + " " + msg, Color.red);
    }

    public void error(Throwable t) {
        this.error(FaNRptBaseUI.printStackTrace(t));
    }

    protected synchronized void log(final String msg, final Color color) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimpleAttributeSet attributeSet = new SimpleAttributeSet();
                StyleConstants.setForeground(attributeSet, color);
                Document doc = FaNRptBaseUI.this.txtConsole.getDocument();
                try {
                    doc.insertString(doc.getLength(), msg + "\n", attributeSet);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                FaNRptBaseUI.this.txtConsole.setSelectionStart(doc.getLength());
            }
        });
    }

    public static String printStackTrace(Throwable t) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(stream);
        t.printStackTrace(writer);
        writer.flush();
        String s = stream.toString();
        writer.close();
        return s;
    }

    static class GLRptSysWaitUI
    extends KDPanel {
        private static final long serialVersionUID = 1527228599168677729L;
        private static final Image LOGO = EASResource.getImage((String)"imgPic_wait_coffeecup");
        private static final Color BACKGROUD_COLOER = new Color(226, 226, 221);
        private int image_width;
        private int image_height;
        private Component parent = null;

        public GLRptSysWaitUI(Component owner) {
            this.parent = owner;
            this.loadImage(LOGO, 0);
            this.image_width = LOGO.getWidth((ImageObserver)((Object)this));
            this.image_height = LOGO.getHeight((ImageObserver)((Object)this));
            this.setBackground(BACKGROUD_COLOER);
        }

        private void loadImage(Image image, int ID) {
            if (image != null) {
                MediaTracker tracker = new MediaTracker(this.parent);
                tracker.addImage(image, ID);
                try {
                    tracker.waitForID(ID);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public void paint(Graphics g) {
            g.setColor(UIManager.getColor("Panel.background"));
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
            int x = (this.getWidth() - this.image_width) / 2 - 40;
            if (x < 0) {
                x = 0;
            }
            int y = (this.getHeight() - this.image_height) / 2;
            g.drawImage(LOGO, x, y, this.image_width, this.image_height, (ImageObserver)((Object)this));
            g.setColor(new Color(0, 0, 0));
            g.drawString(EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"482_GLRptSysWaitUI"), x + this.image_width + 10, this.getSize().height / 2);
        }
    }

    protected static interface QueryAfterHandler {
        public void handle() throws EASBizException, BOSException;
    }
}

